# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .part_attachment import PartAttachment
from .ticket_part_author import TicketPartAuthor
from .ticket_reply_part_type import TicketReplyPartType


class TicketReply(UncheckedBaseModel):
    """
    A Ticket Part representing a note, comment, or quick_reply on a ticket
    """

    type: typing.Optional[typing.Literal["ticket_part"]] = pydantic.Field(default=None)
    """
    Always ticket_part
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id representing the part.
    """

    part_type: typing.Optional[TicketReplyPartType] = pydantic.Field(default=None)
    """
    Type of the part
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The message body, which may contain HTML.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the note was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The last time the note was updated.
    """

    author: typing.Optional[TicketPartAuthor] = None
    attachments: typing.Optional[typing.List[PartAttachment]] = pydantic.Field(default=None)
    """
    A list of attachments for the part.
    """

    redacted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the ticket part has been redacted.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
