# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .ticket_type_attribute_data_type import TicketTypeAttributeDataType


class TicketTypeAttribute(UncheckedBaseModel):
    """
    Ticket type attribute, used to define each data field to be captured in a ticket.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    String representing the object's type. Always has the value `ticket_type_attribute`.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id representing the ticket type attribute.
    """

    workspace_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the workspace that the ticket type attribute belongs to.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the ticket type attribute
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the ticket type attribute
    """

    data_type: typing.Optional[TicketTypeAttributeDataType] = pydantic.Field(default=None)
    """
    The type of the data attribute (allowed values: "string list integer decimal boolean datetime files")
    """

    input_options: typing.Optional[typing.Dict[str, typing.Any]] = pydantic.Field(default=None)
    """
    Input options for the attribute
    """

    order: typing.Optional[int] = pydantic.Field(default=None)
    """
    The order of the attribute against other attributes
    """

    required_to_create: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the attribute is required or not for teammates.
    """

    required_to_create_for_contacts: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the attribute is required or not for contacts.
    """

    visible_on_create: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the attribute is visible or not to teammates.
    """

    visible_to_contacts: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the attribute is visible or not to contacts.
    """

    default: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the attribute is built in or not.
    """

    ticket_type_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The id of the ticket type that the attribute belongs to.
    """

    archived: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the ticket type attribute is archived or not.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The date and time the ticket type attribute was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The date and time the ticket type attribute was last updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
