# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class UpdateCompanyRequestBody(UncheckedBaseModel):
    """
    You can update a Company
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the Company
    """

    plan: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the plan you have associated with the company.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of employees in this company.
    """

    website: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL for this company's website. Please note that the value specified here is not validated. Accepts any string.
    """

    industry: typing.Optional[str] = pydantic.Field(default=None)
    """
    The industry that this company operates in.
    """

    custom_attributes: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    A hash of key/value pairs containing any other data about the company you want Intercom to store.
    """

    monthly_spend: typing.Optional[int] = pydantic.Field(default=None)
    """
    How much revenue the company generates for your business. Note that this will truncate floats. i.e. it only allow for whole integers, 155.98 will be truncated to 155. Note that this has an upper limit of 2**31-1 or 2147483647..
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
