# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.data_attribute_list import DataAttributeList
from .raw_client import AsyncRawDataAttributesClient, RawDataAttributesClient
from .types.data_attribute import DataAttribute
from .types.lis_data_attributes_request_model import LisDataAttributesRequestModel

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DataAttributesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDataAttributesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDataAttributesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDataAttributesClient
        """
        return self._raw_client

    def lis_data_attributes(
        self,
        *,
        model: typing.Optional[LisDataAttributesRequestModel] = None,
        include_archived: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DataAttributeList:
        """
        You can fetch a list of all data attributes belonging to a workspace for contacts, companies or conversations.

        Parameters
        ----------
        model : typing.Optional[LisDataAttributesRequestModel]
            Specify the data attribute model to return.

        include_archived : typing.Optional[bool]
            Include archived attributes in the list. By default we return only non archived data attributes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttributeList
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.data_attributes.lis_data_attributes(
            model="contact",
            include_archived=True,
        )
        """
        _response = self._raw_client.lis_data_attributes(
            model=model, include_archived=include_archived, request_options=request_options
        )
        return _response.data

    def create_data_attribute(
        self, *, request: typing.Any, request_options: typing.Optional[RequestOptions] = None
    ) -> DataAttribute:
        """
        You can create a data attributes for a `contact` or a `company`.

        Parameters
        ----------
        request : typing.Any

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttribute
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.data_attributes.create_data_attribute(
            request={"key": "value"},
        )
        """
        _response = self._raw_client.create_data_attribute(request=request, request_options=request_options)
        return _response.data

    def update_data_attribute(
        self, id: int, *, request: typing.Any, request_options: typing.Optional[RequestOptions] = None
    ) -> DataAttribute:
        """

        You can update a data attribute.

        > 🚧 Updating the data type is not possible
        >
        > It is currently a dangerous action to execute changing a data attribute's type via the API. You will need to update the type via the UI instead.

        Parameters
        ----------
        id : int
            The data attribute id

        request : typing.Any

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttribute
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.data_attributes.update_data_attribute(
            id=1,
            request={"key": "value"},
        )
        """
        _response = self._raw_client.update_data_attribute(id, request=request, request_options=request_options)
        return _response.data


class AsyncDataAttributesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDataAttributesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDataAttributesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDataAttributesClient
        """
        return self._raw_client

    async def lis_data_attributes(
        self,
        *,
        model: typing.Optional[LisDataAttributesRequestModel] = None,
        include_archived: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DataAttributeList:
        """
        You can fetch a list of all data attributes belonging to a workspace for contacts, companies or conversations.

        Parameters
        ----------
        model : typing.Optional[LisDataAttributesRequestModel]
            Specify the data attribute model to return.

        include_archived : typing.Optional[bool]
            Include archived attributes in the list. By default we return only non archived data attributes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttributeList
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.data_attributes.lis_data_attributes(
                model="contact",
                include_archived=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.lis_data_attributes(
            model=model, include_archived=include_archived, request_options=request_options
        )
        return _response.data

    async def create_data_attribute(
        self, *, request: typing.Any, request_options: typing.Optional[RequestOptions] = None
    ) -> DataAttribute:
        """
        You can create a data attributes for a `contact` or a `company`.

        Parameters
        ----------
        request : typing.Any

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttribute
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.data_attributes.create_data_attribute(
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_data_attribute(request=request, request_options=request_options)
        return _response.data

    async def update_data_attribute(
        self, id: int, *, request: typing.Any, request_options: typing.Optional[RequestOptions] = None
    ) -> DataAttribute:
        """

        You can update a data attribute.

        > 🚧 Updating the data type is not possible
        >
        > It is currently a dangerous action to execute changing a data attribute's type via the API. You will need to update the type via the UI instead.

        Parameters
        ----------
        id : int
            The data attribute id

        request : typing.Any

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttribute
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.data_attributes.update_data_attribute(
                id=1,
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_data_attribute(id, request=request, request_options=request_options)
        return _response.data
