# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel


class EmailSetting(UncheckedBaseModel):
    """
    Represents a sender email address configuration
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of object
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique email setting identifier
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Full sender email address
    """

    verified: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the email address has been verified
    """

    domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    Domain portion of the email address
    """

    brand_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Associated brand identifier
    """

    forwarding_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether email forwarding is active
    """

    forwarded_email_last_received_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Unix timestamp of last forwarded email received (null if never)
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Unix timestamp of creation
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Unix timestamp of last modification
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
