# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.collection_list import CollectionList
from ..types.deleted_collection_object import DeletedCollectionObject
from ..types.group_translated_content import GroupTranslatedContent
from .raw_client import AsyncRawHelpCenterClient, RawHelpCenterClient
from .types.collection import Collection
from .types.help_center import HelpCenter
from .types.help_center_list import HelpCenterList

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class HelpCenterClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawHelpCenterClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawHelpCenterClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawHelpCenterClient
        """
        return self._raw_client

    def list_all_collections(self, *, request_options: typing.Optional[RequestOptions] = None) -> CollectionList:
        """
        You can fetch a list of all collections by making a GET request to `https://api.intercom.io/help_center/collections`.

        Collections will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated collections first.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionList
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.help_center.list_all_collections()
        """
        _response = self._raw_client.list_all_collections(request_options=request_options)
        return _response.data

    def create_collection(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[GroupTranslatedContent] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        help_center_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        You can create a new collection by making a POST request to `https://api.intercom.io/help_center/collections.`

        Parameters
        ----------
        name : str
            The name of the collection. For multilingual collections, this will be the name of the default language's content.

        description : typing.Optional[str]
            The description of the collection. For multilingual collections, this will be the description of the default language's content.

        translated_content : typing.Optional[GroupTranslatedContent]

        parent_id : typing.Optional[str]
            The id of the parent collection. If `null` then it will be created as the first level collection.

        help_center_id : typing.Optional[int]
            The id of the help center where the collection will be created. If `null` then it will be created in the default help center.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            collection created

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.help_center.create_collection(
            name="Thanks for everything",
        )
        """
        _response = self._raw_client.create_collection(
            name=name,
            description=description,
            translated_content=translated_content,
            parent_id=parent_id,
            help_center_id=help_center_id,
            request_options=request_options,
        )
        return _response.data

    def retrieve_collection(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> Collection:
        """
        You can fetch the details of a single collection by making a GET request to `https://api.intercom.io/help_center/collections/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Collection found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.help_center.retrieve_collection(
            id=1,
        )
        """
        _response = self._raw_client.retrieve_collection(id, request_options=request_options)
        return _response.data

    def update_collection(
        self,
        id: int,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[GroupTranslatedContent] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        You can update the details of a single collection by making a PUT request to `https://api.intercom.io/collections/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the collection which is given by Intercom.

        name : typing.Optional[str]
            The name of the collection. For multilingual collections, this will be the name of the default language's content.

        description : typing.Optional[str]
            The description of the collection. For multilingual collections, this will be the description of the default language's content.

        translated_content : typing.Optional[GroupTranslatedContent]

        parent_id : typing.Optional[str]
            The id of the parent collection. If `null` then it will be updated as the first level collection.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.help_center.update_collection(
            id=1,
            name="Update collection name",
        )
        """
        _response = self._raw_client.update_collection(
            id,
            name=name,
            description=description,
            translated_content=translated_content,
            parent_id=parent_id,
            request_options=request_options,
        )
        return _response.data

    def delete_collection(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedCollectionObject:
        """
        You can delete a single collection by making a DELETE request to `https://api.intercom.io/collections/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedCollectionObject
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.help_center.delete_collection(
            id=1,
        )
        """
        _response = self._raw_client.delete_collection(id, request_options=request_options)
        return _response.data

    def retrieve_help_center(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> HelpCenter:
        """
        You can fetch the details of a single Help Center by making a GET request to `https://api.intercom.io/help_center/help_center/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HelpCenter
            Collection found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.help_center.retrieve_help_center(
            id=1,
        )
        """
        _response = self._raw_client.retrieve_help_center(id, request_options=request_options)
        return _response.data

    def list_help_centers(self, *, request_options: typing.Optional[RequestOptions] = None) -> HelpCenterList:
        """
        You can list all Help Centers by making a GET request to `https://api.intercom.io/help_center/help_centers`.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HelpCenterList
            Help Centers found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.help_center.list_help_centers()
        """
        _response = self._raw_client.list_help_centers(request_options=request_options)
        return _response.data


class AsyncHelpCenterClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawHelpCenterClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawHelpCenterClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawHelpCenterClient
        """
        return self._raw_client

    async def list_all_collections(self, *, request_options: typing.Optional[RequestOptions] = None) -> CollectionList:
        """
        You can fetch a list of all collections by making a GET request to `https://api.intercom.io/help_center/collections`.

        Collections will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated collections first.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionList
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.help_center.list_all_collections()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_all_collections(request_options=request_options)
        return _response.data

    async def create_collection(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[GroupTranslatedContent] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        help_center_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        You can create a new collection by making a POST request to `https://api.intercom.io/help_center/collections.`

        Parameters
        ----------
        name : str
            The name of the collection. For multilingual collections, this will be the name of the default language's content.

        description : typing.Optional[str]
            The description of the collection. For multilingual collections, this will be the description of the default language's content.

        translated_content : typing.Optional[GroupTranslatedContent]

        parent_id : typing.Optional[str]
            The id of the parent collection. If `null` then it will be created as the first level collection.

        help_center_id : typing.Optional[int]
            The id of the help center where the collection will be created. If `null` then it will be created in the default help center.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            collection created

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.help_center.create_collection(
                name="Thanks for everything",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_collection(
            name=name,
            description=description,
            translated_content=translated_content,
            parent_id=parent_id,
            help_center_id=help_center_id,
            request_options=request_options,
        )
        return _response.data

    async def retrieve_collection(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Collection:
        """
        You can fetch the details of a single collection by making a GET request to `https://api.intercom.io/help_center/collections/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Collection found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.help_center.retrieve_collection(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_collection(id, request_options=request_options)
        return _response.data

    async def update_collection(
        self,
        id: int,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[GroupTranslatedContent] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        You can update the details of a single collection by making a PUT request to `https://api.intercom.io/collections/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the collection which is given by Intercom.

        name : typing.Optional[str]
            The name of the collection. For multilingual collections, this will be the name of the default language's content.

        description : typing.Optional[str]
            The description of the collection. For multilingual collections, this will be the description of the default language's content.

        translated_content : typing.Optional[GroupTranslatedContent]

        parent_id : typing.Optional[str]
            The id of the parent collection. If `null` then it will be updated as the first level collection.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.help_center.update_collection(
                id=1,
                name="Update collection name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_collection(
            id,
            name=name,
            description=description,
            translated_content=translated_content,
            parent_id=parent_id,
            request_options=request_options,
        )
        return _response.data

    async def delete_collection(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedCollectionObject:
        """
        You can delete a single collection by making a DELETE request to `https://api.intercom.io/collections/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedCollectionObject
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.help_center.delete_collection(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_collection(id, request_options=request_options)
        return _response.data

    async def retrieve_help_center(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HelpCenter:
        """
        You can fetch the details of a single Help Center by making a GET request to `https://api.intercom.io/help_center/help_center/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HelpCenter
            Collection found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.help_center.retrieve_help_center(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_help_center(id, request_options=request_options)
        return _response.data

    async def list_help_centers(self, *, request_options: typing.Optional[RequestOptions] = None) -> HelpCenterList:
        """
        You can list all Help Centers by making a GET request to `https://api.intercom.io/help_center/help_centers`.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HelpCenterList
            Help Centers found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.help_center.list_help_centers()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_help_centers(request_options=request_options)
        return _response.data
