# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...core.unchecked_base_model import construct_type
from ..articles.types.internal_article import InternalArticle
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.create_internal_article_request import CreateInternalArticleRequest
from ..types.deleted_internal_article_object import DeletedInternalArticleObject
from ..types.error import Error
from ..types.internal_article_list import InternalArticleList
from .types.internal_article_search_response import InternalArticleSearchResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawInternalArticlesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_internal_articles(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[InternalArticleList]:
        """
        You can fetch a list of all internal articles by making a GET request to `https://api.intercom.io/internal_articles`.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InternalArticleList]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "internal_articles",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InternalArticleList,
                    construct_type(
                        type_=InternalArticleList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_internal_article(
        self,
        *,
        request: typing.Optional[CreateInternalArticleRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[InternalArticle]:
        """
        You can create a new internal article by making a POST request to `https://api.intercom.io/internal_articles`.

        Parameters
        ----------
        request : typing.Optional[CreateInternalArticleRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InternalArticle]
            internal article created
        """
        _response = self._client_wrapper.httpx_client.request(
            "internal_articles",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CreateInternalArticleRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InternalArticle,
                    construct_type(
                        type_=InternalArticle,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve_internal_article(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[InternalArticle]:
        """
        You can fetch the details of a single internal article by making a GET request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InternalArticle]
            Internal article found
        """
        _response = self._client_wrapper.httpx_client.request(
            f"internal_articles/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InternalArticle,
                    construct_type(
                        type_=InternalArticle,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_internal_article(
        self,
        id: int,
        *,
        title: typing.Optional[str] = OMIT,
        body: typing.Optional[str] = OMIT,
        author_id: typing.Optional[int] = OMIT,
        owner_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[InternalArticle]:
        """
        You can update the details of a single internal article by making a PUT request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the internal article which is given by Intercom.

        title : typing.Optional[str]
            The title of the article.

        body : typing.Optional[str]
            The content of the article.

        author_id : typing.Optional[int]
            The id of the author of the article.

        owner_id : typing.Optional[int]
            The id of the author of the article.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InternalArticle]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"internal_articles/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "title": title,
                "body": body,
                "author_id": author_id,
                "owner_id": owner_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InternalArticle,
                    construct_type(
                        type_=InternalArticle,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_internal_article(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeletedInternalArticleObject]:
        """
        You can delete a single internal article by making a DELETE request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the internal article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeletedInternalArticleObject]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"internal_articles/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeletedInternalArticleObject,
                    construct_type(
                        type_=DeletedInternalArticleObject,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def search_internal_articles(
        self, *, folder_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[InternalArticleSearchResponse]:
        """
        You can search for internal articles by making a GET request to `https://api.intercom.io/internal_articles/search`.

        Parameters
        ----------
        folder_id : typing.Optional[str]
            The ID of the folder to search in.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InternalArticleSearchResponse]
            Search successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "internal_articles/search",
            method="GET",
            params={
                "folder_id": folder_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InternalArticleSearchResponse,
                    construct_type(
                        type_=InternalArticleSearchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawInternalArticlesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_internal_articles(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[InternalArticleList]:
        """
        You can fetch a list of all internal articles by making a GET request to `https://api.intercom.io/internal_articles`.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InternalArticleList]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "internal_articles",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InternalArticleList,
                    construct_type(
                        type_=InternalArticleList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_internal_article(
        self,
        *,
        request: typing.Optional[CreateInternalArticleRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[InternalArticle]:
        """
        You can create a new internal article by making a POST request to `https://api.intercom.io/internal_articles`.

        Parameters
        ----------
        request : typing.Optional[CreateInternalArticleRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InternalArticle]
            internal article created
        """
        _response = await self._client_wrapper.httpx_client.request(
            "internal_articles",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CreateInternalArticleRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InternalArticle,
                    construct_type(
                        type_=InternalArticle,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve_internal_article(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[InternalArticle]:
        """
        You can fetch the details of a single internal article by making a GET request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InternalArticle]
            Internal article found
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"internal_articles/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InternalArticle,
                    construct_type(
                        type_=InternalArticle,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_internal_article(
        self,
        id: int,
        *,
        title: typing.Optional[str] = OMIT,
        body: typing.Optional[str] = OMIT,
        author_id: typing.Optional[int] = OMIT,
        owner_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[InternalArticle]:
        """
        You can update the details of a single internal article by making a PUT request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the internal article which is given by Intercom.

        title : typing.Optional[str]
            The title of the article.

        body : typing.Optional[str]
            The content of the article.

        author_id : typing.Optional[int]
            The id of the author of the article.

        owner_id : typing.Optional[int]
            The id of the author of the article.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InternalArticle]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"internal_articles/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "title": title,
                "body": body,
                "author_id": author_id,
                "owner_id": owner_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InternalArticle,
                    construct_type(
                        type_=InternalArticle,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_internal_article(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeletedInternalArticleObject]:
        """
        You can delete a single internal article by making a DELETE request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the internal article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeletedInternalArticleObject]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"internal_articles/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeletedInternalArticleObject,
                    construct_type(
                        type_=DeletedInternalArticleObject,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def search_internal_articles(
        self, *, folder_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[InternalArticleSearchResponse]:
        """
        You can search for internal articles by making a GET request to `https://api.intercom.io/internal_articles/search`.

        Parameters
        ----------
        folder_id : typing.Optional[str]
            The ID of the folder to search in.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InternalArticleSearchResponse]
            Search successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "internal_articles/search",
            method="GET",
            params={
                "folder_id": folder_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InternalArticleSearchResponse,
                    construct_type(
                        type_=InternalArticleSearchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
