# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawMacrosClient, RawMacrosClient
from .types.macro import Macro
from .types.macro_list import MacroList


class MacrosClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMacrosClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMacrosClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMacrosClient
        """
        return self._raw_client

    def list_macros(
        self,
        *,
        per_page: typing.Optional[int] = None,
        starting_after: typing.Optional[str] = None,
        updated_since: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MacroList:
        """
        You can fetch a list of all macros (saved replies) in your workspace for use in automating responses.

        The macros are returned in descending order by updated_at.

        **Pagination**

        This endpoint uses cursor-based pagination via the `starting_after` parameter. The cursor is a Base64-encoded JSON array containing `[updated_at, id]` of the last item from the previous page.

        **Placeholder Transformation**

        The API transforms Intercom placeholders to a more standard XML-like format:
        - From: `{{user.name | fallback: 'there'}}`
        - To: `<attribute key="user.name" default="there"/>`

        Parameters
        ----------
        per_page : typing.Optional[int]
            The number of results per page

        starting_after : typing.Optional[str]
            Base64-encoded cursor containing [updated_at, id] for pagination

        updated_since : typing.Optional[int]
            Unix timestamp to filter macros updated after this time

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MacroList
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.macros.list_macros(
            per_page=1,
            starting_after="WzE3MTk0OTM3NTcuMCwgIjEyMyJd",
            updated_since=1000000,
        )
        """
        _response = self._raw_client.list_macros(
            per_page=per_page,
            starting_after=starting_after,
            updated_since=updated_since,
            request_options=request_options,
        )
        return _response.data

    def get_macro(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[Macro]:
        """
        You can fetch a single macro (saved reply) by its ID. The macro will only be returned if it is visible to the authenticated user based on its visibility settings.

        **Visibility Rules**

        A macro is returned based on its `visible_to` setting:
        - `everyone`: Always visible to all team members
        - `specific_teams`: Only visible if the authenticated user belongs to one of the teams specified in `visible_to_team_ids`

        If a macro exists but is not visible to the authenticated user, a 404 error is returned.

        **Placeholder Transformation**

        The API transforms Intercom placeholders to a more standard XML-like format in the `body` field:
        - From: `{{user.name | fallback: 'there'}}`
        - To: `<attribute key="user.name" default="there"/>`

        Default values in placeholders are HTML-escaped for security.

        Parameters
        ----------
        id : str
            The unique identifier of the macro

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Macro]
            Macro found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.macros.get_macro(
            id="123",
        )
        """
        _response = self._raw_client.get_macro(id, request_options=request_options)
        return _response.data


class AsyncMacrosClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMacrosClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMacrosClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMacrosClient
        """
        return self._raw_client

    async def list_macros(
        self,
        *,
        per_page: typing.Optional[int] = None,
        starting_after: typing.Optional[str] = None,
        updated_since: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MacroList:
        """
        You can fetch a list of all macros (saved replies) in your workspace for use in automating responses.

        The macros are returned in descending order by updated_at.

        **Pagination**

        This endpoint uses cursor-based pagination via the `starting_after` parameter. The cursor is a Base64-encoded JSON array containing `[updated_at, id]` of the last item from the previous page.

        **Placeholder Transformation**

        The API transforms Intercom placeholders to a more standard XML-like format:
        - From: `{{user.name | fallback: 'there'}}`
        - To: `<attribute key="user.name" default="there"/>`

        Parameters
        ----------
        per_page : typing.Optional[int]
            The number of results per page

        starting_after : typing.Optional[str]
            Base64-encoded cursor containing [updated_at, id] for pagination

        updated_since : typing.Optional[int]
            Unix timestamp to filter macros updated after this time

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MacroList
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.macros.list_macros(
                per_page=1,
                starting_after="WzE3MTk0OTM3NTcuMCwgIjEyMyJd",
                updated_since=1000000,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_macros(
            per_page=per_page,
            starting_after=starting_after,
            updated_since=updated_since,
            request_options=request_options,
        )
        return _response.data

    async def get_macro(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[Macro]:
        """
        You can fetch a single macro (saved reply) by its ID. The macro will only be returned if it is visible to the authenticated user based on its visibility settings.

        **Visibility Rules**

        A macro is returned based on its `visible_to` setting:
        - `everyone`: Always visible to all team members
        - `specific_teams`: Only visible if the authenticated user belongs to one of the teams specified in `visible_to_team_ids`

        If a macro exists but is not visible to the authenticated user, a 404 error is returned.

        **Placeholder Transformation**

        The API transforms Intercom placeholders to a more standard XML-like format in the `body` field:
        - From: `{{user.name | fallback: 'there'}}`
        - To: `<attribute key="user.name" default="there"/>`

        Default values in placeholders are HTML-escaped for security.

        Parameters
        ----------
        id : str
            The unique identifier of the macro

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Macro]
            Macro found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.macros.get_macro(
                id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_macro(id, request_options=request_options)
        return _response.data
