# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .macro_available_on_item import MacroAvailableOnItem
from .macro_visible_to import MacroVisibleTo


class Macro(UncheckedBaseModel):
    """
    A macro is a pre-defined response template (saved reply) that can be used to quickly reply to conversations.
    """

    type: typing.Optional[typing.Literal["macro"]] = pydantic.Field(default=None)
    """
    String representing the object's type. Always has the value `macro`.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the macro.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the macro.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The body of the macro in HTML format with placeholders transformed to XML-like format.
    """

    body_text: typing.Optional[str] = pydantic.Field(default=None)
    """
    The plain text version of the macro body with original Intercom placeholder format.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time the macro was created in ISO 8601 format.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time the macro was last updated in ISO 8601 format.
    """

    visible_to: typing.Optional[MacroVisibleTo] = pydantic.Field(default=None)
    """
    Who can view this macro.
    """

    visible_to_team_ids: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The team IDs that can view this macro when visible_to is set to specific_teams.
    """

    available_on: typing.Optional[typing.List[MacroAvailableOnItem]] = pydantic.Field(default=None)
    """
    Where the macro is available for use.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
