# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.note_list import NoteList
from .raw_client import AsyncRawNotesClient, RawNotesClient
from .types.note import Note

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class NotesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawNotesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawNotesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawNotesClient
        """
        return self._raw_client

    def list_company_notes(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> NoteList:
        """
        You can fetch a list of notes that are associated to a company.

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NoteList
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.notes.list_company_notes(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        )
        """
        _response = self._raw_client.list_company_notes(id, request_options=request_options)
        return _response.data

    def list_notes(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> NoteList:
        """
        You can fetch a list of notes that are associated to a contact.

        Parameters
        ----------
        id : int
            The unique identifier of a contact.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NoteList
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.notes.list_notes(
            id=1,
        )
        """
        _response = self._raw_client.list_notes(id, request_options=request_options)
        return _response.data

    def create_note(
        self,
        id: int,
        *,
        body: str,
        contact_id: typing.Optional[str] = OMIT,
        admin_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Note:
        """
        You can add a note to a single contact.

        Parameters
        ----------
        id : int
            The unique identifier of a given contact.

        body : str
            The text of the note.

        contact_id : typing.Optional[str]
            The unique identifier of a given contact.

        admin_id : typing.Optional[str]
            The unique identifier of a given admin.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.notes.create_note(
            id=1,
            body="Hello",
            contact_id="6762f0ad1bb69f9f2193bb62",
            admin_id="123",
        )
        """
        _response = self._raw_client.create_note(
            id, body=body, contact_id=contact_id, admin_id=admin_id, request_options=request_options
        )
        return _response.data

    def retrieve_note(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> Note:
        """
        You can fetch the details of a single note.

        Parameters
        ----------
        id : int
            The unique identifier of a given note

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note
            Note found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.notes.retrieve_note(
            id=1,
        )
        """
        _response = self._raw_client.retrieve_note(id, request_options=request_options)
        return _response.data


class AsyncNotesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawNotesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawNotesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawNotesClient
        """
        return self._raw_client

    async def list_company_notes(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> NoteList:
        """
        You can fetch a list of notes that are associated to a company.

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NoteList
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.notes.list_company_notes(
                id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_company_notes(id, request_options=request_options)
        return _response.data

    async def list_notes(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> NoteList:
        """
        You can fetch a list of notes that are associated to a contact.

        Parameters
        ----------
        id : int
            The unique identifier of a contact.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NoteList
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.notes.list_notes(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_notes(id, request_options=request_options)
        return _response.data

    async def create_note(
        self,
        id: int,
        *,
        body: str,
        contact_id: typing.Optional[str] = OMIT,
        admin_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Note:
        """
        You can add a note to a single contact.

        Parameters
        ----------
        id : int
            The unique identifier of a given contact.

        body : str
            The text of the note.

        contact_id : typing.Optional[str]
            The unique identifier of a given contact.

        admin_id : typing.Optional[str]
            The unique identifier of a given admin.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.notes.create_note(
                id=1,
                body="Hello",
                contact_id="6762f0ad1bb69f9f2193bb62",
                admin_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_note(
            id, body=body, contact_id=contact_id, admin_id=admin_id, request_options=request_options
        )
        return _response.data

    async def retrieve_note(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> Note:
        """
        You can fetch the details of a single note.

        Parameters
        ----------
        id : int
            The unique identifier of a given note

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note
            Note found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.notes.retrieve_note(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_note(id, request_options=request_options)
        return _response.data
