# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from ...admins.types.admin import Admin
from .company_note_company import CompanyNoteCompany


class CompanyNote(UncheckedBaseModel):
    """
    Notes allow you to annotate and comment on companies.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    String representing the object's type. Always has the value `note`.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the note.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the note was created.
    """

    company: typing.Optional[CompanyNoteCompany] = pydantic.Field(default=None)
    """
    Represents the company that the note was created about.
    """

    author: typing.Optional[Admin] = pydantic.Field(default=None)
    """
    Optional. Represents the Admin that created the note.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The body text of the note.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
