# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel


class AiCallResponse(UncheckedBaseModel):
    """
    Response containing information about a Fin Voice call
    """

    id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The unique identifier for the external reference
    """

    app_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The workspace identifier
    """

    user_phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Phone number in E.164 format for the call
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    Status of the call. Can be "registered", "in-progress", or a resolution state
    """

    intercom_call_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Intercom call identifier, if the call has been matched
    """

    external_call_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The external call identifier from the call provider
    """

    intercom_conversation_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Intercom conversation identifier, if a conversation has been created
    """

    call_transcript: typing.Optional[typing.List[typing.Dict[str, typing.Any]]] = pydantic.Field(default=None)
    """
    Array of transcript entries for the call
    """

    call_summary: typing.Optional[str] = pydantic.Field(default=None)
    """
    Summary of the call conversation, truncated to 256 characters. Empty string if no summary available.
    """

    intent: typing.Optional[typing.List[typing.Dict[str, typing.Any]]] = pydantic.Field(default=None)
    """
    Array of intent classifications for the call
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
