# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from ...core.unchecked_base_model import UncheckedBaseModel
from .article_content import ArticleContent


class ArticleTranslatedContent(UncheckedBaseModel):
    """
    The Translated Content of an Article. The keys are the locale codes and the values are the translated content of the article.
    """

    type: typing.Optional[typing.Literal["article_translated_content"]] = pydantic.Field(default=None)
    """
    The type of object - article_translated_content.
    """

    ar: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Arabic
    """

    bg: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Bulgarian
    """

    bs: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Bosnian
    """

    ca: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Catalan
    """

    cs: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Czech
    """

    da: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Danish
    """

    de: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in German
    """

    el: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Greek
    """

    en: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in English
    """

    es: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Spanish
    """

    et: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Estonian
    """

    fi: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Finnish
    """

    fr: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in French
    """

    he: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Hebrew
    """

    hr: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Croatian
    """

    hu: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Hungarian
    """

    id: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Indonesian
    """

    it: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Italian
    """

    ja: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Japanese
    """

    ko: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Korean
    """

    lt: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Lithuanian
    """

    lv: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Latvian
    """

    mn: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Mongolian
    """

    nb: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Norwegian
    """

    nl: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Dutch
    """

    pl: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Polish
    """

    pt: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Portuguese (Portugal)
    """

    ro: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Romanian
    """

    ru: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Russian
    """

    sl: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Slovenian
    """

    sr: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Serbian
    """

    sv: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Swedish
    """

    tr: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Turkish
    """

    vi: typing.Optional[ArticleContent] = pydantic.Field(default=None)
    """
    The content of the article in Vietnamese
    """

    pt_br: typing_extensions.Annotated[typing.Optional[ArticleContent], FieldMetadata(alias="pt-BR")] = pydantic.Field(
        default=None
    )
    """
    The content of the article in Portuguese (Brazil)
    """

    zh_cn: typing_extensions.Annotated[typing.Optional[ArticleContent], FieldMetadata(alias="zh-CN")] = pydantic.Field(
        default=None
    )
    """
    The content of the article in Chinese (China)
    """

    zh_tw: typing_extensions.Annotated[typing.Optional[ArticleContent], FieldMetadata(alias="zh-TW")] = pydantic.Field(
        default=None
    )
    """
    The content of the article in Chinese (Taiwan)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
