# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel


class CreateInternalArticleRequest(UncheckedBaseModel):
    """
    You can create an Internal Article
    """

    title: str = pydantic.Field()
    """
    The title of the article.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The content of the article.
    """

    author_id: int = pydantic.Field()
    """
    The id of the author of the article.
    """

    owner_id: int = pydantic.Field()
    """
    The id of the owner of the article.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
