# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .handling_event_type import HandlingEventType
from .teammate_reference import TeammateReference


class HandlingEvent(UncheckedBaseModel):
    """
    A pause or resume event for a conversation
    """

    teammate: TeammateReference
    type: HandlingEventType = pydantic.Field()
    """
    The type of handling event
    """

    timestamp: dt.datetime = pydantic.Field()
    """
    ISO8601 timestamp when the event occurred
    """

    reason: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional reason for the event (e.g., "Paused", "Away")
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
