# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ..news.types.newsfeed_assignment import NewsfeedAssignment
from .news_item_request_state import NewsItemRequestState


class NewsItemRequest(UncheckedBaseModel):
    """
    A News Item is a content type in Intercom enabling you to announce product updates, company news, promotions, events and more with your customers.
    """

    title: str = pydantic.Field()
    """
    The title of the news item.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The news item body, which may contain HTML.
    """

    sender_id: int = pydantic.Field()
    """
    The id of the sender of the news item. Must be a teammate on the workspace.
    """

    state: typing.Optional[NewsItemRequestState] = pydantic.Field(default=None)
    """
    News items will not be visible to your users in the assigned newsfeeds until they are set live.
    """

    deliver_silently: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When set to `true`, the news item will appear in the messenger newsfeed without showing a notification badge.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Label names displayed to users to categorize the news item.
    """

    reactions: typing.Optional[typing.List[typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Ordered list of emoji reactions to the news item. When empty, reactions are disabled.
    """

    newsfeed_assignments: typing.Optional[typing.List[NewsfeedAssignment]] = pydantic.Field(default=None)
    """
    A list of newsfeed_assignments to assign to the specified newsfeed.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
