# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .register_fin_voice_call_request_source import RegisterFinVoiceCallRequestSource


class RegisterFinVoiceCallRequest(UncheckedBaseModel):
    """
    Register a Fin Voice call with Intercom
    """

    phone_number: str = pydantic.Field()
    """
    Phone number in E.164 format for the call
    """

    call_id: str = pydantic.Field()
    """
    External call identifier from the call provider
    """

    source: typing.Optional[RegisterFinVoiceCallRequestSource] = pydantic.Field(default=None)
    """
    Source of the call. Can be "five9", "zoom_phone", or defaults to "aws_connect"
    """

    data: typing.Optional[typing.Dict[str, typing.Any]] = pydantic.Field(default=None)
    """
    Additional metadata about the call
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
