# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .teammate_reference_type import TeammateReferenceType


class TeammateReference(UncheckedBaseModel):
    """
    A reference to a teammate (admin, team, or bot)
    """

    type: TeammateReferenceType = pydantic.Field()
    """
    The type of teammate
    """

    id: int = pydantic.Field()
    """
    The unique identifier of the teammate
    """

    name: str = pydantic.Field()
    """
    The display name of the teammate
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email address of the teammate (optional for teams/bots)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
