# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .workflow_export_workflow import WorkflowExportWorkflow


class WorkflowExport(UncheckedBaseModel):
    """
    A workflow export containing the complete workflow configuration.
    """

    export_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the export format.
    """

    exported_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the export was generated.
    """

    app_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The workspace identifier.
    """

    workflow: typing.Optional[WorkflowExportWorkflow] = pydantic.Field(default=None)
    """
    The workflow configuration.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
