      }(__cache_versionKobj}(src/invar/shell/perception.py af350323eb3d13e2d413554655dad9a5solidlsp.lsDocumentSymbols)}(root_symbols](}(nameconsolekindK
range}(start}(lineK	characterK uend}(hKhKuuselectionRange}(h}(hKhK uh}(hKhKuuchildren]location}(uri?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyrangehabsolutePath8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyrelativePathhubodyconsole = Console()parentNu}(hrun_maphKh}(h}(hKhK uh}(hKChKuuh}(h}(hKhKuh}(hKhKuuh](}(hpathhK
h}(h}(hKhKuh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#h5h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'@path: Path, top_n: int, json_output: bool) -> Result[None, str]:h)h*u}(htop_nhK
h}(h}(hKhKuh}(hKhK"uuh}(h}(hKhKuh}(hKhK"uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hBh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'4top_n: int, json_output: bool) -> Result[None, str]:h)h*u}(hjson_outputhK
h}(h}(hKhK$uh}(hKhK5uuh}(h}(hKhK$uh}(hKhK5uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hOh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'(json_output: bool) -> Result[None, str]:h)h*u}(h
file_infoshK
h}(h}(hK&hKuh}(hK&hKuuh}(h}(hK&hKuh}(hK&hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#h\h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'file_infos: list[FileInfo] = []h)h*u}(hsourceshK
h}(h}(hK'hKuh}(hK'hKuuh}(h}(hK'hKuh}(hK'hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hih$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'sources: dict[str, str] = {}h)h*u}(hpy_filehK
h}(h}(hK)hKuh}(hK)hKuuh}(h}(hK)hKuh}(hK)hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hvh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh''py_file in discover_python_files(path):h)h*u}(hcontenthK
h}(h}(hK+hKuh}(hK+hKuuh}(h}(hK+hKuh}(hK+hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'-content = py_file.read_text(encoding="utf-8")h)h*u}(hrel_pathhK
h}(h}(hK,hKuh}(hK,hKuuh}(h}(hK,hKuh}(hK,hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh')rel_path = str(py_file.relative_to(path))h)h*u}(h	file_infohK
h}(h}(hK-hKuh}(hK-hKuuh}(h}(hK-hKuh}(hK-hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'+file_info = parse_source(content, rel_path)h)h*u}(hehK
h}(h}(hK1hK0uh}(hK1hK1uuh}(h}(hK1hK0uh}(hK1hK1uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'e:h)h*u}(hperception_maphK
h}(h}(hK9hKuh}(hK9hKuuh}(h}(hK9hKuh}(hK9hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'Pperception_map = build_perception_map(file_infos, sources, str(path.absolute()))h)h*u}(houtputhK
h}(h}(hK=hKuh}(hK=hKuuh}(h}(hK=hKuh}(hK=hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'(output = format_map_json(perception_map)h)h*ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#h,h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'X  def run_map(path: Path, top_n: int, json_output: bool) -> Result[None, str]:
    """
    Run the map command.

    Scans project and generates perception map with reference counts.
    """
    if not path.exists():
        return Failure(f"Path does not exist: {path}")

    # Collect all files and their sources
    file_infos: list[FileInfo] = []
    sources: dict[str, str] = {}

    for py_file in discover_python_files(path):
        try:
            content = py_file.read_text(encoding="utf-8")
            rel_path = str(py_file.relative_to(path))
            file_info = parse_source(content, rel_path)
            if file_info:
                file_infos.append(file_info)
                sources[rel_path] = content
        except (OSError, UnicodeDecodeError) as e:
            console.print(f"[yellow]Warning:[/yellow] {py_file}: {e}")
            continue

    if not file_infos:
        return Failure("No Python files found")

    # Build perception map
    perception_map = build_perception_map(file_infos, sources, str(path.absolute()))

    # Output
    if json_output:
        output = format_map_json(perception_map)
        console.print(json.dumps(output, indent=2))
    else:
        output = format_map_text(perception_map, top_n)
        console.print(output)

    return Success(None)h)Nu}(hrun_sighKh}(h}(hKFhK uh}(hKqhKuuh}(h}(hKFhKuh}(hKFhKuuh](}(htargethK
h}(h}(hKFhKuh}(hKFhKuuh}(h}(hKFhKuh}(hKFhKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'5target: str, json_output: bool) -> Result[None, str]:h)hu}(hjson_outputhK
h}(h}(hKFhKuh}(hKFhK*uuh}(h}(hKFhKuh}(hKFhK*uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'(json_output: bool) -> Result[None, str]:h)hu}(h
file_path_strhK
h}(h}(hKOhKuh}(hKOhKuuh}(h}(hKOhKuh}(hKOhKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'2file_path_str, symbol_name = target.split("::", 1)h)hu}(hsymbol_namehK
h}(h}(hKOhKuh}(hKOhK"uuh}(h}(hKOhKuh}(hKOhK"uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'#symbol_name = target.split("::", 1)h)hu}(h	file_pathhK
h}(h}(hKThKuh}(hKThK
uuh}(h}(hKThKuh}(hKThK
uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'file_path = Path(file_path_str)h)hu}(hcontenthK
h}(h}(hKZhKuh}(hKZhKuuh}(h}(hKZhKuh}(hKZhKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'/content = file_path.read_text(encoding="utf-8")h)hu}(hhhK
h}(h}(hK[hK,uh}(hK[hK-uuh}(h}(hK[hK,uh}(hK[hK-uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#j+  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'e:h)hu}(h	file_infohK
h}(h}(hK^hKuh}(hK^hK
uuh}(h}(hK^hKuh}(hK^hK
uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#j8  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'1file_info = parse_source(content, str(file_path))h)hu}(hsymbolshK
h}(h}(hKchKuh}(hKchKuuh}(h}(hKchKuh}(hKchKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#jE  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh')symbols: list[Symbol] = file_info.symbolsh)hu}(houtputhK
h}(h}(hKkhKuh}(hKkhKuuh}(h}(hKkhKuh}(hKkhKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#jR  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'8output = format_signatures_json(symbols, str(file_path))h)hueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'Xp  def run_sig(target: str, json_output: bool) -> Result[None, str]:
    """
    Run the sig command.

    Extracts signatures from a file or specific symbol.
    Target format: "path/to/file.py" or "path/to/file.py::symbol_name"
    """
    # Parse target
    if "::" in target:
        file_path_str, symbol_name = target.split("::", 1)
    else:
        file_path_str = target
        symbol_name = None

    file_path = Path(file_path_str)
    if not file_path.exists():
        return Failure(f"File not found: {file_path}")

    # Read and parse
    try:
        content = file_path.read_text(encoding="utf-8")
    except (OSError, UnicodeDecodeError) as e:
        return Failure(f"Failed to read {file_path}: {e}")

    file_info = parse_source(content, str(file_path))
    if file_info is None:
        return Failure(f"Syntax error in {file_path}")

    # Filter symbols
    symbols: list[Symbol] = file_info.symbols
    if symbol_name:
        symbols = [s for s in symbols if s.name == symbol_name]
        if not symbols:
            return Failure(f"Symbol '{symbol_name}' not found in {file_path}")

    # Output
    if json_output:
        output = format_signatures_json(symbols, str(file_path))
        console.print(json.dumps(output, indent=2))
    else:
        output = format_signatures_text(symbols, str(file_path))
        console.print(output)

    return Success(None)h)Nue_all_symbolsNubsrc/invar/core/rule_meta.py b3a6352581935aaf23f0064fa681e85bh)}(h](}(nameRuleCategorykindKrange}(start}(lineK	characterK uend}(jp  Kjq  KuuselectionRange}(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuuchildren](}(ji  SIZEjk  Kjl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j|  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'
SIZE = "size"h)jh  u}(ji  	CONTRACTSjk  Kjl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K
uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K
uujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'CONTRACTS = "contracts"h)jh  u}(ji  PURITYjk  Kjl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K
uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K
uujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'PURITY = "purity"h)jh  u}(ji  SHELLjk  Kjl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K	uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K	uujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'SHELL = "shell"h)jh  u}(ji  DOCSjk  Kjl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'
DOCS = "docs"h)jh  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#jm  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'class RuleCategory(str, Enum):
    """Categories for grouping rules."""

    SIZE = "size"
    CONTRACTS = "contracts"
    PURITY = "purity"
    SHELL = "shell"
    DOCS = "docs"h)}(name	rule_metakindsolidlsp.ls_types
SymbolKindKRh#}(start}(lineK 	characterK uend}(j  Kj  K uuselectionRangej  h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&src/invar/core/rule_meta.pyuchildrenjg  h)}(j  corej  j  KRh}(h!0file:///Users/tefx/Projects/Invar/src/invar/coreh#}(j  }(j  K j  K uj  }(j  K j  K uuh$)/Users/tefx/Projects/Invar/src/invar/coreh&src/invar/coreuj  ](j  }(j  	formatterj  j  h#}(j  }(j  K j  K uj  }(j  Mj  K uuj  j  h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&src/invar/core/formatter.pyuj  ](}(nameformat_map_textkindKrange}(start}(lineK	characterK uend}(j  K;j  KuuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  perception_mapj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K1uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K1uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&src/invar/core/formatter.pyuh'6perception_map: PerceptionMap, top_n: int = 0) -> str:h)j  u}(j  top_nj  K
j  }(j  }(j  Kj  K3uj  }(j  Kj  KAuuj  }(j  }(j  Kj  K3uj  }(j  Kj  KAuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j
  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'top_n: int = 0) -> str:h)j  u}(j  linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'lines: list[str] = []h)j  u}(j  symbolsj  K
j  }(j  }(j  K%j  Kuj  }(j  K%j  Kuuj  }(j  }(j  K%j  Kuj  }(j  K%j  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j'  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh' symbols = perception_map.symbolsh)j  u}(j  hotj  K
j  }(j  }(j  K.j  Kuj  }(j  K.j  Kuuj  }(j  }(j  K.j  Kuj  }(j  K.j  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j4  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'.hot = [s for s in symbols if s.ref_count > 10]h)j  u}(j  warmj  K
j  }(j  }(j  K/j  Kuj  }(j  K/j  Kuuj  }(j  }(j  K/j  Kuj  }(j  K/j  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jA  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'5warm = [s for s in symbols if 3 <= s.ref_count <= 10]h)j  u}(j  coldj  K
j  }(j  }(j  K0j  Kuj  }(j  K0j  Kuuj  }(j  }(j  K0j  Kuj  }(j  K0j  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jN  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'.cold = [s for s in symbols if s.ref_count < 3]h)j  u}(j  labelj  K
j  }(j  }(j  K2j  Kuj  }(j  K2j  K
uuj  }(j  }(j  K2j  Kuj  }(j  K2j  K
uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j[  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'8label, group, level in [("Hot (refs > 10)", hot, "hot"),h)j  u}(j  groupj  K
j  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jh  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'1group, level in [("Hot (refs > 10)", hot, "hot"),h)j  u}(j  levelj  K
j  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#ju  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'*level in [("Hot (refs > 10)", hot, "hot"),h)j  u}(j  srj  K
j  }(j  }(j  K7j  Kuj  }(j  K7j  Kuuj  }(j  }(j  K7j  Kuj  }(j  K7j  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'sr in group:h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'X5  @pre(lambda perception_map, top_n=0: isinstance(perception_map, PerceptionMap))
def format_map_text(perception_map: PerceptionMap, top_n: int = 0) -> str:
    """
    Format perception map as plain text.

    Args:
        perception_map: The perception map to format
        top_n: If > 0, only show top N symbols by reference count

    Examples:
        >>> from invar.core.models import PerceptionMap
        >>> pm = PerceptionMap(project_root="/test", total_files=1, total_symbols=0)
        >>> "Project:" in format_map_text(pm)
        True
    """
    lines: list[str] = []
    lines.append(f"Project: {perception_map.project_root}")
    lines.append(f"Files: {perception_map.total_files}")
    lines.append(f"Symbols: {perception_map.total_symbols}")
    lines.append("")

    symbols = perception_map.symbols
    if top_n > 0:
        symbols = symbols[:top_n]

    if not symbols:
        lines.append("No symbols found.")
        return "\n".join(lines)

    # Group by reference count level
    hot = [s for s in symbols if s.ref_count > 10]
    warm = [s for s in symbols if 3 <= s.ref_count <= 10]
    cold = [s for s in symbols if s.ref_count < 3]

    for label, group, level in [("Hot (refs > 10)", hot, "hot"),
                                  ("Warm (refs 3-10)", warm, "warm"),
                                  ("Cold (refs < 3)", cold, "cold")]:
        if group:
            lines.append(f"=== {label} ===")
            for sr in group:
                lines.extend(_format_symbol_detail(sr, level=level))
            lines.append("")

    return "\n".join(lines)h)j  u}(j  _format_symbol_detailj  Kj  }(j  }(j  K>j  K uj  }(j  KZj  Kuuj  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj  ](}(j  srj  K
j  }(j  }(j  K@j  Kuj  }(j  K@j  K(uuj  }(j  }(j  K@j  Kuj  }(j  K@j  K(uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh')sr: SymbolRefs, level: str) -> list[str]:h)j  u}(j  levelj  K
j  }(j  }(j  K@j  K*uj  }(j  K@j  K4uuj  }(j  }(j  K@j  K*uj  }(j  K@j  K4uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'level: str) -> list[str]:h)j  u}(j  linesj  K
j  }(j  }(j  KBj  Kuj  }(j  KBj  K	uuj  }(j  }(j  KBj  Kuj  }(j  KBj  K	uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'lines: list[str] = []h)j  u}(j  symj  K
j  }(j  }(j  KCj  Kuj  }(j  KCj  Kuuj  }(j  }(j  KCj  Kuj  }(j  KCj  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'sym = sr.symbolh)j  u}(j  sigj  K
j  }(j  }(j  KDj  Kuj  }(j  KDj  Kuuj  }(j  }(j  KDj  Kuj  }(j  KDj  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'&sig = sym.signature or f"({sym.name})"h)j  u}(j  
first_linej  K
j  }(j  }(j  KJj  Kuj  }(j  KJj  Kuuj  }(j  }(j  KJj  Kuj  }(j  KJj  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'1first_line = sym.docstring.split("\n")[0].strip()h)j  u}(j  cj  K
j  }(j  }(j  KNj  Kuj  }(j  KNj  Kuuj  }(j  }(j  KNj  Kuj  }(j  KNj  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'c in sym.contracts:h)j  u}(j  kindsj  K
j  }(j  }(j  KTj  Kuj  }(j  KTj  Kuuj  }(j  }(j  KTj  Kuj  }(j  KTj  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh''kinds = [c.kind for c in sym.contracts]h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'X  @pre(lambda sr, level: isinstance(sr, SymbolRefs) and level in ("hot", "warm", "cold"))
@post(lambda result: all(isinstance(line, str) for line in result))
def _format_symbol_detail(sr: SymbolRefs, level: str) -> list[str]:
    """Format a single symbol with appropriate detail level."""
    lines: list[str] = []
    sym = sr.symbol
    sig = sym.signature or f"({sym.name})"

    if level == "hot":
        # Full detail: signature + docstring + contracts
        lines.append(f"  {sr.file_path}::{sym.name}{sig}  [refs: {sr.ref_count}]")
        if sym.docstring:
            first_line = sym.docstring.split("\n")[0].strip()
            if first_line:
                lines.append(f"    | {first_line}")
        if sym.contracts:
            for c in sym.contracts:
                lines.append(f"    | @{c.kind}: {c.expression}")
    elif level == "warm":
        # Medium: signature + contracts summary
        lines.append(f"  {sr.file_path}::{sym.name}{sig}  [refs: {sr.ref_count}]")
        if sym.contracts:
            kinds = [c.kind for c in sym.contracts]
            lines.append(f"    | contracts: {', '.join(kinds)}")
    else:
        # Minimal: name only
        lines.append(f"  {sr.file_path}::{sym.name}  [refs: {sr.ref_count}]")

    return linesh)j  u}(j  format_map_jsonj  Kj  }(j  }(j  K]j  K uj  }(j  Knj  Kuuj  }(j  }(j  K^j  Kuj  }(j  K^j  Kuuj  ]}(j  perception_mapj  K
j  }(j  }(j  K^j  Kuj  }(j  K^j  K1uuj  }(j  }(j  K^j  Kuj  }(j  K^j  K1uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh''perception_map: PerceptionMap) -> dict:h)j  uah}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'X  @pre(lambda perception_map: isinstance(perception_map, PerceptionMap))
def format_map_json(perception_map: PerceptionMap) -> dict:
    """
    Format perception map as JSON-serializable dict.

    Examples:
        >>> from invar.core.models import PerceptionMap
        >>> pm = PerceptionMap(project_root="/test", total_files=1, total_symbols=0)
        >>> d = format_map_json(pm)
        >>> d["project_root"]
        '/test'
    """
    return {
        "project_root": perception_map.project_root,
        "total_files": perception_map.total_files,
        "total_symbols": perception_map.total_symbols,
        "symbols": [_symbol_refs_to_dict(sr) for sr in perception_map.symbols],
    }h)j  u}(j  _symbol_refs_to_dictj  Kj  }(j  }(j  Kqj  K uj  }(j  Kj  Kuuj  }(j  }(j  Ksj  Kuj  }(j  Ksj  Kuuj  ](}(j  srj  K
j  }(j  }(j  Ksj  Kuj  }(j  Ksj  K'uuj  }(j  }(j  Ksj  Kuj  }(j  Ksj  K'uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j+  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'sr: SymbolRefs) -> dict:h)j   u}(j  symj  K
j  }(j  }(j  Kuj  Kuj  }(j  Kuj  Kuuj  }(j  }(j  Kuj  Kuj  }(j  Kuj  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j8  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'sym = sr.symbolh)j   ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'X$  @pre(lambda sr: isinstance(sr, SymbolRefs))
@post(lambda result: "name" in result and "ref_count" in result)
def _symbol_refs_to_dict(sr: SymbolRefs) -> dict:
    """Convert SymbolRefs to dict."""
    sym = sr.symbol
    return {
        "file": sr.file_path,
        "name": sym.name,
        "kind": sym.kind.value,
        "line": sym.line,
        "signature": sym.signature,
        "ref_count": sr.ref_count,
        "docstring": sym.docstring,
        "contracts": [{"kind": c.kind, "expression": c.expression} for c in sym.contracts],
    }h)j  u}(j  format_signaturej  Kj  }(j  }(j  Kj  K uj  }(j  Kj  K-uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  symbolj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K#uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K#uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jR  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh''symbol: Symbol, file_path: str) -> str:h)jG  u}(j  	file_pathj  K
j  }(j  }(j  Kj  K%uj  }(j  Kj  K3uuj  }(j  }(j  Kj  K%uj  }(j  Kj  K3uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j_  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'file_path: str) -> str:h)jG  u}(j  sigj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jl  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'sig = symbol.signature or ""h)jG  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jI  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'X  @pre(lambda symbol, file_path: isinstance(symbol, Symbol))
def format_signature(symbol: Symbol, file_path: str) -> str:
    """
    Format a single symbol signature.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     signature="(x: int) -> int")
        >>> format_signature(sym, "test.py")
        'test.py::foo(x: int) -> int'
    """
    sig = symbol.signature or ""
    return f"{file_path}::{symbol.name}{sig}"h)j  u}(j  format_signatures_textj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  symbolsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K0uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K0uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'.symbols: list[Symbol], file_path: str) -> str:h)j{  u}(j  	file_pathj  K
j  }(j  }(j  Kj  K2uj  }(j  Kj  K@uuj  }(j  }(j  Kj  K2uj  }(j  Kj  K@uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'file_path: str) -> str:h)j{  u}(j  linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'=lines = [format_signature(sym, file_path) for sym in symbols]h)j{  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j}  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'X  @pre(lambda symbols, file_path: isinstance(symbols, list))
def format_signatures_text(symbols: list[Symbol], file_path: str) -> str:
    """
    Format multiple signatures as text.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> format_signatures_text([sym], "test.py")
        'test.py::foo'
    """
    lines = [format_signature(sym, file_path) for sym in symbols]
    return "\n".join(lines)h)j  u}(j  format_signatures_jsonj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  symbolsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K0uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K0uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'/symbols: list[Symbol], file_path: str) -> dict:h)j  u}(j  	file_pathj  K
j  }(j  }(j  Kj  K2uj  }(j  Kj  K@uuj  }(j  }(j  Kj  K2uj  }(j  Kj  K@uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'file_path: str) -> dict:h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'Xw  @pre(lambda symbols, file_path: isinstance(symbols, list))
def format_signatures_json(symbols: list[Symbol], file_path: str) -> dict:
    """
    Format signatures as JSON-serializable dict.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> d = format_signatures_json([sym], "test.py")
        >>> d["file"]
        'test.py'
    """
    return {
        "file": file_path,
        "symbols": [
            {
                "name": sym.name,
                "kind": sym.kind.value,
                "line": sym.line,
                "signature": sym.signature,
                "docstring": sym.docstring,
                "contracts": [{"kind": c.kind, "expression": c.expression} for c in sym.contracts],
            }
            for sym in symbols
        ],
    }h)j  u}(j  format_guard_agentj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]}(j  reportj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K*uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K*uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'report: GuardReport) -> dict:h)j  uah}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'XQ  @pre(lambda report: isinstance(report, GuardReport))
def format_guard_agent(report: GuardReport) -> dict:
    """
    Format Guard report for Agent consumption (Phase 8.2).

    Provides structured output with actionable fix instructions.

    Examples:
        >>> from invar.core.models import GuardReport, Violation, Severity
        >>> report = GuardReport(files_checked=1)
        >>> v = Violation(rule="missing_contract", severity=Severity.WARNING,
        ...     file="test.py", line=10, message="Function 'foo' has no contract",
        ...     suggestion="Add: @pre(lambda x: x >= 0)")
        >>> report.add_violation(v)
        >>> d = format_guard_agent(report)
        >>> d["status"]
        'passed'
        >>> len(d["fixes"])
        1
    """
    return {
        "status": "passed" if report.passed else "failed",
        "summary": {
            "files_checked": report.files_checked,
            "errors": report.errors,
            "warnings": report.warnings,
            "infos": report.infos,
        },
        "fixes": [_violation_to_fix(v) for v in report.violations],
    }h)j  u}(j  _violation_to_fixj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  vj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K"uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K"uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'v: Violation) -> dict:h)j  u}(j  fix_infoj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'Lfix_info = _parse_suggestion(v.suggestion, v.rule) if v.suggestion else Noneh)j  u}(j  resultj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'result: dict = {h)j  u}(j  metaj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'meta = get_rule_meta(v.rule)h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'X  @pre(lambda v: isinstance(v, Violation))
def _violation_to_fix(v: Violation) -> dict:
    """Convert a Violation to an Agent-friendly fix instruction."""
    from invar.core.rule_meta import get_rule_meta

    fix_info = _parse_suggestion(v.suggestion, v.rule) if v.suggestion else None

    # Phase 9.2 P3: Include rule metadata
    result: dict = {
        "file": v.file,
        "line": v.line,
        "rule": v.rule,
        "severity": v.severity.value,
        "message": v.message,
        "fix": fix_info,
    }

    meta = get_rule_meta(v.rule)
    if meta:
        result["rule_meta"] = {
            "category": meta.category.value,
            "detects": meta.detects,
            "cannot_detect": list(meta.cannot_detect),
            "hint": meta.hint,
        }

    return resulth)j  u}(j  _parse_suggestionj  Kj  }(j  }(j  Kj  K uj  }(j  Mj  K:uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  
suggestionj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K,uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K,uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j<  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'2suggestion: str | None, rule: str) -> dict | None:h)j1  u}(j  rulej  K
j  }(j  }(j  Kj  K.uj  }(j  Kj  K7uuj  }(j  }(j  Kj  K.uj  }(j  Kj  K7uuj  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jI  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'rule: str) -> dict | None:h)j1  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j3  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&j	  uh'X{  @pre(lambda suggestion, rule: suggestion is None or isinstance(suggestion, str))
def _parse_suggestion(suggestion: str | None, rule: str) -> dict | None:
    """Parse suggestion string into structured fix instruction."""
    if not suggestion:
        return None

    # Parse "Add: @pre(...)" style suggestions
    if suggestion.startswith("Add: "):
        return {"action": "add_decorator", "code": suggestion[5:]}

    # Parse "Replace with: @pre(...)" style suggestions
    if suggestion.startswith("Replace with: "):
        return {"action": "replace_decorator", "code": suggestion[14:]}

    # Parse "Replace with business logic: @pre(...)" style
    if suggestion.startswith("Replace with business logic: "):
        return {"action": "replace_decorator", "code": suggestion[29:]}

    # Default: return as instruction text
    return {"action": "manual", "instruction": suggestion}h)j  ueh)j  u}(j  suggestionsj  j  h#}(j  }(j  K j  K uj  }(j  MDj  K uuj  jZ  h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jZ  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&src/invar/core/suggestions.pyuj  ](}(nameCONSTRAINT_PATTERNSkindKrange}(start}(lineK	characterK uend}(jj  Kjk  KuuselectionRange}(jh  }(jj  Kjk  K ujl  }(jj  Kjk  Kuuchildren]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jg  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&src/invar/core/suggestions.pyuh'-CONSTRAINT_PATTERNS: dict[str, list[str]] = {h)jX  u}(jc  generate_contract_suggestionje  Kjf  }(jh  }(jj  K$jk  K ujl  }(jj  KOjk  K:uujn  }(jh  }(jj  K%jk  Kujl  }(jj  K%jk  K uujr  ](}(jc  	signatureje  K
jf  }(jh  }(jj  K%jk  K!ujl  }(jj  K%jk  K/uujn  }(jh  }(jj  K%jk  K!ujl  }(jj  K%jk  K/uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'signature: str) -> str:h)jy  u}(jc  paramsje  K
jf  }(jh  }(jj  K:jk  Kujl  }(jj  K:jk  K
uujn  }(jh  }(jj  K:jk  Kujl  }(jj  K:jk  K
uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'#params = _extract_params(signature)h)jy  u}(jc  constraintsje  K
jf  }(jh  }(jj  K>jk  Kujl  }(jj  K>jk  Kuujn  }(jh  }(jj  K>jk  Kujl  }(jj  K>jk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'constraints = []h)jy  u}(jc  param_namesje  K
jf  }(jh  }(jj  K?jk  Kujl  }(jj  K?jk  Kuujn  }(jh  }(jj  K?jk  Kujl  }(jj  K?jk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'param_names = []h)jy  u}(jc  nameje  K
jf  }(jh  }(jj  KAjk  Kujl  }(jj  KAjk  Kuujn  }(jh  }(jj  KAjk  Kujl  }(jj  KAjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'name, type_hint in params:h)jy  u}(jc  	type_hintje  K
jf  }(jh  }(jj  KAjk  Kujl  }(jj  KAjk  Kuujn  }(jh  }(jj  KAjk  Kujl  }(jj  KAjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'type_hint in params:h)jy  u}(jc  
constraintje  K
jf  }(jh  }(jj  KFjk  Kujl  }(jj  KFjk  Kuujn  }(jh  }(jj  KFjk  Kujl  }(jj  KFjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'1constraint = _suggest_constraint(name, type_hint)h)jy  u}(jc  
params_strje  K
jf  }(jh  }(jj  KMjk  Kujl  }(jj  KMjk  Kuujn  }(jh  }(jj  KMjk  Kujl  }(jj  KMjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'#params_str = ", ".join(param_names)h)jy  u}(jc  constraints_strje  K
jf  }(jh  }(jj  KNjk  Kujl  }(jj  KNjk  Kuujn  }(jh  }(jj  KNjk  Kujl  }(jj  KNjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'+constraints_str = " and ".join(constraints)h)jy  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j{  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'X  @pre(lambda signature: signature.startswith("(") or signature == "")
def generate_contract_suggestion(signature: str) -> str:
    """
    Generate a suggested @pre contract based on function signature.

    Uses common patterns:
    - int/float: param >= 0
    - str/list/dict/set/tuple: len(param) > 0
    - Optional/None union: param is not None

    Examples:
        >>> generate_contract_suggestion("(x: int, y: int) -> int")
        '@pre(lambda x, y: x >= 0 and y >= 0)'
        >>> generate_contract_suggestion("(name: str) -> bool")
        '@pre(lambda name: len(name) > 0)'
        >>> generate_contract_suggestion("(items: list[int]) -> int")
        '@pre(lambda items: len(items) > 0)'
        >>> generate_contract_suggestion("(x, y)")
        ''
        >>> generate_contract_suggestion("(value: Optional[str]) -> str")
        '@pre(lambda value: value is not None)'
    """
    params = _extract_params(signature)
    if not params:
        return ""

    constraints = []
    param_names = []

    for name, type_hint in params:
        param_names.append(name)
        if not type_hint:
            continue

        constraint = _suggest_constraint(name, type_hint)
        if constraint:
            constraints.append(constraint)

    if not constraints:
        return ""

    params_str = ", ".join(param_names)
    constraints_str = " and ".join(constraints)
    return f"@pre(lambda {params_str}: {constraints_str})"h)jX  u}(jc  _extract_paramsje  Kjf  }(jh  }(jj  KRjk  K ujl  }(jj  Kxjk  Kuujn  }(jh  }(jj  KSjk  Kujl  }(jj  KSjk  Kuujr  ](}(jc  	signatureje  K
jf  }(jh  }(jj  KSjk  Kujl  }(jj  KSjk  K"uujn  }(jh  }(jj  KSjk  Kujl  }(jj  KSjk  K"uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'0signature: str) -> list[tuple[str, str | None]]:h)j  u}(jc  matchje  K
jf  }(jh  }(jj  Kbjk  Kujl  }(jj  Kbjk  K	uujn  }(jh  }(jj  Kbjk  Kujl  }(jj  Kbjk  K	uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'+match = re.match(r"\(([^)]*)\)", signature)h)j  u}(jc  paramsje  K
jf  }(jh  }(jj  Kfjk  Kujl  }(jj  Kfjk  K
uujn  }(jh  }(jj  Kfjk  Kujl  }(jj  Kfjk  K
uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j   h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'params = []h)j  u}(jc  paramje  K
jf  }(jh  }(jj  Kgjk  Kujl  }(jj  Kgjk  K
uujn  }(jh  }(jj  Kgjk  Kujl  }(jj  Kgjk  K
uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j-  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'#param in match.group(1).split(","):h)j  u}(jc  nameje  K
jf  }(jh  }(jj  Kmjk  Kujl  }(jj  Kmjk  Kuujn  }(jh  }(jj  Kmjk  Kujl  }(jj  Kmjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j:  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'&name, type_hint = param.split(": ", 1)h)j  u}(jc  	type_hintje  K
jf  }(jh  }(jj  Kmjk  Kujl  }(jj  Kmjk  Kuujn  }(jh  }(jj  Kmjk  Kujl  }(jj  Kmjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jG  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh' type_hint = param.split(": ", 1)h)j  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'X  @pre(lambda signature: signature.startswith("(") or signature == "")
def _extract_params(signature: str) -> list[tuple[str, str | None]]:
    """
    Extract parameters and their types from a signature.

    Examples:
        >>> _extract_params("(x: int, y: str) -> bool")
        [('x', 'int'), ('y', 'str')]
        >>> _extract_params("(x, y)")
        [('x', None), ('y', None)]
        >>> _extract_params("(items: list[int], n: int = 10) -> list")
        [('items', 'list[int]'), ('n', 'int')]
    """
    if not signature:
        return []

    match = re.match(r"\(([^)]*)\)", signature)
    if not match:
        return []

    params = []
    for param in match.group(1).split(","):
        param = param.strip()
        if not param:
            continue

        if ": " in param:
            name, type_hint = param.split(": ", 1)
            # Handle default values
            if "=" in type_hint:
                type_hint = type_hint.split("=")[0].strip()
            params.append((name.strip(), type_hint.strip()))
        else:
            # No type annotation
            if "=" in param:
                param = param.split("=")[0].strip()
            params.append((param, None))

    return paramsh)jX  u}(jc  _suggest_constraintje  Kjf  }(jh  }(jj  K{jk  K ujl  }(jj  Kjk  Kuujn  }(jh  }(jj  K|jk  Kujl  }(jj  K|jk  Kuujr  ](}(jc  nameje  K
jf  }(jh  }(jj  K|jk  Kujl  }(jj  K|jk  K!uujn  }(jh  }(jj  K|jk  Kujl  }(jj  K|jk  K!uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#ja  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh')name: str, type_hint: str) -> str | None:h)jV  u}(jc  	type_hintje  K
jf  }(jh  }(jj  K|jk  K#ujl  }(jj  K|jk  K1uujn  }(jh  }(jj  K|jk  K#ujl  }(jj  K|jk  K1uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jn  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'type_hint: str) -> str | None:h)jV  u}(jc  
base_matchje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j{  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'=base_match = re.match(r"^(list|dict|set|tuple)\[", type_hint)h)jV  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jX  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'X  @pre(lambda name, type_hint: len(name) > 0 and len(type_hint) > 0)
def _suggest_constraint(name: str, type_hint: str) -> str | None:
    """
    Suggest a constraint for a parameter based on its type.

    Examples:
        >>> _suggest_constraint("x", "int")
        'x >= 0'
        >>> _suggest_constraint("name", "str")
        'len(name) > 0'
        >>> _suggest_constraint("items", "list[str]")
        'len(items) > 0'
        >>> _suggest_constraint("value", "Optional[int]")
        'value is not None'
        >>> _suggest_constraint("x", "SomeCustomType")
    """
    # Numeric types: suggest non-negative
    if type_hint in ("int", "float"):
        return f"{name} >= 0"

    # Collection types: suggest non-empty
    if type_hint in ("str", "list", "dict", "set", "tuple", "bytes"):
        return f"len({name}) > 0"

    # Generic collections: list[X], dict[K, V], etc.
    base_match = re.match(r"^(list|dict|set|tuple)\[", type_hint)
    if base_match:
        return f"len({name}) > 0"

    # Optional types: suggest not None
    if type_hint.startswith("Optional[") or " | None" in type_hint or "None |" in type_hint:
        return f"{name} is not None"

    return Noneh)jX  u}(jc  _get_pattern_alternativesje  Kjf  }(jh  }(jj  Kjk  K ujl  }(jj  Kjk  K
uujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ](}(jc  nameje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  K'uujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  K'uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'(name: str, type_hint: str) -> list[str]:h)j  u}(jc  	type_hintje  K
jf  }(jh  }(jj  Kjk  K)ujl  }(jj  Kjk  K7uujn  }(jh  }(jj  Kjk  K)ujl  }(jj  Kjk  K7uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'type_hint: str) -> list[str]:h)j  u}(jc  
base_matchje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'=base_match = re.match(r"^(list|dict|set|tuple)\[", type_hint)h)j  u}(jc  	base_typeje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'base_type = base_match.group(1)h)j  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'X#  @pre(lambda name, type_hint: len(name) > 0 and len(type_hint) > 0)
def _get_pattern_alternatives(name: str, type_hint: str) -> list[str]:
    """
    Get multiple constraint pattern alternatives for a parameter (P27).

    Returns up to 3 common patterns for the type.

    Examples:
        >>> _get_pattern_alternatives("x", "int")
        ['x >= 0', 'x > 0', 'x != 0']
        >>> _get_pattern_alternatives("name", "str")
        ['len(name) > 0', 'name', 'name.strip()']
        >>> _get_pattern_alternatives("value", "Optional[int]")
        ['value is not None', 'value']
        >>> _get_pattern_alternatives("x", "CustomType")
        []
    """
    # Check exact type matches
    if type_hint in CONSTRAINT_PATTERNS:
        return [p.format(name=name) for p in CONSTRAINT_PATTERNS[type_hint]]

    # Generic collections: list[X], dict[K, V], etc.
    base_match = re.match(r"^(list|dict|set|tuple)\[", type_hint)
    if base_match:
        base_type = base_match.group(1)
        if base_type in CONSTRAINT_PATTERNS:
            return [p.format(name=name) for p in CONSTRAINT_PATTERNS[base_type]]

    # Optional types
    if type_hint.startswith("Optional[") or " | None" in type_hint or "None |" in type_hint:
        return [p.format(name=name) for p in CONSTRAINT_PATTERNS["Optional"]]

    return []h)jX  u}(jc  generate_pattern_optionsje  Kjf  }(jh  }(jj  Kjk  K ujl  }(jj  Kjk  K1uujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ](}(jc  	signatureje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  K+uujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  K+uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'signature: str) -> str:h)j  u}(jc  paramsje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  K
uujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  K
uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'#params = _extract_params(signature)h)j  u}(jc  all_patternsje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'all_patterns: list[str] = []h)j  u}(jc  nameje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'name, type_hint in params:h)j  u}(jc  	type_hintje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j
  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'type_hint in params:h)j  u}(jc  patternsje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'5patterns = _get_pattern_alternatives(name, type_hint)h)j  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'X  @pre(lambda signature: signature.startswith("(") or signature == "")
def generate_pattern_options(signature: str) -> str:
    """
    Generate multiple constraint pattern options for each parameter (P27).

    Returns a formatted string showing alternatives for each typed parameter.

    Examples:
        >>> generate_pattern_options("(x: int, y: str) -> int")
        'Patterns: x >= 0 | x > 0 | x != 0, len(y) > 0 | y | y.strip()'
        >>> generate_pattern_options("(data, config)")
        ''
    """
    params = _extract_params(signature)
    if not params:
        return ""

    all_patterns: list[str] = []
    for name, type_hint in params:
        if not type_hint:
            continue
        patterns = _get_pattern_alternatives(name, type_hint)
        if patterns:
            all_patterns.append(" | ".join(patterns))

    if not all_patterns:
        return ""

    return f"Patterns: {', '.join(all_patterns)}"h)jX  u}(jc  _generate_lambda_skeletonje  Kjf  }(jh  }(jj  Kjk  K ujl  }(jj  Kjk  KYuujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ](}(jc  	signatureje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  K,uujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  K,uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j1  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'signature: str) -> str:h)j&  u}(jc  paramsje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  K
uujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  K
uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j>  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'#params = _extract_params(signature)h)j&  u}(jc  param_namesje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jK  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'*param_names = [name for name, _ in params]h)j&  u}(jc  
params_strje  K
jf  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jX  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'#params_str = ", ".join(param_names)h)j&  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j(  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'X{  def _generate_lambda_skeleton(signature: str) -> str:
    """
    Generate a lambda skeleton from function signature (P4).

    Returns skeleton with parameters extracted, condition placeholder.

    Examples:
        >>> _generate_lambda_skeleton("(x: int, y: int) -> int")
        '@pre(lambda x, y: <condition>) or @post(lambda result: <condition>)'
        >>> _generate_lambda_skeleton("(items: list) -> None")
        '@pre(lambda items: <condition>) or @post(lambda result: <condition>)'
        >>> _generate_lambda_skeleton("() -> int")
        '@post(lambda result: <condition>)'
    """
    params = _extract_params(signature)
    param_names = [name for name, _ in params]

    if not param_names:
        return "@post(lambda result: <condition>)"

    params_str = ", ".join(param_names)
    return f"@pre(lambda {params_str}: <condition>) or @post(lambda result: <condition>)"h)jX  u}(jc  format_suggestion_for_violationje  Kjf  }(jh  }(jj  Kjk  K ujl  }(jj  MBjk  K
uujn  }(jh  }(jj  Kjk  Kujl  }(jj  Kjk  K#uujr  ](}(jc  symbolje  K
jf  }(jh  }(jj  Kjk  K$ujl  }(jj  Kjk  K2uujn  }(jh  }(jj  Kjk  K$ujl  }(jj  Kjk  K2uujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jr  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh',symbol: Symbol, violation_type: str) -> str:h)jg  u}(jc  violation_typeje  K
jf  }(jh  }(jj  Kjk  K4ujl  }(jj  Kjk  KGuujn  }(jh  }(jj  Kjk  K4ujl  }(jj  Kjk  KGuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'violation_type: str) -> str:h)jg  u}(jc  patternsje  K
jf  }(jh  }(jj  Mjk  Kujl  }(jj  Mjk  Kuujn  }(jh  }(jj  Mjk  Kujl  }(jj  Mjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'5patterns = generate_pattern_options(symbol.signature)h)jg  u}(jc  
suggestionje  K
jf  }(jh  }(jj  Mjk  Kujl  }(jj  Mjk  Kuujn  }(jh  }(jj  Mjk  Kujl  }(jj  Mjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh';suggestion = generate_contract_suggestion(symbol.signature)h)jg  u}(jc  resultje  K
jf  }(jh  }(jj  Mjk  Kujl  }(jj  Mjk  Kuujn  }(jh  }(jj  Mjk  Kujl  }(jj  Mjk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'result = f"Add: {suggestion}"h)jg  u}(jc  skeletonje  K
jf  }(jh  }(jj  M jk  Kujl  }(jj  M jk  Kuujn  }(jh  }(jj  M jk  Kujl  }(jj  M jk  Kuujr  ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'6skeleton = _generate_lambda_skeleton(symbol.signature)h)jg  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#ji  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&jw  uh'X  @pre(lambda symbol, violation_type: violation_type in ("missing_contract", "empty_contract", "redundant_type_contract", "semantic_tautology", ""))
def format_suggestion_for_violation(symbol: Symbol, violation_type: str) -> str:
    """
    Format a complete suggestion message for a violation.

    Phase 9.2 P4: Generate lambda skeletons when no type-based suggestion available.
    P7: Added semantic_tautology support.
    P27: Show pattern alternatives (Guard provides options, Agent decides).

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind
        >>> sym = Symbol(name="calc", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     signature="(x: int, y: int) -> int")
        >>> msg = format_suggestion_for_violation(sym, "missing_contract")
        >>> "@pre(lambda x, y: x >= 0 and y >= 0)" in msg
        True
        >>> "Patterns:" in msg  # P27: shows alternatives
        True
        >>> # P4: skeleton when no type-based suggestion
        >>> sym2 = Symbol(name="process", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     signature="(data, config)")
        >>> msg2 = format_suggestion_for_violation(sym2, "missing_contract")
        >>> "@pre(lambda data, config: <condition>)" in msg2
        True
    """
    if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD):
        return ""

    # P27: Get pattern alternatives
    patterns = generate_pattern_options(symbol.signature)

    if violation_type == "missing_contract":
        suggestion = generate_contract_suggestion(symbol.signature)
        if suggestion:
            result = f"Add: {suggestion}"
            if patterns:
                result += f"\n{patterns}"
            return result
        # P4: Generate lambda skeleton when no type-based suggestion
        skeleton = _generate_lambda_skeleton(symbol.signature)
        return f"Add: {skeleton}"

    if violation_type == "empty_contract":
        suggestion = generate_contract_suggestion(symbol.signature)
        if suggestion:
            result = f"Replace with: {suggestion}"
            if patterns:
                result += f"\n{patterns}"
            return result
        skeleton = _generate_lambda_skeleton(symbol.signature)
        return f"Replace with: {skeleton}"

    if violation_type == "redundant_type_contract":
        suggestion = generate_contract_suggestion(symbol.signature)
        if suggestion:
            result = f"Replace with business logic: {suggestion}"
            if patterns:
                result += f"\n{patterns}"
            return result
        skeleton = _generate_lambda_skeleton(symbol.signature)
        return f"Replace with: {skeleton}"

    if violation_type == "semantic_tautology":
        # P7: Semantic tautology - suggest meaningful constraint
        suggestion = generate_contract_suggestion(symbol.signature)
        if suggestion:
            result = f"Replace tautology with meaningful constraint: {suggestion}"
            if patterns:
                result += f"\n{patterns}"
            return result
        skeleton = _generate_lambda_skeleton(symbol.signature)
        return f"Replace tautology with: {skeleton}"

    return ""h)jX  ueh)j  u}(j  modelsj  j  h#}(j  }(j  K j  K uj  }(j  Mj  K uuj  j  h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&src/invar/core/models.pyuj  ](}(name
SymbolKindkindKrange}(start}(lineK	characterK uend}(j  Kj  KuuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  FUNCTIONj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&src/invar/core/models.pyuh'FUNCTION = "function"h)j  u}(j  CLASSj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'CLASS = "class"h)j  u}(j  METHODj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'METHOD = "method"h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'class SymbolKind(str, Enum):
    """Kind of symbol extracted from Python code."""

    FUNCTION = "function"
    CLASS = "class"
    METHOD = "method"h)j  u}(j  Severityj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  ERRORj  Kj  }(j  }(j       Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'ERROR = "error"h)j
  u}(j  WARNINGj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j"  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'WARNING = "warning"h)j
  u}(j  INFOj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j/  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'PINFO = "info"  # Phase 7: For informational issues like redundant type contractsh)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'class Severity(str, Enum):
    """Severity level for violations."""

    ERROR = "error"
    WARNING = "warning"
    INFO = "info"  # Phase 7: For informational issues like redundant type contractsh)j  u}(j  Contractj  Kj  }(j  }(j  K j  K uj  }(j  K%j  K
uuj  }(j  }(j  K j  Kuj  }(j  K j  Kuuj  ](}(j  kindj  K
j  }(j  }(j  K#j  Kuj  }(j  K#j  Kuuj  }(j  }(j  K#j  Kuj  }(j  K#j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jI  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'kind: Literal["pre", "post"]h)j>  u}(j  
expressionj  K
j  }(j  }(j  K$j  Kuj  }(j  K$j  Kuuj  }(j  }(j  K$j  Kuj  }(j  K$j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jV  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'expression: strh)j>  u}(j  linej  K
j  }(j  }(j  K%j  Kuj  }(j  K%j  Kuuj  }(j  }(j  K%j  Kuj  }(j  K%j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jc  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	line: inth)j>  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j@  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'class Contract(BaseModel):
    """A contract (precondition or postcondition) on a function."""

    kind: Literal["pre", "post"]
    expression: str
    line: inth)j  u}(j  Symbolj  Kj  }(j  }(j  K(j  K uj  }(j  K:j  K;uuj  }(j  }(j  K(j  Kuj  }(j  K(j  Kuuj  ](}(j  namej  K
j  }(j  }(j  K+j  Kuj  }(j  K+j  Kuuj  }(j  }(j  K+j  Kuj  }(j  K+j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j}  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	name: strh)jr  u}(j  kindj  K
j  }(j  }(j  K,j  Kuj  }(j  K,j  Kuuj  }(j  }(j  K,j  Kuj  }(j  K,j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'kind: SymbolKindh)jr  u}(j  linej  K
j  }(j  }(j  K-j  Kuj  }(j  K-j  Kuuj  }(j  }(j  K-j  Kuj  }(j  K-j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	line: inth)jr  u}(j  end_linej  K
j  }(j  }(j  K.j  Kuj  }(j  K.j  Kuuj  }(j  }(j  K.j  Kuj  }(j  K.j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'
end_line: inth)jr  u}(j  	signaturej  K
j  }(j  }(j  K/j  Kuj  }(j  K/j  K
uuj  }(j  }(j  K/j  Kuj  }(j  K/j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'signature: str = ""h)jr  u}(j  	docstringj  K
j  }(j  }(j  K0j  Kuj  }(j  K0j  K
uuj  }(j  }(j  K0j  Kuj  }(j  K0j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'docstring: str | None = Noneh)jr  u}(j  	contractsj  K
j  }(j  }(j  K1j  Kuj  }(j  K1j  K
uuj  }(j  }(j  K1j  Kuj  }(j  K1j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'7contracts: list[Contract] = Field(default_factory=list)h)jr  u}(j  has_doctestj  K
j  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'has_doctest: bool = Falseh)jr  u}(j  internal_importsj  K
j  }(j  }(j  K4j  Kuj  }(j  K4j  Kuuj  }(j  }(j  K4j  Kuj  }(j  K4j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'9internal_imports: list[str] = Field(default_factory=list)h)jr  u}(j  impure_callsj  K
j  }(j  }(j  K5j  Kuj  }(j  K5j  Kuuj  }(j  }(j  K5j  Kuj  }(j  K5j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'5impure_calls: list[str] = Field(default_factory=list)h)jr  u}(j  
code_linesj  K
j  }(j  }(j  K6j  Kuj  }(j  K6j  Kuuj  }(j  }(j  K6j  Kuj  }(j  K6j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Ccode_lines: int | None = None  # Lines excluding docstring/commentsh)jr  u}(j  
doctest_linesj  K
j  }(j  }(j  K8j  Kuj  }(j  K8j  Kuuj  }(j  }(j  K8j  Kuj  }(j  K8j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Cdoctest_lines: int = 0  # Number of lines that are doctest examplesh)jr  u}(j  function_callsj  K
j  }(j  }(j  K:j  Kuj  }(j  K:j  Kuuj  }(j  }(j  K:j  Kuj  }(j  K:j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'`function_calls: list[str] = Field(default_factory=list)  # Functions called within this functionh)jr  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jt  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  class Symbol(BaseModel):
    """A symbol extracted from Python source code."""

    name: str
    kind: SymbolKind
    line: int
    end_line: int
    signature: str = ""
    docstring: str | None = None
    contracts: list[Contract] = Field(default_factory=list)
    has_doctest: bool = False
    # Phase 3: Guard Enhancement
    internal_imports: list[str] = Field(default_factory=list)
    impure_calls: list[str] = Field(default_factory=list)
    code_lines: int | None = None  # Lines excluding docstring/comments
    # Phase 6: Verification Completeness
    doctest_lines: int = 0  # Number of lines that are doctest examples
    # Phase 11 P25: For extraction analysis
    function_calls: list[str] = Field(default_factory=list)  # Functions called within this functionh)j  u}(j  FileInfoj  Kj  }(j  }(j  K=j  K uj  }(j  KEj  Kuuj  }(j  }(j  K=j  Kuj  }(j  K=j  Kuuj  ](}(j  pathj  K
j  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j3  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	path: strh)j(  u}(j  linesj  K
j  }(j  }(j  KAj  Kuj  }(j  KAj  K	uuj  }(j  }(j  KAj  Kuj  }(j  KAj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j@  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'
lines: inth)j(  u}(j  symbolsj  K
j  }(j  }(j  KBj  Kuj  }(j  KBj  Kuuj  }(j  }(j  KBj  Kuj  }(j  KBj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jM  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'3symbols: list[Symbol] = Field(default_factory=list)h)j(  u}(j  importsj  K
j  }(j  }(j  KCj  Kuj  }(j  KCj  Kuuj  }(j  }(j  KCj  Kuj  }(j  KCj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jZ  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'0imports: list[str] = Field(default_factory=list)h)j(  u}(j  is_corej  K
j  }(j  }(j  KDj  Kuj  }(j  KDj  Kuuj  }(j  }(j  KDj  Kuj  }(j  KDj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jg  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'is_core: bool = Falseh)j(  u}(j  is_shellj  K
j  }(j  }(j  KEj  Kuj  }(j  KEj  Kuuj  }(j  }(j  KEj  Kuj  }(j  KEj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jt  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'is_shell: bool = Falseh)j(  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j*  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  class FileInfo(BaseModel):
    """Information about a Python file."""

    path: str
    lines: int
    symbols: list[Symbol] = Field(default_factory=list)
    imports: list[str] = Field(default_factory=list)
    is_core: bool = False
    is_shell: bool = Falseh)j  u}(j  	Violationj  Kj  }(j  }(j  KHj  K uj  }(j  KPj  K!uuj  }(j  }(j  KHj  Kuj  }(j  KHj  Kuuj  ](}(j  rulej  K
j  }(j  }(j  KKj  Kuj  }(j  KKj  Kuuj  }(j  }(j  KKj  Kuj  }(j  KKj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	rule: strh)j  u}(j  severityj  K
j  }(j  }(j  KLj  Kuj  }(j  KLj  Kuuj  }(j  }(j  KLj  Kuj  }(j  KLj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'severity: Severityh)j  u}(j  filej  K
j  }(j  }(j  KMj  Kuj  }(j  KMj  Kuuj  }(j  }(j  KMj  Kuj  }(j  KMj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	file: strh)j  u}(j  linej  K
j  }(j  }(j  KNj  Kuj  }(j  KNj  Kuuj  }(j  }(j  KNj  Kuj  }(j  KNj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'line: int | None = Noneh)j  u}(j  messagej  K
j  }(j  }(j  KOj  Kuj  }(j  KOj  Kuuj  }(j  }(j  KOj  Kuj  }(j  KOj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'message: strh)j  u}(j  
suggestionj  K
j  }(j  }(j  KPj  Kuj  }(j  KPj  Kuuj  }(j  }(j  KPj  Kuj  }(j  KPj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'suggestion: str | None = Noneh)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'class Violation(BaseModel):
    """A rule violation found by Guard."""

    rule: str
    severity: Severity
    file: str
    line: int | None = None
    message: str
    suggestion: str | None = Noneh)j  u}(j  GuardReportj  Kj  }(j  }(j  KSj  K uj  }(j  Kj  Kuuj  }(j  }(j  KSj  Kuj  }(j  KSj  Kuuj  ](}(j  
files_checkedj  K
j  }(j  }(j  KVj  Kuj  }(j  KVj  Kuuj  }(j  }(j  KVj  Kuj  }(j  KVj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'files_checked: inth)j  u}(j  
violationsj  K
j  }(j  }(j  KWj  Kuj  }(j  KWj  Kuuj  }(j  }(j  KWj  Kuj  }(j  KWj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'9violations: list[Violation] = Field(default_factory=list)h)j  u}(j  errorsj  K
j  }(j  }(j  KXj  Kuj  }(j  KXj  K
uuj  }(j  }(j  KXj  Kuj  }(j  KXj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'errors: int = 0h)j  u}(j  warningsj  K
j  }(j  }(j  KYj  Kuj  }(j  KYj  Kuuj  }(j  }(j  KYj  Kuj  }(j  KYj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'warnings: int = 0h)j  u}(j  infosj  K
j  }(j  }(j  KZj  Kuj  }(j  KZj  K	uuj  }(j  }(j  KZj  Kuj  }(j  KZj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'2infos: int = 0  # Phase 7: Track INFO-level issuesh)j  u}(j  core_functions_totalj  K
j  }(j  }(j  K\j  Kuj  }(j  K\j  Kuuj  }(j  }(j  K\j  Kuj  }(j  K\j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j*	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'core_functions_total: int = 0h)j  u}(j  core_functions_with_contractsj  K
j  }(j  }(j  K]j  Kuj  }(j  K]j  K!uuj  }(j  }(j  K]j  Kuj  }(j  K]j  K!uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j7	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'&core_functions_with_contracts: int = 0h)j  u}(j  
add_violationj  Kj  }(j  }(j  K_j  Kuj  }(j  Krj  Kuuj  }(j  }(j  K`j  Kuj  }(j  K`j  Kuuj  ]}(j  	violationj  K
j  }(j  }(j  K`j  Kuj  }(j  K`j  K0uuj  }(j  }(j  K`j  Kuj  }(j  K`j  K0uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jM	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'violation: Violation) -> None:h)jB	  uah}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jD	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  @pre(lambda self, violation: isinstance(violation, Violation))
    def add_violation(self, violation: Violation) -> None:
        """
        Add a violation and update counts.

        Examples:
            >>> from invar.core.models import Violation, Severity, GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> v = Violation(rule="test", severity=Severity.ERROR, file="x.py", message="err")
            >>> report.add_violation(v)
            >>> report.errors
            1
        """
        self.violations.append(violation)
        if violation.severity == Severity.ERROR:
            self.errors += 1
        elif violation.severity == Severity.WARNING:
            self.warnings += 1
        else:
            self.infos += 1h)j  u}(j  update_coveragej  Kj  }(j  }(j  Ktj  Kuj  }(j  Kj  K<uuj  }(j  }(j  Kuj  Kuj  }(j  Kuj  Kuuj  ](}(j  totalj  K
j  }(j  }(j  Kuj  Kuj  }(j  Kuj  K(uuj  }(j  }(j  Kuj  Kuj  }(j  Kuj  K(uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jg	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh')total: int, with_contracts: int) -> None:h)j\	  u}(j  with_contractsj  K
j  }(j  }(j  Kuj  K*uj  }(j  Kuj  K=uuj  }(j  }(j  Kuj  K*uj  }(j  Kuj  K=uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jt	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'with_contracts: int) -> None:h)j\	  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j^	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Xv  @pre(lambda self, total, with_contracts: total >= 0 and with_contracts >= 0)
    def update_coverage(self, total: int, with_contracts: int) -> None:
        """
        Update contract coverage statistics (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.core_functions_total
            10
            >>> report.core_functions_with_contracts
            8
        """
        self.core_functions_total += total
        self.core_functions_with_contracts += with_contractsh)j  u}(j  contract_coverage_pctj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  KXuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X:  @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_coverage_pct(self) -> int:
        """
        Get contract coverage percentage (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.contract_coverage_pct
            80
        """
        if self.core_functions_total == 0:
            return 100
        return int(self.core_functions_with_contracts / self.core_functions_total * 100)h)j  u}(j  contract_issue_countsj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  countsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Ccounts = {"tautology": 0, "empty": 0, "partial": 0, "type_only": 0}h)j	  u}(j  j  j  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'v in self.violations:h)j	  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_issue_counts(self) -> dict[str, int]:
        """
        Count contract quality issues by type (P24).

        Examples:
            >>> from invar.core.models import GuardReport, Violation, Severity
            >>> report = GuardReport(files_checked=1)
            >>> v1 = Violation(rule="empty_contract", severity=Severity.WARNING, file="x.py", message="m")
            >>> v2 = Violation(rule="semantic_tautology", severity=Severity.WARNING, file="x.py", message="m")
            >>> report.add_violation(v1)
            >>> report.add_violation(v2)
            >>> report.contract_issue_counts
            {'tautology': 1, 'empty': 1, 'partial': 0, 'type_only': 0}
        """
        counts = {"tautology": 0, "empty": 0, "partial": 0, "type_only": 0}
        for v in self.violations:
            if v.rule == "semantic_tautology":
                counts["tautology"] += 1
            elif v.rule == "empty_contract":
                counts["empty"] += 1
            elif v.rule == "partial_contract":
                counts["partial"] += 1
            elif v.rule == "redundant_type_contract":
                counts["type_only"] += 1
        return countsh)j  u}(j  passedj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Xq  @property
    @pre(lambda self: isinstance(self, GuardReport))
    def passed(self) -> bool:
        """
        Check if guard passed (no errors).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.passed
            True
        """
        return self.errors == 0h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  class GuardReport(BaseModel):
    """Complete Guard report for a project."""

    files_checked: int
    violations: list[Violation] = Field(default_factory=list)
    errors: int = 0
    warnings: int = 0
    infos: int = 0  # Phase 7: Track INFO-level issues
    # P24: Contract coverage statistics (Core files only)
    core_functions_total: int = 0
    core_functions_with_contracts: int = 0

    @pre(lambda self, violation: isinstance(violation, Violation))
    def add_violation(self, violation: Violation) -> None:
        """
        Add a violation and update counts.

        Examples:
            >>> from invar.core.models import Violation, Severity, GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> v = Violation(rule="test", severity=Severity.ERROR, file="x.py", message="err")
            >>> report.add_violation(v)
            >>> report.errors
            1
        """
        self.violations.append(violation)
        if violation.severity == Severity.ERROR:
            self.errors += 1
        elif violation.severity == Severity.WARNING:
            self.warnings += 1
        else:
            self.infos += 1

    @pre(lambda self, total, with_contracts: total >= 0 and with_contracts >= 0)
    def update_coverage(self, total: int, with_contracts: int) -> None:
        """
        Update contract coverage statistics (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.core_functions_total
            10
            >>> report.core_functions_with_contracts
            8
        """
        self.core_functions_total += total
        self.core_functions_with_contracts += with_contracts

    @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_coverage_pct(self) -> int:
        """
        Get contract coverage percentage (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.contract_coverage_pct
            80
        """
        if self.core_functions_total == 0:
            return 100
        return int(self.core_functions_with_contracts / self.core_functions_total * 100)

    @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_issue_counts(self) -> dict[str, int]:
        """
        Count contract quality issues by type (P24).

        Examples:
            >>> from invar.core.models import GuardReport, Violation, Severity
            >>> report = GuardReport(files_checked=1)
            >>> v1 = Violation(rule="empty_contract", severity=Severity.WARNING, file="x.py", message="m")
            >>> v2 = Violation(rule="semantic_tautology", severity=Severity.WARNING, file="x.py", message="m")
            >>> report.add_violation(v1)
            >>> report.add_violation(v2)
            >>> report.contract_issue_counts
            {'tautology': 1, 'empty': 1, 'partial': 0, 'type_only': 0}
        """
        counts = {"tautology": 0, "empty": 0, "partial": 0, "type_only": 0}
        for v in self.violations:
            if v.rule == "semantic_tautology":
                counts["tautology"] += 1
            elif v.rule == "empty_contract":
                counts["empty"] += 1
            elif v.rule == "partial_contract":
                counts["partial"] += 1
            elif v.rule == "redundant_type_contract":
                counts["type_only"] += 1
        return counts

    @property
    @pre(lambda self: isinstance(self, GuardReport))
    def passed(self) -> bool:
        """
        Check if guard passed (no errors).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.passed
            True
        """
        return self.errors == 0h)j  u}(j  
RuleExclusionj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  patternj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'<pattern: str  # Glob pattern (fnmatch style with ** support)h)j	  u}(j  rulesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh';rules: list[str]  # Rule names to exclude, or ["*"] for allh)j	  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  class RuleExclusion(BaseModel):
    """
    A rule exclusion pattern for specific files.

    Examples:
        >>> excl = RuleExclusion(pattern="**/generated/**", rules=["*"])
        >>> excl.pattern
        '**/generated/**'
        >>> excl.rules
        ['*']
    """

    pattern: str  # Glob pattern (fnmatch style with ** support)
    rules: list[str]  # Rule names to exclude, or ["*"] for allh)j  u}(j  
RuleConfigj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  K'uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  max_file_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Jmax_file_lines: int = 500  # Phase 9 P1: Raised from 300 for less frictionh)j	  u}(j  max_function_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'max_function_lines: int = 50h)j	  u}(j  forbidden_importsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'&forbidden_imports: tuple[str, ...] = (h)j	  u}(j  require_contractsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j 
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'require_contracts: bool = Trueh)j	  u}(j  require_doctestsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j-
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'require_doctests: bool = Trueh)j	  u}(j  strict_purej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j:
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Dstrict_pure: bool = True  # Phase 9 P12: Default ON for agent-nativeh)j	  u}(j  use_code_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jG
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'use_code_lines: bool = Falseh)j	  u}(j  exclude_doctest_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jT
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'#exclude_doctest_lines: bool = Falseh)j	  u}(j  rule_exclusionsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#ja
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Brule_exclusions: list[RuleExclusion] = Field(default_factory=list)h)j	  u}(j  severity_overridesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jn
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Dseverity_overrides: dict[str, str] = Field(default_factory=lambda: {h)j	  u}(j  size_warning_thresholdj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j{
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'#size_warning_threshold: float = 0.8h)j	  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X$  class RuleConfig(BaseModel):
    """
    Configuration for rule checking.

    Examples:
        >>> config = RuleConfig()
        >>> config.max_file_lines  # Phase 9 P1: Raised from 300
        500
        >>> config.strict_pure  # Phase 9 P12: Default ON for agents
        True
    """

    max_file_lines: int = 500  # Phase 9 P1: Raised from 300 for less friction
    max_function_lines: int = 50
    forbidden_imports: tuple[str, ...] = (
        "os",
        "sys",
        "socket",
        "requests",
        "urllib",
        "subprocess",
        "shutil",
        "io",
        "pathlib",
    )
    require_contracts: bool = True
    require_doctests: bool = True
    strict_pure: bool = True  # Phase 9 P12: Default ON for agent-native
    use_code_lines: bool = False
    exclude_doctest_lines: bool = False
    # Phase 9 P1: Rule exclusions for specific file patterns
    rule_exclusions: list[RuleExclusion] = Field(default_factory=list)
    # Phase 9 P2: Per-rule severity overrides (off, info, warning, error)
    severity_overrides: dict[str, str] = Field(default_factory=lambda: {
        "redundant_type_contract": "off",  # Expected behavior when forcing contracts
    })
    # Phase 9 P8: File size warning threshold (0 to disable, 0.8 = warn at 80%)
    size_warning_threshold: float = 0.8h)j  u}(j  
SymbolRefsj  Kj  }(j  }(j  Kj  K uj  }(j  M
j  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  symbolj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  K
uuj  }(j  }(j  Mj  Kuj  }(j  Mj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'symbol: Symbolh)j
  u}(j  	file_pathj  K
j  }(j  }(j  M	j  Kuj  }(j  M	j  K
uuj  }(j  }(j  M	j  Kuj  }(j  M	j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'file_path: strh)j
  u}(j  	ref_countj  K
j  }(j  }(j  M
j  Kuj  }(j  M
j  K
uuj  }(j  }(j  M
j  Kuj  }(j  M
j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'ref_count: int = 0h)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  class SymbolRefs(BaseModel):
    """
    A symbol with its cross-file reference count.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind, SymbolRefs
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> sr = SymbolRefs(symbol=sym, file_path="core/calc.py", ref_count=10)
        >>> sr.ref_count
        10
    """

    symbol: Symbol
    file_path: str
    ref_count: int = 0h)j  u}(j  
PerceptionMapj  Kj  }(j  }(j  M
j  K uj  }(j  Mj  K;uuj  }(j  }(j  M
j  Kuj  }(j  M
j  Kuuj  ](}(j  project_rootj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'project_root: strh)j
  u}(j  total_filesj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'total_files: inth)j
  u}(j  
total_symbolsj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'total_symbols: inth)j
  u}(j  symbolsj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'7symbols: list[SymbolRefs] = Field(default_factory=list)h)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Xc  class PerceptionMap(BaseModel):
    """
    Complete perception map for a project.

    Examples:
        >>> pm = PerceptionMap(project_root="/test", total_files=5, total_symbols=20)
        >>> pm.total_files
        5
    """

    project_root: str
    total_files: int
    total_symbols: int
    symbols: list[SymbolRefs] = Field(default_factory=list)h)j  ueh)j  u}(j  purityj  j  h#}(j  }(j  K j  K uj  }(j  MRj  K uuj  j  h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&src/invar/core/purity.pyuj  ](}(nameIMPURE_FUNCTIONSkindKrange}(start}(lineK	characterK uend}(j  Kj  KuuselectionRange}(j  }(j  Kj  K uj  }(j  Kj  Kuuchildren]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&src/invar/core/purity.pyuh'IMPURE_FUNCTIONS: set[str] = {h)j
  u}(j
  IMPURE_PATTERNSj  Kj
  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j"  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh')IMPURE_PATTERNS: set[tuple[str, str]] = {h)j
  u}(j
  extract_internal_importsj  Kj
  }(j  }(j  K j  K uj  }(j  K<j  Kuuj  }(j  }(j  K!j  Kuj  }(j  K!j  Kuuj  ](}(j
  nodej  K
j
  }(j  }(j  K!j  Kuj  }(j  K!j  KIuuj  }(j  }(j  K!j  Kuj  }(j  K!j  KIuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j8  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh';node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:h)j-  u}(j
  importsj  K
j
  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jE  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'imports: list[str] = []h)j-  u}(j
  childj  K
j
  }(j  }(j  K4j  Kuj  }(j  K4j  K
uuj  }(j  }(j  K4j  Kuj  }(j  K4j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jR  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'child in ast.walk(node):h)j-  u}(j
  aliasj  K
j
  }(j  }(j  K6j  Kuj  }(j  K6j  Kuuj  }(j  }(j  K6j  Kuj  }(j  K6j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j_  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'alias in child.names:h)j-  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j/  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def extract_internal_imports(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:
    """
    Extract imports inside a function body.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     import os
        ...     from pathlib import Path
        ...     return Path(".")
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> sorted(extract_internal_imports(func))
        ['os', 'pathlib']
    """
    imports: list[str] = []

    for child in ast.walk(node):
        if isinstance(child, ast.Import):
            for alias in child.names:
                imports.append(alias.name.split(".")[0])
        elif isinstance(child, ast.ImportFrom):
            if child.module:
                imports.append(child.module.split(".")[0])

    return list(set(imports))h)j
  u}(j
  extract_impure_callsj  Kj
  }(j  }(j  K?j  K uj  }(j  KYj  Kuuj  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj  ](}(j
  nodej  K
j
  }(j  }(j  K@j  Kuj  }(j  K@j  KEuuj  }(j  }(j  K@j  Kuj  }(j  K@j  KEuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jy  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh';node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:h)jn  u}(j
  impurej  K
j
  }(j  }(j  KQj  Kuj  }(j  KQj  K
uuj  }(j  }(j  KQj  Kuj  }(j  KQj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'impure: list[str] = []h)jn  u}(j
  childj  K
j
  }(j  }(j  KSj  Kuj  }(j  KSj  K
uuj  }(j  }(j  KSj  Kuj  }(j  KSj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'child in ast.walk(node):h)jn  u}(j
  	call_namej  K
j
  }(j  }(j  KUj  Kuj  }(j  KUj  Kuuj  }(j  }(j  KUj  Kuj  }(j  KUj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'!call_name = _get_call_name(child)h)jn  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jp  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'XC  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def extract_impure_calls(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:
    """
    Extract calls to known impure functions.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     x = datetime.now()
        ...     print("hello")
        ...     return x
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> sorted(extract_impure_calls(func))
        ['datetime.now', 'print']
    """
    impure: list[str] = []

    for child in ast.walk(node):
        if isinstance(child, ast.Call):
            call_name = _get_call_name(child)
            if call_name and _is_impure_call(call_name):
                impure.append(call_name)

    return list(set(impure))h)j
  u}(j
  extract_function_callsj  Kj
  }(j  }(j  K\j  K uj  }(j  Kj  Kuuj  }(j  }(j  K]j  Kuj  }(j  K]j  Kuuj  ](}(j
  nodej  K
j
  }(j  }(j  K]j  Kuj  }(j  K]j  KGuuj  }(j  }(j  K]j  Kuj  }(j  K]j  KGuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh';node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:h)j  u}(j
  callsj  K
j
  }(j  }(j  K|j  Kuj  }(j  K|j  K	uuj  }(j  }(j  K|j  Kuj  }(j  K|j  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'calls: list[str] = []h)j  u}(j
  childj  K
j
  }(j  }(j  K~j  Kuj  }(j  K~j  K
uuj  }(j  }(j  K~j  Kuj  }(j  K~j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'child in ast.walk(node):h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'X5  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def extract_function_calls(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:
    """
    Extract all function calls from a function body (P25: for extraction analysis).

    Only extracts simple function calls (not method calls on objects).
    Used to build call graph for grouping related functions.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     helper()
        ...     result = calculate(x)
        ...     return result
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> sorted(extract_function_calls(func))
        ['calculate', 'helper']
        >>> # Method calls are excluded
        >>> code2 = '''
        ... def bar():
        ...     self.method()
        ...     obj.call()
        ...     helper()
        ... '''
        >>> tree2 = ast.parse(code2)
        >>> func2 = tree2.body[0]
        >>> extract_function_calls(func2)
        ['helper']
    """
    calls: list[str] = []

    for child in ast.walk(node):
        if isinstance(child, ast.Call):
            # Only simple function calls (not x.method())
            if isinstance(child.func, ast.Name):
                calls.append(child.func.id)

    return list(set(calls))h)j
  u}(j
  _get_call_namej  Kj
  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j
  callj  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  K!uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K!uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'call: ast.Call) -> str | None:h)j  u}(j
  funcj  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'func = call.funch)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'X  @pre(lambda call: isinstance(call, ast.Call))
def _get_call_name(call: ast.Call) -> str | None:
    """Get the name of a function call as a string."""
    func = call.func

    # Simple name: print(), open()
    if isinstance(func, ast.Name):
        return func.id

    # Attribute: datetime.now(), random.randint()
    if isinstance(func, ast.Attribute):
        if isinstance(func.value, ast.Name):
            return f"{func.value.id}.{func.attr}"

    return Noneh)j
  u}(j
  _is_impure_callj  Kj
  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j
  	call_namej  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  K"uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K"uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'call_name: str) -> bool:h)j
  u}(j
  partsj  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j"  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'parts = call_name.split(".")h)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'X  @pre(lambda call_name: isinstance(call_name, str) and len(call_name) > 0)
def _is_impure_call(call_name: str) -> bool:
    """Check if a call name represents an impure function."""
    # Check simple names
    if call_name in IMPURE_FUNCTIONS:
        return True

    # Check patterns like datetime.now
    if "." in call_name:
        parts = call_name.split(".")
        if len(parts) == 2 and (parts[0], parts[1]) in IMPURE_PATTERNS:
            return True

    return Falseh)j
  u}(j
  count_code_linesj  Kj
  }(j  }(j  Kj  K uj  }(j  Kj  K(uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j
  nodej  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  KAuuj  }(j  }(j  Kj  Kuj  }(j  Kj  KAuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j<  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'5node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:h)j1  u}(j
  total_linesj  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jI  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'@total_lines = (node.end_lineno or node.lineno) - node.lineno + 1h)j1  u}(j
  docstring_linesj  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jV  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'docstring_lines = 0h)j1  u}(j
  docstring_nodej  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jc  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'docstring_node = node.body[0]h)j1  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j3  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'X{  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def count_code_lines(node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:
    """
    Count lines of code excluding docstring.

    The total function lines minus docstring lines gives the actual code lines.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     \"\"\"This is a docstring.\"\"\"
        ...     x = 1
        ...     return x
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> count_code_lines(func)
        3
    """
    total_lines = (node.end_lineno or node.lineno) - node.lineno + 1

    # Check for docstring
    docstring_lines = 0
    if (
        node.body
        and isinstance(node.body[0], ast.Expr)
        and isinstance(node.body[0].value, ast.Constant)
        and isinstance(node.body[0].value.value, str)
    ):
        docstring_node = node.body[0]
        docstring_lines = (
            (docstring_node.end_lineno or docstring_node.lineno)
            - docstring_node.lineno
            + 1
        )

    return total_lines - docstring_linesh)j
  u}(j
  count_doctest_linesj  Kj
  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j
  nodej  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  KDuuj  }(j  }(j  Kj  Kuj  }(j  Kj  KDuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j}  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'5node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:h)jr  u}(j
  	docstringj  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'#docstring = ast.get_docstring(node)h)jr  u}(j
  countj  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'	count = 0h)jr  u}(j
  
in_doctestj  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'in_doctest = Falseh)jr  u}(j
  linej  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'line in docstring.split("\n"):h)jr  u}(j
  strippedj  K
j
  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'stripped = line.strip()h)jr  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jt  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'Xd  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def count_doctest_lines(node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:
    """
    Count lines that are doctest examples in the docstring.

    Counts both `>>> ` input lines and their expected output lines.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     \"\"\"Example.
        ...
        ...     Examples:
        ...         >>> foo()
        ...         42
        ...         >>> foo() + 1
        ...         43
        ...     \"\"\"
        ...     return 42
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> count_doctest_lines(func)
        4
    """
    docstring = ast.get_docstring(node)
    if not docstring:
        return 0

    count = 0
    in_doctest = False
    for line in docstring.split("\n"):
        stripped = line.strip()
        if stripped.startswith(">>> "):
            count += 1
            in_doctest = True
        elif stripped.startswith("... "):
            count += 1  # Continuation line
        elif in_doctest and stripped and not stripped.startswith(">>>"):
            count += 1  # Expected output line
            if not stripped:  # Empty line ends output
                in_doctest = False
        else:
            in_doctest = False
    return counth)j
  u}(j
  check_internal_importsj  Kj
  }(j  }(j  Mj  K uj  }(j  M(j  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ](}(j
  	file_infoj  K
j
  }(j  }(j  Mj  Kuj  }(j  Mj  K.uuj  }(j  }(j  Mj  Kuj  }(j  Mj  K.uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(j
  configj  K
j
  }(j  }(j  Mj  K0uj  }(j  Mj  KBuuj  }(j  }(j  Mj  K0uj  }(j  Mj  KBuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh''config: RuleConfig) -> list[Violation]:h)j  u}(j
  
violationsj  K
j
  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh' violations: list[Violation] = []h)j  u}(j
  symbolj  K
j
  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'symbol in file_info.symbols:h)j  u}(j
  	kind_namej  K
j
  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_internal_imports(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check for imports inside function bodies.

    Only applies to Core files when strict_pure is enabled.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, RuleConfig
        >>> sym = Symbol(
        ...     name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     internal_imports=["os"]
        ... )
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> violations = check_internal_imports(info, RuleConfig(strict_pure=True))
        >>> len(violations)
        1
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.strict_pure:
        return violations

    for symbol in file_info.symbols:
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD) and symbol.internal_imports:
            kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
            violations.append(
                Violation(
                    rule="internal_import",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"{kind_name} '{symbol.name}' has internal imports: {', '.join(symbol.internal_imports)}",
                    suggestion="Move imports to top of file or move function to Shell",
                )
            )

    return violationsh)j
  u}(j
  check_impure_callsj  Kj
  }(j  }(j  M+j  K uj  }(j  MPj  Kuuj  }(j  }(j  M,j  Kuj  }(j  M,j  Kuuj  ](}(j
  	file_infoj  K
j
  }(j  }(j  M,j  Kuj  }(j  M,j  K*uuj  }(j  }(j  M,j  Kuj  }(j  M,j  K*uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j&
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j
  u}(j
  configj  K
j
  }(j  }(j  M,j  K,uj  }(j  M,j  K>uuj  }(j  }(j  M,j  K,uj  }(j  M,j  K>uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j3
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh''config: RuleConfig) -> list[Violation]:h)j
  u}(j
  
violationsj  K
j
  }(j  }(j  M=j  Kuj  }(j  M=j  Kuuj  }(j  }(j  M=j  Kuj  }(j  M=j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j@
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh' violations: list[Violation] = []h)j
  u}(j
  symbolj  K
j
  }(j  }(j  MBj  Kuj  }(j  MBj  Kuuj  }(j  }(j  MBj  Kuj  }(j  MBj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jM
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'symbol in file_info.symbols:h)j
  u}(j
  	kind_namej  K
j
  }(j  }(j  MDj  Kuj  }(j  MDj  Kuuj  }(j  }(j  MDj  Kuj  }(j  MDj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jZ
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_impure_calls(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check for calls to known impure functions.

    Only applies to Core files when strict_pure is enabled.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, RuleConfig
        >>> sym = Symbol(
        ...     name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     impure_calls=["datetime.now", "print"]
        ... )
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> violations = check_impure_calls(info, RuleConfig(strict_pure=True))
        >>> len(violations)
        1
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.strict_pure:
        return violations

    for symbol in file_info.symbols:
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD) and symbol.impure_calls:
            kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
            violations.append(
                Violation(
                    rule="impure_call",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"{kind_name} '{symbol.name}' calls impure functions: {', '.join(symbol.impure_calls)}",
                    suggestion="Inject dependencies or move function to Shell",
                )
            )

    return violationsh)j
  ueh)j  u}(j  
referencesj  j  h#}(j  }(j  K j  K uj  }(j  Kj  K uuj  jk
  h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jk
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&src/invar/core/references.pyuj  ](}(namefind_references_in_sourcekindKrange}(start}(lineK	characterK uend}(j{
  K4j|
  KuuselectionRange}(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuchildren](}(jt
  sourcejv
  K
jw
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&src/invar/core/references.pyuh'$source: str, known_symbols: set[str]h)js
  u}(jt
  
known_symbolsjv
  K
jw
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  K(uuj
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  K(uuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'known_symbols: set[str]h)js
  u}(jt
  treejv
  K
jw
  }(jy
  }(j{
  K&j|
  Kuj}
  }(j{
  K&j|
  Kuuj
  }(jy
  }(j{
  K&j|
  Kuj}
  }(j{
  K&j|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'tree = ast.parse(source)h)js
  u}(jt
  seenjv
  K
jw
  }(jy
  }(j{
  K*j|
  Kuj}
  }(j{
  K*j|
  Kuuj
  }(jy
  }(j{
  K*j|
  Kuj}
  }(j{
  K*j|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'"seen: set[tuple[str, int]] = set()h)js
  u}(jt
  nodejv
  K
jw
  }(jy
  }(j{
  K,j|
  Kuj}
  }(j{
  K,j|
  Kuuj
  }(jy
  }(j{
  K,j|
  Kuj}
  }(j{
  K,j|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'node in ast.walk(tree):h)js
  u}(jt
  namejv
  K
jw
  }(jy
  }(j{
  K/j|
  Kuj}
  }(j{
  K/j|
  Kuuj
  }(jy
  }(j{
  K/j|
  Kuj}
  }(j{
  K/j|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'name = node.func.idh)js
  u}(jt
  linejv
  K
jw
  }(jy
  }(j{
  K1j|
  Kuj}
  }(j{
  K1j|
  Kuuj
  }(jy
  }(j{
  K1j|
  Kuj}
  }(j{
  K1j|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'!line = getattr(node, "lineno", 0)h)js
  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jx
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'XA  @pre(lambda source, known_symbols: isinstance(source, str))
@post(lambda result: isinstance(result, list))
def find_references_in_source(
    source: str, known_symbols: set[str]
) -> list[tuple[str, int]]:
    """
    Find references to known symbols in source code.

    Returns list of (symbol_name, line_number) for each reference found.
    Deduplicates: each (symbol, line) pair counted once.

    Examples:
        >>> refs = find_references_in_source("x = foo()\\nbar(x)", {"foo", "bar"})
        >>> sorted(refs)
        [('bar', 2), ('foo', 1)]
        >>> find_references_in_source("x = unknown()", {"foo"})
        []
    """
    try:
        tree = ast.parse(source)
    except SyntaxError:
        return []

    seen: set[tuple[str, int]] = set()

    for node in ast.walk(tree):
        # Count function calls: foo()
        if isinstance(node, ast.Call) and isinstance(node.func, ast.Name):
            name = node.func.id
            if name in known_symbols:
                line = getattr(node, "lineno", 0)
                seen.add((name, line))

    return list(seen)       h)ji
  u}(jt
  build_symbol_tablejv
  Kjw
  }(jy
  }(j{
  K7j|
  K uj}
  }(j{
  KOj|
  Kuuj
  }(jy
  }(j{
  K9j|
  Kuj}
  }(j{
  K9j|
  Kuuj
  ](}(jt
  
file_infosjv
  K
jw
  }(jy
  }(j{
  K9j|
  Kuj}
  }(j{
  K9j|
  K1uuj
  }(jy
  }(j{
  K9j|
  Kuj}
  }(j{
  K9j|
  K1uuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'.file_infos: list[FileInfo]) -> dict[str, str]:h)j
  u}(jt
  symbol_tablejv
  K
jw
  }(jy
  }(j{
  KGj|
  Kuj}
  }(j{
  KGj|
  Kuuj
  }(jy
  }(j{
  KGj|
  Kuj}
  }(j{
  KGj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'!symbol_table: dict[str, str] = {}h)j
  u}(jt
  	file_infojv
  K
jw
  }(jy
  }(j{
  KIj|
  Kuj}
  }(j{
  KIj|
  Kuuj
  }(jy
  }(j{
  KIj|
  Kuj}
  }(j{
  KIj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'file_info in file_infos:h)j
  u}(jt
  symboljv
  K
jw
  }(jy
  }(j{
  KJj|
  Kuj}
  }(j{
  KJj|
  Kuuj
  }(jy
  }(j{
  KJj|
  Kuj}
  }(j{
  KJj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'symbol in file_info.symbols:h)j
  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j
  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'X  @pre(lambda file_infos: isinstance(file_infos, list))
@post(lambda result: isinstance(result, dict))
def build_symbol_table(file_infos: list[FileInfo]) -> dict[str, str]:
    """
    Build a mapping of symbol names to their defining file.

    Returns dict of {symbol_name: file_path}.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym])
        >>> table = build_symbol_table([info])
        >>> table["foo"]
        'core/calc.py'
    """
    symbol_table: dict[str, str] = {}

    for file_info in file_infos:
        for symbol in file_info.symbols:
            if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.CLASS):
                # Use simple name (may have collisions, that's OK for now)
                symbol_table[symbol.name] = file_info.path

    return symbol_tableh)ji
  u}(jt
  count_cross_file_referencesjv
  Kjw
  }(jy
  }(j{
  KRj|
  K uj}
  }(j{
  K{j|
  Kuuj
  }(jy
  }(j{
  KSj|
  Kuj}
  }(j{
  KSj|
  Kuuj
  ](}(jt
  
file_infosjv
  K
jw
  }(jy
  }(j{
  KTj|
  Kuj}
  }(j{
  KTj|
  Kuuj
  }(jy
  }(j{
  KTj|
  Kuj}
  }(j{
  KTj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j1  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'3file_infos: list[FileInfo], sources: dict[str, str]h)j&  u}(jt
  sourcesjv
  K
jw
  }(jy
  }(j{
  KTj|
  K uj}
  }(j{
  KTj|
  K7uuj
  }(jy
  }(j{
  KTj|
  K uj}
  }(j{
  KTj|
  K7uuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j>  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'sources: dict[str, str]h)j&  u}(jt
  symbol_tablejv
  K
jw
  }(jy
  }(j{
  Kgj|
  Kuj}
  }(j{
  Kgj|
  Kuuj
  }(jy
  }(j{
  Kgj|
  Kuj}
  }(j{
  Kgj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jK  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'-symbol_table = build_symbol_table(file_infos)h)j&  u}(jt
  
known_symbolsjv
  K
jw
  }(jy
  }(j{
  Khj|
  Kuj}
  }(j{
  Khj|
  Kuuj
  }(jy
  }(j{
  Khj|
  Kuj}
  }(j{
  Khj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jX  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'(known_symbols = set(symbol_table.keys())h)j&  u}(jt
  
ref_countsjv
  K
jw
  }(jy
  }(j{
  Kkj|
  Kuj}
  }(j{
  Kkj|
  Kuuj
  }(jy
  }(j{
  Kkj|
  Kuj}
  }(j{
  Kkj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#je  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'-ref_counts: dict[str, int] = defaultdict(int)h)j&  u}(jt
  	file_infojv
  K
jw
  }(jy
  }(j{
  Kmj|
  Kuj}
  }(j{
  Kmj|
  Kuuj
  }(jy
  }(j{
  Kmj|
  Kuj}
  }(j{
  Kmj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jr  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'file_info in file_infos:h)j&  u}(jt
  sourcejv
  K
jw
  }(jy
  }(j{
  Knj|
  Kuj}
  }(j{
  Knj|
  Kuuj
  }(jy
  }(j{
  Knj|
  Kuj}
  }(j{
  Knj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'(source = sources.get(file_info.path, "")h)j&  u}(jt
  
referencesjv
  K
jw
  }(jy
  }(j{
  Krj|
  Kuj}
  }(j{
  Krj|
  Kuuj
  }(jy
  }(j{
  Krj|
  Kuj}
  }(j{
  Krj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'=references = find_references_in_source(source, known_symbols)h)j&  u}(jt
  symbol_namejv
  K
jw
  }(jy
  }(j{
  Ktj|
  Kuj}
  }(j{
  Ktj|
  Kuuj
  }(jy
  }(j{
  Ktj|
  Kuj}
  }(j{
  Ktj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'symbol_name, _ in references:h)j&  u}(jt
  
defining_filejv
  K
jw
  }(jy
  }(j{
  Kuj|
  Kuj}
  }(j{
  Kuj|
  Kuuj
  }(jy
  }(j{
  Kuj|
  Kuj}
  }(j{
  Kuj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'-defining_file = symbol_table.get(symbol_name)h)j&  u}(jt
  keyjv
  K
jw
  }(jy
  }(j{
  Kxj|
  Kuj}
  }(j{
  Kxj|
  Kuuj
  }(jy
  }(j{
  Kxj|
  Kuj}
  }(j{
  Kxj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh''key = f"{defining_file}::{symbol_name}"h)j&  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j(  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'XW  @pre(lambda file_infos, sources: isinstance(file_infos, list))
def count_cross_file_references(
    file_infos: list[FileInfo], sources: dict[str, str]
) -> dict[str, int]:
    """
    Count cross-file references for all symbols.

    Returns dict of {"file::symbol": reference_count}.
    Only counts references from OTHER files (excludes self-references).

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> info = FileInfo(path="a.py", lines=10, symbols=[sym])
        >>> sources = {"a.py": "def foo(): pass", "b.py": "foo()"}
        >>> info2 = FileInfo(path="b.py", lines=5, symbols=[])
        >>> refs = count_cross_file_references([info, info2], sources)
        >>> refs.get("a.py::foo", 0)
        1
    """
    # Build symbol table: name -> defining file
    symbol_table = build_symbol_table(file_infos)
    known_symbols = set(symbol_table.keys())

    # Count references from each file
    ref_counts: dict[str, int] = defaultdict(int)

    for file_info in file_infos:
        source = sources.get(file_info.path, "")
        if not source:
            continue

        references = find_references_in_source(source, known_symbols)

        for symbol_name, _ in references:
            defining_file = symbol_table.get(symbol_name)
            if defining_file and defining_file != file_info.path:
                # Cross-file reference: increment count
                key = f"{defining_file}::{symbol_name}"
                ref_counts[key] += 1

    return dict(ref_counts)h)ji
  u}(jt
  build_perception_mapjv
  Kjw
  }(jy
  }(j{
  K~j|
  K uj}
  }(j{
  Kj|
  Kuuj
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  ](}(jt
  
file_infosjv
  K
jw
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'Ffile_infos: list[FileInfo], sources: dict[str, str], project_root: strh)j  u}(jt
  sourcesjv
  K
jw
  }(jy
  }(j{
  Kj|
  K uj}
  }(j{
  Kj|
  K7uuj
  }(jy
  }(j{
  Kj|
  K uj}
  }(j{
  Kj|
  K7uuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'*sources: dict[str, str], project_root: strh)j  u}(jt
  project_rootjv
  K
jw
  }(jy
  }(j{
  Kj|
  K9uj}
  }(j{
  Kj|
  KJuuj
  }(jy
  }(j{
  Kj|
  K9uj}
  }(j{
  Kj|
  KJuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'project_root: strh)j  u}(jt
  
ref_countsjv
  K
jw
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'=ref_counts = count_cross_file_references(file_infos, sources)h)j  u}(jt
  symbol_refsjv
  K
jw
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'"symbol_refs: list[SymbolRefs] = []h)j  u}(jt
  
total_symbolsjv
  K
jw
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'total_symbols = 0h)j  u}(jt
  	file_infojv
  K
jw
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'file_info in file_infos:h)j  u}(jt
  symboljv
  K
jw
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j(  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'symbol in file_info.symbols:h)j  u}(jt
  keyjv
  K
jw
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j5  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'(key = f"{file_info.path}::{symbol.name}"h)j  u}(jt
  countjv
  K
jw
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  }(jy
  }(j{
  Kj|
  Kuj}
  }(j{
  Kj|
  Kuuj
  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jB  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'count = ref_counts.get(key, 0)h)j  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&j
  uh'X2  @pre(lambda file_infos, sources, project_root: isinstance(file_infos, list))
def build_perception_map(
    file_infos: list[FileInfo], sources: dict[str, str], project_root: str
) -> PerceptionMap:
    """
    Build complete perception map with reference counts.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> info = FileInfo(path="a.py", lines=10, symbols=[sym])
        >>> pm = build_perception_map([info], {"a.py": "def foo(): pass"}, "/test")
        >>> pm.total_symbols
        1
    """
    ref_counts = count_cross_file_references(file_infos, sources)

    # Build SymbolRefs list
    symbol_refs: list[SymbolRefs] = []
    total_symbols = 0

    for file_info in file_infos:
        for symbol in file_info.symbols:
            if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.CLASS):
                key = f"{file_info.path}::{symbol.name}"
                count = ref_counts.get(key, 0)
                symbol_refs.append(
                    SymbolRefs(
                        symbol=symbol,
                        file_path=file_info.path,
                        ref_count=count,
                    )
                )
                total_symbols += 1

    # Sort by reference count (descending)
    symbol_refs.sort(key=lambda sr: sr.ref_count, reverse=True)

    return PerceptionMap(
        project_root=project_root,
        total_files=len(file_infos),
        total_symbols=total_symbols,
        symbols=symbol_refs,
    )h)ji
  ueh)j  u}(j  __init__j  j  h#}(j  }(j  K j  K uj  }(j  K	j  K uuj  jS  h}(h!<file:///Users/tefx/Projects/Invar/src/invar/core/__init__.pyh#jS  h$5/Users/tefx/Projects/Invar/src/invar/core/__init__.pyh&src/invar/core/__init__.pyuj  ]h)j  u}(j  rulesj  j  h#}(j  }(j  K j  K uj  }(j  Mj  K uuj  j]  h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j]  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&src/invar/core/rules.pyuj  ](}(nameFORBIDDEN_IMPORT_ALTERNATIVESkindKrange}(start}(lineK	characterK uend}(jm  Kjn  KuuselectionRange}(jk  }(jm  Kjn  K ujo  }(jm  Kjn  Kuuchildren]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jj  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&src/invar/core/rules.pyuh'1FORBIDDEN_IMPORT_ALTERNATIVES: dict[str, str] = {h)j[  u}(jf  RuleFuncjh  K
ji  }(jk  }(jm  Kjn  K ujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  K ujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j~  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'<RuleFunc = Callable[[FileInfo, RuleConfig], list[Violation]]h)j[  u}(jf  check_file_sizejh  Kji  }(jk  }(jm  K jn  K ujo  }(jm  Kbjn  Kuujq  }(jk  }(jm  K!jn  Kujo  }(jm  K!jn  Kuuju  ](}(jf  	file_infojh  K
ji  }(jk  }(jm  K!jn  Kujo  }(jm  K!jn  K'uujq  }(jk  }(jm  K!jn  Kujo  }(jm  K!jn  K'uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(jf  configjh  K
ji  }(jk  }(jm  K!jn  K)ujo  }(jm  K!jn  K;uujq  }(jk  }(jm  K!jn  K)ujo  }(jm  K!jn  K;uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh''config: RuleConfig) -> list[Violation]:h)j  u}(jf  
violationsjh  K
ji  }(jk  }(jm  K3jn  Kujo  }(jm  K3jn  Kuujq  }(jk  }(jm  K3jn  Kujo  }(jm  K3jn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh' violations: list[Violation] = []h)j  u}(jf  funcsjh  K
ji  }(jk  }(jm  K5jn  Kujo  }(jm  K5jn  K	uujq  }(jk  }(jm  K5jn  Kujo  }(jm  K5jn  K	uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'Lfuncs = sorted([(s.name, s.end_line - s.line + 1) for s in file_info.symbolsh)j  u}(jf  	func_hintjh  K
ji  }(jk  }(jm  K8jn  Kujo  }(jm  K8jn  K
uujq  }(jk  }(jm  K8jn  Kujo  }(jm  K8jn  K
uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'Yfunc_hint = f" Functions: {', '.join(f'{n}({sz}L)' for n, sz in funcs)}" if funcs else ""h)j  u}(jf  extraction_hintjh  K
ji  }(jk  }(jm  K;jn  Kujo  }(jm  K;jn  Kuujq  }(jk  }(jm  K;jn  Kujo  }(jm  K;jn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'3extraction_hint = format_extraction_hint(file_info)h)j  u}(jf  
suggestionjh  K
ji  }(jk  }(jm  K>jn  Kujo  }(jm  K>jn  Kuujq  }(jk  }(jm  K>jn  Kujo  }(jm  K>jn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'*suggestion = "Split into smaller modules."h)j  u}(jf  threshold_linesjh  K
ji  }(jk  }(jm  KOjn  Kujo  }(jm  KOjn  Kuujq  }(jk  }(jm  KOjn  Kujo  }(jm  KOjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'Lthreshold_lines = int(config.max_file_lines * config.size_warning_threshold)h)j  u}(jf  pctjh  K
ji  }(jk  }(jm  KQjn  Kujo  }(jm  KQjn  Kuujq  }(jk  }(jm  KQjn  Kujo  }(jm  KQjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'8pct = int(file_info.lines / config.max_file_lines * 100)h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_file_size(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check if file exceeds maximum line count or warning threshold.

    P18: Shows function groups in size warnings to help agents decide what to extract.
    P25: Shows extractable groups with dependencies for warnings.

    Examples:
        >>> from invar.core.models import FileInfo, RuleConfig
        >>> check_file_size(FileInfo(path="ok.py", lines=100), RuleConfig())
        []
        >>> len(check_file_size(FileInfo(path="big.py", lines=600), RuleConfig()))
        1
        >>> # P8: Warning at 80% threshold (400 lines when max is 500)
        >>> vs = check_file_size(FileInfo(path="growing.py", lines=420), RuleConfig())
        >>> len(vs) == 1 and vs[0].rule == "file_size_warning"
        True
    """
    violations: list[Violation] = []
    # P18: Show top 5 largest functions in size warnings
    funcs = sorted([(s.name, s.end_line - s.line + 1) for s in file_info.symbols
                    if s.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD)],
                   key=lambda x: -x[1])[:5]
    func_hint = f" Functions: {', '.join(f'{n}({sz}L)' for n, sz in funcs)}" if funcs else ""

    # P25: Get extractable groups with dependencies
    extraction_hint = format_extraction_hint(file_info)

    if file_info.lines > config.max_file_lines:
        suggestion = "Split into smaller modules."
        if extraction_hint:
            suggestion += f"\nExtractable groups:\n{extraction_hint}"
        elif func_hint:
            suggestion += func_hint
        violations.append(
            Violation(
                rule="file_size",
                severity=Severity.ERROR,
                file=file_info.path,
                line=None,
                message=f"File has {file_info.lines} lines (max: {config.max_file_lines})",
                suggestion=suggestion,
            )
        )
    # Phase 9 P8: Warning at configurable threshold (default 80%)
    elif config.size_warning_threshold > 0:
        threshold_lines = int(config.max_file_lines * config.size_warning_threshold)
        if file_info.lines >= threshold_lines:
            pct = int(file_info.lines / config.max_file_lines * 100)
            suggestion = "Consider splitting before reaching limit."
            if extraction_hint:
                suggestion += f"\nExtractable groups:\n{extraction_hint}"
            elif func_hint:
                suggestion += func_hint
            violations.append(
                Violation(
                    rule="file_size_warning",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=None,
                    message=f"File has {file_info.lines} lines ({pct}% of {config.max_file_lines} limit)",
                    suggestion=suggestion,
                )
            )

    return violationsh)j[  u}(jf  check_function_sizejh  Kji  }(jk  }(jm  Kejn  K ujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kfjn  Kujo  }(jm  Kfjn  Kuuju  ](}(jf  	file_infojh  K
ji  }(jk  }(jm  Kfjn  Kujo  }(jm  Kfjn  K+uujq  }(jk  }(jm  Kfjn  Kujo  }(jm  Kfjn  K+uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(jf  configjh  K
ji  }(jk  }(jm  Kfjn  K-ujo  }(jm  Kfjn  K?uujq  }(jk  }(jm  Kfjn  K-ujo  }(jm  Kfjn  K?uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j#  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh''config: RuleConfig) -> list[Violation]:h)j  u}(jf  
violationsjh  K
ji  }(jk  }(jm  Kujn  Kujo  }(jm  Kujn  Kuujq  }(jk  }(jm  Kujn  Kujo  }(jm  Kujn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j0  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh' violations: list[Violation] = []h)j  u}(jf  symboljh  K
ji  }(jk  }(jm  Kwjn  Kujo  }(jm  Kwjn  Kuujq  }(jk  }(jm  Kwjn  Kujo  }(jm  Kwjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j=  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'symbol in file_info.symbols:h)j  u}(jf  total_linesjh  K
ji  }(jk  }(jm  Kyjn  Kujo  }(jm  Kyjn  Kuujq  }(jk  }(jm  Kyjn  Kujo  }(jm  Kyjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jJ  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'/total_lines = symbol.end_line - symbol.line + 1h)j  u}(jf  
func_linesjh  K
ji  }(jk  }(jm  K|jn  Kujo  }(jm  K|jn  Kuujq  }(jk  }(jm  K|jn  Kujo  }(jm  K|jn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jW  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'func_lines = symbol.code_linesh)j  u}(jf  	line_typejh  K
ji  }(jk  }(jm  K}jn  Kujo  }(jm  K}jn  Kuujq  }(jk  }(jm  K}jn  Kujo  }(jm  K}jn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jd  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'line_type = "code lines"h)j  u}(jf  	code_onlyjh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jq  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'.code_only = total_lines - symbol.doctest_linesh)j  u}(jf  	breakdownjh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j~  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'Cbreakdown = f" ({code_only} code + {symbol.doctest_lines} doctest)"h)j  u}(jf  
suggestionjh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'Ksuggestion = f"Extract helper or set exclude_doctest_lines=true{breakdown}"h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j
  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'X	  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_function_size(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check if any function exceeds maximum line count.

    When use_code_lines is True, uses code_lines (excluding docstring).
    When exclude_doctest_lines is True, subtracts doctest lines from count.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=10)
        >>> info = FileInfo(path="test.py", lines=20, symbols=[sym])
        >>> cfg = RuleConfig(max_function_lines=50)
        >>> check_function_size(info, cfg)
        []
    """
    violations: list[Violation] = []

    for symbol in file_info.symbols:
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            total_lines = symbol.end_line - symbol.line + 1
            # Calculate effective line count based on config
            if config.use_code_lines and symbol.code_lines is not None:
                func_lines = symbol.code_lines
                line_type = "code lines"
            else:
                func_lines = total_lines
                line_type = "lines"
            # Optionally exclude doctest lines
            if config.exclude_doctest_lines and symbol.doctest_lines > 0:
                func_lines -= symbol.doctest_lines
                line_type = f"{line_type} (excl. doctest)"

            if func_lines > config.max_function_lines:
                # P19: Show breakdown if doctest lines exist
                if symbol.doctest_lines > 0 and not config.exclude_doctest_lines:
                    code_only = total_lines - symbol.doctest_lines
                    breakdown = f" ({code_only} code + {symbol.doctest_lines} doctest)"
                    suggestion = f"Extract helper or set exclude_doctest_lines=true{breakdown}"
                else:
                    suggestion = "Extract helper functions"
                violations.append(
                    Violation(
                        rule="function_size",
                        severity=Severity.WARNING,
                        file=file_info.path,
                        line=symbol.line,
                        message=f"Function '{symbol.name}' has {func_lines} {line_type} (max: {config.max_function_lines})",
                        suggestion=suggestion,
                    )
                )

    return violationsh)j[  u}(jf  check_forbidden_importsjh  Kji  }(jk  }(jm  Kjn  K ujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ](}(jf  	file_infojh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  K/uujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  K/uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(jf  configjh  K
ji  }(jk  }(jm  Kjn  K1ujo  }(jm  Kjn  KCuujq  }(jk  }(jm  Kjn  K1ujo  }(jm  Kjn  KCuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh''config: RuleConfig) -> list[Violation]:h)j  u}(jf  
violationsjh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh' violations: list[Violation] = []h)j  u}(jf  impjh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'imp in file_info.imports:h)j  u}(jf  altjh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'0alt = FORBIDDEN_IMPORT_ALTERNATIVES.get(imp, "")h)j  u}(jf  
suggestionjh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'4suggestion = f"Move I/O code using '{imp}' to Shell"h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_forbidden_imports(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check for forbidden imports in Core files.

    Only applies to files marked as Core.

    Examples:
        >>> from invar.core.models import FileInfo
        >>> info = FileInfo(path="core/calc.py", lines=10, imports=["math"], is_core=True)
        >>> cfg = RuleConfig()
        >>> check_forbidden_imports(info, cfg)
        []
        >>> info = FileInfo(path="core/bad.py", lines=10, imports=["os"], is_core=True)
        >>> violations = check_forbidden_imports(info, cfg)
        >>> len(violations)
        1
    """
    violations: list[Violation] = []

    if not file_info.is_core:
        return violations

    for imp in file_info.imports:
        if imp in config.forbidden_imports:
            # P17: Include pure alternative in suggestion
            alt = FORBIDDEN_IMPORT_ALTERNATIVES.get(imp, "")
            suggestion = f"Move I/O code using '{imp}' to Shell"
            if alt:
                suggestion += f". Alternative: {alt}"
            violations.append(
                Violation(
                    rule="forbidden_import",
                    severity=Severity.ERROR,
                    file=file_info.path,
                    line=None,
                    message=f"Imports '{imp}' (forbidden in Core)",
                    suggestion=suggestion,
                )
            )

    return violationsh)j[  u}(jf  check_contractsjh  Kji  }(jk  }(jm  Kjn  K ujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ](}(jf  	file_infojh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  K'uujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  K'uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j   h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(jf  configjh  K
ji  }(jk  }(jm  Kjn  K)ujo  }(jm  Kjn  K;uujq  }(jk  }(jm  Kjn  K)ujo  }(jm  Kjn  K;uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j
  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh''config: RuleConfig) -> list[Violation]:h)j  u}(jf  
violationsjh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh' violations: list[Violation] = []h)j  u}(jf  symboljh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j'  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'symbol in file_info.symbols:h)j  u}(jf  	kind_namejh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j4  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j  u}(jf  
suggestionjh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jA  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'Hsuggestion = format_suggestion_for_violation(symbol, "missing_contract")h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_contracts(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check that public Core functions have contracts.

    Only applies to files marked as Core when require_contracts is True.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract
        >>> contract = Contract(kind="pre", expression="x > 0", line=1)
        >>> sym = Symbol(name="calc", kind=SymbolKind.FUNCTION, line=1, end_line=5, contracts=[contract])
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> cfg = RuleConfig(require_contracts=True)
        >>> check_contracts(info, cfg)
        []
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.require_contracts:
        return violations

    for symbol in file_info.symbols:
        # Check all functions and methods - agent needs contracts everywhere
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            if not symbol.contracts:
                kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                suggestion = format_suggestion_for_violation(symbol, "missing_contract")
                violations.append(
                    Violation(
                        rule="missing_contract",
                        severity=Severity.WARNING,
                        file=file_info.path,
                        line=symbol.line,
                        message=f"{kind_name} '{symbol.name}' has no @pre or @post contract",
                        suggestion=suggestion,
                    )
                )

    return violationsh)j[  u}(jf  check_doctestsjh  Kji  }(jk  }(jm  Kjn  K ujo  }(jm  Mjn  Kuujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  Kuuju  ](}(jf  	file_infojh  K
ji  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  K&uujq  }(jk  }(jm  Kjn  Kujo  }(jm  Kjn  K&uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j[  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)jP  u}(jf  configjh  K
ji  }(jk  }(jm  Kjn  K(ujo  }(jm  Kjn  K:uujq  }(jk  }(jm  Kjn  K(ujo  }(jm  Kjn  K:uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jh  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh''config: RuleConfig) -> list[Violation]:h)jP  u}(jf  
violationsjh  K
ji  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#ju  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh' violations: list[Violation] = []h)jP  u}(jf  symboljh  K
ji  }(jk  }(jm  M	jn  Kujo  }(jm  M	jn  Kuujq  }(jk  }(jm  M	jn  Kujo  }(jm  M	jn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'symbol in file_info.symbols:h)jP  u}(jf  	name_partjh  K
ji  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'Mname_part = symbol.name.split(".")[-1] if "." in symbol.name else symbol.nameh)jP  u}(jf  	is_publicjh  K
ji  }(jk  }(jm  M
jn  Kujo  }(jm  M
jn  Kuujq  }(jk  }(jm  M
jn  Kujo  }(jm  M
jn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh')is_public = not name_part.startswith("_")h)jP  u}(jf  	kind_namejh  K
ji  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)jP  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jR  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_doctests(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check that contracted functions have doctest examples.

    Only applies to files marked as Core when require_doctests is True.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract
        >>> contract = Contract(kind="pre", expression="x > 0", line=1)
        >>> sym = Symbol(
        ...     name="calc", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     contracts=[contract], has_doctest=True
        ... )
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> cfg = RuleConfig(require_doctests=True)
        >>> check_doctests(info, cfg)
        []
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.require_doctests:
        return violations

    for symbol in file_info.symbols:
        # Only public functions/methods require doctests (private can skip)
        # For methods, check if method name (after dot) starts with _
        name_part = symbol.name.split(".")[-1] if "." in symbol.name else symbol.name
        is_public = not name_part.startswith("_")
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD) and is_public and symbol.contracts and not symbol.has_doctest:
            kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
            violations.append(
                Violation(
                    rule="missing_doctest",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"{kind_name} '{symbol.name}' has contracts but no doctest examples",
                    suggestion="Add >>> examples in docstring",
                )
            )

    return violationsh)j[  u}(jf  check_shell_resultjh  Kji  }(jk  }(jm  Mjn  K ujo  }(jm  MEjn  Kuujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuuju  ](}(jf  	file_infojh  K
ji  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  K*uujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  K*uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(jf  configjh  K
ji  }(jk  }(jm  Mjn  K,ujo  }(jm  Mjn  K>uujq  }(jk  }(jm  Mjn  K,ujo  }(jm  Mjn  K>uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh''config: RuleConfig) -> list[Violation]:h)j  u}(jf  
violationsjh  K
ji  }(jk  }(jm  M-jn  Kujo  }(jm  M-jn  Kuujq  }(jk  }(jm  M-jn  Kujo  }(jm  M-jn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh' violations: list[Violation] = []h)j  u}(jf  symboljh  K
ji  }(jk  }(jm  M1jn  Kujo  }(jm  M1jn  Kuujq  }(jk  }(jm  M1jn  Kujo  }(jm  M1jn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'symbol in file_info.symbols:h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_shell_result(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check that Shell functions with return values use Result[T, E].

    Skips: functions returning None (CLI entry points).

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, RuleConfig
        >>> sym = Symbol(name="load", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     signature="(path: str) -> Result[str, str]")
        >>> info = FileInfo(path="shell/fs.py", lines=10, symbols=[sym], is_shell=True)
        >>> check_shell_result(info, RuleConfig())
        []
    """
    violations: list[Violation] = []
    if not file_info.is_shell:
        return violations

    for symbol in file_info.symbols:
        if symbol.kind != SymbolKind.FUNCTION:
            continue
        # Skip functions with no return type or returning None
        if "-> None" in symbol.signature or "->" not in symbol.signature:
            continue
        # Skip generators (Iterator/Generator) - acceptable exception per protocol
        if "Iterator[" in symbol.signature or "Generator[" in symbol.signature:
            continue
        if "Result[" not in symbol.signature:
            violations.append(
                Violation(
                    rule="shell_result",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"Shell function '{symbol.name}' should return Result[T, E]",
                    suggestion="Use Result[T, E] from returns library",
                )
            )
    return violationsh)j[  u}(jf  
get_all_rulesjh  Kji  }(jk  }(jm  MHjn  K ujo  }(jm  MTjn  K9uujq  }(jk  }(jm  MIjn  Kujo  }(jm  MIjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'X  @post(lambda result: len(result) > 0)
def get_all_rules() -> list[RuleFunc]:
    """
    Return all available rule functions.

    Examples:
        >>> len(get_all_rules()) >= 5
        True
    """
    return [check_file_size, check_function_size, check_forbidden_imports, check_contracts,
            check_doctests, check_shell_result, check_internal_imports, check_impure_calls,
            check_empty_contracts, check_semantic_tautology, check_redundant_type_contracts,
            check_param_mismatch, check_partial_contract]h)j[  u}(jf  _apply_severity_overridejh  Kji  }(jk  }(jm  MWjn  K ujo  }(jm  M{jn  Kuujq  }(jk  }(jm  MWjn  Kujo  }(jm  MWjn  Kuuju  ](}(jf  j  jh  K
ji  }(jk  }(jm  MWjn  Kujo  }(jm  MWjn  K)uujq  }(jk  }(jm  MWjn  Kujo  }(jm  MWjn  K)uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'=v: Violation, overrides: dict[str, str]) -> Violation | None:h)j  u}(jf  	overridesjh  K
ji  }(jk  }(jm  MWjn  K+ujo  }(jm  MWjn  KDuujq  }(jk  }(jm  MWjn  K+ujo  }(jm  MWjn  KDuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'/overrides: dict[str, str]) -> Violation | None:h)j  u}(jf  overridejh  K
ji  }(jk  }(jm  Mijn  Kujo  }(jm  Mijn  Kuujq  }(jk  }(jm  Mijn  Kujo  }(jm  Mijn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j*  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh' override = overrides.get(v.rule)h)j  u}(jf  severity_mapjh  K
ji  }(jk  }(jm  Mojn  Kujo  }(jm  Mojn  Kuujq  }(jk  }(jm  Mojn  Kujo  }(jm  Mojn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j7  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'\severity_map = {"info": Severity.INFO, "warning": Severity.WARNING, "error": Severity.ERROR}h)j  u}(jf  new_severityjh  K
ji  }(jk  }(jm  Mpjn  Kujo  }(jm  Mpjn  Kuujq  }(jk  }(jm  Mpjn  Kujo  }(jm  Mpjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jD  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh')new_severity = severity_map.get(override)h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'X>  def _apply_severity_override(v: Violation, overrides: dict[str, str]) -> Violation | None:
    """
    Apply severity override to a violation.

    Returns None if rule is set to "off", otherwise returns violation
    with potentially updated severity.

    Examples:
        >>> from invar.core.models import Violation, Severity
        >>> v = Violation(rule="test", severity=Severity.INFO, file="x.py", message="msg")
        >>> _apply_severity_override(v, {"test": "off"}) is None
        True
        >>> v2 = _apply_severity_override(v, {"test": "error"})
        >>> v2.severity
        <Severity.ERROR: 'error'>
        >>> _apply_severity_override(v, {}).severity  # No override
        <Severity.INFO: 'info'>
    """
    override = overrides.get(v.rule)
    if override is None:
        return v
    if override == "off":
        return None
    # Map string to Severity enum
    severity_map = {"info": Severity.INFO, "warning": Severity.WARNING, "error": Severity.ERROR}
    new_severity = severity_map.get(override)
    if new_severity is None:
        return v  # Invalid override, keep original
    # Create new violation with updated severity
    return Violation(
        rule=v.rule,
        severity=new_severity,
        file=v.file,
        line=v.line,
        message=v.message,
        suggestion=v.suggestion,
    )h)j[  u}(jf  check_all_rulesjh  Kji  }(jk  }(jm  M~jn  K ujo  }(jm  Mjn  Kuujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuuju  ](}(jf  	file_infojh  K
ji  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  K'uujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  K'uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j^  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)jS  u}(jf  configjh  K
ji  }(jk  }(jm  Mjn  K)ujo  }(jm  Mjn  K;uujq  }(jk  }(jm  Mjn  K)ujo  }(jm  Mjn  K;uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jk  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh''config: RuleConfig) -> list[Violation]:h)jS  u}(jf  excludedjh  K
ji  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jx  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'5excluded = get_excluded_rules(file_info.path, config)h)jS  u}(jf  exclude_alljh  K
ji  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'exclude_all = "*" in excludedh)jS  u}(jf  
violationsjh  K
ji  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'violations = []h)jS  u}(jf  rulejh  K
ji  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  Kuuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'rule in get_all_rules():h)jS  u}(jf  j  jh  K
ji  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  K
uujq  }(jk  }(jm  Mjn  Kujo  }(jm  Mjn  K
uuju  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'v in rule(file_info, config):h)jS  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jU  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&jz  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_all_rules(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Run all rules against a file and collect violations.

    Respects rule_exclusions and severity_overrides config.

    Examples:
        >>> from invar.core.models import FileInfo, RuleConfig, RuleExclusion
        >>> violations = check_all_rules(FileInfo(path="test.py", lines=50), RuleConfig())
        >>> isinstance(violations, list)
        True
        >>> # Test exclusion: file_size excluded for generated files
        >>> excl = RuleExclusion(pattern="**/generated/**", rules=["file_size"])
        >>> cfg = RuleConfig(rule_exclusions=[excl])
        >>> big_file = FileInfo(path="src/generated/data.py", lines=600)
        >>> vs = check_all_rules(big_file, cfg)
        >>> any(v.rule == "file_size" for v in vs)
        False
    """
    # Phase 9 P1: Get excluded rules for this file
    excluded = get_excluded_rules(file_info.path, config)
    exclude_all = "*" in excluded

    violations = []
    for rule in get_all_rules():
        for v in rule(file_info, config):
            # Skip if rule is excluded (either specifically or via "*")
            if exclude_all or v.rule in excluded:
                continue
            # Phase 9 P2: Apply severity overrides
            v = _apply_severity_override(v, config.severity_overrides)
            if v is not None:
                violations.append(v)
    return violationsh)j[  ueh)j  u}(j  parserj  j  h#}(j  }(j  K j  K uj  }(j  Mj  K uuj  j  h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&src/invar/core/parser.pyuj  ](}(nameparse_sourcekindKrange}(start}(lineK	characterK uend}(j  K7j  KuuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  sourcej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&src/invar/core/parser.pyuh'8source: str, path: str = "<string>") -> FileInfo | None:h)j  u}(j  pathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K4uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K4uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'+path: str = "<string>") -> FileInfo | None:h)j  u}(j  treej  K
j  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'tree = ast.parse(source)h)j  u}(j  linesj  K
j  }(j  }(j  K.j  Kuj  }(j  K.j  K	uuj  }(j  }(j  K.j  Kuj  }(j  K.j  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j   h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'lines = source.count("\n") + 1h)j  u}(j  symbolsj  K
j  }(j  }(j  K/j  Kuj  }(j  K/j  Kuuj  }(j  }(j  K/j  Kuj  }(j  K/j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh' symbols = _extract_symbols(tree)h)j  u}(j  importsj  K
j  }(j  }(j  K0j  Kuj  }(j  K0j  Kuuj  }(j  }(j  K0j  Kuj  }(j  K0j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh' imports = _extract_imports(tree)h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda source, path="<string>": isinstance(source, str))
def parse_source(source: str, path: str = "<string>") -> FileInfo | None:
    """
    Parse Python source code and extract symbols.

    Args:
        source: Python source code as string
        path: Path for reporting (not used for I/O)

    Returns:
        FileInfo with extracted symbols, or None if syntax error

    Examples:
        >>> info = parse_source("def foo(): pass")
        >>> info is not None
        True
        >>> len(info.symbols)
        1
        >>> info.symbols[0].name
        'foo'
    """
    try:
        tree = ast.parse(source)
    except SyntaxError:
        return None

    lines = source.count("\n") + 1
    symbols = _extract_symbols(tree)
    imports = _extract_imports(tree)

    return FileInfo(
        path=path,
        lines=lines,
        symbols=symbols,
        imports=imports,
    )h)j  u}(j  _extract_symbolsj  Kj  }(j  }(j  K:j  K uj  }(j  KVj  Kuuj  }(j  }(j  K;j  Kuj  }(j  K;j  Kuuj  ](}(j  treej  K
j  }(j  }(j  K;j  Kuj  }(j  K;j  K%uuj  }(j  }(j  K;j  Kuj  }(j  K;j  K%uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j4  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'"tree: ast.Module) -> list[Symbol]:h)j)  u}(j  symbolsj  K
j  }(j  }(j  KJj  Kuj  }(j  KJj  Kuuj  }(j  }(j  KJj  Kuj  }(j  KJj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jA  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'symbols: list[Symbol] = []h)j)  u}(j  nodej  K
j  }(j  }(j  KLj  Kuj  }(j  KLj  Kuuj  }(j  }(j  KLj  Kuj  }(j  KLj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jN  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'node in tree.body:h)j)  u}(j  itemj  K
j  }(j  }(j  KRj  Kuj  }(j  KRj  Kuuj  }(j  }(j  KRj  Kuj  }(j  KRj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j[  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'item in node.body:h)j)  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j+  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda tree: isinstance(tree, ast.Module))
def _extract_symbols(tree: ast.Module) -> list[Symbol]:
    """
    Extract function, class, and method symbols from AST.

    Examples:
        >>> import ast
        >>> tree = ast.parse("class Foo:\\n    def bar(self): pass")
        >>> symbols = _extract_symbols(tree)
        >>> len(symbols)
        2
        >>> symbols[0].kind.value
        'class'
        >>> symbols[1].kind.value
        'method'
    """
    symbols: list[Symbol] = []

    for node in tree.body:
        if isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef):
            symbols.append(_parse_function(node))
        elif isinstance(node, ast.ClassDef):
            symbols.append(_parse_class(node))
            # Extract methods from class body
            for item in node.body:
                if isinstance(item, ast.FunctionDef | ast.AsyncFunctionDef):
                    symbols.append(_parse_method(item, node.name))

    return symbolsh)j  u}(j  _parse_functionj  Kj  }(j  }(j  KYj  K uj  }(j  Kuj  Kuuj  }(j  }(j  K[j  Kuj  }(j  K[j  Kuuj  ](}(j  nodej  K
j  }(j  }(j  K[j  Kuj  }(j  K[j  K@uuj  }(j  }(j  K[j  Kuj  }(j  K[j  K@uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#ju  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'8node: ast.FunctionDef | ast.AsyncFunctionDef) -> Symbol:h)jj  u}(j  	contractsj  K
j  }(j  }(j  K]j  Kuj  }(j  K]j  K
uuj  }(j  }(j  K]j  Kuj  }(j  K]j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'$contracts = _extract_contracts(node)h)jj  u}(j  	docstringj  K
j  }(j  }(j  K^j  Kuj  }(j  K^j  K
uuj  }(j  }(j  K^j  Kuj  }(j  K^j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'#docstring = ast.get_docstring(node)h)jj  u}(j  has_doctestj  K
j  }(j  }(j  K_j  Kuj  }(j  K_j  Kuuj  }(j  }(j  K_j  Kuj  }(j  K_j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh':has_doctest = docstring is not None and ">>>" in docstringh)jj  u}(j  	signaturej  K
j  }(j  }(j  K`j  Kuj  }(j  K`j  K
uuj  }(j  }(j  K`j  Kuj  }(j  K`j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'"signature = _build_signature(node)h)jj  u}(j  internal_importsj  K
j  }(j  }(j  Kaj  Kuj  }(j  Kaj  Kuuj  }(j  }(j  Kaj  Kuj  }(j  Kaj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'1internal_imports = extract_internal_imports(node)h)jj  u}(j  impure_callsj  K
j  }(j  }(j  Kbj  Kuj  }(j  Kbj  Kuuj  }(j  }(j  Kbj  Kuj  }(j  Kbj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh')impure_calls = extract_impure_calls(node)h)jj  u}(j  
code_linesj  K
j  }(j  }(j  Kcj  Kuj  }(j  Kcj  Kuuj  }(j  }(j  Kcj  Kuj  }(j  Kcj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'#code_lines = count_code_lines(node)h)jj  u}(j  
doctest_linesj  K
j  }(j  }(j  Kdj  Kuj  }(j  Kdj  Kuuj  }(j  }(j  Kdj  Kuj  }(j  Kdj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh')doctest_lines = count_doctest_lines(node)h)jj  u}(j  function_callsj  K
j  }(j  }(j  Kej  Kuj  }(j  Kej  Kuuj  }(j  }(j  Kej  Kuj  }(j  Kej  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'4function_calls = extract_function_calls(node)  # P25h)jj  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jl  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: result.kind == SymbolKind.FUNCTION)
def _parse_function(node: ast.FunctionDef | ast.AsyncFunctionDef) -> Symbol:
    """Parse a function definition into a Symbol."""
    contracts = _extract_contracts(node)
    docstring = ast.get_docstring(node)
    has_doctest = docstring is not None and ">>>" in docstring
    signature = _build_signature(node)
    internal_imports = extract_internal_imports(node)
    impure_calls = extract_impure_calls(node)
    code_lines = count_code_lines(node)
    doctest_lines = count_doctest_lines(node)
    function_calls = extract_function_calls(node)  # P25

    return Symbol(
        name=node.name,
        kind=SymbolKind.FUNCTION,
        line=node.lineno,
        end_line=node.end_lineno or node.lineno,
        signature=signature,
        docstring=docstring,
        contracts=contracts,
        has_doctest=has_doctest,
        internal_imports=internal_imports,
        impure_calls=impure_calls,
        code_lines=code_lines,
        doctest_lines=doctest_lines,
        function_calls=function_calls,
    )h)j  u}(j  
_parse_methodj  Kj  }(j  }(j  Kxj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kzj  Kuj  }(j  Kzj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kzj  Kuj  }(j  Kzj  K>uuj  }(j  }(j  Kzj  Kuj  }(j  Kzj  K>uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'Inode: ast.FunctionDef | ast.AsyncFunctionDef, class_name: str) -> Symbol:h)j  u}(j  
class_namej  K
j  }(j  }(j  Kzj  K@uj  }(j  Kzj  KOuuj  }(j  }(j  Kzj  K@uj  }(j  Kzj  KOuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'class_name: str) -> Symbol:h)j  u}(j  	contractsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'$contracts = _extract_contracts(node)h)j  u}(j  	docstringj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j+  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'#docstring = ast.get_docstring(node)h)j  u}(j  has_doctestj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j8  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh':has_doctest = docstring is not None and ">>>" in docstringh)j  u}(j  	signaturej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jE  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'"signature = _build_signature(node)h)j  u}(j  internal_importsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jR  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'1internal_imports = extract_internal_imports(node)h)j  u}(j  impure_callsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(      j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j_  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh')impure_calls = extract_impure_calls(node)h)j  u}(j  
code_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jl  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'#code_lines = count_code_lines(node)h)j  u}(j  
doctest_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jy  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh')doctest_lines = count_doctest_lines(node)h)j  u}(j  function_callsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'4function_calls = extract_function_calls(node)  # P25h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda node, class_name: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: result.kind == SymbolKind.METHOD)
def _parse_method(node: ast.FunctionDef | ast.AsyncFunctionDef, class_name: str) -> Symbol:
    """
    Parse a method definition into a Symbol.

    Examples:
        >>> import ast
        >>> tree = ast.parse("class Foo:\\n    def bar(self): pass")
        >>> method_node = tree.body[0].body[0]
        >>> sym = _parse_method(method_node, "Foo")
        >>> sym.name
        'Foo.bar'
        >>> sym.kind.value
        'method'
    """
    contracts = _extract_contracts(node)
    docstring = ast.get_docstring(node)
    has_doctest = docstring is not None and ">>>" in docstring
    signature = _build_signature(node)
    internal_imports = extract_internal_imports(node)
    impure_calls = extract_impure_calls(node)
    code_lines = count_code_lines(node)
    doctest_lines = count_doctest_lines(node)
    function_calls = extract_function_calls(node)  # P25

    return Symbol(
        name=f"{class_name}.{node.name}",
        kind=SymbolKind.METHOD,
        line=node.lineno,
        end_line=node.end_lineno or node.lineno,
        signature=signature,
        docstring=docstring,
        contracts=contracts,
        has_doctest=has_doctest,
        internal_imports=internal_imports,
        impure_calls=impure_calls,
        code_lines=code_lines,
        doctest_lines=doctest_lines,
        function_calls=function_calls,
    )h)j  u}(j  _parse_classj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K#uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K#uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'node: ast.ClassDef) -> Symbol:h)j  u}(j  	docstringj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'#docstring = ast.get_docstring(node)h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda node: isinstance(node, ast.ClassDef))
@post(lambda result: result.kind == SymbolKind.CLASS)
def _parse_class(node: ast.ClassDef) -> Symbol:
    """Parse a class definition into a Symbol."""
    docstring = ast.get_docstring(node)

    return Symbol(
        name=node.name,
        kind=SymbolKind.CLASS,
        line=node.lineno,
        end_line=node.end_lineno or node.lineno,
        docstring=docstring,
    )h)j  u}(j  _extract_contractsj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  KCuuj  }(j  }(j  Kj  Kuj  }(j  Kj  KCuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'@node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[Contract]:h)j  u}(j  	contractsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'contracts: list[Contract] = []h)j  u}(j  	decoratorj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'!decorator in node.decorator_list:h)j  u}(j  contractj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'2contract = _parse_decorator_as_contract(decorator)h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: all(c.kind in ("pre", "post") for c in result))
def _extract_contracts(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[Contract]:
    """Extract @pre and @post contracts from function decorators."""
    contracts: list[Contract] = []

    for decorator in node.decorator_list:
        contract = _parse_decorator_as_contract(decorator)
        if contract:
            contracts.append(contract)

    return contractsh)j  u}(j  _parse_decorator_as_contractj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  K uuj  ](}(j  	decoratorj  K
j  }(j  }(j  Kj  K!uj  }(j  Kj  K4uuj  }(j  }(j  Kj  K!uj  }(j  Kj  K4uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'(decorator: ast.expr) -> Contract | None:h)j  u}(j  funcj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'func = decorator.funch)j  u}(j  exprj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j"  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'*expr = _get_contract_expression(decorator)h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @post(lambda result: result is None or result.kind in ("pre", "post"))
def _parse_decorator_as_contract(decorator: ast.expr) -> Contract | None:
    """Try to parse a decorator as a contract (@pre or @post)."""
    # Handle @pre(...) or @post(...)
    if isinstance(decorator, ast.Call):
        func = decorator.func
        if isinstance(func, ast.Name) and func.id in ("pre", "post"):
            expr = _get_contract_expression(decorator)
            return Contract(
                kind="pre" if func.id == "pre" else "post",
                expression=expr,
                line=decorator.lineno,
            )
        # Handle deal.pre(...) or deal.post(...)
        if isinstance(func, ast.Attribute) and func.attr in ("pre", "post"):
            expr = _get_contract_expression(decorator)
            return Contract(
                kind="pre" if func.attr == "pre" else "post",
                expression=expr,
                line=decorator.lineno,
            )

    return Noneh)j  u}(j  _get_contract_expressionj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]}(j  callj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K+uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K+uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j<  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'call: ast.Call) -> str:h)j1  uah}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j3  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'@pre(lambda call: isinstance(call, ast.Call))
def _get_contract_expression(call: ast.Call) -> str:
    """Extract the expression string from a contract decorator call."""
    if call.args:
        return ast.unparse(call.args[0])
    return ""h)j  u}(j  _build_signaturej  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  KAuuj  }(j  }(j  Kj  Kuj  }(j  Kj  KAuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jV  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'5node: ast.FunctionDef | ast.AsyncFunctionDef) -> str:h)jK  u}(j  argsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jc  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'args = node.argsh)jK  u}(j  partsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jp  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'parts: list[str] = []h)jK  u}(j  argj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j}  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'arg in args.args:h)jK  u}(j  partj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'part = arg.argh)jK  u}(j  sigj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'sig = f"({', '.join(parts)})"h)jK  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jM  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: result.startswith("(") and ")" in result)
def _build_signature(node: ast.FunctionDef | ast.AsyncFunctionDef) -> str:
    """Build a signature string from function arguments."""
    args = node.args
    parts: list[str] = []

    # Regular args
    for arg in args.args:
        part = arg.arg
        if arg.annotation:
            part += f": {ast.unparse(arg.annotation)}"
        parts.append(part)

    sig = f"({', '.join(parts)})"

    # Return type
    if node.returns:
        sig += f" -> {ast.unparse(node.returns)}"

    return sigh)j  u}(j  _extract_importsj  Kj  }(j  }(j  Kj  K uj  }(j  Mj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  treej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'tree: ast.Module) -> list[str]:h)j  u}(j  importsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'imports: list[str] = []h)j  u}(j  nodej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'node in tree.body:h)j  u}(j  aliasj  K
j  }(j  }(j  M j  Kuj  }(j  M j  Kuuj  }(j  }(j  M j  Kuj  }(j  M j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'alias in node.names:h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X]  @pre(lambda tree: isinstance(tree, ast.Module))
@post(lambda result: all(isinstance(s, str) and s for s in result))
def _extract_imports(tree: ast.Module) -> list[str]:
    """Extract imported module names from AST (top-level only)."""
    imports: list[str] = []

    for node in tree.body:
        if isinstance(node, ast.Import):
            for alias in node.names:
                imports.append(alias.name.split(".")[0])
        elif isinstance(node, ast.ImportFrom):
            if node.module:
                imports.append(node.module.split(".")[0])

    return list(set(imports))  # Deduplicateh)j  ueh)j  u}(j  inspectj  j  h#}(j  }(j  K j  K uj  }(j  Kj  K uuj  j  h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&src/invar/core/inspect.pyuj  ](}(nameFileContextkindKrange}(start}(lineK	characterK uend}(j  K7j  K.uuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  pathj  K
j  }(j  }(j  K&j  Kuj  }(j  K&j  Kuuj  }(j  }(j  K&j  Kuj  }(j  K&j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&src/invar/core/inspect.pyuh'	path: strh)j  u}(j  linesj  K
j  }(j  }(j  K'j  Kuj  }(j  K'j  K	uuj  }(j  }(j  K'j  Kuj  }(j  K'j  K	uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'
lines: inth)j  u}(j  	max_linesj  K
j  }(j  }(j  K(j  Kuj  }(j  K(j  K
uuj  }(j  }(j  K(j  Kuj  }(j  K(j  K
uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j   h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'max_lines: inth)j  u}(j  functions_totalj  K
j  }(j  }(j  K)j  Kuj  }(j  K)j  Kuuj  }(j  }(j  K)j  Kuj  }(j  K)j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j-  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'functions_total: inth)j  u}(j  functions_with_contractsj  K
j  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j:  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'functions_with_contracts: inth)j  u}(j  contract_examplesj  K
j  }(j  }(j  K+j  Kuj  }(j  K+j  Kuuj  }(j  }(j  K+j  Kuj  }(j  K+j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#jG  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'contract_examples: list[str]h)j  u}(j  
percentagej  Kj  }(j  }(j  K-j  Kuj  }(j  K2j  K5uuj  }(j  }(j  K.j  Kuj  }(j  K.j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#jT  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'@property
    def percentage(self) -> int:
        """Percentage of max lines used."""
        if self.max_lines == 0:
            return 0
        return int(self.lines / self.max_lines * 100)h)j  u}(j  has_patternsj  Kj  }(j  }(j  K4j  Kuj  }(j  K7j  K.uuj  }(j  }(j  K5j  Kuj  }(j  K5j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#ja  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'@property
    def has_patterns(self) -> bool:
        """Whether there are contract patterns to show."""
        return len(self.contract_examples) > 0h)j  ueh}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'X  @dataclass
class FileContext:
    """
    Context information about a file for inspection.

    Examples:
        >>> ctx = FileContext(
        ...     path="src/core/calc.py",
        ...     lines=150,
        ...     max_lines=500,
        ...     functions_total=5,
        ...     functions_with_contracts=3,
        ...     contract_examples=["@pre(lambda x: x > 0)", "@post(lambda result: result is not None)"]
        ... )
        >>> ctx.percentage
        30
        >>> ctx.has_patterns
        True
    """

    path: str
    lines: int
    max_lines: int
    functions_total: int
    functions_with_contracts: int
    contract_examples: list[str]

    @property
    def percentage(self) -> int:
        """Percentage of max lines used."""
        if self.max_lines == 0:
            return 0
        return int(self.lines / self.max_lines * 100)

    @property
    def has_patterns(self) -> bool:
        """Whether there are contract patterns to show."""
        return len(self.contract_examples) > 0h)j  u}(j  analyze_file_contextj  Kj  }(j  }(j  K:j  K uj  }(j  Koj  Kuuj  }(j  }(j  K;j  Kuj  }(j  K;j  Kuuj  ](}(j  sourcej  K
j  }(j  }(j  K;j  Kuj  }(j  K;j  K$uuj  }(j  }(j  K;j  Kuj  }(j  K;j  K$uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j{  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'=source: str, path: str, max_lines: int = 500) -> FileContext:h)jp  u}(j  pathj  K
j  }(j  }(j  K;j  K&uj  }(j  K;j  K/uuj  }(j  }(j  K;j  K&uj  }(j  K;j  K/uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'0path: str, max_lines: int = 500) -> FileContext:h)jp  u}(j  	max_linesj  K
j  }(j  }(j  K;j  K1uj  }(j  K;j  KEuuj  }(j  }(j  K;j  K1uj  }(j  K;j  KEuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'%max_lines: int = 500) -> FileContext:h)jp  u}(j  linesj  K
j  }(j  }(j  KPj  Kuj  }(j  KPj  K	uuj  }(j  }(j  KPj  Kuj  }(j  KPj  K	uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'lines = source.count("\n") + 1h)jp  u}(j  	file_infoj  K
j  }(j  }(j  KSj  Kuj  }(j  KSj  K
uuj  }(j  }(j  KSj  Kuj  }(j  KSj  K
uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'&file_info = parse_source(source, path)h)jp  u}(j  	functionsj  K
j  }(j  }(j  K^j  Kuj  }(j  K^j  K
uuj  }(j  }(j  K^j  Kuj  }(j  K^j  K
uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'`functions = [s for s in file_info.symbols if s.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD)]h)jp  u}(j  contract_examplesj  K
j  }(j  }(j  Kaj  Kuj  }(j  Kaj  Kuuj  }(j  }(j  Kaj  Kuj  }(j  Kaj  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'6contract_examples = _extract_contract_patterns(source)h)jp  u}(j  functions_with_contractsj  K
j  }(j  }(j  Kdj  Kuj  }(j  Kdj  Kuuj  }(j  }(j  Kdj  Kuj  }(j  Kdj  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'functions_with_contracts = sum(h)jp  ueh}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#jr  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'X  @pre(lambda source, path, max_lines: isinstance(source, str) and max_lines > 0)
def analyze_file_context(source: str, path: str, max_lines: int = 500) -> FileContext:
    """
    Analyze a source file to extract context for inspection.

    Examples:
        >>> source = '''
        ... from deal import pre
        ... @pre(lambda x: x > 0)
        ... def positive(x: int) -> int:
        ...     return x * 2
        ... def no_contract(y):
        ...     return y
        ... '''
        >>> ctx = analyze_file_context(source.strip(), "test.py", 500)
        >>> ctx.functions_total
        2
        >>> ctx.functions_with_contracts
        1
        >>> "@pre(lambda x: x > 0)" in ctx.contract_examples
        True
    """
    lines = source.count("\n") + 1

    # Parse to find functions
    file_info = parse_source(source, path)
    if file_info is None:
        return FileContext(
            path=path,
            lines=lines,
            max_lines=max_lines,
            functions_total=0,
            functions_with_contracts=0,
            contract_examples=[],
        )

    functions = [s for s in file_info.symbols if s.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD)]

    # Find contract patterns in source
    contract_examples = _extract_contract_patterns(source)

    # Count functions with contracts (Symbol.contracts is non-empty)
    functions_with_contracts = sum(
        1 for f in functions if len(f.contracts) > 0
    )

    return FileContext(
        path=path,
        lines=lines,
        max_lines=max_lines,
        functions_total=len(functions),
        functions_with_contracts=functions_with_contracts,
        contract_examples=contract_examples[:3],  # Limit to 3 examples
    )h)j  u}(j  _extract_contract_patternsj  Kj  }(j  }(j  Krj  K uj  }(j  Kj  Kuuj  }(j  }(j  Krj  Kuj  }(j  Krj  Kuuj  ](}(j  sourcej  K
j  }(j  }(j  Krj  Kuj  }(j  Krj  K*uuj  }(j  }(j  Krj  Kuj  }(j  Krj  K*uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'source: str) -> list[str]:h)j  u}(j  patternsj  K
j  }(j  }(j  K~j  Kuj  }(j  K~j  Kuuj  }(j  }(j  K~j  Kuj  }(j  K~j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'
patterns = []h)j  u}(j  matchj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j
  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'6match in re.finditer(r"@(pre|post)\([^)]+\)", source):h)j  u}(j  patternj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'pattern = match.group(0)h)j  ueh}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'X  def _extract_contract_patterns(source: str) -> list[str]:
    """
    Extract @pre/@post patterns from source.

    Examples:
        >>> src = "@pre(lambda x: x > 0)\\n@post(lambda r: r is not None)"
        >>> patterns = _extract_contract_patterns(src)
        >>> len(patterns)
        2
        >>> "@pre(lambda x: x > 0)" in patterns
        True
    """
    patterns = []

    # Match @pre(...) and @post(...) decorators
    for match in re.finditer(r"@(pre|post)\([^)]+\)", source):
        pattern = match.group(0)
        # Simplify if too long
        if len(pattern) > 60:
            pattern = pattern[:57] + "..."
        if pattern not in patterns:
            patterns.append(pattern)

    return patternsh)j  ueh)j  u}(j  
extractionj  j  h#}(j  }(j  K j  K uj  }(j  Kj  K uuj  j(  h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j(  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&src/invar/core/extraction.pyuj  ](}(namefind_extractable_groupskindKrange}(start}(lineK
	characterK uend}(j8  KVj9  KuuselectionRange}(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  Kuuchildren](}(j1  	file_infoj3  K
j4  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K/uuj<  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K/uuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jD  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&src/invar/core/extraction.pyuh'#file_info: FileInfo) -> list[dict]:h)j0  u}(j1  funcsj3  K
j4  }(j6  }(j8  K'j9  Kuj:  }(j8  K'j9  K	uuj<  }(j6  }(j8  K'j9  Kuj:  }(j8  K'j9  K	uuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jR  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'-funcs = {s.name: s for s in file_info.symbolsh)j0  u}(j1  
func_namesj3  K
j4  }(j6  }(j8  K.j9  Kuj:  }(j8  K.j9  Kuuj<  }(j6  }(j8  K.j9  Kuj:  }(j8  K.j9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j_  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'func_names = set(funcs.keys())h)j0  u}(j1  graphj3  K
j4  }(j6  }(j8  K/j9  Kuj:  }(j8  K/j9  K	uuj<  }(j6  }(j8  K/j9  Kuj:  }(j8  K/j9  K	uuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jl  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'Agraph: dict[str, set[str]] = {name: set() for name in func_names}h)j0  u}(j1  namej3  K
j4  }(j6  }(j8  K1j9  Kuj:  }(j8  K1j9  Kuuj<  }(j6  }(j8  K1j9  Kuj:  }(j8  K1j9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jy  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'name, sym in funcs.items():h)j0  u}(j1  symj3  K
j4  }(j6  }(j8  K1j9  Kuj:  }(j8  K1j9  Kuuj<  }(j6  }(j8  K1j9  Kuj:  }(j8  K1j9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'sym in funcs.items():h)j0  u}(j1  calledj3  K
j4  }(j6  }(j8  K2j9  Kuj:  }(j8  K2j9  Kuuj<  }(j6  }(j8  K2j9  Kuj:  }(j8  K2j9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'called in sym.function_calls:h)j0  u}(j1  visitedj3  K
j4  }(j6  }(j8  K8j9  Kuj:  }(j8  K8j9  Kuuj<  }(j6  }(j8  K8j9  Kuj:  }(j8  K8j9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'visited: set[str] = set()h)j0  u}(j1  groupsj3  K
j4  }(j6  }(j8  K9j9  Kuj:  }(j8  K9j9  K
uuj<  }(j6  }(j8  K9j9  Kuj:  }(j8  K9j9  K
uuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'groups: list[dict] = []h)j0  u}(j1  	componentj3  K
j4  }(j6  }(j8  K@j9  Kuj:  }(j8  K@j9  Kuuj<  }(j6  }(j8  K@j9  Kuj:  }(j8  K@j9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'component: list[str] = []h)j0  u}(j1  queuej3  K
j4  }(j6  }(j8  KAj9  Kuj:  }(j8  KAj9  K
uuj<  }(j6  }(j8  KAj9  Kuj:  }(j8  KAj9  K
uuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'queue = [name]h)j0  u}(j1  currentj3  K
j4  }(j6  }(j8  KCj9  Kuj:  }(j8  KCj9  Kuuj<  }(j6  }(j8  KCj9  Kuj:  }(j8  KCj9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'current = queue.pop(0)h)j0  u}(j1  total_linesj3  K
j4  }(j6  }(j8  KKj9  Kuj:  }(j8  KKj9  Kuuj<  }(j6  }(j8  KKj9  Kuj:  }(j8  KKj9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'Ktotal_lines = sum(funcs[n].end_line - funcs[n].line + 1 for n in component)h)j0  u}(j1  depsj3  K
j4  }(j6  }(j8  KLj9  Kuj:  }(j8  KLj9  Kuuj<  }(j6  }(j8  KLj9  Kuj:  }(j8  KLj9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'Cdeps = _get_group_dependencies(component, funcs, file_info.imports)h)j0  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j5  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'XL
  @pre(lambda file_info: isinstance(file_info, FileInfo))
def find_extractable_groups(file_info: FileInfo) -> list[dict]:
    """
    Find groups of related functions that could be extracted together.

    Uses function call relationships to identify connected components.
    Returns groups sorted by total lines (largest first).

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> s1 = Symbol(name="main", kind=SymbolKind.FUNCTION, line=1, end_line=20,
        ...     function_calls=["helper"])
        >>> s2 = Symbol(name="helper", kind=SymbolKind.FUNCTION, line=21, end_line=30,
        ...     function_calls=[])
        >>> s3 = Symbol(name="unrelated", kind=SymbolKind.FUNCTION, line=31, end_line=40,
        ...     function_calls=[])
        >>> info = FileInfo(path="test.py", lines=40, symbols=[s1, s2, s3])
        >>> groups = find_extractable_groups(info)
        >>> len(groups)
        2
        >>> sorted(groups[0]["functions"])  # Largest group first
        ['helper', 'main']
        >>> groups[0]["lines"]
        30
    """
    # Get only functions/methods
    funcs = {s.name: s for s in file_info.symbols
             if s.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD)}

    if not funcs:
        return []

    # Build call graph (only internal calls)
    func_names = set(funcs.keys())
    graph: dict[str, set[str]] = {name: set() for name in func_names}

    for name, sym in funcs.items():
        for called in sym.function_calls:
            if called in func_names:
                graph[name].add(called)
                graph[called].add(name)  # Bidirectional for grouping

    # Find connected components
    visited: set[str] = set()
    groups: list[dict] = []

    for name in func_names:
        if name in visited:
            continue

        # BFS to find all connected functions
        component: list[str] = []
        queue = [name]
        while queue:
            current = queue.pop(0)
            if current in visited:
                continue
            visited.add(current)
            component.append(current)
            queue.extend(n for n in graph[current] if n not in visited)

        # Calculate group stats
        total_lines = sum(funcs[n].end_line - funcs[n].line + 1 for n in component)
        deps = _get_group_dependencies(component, funcs, file_info.imports)

        groups.append({
            "functions": sorted(component),
            "lines": total_lines,
            "dependencies": sorted(deps),
        })

    # Sort by lines (largest first)
    groups.sort(key=lambda g: -g["lines"])
    return groupsh)j&  u}(j1  _get_group_dependenciesj3  Kj4  }(j6  }(j8  KYj9  K uj:  }(j8  Khj9  KIuuj<  }(j6  }(j8  KYj9  Kuj:  }(j8  KYj9  Kuuj@  ](}(j1  
func_namesj3  K
j4  }(j6  }(j8  KZj9  Kuj:  }(j8  KZj9  Kuuj<  }(j6  }(j8  KZj9  Kuj:  }(j8  KZj9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'func_names: list[str],h)j  u}(j1  funcsj3  K
j4  }(j6  }(j8  K[j9  Kuj:  }(j8  K[j9  Kuuj<  }(j6  }(j8  K[j9  Kuj:  }(j8  K[j9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'funcs: dict[str, Symbol],h)j  u}(j1  file_importsj3  K
j4  }(j6  }(j8  K\j9  Kuj:  }(j8  K\j9  Kuuj<  }(j6  }(j8  K\j9  Kuj:  }(j8  K\j9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j"  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'file_imports: list[str],h)j  u}(j1  depsj3  K
j4  }(j6  }(j8  K_j9  Kuj:  }(j8  K_j9  Kuuj<  }(j6  }(j8  K_j9  Kuj:  }(j8  K_j9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j/  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'deps: set[str] = set()h)j  u}(j1  namej3  K
j4  }(j6  }(j8  Kaj9  Kuj:  }(j8  Kaj9  Kuuj<  }(j6  }(j8  Kaj9  Kuj:  }(j8  Kaj9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j<  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'name in func_names:h)j  u}(j1  symj3  K
j4  }(j6  }(j8  Kbj9  Kuj:  }(j8  Kbj9  Kuuj<  }(j6  }(j8  Kbj9  Kuj:  }(j8  Kbj9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jI  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'sym = funcs[name]h)j  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'X/  def _get_group_dependencies(
    func_names: list[str],
    funcs: dict[str, Symbol],
    file_imports: list[str],
) -> set[str]:
    """Get external dependencies used by a group of functions."""
    deps: set[str] = set()

    for name in func_names:
        sym = funcs[name]
        # Add internal imports used by this function
        deps.update(sym.internal_imports)

    # Filter to only include actual imports from file
    # (some internal_imports might be from nested scopes)
    return deps.intersection(set(file_imports)) if file_imports else depsh)j&  u}(j1  format_extraction_hintj3  Kj4  }(j6  }(j8  Kkj9  K uj:  }(j8  Kj9  Kuuj<  }(j6  }(j8  Klj9  Kuj:  }(j8  Klj9  Kuuj@  ](}(j1  	file_infoj3  K
j4  }(j6  }(j8  Klj9  Kuj:  }(j8  Klj9  K.uuj<  }(j6  }(j8  Klj9  Kuj:  }(j8  Klj9  K.uuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jc  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'1file_info: FileInfo, max_groups: int = 3) -> str:h)jX  u}(j1  
max_groupsj3  K
j4  }(j6  }(j8  Klj9  K0uj:  }(j8  Klj9  KCuuj<  }(j6  }(j8  Klj9  K0uj:  }(j8  Klj9  KCuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jp  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'max_groups: int = 3) -> str:h)jX  u}(j1  groupsj3  K
j4  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K
uuj<  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K
uuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j}  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'+groups = find_extractable_groups(file_info)h)jX  u}(j1  hintsj3  K
j4  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K	uuj<  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K	uuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'hints: list[str] = []h)jX  u}(j1  ij3  K
j4  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K	uuj<  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K	uuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'+i, group in enumerate(groups[:max_groups]):h)jX  u}(j1  groupj3  K
j4  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  Kuuj<  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'(group in enumerate(groups[:max_groups]):h)jX  u}(j1  funcsj3  K
j4  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K
uuj<  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K
uuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'%funcs = ", ".join(group["functions"])h)jX  u}(j1  linesj3  K
j4  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K
uuj<  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  K
uuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'lines = group["lines"]h)jX  u}(j1  depsj3  K
j4  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  Kuuj<  }(j6  }(j8  Kj9  Kuj:  }(j8  Kj9  Kuuj@  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'Ldeps = ", ".join(group["dependencies"]) if group["dependencies"] else "none"h)jX  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jZ  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&jN  uh'XU  @pre(lambda file_info, max_groups=3: isinstance(file_info, FileInfo))
def format_extraction_hint(file_info: FileInfo, max_groups: int = 3) -> str:
    """
    Format extraction suggestions for file_size_warning.

    P25: Shows extractable function groups with dependencies.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> s1 = Symbol(name="parse", kind=SymbolKind.FUNCTION, line=1, end_line=50,
        ...     function_calls=["validate"], internal_imports=["ast"])
        >>> s2 = Symbol(name="validate", kind=SymbolKind.FUNCTION, line=51, end_line=80,
        ...     function_calls=[], internal_imports=["ast"])
        >>> info = FileInfo(path="test.py", lines=100, symbols=[s1, s2], imports=["ast", "re"])
        >>> hint = format_extraction_hint(info)
        >>> "parse, validate" in hint
        True
        >>> "(80L)" in hint
        True
    """
    groups = find_extractable_groups(file_info)

    if not groups:
        return ""

    # Format top N groups
    hints: list[str] = []
    for i, group in enumerate(groups[:max_groups]):
        funcs = ", ".join(group["functions"])
        lines = group["lines"]
        deps = ", ".join(group["dependencies"]) if group["dependencies"] else "none"
        hints.append(f"[{chr(65+i)}] {funcs} ({lines}L) | Deps: {deps}")

    return "\n".join(hints)h)j&  ueh)j  u}(j  utilsj  j  h#}(j  }(j  K j  K uj  }(j  Kj  K uuj  j  h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&src/invar/core/utils.pyuj  ](}(name
get_exit_codekindKrange}(start}(lineK	characterK uend}(j  K$j  KuuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  reportj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&src/invar/core/utils.pyuh'*report: GuardReport, strict: bool) -> int:h)j  u}(j  strictj  K
j  }(j  }(j  Kj  K'uj  }(j  Kj  K3uuj  }(j  }(j  Kj  K'uj  }(j  Kj  K3uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'strict: bool) -> int:h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'Xx  @pre(lambda report, strict: isinstance(report, GuardReport))
@post(lambda result: result in (0, 1))
def get_exit_code(report: GuardReport, strict: bool) -> int:
    """
    Determine exit code based on report and strict mode.

    Examples:
        >>> from invar.core.models import GuardReport
        >>> get_exit_code(GuardReport(files_checked=1), strict=False)
        0
        >>> report = GuardReport(files_checked=1)
        >>> report.errors = 1
        >>> get_exit_code(report, strict=False)
        1
    """
    if report.errors > 0:
        return 1
    if strict and report.warnings > 0:
        return 1
    return 0h)j  u}(j  extract_guard_sectionj  Kj  }(j  }(j  K'j  K uj  }(j  K8j  K uuj  }(j  }(j  K)j  Kuj  }(j  K)j  Kuuj  ](}(j  dataj  K
j  }(j  }(j  K)j  Kuj  }(j  K)j  K.uuj  }(j  }(j  K)j  Kuj  }(j  K)j  K.uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j   h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'5data: dict[str, Any], source: str) -> dict[str, Any]:h)j  u}(j  sourcej  K
j  }(j  }(j  K)j  K0uj  }(j  K)j  K;uuj  }(j  }(j  K)j  K0uj  }(j  K)j  K;uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j-  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'source: str) -> dict[str, Any]:h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'X  @pre(lambda data, source: isinstance(data, dict))
@post(lambda result: isinstance(result, dict))
def extract_guard_section(data: dict[str, Any], source: str) -> dict[str, Any]:
    """
    Extract guard config section based on source type.

    Examples:
        >>> extract_guard_section({"tool": {"invar": {"guard": {"x": 1}}}}, "pyproject")
        {'x': 1}
        >>> extract_guard_section({"guard": {"y": 2}}, "invar")
        {'y': 2}
        >>> extract_guard_section({}, "default")
        {}
    """
    if source == "pyproject":
        return data.get("tool", {}).get("invar", {}).get("guard", {})
    # invar.toml and .invar/config.toml use [guard] directly
    return data.get("guard", {})h)j  u}(j  parse_guard_configj  Kj  }(j  }(j  K;j  K uj  }(j  K}j  Kuuj  }(j  }(j  K=j  Kuj  }(j  K=j  Kuuj  ](}(j  guard_configj  K
j  }(j  }(j  K=j  Kuj  }(j  K=j  K3uuj  }(j  }(j  K=j  Kuj  }(j  K=j  K3uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jG  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh',guard_config: dict[str, Any]) -> RuleConfig:h)j<  u}(j  kwargsj  K
j  }(j  }(j  KNj  Kuj  }(j  KNj  K
uuj  }(j  }(j  KNj  Kuj  }(j  KNj  K
uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jT  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'kwargs: dict[str, Any] = {}h)j<  u}(j  
exclusionsj  K
j  }(j  }(j  Kjj  Kuj  }(j  Kjj  Kuuj  }(j  }(j  Kjj  Kuj  }(j  Kjj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#ja  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'exclusions = []h)j<  u}(j  exclj  K
j  }(j  }(j  Kkj  Kuj  }(j  Kkj  Kuuj  }(j  }(j  Kkj  Kuj  }(j  Kkj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jn  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'(excl in guard_config["rule_exclusions"]:h)j<  u}(j  defaultsj  K
j  }(j  }(j  Kuj  Kuj  }(j  Kuj  Kuuj  }(j  }(j  Kuj  Kuj  }(j  Kuj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j{  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'-defaults = {"redundant_type_contract": "off"}h)j<  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j>  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'X	  @pre(lambda guard_config: isinstance(guard_config, dict))
@post(lambda result: isinstance(result, RuleConfig))
def parse_guard_config(guard_config: dict[str, Any]) -> RuleConfig:
    """
    Parse configuration from guard section.

    Examples:
        >>> cfg = parse_guard_config({"max_file_lines": 400})
        >>> cfg.max_file_lines
        400
        >>> cfg = parse_guard_config({})
        >>> cfg.max_file_lines  # Phase 9 P1: Default is now 500
        500
        >>> cfg = parse_guard_config({"rule_exclusions": [{"pattern": "**/gen/**", "rules": ["*"]}]})
        >>> len(cfg.rule_exclusions)
        1
        >>> cfg.rule_exclusions[0].pattern
        '**/gen/**'
    """
    kwargs: dict[str, Any] = {}

    if "max_file_lines" in guard_config:
        kwargs["max_file_lines"] = guard_config["max_file_lines"]

    if "max_function_lines" in guard_config:
        kwargs["max_function_lines"] = guard_config["max_function_lines"]

    if "forbidden_imports" in guard_config:
        kwargs["forbidden_imports"] = tuple(guard_config["forbidden_imports"])

    if "require_contracts" in guard_config:
        kwargs["require_contracts"] = guard_config["require_contracts"]

    if "require_doctests" in guard_config:
        kwargs["require_doctests"] = guard_config["require_doctests"]

    if "strict_pure" in guard_config:
        kwargs["strict_pure"] = guard_config["strict_pure"]

    if "use_code_lines" in guard_config:
        kwargs["use_code_lines"] = guard_config["use_code_lines"]

    if "exclude_doctest_lines" in guard_config:
        kwargs["exclude_doctest_lines"] = guard_config["exclude_doctest_lines"]

    # Phase 9 P1: Parse rule_exclusions
    if "rule_exclusions" in guard_config:
        exclusions = []
        for excl in guard_config["rule_exclusions"]:
            exclusions.append(RuleExclusion(
                pattern=excl["pattern"],
                rules=excl["rules"],
            ))
        kwargs["rule_exclusions"] = exclusions

    # Phase 9 P2: Parse severity_overrides (merge with defaults)
    if "severity_overrides" in guard_config:
        # Get default overrides and update with user config
        defaults = {"redundant_type_contract": "off"}
        defaults.update(guard_config["severity_overrides"])
        kwargs["severity_overrides"] = defaults

    # Phase 9 P8: Parse size_warning_threshold
    if "size_warning_threshold" in guard_config:
        kwargs["size_warning_threshold"] = guard_config["size_warning_threshold"]

    return RuleConfig(**kwargs)h)j  u}(j  matches_patternj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  	file_pathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K"uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K"uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'-file_path: str, patterns: list[str]) -> bool:h)j  u}(j  patternsj  K
j  }(j  }(j  Kj  K$uj  }(j  Kj  K7uuj  }(j  }(j  Kj  K$uj  }(j  Kj  K7uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'patterns: list[str]) -> bool:h)j  u}(j  patternj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'pattern in patterns:h)j  u}(j  partsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'parts = file_path.split("/")h)j  u}(j  j  j  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'i in range(len(parts)):h)j  u}(j  subpathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'subpath = "/".join(parts[i:])h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'XP  @pre(lambda file_path, patterns: isinstance(file_path, str) and isinstance(patterns, list))
def matches_pattern(file_path: str, patterns: list[str]) -> bool:
    """
    Check if a file path matches any of the glob patterns.

    Examples:
        >>> matches_pattern("src/domain/models.py", ["**/domain/**"])
        True
        >>> matches_pattern("src/api/views.py", ["**/domain/**"])
        False
        >>> matches_pattern("src/core/logic.py", ["src/core/**", "**/models/**"])
        True
    """
    for pattern in patterns:
        if fnmatch.fnmatch(file_path, pattern):
            return True
        # Also check with leading path component for ** patterns
        if pattern.startswith("**/"):
            # Match anywhere in path
            if fnmatch.fnmatch(file_path, pattern[3:]):
                return True
            # Try matching each subpath
            parts = file_path.split("/")
            for i in range(len(parts)):
                subpath = "/".join(parts[i:])
                if fnmatch.fnmatch(subpath, pattern[3:]):
                    return True
    return Falseh)j  u}(j  matches_path_prefixj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  K9uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  	file_pathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K&uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K&uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'-file_path: str, prefixes: list[str]) -> bool:h)j  u}(j  prefixesj  K
j  }(j  }(j  Kj  K(uj  }(j  Kj  K;uuj  }(j  }(j  Kj  K(uj  }(j  Kj  K;uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'prefixes: list[str]) -> bool:h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'X  @pre(lambda file_path, prefixes: isinstance(file_path, str) and isinstance(prefixes, list))
def matches_path_prefix(file_path: str, prefixes: list[str]) -> bool:
    """
    Check if file_path starts with any of the given prefixes.

    Examples:
        >>> matches_path_prefix("src/core/logic.py", ["src/core", "src/domain"])
        True
        >>> matches_path_prefix("src/shell/cli.py", ["src/core", "src/domain"])
        False
    """
    return any(file_path.startswith(p) for p in prefixes)h)j  u}(j  match_glob_patternj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  	file_pathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'&file_path: str, pattern: str) -> bool:h)j  u}(j  patternj  K
j  }(j  }(j  Kj  K'uj  }(j  Kj  K3uuj  }(j  }(j  Kj  K'uj  }(j  Kj  K3uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j#  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'pattern: str) -> bool:h)j  u}(j  
path_partsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j0  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'!path_parts = file_path.split("/")h)j  u}(j  middlej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j=  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'middle = pattern[3:-3]h)j  u}(j  suffixj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jJ  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'suffix = pattern[3:]h)j  u}(j  j  j  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jV  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'i in range(len(path_parts)):h)j  u}(j  prefixj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jc  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'prefix = pattern[:-3]h)j  u}(j  partsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jp  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'parts = pattern.split("**/")h)j  u}(j  headj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j}  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'0head = "/".join(path_parts[:i]) if i > 0 else ""h)j  u}(j  tailj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'tail = "/".join(path_parts[i:])h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j
  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'X  def match_glob_pattern(file_path: str, pattern: str) -> bool:
    """
    Check if file path matches a glob pattern with ** support.

    Uses fnmatch for single-segment wildcards, handles ** for multi-segment.

    Examples:
        >>> match_glob_pattern("src/generated/foo.py", "**/generated/**")
        True
        >>> match_glob_pattern("generated/foo.py", "**/generated/**")
        True
        >>> match_glob_pattern("src/core/calc.py", "**/generated/**")
        False
        >>> match_glob_pattern("src/core/data.py", "src/core/data.py")
        True
        >>> match_glob_pattern("src/core/calc.py", "src/core/*.py")
        True
        >>> match_glob_pattern("src/core/sub/calc.py", "src/core/*.py")
        False
        >>> match_glob_pattern("src/core/sub/calc.py", "src/core/**/*.py")
        True
    """
    file_path = file_path.replace("\\", "/")
    pattern = pattern.replace("\\", "/")
    if "**" not in pattern:
        if file_path.count("/") != pattern.count("/"):
            return False
        return fnmatch.fnmatch(file_path, pattern)
    path_parts = file_path.split("/")
    if pattern.startswith("**/") and pattern.endswith("/**"):
        middle = pattern[3:-3]
        if "/" not in middle and "*" not in middle:
            return middle in path_parts[:-1]
    if pattern.startswith("**/") and not pattern.endswith("/**"):
        suffix = pattern[3:]
        for i in range(len(path_parts)):
            if fnmatch.fnmatch("/".join(path_parts[i:]), suffix):
                return True
        return False
    if pattern.endswith("/**") and not pattern.startswith("**/"):
        prefix = pattern[:-3]
        return file_path.startswith(prefix + "/") or file_path == prefix
    parts = pattern.split("**/")
    if len(parts) == 2:
        prefix, suffix = parts[0].rstrip("/"), parts[1].lstrip("/").rstrip("/**")
        for i in range(len(path_parts) + 1):
            head = "/".join(path_parts[:i]) if i > 0 else ""
            tail = "/".join(path_parts[i:])
            if (not prefix or fnmatch.fnmatch(head, prefix)) and \
               (not suffix or fnmatch.fnmatch(tail, suffix) or fnmatch.fnmatch(tail, "*/" + suffix)):
                return True
    return Falseh)j  u}(j  get_excluded_rulesj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  	file_pathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'0file_path: str, config: RuleConfig) -> set[str]:h)j  u}(j  configj  K
j  }(j  }(j  Kj  K'uj  }(j  Kj  K9uuj  }(j  }(j  Kj  K'uj  }(j  Kj  K9uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh' config: RuleConfig) -> set[str]:h)j  u}(j  excludedj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'excluded: set[str] = set()h)j  u}(j  	exclusionj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'$exclusion in config.rule_exclusions:h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'X  @pre(lambda file_path, config: isinstance(config, RuleConfig))
def get_excluded_rules(file_path: str, config: RuleConfig) -> set[str]:
    """
    Get the set of rules to exclude for a given file path.

    Examples:
        >>> from invar.core.models import RuleConfig, RuleExclusion
        >>> excl = RuleExclusion(pattern="**/generated/**", rules=["*"])
        >>> cfg = RuleConfig(rule_exclusions=[excl])
        >>> get_excluded_rules("src/generated/foo.py", cfg)
        {'*'}
        >>> get_excluded_rules("src/core/calc.py", cfg)
        set()
        >>> excl2 = RuleExclusion(pattern="**/data/**", rules=["file_size"])
        >>> cfg2 = RuleConfig(rule_exclusions=[excl, excl2])
        >>> sorted(get_excluded_rules("src/data/big.py", cfg2))
        ['file_size']
    """
    excluded: set[str] = set()
    for exclusion in config.rule_exclusions:
        if match_glob_pattern(file_path, exclusion.pattern):
            excluded.update(exclusion.rules)
    return excludedh)j  ueh)j  u}(j  lambda_helpersj  j  h#}(j  }(j  K j  K uj  }(j  K~j  K uuj  j  h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh& src/invar/core/lambda_helpers.pyuj  ](}(namefind_lambdakindKrange}(start}(lineK	characterK uend}(j  Kj  KOuuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren]}(j  treej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K$uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K$uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh& src/invar/core/lambda_helpers.pyuh'+tree: ast.Expression) -> ast.Lambda | None:h)j  uah}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'X  def find_lambda(tree: ast.Expression) -> ast.Lambda | None:
    """Find the lambda node in an expression tree.

    Examples:
        >>> tree = ast.parse("lambda x: x > 0", mode="eval")
        >>> find_lambda(tree) is not None
        True
        >>> tree = ast.parse("x + y", mode="eval")
        >>> find_lambda(tree) is None
        True
    """
    return next((n for n in ast.walk(tree) if isinstance(n, ast.Lambda)), None)h)j  u}(j  extract_annotationsj  Kj  }(j  }(j  Kj  K uj  }(j  K.j  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  	signaturej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K&uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K&uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'"signature: str) -> dict[str, str]:h)j  u}(j  annotationsj  K
j  }(j  }(j  K#j  Kuj  }(j  K#j  Kuuj  }(j  }(j  K#j  Kuj  }(j  K#j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j   h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'annotations = {}h)j  u}(j  matchj  K
j  }(j  }(j  K$j  Kuj  }(j  K$j  K	uuj  }(j  }(j  K$j  Kuj  }(j         K$j  K	uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j-  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'+match = re.match(r"\(([^)]*)\)", signature)h)j  u}(j  paramj  K
j  }(j  }(j  K'j  Kuj  }(j  K'j  K
uuj  }(j  }(j  K'j  Kuj  }(j  K'j  K
uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j:  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'#param in match.group(1).split(","):h)j  u}(j  namej  K
j  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#jG  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'&name, type_hint = param.split(": ", 1)h)j  u}(j  	type_hintj  K
j  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#jT  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh' type_hint = param.split(": ", 1)h)j  ueh}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j
  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'Xz  def extract_annotations(signature: str) -> dict[str, str]:
    """Extract parameter type annotations from signature.

    Examples:
        >>> extract_annotations("(x: int, y: str) -> bool")
        {'x': 'int', 'y': 'str'}
        >>> extract_annotations("(items: list[int]) -> None")
        {'items': 'list[int]'}
        >>> extract_annotations("(x, y)")
        {}
    """
    if not signature or not signature.startswith("("):
        return {}
    annotations = {}
    match = re.match(r"\(([^)]*)\)", signature)
    if not match:
        return annotations
    for param in match.group(1).split(","):
        param = param.strip()
        if ": " in param:
            name, type_hint = param.split(": ", 1)
            if "=" in type_hint:
                type_hint = type_hint.split("=")[0].strip()
            annotations[name.strip()] = type_hint.strip()
    return annotationsh)j  u}(j  extract_lambda_paramsj  Kj  }(j  }(j  K1j  K uj  }(j  KCj  Kuuj  }(j  }(j  K1j  Kuj  }(j  K1j  Kuuj  ](}(j  
expressionj  K
j  }(j  }(j  K1j  Kuj  }(j  K1j  K)uuj  }(j  }(j  K1j  Kuj  }(j  K1j  K)uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#jn  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'%expression: str) -> list[str] | None:h)jc  u}(j  treej  K
j  }(j  }(j  K?j  Kuj  }(j  K?j  Kuuj  }(j  }(j  K?j  Kuj  }(j  K?j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j{  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh')tree = ast.parse(expression, mode="eval")h)jc  u}(j  lambda_nodej  K
j  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'lambda_node = find_lambda(tree)h)jc  ueh}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#je  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'X  def extract_lambda_params(expression: str) -> list[str] | None:
    """Extract parameter names from a lambda expression.

    Examples:
        >>> extract_lambda_params("lambda x, y: x > 0")
        ['x', 'y']
        >>> extract_lambda_params("lambda: True")
        []
        >>> extract_lambda_params("not a lambda") is None
        True
    """
    if not expression.strip() or "lambda" not in expression:
        return None
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        return [arg.arg for arg in lambda_node.args.args] if lambda_node else None
    except SyntaxError:
        return Noneh)j  u}(j  extract_func_param_namesj  Kj  }(j  }(j  KFj  K uj  }(j  Kjj  Kuuj  }(j  }(j  KFj  Kuj  }(j  KFj  Kuuj  ](}(j  	signaturej  K
j  }(j  }(j  KFj  Kuj  }(j  KFj  K+uuj  }(j  }(j  KFj  Kuj  }(j  KFj  K+uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'$signature: str) -> list[str] | None:h)j  u}(j  matchj  K
j  }(j  }(j  KSj  Kuj  }(j  KSj  K	uuj  }(j  }(j  KSj  Kuj  }(j  KSj  K	uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'+match = re.match(r"\(([^)]*)\)", signature)h)j  u}(j  contentj  K
j  }(j  }(j  KVj  Kuj  }(j  KVj  Kuuj  }(j  }(j  KVj  Kuj  }(j  KVj  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh' content = match.group(1).strip()h)j  u}(j  paramsj  K
j  }(j  }(j  KZj  Kuj  }(j  KZj  K
uuj  }(j  }(j  KZj  Kuj  }(j  KZj  K
uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'params = []h)j  u}(j  currentj  K
j  }(j  }(j  K[j  Kuj  }(j  K[j  Kuuj  }(j  }(j  K[j  Kuj  }(j  K[j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'current = ""h)j  u}(j  depthj  K
j  }(j  }(j  K\j  Kuj  }(j  K\j  K	uuj  }(j  }(j  K\j  Kuj  }(j  K\j  K	uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'	depth = 0h)j  u}(j  charj  K
j  }(j  }(j  K]j  Kuj  }(j  K]j  Kuuj  }(j  }(j  K]j  Kuj  }(j  K]j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'char in content:h)j  ueh}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'X  def extract_func_param_names(signature: str) -> list[str] | None:
    """Extract parameter names from a function signature (handles nested brackets).

    Examples:
        >>> extract_func_param_names("(x: int, y: int) -> int")
        ['x', 'y']
        >>> extract_func_param_names("(items: dict[str, int]) -> None")
        ['items']
        >>> extract_func_param_names("() -> bool")
        []
    """
    if not signature or not signature.startswith("("):
        return None
    match = re.match(r"\(([^)]*)\)", signature)
    if not match:
        return None
    content = match.group(1).strip()
    if not content:
        return []
    # Split by comma, but respect brackets (for dict[K, V], tuple[A, B], etc.)
    params = []
    current = ""
    depth = 0
    for char in content:
        if char in "([{":
            depth += 1
        elif char in ")]}":
            depth -= 1
        elif char == "," and depth == 0:
            if current.strip():
                params.append(current.strip().split(":")[0].split("=")[0].strip())
            current = ""
            continue
        current += char
    if current.strip():
        params.append(current.strip().split(":")[0].split("=")[0].strip())
    return paramsh)j  u}(j  extract_used_namesj  Kj  }(j  }(j  Kmj  K uj  }(j  K|j  Kuuj  }(j  }(j  Kmj  Kuj  }(j  Kmj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kmj  Kuj  }(j  Kmj  K%uuj  }(j  }(j  Kmj  Kuj  }(j  Kmj  K%uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j
  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'node: ast.expr) -> set[str]:h)j  u}(j  namesj  K
j  }(j  }(j  Kxj  Kuj  }(j  Kxj  K	uuj  }(j  }(j  Kxj  Kuj  }(j  Kxj  K	uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'names: set[str] = set()h)j  u}(j  childj  K
j  }(j  }(j  Kyj  Kuj  }(j  Kyj  K
uuj  }(j  }(j  Kyj  Kuj  }(j  Kyj  K
uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j$  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'child in ast.walk(node):h)j  ueh}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'XK  def extract_used_names(node: ast.expr) -> set[str]:
    """Extract all variable names used in an expression (Load context).

    Examples:
        >>> tree = ast.parse("x + y", mode="eval")
        >>> sorted(extract_used_names(tree.body))
        ['x', 'y']
        >>> tree = ast.parse("len(items) > 0", mode="eval")
        >>> sorted(extract_used_names(tree.body))
        ['items', 'len']
    """
    names: set[str] = set()
    for child in ast.walk(node):
        if isinstance(child, ast.Name) and isinstance(child.ctx, ast.Load):
            names.add(child.id)
    return namesh)j  ueh)j  u}(j  	contractsj  j  h#}(j  }(j  K j  K uj  }(j  Mj  K uuj  j5  h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j5  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&src/invar/core/contracts.pyuj  ](}(nameis_empty_contractkindKrange}(start}(lineK	characterK uend}(jE  K"jF  KuuselectionRange}(jC  }(jE  KjF  KujG  }(jE  KjF  Kuuchildren](}(j>  
expressionj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  K%uujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  K%uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jQ  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&src/invar/core/contracts.pyuh'expression: str) -> bool:h)j=  u}(j>  treej@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j_  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh')tree = ast.parse(expression, mode="eval")h)j=  u}(j>  lambda_nodej@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jl  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'lambda_node = find_lambda(tree)h)j=  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jB  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X  @pre(lambda expression: "lambda" in expression or not expression.strip())
def is_empty_contract(expression: str) -> bool:
    """Check if a contract expression is always True (tautological).

    Examples:
        >>> is_empty_contract("lambda: True"), is_empty_contract("lambda x: True")
        (True, True)
        >>> is_empty_contract("lambda x: x > 0"), is_empty_contract("")
        (False, False)
    """
    if not expression.strip():
        return False
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        return lambda_node is not None and isinstance(lambda_node.body, ast.Constant) and lambda_node.body.value is True
    except SyntaxError:
        return Falseh)j3  u}(j>  is_semantic_tautologyj@  KjA  }(jC  }(jE  K(jF  K ujG  }(jE  KJjF  KuujI  }(jC  }(jE  K)jF  KujG  }(jE  K)jF  KuujM  ](}(j>  
expressionj@  K
jA  }(jC  }(jE  K)jF  KujG  }(jE  K)jF  K)uujI  }(jC  }(jE  K)jF  KujG  }(jE  K)jF  K)uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'%expression: str) -> tuple[bool, str]:h)j{  u}(j>  treej@  K
jA  }(jC  }(jE  KDjF  KujG  }(jE  KDjF  KuujI  }(jC  }(jE  KDjF  KujG  }(jE  KDjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh')tree = ast.parse(expression, mode="eval")h)j{  u}(j>  lambda_nodej@  K
jA  }(jC  }(jE  KEjF  KujG  }(jE  KEjF  KuujI  }(jC  }(jE  KEjF  KujG  }(jE  KEjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'lambda_node = find_lambda(tree)h)j{  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j}  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X{  @pre(lambda expression: "lambda" in expression or not expression.strip())
def is_semantic_tautology(expression: str) -> tuple[bool, str]:
    """Check if a contract expression is a semantic tautology.

    Returns (is_tautology, pattern_description).

    P7: Detects patterns that are always true:
    - x == x (identity comparison)
    - len(x) >= 0 (length always non-negative)
    - isinstance(x, object) (everything is object)
    - x or True (always true due to True)
    - True and x (simplifies but starts with True)

    Examples:
        >>> is_semantic_tautology("lambda x: x == x")
        (True, 'x == x is always True')
        >>> is_semantic_tautology("lambda x: len(x) >= 0")
        (True, 'len(x) >= 0 is always True for any sequence')
        >>> is_semantic_tautology("lambda x: isinstance(x, object)")
        (True, 'isinstance(x, object) is always True')
        >>> is_semantic_tautology("lambda x: x > 0")
        (False, '')
        >>> is_semantic_tautology("lambda x: x or True")
        (True, 'expression contains unconditional True')
    """
    if not expression.strip():
        return (False, "")
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        if lambda_node is None:
            return (False, "")
        return _check_tautology_patterns(lambda_node.body)
    except SyntaxError:
        return (False, "")h)j3  u}(j>  _check_tautology_patternsj@  KjA  }(jC  }(jE  KMjF  K ujG  }(jE  KsjF  KuujI  }(jC  }(jE  KMjF  KujG  }(jE  KMjF  KuujM  ](}(j>  nodej@  K
jA  }(jC  }(jE  KMjF  KujG  }(jE  KMjF  K,uujI  }(jC  }(jE  KMjF  KujG  }(jE  KMjF  K,uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'$node: ast.expr) -> tuple[bool, str]:h)j  u}(j>  leftj@  K
jA  }(jC  }(jE  KRjF  KujG  }(jE  KRjF  KuujI  }(jC  }(jE  KRjF  KujG  }(jE  KRjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'left = ast.unparse(node.left)h)j  u}(j>  rightj@  K
jA  }(jC  }(jE  KSjF  KujG  }(jE  KSjF  KuujI  }(jC  }(jE  KSjF  KujG  }(jE  KSjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'(right = ast.unparse(node.comparators[0])h)j  u}(j>  opj@  K
jA  }(jC  }(jE  K[jF  KujG  }(jE  K[jF  KuujI  }(jC  }(jE  K[jF  KujG  }(jE  K[jF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'op = node.ops[0]h)j  u}(j>  argj@  K
jA  }(jC  }(jE  KajF  KujG  }(jE  KajF  KuujI  }(jC  }(jE  KajF  KujG  }(jE  KajF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'5arg = ast.unparse(left.args[0]) if left.args else "x"h)j  u}(j>  type_argj@  K
jA  }(jC  }(jE  KhjF  KujG  }(jE  KhjF  KuujI  }(jC  }(jE  KhjF  KujG  }(jE  KhjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'type_arg = node.args[1]h)j  u}(j>  valj@  K
jA  }(jC  }(jE  KojF  KujG  }(jE  KojF  KuujI  }(jC  }(jE  KojF  KujG  }(jE  KojF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'val in node.values:h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Xj  def _check_tautology_patterns(node: ast.expr) -> tuple[bool, str]:
    """Check for common tautology patterns in AST node."""
    # Pattern: x == x (identity comparison)
    if isinstance(node, ast.Compare):
        if len(node.ops) == 1 and isinstance(node.ops[0], (ast.Eq, ast.Is)):
            left = ast.unparse(node.left)
            right = ast.unparse(node.comparators[0])
            if left == right:
                return (True, f"{left} == {right} is always True")

    # Pattern: len(x) >= 0 or len(x) > -1 (length always non-negative)
    if isinstance(node, ast.Compare):
        if len(node.ops) == 1 and len(node.comparators) == 1:
            left = node.left
            op = node.ops[0]
            right = node.comparators[0]
            # len(x) >= 0
            if (isinstance(left, ast.Call) and isinstance(left.func, ast.Name)
                    and left.func.id == "len" and isinstance(op, ast.GtE)
                    and isinstance(right, ast.Constant) and right.value == 0):
                arg = ast.unparse(left.args[0]) if left.args else "x"
                return (True, f"len({arg}) >= 0 is always True for any sequence")

    # Pattern: isinstance(x, object)
    if isinstance(node, ast.Call):
        if (isinstance(node.func, ast.Name) and node.func.id == "isinstance"
                and len(node.args) == 2):
            type_arg = node.args[1]
            if isinstance(type_arg, ast.Name) and type_arg.id == "object":
                arg = ast.unparse(node.args[0])
                return (True, f"isinstance({arg}, object) is always True")

    # Pattern: x or True, True or x (always true)
    if isinstance(node, ast.BoolOp) and isinstance(node.op, ast.Or):
        for val in node.values:
            if isinstance(val, ast.Constant) and val.value is True:
                return (True, "expression contains unconditional True")

    return (False, "")h)j3  u}(j>  is_redundant_type_contractj@  KjA  }(jC  }(jE  KvjF  K ujG  }(jE  KjF  KuujI  }(jC  }(jE  KwjF  KujG  }(jE  KwjF  KuujM  ](}(j>  
expressionj@  K
jA  }(jC  }(jE  KwjF  KujG  }(jE  KwjF  K.uujI  }(jC  }(jE  KwjF  KujG  }(jE  KwjF  K.uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'6expression: str, annotations: dict[str, str]) -> bool:h)j  u}(j>  annotationsj@  K
jA  }(jC  }(jE  KwjF  K0ujG  }(jE  KwjF  KKuujI  }(jC  }(jE  KwjF  K0ujG  }(jE  KwjF  KKuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j/  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'%annotations: dict[str, str]) -> bool:h)j  u}(j>  treej@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j<  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh')tree = ast.parse(expression, mode="eval")h)j  u}(j>  lambda_nodej@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jI  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'lambda_node = find_lambda(tree)h)j  u}(j>  checksj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jV  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'5checks = _extract_isinstance_checks(lambda_node.body)h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X  @pre(lambda expression, annotations: "lambda" in expression or not expression.strip())
def is_redundant_type_contract(expression: str, annotations: dict[str, str]) -> bool:
    """Check if a contract only checks types already in annotations.

    Examples:
        >>> is_redundant_type_contract("lambda x: isinstance(x, int)", {"x": "int"})
        True
        >>> is_redundant_type_contract("lambda x: isinstance(x, int) and x > 0", {"x": "int"})
        False
    """
    if not expression.strip() or not annotations:
        return False
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        if lambda_node is None:
            return False
        checks = _extract_isinstance_checks(lambda_node.body)
        if checks is None:
            return False
        return all(p in annotations and _types_match(annotations[p], t) for p, t in checks)
    except SyntaxError:
        return Falseh)j3  u}(j>  _extract_isinstance_checksj@  KjA  }(jC  }(jE  KjF  K ujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ](}(j>  nodej@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  K-uujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  K-uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jp  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'0node: ast.expr) -> list[tuple[str, str]] | None:h)je  u}(j>  checkj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  K
uujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  K
uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j}  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'$check = _parse_isinstance_call(node)h)je  u}(j>  checksj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Tchecks = [_parse_isinstance_call(v) for v in node.values if isinstance(v, ast.Call)]h)je  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jg  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X  def _extract_isinstance_checks(node: ast.expr) -> list[tuple[str, str]] | None:
    """Extract isinstance checks. Returns None if other logic present."""
    if isinstance(node, ast.Call):
        check = _parse_isinstance_call(node)
        return [check] if check else None
    if isinstance(node, ast.BoolOp) and isinstance(node.op, ast.And):
        checks = [_parse_isinstance_call(v) for v in node.values if isinstance(v, ast.Call)]
        return checks if len(checks) == len(node.values) and all(checks) else None
    return Noneh)j3  u}(j>  _parse_isinstance_callj@  KjA  }(jC  }(jE  KjF  K ujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ](}(j>  nodej@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  K)uujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  K)uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'*node: ast.Call) -> tuple[str, str] | None:h)j  u}(j>  paramj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  K	uujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  K	uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'/param, type_arg = node.args[0].id, node.args[1]h)j  u}(j>  type_argj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'(type_arg = node.args[0].id, node.args[1]h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X,  def _parse_isinstance_call(node: ast.Call) -> tuple[str, str] | None:
    """Parse isinstance(x, Type) call. Returns (param, type) or None."""
    if not (isinstance(node.func, ast.Name) and node.func.id == "isinstance"):
        return None
    if len(node.args) != 2 or not isinstance(node.args[0], ast.Name):
        return None
    param, type_arg = node.args[0].id, node.args[1]
    if isinstance(type_arg, ast.Name):
        return (param, type_arg.id)
    if isinstance(type_arg, ast.Attribute):
        return (param, type_arg.attr)
    return Noneh)j3  u}(j>  _types_matchj@  KjA  }(jC  }(jE  KjF  K ujG  }(jE  KjF  K@uujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ](}(j>  
annotationj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  K uujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  K uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh')annotation: str, type_name: str) -> bool:h)j  u}(j>  	type_namej@  K
jA  }(jC  }(jE  KjF  K"ujG  }(jE  KjF  K0uujI  }(jC  }(jE  KjF  K"ujG  }(jE  KjF  K0uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'type_name: str) -> bool:h)j  u}(j>  
base_matchj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'.base_match = re.match(r"^(\w+)\[", annotation)h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X  def _types_match(annotation: str, type_name: str) -> bool:
    """Check if type annotation matches isinstance check.

    Examples:
        >>> _types_match("int", "int"), _types_match("list[int]", "list")
        (True, True)
    """
    if annotation == type_name:
        return True
    base_match = re.match(r"^(\w+)\[", annotation)
    return bool(base_match and base_match.group(1) == type_name)h)j3  u}(j>  has_unused_paramsj@  KjA  }(jC  }(jE  KjF  K ujG  }(jE  KjF  K?uujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ](}(j>  
expressionj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  K%uujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  K%uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Fexpression: str, signature: str) -> tuple[bool, list[str], list[str]]:h)j  u}(j>  	signaturej@  K
jA  }(jC  }(jE  KjF  K'ujG  }(jE  KjF  K5uujI  }(jC  }(jE  KjF  K'ujG  }(jE  KjF  K5uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'5signature: str) -> tuple[bool, list[str], list[str]]:h)j  u}(j>  
lambda_paramsj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j&  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'1lambda_params = extract_lambda_params(expression)h)j  u}(j>  func_paramsj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j3  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'1func_params = extract_func_param_names(signature)h)j  u}(j>  treej@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j@  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh')tree = ast.parse(expression, mode="eval")h)j  u}(j>  lambda_nodej@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jM  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'lambda_node = find_lambda(tree)h)j  u}(j>  
used_namesj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jZ  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'1used_names = extract_used_names(lambda_node.body)h)j  u}(j>  used_paramsj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jg  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh';used_params = [p for p in lambda_params if p in used_names]h)j  u}(j>  
unused_paramsj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jt  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Aunused_params = [p for p in lambda_params if p not in used_names]h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X  @pre(lambda expression, signature: "lambda" in expression or not expression.strip())
def has_unused_params(expression: str, signature: str) -> tuple[bool, list[str], list[str]]:
    """
    Check if lambda has params it doesn't use (P28: Partial Contract Detection).

    Returns (has_unused, unused_params, used_params).

    Different from param_mismatch:
    - param_mismatch: lambda param COUNT != function param count (ERROR)
    - unused_params: lambda has all params but doesn't USE all (WARN)

    Examples:
        >>> has_unused_params("lambda x, y: x > 0", "(x: int, y: int) -> int")
        (True, ['y'], ['x'])
        >>> has_unused_params("lambda x, y: x > 0 and y < 10", "(x: int, y: int) -> int")
        (False, [], ['x', 'y'])
        >>> has_unused_params("lambda x: x > 0", "(x: int, y: int) -> int")
        (False, [], [])
        >>> has_unused_params("lambda items: len(items) > 0", "(items: list) -> int")
        (False, [], ['items'])
    """
    if not expression.strip() or not signature:
        return (False, [], [])

    lambda_params = extract_lambda_params(expression)
    func_params = extract_func_param_names(signature)

    if lambda_params is None or func_params is None:
        return (False, [], [])

    # Only check when lambda has same param count as function
    # (if different count, that's param_mismatch, not this check)
    if len(lambda_params) != len(func_params):
        return (False, [], [])

    # Extract used names from lambda body
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        if lambda_node is None:
            return (False, [], [])
        used_names = extract_used_names(lambda_node.body)
    except SyntaxError:
        return (False, [], [])

    # Check which params are actually used
    used_params = [p for p in lambda_params if p in used_names]
    unused_params = [p for p in lambda_params if p not in used_names]

    return (len(unused_params) > 0, unused_params, used_params)h)j3  u}(j>  has_param_mismatchj@  KjA  }(jC  }(jE  KjF  K ujG  }(jE  M	jF  KuujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  KuujM  ](}(j>  
expressionj@  K
jA  }(jC  }(jE  KjF  KujG  }(jE  KjF  K&uujI  }(jC  }(jE  KjF  KujG  }(jE  KjF  K&uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'5expression: str, signature: str) -> tuple[bool, str]:h)j  u}(j>  	signaturej@  K
jA  }(jC  }(jE  KjF  K(ujG  }(jE  KjF  K6uujI  }(jC  }(jE  KjF  K(ujG  }(jE  KjF  K6uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'$signature: str) -> tuple[bool, str]:h)j  u}(j>  
lambda_paramsj@  K
jA  }(jC  }(jE  M jF  KujG  }(jE  M jF  KuujI  }(jC  }(jE  M jF  KujG  }(jE  M jF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'1lambda_params = extract_lambda_params(expression)h)j  u}(j>  func_paramsj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'1func_params = extract_func_param_names(signature)h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X  @pre(lambda expression, signature: "lambda" in expression or not expression.strip())
def has_param_mismatch(expression: str, signature: str) -> tuple[bool, str]:
    """
    Check if lambda params don't match function params.

    Returns (has_mismatch, error_description).

    Examples:
        >>> has_param_mismatch("lambda x: x > 0", "(x: int, y: int) -> int")
        (True, 'lambda has 1 param(s) but function has 2')
        >>> has_param_mismatch("lambda x, y: x > 0", "(x: int, y: int) -> int")
        (False, '')
        >>> has_param_mismatch("lambda x, y=0: x > 0", "(x: int, y: int = 0) -> int")
        (False, '')
        >>> has_param_mismatch("lambda: True", "() -> bool")
        (False, '')
    """
    if not expression.strip() or not signature:
        return (False, "")

    lambda_params = extract_lambda_params(expression)
    func_params = extract_func_param_names(signature)

    if lambda_params is None or func_params is None:
        return (False, "")  # Can't determine, skip

    if len(lambda_params) != len(func_params):
        return (True, f"lambda has {len(lambda_params)} param(s) but function has {len(func_params)}")

    return (False, "")h)j3  u}(j>  check_empty_contractsj@  KjA  }(jC  }(jE  MjF  K ujG  }(jE  M(jF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ](}(j>  	file_infoj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  K-uujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  K-uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(j>  configj@  K
jA  }(jC  }(jE  MjF  K/ujG  }(jE  MjF  KAuujI  }(jC  }(jE  MjF  K/ujG  }(jE  MjF  KAuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh''config: RuleConfig) -> list[Violation]:h)j  u}(j>  
violationsj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh' violations: list[Violation] = []h)j  u}(j>  symbolj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'symbol in file_info.symbols:h)j  u}(j>  contractj@  K
jA  }(jC  }(jE  M jF  KujG  }(jE  M jF  KuujI  }(jC  }(jE  M jF  KujG  }(jE  M jF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'contract in symbol.contracts:h)j  u}(j>  kindj@  K
jA  }(jC  }(jE  M"jF  KujG  }(jE  M"jF  KuujI  }(jC  }(jE  M"jF  KujG  }(jE  M"jF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_empty_contracts(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check for empty/tautological contracts. Core files only.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: True", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, contracts=[c])
        >>> check_empty_contracts(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())[0].rule
        'empty_contract'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            continue
        for contract in symbol.contracts:
            if is_empty_contract(contract.expression):
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(Violation(
                    rule="empty_contract", severity=Severity.WARNING, file=file_info.path, line=contract.line,
                    message=f"{kind} '{symbol.name}' has empty contract: @{contract.kind}({contract.expression})",
                    suggestion=format_suggestion_for_violation(symbol, "empty_contract"),
                ))
    return violationsh)j3  u}(j>  check_semantic_tautologyj@  KjA  }(jC  }(jE  M+jF  K ujG  }(jE  MIjF  KuujI  }(jC  }(jE  M,jF  KujG  }(jE  M,jF  KuujM  ](}(j>  	file_infoj@  K
jA  }(jC  }(jE  M,jF  KujG  }(jE  M,jF  K0uujI  }(jC  }(jE  M,jF  KujG  }(jE  M,jF  K0uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j*  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(j>  configj@  K
jA  }(jC  }(jE  M,jF  K2ujG  }(jE  M,jF  KDuujI  }(jC  }(jE  M,jF  K2ujG  }(jE  M,jF  KDuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j7  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh''config: RuleConfig) -> list[Violation]:h)j  u}(j>  
violationsj@  K
jA  }(jC  }(jE  M:jF  KujG  }(jE  M:jF  KuujI  }(jC  }(jE  M:jF  KujG  }(jE  M:jF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jD  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh' violations: list[Violation] = []h)j  u}(j>  symbolj@  K
jA  }(jC  }(jE  M=jF  KujG  }(jE  M=jF  KuujI  }(jC  }(jE  M=jF  KujG  }(jE  M=jF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jQ  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'symbol in file_info.symbols:h)j  u}(j>  contractj@  K
jA  }(jC  }(jE  M@jF  KujG  }(jE  M@jF  KuujI  }(jC  }(jE  M@jF  KujG  }(jE  M@jF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j^  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'contract in symbol.contracts:h)j  u}(j>  is_tautologyj@  K
jA  }(jC  }(jE  MAjF  KujG  }(jE  MAjF  KuujI  }(jC  }(jE  MAjF  KujG  }(jE  MAjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jk  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Gis_tautology, pattern_desc = is_semantic_tautology(contract.expression)h)j  u}(j>  pattern_descj@  K
jA  }(jC  }(jE  MAjF  KujG  }(jE  MAjF  K&uujI  }(jC  }(jE  MAjF  KujG  }(jE  MAjF  K&uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jx  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'9pattern_desc = is_semantic_tautology(contract.expression)h)j  u}(j>  kindj@  K
jA  }(jC  }(jE  MCjF  KujG  }(jE  MCjF  KuujI  }(jC  }(jE  MCjF  KujG  }(jE  MCjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X{  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_semantic_tautology(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check for semantic tautology contracts. Core files only.

    P7: Detects contracts that are always true due to semantic patterns:
    - x == x, len(x) >= 0, isinstance(x, object), x or True

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: x == x", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, contracts=[c])
        >>> vs = check_semantic_tautology(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())
        >>> vs[0].rule
        'semantic_tautology'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            continue
        for contract in symbol.contracts:
            is_tautology, pattern_desc = is_semantic_tautology(contract.expression)
            if is_tautology:
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(Violation(
                    rule="semantic_tautology", severity=Severity.WARNING, file=file_info.path, line=contract.line,
                    message=f"{kind} '{symbol.name}' has tautological contract: {pattern_desc}",
                    suggestion=format_suggestion_for_violation(symbol, "semantic_tautology"),
                ))
    return violationsh)j3  u}(j>  check_redundant_type_contractsj@  KjA  }(jC  }(jE  MLjF  K ujG  }(jE  MhjF  KuujI  }(jC  }(jE  MMjF  KujG  }(jE  MMjF  K"uujM  ](}(j>  	file_infoj@  K
jA  }(jC  }(jE  MMjF  K#ujG  }(jE  MMjF  K6uujI  }(jC  }(jE  MMjF  K#ujG  }(jE  MMjF  K6uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(j>  configj@  K
jA  }(jC  }(jE  MMjF  K8ujG  }(jE  MMjF  KJuujI  }(jC  }(jE  MMjF  K8ujG  }(jE  MMjF  KJuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh''config: RuleConfig) -> list[Violation]:h)j  u}(j>  
violationsj@  K
jA  }(jC  }(jE  MWjF  KujG  }(jE  MWjF  KuujI  }(jC  }(jE  MWjF  KujG  }(jE  MWjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh' violations: list[Violation] = []h)j  u}(j>  symbolj@  K
jA  }(jC  }(jE  MZjF  KujG  }(jE  MZjF  KuujI  }(jC  }(jE  MZjF  KujG  }(jE  MZjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'symbol in file_info.symbols:h)j  u}(j>  annotationsj@  K
jA  }(jC  }(jE  M]jF  KujG  }(jE  M]jF  KuujI  }(jC  }(jE  M]jF  KujG  }(jE  M]jF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'3annotations = extract_annotations(symbol.signature)h)j  u}(j>  contractj@  K
jA  }(jC  }(jE  M`jF  KujG  }(jE  M`jF  KuujI  }(jC  }(jE  M`jF  KujG  }(jE  M`jF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'contract in symbol.contracts:h)j  u}(j>  kindj@  K
jA  }(jC  }(jE  MbjF  KujG  }(jE  MbjF  KuujI  }(jC  }(jE  MbjF  KujG  }(jE  MbjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_redundant_type_contracts(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check for contracts that only check types in annotations. Core files only. INFO severity.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: isinstance(x, int)", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, signature="(x: int) -> int", contracts=[c])
        >>> check_redundant_type_contracts(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())[0].severity.value
        'info'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            continue
        annotations = extract_annotations(symbol.signature)
        if not annotations:
            continue
        for contract in symbol.contracts:
            if is_redundant_type_contract(contract.expression, annotations):
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(Violation(
                    rule="redundant_type_contract", severity=Severity.INFO, file=file_info.path, line=contract.line,
                    message=f"{kind} '{symbol.name}' contract only checks types already in annotations",
                    suggestion=format_suggestion_for_violation(symbol, "redundant_type_contract"),
                ))
    return violationsh)j3  u}(j>  check_param_mismatchj@  KjA  }(jC  }(jE  MkjF  K ujG  }(jE  MjF  KuujI  }(jC  }(jE  MljF  KujG  }(jE  MljF  KuujM  ](}(j>  	file_infoj@  K
jA  }(jC  }(jE  MljF  KujG  }(jE  MljF  K,uujI  }(jC  }(jE  MljF  KujG  }(jE  MljF  K,uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(j>  configj@  K
jA  }(jC  }(jE  MljF  K.ujG  }(jE  MljF  K@uujI  }(jC  }(jE  MljF  K.ujG  }(jE  MljF  K@uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh''config: RuleConfig) -> list[Violation]:h)j  u}(j>  
violationsj@  K
jA  }(jC  }(jE  MxjF  KujG  }(jE  MxjF  KuujI  }(jC  }(jE  MxjF  KujG  }(jE  MxjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh' violations: list[Violation] = []h)j  u}(j>  symbolj@  K
jA  }(jC  }(jE  M{jF  KujG  }(jE  M{jF  KuujI  }(jC  }(jE  M{jF  KujG  }(jE  M{jF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j.   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'symbol in file_info.symbols:h)j  u}(j>  contractj@  K
jA  }(jC  }(jE  M~jF  KujG  }(jE  M~jF  KuujI  }(jC  }(jE  M~jF  KujG  }(jE  M~jF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j;   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'contract in symbol.contracts:h)j  u}(j>  mismatchj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jH   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Jmismatch, desc = has_param_mismatch(contract.expression, symbol.signature)h)j  u}(j>  descj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jU   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'@desc = has_param_mismatch(contract.expression, symbol.signature)h)j  u}(j>  kindj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jb   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_param_mismatch(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check @pre lambda params match function params. Core files only. ERROR severity.

    Only checks @pre contracts (@post takes 'result' param, different signature).

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: x > 0", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, signature="(x: int, y: int) -> int", contracts=[c])
        >>> check_param_mismatch(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())[0].rule
        'param_mismatch'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD) or not symbol.signature:
            continue
        for contract in symbol.contracts:
            # Only check @pre contracts (not @post which takes 'result')
            if contract.kind != "pre":
                continue
            mismatch, desc = has_param_mismatch(contract.expression, symbol.signature)
            if mismatch:
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(Violation(
                    rule="param_mismatch", severity=Severity.ERROR, file=file_info.path, line=contract.line,
                    message=f"{kind} '{symbol.name}' @pre {desc}",
                    suggestion="Lambda must include ALL function parameters",
                ))
    return violationsh)j3  u}(j>  check_partial_contractj@  KjA  }(jC  }(jE  MjF  K ujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ](}(j>  	file_infoj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  K.uujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  K.uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j|   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)jq   u}(j>  configj@  K
jA  }(jC  }(jE  MjF  K0ujG  }(jE  MjF  KBuujI  }(jC  }(jE  MjF  K0ujG  }(jE  MjF  KBuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh''config: RuleConfig) -> list[Violation]:h)jq   u}(j>  
violationsj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh' violations: list[Violation] = []h)jq   u}(j>  symbolj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'symbol in file_info.symbols:h)jq   u}(j>  contractj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'contract in symbol.contracts:h)jq   u}(j>  
has_unusedj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Shas_unused, unused, used = has_unused_params(contract.expression, symbol.signature)h)jq   u}(j>  unusedj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Gunused, used = has_unused_params(contract.expression, symbol.signature)h)jq   u}(j>  usedj@  K
jA  }(jC  }(jE  MjF  K ujG  }(jE  MjF  K$uujI  }(jC  }(jE  MjF  K ujG  }(jE  MjF  K$uujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'?used = has_unused_params(contract.expression, symbol.signature)h)jq   u}(j>  kindj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)jq   u}(j>  
unused_strj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'0unused_str = ", ".join(f"'{p}'" for p in unused)h)jq   u}(j>  used_strj@  K
jA  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujI  }(jC  }(jE  MjF  KujG  }(jE  MjF  KuujM  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'@used_str = ", ".join(f"'{p}'" for p in used) if used else "none"h)jq   ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#js   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j[  uh'X	  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_partial_contract(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check @pre contracts that don't use all declared params (P28). Core files only. WARN severity.

    P28: Detects hidden formal compliance - lambda declares all params but doesn't use all.
    Forces Agent to think about whether unchecked params need constraints.

    Different from param_mismatch (P8.3):
    - param_mismatch: lambda param COUNT != function param count (ERROR)
    - partial_contract: lambda has all params but doesn't USE all (WARN)

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x, y: x > 0", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, signature="(x: int, y: int) -> int", contracts=[c])
        >>> vs = check_partial_contract(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())
        >>> vs[0].rule
        'partial_contract'
        >>> vs[0].severity
        <Severity.WARNING: 'warning'>
        >>> "y" in vs[0].message
        True
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD) or not symbol.signature:
            continue
        for contract in symbol.contracts:
            # Only check @pre contracts (not @post which takes 'result')
            if contract.kind != "pre":
                continue
            has_unused, unused, used = has_unused_params(contract.expression, symbol.signature)
            if has_unused:
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                unused_str = ", ".join(f"'{p}'" for p in unused)
                used_str = ", ".join(f"'{p}'" for p in used) if used else "none"
                violations.append(Violation(
                    rule="partial_contract",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=contract.line,
                    message=f"{kind} '{symbol.name}' @pre checks {used_str} but not {unused_str}",
                    suggestion=f"Signature: {symbol.signature}\n→ Add constraint for {unused_str} or verify it needs none",
                ))
    return violationsh)j3  ueh)j  ueuuu}(ji  RuleMetajk  Kjl  }(jn  }(jp  Kjq  K ujr  }(jp  K+jq  K
uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujx  ](}(ji  namejk  K
jl  }(jn  }(jp  K&jq  Kujr  }(jp  K&jq  Kuujt  }(jn  }(jp  K&jq  Kujr  }(jp  K&jq  Kuujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'	name: strh)j
!  u}(ji  severityjk  K
jl  }(jn  }(jp  K'jq  Kujr  }(jp  K'jq  Kuujt  }(jn  }(jp  K'jq  Kujr  }(jp  K'jq  Kuujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j%!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'severity: Severityh)j
!  u}(ji  categoryjk  K
jl  }(jn  }(jp  K(jq  Kujr  }(jp  K(jq  Kuujt  }(jn  }(jp  K(jq  Kujr  }(jp  K(jq  Kuujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j2!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'category: RuleCategoryh)j
!  u}(ji  detectsjk  K
jl  }(jn  }(jp  K)jq  Kujr  }(jp  K)jq  Kuujt  }(jn  }(jp  K)jq  Kujr  }(jp  K)jq  Kuujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j?!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'detects: strh)j
!  u}(ji  
cannot_detectjk  K
jl  }(jn  }(jp  K*jq  Kujr  }(jp  K*jq  Kuujt  }(jn  }(jp  K*jq  Kujr  }(jp  K*jq  Kuujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#jL!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'cannot_detect: tuple[str, ...]h)j
!  u}(ji  hintjk  K
jl  }(jn  }(jp  K+jq  Kujr  }(jp  K+jq  Kuujt  }(jn  }(jp  K+jq  Kujr  }(jp  K+jq  Kuujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#jY!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'	hint: strh)j
!  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'X~  @dataclass(frozen=True)
class RuleMeta:
    """
    Metadata for a Guard rule.

    Examples:
        >>> meta = RULE_META["file_size"]
        >>> meta.category
        <RuleCategory.SIZE: 'size'>
        >>> "Split" in meta.hint
        True
    """

    name: str
    severity: Severity
    category: RuleCategory
    detects: str
    cannot_detect: tuple[str, ...]
    hint: strh)j  u}(ji  	RULE_METAjk  Kjl  }(jn  }(jp  K/jq  K ujr  }(jp  K/jq  K	uujt  }(jn  }(jp  K/jq  K ujr  }(jp  K/jq  K	uujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#jj!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'"RULE_META: dict[str, RuleMeta] = {h)j  u}(ji  
get_rule_metajk  Kjl  }(jn  }(jp  Kjq  K ujr  }(jp  Kjq  K#uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujx  ]}(ji  	rule_namejk  K
jl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K uujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'#rule_name: str) -> RuleMeta | None:h)ju!  uah}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#jw!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'X3  def get_rule_meta(rule_name: str) -> RuleMeta | None:
    """
    Get metadata for a rule by name.

    Examples:
        >>> meta = get_rule_meta("file_size")
        >>> meta is not None
        True
        >>> get_rule_meta("nonexistent") is None
        True
    """
    return RULE_META.get(rule_name)h)j  u}(ji  get_all_rule_namesjk  Kjl  }(jn  }(jp  Kjq  K ujr  }(jp  Kjq  K!uujt  }(jn  }(jp  Kjq  Kujr  }(jp  K	      jq  Kuujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'X  def get_all_rule_names() -> list[str]:
    """
    Get list of all rule names.

    Examples:
        >>> names = get_all_rule_names()
        >>> "file_size" in names
        True
        >>> len(names) >= 10
        True
    """
    return list(RULE_META.keys())h)j  u}(ji  get_rules_by_categoryjk  Kjl  }(jn  }(jp  Kjq  K ujr  }(jp  Kjq  KMuujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujx  ]}(ji  categoryjk  K
jl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K0uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K0uujx  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'*category: RuleCategory) -> list[RuleMeta]:h)j!  uah}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'XB  def get_rules_by_category(category: RuleCategory) -> list[RuleMeta]:
    """
    Get all rules in a category.

    Examples:
        >>> size_rules = get_rules_by_category(RuleCategory.SIZE)
        >>> len(size_rules) >= 2
        True
    """
    return [meta for meta in RULE_META.values() if meta.category == category]h)j  ueja  Nubj	   9683233853cab9c3a1e8db1b5c0ef0e8h)}(hj  ja  Nubjw   7df5ea5a04682e5a26cdf21d8973872fh)}(hja  ja  Nubj   7a1358266bb1111b649b5c5ebdf1c670h)}(hj  ja  Nubj   8430cd87363458b5a8b26d6bef1978b2h)}(hj  ja  Nubj
   230722960bd238a6e7bd95824f8e6597h)}(hjr
  ja  Nubsrc/invar/core/__init__.py 404c968b10271f91e39639c0cd2ed068h)}(hjZ  ja  Nubjz   567745354e6b4cd8a1efee388d9ea170h)}(hjd  ja  Nubj   033e183175f9dc40178f3705c6b3ffd7h)}(hj  ja  Nubj   dd4adff7ae129bc65ce0846356775487h)}(hj  ja  NubjN   1a3a81d07805dd0c4ceb4692d45541deh)}(hj/  ja  Nubj   dff40b94dcd636260169edeec8ac8cbfh)}(hj  ja  Nubj   265451569eb2f4c4f012fc17f94ddf14h)}(hj  ja  Nubj[   e3d3d016169dae8ec79159605c89ca07h)}(hj<  ja  Nubuu.