       }(__cache_versionKobj}(src/invar/shell/perception.py af350323eb3d13e2d413554655dad9a5solidlsp.lsDocumentSymbols)}(root_symbols](}(nameconsolekindK
range}(start}(lineK	characterK uend}(hKhKuuselectionRange}(h}(hKhK uh}(hKhKuuchildren]location}(uri?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyrangehabsolutePath8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyrelativePathhubodyconsole = Console()parentNu}(hrun_maphKh}(h}(hKhK uh}(hKChKuuh}(h}(hKhKuh}(hKhKuuh](}(hpathhK
h}(h}(hKhKuh}(hKhKuuh}(h}(hKhKuh}(hKhKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#h5h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'@path: Path, top_n: int, json_output: bool) -> Result[None, str]:h)h*u}(htop_nhK
h}(h}(hKhKuh}(hKhK"uuh}(h}(hKhKuh}(hKhK"uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hBh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'4top_n: int, json_output: bool) -> Result[None, str]:h)h*u}(hjson_outputhK
h}(h}(hKhK$uh}(hKhK5uuh}(h}(hKhK$uh}(hKhK5uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hOh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'(json_output: bool) -> Result[None, str]:h)h*u}(h
file_infoshK
h}(h}(hK&hKuh}(hK&hKuuh}(h}(hK&hKuh}(hK&hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#h\h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'file_infos: list[FileInfo] = []h)h*u}(hsourceshK
h}(h}(hK'hKuh}(hK'hKuuh}(h}(hK'hKuh}(hK'hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hih$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'sources: dict[str, str] = {}h)h*u}(hpy_filehK
h}(h}(hK)hKuh}(hK)hKuuh}(h}(hK)hKuh}(hK)hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hvh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh''py_file in discover_python_files(path):h)h*u}(hcontenthK
h}(h}(hK+hKuh}(hK+hKuuh}(h}(hK+hKuh}(hK+hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'-content = py_file.read_text(encoding="utf-8")h)h*u}(hrel_pathhK
h}(h}(hK,hKuh}(hK,hKuuh}(h}(hK,hKuh}(hK,hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh')rel_path = str(py_file.relative_to(path))h)h*u}(h	file_infohK
h}(h}(hK-hKuh}(hK-hKuuh}(h}(hK-hKuh}(hK-hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'+file_info = parse_source(content, rel_path)h)h*u}(hehK
h}(h}(hK1hK0uh}(hK1hK1uuh}(h}(hK1hK0uh}(hK1hK1uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'e:h)h*u}(hperception_maphK
h}(h}(hK9hKuh}(hK9hKuuh}(h}(hK9hKuh}(hK9hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'Pperception_map = build_perception_map(file_infos, sources, str(path.absolute()))h)h*u}(houtputhK
h}(h}(hK=hKuh}(hK=hKuuh}(h}(hK=hKuh}(hK=hKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'(output = format_map_json(perception_map)h)h*ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#h,h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'X  def run_map(path: Path, top_n: int, json_output: bool) -> Result[None, str]:
    """
    Run the map command.

    Scans project and generates perception map with reference counts.
    """
    if not path.exists():
        return Failure(f"Path does not exist: {path}")

    # Collect all files and their sources
    file_infos: list[FileInfo] = []
    sources: dict[str, str] = {}

    for py_file in discover_python_files(path):
        try:
            content = py_file.read_text(encoding="utf-8")
            rel_path = str(py_file.relative_to(path))
            file_info = parse_source(content, rel_path)
            if file_info:
                file_infos.append(file_info)
                sources[rel_path] = content
        except (OSError, UnicodeDecodeError) as e:
            console.print(f"[yellow]Warning:[/yellow] {py_file}: {e}")
            continue

    if not file_infos:
        return Failure("No Python files found")

    # Build perception map
    perception_map = build_perception_map(file_infos, sources, str(path.absolute()))

    # Output
    if json_output:
        output = format_map_json(perception_map)
        console.print(json.dumps(output, indent=2))
    else:
        output = format_map_text(perception_map, top_n)
        console.print(output)

    return Success(None)h)Nu}(hrun_sighKh}(h}(hKFhK uh}(hKqhKuuh}(h}(hKFhKuh}(hKFhKuuh](}(htargethK
h}(h}(hKFhKuh}(hKFhKuuh}(h}(hKFhKuh}(hKFhKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'5target: str, json_output: bool) -> Result[None, str]:h)hu}(hjson_outputhK
h}(h}(hKFhKuh}(hKFhK*uuh}(h}(hKFhKuh}(hKFhK*uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'(json_output: bool) -> Result[None, str]:h)hu}(h
file_path_strhK
h}(h}(hKOhKuh}(hKOhKuuh}(h}(hKOhKuh}(hKOhKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'2file_path_str, symbol_name = target.split("::", 1)h)hu}(hsymbol_namehK
h}(h}(hKOhKuh}(hKOhK"uuh}(h}(hKOhKuh}(hKOhK"uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'#symbol_name = target.split("::", 1)h)hu}(h	file_pathhK
h}(h}(hKThKuh}(hKThK
uuh}(h}(hKThKuh}(hKThK
uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'file_path = Path(file_path_str)h)hu}(hcontenthK
h}(h}(hKZhKuh}(hKZhKuuh}(h}(hKZhKuh}(hKZhKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'/content = file_path.read_text(encoding="utf-8")h)hu}(hhhK
h}(h}(hK[hK,uh}(hK[hK-uuh}(h}(hK[hK,uh}(hK[hK-uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#j+  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'e:h)hu}(h	file_infohK
h}(h}(hK^hKuh}(hK^hK
uuh}(h}(hK^hKuh}(hK^hK
uuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#j8  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'1file_info = parse_source(content, str(file_path))h)hu}(hsymbolshK
h}(h}(hKchKuh}(hKchKuuh}(h}(hKchKuh}(hKchKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#jE  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh')symbols: list[Symbol] = file_info.symbolsh)hu}(houtputhK
h}(h}(hKkhKuh}(hKkhKuuh}(h}(hKkhKuh}(hKkhKuuh]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#jR  h$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'8output = format_signatures_json(symbols, str(file_path))h)hueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/shell/perception.pyh#hh$8/Users/tefx/Projects/Invar/src/invar/shell/perception.pyh&huh'Xp  def run_sig(target: str, json_output: bool) -> Result[None, str]:
    """
    Run the sig command.

    Extracts signatures from a file or specific symbol.
    Target format: "path/to/file.py" or "path/to/file.py::symbol_name"
    """
    # Parse target
    if "::" in target:
        file_path_str, symbol_name = target.split("::", 1)
    else:
        file_path_str = target
        symbol_name = None

    file_path = Path(file_path_str)
    if not file_path.exists():
        return Failure(f"File not found: {file_path}")

    # Read and parse
    try:
        content = file_path.read_text(encoding="utf-8")
    except (OSError, UnicodeDecodeError) as e:
        return Failure(f"Failed to read {file_path}: {e}")

    file_info = parse_source(content, str(file_path))
    if file_info is None:
        return Failure(f"Syntax error in {file_path}")

    # Filter symbols
    symbols: list[Symbol] = file_info.symbols
    if symbol_name:
        symbols = [s for s in symbols if s.name == symbol_name]
        if not symbols:
            return Failure(f"Symbol '{symbol_name}' not found in {file_path}")

    # Output
    if json_output:
        output = format_signatures_json(symbols, str(file_path))
        console.print(json.dumps(output, indent=2))
    else:
        output = format_signatures_text(symbols, str(file_path))
        console.print(output)

    return Success(None)h)Nue_all_symbolsNubsrc/invar/core/rule_meta.py 9f58177cf42b2c27e7013ab48558e977h)}(h](}(nameRuleCategorykindKrange}(start}(lineK	characterK uend}(jp  Kjq  KuuselectionRange}(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuuchildren](}(ji  SIZEjk  Kjl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujx  ]location}(uri=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyrangej|  absolutePath6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyrelativePathsrc/invar/core/rule_meta.pyubody
SIZE = "size"parentjh  u}(ji  	CONTRACTSjk  Kjl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K
uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K
uujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  CONTRACTS = "contracts"j  jh  u}(ji  PURITYjk  Kjl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K
uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K
uujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  PURITY = "purity"j  jh  u}(ji  SHELLjk  Kjl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K	uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K	uujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  SHELL = "shell"j  jh  u}(ji  DOCSjk  Kjl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  
DOCS = "docs"j  jh  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  jm  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  class RuleCategory(str, Enum):
    """Categories for grouping rules."""

    SIZE = "size"
    CONTRACTS = "contracts"
    PURITY = "purity"
    SHELL = "shell"
    DOCS = "docs"j  Nu}(ji  RuleMetajk  Kjl  }(jn  }(jp  Kjq  K ujr  }(jp  K-jq  K
uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujx  ](}(ji  namejk  K
jl  }(jn  }(jp  K(jq  Kujr  }(jp  K(jq  Kuujt  }(jn  }(jp  K(jq  Kujr  }(jp  K(jq  Kuujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  	name: strj  j  u}(ji  severityjk  K
jl  }(jn  }(jp  K)jq  Kujr  }(jp  K)jq  Kuujt  }(jn  }(jp  K)jq  Kujr  }(jp  K)jq  Kuujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  severity: Severityj  j  u}(ji  categoryjk  K
jl  }(jn  }(jp  K*jq  Kujr  }(jp  K*jq  Kuujt  }(jn  }(jp  K*jq  Kujr  }(jp  K*jq  Kuujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  category: RuleCategoryj  j  u}(ji  detectsjk  K
jl  }(jn  }(jp  K+jq  Kujr  }(jp  K+jq  Kuujt  }(jn  }(jp  K+jq  Kujr  }(jp  K+jq  Kuujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  detects: strj  j  u}(ji  
cannot_detectjk  K
jl  }(jn  }(jp  K,jq  Kujr  }(jp  K,jq  Kuujt  }(jn  }(jp  K,jq  Kujr  }(jp  K,jq  Kuujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  cannot_detect: tuple[str, ...]j  j  u}(ji  hintjk  K
jl  }(jn  }(jp  K-jq  Kujr  }(jp  K-jq  Kuujt  }(jn  }(jp  K-jq  Kujr  }(jp  K-jq  Kuujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  	hint: strj  j  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  X~  @dataclass(frozen=True)
class RuleMeta:
    """
    Metadata for a Guard rule.

    Examples:
        >>> meta = RULE_META["file_size"]
        >>> meta.category
        <RuleCategory.SIZE: 'size'>
        >>> "Split" in meta.hint
        True
    """

    name: str
    severity: Severity
    category: RuleCategory
    detects: str
    cannot_detect: tuple[str, ...]
    hint: strj  Nu}(ji  	RULE_METAjk  Kjl  }(jn  }(jp  K1jq  K ujr  }(jp  K1jq  K	uujt  }(jn  }(jp  K1jq  K ujr  }(jp  K1jq  K	uujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j$  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  "RULE_META: dict[str, RuleMeta] = {j  Nu}(ji  
get_rule_metajk  Kjl  }(jn  }(jp  Kjq  K ujr  }(jp  Kjq  K#uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujx  ]}(ji  	rule_namejk  K
jl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K uujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j:  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  #rule_name: str) -> RuleMeta | None:j  j/  uaj  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j1  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  Xx  @post(lambda result: result is None or isinstance(result, RuleMeta))
def get_rule_meta(rule_name: str) -> RuleMeta | None:
    """
    Get metadata for a rule by name.

    Examples:
        >>> meta = get_rule_meta("file_size")
        >>> meta is not None
        True
        >>> get_rule_meta("nonexistent") is None
        True
    """
    return RULE_META.get(rule_name)j  Nu}(ji  get_all_rule_namesjk  Kjl  }(jn  }(jp  Kjq  K ujr  }(jp  Kjq  K!uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  jK  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  X.  @post(lambda result: len(result) > 0)
def get_all_rule_names() -> list[str]:
    """
    Get list of all rule names.

    Examples:
        >>> names = get_all_rule_names()
        >>> "file_size" in names
        True
        >>> len(names) >= 10
        True
    """
    return list(RULE_META.keys())j  Nu}(ji  get_rules_by_categoryjk  Kjl  }(jn  }(jp  Kjq  K ujr  }(jp  Kjq  KMuujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  Kuujx  ]}(ji  categoryjk  K
jl  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K0uujt  }(jn  }(jp  Kjq  Kujr  }(jp  Kjq  K0uujx  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  ja  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  *category: RuleCategory) -> list[RuleMeta]:j  jV  uaj  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  jX  j  6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyj  j  uj  Xq  @post(lambda result: isinstance(result, list))
def get_rules_by_category(category: RuleCategory) -> list[RuleMeta]:
    """
    Get all rules in a category.

    Examples:
        >>> size_rules = get_rules_by_category(RuleCategory.SIZE)
        >>> len(size_rules) >= 2
        True
    """
    return [meta for meta in RULE_META.values() if meta.category == category]j  Nueja  Nubsrc/invar/core/formatter.py 6fabb925b782e1d3e4a51bfcce84e0b8h)}(h](}(nameformat_map_textkindKrange}(start}(lineK	characterK uend}(j~  K>j  KuuselectionRange}(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuchildren](}(jw  perception_mapjy  K
jz  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K1uuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K1uuj  ]location}(uri=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyrangej  absolutePath6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyrelativePathsrc/invar/core/formatter.pyubody6perception_map: PerceptionMap, top_n: int = 0) -> str:parentjv  u}(jw  top_njy  K
jz  }(j|  }(j~  Kj  K3uj  }(j~  Kj  KAuuj  }(j|  }(j~  Kj  K3uj  }(j~  Kj  KAuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  top_n: int = 0) -> str:j  jv  u}(jw  linesjy  K
jz  }(j|  }(j~  K j  Kuj  }(j~  K j  K	uuj  }(j|  }(j~  K j  Kuj  }(j~  K j  K	uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  lines: list[str] = []j  jv  u}(jw  symbolsjy  K
jz  }(j|  }(j~  K&j  Kuj  }(j~  K&j  Kuuj  }(j|  }(j~  K&j  Kuj  }(j~  K&j  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj   symbols = perception_map.symbolsj  jv  u}(jw  hotjy  K
jz  }(j|  }(j~  K/j  Kuj  }(j~  K/j  Kuuj  }(j|  }(j~  K/j  Kuj  }(j~  K/j  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  .hot = [s for s in symbols if s.ref_count > 10]j  jv  u}(jw  warmjy  K
jz  }(j|  }(j~  K0j  Kuj  }(j~  K0j  Kuuj  }(j|  }(j~  K0j  Kuj  }(j~  K0j  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  5warm = [s for s in symbols if 3 <= s.ref_count <= 10]j  jv  u}(jw  coldjy  K
jz  }(j|  }(j~  K1j  Kuj  }(j~  K1j  Kuuj  }(j|  }(j~  K1j  Kuj  }(j~  K1j  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  .cold = [s for s in symbols if s.ref_count < 3]j  jv  u}(jw  labeljy  K
jz  }(j|  }(j~  K3j  Kuj  }(j~  K3j  K
uuj  }(j|  }(j~  K3j  Kuj  }(j~  K3j  K
uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  label, group, level in [j  jv  u}(jw  groupjy  K
jz  }(j|  }(j~  K3j  Kuj  }(j~  K3j  Kuuj  }(j|  }(j~  K3j  Kuj  }(j~  K3j  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  group, level in [j  jv  u}(jw  leveljy  K
jz  }(j|  }(j~  K3j  Kuj  }(j~  K3j  Kuuj  }(j|  }(j~  K3j  Kuj  }(j~  K3j  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  
level in [j  jv  u}(jw  srjy  K
jz  }(j|  }(j~  K:j  Kuj  }(j~  K:j  Kuuj  }(j|  }(j~  K:j  Kuj  }(j~  K:j  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  sr in group:j  jv  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j{  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  X  @pre(lambda perception_map, top_n=0: isinstance(perception_map, PerceptionMap))
def format_map_text(perception_map: PerceptionMap, top_n: int = 0) -> str:
    """
    Format perception map as plain text.

    Args:
        perception_map: The perception map to format
        top_n: If > 0, only show top N symbols by reference count

    Examples:
        >>> from invar.core.models import PerceptionMap
        >>> pm = PerceptionMap(project_root="/test", total_files=1, total_symbols=0)
        >>> "Project:" in format_map_text(pm)
        True
    """
    lines: list[str] = []
    lines.append(f"Project: {perception_map.project_root}")
    lines.append(f"Files: {perception_map.total_files}")
    lines.append(f"Symbols: {perception_map.total_symbols}")
    lines.append("")

    symbols = perception_map.symbols
    if top_n > 0:
        symbols = symbols[:top_n]

    if not symbols:
        lines.append("No symbols found.")
        return "\n".join(lines)

    # Group by reference count level
    hot = [s for s in symbols if s.ref_count > 10]
    warm = [s for s in symbols if 3 <= s.ref_count <= 10]
    cold = [s for s in symbols if s.ref_count < 3]

    for label, group, level in [
        ("Hot (refs > 10)", hot, "hot"),
        ("Warm (refs 3-10)", warm, "warm"),
        ("Cold (refs < 3)", cold, "cold"),
    ]:
        if group:
            lines.append(f"=== {label} ===")
            for sr in group:
                lines.extend(_format_symbol_detail(sr, level=level))
            lines.append("")

    return "\n".join(lines)j  Nu}(jw  _format_symbol_detailjy  Kjz  }(j|  }(j~  KAj  K uj  }(j~  K]j  Kuuj  }(j|  }(j~  KCj  Kuj  }(j~  KCj  Kuuj  ](}(jw  srjy  K
jz  }(j|  }(j~  KCj  Kuj  }(j~  KCj  K(uuj  }(j|  }(j~  KCj  Kuj  }(j~  KCj  K(uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j.  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  )sr: SymbolRefs, level: str) -> list[str]:j  j#  u}(jw  leveljy  K
jz  }(j|  }(j~  KCj  K*uj  }(j~  KCj  K4uuj  }(j|  }(j~  KCj  K*uj  }(j~  KCj  K4uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j;  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  level: str) -> list[str]:j  j#  u}(jw  linesjy  K
jz  }(j|  }(j~  KEj  Kuj  }(j~  KEj  K	uuj  }(j|  }(j~  KEj  Kuj  }(j~  KEj  K	uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  jH  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  lines: list[str] = []j  j#  u}(jw  symjy  K
jz  }(j|  }(j~  KFj  Kuj  }(j~  KFj  Kuuj  }(j|  }(j~  KFj  Kuj  }(j~  KFj  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  jU  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  sym = sr.symbolj  j#  u}(jw  sigjy  K
jz  }(j|  }(j~  KGj  Kuj  }(j~  KGj  Kuuj  }(j|  }(j~  KGj  Kuj  }(j~  KGj  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  jb  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  &sig = sym.signature or f"({sym.name})"j  j#  u}(jw  
first_linejy  K
jz  }(j|  }(j~  KMj  Kuj  }(j~  KMj  Kuuj  }(j|  }(j~  KMj  Kuj  }(j~  KMj  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  jo  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  1first_line = sym.docstring.split("\n")[0].strip()j  j#  u}(jw  cjy  K
jz  }(j|  }(j~  KQj  Kuj  }(j~  KQj  Kuuj  }(j|  }(j~  KQj  Kuj  }(j~  KQj  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j|  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  c in sym.contracts:j  j#  u}(jw  kindsjy  K
jz  }(j|  }(j~  KWj  Kuj  }(j~  KWj  Kuuj  }(j|  }(j~  KWj  Kuj  }(j~  KWj  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  'kinds = [c.kind for c in sym.contracts]j  j#  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j%  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  X  @pre(lambda sr, level: isinstance(sr, SymbolRefs) and level in ("hot", "warm", "cold"))
@post(lambda result: all(isinstance(line, str) for line in result))
def _format_symbol_detail(sr: SymbolRefs, level: str) -> list[str]:
    """Format a single symbol with appropriate detail level."""
    lines: list[str] = []
    sym = sr.symbol
    sig = sym.signature or f"({sym.name})"

    if level == "hot":
        # Full detail: signature + docstring + contracts
        lines.append(f"  {sr.file_path}::{sym.name}{sig}  [refs: {sr.ref_count}]")
        if sym.docstring:
            first_line = sym.docstring.split("\n")[0].strip()
            if first_line:
                lines.append(f"    | {first_line}")
        if sym.contracts:
            for c in sym.contracts:
                lines.append(f"    | @{c.kind}: {c.expression}")
    elif level == "warm":
        # Medium: signature + contracts summary
        lines.append(f"  {sr.file_path}::{sym.name}{sig}  [refs: {sr.ref_count}]")
        if sym.contracts:
            kinds = [c.kind for c in sym.contracts]
            lines.append(f"    | contracts: {', '.join(kinds)}")
    else:
        # Minimal: name only
        lines.append(f"  {sr.file_path}::{sym.name}  [refs: {sr.ref_count}]")

    return linesj  Nu}(jw  format_map_jsonjy  Kjz  }(j|  }(j~  K`j  K uj  }(j~  Kqj  Kuuj  }(j|  }(j~  Kaj  Kuj  }(j~  Kaj  Kuuj  ]}(jw  perception_mapjy  K
jz  }(j|  }(j~  Kaj  Kuj  }(j~  Kaj  K1uuj  }(j|  }(j~  Kaj  Kuj  }(j~  Kaj  K1uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  'perception_map: PerceptionMap) -> dict:j  j  uaj  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  X  @pre(lambda perception_map: isinstance(perception_map, PerceptionMap))
def format_map_json(perception_map: PerceptionMap) -> dict:
    """
    Format perception map as JSON-serializable dict.

    Examples:
        >>> from invar.core.models import PerceptionMap
        >>> pm = PerceptionMap(project_root="/test", total_files=1, total_symbols=0)
        >>> d = format_map_json(pm)
        >>> d["project_root"]
        '/test'
    """
    return {
        "project_root": perception_map.project_root,
        "total_files": perception_map.total_files,
        "total_symbols": perception_map.total_symbols,
        "symbols": [_symbol_refs_to_dict(sr) for sr in perception_map.symbols],
    }j  Nu}(jw  _symbol_refs_to_dictjy  Kjz  }(j|  }(j~  Ktj  K uj  }(j~  Kj  Kuuj  }(j|  }(j~  Kvj  Kuj  }(j~  Kvj  Kuuj  ](}(jw  srjy  K
jz  }(j|  }(j~  Kvj  Kuj  }(j~  Kvj  K'uuj  }(j|  }(j~  Kvj  Kuj  }(j~  Kvj  K'uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  sr: SymbolRefs) -> dict:j  j  u}(jw  symjy  K
jz  }(j|  }(j~  Kxj  Kuj  }(j~  Kxj  Kuuj  }(j|  }(j~  Kxj  Kuj  }(j~  Kxj  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  sym = sr.symbolj  j  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  X$  @pre(lambda sr: isinstance(sr, SymbolRefs))
@post(lambda result: "name" in result and "ref_count" in result)
def _symbol_refs_to_dict(sr: SymbolRefs) -> dict:
    """Convert SymbolRefs to dict."""
    sym = sr.symbol
    return {
        "file": sr.file_path,
        "name": sym.name,
        "kind": sym.kind.value,
        "line": sym.line,
        "signature": sym.signature,
        "ref_count": sr.ref_count,
        "docstring": sym.docstring,
        "contracts": [{"kind": c.kind, "expression": c.expression} for c in sym.contracts],
    }j  Nu}(jw  format_signaturejy  Kjz  }(j|  }(j~  Kj  K uj  }(j~  Kj  K-uuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuj  ](}(jw  symboljy  K
jz  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K#uuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K#uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  'symbol: Symbol, file_path: str) -> str:j  j  u}(jw  	file_pathjy  K
jz  }(j|  }(j~  Kj  K%uj  }(j~  Kj  K3uuj  }(j|  }(j~  Kj  K%uj  }(j~  Kj  K3uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  file_path: str) -> str:j  j  u}(jw  sigjy  K
jz  }(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  sig = symbol.signature or ""j  j  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  X  @pre(lambda symbol, file_path: isinstance(symbol, Symbol))
def format_signature(symbol: Symbol, file_path: str) -> str:
    """
    Format a single symbol signature.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     signature="(x: int) -> int")
        >>> format_signature(sym, "test.py")
        'test.py::foo(x: int) -> int'
    """
    sig = symbol.signature or ""
    return f"{file_path}::{symbol.name}{sig}"j  Nu}(jw  format_signatures_textjy  Kjz  }(j|  }(j~  Kj  K uj  }(j~  Kj  Kuuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuj  ](}(jw  symbolsjy  K
jz  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K0uuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K0uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  .symbols: list[Symbol], file_path: str) -> str:j  j
  u}(jw  	file_pathjy  K
jz  }(j|  }(j~  Kj  K2uj  }(j~  Kj  K@uuj  }(j|  }(j~  Kj  K2uj  }(j~  Kj  K@uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j%  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  file_path: str) -> str:j  j
  u}(jw  linesjy  K
jz  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K	uuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K	uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j2  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  =lines = [format_signature(sym, file_path) for sym in symbols]j  j
  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  X  @pre(lambda symbols, file_path: isinstance(symbols, list))
def format_signatures_text(symbols: list[Symbol], file_path: str) -> str:
    """
    Format multiple signatures as text.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> format_signatures_text([sym], "test.py")
        'test.py::foo'
    """
    lines = [format_signature(sym, file_path) for sym in symbols]
    return "\n".join(lines)j  Nu}(jw  format_signatures_jsonjy  Kjz  }(j|  }(j~  Kj  K uj  }(j~  Kj  Kuuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuj  ](}(jw  symbolsjy  K
jz  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K0uuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K0uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  jL  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  /symbols: list[Symbol], file_path: str) -> dict:j  jA  u}(jw  	file_pathjy  K
jz  }(j|  }(j~  Kj  K2uj  }(j~  Kj  K@uuj  }(j|  }(j~  Kj  K2uj  }(j~  Kj  K@uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  jY  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  file_path: str) -> dict:j  jA  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  jC  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  Xw  @pre(lambda symbols, file_path: isinstance(symbols, list))
def format_signatures_json(symbols: list[Symbol], file_path: str) -> dict:
    """
    Format signatures as JSON-serializable dict.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> d = format_signatures_json([sym], "test.py")
        >>> d["file"]
        'test.py'
    """
    return {
        "file": file_path,
        "symbols": [
            {
                "name": sym.name,
                "kind": sym.kind.value,
                "line": sym.line,
                "signature": sym.signature,
                "docstring": sym.docstring,
                "contracts": [{"kind": c.kind, "expression": c.expression} for c in sym.contracts],
            }
            for sym in symbols
        ],
    }j  Nu}(jw  format_guard_agentjy  Kjz  }(j|  }(j~  Kj  K uj  }(j~  Kj  Kuuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuj  ]}(jw  reportjy  K
jz  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K*uuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K*uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  js  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  report: GuardReport) -> dict:j  jh  uaj  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  jj  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  XQ  @pre(lambda report: isinstance(report, GuardReport))
def format_guard_agent(report: GuardReport) -> dict:
    """
    Format Guard report for Agent consumption (Phase 8.2).

    Provides structured output with actionable fix instructions.

    Examples:
        >>> from invar.core.models import GuardReport, Violation, Severity
        >>> report = GuardReport(files_checked=1)
        >>> v = Violation(rule="missing_contract", severity=Severity.WARNING,
        ...     file="test.py", line=10, message="Function 'foo' has no contract",
        ...     suggestion="Add: @pre(lambda x: x >= 0)")
        >>> report.add_violation(v)
        >>> d = format_guard_agent(report)
        >>> d["status"]
        'passed'
        >>> len(d["fixes"])
        1
    """
    return {
        "status": "passed" if report.passed else "failed",
        "summary": {
            "files_checked": report.files_checked,
            "errors": report.errors,
            "warnings": report.warnings,
            "infos": report.infos,
        },
        "fixes": [_violation_to_fix(v) for v in report.violations],
    }j  Nu}(jw  _violation_to_fixjy  Kjz  }(j|  }(j~  Kj  K uj  }(j~  Kj  Kuuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuj  ](}(jw  vjy  K
jz  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K"uuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K"uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  v: Violation) -> dict:j  j  u}(jw  fix_infojy  K
jz  }(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  Lfix_info = _parse_suggestion(v.suggestion, v.rule) if v.suggestion else Nonej  j  u}(jw  resultjy  K
jz  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K
uuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  K
uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  result: dict = {j  j  u}(jw  metajy  K
jz  }(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuj  }(j|  }(j~  Kj  Kuj  }(j~  Kj  Kuuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  meta = get_rule_meta(v.rule)j  j  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  X  @pre(lambda v: isinstance(v, Violation))
def _violation_to_fix(v: Violation) -> dict:
    """Convert a Violation to an Agent-friendly fix instruction."""
    from invar.core.rule_meta import get_rule_meta

    fix_info = _parse_suggestion(v.suggestion, v.rule) if v.suggestion else None

    # Phase 9.2 P3: Include rule metadata
    result: dict = {
        "file": v.file,
        "line": v.line,
        "rule": v.rule,
        "severity": v.severity.value,
        "message": v.message,
        "fix": fix_info,
    }

    meta = get_rule_meta(v.rule)
    if meta:
        result["rule_meta"] = {
            "category": meta.category.value,
            "detects": meta.detects,
            "cannot_detect": list(meta.cannot_detect),
            "hint": meta.hint,
        }

    return resultj  Nu}(jw  _parse_suggestionjy  Kjz  }(j|  }(j~  M j  K uj  }(j~  Mj  K:uuj  }(j|  }(j~  Mj  Kuj  }(j~  Mj  Kuuj  ](}(jw  
suggestionjy  K
jz  }(j|  }(j~  Mj  Kuj  }(j~  Mj  K,uuj  }(j|  }(j~  Mj  Kuj  }(j~  Mj  K,uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  2suggestion: str | None, rule: str) -> dict | None:j  j  u}(jw  rulejy  K
jz  }(j|  }(j~  Mj  K.uj  }(j~  Mj  K7uuj  }(j|  }(j~  Mj  K.uj  }(j~  Mj  K7uuj  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  rule: str) -> dict | None:j  j  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  j  6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyj  j  uj  X{  @pre(lambda suggestion, rule: suggestion is None or isinstance(suggestion, str))
def _parse_suggestion(suggestion: str | None, rule: str) -> dict | None:
    """Parse suggestion string into structured fix instruction."""
    if not suggestion:
        return None

    # Parse "Add: @pre(...)" style suggestions
    if suggestion.startswith("Add: "):
        return {"action": "add_decorator", "code": suggestion[5:]}

    # Parse "Replace with: @pre(...)" style suggestions
    if suggestion.startswith("Replace with: "):
        return {"action": "replace_decorator", "code": suggestion[14:]}

    # Parse "Replace with business logic: @pre(...)" style
    if suggestion.startswith("Replace with business logic: "):
        return {"action": "replace_decorator", "code": suggestion[29:]}

    # Default: return as instruction text
    return {"action": "manual", "instruction": suggestion}j  Nueja  Nubsrc/invar/core/suggestions.py 7df5ea5a04682e5a26cdf21d8973872fh)}(h](}(nameCONSTRAINT_PATTERNSkindKrange}(start}(lineK	characterK uend}(j  Kj  KuuselectionRange}(j  }(j  Kj  K uj  }(j  Kj  Kuuchildren]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'-CONSTRAINT_PATTERNS: dict[str, list[str]] = {h)}(namesuggestionskindsolidlsp.ls_types
SymbolKindKRh#}(start}(lineK 	characterK uend}(j  MDj  K uuselectionRangej  h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&src/invar/core/suggestions.pyuchildrenj  h)}(j  corej	  j  KRh}(h!0file:///Users/tefx/Projects/Invar/src/invar/coreh#}(j  }(j  K j  K uj  }(j  K j  K uuh$)/Users/tefx/Projects/Invar/src/invar/coreh&src/invar/coreuj  ](}(j  	rule_metaj	  j  h#}(j  }(j  K j  K uj  }(j  Kj  K uuj  j*  h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j*  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&src/invar/core/rule_meta.pyuj  ](}(nameRuleCategorykindKrange}(start}(lineK	characterK uend}(j:  Kj;  KuuselectionRange}(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  Kuuchildren](}(j3  SIZEj5  Kj6  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  Kuuj>  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  KuujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#jF  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'
SIZE = "size"h)j2  u}(j3  	CONTRACTSj5  Kj6  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  K
uuj>  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  K
uujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#jS  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'CONTRACTS = "contracts"h)j2  u}(j3  PURITYj5  Kj6  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  K
uuj>  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  K
uujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j`  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'PURITY = "purity"h)j2  u}(j3  SHELLj5  Kj6  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  K	uuj>  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  K	uujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#jm  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'SHELL = "shell"h)j2  u}(j3  DOCSj5  Kj6  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  Kuuj>  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  KuujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#jz  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'
DOCS = "docs"h)j2  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j7  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'class RuleCategory(str, Enum):
    """Categories for grouping rules."""

    SIZE = "size"
    CONTRACTS = "contracts"
    PURITY = "purity"
    SHELL = "shell"
    DOCS = "docs"h)j(  u}(j3  RuleMetaj5  Kj6  }(j8  }(j:  Kj;  K uj<  }(j:  K+j;  K
uuj>  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  KuujB  ](}(j3  namej5  K
j6  }(j8  }(j:  K&j;  Kuj<  }(j:  K&j;  Kuuj>  }(j8  }(j:  K&j;  Kuj<  }(j:  K&j;  KuujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'	name: strh)j  u}(j3  severityj5  K
j6  }(j8  }(j:  K'j;  Kuj<  }(j:  K'j;  Kuuj>  }(j8  }(j:  K'j;  Kuj<  }(j:  K'j;  KuujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'severity: Severityh)j  u}(j3  categoryj5  K
j6  }(j8  }(j:  K(j;  Kuj<  }(j:  K(j;  Kuuj>  }(j8  }(j:  K(j;  Kuj<  }(j:  K(j;  KuujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'category: RuleCategoryh)j  u}(j3  detectsj5  K
j6  }(j8  }(j:  K)j;  Kuj<  }(j:  K)j;  Kuuj>  }(j8  }(j:  K)j;  Kuj<  }(j:  K)j;  KuujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'detects: strh)j  u}(j3  
cannot_detectj5  K
j6  }(j8  }(j:  K*j;  Kuj<  }(j:  K*j;  Kuuj>  }(j8  }(j:  K*j;  Kuj<  }(j:  K*j;  KuujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'cannot_detect: tuple[str, ...]h)j  u}(j3  hintj5  K
j6  }(j8  }(j:  K+j;  Kuj<  }(j:  K+j;  Kuuj>  }(j8  }(j:  K+j;  Kuj<  }(j:  K+j;  KuujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'	hint: strh)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'X~  @dataclass(frozen=True)
class RuleMeta:
    """
    Metadata for a Guard rule.

    Examples:
        >>> meta = RULE_META["file_size"]
        >>> meta.category
        <RuleCategory.SIZE: 'size'>
        >>> "Split" in meta.hint
        True
    """

    name: str
    severity: Severity
    category: RuleCategory
    detects: str
    cannot_detect: tuple[str, ...]
    hint: strh)j(  u}(j3  	RULE_METAj5  Kj6  }(j8  }(j:  K/j;  K uj<  }(j:  K/j;  K	uuj>  }(j8  }(j:  K/j;  K uj<  }(j:  K/j;  K	uujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'"RULE_META: dict[str, RuleMeta] = {h)j(  u}(j3  
get_rule_metaj5  Kj6  }(j8  }(j:  Kj;  K uj<  }(j:  Kj;  K#uuj>  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  KuujB  ]}(j3  	rule_namej5  K
j6  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  K uuj>  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  K uujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'#rule_name: str) -> RuleMeta | None:h)j  uah}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'X3  def get_rule_meta(rule_name: str) -> RuleMeta | None:
    """
    Get metadata for a rule by name.

    Examples:
        >>> meta = get_rule_meta("file_size")
        >>> meta is not None
        True
        >>> get_rule_meta("nonexistent") is None
        True
    """
    return RULE_META.get(rule_name)h)j(  u}(j3  get_all_rule_namesj5  Kj6  }(j8  }(j:  Kj;  K uj<  }(j:  Kj;  K!uuj>  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  KuujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j
  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'X  def get_all_rule_names() -> list[str]:
    """
    Get list of all rule names.

    Examples:
        >>> names = get_all_rule_names()
        >>> "file_size" in names
        True
        >>> len(names) >= 10
        True
    """
    return list(RULE_META.keys())h)j(  u}(j3  get_rules_by_categoryj5  Kj6  }(j8  }(j:  Kj;  K uj<  }(j:  Kj;  KMuuj>  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  KuujB  ]}(j3  categoryj5  K
j6  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  K0uuj>  }(j8  }(j:  Kj;  Kuj<  }(j:  Kj;  K0uujB  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j#  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'*category: RuleCategory) -> list[RuleMeta]:h)j  uah}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/rule_meta.pyh&jc  uh'XB  def get_rules_by_category(category: RuleCategory) -> list[RuleMeta]:
    """
    Get all rules in a category.

    Examples:
        >>> size_rules = get_rules_by_category(RuleCategory.SIZE)
        >>> len(size_rules) >= 2
        True
    """
    return [meta for meta in RULE_META.values() if meta.category == category]h)j(  ueh)j  u}(j  	formatterj	  j  h#}(j  }(j  K j  K uj  }(j  Mj  K uuj  j4  h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j4  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&src/invar/core/formatter.pyuj  ](}(nameformat_map_textkindKrange}(start}(lineK	characterK uend}(jD  K;jE  KuuselectionRange}(jB  }(jD  KjE  KujF  }(jD  KjE  Kuuchildren](}(j=  perception_mapj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  K1uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  K1uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jP  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'6perception_map: PerceptionMap, top_n: int = 0) -> str:h)j<  u}(j=  top_nj?  K
j@  }(jB  }(jD  KjE  K3ujF  }(jD  KjE  KAuujH  }(jB  }(jD  KjE  K3ujF  }(jD  KjE  KAuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j]  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'top_n: int = 0) -> str:h)j<  u}(j=  linesj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  K	uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  K	uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jj  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'lines: list[str] = []h)j<  u}(j=  symbolsj?  K
j@  }(jB  }(jD  K%jE  KujF  }(jD  K%jE  KuujH  }(jB  }(jD  K%jE  KujF  }(jD  K%jE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jw  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh' symbols = perception_map.symbolsh)j<  u}(j=  hotj?  K
j@  }(jB  }(jD  K.jE  KujF  }(jD  K.jE  KuujH  }(jB  }(jD  K.jE  KujF  }(jD  K.jE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'.hot = [s for s in symbols if s.ref_count > 10]h)j<  u}(j=  warmj?  K
j@  }(jB  }(jD  K/jE  KujF  }(jD  K/jE  KuujH  }(jB  }(jD  K/jE  KujF  }(jD  K/jE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'5warm = [s for s in symbols if 3 <= s.ref_count <= 10]h)j<  u}(j=  coldj?  K
j@  }(jB  }(jD  K0jE  KujF  }(jD  K0jE  KuujH  }(jB  }(jD  K0jE  KujF  }(jD  K0jE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'.cold = [s for s in symbols if s.ref_count < 3]h)j<  u}(j=  labelj?  K
j@  }(jB  }(jD  K2jE  KujF  }(jD  K2jE  K
uujH  }(jB  }(jD  K2jE  KujF  }(jD  K2jE  K
uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'8label, group, level in [("Hot (refs > 10)", hot, "hot"),h)j<  u}(j=  groupj?  K
j@  }(jB  }(jD  K2jE  KujF  }(jD  K2jE  KuujH  }(jB  }(jD  K2jE  KujF  }(jD  K2jE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'1group, level in [("Hot (refs > 10)", hot, "hot"),h)j<  u}(j=  levelj?  K
j@  }(jB  }(jD  K2jE  KujF  }(jD  K2jE  KuujH  }(jB  }(jD  K2jE  KujF  }(jD  K2jE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'*level in [("Hot (refs > 10)", hot, "hot"),h)j<  u}(j=  srj?  K
j@  }(jB  }(jD  K7jE  KujF  }(jD  K7jE  KuujH  }(jB  }(jD  K7jE  KujF  }(jD  K7jE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'sr in group:h)j<  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jA  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'X5  @pre(lambda perception_map, top_n=0: isinstance(perception_map, PerceptionMap))
def format_map_text(perception_map: PerceptionMap, top_n: int = 0) -> str:
    """
    Format perception map as plain text.

    Args:
        perception_map: The perception map to format
        top_n: If > 0, only show top N symbols by reference count

    Examples:
        >>> from invar.core.models import PerceptionMap
        >>> pm = PerceptionMap(project_root="/test", total_files=1, total_symbols=0)
        >>> "Project:" in format_map_text(pm)
        True
    """
    lines: list[str] = []
    lines.append(f"Project: {perception_map.project_root}")
    lines.append(f"Files: {perception_map.total_files}")
    lines.append(f"Symbols: {perception_map.total_symbols}")
    lines.append("")

    symbols = perception_map.symbols
    if top_n > 0:
        symbols = symbols[:top_n]

    if not symbols:
        lines.append("No symbols found.")
        return "\n".join(lines)

    # Group by reference count level
    hot = [s for s in symbols if s.ref_count > 10]
    warm = [s for s in symbols if 3 <= s.ref_count <= 10]
    cold = [s for s in symbols if s.ref_count < 3]

    for label, group, level in [("Hot (refs > 10)", hot, "hot"),
                                  ("Warm (refs 3-10)", warm, "warm"),
                                  ("Cold (refs < 3)", cold, "cold")]:
        if group:
            lines.append(f"=== {label} ===")
            for sr in group:
                lines.extend(_format_symbol_detail(sr, level=level))
            lines.append("")

    return "\n".join(lines)h)j2  u}(j=  _format_symbol_detailj?  Kj@  }(jB  }(jD  K>jE  K ujF  }(jD  KZjE  KuujH  }(jB  }(jD  K@jE  KujF  }(jD  K@jE  KuujL  ](}(j=  srj?  K
j@  }(jB  }(jD  K@jE  KujF  }(jD  K@jE  K(uujH  }(jB  }(jD  K@jE  KujF  }(jD  K@jE  K(uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh')sr: SymbolRefs, level: str) -> list[str]:h)j  u}(j=  levelj?  K
j@  }(jB  }(jD  K@jE  K*ujF  }(jD  K@jE  K4uujH  }(jB  }(jD  K@jE  K*ujF  }(jD  K@jE  K4uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'level: str) -> list[str]:h)j  u}(j=  linesj?  K
j@  }(jB  }(jD  KBjE  KujF  }(jD  KBjE  K	uujH  }(jB  }(jD  KBjE  KujF  }(jD  KBjE  K	uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'lines: list[str] = []h)j  u}(j=  symj?  K
j@  }(jB  }(jD  KCjE  KujF  }(jD  KCjE  KuujH  }(jB  }(jD  KCjE  KujF  }(jD  KCjE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'sym = sr.symbolh)j  u}(j=  sigj?  K
j@  }(jB  }(jD  KDjE  KujF  }(jD  KDjE  KuujH  }(jB  }(jD  KDjE  KujF  }(jD  KDjE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'&sig = sym.signature or f"({sym.name})"h)j  u}(j=  
first_linej?  K
j@  }(jB  }(jD  KJjE  KujF  }(jD  KJjE  KuujH  }(jB  }(jD  KJjE  KujF  }(jD  KJjE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j-  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'1first_line = sym.docstring.split("\n")[0].strip()h)j  u}(j=  j{  j?  K
j@  }(jB  }(jD  KNjE  KujF  }(jD  KNjE  KuujH  }(jB  }(jD  KNjE  KujF  }(jD  KNjE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j9  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'c in sym.contracts:h)j  u}(j=  kindsj?  K
j@  }(jB  }(jD  KTjE  KujF  }(jD  KTjE  KuujH  }(jB  }(jD  KTjE  KujF  }(jD  KTjE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jF  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh''kinds = [c.kind for c in sym.contracts]h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'X  @pre(lambda sr, level: isinstance(sr, SymbolRefs) and level in ("hot", "warm", "cold"))
@post(lambda result: all(isinstance(line, str) for line in result))
def _format_symbol_detail(sr: SymbolRefs, level: str) -> list[str]:
    """Format a single symbol with appropriate detail level."""
    lines: list[str] = []
    sym = sr.symbol
    sig = sym.signature or f"({sym.name})"

    if level == "hot":
        # Full detail: signature + docstring + contracts
        lines.append(f"  {sr.file_path}::{sym.name}{sig}  [refs: {sr.ref_count}]")
        if sym.docstring:
            first_line = sym.docstring.split("\n")[0].strip()
            if first_line:
                lines.append(f"    | {first_line}")
        if sym.contracts:
            for c in sym.contracts:
                lines.append(f"    | @{c.kind}: {c.expression}")
    elif level == "warm":
        # Medium: signature + contracts summary
        lines.append(f"  {sr.file_path}::{sym.name}{sig}  [refs: {sr.ref_count}]")
        if sym.contracts:
            kinds = [c.kind for c in sym.contracts]
            lines.append(f"    | contracts: {', '.join(kinds)}")
    else:
        # Minimal: name only
        lines.append(f"  {sr.file_path}::{sym.name}  [refs: {sr.ref_count}]")

    return linesh)j2  u}(j=  format_map_jsonj?  Kj@  }(jB  }(jD  K]jE  K ujF  }(jD  KnjE  KuujH  }(jB  }(jD  K^jE  KujF  }(jD  K^jE  KuujL  ]}(j=  perception_mapj?  K
j@  }(jB  }(jD  K^jE  KujF  }(jD  K^jE  K1uujH  }(jB  }(jD  K^jE  KujF  }(jD  K^jE  K1uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j`  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh''perception_map: PerceptionMap) -> dict:h)jU  uah}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jW  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'X  @pre(lambda perception_map: isinstance(perception_map, PerceptionMap))
def format_map_json(perception_map: PerceptionMap) -> dict:
    """
    Format perception map as JSON-serializable dict.

    Examples:
        >>> from invar.core.models import PerceptionMap
        >>> pm = PerceptionMap(project_root="/test", total_files=1, total_symbols=0)
        >>> d = format_map_json(pm)
        >>> d["project_root"]
        '/test'
    """
    return {
        "project_root": perception_map.project_root,
        "total_files": perception_map.total_files,
        "total_symbols": perception_map.total_symbols,
        "symbols": [_symbol_refs_to_dict(sr) for sr in perception_map.symbols],
    }h)j2  u}(j=  _symbol_refs_to_dictj?  Kj@  }(jB  }(jD  KqjE  K ujF  }(jD  KjE  KuujH  }(jB  }(jD  KsjE  KujF  }(jD  KsjE  KuujL  ](}(j=  srj?  K
j@  }(jB  }(jD  KsjE  KujF  }(jD  KsjE  K'uujH  }(jB  }(jD  KsjE  KujF  }(jD  KsjE  K'uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jz  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'sr: SymbolRefs) -> dict:h)jo  u}(j=  symj?  K
j@  }(jB  }(jD  KujE  KujF  }(jD  KujE  KuujH  }(jB  }(jD  KujE  KujF  }(jD  KujE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'sym = sr.symbolh)jo  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jq  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'X$  @pre(lambda sr: isinstance(sr, SymbolRefs))
@post(lambda result: "name" in result and "ref_count" in result)
def _symbol_refs_to_dict(sr: SymbolRefs) -> dict:
    """Convert SymbolRefs to dict."""
    sym = sr.symbol
    return {
        "file": sr.file_path,
        "name": sym.name,
        "kind": sym.kind.value,
        "line": sym.line,
        "signature": sym.signature,
        "ref_count": sr.ref_count,
        "docstring": sym.docstring,
        "contracts": [{"kind": c.kind, "expression": c.expression} for c in sym.contracts],
    }h)j2  u}(j=  format_signaturej?  Kj@  }(       jB  }(jD  KjE  K ujF  }(jD  KjE  K-uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujL  ](}(j=  symbolj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  K#uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  K#uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh''symbol: Symbol, file_path: str) -> str:h)j  u}(j=  	file_pathj?  K
j@  }(jB  }(jD  KjE  K%ujF  }(jD  KjE  K3uujH  }(jB  }(jD  KjE  K%ujF  }(jD  KjE  K3uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'file_path: str) -> str:h)j  u}(j=  sigj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'sig = symbol.signature or ""h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'X  @pre(lambda symbol, file_path: isinstance(symbol, Symbol))
def format_signature(symbol: Symbol, file_path: str) -> str:
    """
    Format a single symbol signature.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     signature="(x: int) -> int")
        >>> format_signature(sym, "test.py")
        'test.py::foo(x: int) -> int'
    """
    sig = symbol.signature or ""
    return f"{file_path}::{symbol.name}{sig}"h)j2  u}(j=  format_signatures_textj?  Kj@  }(jB  }(jD  KjE  K ujF  }(jD  KjE  KuujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujL  ](}(j=  symbolsj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  K0uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  K0uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'.symbols: list[Symbol], file_path: str) -> str:h)j  u}(j=  	file_pathj?  K
j@  }(jB  }(jD  KjE  K2ujF  }(jD  KjE  K@uujH  }(jB  }(jD  KjE  K2ujF  }(jD  KjE  K@uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'file_path: str) -> str:h)j  u}(j=  linesj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  K	uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  K	uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'=lines = [format_signature(sym, file_path) for sym in symbols]h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'X  @pre(lambda symbols, file_path: isinstance(symbols, list))
def format_signatures_text(symbols: list[Symbol], file_path: str) -> str:
    """
    Format multiple signatures as text.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> format_signatures_text([sym], "test.py")
        'test.py::foo'
    """
    lines = [format_signature(sym, file_path) for sym in symbols]
    return "\n".join(lines)h)j2  u}(j=  format_signatures_jsonj?  Kj@  }(jB  }(jD  KjE  K ujF  }(jD  KjE  KuujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujL  ](}(j=  symbolsj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  K0uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  K0uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j	  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'/symbols: list[Symbol], file_path: str) -> dict:h)j  u}(j=  	file_pathj?  K
j@  }(jB  }(jD  KjE  K2ujF  }(jD  KjE  K@uujH  }(jB  }(jD  KjE  K2ujF  }(jD  KjE  K@uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'file_path: str) -> dict:h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'Xw  @pre(lambda symbols, file_path: isinstance(symbols, list))
def format_signatures_json(symbols: list[Symbol], file_path: str) -> dict:
    """
    Format signatures as JSON-serializable dict.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> d = format_signatures_json([sym], "test.py")
        >>> d["file"]
        'test.py'
    """
    return {
        "file": file_path,
        "symbols": [
            {
                "name": sym.name,
                "kind": sym.kind.value,
                "line": sym.line,
                "signature": sym.signature,
                "docstring": sym.docstring,
                "contracts": [{"kind": c.kind, "expression": c.expression} for c in sym.contracts],
            }
            for sym in symbols
        ],
    }h)j2  u}(j=  format_guard_agentj?  Kj@  }(jB  }(jD  KjE  K ujF  }(jD  KjE  KuujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujL  ]}(j=  reportj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  K*uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  K*uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j0  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'report: GuardReport) -> dict:h)j%  uah}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j'  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'XQ  @pre(lambda report: isinstance(report, GuardReport))
def format_guard_agent(report: GuardReport) -> dict:
    """
    Format Guard report for Agent consumption (Phase 8.2).

    Provides structured output with actionable fix instructions.

    Examples:
        >>> from invar.core.models import GuardReport, Violation, Severity
        >>> report = GuardReport(files_checked=1)
        >>> v = Violation(rule="missing_contract", severity=Severity.WARNING,
        ...     file="test.py", line=10, message="Function 'foo' has no contract",
        ...     suggestion="Add: @pre(lambda x: x >= 0)")
        >>> report.add_violation(v)
        >>> d = format_guard_agent(report)
        >>> d["status"]
        'passed'
        >>> len(d["fixes"])
        1
    """
    return {
        "status": "passed" if report.passed else "failed",
        "summary": {
            "files_checked": report.files_checked,
            "errors": report.errors,
            "warnings": report.warnings,
            "infos": report.infos,
        },
        "fixes": [_violation_to_fix(v) for v in report.violations],
    }h)j2  u}(j=  _violation_to_fixj?  Kj@  }(jB  }(jD  KjE  K ujF  }(jD  KjE  KuujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujL  ](}(j=  j  j?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  K"uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  K"uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jI  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'v: Violation) -> dict:h)j?  u}(j=  fix_infoj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jV  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'Lfix_info = _parse_suggestion(v.suggestion, v.rule) if v.suggestion else Noneh)j?  u}(j=  resultj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  K
uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  K
uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jc  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'result: dict = {h)j?  u}(j=  metaj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jp  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'meta = get_rule_meta(v.rule)h)j?  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#jA  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'X  @pre(lambda v: isinstance(v, Violation))
def _violation_to_fix(v: Violation) -> dict:
    """Convert a Violation to an Agent-friendly fix instruction."""
    from invar.core.rule_meta import get_rule_meta

    fix_info = _parse_suggestion(v.suggestion, v.rule) if v.suggestion else None

    # Phase 9.2 P3: Include rule metadata
    result: dict = {
        "file": v.file,
        "line": v.line,
        "rule": v.rule,
        "severity": v.severity.value,
        "message": v.message,
        "fix": fix_info,
    }

    meta = get_rule_meta(v.rule)
    if meta:
        result["rule_meta"] = {
            "category": meta.category.value,
            "detects": meta.detects,
            "cannot_detect": list(meta.cannot_detect),
            "hint": meta.hint,
        }

    return resulth)j2  u}(j=  _parse_suggestionj?  Kj@  }(jB  }(jD  KjE  K ujF  }(jD  MjE  K:uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  KuujL  ](}(j=  
suggestionj?  K
j@  }(jB  }(jD  KjE  KujF  }(jD  KjE  K,uujH  }(jB  }(jD  KjE  KujF  }(jD  KjE  K,uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'2suggestion: str | None, rule: str) -> dict | None:h)j  u}(j=  rulej?  K
j@  }(jB  }(jD  KjE  K.ujF  }(jD  KjE  K7uujH  }(jB  }(jD  KjE  K.ujF  }(jD  KjE  K7uujL  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'rule: str) -> dict | None:h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/formatter.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/formatter.pyh&jq  uh'X{  @pre(lambda suggestion, rule: suggestion is None or isinstance(suggestion, str))
def _parse_suggestion(suggestion: str | None, rule: str) -> dict | None:
    """Parse suggestion string into structured fix instruction."""
    if not suggestion:
        return None

    # Parse "Add: @pre(...)" style suggestions
    if suggestion.startswith("Add: "):
        return {"action": "add_decorator", "code": suggestion[5:]}

    # Parse "Replace with: @pre(...)" style suggestions
    if suggestion.startswith("Replace with: "):
        return {"action": "replace_decorator", "code": suggestion[14:]}

    # Parse "Replace with business logic: @pre(...)" style
    if suggestion.startswith("Replace with business logic: "):
        return {"action": "replace_decorator", "code": suggestion[29:]}

    # Default: return as instruction text
    return {"action": "manual", "instruction": suggestion}h)j2  ueh)j  uj  }(j  modelsj	  j  h#}(j  }(j  K j  K uj  }(j  Mj  K uuj  j  h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&src/invar/core/models.pyuj  ](}(name
SymbolKindkindKrange}(start}(lineK	characterK uend}(j  Kj  KuuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  FUNCTIONj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&src/invar/core/models.pyuh'FUNCTION = "function"h)j  u}(j  CLASSj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'CLASS = "class"h)j  u}(j  METHODj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'METHOD = "method"h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'class SymbolKind(str, Enum):
    """Kind of symbol extracted from Python code."""

    FUNCTION = "function"
    CLASS = "class"
    METHOD = "method"h)j  u}(j  Severityj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  ERRORj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'ERROR = "error"h)j  u}(j  WARNINGj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'WARNING = "warning"h)j  u}(j  INFOj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'PINFO = "info"  # Phase 7: For informational issues like redundant type contractsh)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'class Severity(str, Enum):
    """Severity level for violations."""

    ERROR = "error"
    WARNING = "warning"
    INFO = "info"  # Phase 7: For informational issues like redundant type contractsh)j  u}(j  Contractj  Kj  }(j  }(j  K j  K uj  }(j  K%j  K
uuj  }(j  }(j  K j  Kuj  }(j  K j  Kuuj  ](}(j  kindj  K
j  }(j  }(j  K#j  Kuj  }(j  K#j  Kuuj  }(j  }(j  K#j  Kuj  }(j  K#j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j-	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'kind: Literal["pre", "post"]h)j"	  u}(j  
expressionj  K
j  }(j  }(j  K$j  Kuj  }(j  K$j  Kuuj  }(j  }(j  K$j  Kuj  }(j  K$j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j:	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'expression: strh)j"	  u}(j  linej  K
j  }(j  }(j  K%j  Kuj  }(j  K%j  Kuuj  }(j  }(j  K%j  Kuj  }(j  K%j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jG	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	line: inth)j"	  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j$	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'class Contract(BaseModel):
    """A contract (precondition or postcondition) on a function."""

    kind: Literal["pre", "post"]
    expression: str
    line: inth)j  u}(j  Symbolj  Kj  }(j  }(j  K(j  K uj  }(j  K:j  K;uuj  }(j  }(j  K(j  Kuj  }(j  K(j  Kuuj  ](}(j  namej  K
j  }(j  }(j  K+j  Kuj  }(j  K+j  Kuuj  }(j  }(j  K+j  Kuj  }(j  K+j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#ja	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	name: strh)jV	  u}(j  kindj  K
j  }(j  }(j  K,j  Kuj  }(j  K,j  Kuuj  }(j  }(j  K,j  Kuj  }(j  K,j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jn	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'kind: SymbolKindh)jV	  u}(j  linej  K
j  }(j  }(j  K-j  Kuj  }(j  K-j  Kuuj  }(j  }(j  K-j  Kuj  }(j  K-j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j{	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	line: inth)jV	  u}(j  end_linej  K
j  }(j  }(j  K.j  Kuj  }(j  K.j  Kuuj  }(j  }(j  K.j  Kuj  }(j  K.j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'
end_line: inth)jV	  u}(j  	signaturej  K
j  }(j  }(j  K/j  Kuj  }(j  K/j  K
uuj  }(j  }(j  K/j  Kuj  }(j  K/j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'signature: str = ""h)jV	  u}(j  	docstringj  K
j  }(j  }(j  K0j  Kuj  }(j  K0j  K
uuj  }(j  }(j  K0j  Kuj  }(j  K0j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'docstring: str | None = Noneh)jV	  u}(j  	contractsj  K
j  }(j  }(j  K1j  Kuj  }(j  K1j  K
uuj  }(j  }(j  K1j  Kuj  }(j  K1j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'7contracts: list[Contract] = Field(default_factory=list)h)jV	  u}(j  has_doctestj  K
j  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'has_doctest: bool = Falseh)jV	  u}(j  internal_importsj  K
j  }(j  }(j  K4j  Kuj  }(j  K4j  Kuuj  }(j  }(j  K4j  Kuj  }(j  K4j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'9internal_imports: list[str] = Field(default_factory=list)h)jV	  u}(j  impure_callsj  K
j  }(j  }(j  K5j  Kuj  }(j  K5j  Kuuj  }(j  }(j  K5j  Kuj  }(j  K5j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'5impure_calls: list[str] = Field(default_factory=list)h)jV	  u}(j  
code_linesj  K
j  }(j  }(j  K6j  Kuj  }(j  K6j  Kuuj  }(j  }(j  K6j  Kuj  }(j  K6j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Ccode_lines: int | None = None  # Lines excluding docstring/commentsh)jV	  u}(j  
doctest_linesj  K
j  }(j  }(j  K8j  Kuj  }(j  K8j  Kuuj  }(j  }(j  K8j  Kuj  }(j  K8j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Cdoctest_lines: int = 0  # Number of lines that are doctest examplesh)jV	  u}(j  function_callsj  K
j  }(j  }(j  K:j  Kuj  }(j  K:j  Kuuj  }(j  }(j  K:j  Kuj  }(j  K:j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'`function_calls: list[str] = Field(default_factory=list)  # Functions called within this functionh)jV	  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jX	  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  class Symbol(BaseModel):
    """A symbol extracted from Python source code."""

    name: str
    kind: SymbolKind
    line: int
    end_line: int
    signature: str = ""
    docstring: str | None = None
    contracts: list[Contract] = Field(default_factory=list)
    has_doctest: bool = False
    # Phase 3: Guard Enhancement
    internal_imports: list[str] = Field(default_factory=list)
    impure_calls: list[str] = Field(default_factory=list)
    code_lines: int | None = None  # Lines excluding docstring/comments
    # Phase 6: Verification Completeness
    doctest_lines: int = 0  # Number of lines that are doctest examples
    # Phase 11 P25: For extraction analysis
    function_calls: list[str] = Field(default_factory=list)  # Functions called within this functionh)j  u}(j  FileInfoj  Kj  }(j  }(j  K=j  K uj  }(j  KEj  Kuuj  }(j  }(j  K=j  Kuj  }(j  K=j  Kuuj  ](}(j  pathj  K
j  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	path: strh)j
  u}(j  linesj  K
j  }(j  }(j  KAj  Kuj  }(j  KAj  K	uuj  }(j  }(j  KAj  Kuj  }(j  KAj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j$
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'
lines: inth)j
  u}(j  symbolsj  K
j  }(j  }(j  KBj  Kuj  }(j  KBj  Kuuj  }(j  }(j  KBj  Kuj  }(j  KBj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j1
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'3symbols: list[Symbol] = Field(default_factory=list)h)j
  u}(j  importsj  K
j  }(j  }(j  KCj  Kuj  }(j  KCj  Kuuj  }(j  }(j  KCj  Kuj  }(j  KCj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j>
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'0imports: list[str] = Field(default_factory=list)h)j
  u}(j  is_corej  K
j  }(j  }(j  KDj  Kuj  }(j  KDj  Kuuj  }(j  }(j  KDj  Kuj  }(j  KDj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jK
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'is_core: bool = Falseh)j
  u}(j  is_shellj  K
j  }(j  }(j  KEj  Kuj  }(j  KEj  Kuuj  }(j  }(j  KEj  Kuj  }(j  KEj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jX
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'is_shell: bool = Falseh)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  class FileInfo(BaseModel):
    """Information about a Python file."""

    path: str
    lines: int
    symbols: list[Symbol] = Field(default_factory=list)
    imports: list[str] = Field(default_factory=list)
    is_core: bool = False
    is_shell: bool = Falseh)j  u}(j  	Violationj  Kj  }(j  }(j  KHj  K uj  }(j  KPj  K!uuj  }(j  }(j  KHj  Kuj  }(j  KHj  Kuuj  ](}(j  rulej  K
j  }(j  }(j  KKj  Kuj  }(j  KKj  Kuuj  }(j  }(j  KKj  Kuj  }(j  KKj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jr
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	rule: strh)jg
  u}(j  severityj  K
j  }(j  }(j  KLj  Kuj  }(j  KLj  Kuuj  }(j  }(j  KLj  Kuj  }(j  KLj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'severity: Severityh)jg
  u}(j  filej  K
j  }(j  }(j  KMj  Kuj  }(j  KMj  Kuuj  }(j  }(j  KMj  Kuj  }(j  KMj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'	file: strh)jg
  u}(j  linej  K
j  }(j  }(j  KNj  Kuj  }(j  KNj  Kuuj  }(j  }(j  KNj  Kuj  }(j  KNj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'line: int | None = Noneh)jg
  u}(j  messagej  K
j  }(j  }(j  KOj  Kuj  }(j  KOj  Kuuj  }(j  }(j  KOj  Kuj  }(j  KOj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'message: strh)jg
  u}(j  
suggestionj  K
j  }(j  }(j  KPj  Kuj  }(j  KPj  Kuuj  }(j  }(j  KPj  Kuj  }(j  KPj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'suggestion: str | None = Noneh)jg
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#ji
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'class Violation(BaseModel):
    """A rule violation found by Guard."""

    rule: str
    severity: Severity
    file: str
    line: int | None = None
    message: str
    suggestion: str | None = Noneh)j  u}(j  GuardReportj  Kj  }(j  }(j  KSj  K uj  }(j  Kj  Kuuj  }(j  }(j  KSj  Kuj  }(j  KSj  Kuuj  ](}(j  
files_checkedj  K
j  }(j  }(j  KVj  Kuj  }(j  KVj  Kuuj  }(j  }(j  KVj  Kuj  }(j  KVj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'files_checked: inth)j
  u}(j  
violationsj  K
j  }(j  }(j  KWj  Kuj  }(j  KWj  Kuuj  }(j  }(j  KWj  Kuj  }(j  KWj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'9violations: list[Violation] = Field(default_factory=list)h)j
  u}(j  errorsj  K
j  }(j  }(j  KXj  Kuj  }(j  KXj  K
uuj  }(j  }(j  KXj  Kuj  }(j  KXj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'errors: int = 0h)j
  u}(j  warningsj  K
j  }(j  }(j  KYj  Kuj  }(j  KYj  Kuuj  }(j  }(j  KYj  Kuj  }(j  KYj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'warnings: int = 0h)j
  u}(j  infosj  K
j  }(j  }(j  KZj  Kuj  }(j  KZj  K	uuj  }(j  }(j  KZj  Kuj  }(j  KZj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'2infos: int = 0  # Phase 7: Track INFO-level issuesh)j
  u}(j  core_functions_totalj  K
j  }(j  }(j  K\j  Kuj  }(j  K\j  Kuuj  }(j  }(j  K\j  Kuj  }(j  K\j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'core_functions_total: int = 0h)j
  u}(j  core_functions_with_contractsj  K
j  }(j  }(j  K]j  Kuj  }(j  K]j  K!uuj  }(j  }(j  K]j  Kuj  }(j  K]j  K!uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'&core_functions_with_contracts: int = 0h)j
  u}(j  
add_violationj  Kj  }(j  }(j  K_j  Kuj  }(j  Krj  Kuuj  }(j  }(j  K`j  Kuj  }(j  K`j  Kuuj  ]}(j  	violationj  K
j  }(j  }(j  K`j  Kuj  }(j  K`j  K0uuj  }(j  }(j  K`j  Kuj  }(j  K`j  K0uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j1  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'violation: Violation) -> None:h)j&  uah}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j(  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  @pre(lambda self, violation: isinstance(violation, Violation))
    def add_violation(self, violation: Violation) -> None:
        """
        Add a violation and update counts.

        Examples:
            >>> from invar.core.models import Violation, Severity, GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> v = Violation(rule="test", severity=Severity.ERROR, file="x.py", message="err")
            >>> report.add_violation(v)
            >>> report.errors
            1
        """
        self.violations.append(violation)
        if violation.severity == Severity.ERROR:
            self.errors += 1
        elif violation.severity == Severity.WARNING:
            self.warnings += 1
        else:
            self.infos += 1h)j
  u}(j  update_coveragej  Kj  }(j  }(j  Ktj  Kuj  }(j  Kj  K<uuj  }(j  }(j  Kuj  Kuj  }(j  Kuj  Kuuj  ](}(j  totalj  K
j  }(j  }(j  Kuj  Kuj  }(j  Kuj  K(uuj  }(j  }(j  Kuj  Kuj  }(j  Kuj  K(uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jK  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh')total: int, with_contracts: int) -> None:h)j@  u}(j  with_contractsj  K
j  }(j  }(j  Kuj  K*uj  }(j  Kuj  K=uuj  }(j  }(j  Kuj  K*uj  }(j  Kuj  K=uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jX  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'with_contracts: int) -> None:h)j@  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jB  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Xv  @pre(lambda self, total, with_contracts: total >= 0 and with_contracts >= 0)
    def update_coverage(self, total: int, with_contracts: int) -> None:
        """
        Update contract coverage statistics (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.core_functions_total
            10
            >>> report.core_functions_with_contracts
            8
        """
        self.core_functions_total += total
        self.core_functions_with_contracts += with_contractsh)j
  u}(j  contract_coverage_pctj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  KXuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#ji  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X:  @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_coverage_pct(self) -> int:
        """
        Get contract coverage percentage (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.contract_coverage_pct
            80
        """
        if self.core_functions_total == 0:
            return 100
        return int(self.core_functions_with_contracts / self.core_functions_total * 100)h)j
  u}(j  contract_issue_countsj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  countsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Ccounts = {"tautology": 0, "empty": 0, "partial": 0, "type_only": 0}h)jt  u}(j  j  j  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'v in self.violations:h)jt  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jv  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_issue_counts(self) -> dict[str, int]:
        """
        Count contract quality issues by type (P24).

        Examples:
            >>> from invar.core.models import GuardReport, Violation, Severity
            >>> report = GuardReport(files_checked=1)
            >>> v1 = Violation(rule="empty_contract", severity=Severity.WARNING, file="x.py", message="m")
            >>> v2 = Violation(rule="semantic_tautology", severity=Severity.WARNING, file="x.py", message="m")
            >>> report.add_violation(v1)
            >>> report.add_violation(v2)
            >>> report.contract_issue_counts
            {'tautology': 1, 'empty': 1, 'partial': 0, 'type_only': 0}
        """
        counts = {"tautology": 0, "empty": 0, "partial": 0, "type_only": 0}
        for v in self.violations:
            if v.rule == "semantic_tautology":
                counts["tautology"] += 1
            elif v.rule == "empty_contract":
                counts["empty"] += 1
            elif v.rule == "partial_contract":
                counts["partial"] += 1
            elif v.rule == "redundant_type_contract":
                counts["type_only"] += 1
        return countsh)j
  u}(j  passedj  Kj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Xq  @property
    @pre(lambda self: isinstance(self, GuardReport))
    def passed(self) -> bool:
        """
        Check if guard passed (no errors).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.passed
            True
        """
        return self.errors == 0h)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  class GuardReport(BaseModel):
    """Complete Guard report for a project."""

    files_checked: int
    violations: list[Violation] = Field(default_factory=list)
    errors: int = 0
    warnings: int = 0
    infos: int = 0  # Phase 7: Track INFO-level issues
    # P24: Contract coverage statistics (Core files only)
    core_functions_total: int = 0
    core_functions_with_contracts: int = 0

    @pre(lambda self, violation: isinstance(violation, Violation))
    def add_violation(self, violation: Violation) -> None:
        """
        Add a violation and update counts.

        Examples:
            >>> from invar.core.models import Violation, Severity, GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> v = Violation(rule="test", severity=Severity.ERROR, file="x.py", message="err")
            >>> report.add_violation(v)
            >>> report.errors
            1
        """
        self.violations.append(violation)
        if violation.severity == Severity.ERROR:
            self.errors += 1
        elif violation.severity == Severity.WARNING:
            self.warnings += 1
        else:
            self.infos += 1

    @pre(lambda self, total, with_contracts: total >= 0 and with_contracts >= 0)
    def update_coverage(self, total: int, with_contracts: int) -> None:
        """
        Update contract coverage statistics (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.core_functions_total
            10
            >>> report.core_functions_with_contracts
            8
        """
        self.core_functions_total += total
        self.core_functions_with_contracts += with_contracts

    @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_coverage_pct(self) -> int:
        """
        Get contract coverage percentage (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.contract_coverage_pct
            80
        """
        if self.core_functions_total == 0:
            return 100
        return int(self.core_functions_with_contracts / self.core_functions_total * 100)

    @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_issue_counts(self) -> dict[str, int]:
        """
        Count contract quality issues by type (P24).

        Examples:
            >>> from invar.core.models import GuardReport, Violation, Severity
            >>> report = GuardReport(files_checked=1)
            >>> v1 = Violation(rule="empty_contract", severity=Severity.WARNING, file="x.py", message="m")
            >>> v2 = Violation(rule="semantic_tautology", severity=Severity.WARNING, file="x.py", message="m")
            >>> report.add_violation(v1)
            >>> report.add_violation(v2)
            >>> report.contract_issue_counts
            {'tautology': 1, 'empty': 1, 'partial': 0, 'type_only': 0}
        """
        counts = {"tautology": 0, "empty": 0, "partial": 0, "type_only": 0}
        for v in self.violations:
            if v.rule == "semantic_tautology":
                counts["tautology"] += 1
            elif v.rule == "empty_contract":
                counts["empty"] += 1
            elif v.rule == "partial_contract":
                counts["partial"] += 1
            elif v.rule == "redundant_type_contract":
                counts["type_only"] += 1
        return counts

    @property
    @pre(lambda self: isinstance(self, GuardReport))
    def passed(self) -> bool:
        """
        Check if guard passed (no errors).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.passed
            True
        """
        return self.errors == 0h)j  u}(j  
RuleExclusionj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  patternj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'<pattern: str  # Glob pattern (fnmatch style with ** support)h)j  u}(j  rulesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh';rules: list[str]  # Rule names to exclude, or ["*"] for allh)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  class RuleExclusion(BaseModel):
    """
    A rule exclusion pattern for specific files.

    Examples:
        >>> excl = RuleExclusion(pattern="**/generated/**", rules=["*"])
        >>> excl.pattern
        '**/generated/**'
        >>> excl.rules
        ['*']
    """

    pattern: str  # Glob pattern (fnmatch style with ** support)
    rules: list[str]  # Rule names to exclude, or ["*"] for allh)j  u}(j  
RuleConfigj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  K'uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  max_file_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Jmax_file_lines: int = 500  # Phase 9 P1: Raised from 300 for less frictionh)j  u}(j  max_function_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'max_function_lines: int = 50h)j  u}(j  forbidden_importsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'&forbidden_imports: tuple[str, ...] = (h)j  u}(j  require_contractsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'require_contracts: bool = Trueh)j  u}(j  require_doctestsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'require_doctests: bool = Trueh)j  u}(j  strict_purej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Dstrict_pure: bool = True  # Phase 9 P12: Default ON for agent-nativeh)j  u}(j  use_code_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j+  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'use_code_lines: bool = Falseh)j  u}(j  exclude_doctest_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j8  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'#exclude_doctest_lines: bool = Falseh)j  u}(j  rule_exclusionsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jE  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Brule_exclusions: list[RuleExclusion] = Field(default_factory=list)h)j  u}(j  severity_overridesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jR  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Dseverity_overrides: dict[str, str] = Field(default_factory=lambda: {h)j  u}(j  size_warning_thresholdj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j_  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'#size_warning_threshold: float = 0.8h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X$  class RuleConfig(BaseModel):
    """
    Configuration for rule checking.

    Examples:
        >>> config = RuleConfig()
        >>> config.max_file_lines  # Phase 9 P1: Raised from 300
        500
        >>> config.strict_pure  # Phase 9 P12: Default ON for agents
        True
    """

    max_file_lines: int = 500  # Phase 9 P1: Raised from 300 for less friction
    max_function_lines: int = 50
    forbidden_imports: tuple[str, ...] = (
        "os",
        "sys",
        "socket",
        "requests",
        "urllib",
        "subprocess",
        "shutil",
        "io",
        "pathlib",
    )
    require_contracts: bool = True
    require_doctests: bool = True
    strict_pure: bool = True  # Phase 9 P12: Default ON for agent-native
    use_code_lines: bool = False
    exclude_doctest_lines: bool = False
    # Phase 9 P1: Rule exclusions for specific file patterns
    rule_exclusions: list[RuleExclusion] = Field(default_factory=list)
    # Phase 9 P2: Per-rule severity overrides (off, info, warning, error)
    severity_overrides: dict[str, str] = Field(default_factory=lambda: {
        "redundant_type_contract": "off",  # Expected behavior when forcing contracts
    })
    # Phase 9 P8: File size warning threshold (0 to disable, 0.8 = warn at 80%)
    size_warning_threshold: float = 0.8h)j  u}(j  
SymbolRefsj  Kj  }(j  }(j  Kj  K uj  }(j  M
j  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  symbolj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  K
uuj  }(j  }(j  Mj  Kuj  }(j  Mj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jy  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'symbol: Symbolh)jn  u}(j  	file_pathj  K
j  }(j  }(j  M	j  Kuj  }(j  M	j  K
uuj  }(j  }(j  M	j  Kuj  }(j  M	j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'file_path: strh)jn  u}(j  	ref_countj  K
j  }(j  }(j  M
j  Kuj  }(j  M
j  K
uuj  }(j  }(j  M
j  Kuj  }(j  M
j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'ref_count: int = 0h)jn  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#jp  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'X  class SymbolRefs(BaseModel):
    """
    A symbol with its cross-file reference count.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind, SymbolRefs
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> sr = SymbolRefs(symbol=sym, file_path="core/calc.py", ref_count=10)
        >>> sr.ref_count
        10
    """

    symbol: Symbol
    file_path: str
    ref_count: int = 0h)j  u}(j  
PerceptionMapj  Kj  }(j  }(j  M
j  K uj  }(j  Mj  K;uuj  }(j  }(j  M
j  Kuj  }(j  M
j  Kuuj  ](}(j  project_rootj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'project_root: strh)j  u}(j  total_filesj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'total_files: inth)j  u}(j  
total_symbolsj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'total_symbols: inth)j  u}(j  symbolsj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'7symbols: list[SymbolRefs] = Field(default_factory=list)h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/models.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/models.pyh&j  uh'Xc  class PerceptionMap(BaseModel):
    """
    Complete perception map for a project.

    Examples:
        >>> pm = PerceptionMap(project_root="/test", total_files=5, total_symbols=20)
        >>> pm.total_files
        5
    """

    project_root: str
    total_files: int
    total_symbols: int
    symbols: list[SymbolRefs] = Field(default_factory=list)h)j  ueh)j  u}(j  purityj	  j  h#}(j  }(j  K j  K uj  }(j  MRj  K uuj  j  h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&src/invar/core/purity.pyuj  ](}(nameIMPURE_FUNCTIONSkindKrange}(start}(lineK	characterK uend}(j  Kj  KuuselectionRange}(j  }(j  Kj  K uj  }(j  Kj  Kuuchildren]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&src/invar/core/purity.pyuh'IMPURE_FUNCTIONS: set[str] = {h)j  u}(j  IMPURE_PATTERNSj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh')IMPURE_PATTERNS: set[tuple[str, str]] = {h)j  u}(j  extract_internal_importsj  Kj  }(j  }(j  K j  K uj  }(j  K<j  Kuuj  }(j  }(j  K!j  Kuj  }(j  K!j  Kuuj  ](}(j  nodej  K
j  }(j  }(j  K!j  Kuj  }(j  K!j  KIuuj  }(j  }(j  K!j  Kuj  }(j  K!j  KIuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh';node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:h)j
  u}(j  importsj  K
j  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j)
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'imports: list[str] = []h)j
  u}(j  childj  K
j  }(j  }(j  K4j  Kuj  }(j  K4j  K
uuj  }(j  }(j  K4j  Kuj  }(j  K4j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j6
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'child in ast.walk(node):h)j
  u}(j  aliasj  K
j  }(j  }(j  K6j  Kuj  }(j  K6j  Kuuj  }(j  }(j  K6j  Kuj  }(j  K6j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jC
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'alias in child.names:h)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def extract_internal_imports(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:
    """
    Extract imports inside a function body.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     import os
        ...     from pathlib import Path
        ...     return Path(".")
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> sorted(extract_internal_imports(func))
        ['os', 'pathlib']
    """
    imports: list[str] = []

    for child in ast.walk(node):
        if isinstance(child, ast.Import):
            for alias in child.names:
                imports.append(alias.name.split(".")[0])
        elif isinstance(child, ast.ImportFrom):
            if child.module:
                imports.append(child.module.split(".")[0])

    return list(set(imports))h)j  u}(j  extract_impure_callsj  Kj  }(j  }(j  K?j  K uj  }(j  KYj  Kuuj  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj  ](}(j  nodej  K
j  }(j  }(j  K@j  Kuj  }(j  K@j  KEuuj  }(j  }(j  K@j  Kuj  }(j  K@j  KEuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j]
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh';node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:h)jR
  u}(j  impurej  K
j  }(j  }(j  KQj  Kuj  }(j  KQj  K
uuj  }(j  }(j  KQj  Kuj  }(j  KQj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jj
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'impure: list[str] = []h)jR
  u}(j  childj  K
j  }(j  }(j  KSj  Kuj  }(j  KSj  K
uuj  }(j  }(j  KSj  Kuj  }(j  KSj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jw
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'child in ast.walk(node):h)jR
  u}(j  	call_namej  K
j  }(j  }(j  KUj  Kuj  }(j  KUj  Kuuj  }(j  }(j  KUj  Kuj  }(j  KUj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'!call_name = _get_call_name(child)h)jR
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jT
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'XC  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def extract_impure_calls(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:
    """
    Extract calls to known impure functions.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     x = datetime.now()
        ...     print("hello")
        ...     return x
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> sorted(extract_impure_calls(func))
        ['datetime.now', 'print']
    """
    impure: list[str] = []

    for child in ast.walk(node):
        if isinstance(child, ast.Call):
            call_name = _get_call_name(child)
            if call_name and _is_impure_call(call_name):
                impure.append(call_name)

    return list(set(impure))h)j  u}(j  extract_function_callsj  Kj  }(j  }(j  K\j  K uj  }(j  Kj  Kuuj  }(j  }(j  K]j  Kuj  }(j  K]j  Kuuj  ](}(j  nodej  K
j  }(j  }(j  K]j  Kuj  }(j  K]j  KGuuj  }(j  }(j  K]j  Kuj  }(j  K]j  KGuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh';node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:h)j
  u}(j  callsj  K
j  }(j  }(j  K|j  Kuj  }(j  K|j  K	uuj  }(j  }(j  K|j  Kuj  }(j  K|j  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'calls: list[str] = []h)j
  u}(j  childj  K
j  }(j  }(j  K~j  Kuj  }(j  K~j  K
uuj  }(j  }(j  K~j  Kuj  }(j  K~j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'child in ast.walk(node):h)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'X5  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def extract_function_calls(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:
    """
    Extract all function calls from a function body (P25: for extraction analysis).

    Only extracts simple function calls (not method calls on objects).
    Used to build call graph for grouping related functions.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     helper()
        ...     result = calculate(x)
        ...     return result
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> sorted(extract_function_calls(func))
        ['calculate', 'helper']
        >>> # Method calls are excluded
        >>> code2 = '''
        ... def bar():
        ...     self.method()
        ...     obj.call()
        ...     helper()
        ... '''
        >>> tree2 = ast.parse(code2)
        >>> func2 = tree2.body[0]
        >>> extract_function_calls(func2)
        ['helper']
    """
    calls: list[str] = []

    for child in ast.walk(node):
        if isinstance(child, ast.Call):
            # Only simple function calls (not x.method())
            if isinstance(child.func, ast.Name):
                calls.append(child.func.id)

    return list(set(calls))h)j  u}(j  _get_call_namej  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  callj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K!uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K!uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'call: ast.Call) -> str | None:h)j
  u}(j  funcj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'func = call.funch)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'X  @pre(lambda call: isinstance(call, ast.Call))
def _get_call_name(call: ast.Call) -> str | None:
    """Get the name of a function call as a string."""
    func = call.func

    # Simple name: print(), open()
    if isinstance(func, ast.Name):
        return func.id

    # Attribute: datetime.now(), random.randint()
    if isinstance(func, ast.Attribute):
        if isinstance(func.value, ast.Name):
            return f"{func.value.id}.{func.attr}"

    return Noneh)j  u}(j  _is_impure_callj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  	call_namej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K"uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K"uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'call_name: str) -> bool:h)j
  u}(j  partsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'parts = call_name.split(".")h)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'X  @pre(lambda call_name: isinstance(call_name, str) and len(call_name) > 0)
def _is_impure_call(call_name: str) -> bool:
    """Check if a call name represents an impure function."""
    # Check simple names
    if call_name in IMPURE_FUNCTIONS:
        return True

    # Check patterns like datetime.now
    if "." in call_name:
        parts = call_name.split(".")
        if len(parts) == 2 and (parts[0], parts[1]) in IMPURE_PATTERNS:
            return True

    return Falseh)j  u}(j  count_code_linesj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  K(uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  KAuuj  }(j  }(j  Kj  Kuj  }(j  Kj  KAuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j   h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'5node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:h)j  u}(j  total_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j-  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'@total_lines = (node.end_lineno or node.lineno) - node.lineno + 1h)j  u}(j  docstring_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j:  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'docstring_lines = 0h)j  u}(j  docstring_nodej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jG  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'docstring_node = node.body[0]h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'X{  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def count_code_lines(node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:
    """
    Count lines of code excluding docstring.

    The total function lines minus docstring lines gives the actual code lines.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     \"\"\"This is a docstring.\"\"\"
        ...     x = 1
        ...     return x
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> count_code_lines(func)
        3
    """
    total_lines = (node.end_lineno or node.lineno) - node.lineno + 1

    # Check for docstring
    docstring_lines = 0
    if (
        node.body
        and isinstance(node.body[0], ast.Expr)
        and isinstance(node.body[0].value, ast.Constant)
        and isinstance(node.body[0].value.value, str)
    ):
        docstring_node = node.body[0]
        docstring_lines = (
            (docstring_node.end_lineno or docstring_node.lineno)
            - docstring_node.lineno
            + 1
        )

    return total_lines - docstring_linesh)j  u}(j  count_doctest_linesj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  KDuuj  }(j  }(j  Kj  Kuj  }(j  Kj  KDuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#ja  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'5node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:h)jV  u}(j  	docstringj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jn  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'#docstring = ast.get_docstring(node)h)jV  u}(     j  countj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j{  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'	count = 0h)jV  u}(j  
in_doctestj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'in_doctest = Falseh)jV  u}(j  linej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'line in docstring.split("\n"):h)jV  u}(j  strippedj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'stripped = line.strip()h)jV  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#jX  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'Xd  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def count_doctest_lines(node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:
    """
    Count lines that are doctest examples in the docstring.

    Counts both `>>> ` input lines and their expected output lines.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     \"\"\"Example.
        ...
        ...     Examples:
        ...         >>> foo()
        ...         42
        ...         >>> foo() + 1
        ...         43
        ...     \"\"\"
        ...     return 42
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> count_doctest_lines(func)
        4
    """
    docstring = ast.get_docstring(node)
    if not docstring:
        return 0

    count = 0
    in_doctest = False
    for line in docstring.split("\n"):
        stripped = line.strip()
        if stripped.startswith(">>> "):
            count += 1
            in_doctest = True
        elif stripped.startswith("... "):
            count += 1  # Continuation line
        elif in_doctest and stripped and not stripped.startswith(">>>"):
            count += 1  # Expected output line
            if not stripped:  # Empty line ends output
                in_doctest = False
        else:
            in_doctest = False
    return counth)j  u}(j  check_internal_importsj  Kj  }(j  }(j  Mj  K uj  }(j  M(j  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ](}(j  	file_infoj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  K.uuj  }(j  }(j  Mj  Kuj  }(j  Mj  K.uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(j  configj  K
j  }(j  }(j  Mj  K0uj  }(j  Mj  KBuuj  }(j  }(j  Mj  K0uj  }(j  Mj  KBuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh''config: RuleConfig) -> list[Violation]:h)j  u}(j  
violationsj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh' violations: list[Violation] = []h)j  u}(j  symbolj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'symbol in file_info.symbols:h)j  u}(j  	kind_namej  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_internal_imports(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check for imports inside function bodies.

    Only applies to Core files when strict_pure is enabled.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, RuleConfig
        >>> sym = Symbol(
        ...     name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     internal_imports=["os"]
        ... )
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> violations = check_internal_imports(info, RuleConfig(strict_pure=True))
        >>> len(violations)
        1
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.strict_pure:
        return violations

    for symbol in file_info.symbols:
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD) and symbol.internal_imports:
            kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
            violations.append(
                Violation(
                    rule="internal_import",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"{kind_name} '{symbol.name}' has internal imports: {', '.join(symbol.internal_imports)}",
                    suggestion="Move imports to top of file or move function to Shell",
                )
            )

    return violationsh)j  u}(j  check_impure_callsj  Kj  }(j  }(j  M+j  K uj  }(j  MPj  Kuuj  }(j  }(j  M,j  Kuj  }(j  M,j  Kuuj  ](}(j  	file_infoj  K
j  }(j  }(j  M,j  Kuj  }(j  M,j  K*uuj  }(j  }(j  M,j  Kuj  }(j  M,j  K*uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j
  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(j  configj  K
j  }(j  }(j  M,j  K,uj  }(j  M,j  K>uuj  }(j  }(j  M,j  K,uj  }(j  M,j  K>uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh''config: RuleConfig) -> list[Violation]:h)j  u}(j  
violationsj  K
j  }(j  }(j  M=j  Kuj  }(j  M=j  Kuuj  }(j  }(j  M=j  Kuj  }(j  M=j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j$  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh' violations: list[Violation] = []h)j  u}(j  symbolj  K
j  }(j  }(j  MBj  Kuj  }(j  MBj  Kuuj  }(j  }(j  MBj  Kuj  }(j  MBj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j1  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'symbol in file_info.symbols:h)j  u}(j  	kind_namej  K
j  }(j  }(j  MDj  Kuj  }(j  MDj  Kuuj  }(j  }(j  MDj  Kuj  }(j  MDj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j>  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/purity.pyh&j
  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_impure_calls(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check for calls to known impure functions.

    Only applies to Core files when strict_pure is enabled.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, RuleConfig
        >>> sym = Symbol(
        ...     name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     impure_calls=["datetime.now", "print"]
        ... )
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> violations = check_impure_calls(info, RuleConfig(strict_pure=True))
        >>> len(violations)
        1
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.strict_pure:
        return violations

    for symbol in file_info.symbols:
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD) and symbol.impure_calls:
            kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
            violations.append(
                Violation(
                    rule="impure_call",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"{kind_name} '{symbol.name}' calls impure functions: {', '.join(symbol.impure_calls)}",
                    suggestion="Inject dependencies or move function to Shell",
                )
            )

    return violationsh)j  ueh)j  u}(j  
referencesj	  j  h#}(j  }(j  K j  K uj  }(j  Kj  K uuj  jO  h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jO  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&src/invar/core/references.pyuj  ](}(namefind_references_in_sourcekindKrange}(start}(lineK	characterK uend}(j_  K4j`  KuuselectionRange}(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuuchildren](}(jX  sourcejZ  K
j[  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujc  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jk  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&src/invar/core/references.pyuh'$source: str, known_symbols: set[str]h)jW  u}(jX  
known_symbolsjZ  K
j[  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  K(uujc  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  K(uujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jy  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'known_symbols: set[str]h)jW  u}(jX  treejZ  K
j[  }(j]  }(j_  K&j`  Kuja  }(j_  K&j`  Kuujc  }(j]  }(j_  K&j`  Kuja  }(j_  K&j`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'tree = ast.parse(source)h)jW  u}(jX  seenjZ  K
j[  }(j]  }(j_  K*j`  Kuja  }(j_  K*j`  Kuujc  }(j]  }(j_  K*j`  Kuja  }(j_  K*j`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'"seen: set[tuple[str, int]] = set()h)jW  u}(jX  nodejZ  K
j[  }(j]  }(j_  K,j`  Kuja  }(j_  K,j`  Kuujc  }(j]  }(j_  K,j`  Kuja  }(j_  K,j`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'node in ast.walk(tree):h)jW  u}(jX  namejZ  K
j[  }(j]  }(j_  K/j`  Kuja  }(j_  K/j`  Kuujc  }(j]  }(j_  K/j`  Kuja  }(j_  K/j`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'name = node.func.idh)jW  u}(jX  linejZ  K
j[  }(j]  }(j_  K1j`  Kuja  }(j_  K1j`  Kuujc  }(j]  }(j_  K1j`  Kuja  }(j_  K1j`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'!line = getattr(node, "lineno", 0)h)jW  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j\  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'XA  @pre(lambda source, known_symbols: isinstance(source, str))
@post(lambda result: isinstance(result, list))
def find_references_in_source(
    source: str, known_symbols: set[str]
) -> list[tuple[str, int]]:
    """
    Find references to known symbols in source code.

    Returns list of (symbol_name, line_number) for each reference found.
    Deduplicates: each (symbol, line) pair counted once.

    Examples:
        >>> refs = find_references_in_source("x = foo()\\nbar(x)", {"foo", "bar"})
        >>> sorted(refs)
        [('bar', 2), ('foo', 1)]
        >>> find_references_in_source("x = unknown()", {"foo"})
        []
    """
    try:
        tree = ast.parse(source)
    except SyntaxError:
        return []

    seen: set[tuple[str, int]] = set()

    for node in ast.walk(tree):
        # Count function calls: foo()
        if isinstance(node, ast.Call) and isinstance(node.func, ast.Name):
            name = node.func.id
            if name in known_symbols:
                line = getattr(node, "lineno", 0)
                seen.add((name, line))

    return list(seen)h)jM  u}(jX  build_symbol_tablejZ  Kj[  }(j]  }(j_  K7j`  K uja  }(j_  KOj`  Kuujc  }(j]  }(j_  K9j`  Kuja  }(j_  K9j`  Kuujg  ](}(jX  
file_infosjZ  K
j[  }(j]  }(j_  K9j`  Kuja  }(j_  K9j`  K1uujc  }(j]  }(j_  K9j`  Kuja  }(j_  K9j`  K1uujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'.file_infos: list[FileInfo]) -> dict[str, str]:h)j  u}(jX  symbol_tablejZ  K
j[  }(j]  }(j_  KGj`  Kuja  }(j_  KGj`  Kuujc  }(j]  }(j_  KGj`  Kuja  }(j_  KGj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'!symbol_table: dict[str, str] = {}h)j  u}(jX  	file_infojZ  K
j[  }(j]  }(j_  KIj`  Kuja  }(j_  KIj`  Kuujc  }(j]  }(j_  KIj`  Kuja  }(j_  KIj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'file_info in file_infos:h)j  u}(jX  symboljZ  K
j[  }(j]  }(j_  KJj`  Kuja  }(j_  KJj`  Kuujc  }(j]  }(j_  KJj`  Kuja  }(j_  KJj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'symbol in file_info.symbols:h)j  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'X  @pre(lambda file_infos: isinstance(file_infos, list))
@post(lambda result: isinstance(result, dict))
def build_symbol_table(file_infos: list[FileInfo]) -> dict[str, str]:
    """
    Build a mapping of symbol names to their defining file.

    Returns dict of {symbol_name: file_path}.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym])
        >>> table = build_symbol_table([info])
        >>> table["foo"]
        'core/calc.py'
    """
    symbol_table: dict[str, str] = {}

    for file_info in file_infos:
        for symbol in file_info.symbols:
            if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.CLASS):
                # Use simple name (may have collisions, that's OK for now)
                symbol_table[symbol.name] = file_info.path

    return symbol_tableh)jM  u}(jX  count_cross_file_referencesjZ  Kj[  }(j]  }(j_  KRj`  K uja  }(j_  K{j`  Kuujc  }(j]  }(j_  KSj`  Kuja  }(j_  KSj`  Kuujg  ](}(jX  
file_infosjZ  K
j[  }(j]  }(j_  KTj`  Kuja  }(j_  KTj`  Kuujc  }(j]  }(j_  KTj`  Kuja  }(j_  KTj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'3file_infos: list[FileInfo], sources: dict[str, str]h)j
  u}(jX  sourcesjZ  K
j[  }(j]  }(j_  KTj`  K uja  }(j_  KTj`  K7uujc  }(j]  }(j_  KTj`  K uja  }(j_  KTj`  K7uujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j"  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'sources: dict[str, str]h)j
  u}(jX  symbol_tablejZ  K
j[  }(j]  }(j_  Kgj`  Kuja  }(j_  Kgj`  Kuujc  }(j]  }(j_  Kgj`  Kuja  }(j_  Kgj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j/  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'-symbol_table = build_symbol_table(file_infos)h)j
  u}(jX  
known_symbolsjZ  K
j[  }(j]  }(j_  Khj`  Kuja  }(j_  Khj`  Kuujc  }(j]  }(j_  Khj`  Kuja  }(j_  Khj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j<  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'(known_symbols = set(symbol_table.keys())h)j
  u}(jX  
ref_countsjZ  K
j[  }(j]  }(j_  Kkj`  Kuja  }(j_  Kkj`  Kuujc  }(j]  }(j_  Kkj`  Kuja  }(j_  Kkj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jI  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'-ref_counts: dict[str, int] = defaultdict(int)h)j
  u}(jX  	file_infojZ  K
j[  }(j]  }(j_  Kmj`  Kuja  }(j_  Kmj`  Kuujc  }(j]  }(j_  Kmj`  Kuja  }(j_  Kmj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jV  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'file_info in file_infos:h)j
  u}(jX  sourcejZ  K
j[  }(j]  }(j_  Knj`  Kuja  }(j_  Knj`  Kuujc  }(j]  }(j_  Knj`  Kuja  }(j_  Knj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jc  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'(source = sources.get(file_info.path, "")h)j
  u}(jX  
referencesjZ  K
j[  }(j]  }(j_  Krj`  Kuja  }(j_  Krj`  Kuujc  }(j]  }(j_  Krj`  Kuja  }(j_  Krj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#jp  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'=references = find_references_in_source(source, known_symbols)h)j
  u}(jX  symbol_namejZ  K
j[  }(j]  }(j_  Ktj`  Kuja  }(j_  Ktj`  Kuujc  }(j]  }(j_  Ktj`  Kuja  }(j_  Ktj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j}  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'symbol_name, _ in references:h)j
  u}(jX  
defining_filejZ  K
j[  }(j]  }(j_  Kuj`  Kuja  }(j_  Kuj`  Kuujc  }(j]  }(j_  Kuj`  Kuja  }(j_  Kuj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'-defining_file = symbol_table.get(symbol_name)h)j
  u}(jX  keyjZ  K
j[  }(j]  }(j_  Kxj`  Kuja  }(j_  Kxj`  Kuujc  }(j]  }(j_  Kxj`  Kuja  }(j_  Kxj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh''key = f"{defining_file}::{symbol_name}"h)j
  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'XW  @pre(lambda file_infos, sources: isinstance(file_infos, list))
def count_cross_file_references(
    file_infos: list[FileInfo], sources: dict[str, str]
) -> dict[str, int]:
    """
    Count cross-file references for all symbols.

    Returns dict of {"file::symbol": reference_count}.
    Only counts references from OTHER files (excludes self-references).

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> info = FileInfo(path="a.py", lines=10, symbols=[sym])
        >>> sources = {"a.py": "def foo(): pass", "b.py": "foo()"}
        >>> info2 = FileInfo(path="b.py", lines=5, symbols=[])
        >>> refs = count_cross_file_references([info, info2], sources)
        >>> refs.get("a.py::foo", 0)
        1
    """
    # Build symbol table: name -> defining file
    symbol_table = build_symbol_table(file_infos)
    known_symbols = set(symbol_table.keys())

    # Count references from each file
    ref_counts: dict[str, int] = defaultdict(int)

    for file_info in file_infos:
        source = sources.get(file_info.path, "")
        if not source:
            continue

        references = find_references_in_source(source, known_symbols)

        for symbol_name, _ in references:
            defining_file = symbol_table.get(symbol_name)
            if defining_file and defining_file != file_info.path:
                # Cross-file reference: increment count
                key = f"{defining_file}::{symbol_name}"
                ref_counts[key] += 1

    return dict(ref_counts)h)jM  u}(jX  build_perception_mapjZ  Kj[  }(j]  }(j_  K~j`  K uja  }(j_  Kj`  Kuujc  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujg  ](}(jX  
file_infosjZ  K
j[  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujc  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'Ffile_infos: list[FileInfo], sources: dict[str, str], project_root: strh)j  u}(jX  sourcesjZ  K
j[  }(j]  }(j_  Kj`  K uja  }(j_  Kj`  K7uujc  }(j]  }(j_  Kj`  K uja  }(j_  Kj`  K7uujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'*sources: dict[str, str], project_root: strh)j  u}(jX  project_rootjZ  K
j[  }(j]  }(j_  Kj`  K9uja  }(j_  Kj`  KJuujc  }(j]  }(j_  Kj`  K9uja  }(j_  Kj`  KJuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'project_root: strh)j  u}(jX  
ref_countsjZ  K
j[  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujc  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'=ref_counts = count_cross_file_references(file_infos, sources)h)j  u}(jX  symbol_refsjZ  K
j[  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujc  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'"symbol_refs: list[SymbolRefs] = []h)j  u}(jX  
total_symbolsjZ  K
j[  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujc  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'total_symbols = 0h)j  u}(jX  	file_infojZ  K
j[  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujc  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'file_info in file_infos:h)j  u}(jX  symboljZ  K
j[  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujc  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'symbol in file_info.symbols:h)j  u}(jX  keyjZ  K
j[  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujc  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'(key = f"{file_info.path}::{symbol.name}"h)j  u}(jX  countjZ  K
j[  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujc  }(j]  }(j_  Kj`  Kuja  }(j_  Kj`  Kuujg  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j&  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'count = ref_counts.get(key, 0)h)j  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/references.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/references.pyh&ju  uh'X2  @pre(lambda file_infos, sources, project_root: isinstance(file_infos, list))
def build_perception_map(
    file_infos: list[FileInfo], sources: dict[str, str], project_root: str
) -> PerceptionMap:
    """
    Build complete perception map with reference counts.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> info = FileInfo(path="a.py", lines=10, symbols=[sym])
        >>> pm = build_perception_map([info], {"a.py": "def foo(): pass"}, "/test")
        >>> pm.total_symbols
        1
    """
    ref_counts = count_cross_file_references(file_infos, sources)

    # Build SymbolRefs list
    symbol_refs: list[SymbolRefs] = []
    total_symbols = 0

    for file_info in file_infos:
        for symbol in file_info.symbols:
            if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.CLASS):
                key = f"{file_info.path}::{symbol.name}"
                count = ref_counts.get(key, 0)
                symbol_refs.append(
                    SymbolRefs(
                        symbol=symbol,
                        file_path=file_info.path,
                        ref_count=count,
                    )
                )
                total_symbols += 1

    # Sort by reference count (descending)
    symbol_refs.sort(key=lambda sr: sr.ref_count, reverse=True)

    return PerceptionMap(
        project_root=project_root,
        total_files=len(file_infos),
        total_symbols=total_symbols,
        symbols=symbol_refs,
    )h)jM  ueh)j  u}(j  __init__j	  j  h#}(j  }(j  K j  K uj  }(j  K	j  K uuj  j7  h}(h!<file:///Users/tefx/Projects/Invar/src/invar/core/__init__.pyh#j7  h$5/Users/tefx/Projects/Invar/src/invar/core/__init__.pyh&src/invar/core/__init__.pyuj  ]h)j  u}(j  rulesj	  j  h#}(j  }(j  K j  K uj  }(j  Mj  K uuj  jA  h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jA  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&src/invar/core/rules.pyuj  ](}(nameFORBIDDEN_IMPORT_ALTERNATIVESkindKrange}(start}(lineK	characterK uend}(jQ  KjR  KuuselectionRange}(jO  }(jQ  KjR  K ujS  }(jQ  KjR  Kuuchildren]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jN  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&src/invar/core/rules.pyuh'1FORBIDDEN_IMPORT_ALTERNATIVES: dict[str, str] = {h)j?  u}(jJ  RuleFuncjL  K
jM  }(jO  }(jQ  KjR  K ujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  K ujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jb  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'<RuleFunc = Callable[[FileInfo, RuleConfig], list[Violation]]h)j?  u}(jJ  check_file_sizejL  KjM  }(jO  }(jQ  K jR  K ujS  }(jQ  KbjR  KuujU  }(jO  }(jQ  K!jR  KujS  }(jQ  K!jR  KuujY  ](}(jJ  	file_infojL  K
jM  }(jO  }(jQ  K!jR  KujS  }(jQ  K!jR  K'uujU  }(jO  }(jQ  K!jR  KujS  }(jQ  K!jR  K'uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jx  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)jm  u}(jJ  configjL  K
jM  }(jO  }(jQ  K!jR  K)ujS  }(jQ  K!jR  K;uujU  }(jO  }(jQ  K!jR  K)ujS  }(jQ  K!jR  K;uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh''config: RuleConfig) -> list[Violation]:h)jm  u}(jJ  
violationsjL  K
jM  }(jO  }(jQ  K3jR  KujS  }(jQ  K3jR  KuujU  }(jO  }(jQ  K3jR  KujS  }(jQ  K3jR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh' violations: list[Violation] = []h)jm  u}(jJ  funcsjL  K
jM  }(jO  }(jQ  K5jR  KujS  }(jQ  K5jR  K	uujU  }(jO  }(jQ  K5jR  KujS  }(jQ  K5jR  K	uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'Lfuncs = sorted([(s.name, s.end_line - s.line + 1) for s in file_info.symbolsh)jm  u}(jJ  	func_hintjL  K
jM  }(jO  }(jQ  K8jR  KujS  }(jQ  K8jR  K
uujU  }(jO  }(jQ  K8jR  KujS  }(jQ  K8jR  K
uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'Yfunc_hint = f" Functions: {', '.join(f'{n}({sz}L)' for n, sz in funcs)}" if funcs else ""h)jm  u}(jJ  extraction_hintjL  K
jM  }(jO  }(jQ  K;jR  KujS  }(jQ  K;jR  KuujU  }(jO  }(jQ  K;jR  KujS  }(jQ  K;jR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'3extraction_hint = format_extraction_hint(file_info)h)jm  u}(jJ  
suggestionjL  K
jM  }(jO  }(jQ  K>jR  KujS  }(jQ  K>jR  KuujU  }(jO  }(jQ  K>jR  KujS  }(jQ  K>jR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'*suggestion = "Split into smaller modules."h)jm  u}(jJ  threshold_linesjL  K
jM  }(jO  }(jQ  KOjR  KujS  }(jQ  KOjR  KuujU  }(jO  }(jQ  KOjR  KujS  }(jQ  KOjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'Lthreshold_lines = int(config.max_file_lines * config.size_warning_threshold)h)jm  u}(jJ  pctjL  K
jM  }(jO  }(jQ  KQjR  KujS  }(jQ  KQjR  KuujU  }(jO  }(jQ  KQjR  KujS  }(jQ  KQjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'8pct = int(file_info.lines / config.max_file_lines * 100)h)jm  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jo  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_file_size(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check if file exceeds maximum line count or warning threshold.

    P18: Shows function groups in size warnings to help agents decide what to extract.
    P25: Shows extractable groups with dependencies for warnings.

    Examples:
        >>> from invar.core.models import FileInfo, RuleConfig
        >>> check_file_size(FileInfo(path="ok.py", lines=100), RuleConfig())
        []
        >>> len(check_file_size(FileInfo(path="big.py", lines=600), RuleConfig()))
        1
        >>> # P8: Warning at 80% threshold (400 lines when max is 500)
        >>> vs = check_file_size(FileInfo(path="growing.py", lines=420), RuleConfig())
        >>> len(vs) == 1 and vs[0].rule == "file_size_warning"
        True
    """
    violations: list[Violation] = []
    # P18: Show top 5 largest functions in size warnings
    funcs = sorted([(s.name, s.end_line - s.line + 1) for s in file_info.symbols
                    if s.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD)],
                   key=lambda x: -x[1])[:5]
    func_hint = f" Functions: {', '.join(f'{n}({sz}L)' for n, sz in funcs)}" if funcs else ""

    # P25: Get extractable groups with dependencies
    extraction_hint = format_extraction_hint(file_info)

    if file_info.lines > config.max_file_lines:
        suggestion = "Split into smaller modules."
        if extraction_hint:
            suggestion += f"\nExtractable groups:\n{extraction_hint}"
        elif func_hint:
            suggestion += func_hint
        violations.append(
            Violation(
                rule="file_size",
                severity=Severity.ERROR,
                file=file_info.path,
                line=None,
                message=f"File has {file_info.lines} lines (max: {config.max_file_lines})",
                suggestion=suggestion,
            )
        )
    # Phase 9 P8: Warning at configurable threshold (default 80%)
    elif config.size_warning_threshold > 0:
        threshold_lines = int(config.max_file_lines * config.size_warning_threshold)
        if file_info.lines >= threshold_lines:
            pct = int(file_info.lines / config.max_file_lines * 100)
            suggestion = "Consider splitting before reaching limit."
            if extraction_hint:
                suggestion += f"\nExtractable groups:\n{extraction_hint}"
            elif func_hint:
                suggestion += func_hint
            violations.append(
                Violation(
                    rule="file_size_warning",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=None,
                    message=f"File has {file_info.lines} lines ({pct}% of {config.max_file_lines} limit)",
                    suggestion=suggestion,
                )
            )

    return violationsh)j?  u}(jJ  check_function_sizejL  KjM  }(jO  }(jQ  KejR  K ujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KfjR  KujS  }(jQ  KfjR  KuujY  ](}(jJ  	file_infojL  K
jM  }(jO  }(jQ  KfjR  KujS  }(jQ  KfjR  K+uujU  }(jO  }(jQ  KfjR  KujS  }(jQ  KfjR  K+uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(jJ  configjL  K
jM  }(jO  }(jQ  KfjR  K-ujS  }(jQ  KfjR  K?uujU  }(jO  }(jQ  KfjR  K-ujS  }(jQ  KfjR  K?uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh''config: RuleConfig) -> list[Violation]:h)j  u}(jJ  
violationsjL  K
jM  }(jO  }(jQ  KujR  KujS  }(jQ  KujR  KuujU  }(jO  }(jQ  KujR  KujS  }(jQ  KujR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh' violations: list[Violation] = []h)j  u}(jJ  symboljL  K
jM  }(jO  }(jQ  KwjR  KujS  }(jQ  KwjR  KuujU  }(jO  }(jQ  KwjR  KujS  }(jQ  KwjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j!  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'symbol in file_info.symbols:h)j  u}(jJ  total_linesjL  K
jM  }(jO  }(jQ  KyjR  KujS  }(jQ  KyjR  KuujU  }(jO  }(jQ  KyjR  KujS  }(jQ  KyjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j.  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'/total_lines = symbol.end_line - symbol.line + 1h)j  u}(jJ  
func_linesjL  K
jM  }(jO  }(jQ  K|jR  KujS  }(jQ  K|jR  KuujU  }(jO  }(jQ  K|jR  KujS  }(jQ  K|jR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j;  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'func_lines = symbol.code_linesh)j  u}(jJ  	line_typejL  K
jM  }(jO  }(jQ  K}jR  KujS  }(jQ  K}jR  KuujU  }(jO  }(jQ  K}jR  KujS  }(jQ  K}jR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jH  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'line_type = "code lines"h)j  u}(jJ  	code_onlyjL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jU  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'.code_only = total_lines - symbol.doctest_linesh)j  u}(jJ  	breakdownjL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jb  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'Cbreakdown = f" ({code_only} code + {symbol.doctest_lines} doctest)"h)j  u}(jJ  
suggestionjL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jo  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'Ksuggestion = f"Extract helper or set exclude_doctest_lines=true{breakdown}"h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'X	  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_function_size(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check if any function exceeds maximum line count.

    When use_code_lines is True, uses code_lines (excluding docstring).
    When exclude_doctest_lines is True, subtracts doctest lines from count.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=10)
        >>> info = FileInfo(path="test.py", lines=20, symbols=[sym])
        >>> cfg = RuleConfig(max_function_lines=50)
        >>> check_function_size(info, cfg)
        []
    """
    violations: list[Violation] = []

    for symbol in file_info.symbols:
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            total_lines = symbol.end_line - symbol.line + 1
            # Calculate effective line count based on config
            if config.use_code_lines and symbol.code_lines is not None:
                func_lines = symbol.code_lines
                line_type = "code lines"
            else:
                func_lines = total_lines
                line_type = "lines"
            # Optionally exclude doctest lines
            if config.exclude_doctest_lines and symbol.doctest_lines > 0:
                func_lines -= symbol.doctest_lines
                line_type = f"{line_type} (excl. doctest)"

            if func_lines > config.max_function_lines:
                # P19: Show breakdown if doctest lines exist
                if symbol.doctest_lines > 0 and not config.exclude_doctest_lines:
                    code_only = total_lines - symbol.doctest_lines
                    breakdown = f" ({code_only} code + {symbol.doctest_lines} doctest)"
                    suggestion = f"Extract helper or set exclude_doctest_lines=true{breakdown}"
                else:
                    suggestion = "Extract helper functions"
                violations.append(
                    Violation(
                        rule="function_size",
                        severity=Severity.WARNING,
                        file=file_info.path,
                        line=symbol.line,
                        message=f"Function '{symbol.name}' has {func_lines} {line_type} (max: {config.max_function_lines})",
                        suggestion=suggestion,
                    )
                )

    return violationsh)j?  u}(jJ  check_forbidden_importsjL  KjM  }(jO  }(jQ  KjR  K ujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ](}(jJ  	file_infojL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  K/uujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  K/uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j~  u}(jJ  configjL  K
jM  }(jO  }(jQ  KjR  K1ujS  }(jQ  KjR  KCuujU  }(jO  }(jQ  KjR  K1ujS  }(jQ  KjR  KCuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh''config: RuleConfig) -> list[Violation]:h)j~  u}(jJ  
violationsjL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh' violations: list[Violation] = []h)j~  u}(jJ  impjL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'imp in file_info.imports:h)j~  u}(jJ  altjL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'0alt = FORBIDDEN_IMPORT_ALTERNATIVES.get(imp, "")h)j~  u}(jJ  
suggestionjL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'4suggestion = f"Move I/O code using '{imp}' to Shell"h)j~  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_forbidden_imports(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check for forbidden imports in Core files.

    Only applies to files marked as Core.

    Examples:
        >>> from invar.core.models import FileInfo
        >>> info = FileInfo(path="core/calc.py", lines=10, imports=["math"], is_core=True)
        >>> cfg = RuleConfig()
        >>> check_forbidden_imports(info, cfg)
        []
        >>> info = FileInfo(path="core/bad.py", lines=10, imports=["os"], is_core=True)
        >>> violations = check_forbidden_imports(info, cfg)
        >>> len(violations)
        1
    """
    violations: list[Violation] = []

    if not file_info.is_core:
        return violations

    for imp in file_info.imports:
        if imp in config.forbidden_imports:
            # P17: Include pure alternative in suggestion
            alt = FORBIDDEN_IMPORT_ALTERNATIVES.get(imp, "")
            suggestion = f"Move I/O code using '{imp}' to Shell"
            if alt:
                suggestion += f". Alternative: {alt}"
            violations.append(
                Violation(
                    rule="forbidden_import",
                    severity=Severity.ERROR,
                    file=file_info.path,
                    line=None,
                    message=f"Imports '{imp}' (forbidden in Core)",
                    suggestion=suggestion,
                )
            )

    return violationsh)j?  u}(jJ  check_contractsjL  KjM  }(jO  }(jQ  KjR  K ujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ](}(jJ  	file_infojL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  K'uujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  K'uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(jJ  configjL  K
jM  }(jO  }(jQ  KjR  K)ujS  }(jQ  KjR  K;uujU  }(jO  }(jQ  KjR  K)ujS  }(jQ  KjR  K;uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh''config: RuleConfig) -> list[Violation]:h)j  u}(jJ  
violationsjL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh' violations: list[Violation] = []h)j  u}(jJ  symboljL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'symbol in file_info.symbols:h)j  u}(jJ  	kind_namejL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j  u}(jJ  
suggestionjL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j%  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'Hsuggestion = format_suggestion_for_violation(symbol, "missing_contract")h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_contracts(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check that public Core functions have contracts.

    Only applies to files marked as Core when require_contracts is True.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract
        >>> contract = Contract(kind="pre", expression="x > 0", line=1)
        >>> sym = Symbol(name="calc", kind=SymbolKind.FUNCTION, line=1, end_line=5, contracts=[contract])
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> cfg = RuleConfig(require_contracts=True)
        >>> check_contracts(info, cfg)
        []
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.require_contracts:
        return violations

    for symbol in file_info.symbols:
        # Check all functions and methods - agent needs contracts everywhere
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            if not symbol.contracts:
                kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                suggestion = format_suggestion_for_violation(symbol, "missing_contract")
                violations.append(
                    Violation(
                        rule="missing_contract",
                        severity=Severity.WARNING,
                        file=file_info.path,
                        line=symbol.line,
                        message=f"{kind_name} '{symbol.name}' has no @pre or @post contract",
                        suggestion=suggestion,
                    )
                )

    return violationsh)j?  u}(jJ  check_doctestsjL  KjM  }(jO  }(jQ  KjR  K ujS  }(jQ  MjR  KuujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  KuujY  ](}(jJ  	file_infojL  K
jM  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  K&uujU  }(jO  }(jQ  KjR  KujS  }(jQ  KjR  K&uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j?  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j4  u}(jJ  configjL  K
jM  }(jO  }(jQ  KjR  K(ujS  }(jQ  KjR  K:uujU  }(jO  }(jQ  KjR  K(ujS  }(jQ  KjR  K:uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jL  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh''config: RuleConfig) -> list[Violation]:h)j4  u}(jJ  
violationsjL  K
jM  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jY  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh' violations: list[Violation] = []h)j4  u}(jJ  symboljL  K
jM  }(jO  }(jQ  M	jR  KujS  }(jQ  M	jR  KuujU  }(jO  }(jQ  M	jR  KujS  }(jQ  M	jR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jf  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'symbol in file_info.symbols:h)j4  u}(jJ  	name_partjL  K
jM  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#js  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'Mname_part = symbol.name.split(".")[-1] if "." in symbol.name else symbol.nameh)j4  u}(jJ  	is_publicjL  K
jM  }(jO  }(jQ  M
jR  KujS  }(jQ  M
jR  KuujU  }(jO  }(jQ  M
jR  KujS  }(jQ  M
jR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh')is_public = not name_part.startswith("_")h)j4  u}(jJ  	kind_namejL  K
jM  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j4  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j6  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_doctests(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check that contracted functions have doctest examples.

    Only applies to files marked as Core when require_doctests is True.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract
        >>> contract = Contract(kind="pre", expression="x > 0", line=1)
        >>> sym = Symbol(
        ...     name="calc", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     contracts=[contract], has_doctest=True
        ... )
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> cfg = RuleConfig(require_doctests=True)
        >>> check_doctests(info, cfg)
        []
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.require_doctests:
        return violations

    for symbol in file_info.symbols:
        # Only public functions/methods require doctests (private can skip)
        # For methods, check if method name (after dot) starts with _
        name_part = symbol.name.split(".")[-1] if "." in symbol.name else symbol.name
        is_public = not name_part.startswith("_")
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD) and is_public and symbol.contracts and not symbol.has_doctest:
            kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
            violations.append(
                Violation(
                    rule="missing_doctest",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"{kind_name} '{symbol.name}' has contracts but no doctest examples",
                    suggestion="Add >>> examples in docstring",
                )
            )

    return violationsh)j?  u}(jJ  check_shell_resultjL  KjM  }(jO  }(jQ  MjR  K ujS  }(jQ  MEjR  KuujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujY  ](}(jJ  	file_infojL  K
jM  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  K*uujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  K*uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j  u}(jJ  configjL  K
jM  }(jO  }(jQ  MjR  K,ujS  }(jQ  MjR  K>uujU  }(jO  }(jQ  MjR  K,ujS  }(jQ  MjR  K>uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh''config: RuleConfig) -> list[Violation]:h)j  u}(jJ  
violationsjL  K
jM  }(jO  }(jQ  M-jR  KujS  }(jQ  M-jR  KuujU  }(jO  }(jQ  M-jR  KujS  }(jQ  M-jR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh' violations: list[Violation] = []h)j  u}(jJ  symboljL  K
jM  }(jO  }(jQ  M1jR  KujS  }(jQ  M1jR  KuujU  }(jO  }(jQ  M1jR  KujS  }(jQ  M1jR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'symbol in file_info.symbols:h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_shell_result(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check that Shell functions with return values use Result[T, E].

    Skips: functions returning None (CLI entry points).

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, RuleConfig
        >>> sym = Symbol(name="load", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     signature="(path: str) -> Result[str, str]")
        >>> info = FileInfo(path="shell/fs.py", lines=10, symbols=[sym], is_shell=True)
        >>> check_shell_result(info, RuleConfig())
        []
    """
    violations: list[Violation] = []
    if not file_info.is_shell:
        return violations

    for symbol in file_info.symbols:
        if symbol.kind != SymbolKind.FUNCTION:
            continue
        # Skip functions with no return type or returning None
        if "-> None" in symbol.signature or "->" not in symbol.signature:
            continue
        # Skip generators (Iterator/Generator) - acceptable exception per protocol
        if "Iterator[" in symbol.signature or "Generator[" in symbol.signature:
            continue
        if "Result[" not in symbol.signature:
            violations.append(
                Violation(
                    rule="shell_result",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"Shell function '{symbol.name}' should return Result[T, E]",
                    suggestion="Use Result[T, E] from returns library",
                )
            )
    return violationsh)j?  u}(jJ  
get_all_rulesjL  KjM  }(jO  }(jQ  MHjR  K ujS  }(jQ  MTjR  K9uujU  }(jO  }(jQ  MIjR  KujS  }(jQ  MIjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'X  @post(lambda result: len(result) > 0)
def get_all_rules() -> list[RuleFunc]:
    """
    Return all available rule functions.

    Examples:
        >>> len(get_all_rules()) >= 5
        True
    """
    return [check_file_size, check_function_size, check_forbidden_imports, check_contracts,
            check_doctests, check_shell_result, check_internal_imports, check_impure_calls,
            check_empty_contracts, check_semantic_tautology, check_redundant_type_contracts,
            check_param_mismatch, check_partial_contract]h)j?  u}(jJ  _apply_severity_overridejL  KjM  }(jO  }(jQ  MWjR  K ujS  }(jQ  M{jR  KuujU  }(jO  }(jQ  MWjR  KujS  }(jQ  MWjR  KuujY  ](}(jJ  j  jL  K
jM  }(jO  }(jQ  MWjR  KujS  }(jQ  MWjR  K)uujU  }(jO  }(jQ  MWjR  KujS  }(jQ  MWjR  K)uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'=v: Violation, overrides: dict[str, str]) -> Violation | None:h)j  u}(jJ  	overridesjL  K
jM  }(jO  }(jQ  MWjR  K+ujS  }(jQ  MWjR  KDuujU  }(jO  }(jQ  MWjR  K+ujS  }(jQ  MWjR  KDuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'/overrides: dict[str, str]) -> Violation | None:h)j  u}(jJ  overridejL  K
jM  }(jO  }(jQ  MijR  KujS  }(jQ  MijR  KuujU  }(jO  }(jQ  MijR  KujS  }(jQ  MijR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh' override = overrides.get(v.rule)h)j  u}(jJ  severity_mapjL  K
jM  }(jO  }(jQ  MojR  KujS  }(jQ  MojR  KuujU  }(jO  }(jQ  MojR  KujS  }(jQ  MojR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'\severity_map = {"info": Severity.INFO, "warning": Severity.WARNING, "error": Severity.ERROR}h)j  u}(jJ  new_severityjL  K
jM  }(jO  }(jQ  MpjR  KujS  }(jQ  MpjR  KuujU  }(jO  }(jQ  MpjR  KujS  }(jQ  MpjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j(  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh')new_severity = severity_map.get(override)h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'X>  def _apply_severity_override(v: Violation, overrides: dict[str, str]) -> Violation | None:
    """
    Apply severity override to a violation.

    Returns None if rule is set to "off", otherwise returns violation
    with potentially updated severity.

    Examples:
        >>> from invar.core.models import Violation, Severity
        >>> v = Violation(rule="test", severity=Severity.INFO, file="x.py", message="msg")
        >>> _apply_severity_override(v, {"test": "off"}) is None
        True
        >>> v2 = _apply_severity_override(v, {"test": "error"})
        >>> v2.severity
        <Severity.ERROR: 'error'>
        >>> _apply_severity_override(v, {}).severity  # No override
        <Severity.INFO: 'info'>
    """
    override = overrides.get(v.rule)
    if override is None:
        return v
    if override == "off":
        return None
    # Map string to Severity enum
    severity_map = {"info": Severity.INFO, "warning": Severity.WARNING, "error": Severity.ERROR}
    new_severity = severity_map.get(override)
    if new_severity is None:
        return v  # Invalid override, keep original
    # Create new violation with updated severity
    return Violation(
        rule=v.rule,
        severity=new_severity,
        file=v.file,
        line=v.line,
        message=v.message,
        suggestion=v.suggestion,
    )h)j?  u}(jJ  check_all_rulesjL  KjM  }(jO  }(jQ  M~jR  K ujS  }(jQ  MjR  KuujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujY  ](}(jJ  	file_infojL  K
jM  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  K'uujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  K'uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jB  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j7  u}(jJ  configjL  K
jM  }(jO  }(jQ  MjR  K)ujS  }(jQ  MjR  K;uujU  }(jO  }(jQ  MjR  K)ujS  }(jQ  MjR  K;uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jO  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh''config: RuleConfig) -> list[Violation]:h)j7  u}(jJ  excludedjL  K
jM  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j\  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'5excluded = get_excluded_rules(file_info.path, config)h)j7  u}(jJ  exclude_alljL  K
jM  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#ji  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'exclude_all = "*" in excludedh)j7  u}(jJ  
violationsjL  K
jM  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#jv  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'violations = []h)j7  u}(jJ  rulejL  K
jM  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  KuujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'rule in get_all_rules():h)j7  u}(jJ  j  jL  K
jM  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  K
uujU  }(jO  }(jQ  MjR  KujS  }(jQ  MjR  K
uujY  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'v in rule(file_info, config):h)j7  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyh#j9  h$2/Users/tefx/Projects/Invar/src/invar/core/rules.pyh&j^  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_all_rules(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Run all rules against a file and collect violations.

    Respects rule_exclusions and severity_overrides config.

    Examples:
        >>> from invar.core.models import FileInfo, RuleConfig, RuleExclusion
        >>> violations = check_all_rules(FileInfo(path="test.py", lines=50), RuleConfig())
        >>> isinstance(violations, list)
        True
        >>> # Test exclusion: file_size excluded for generated files
        >>> excl = RuleExclusion(pattern="**/generated/**", rules=["file_size"])
        >>> cfg = RuleConfig(rule_exclusions=[excl])
        >>> big_file = FileInfo(path="src/generated/data.py", lines=600)
        >>> vs = check_all_rules(big_file, cfg)
        >>> any(v.rule == "file_size" for v in vs)
        False
    """
    # Phase 9 P1: Get excluded rules for this file
    excluded = get_excluded_rules(file_info.path, config)
    exclude_all = "*" in excluded

    violations = []
    for rule in get_all_rules():
        for v in rule(file_info, config):
            # Skip if rule is excluded (either specifically or via "*")
            if exclude_all or v.rule in excluded:
                continue
            # Phase 9 P2: Apply severity overrides
            v = _apply_severity_override(v, config.severity_overrides)
            if v is not None:
                violations.append(v)
    return violations      h)j?  ueh)j  u}(j  parserj	  j  h#}(j  }(j  K j  K uj  }(j  Mj  K uuj  j  h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&src/invar/core/parser.pyuj  ](}(nameparse_sourcekindKrange}(start}(lineK	characterK uend}(j  K7j  KuuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  sourcej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&src/invar/core/parser.pyuh'8source: str, path: str = "<string>") -> FileInfo | None:h)j  u}(j  pathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K4uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K4uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'+path: str = "<string>") -> FileInfo | None:h)j  u}(j  treej  K
j  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'tree = ast.parse(source)h)j  u}(j  linesj  K
j  }(j  }(j  K.j  Kuj  }(j  K.j  K	uuj  }(j  }(j  K.j  Kuj  }(j  K.j  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'lines = source.count("\n") + 1h)j  u}(j  symbolsj  K
j  }(j  }(j  K/j  Kuj  }(j  K/j  Kuuj  }(j  }(j  K/j  Kuj  }(j  K/j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh' symbols = _extract_symbols(tree)h)j  u}(j  importsj  K
j  }(j  }(j  K0j  Kuj  }(j  K0j  Kuuj  }(j  }(j  K0j  Kuj  }(j  K0j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh' imports = _extract_imports(tree)h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda source, path="<string>": isinstance(source, str))
def parse_source(source: str, path: str = "<string>") -> FileInfo | None:
    """
    Parse Python source code and extract symbols.

    Args:
        source: Python source code as string
        path: Path for reporting (not used for I/O)

    Returns:
        FileInfo with extracted symbols, or None if syntax error

    Examples:
        >>> info = parse_source("def foo(): pass")
        >>> info is not None
        True
        >>> len(info.symbols)
        1
        >>> info.symbols[0].name
        'foo'
    """
    try:
        tree = ast.parse(source)
    except SyntaxError:
        return None

    lines = source.count("\n") + 1
    symbols = _extract_symbols(tree)
    imports = _extract_imports(tree)

    return FileInfo(
        path=path,
        lines=lines,
        symbols=symbols,
        imports=imports,
    )h)j  u}(j  _extract_symbolsj  Kj  }(j  }(j  K:j  K uj  }(j  KVj  Kuuj  }(j  }(j  K;j  Kuj  }(j  K;j  Kuuj  ](}(j  treej  K
j  }(j  }(j  K;j  Kuj  }(j  K;j  K%uuj  }(j  }(j  K;j  Kuj  }(j  K;j  K%uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'"tree: ast.Module) -> list[Symbol]:h)j
  u}(j  symbolsj  K
j  }(j  }(j  KJj  Kuj  }(j  KJj  Kuuj  }(j  }(j  KJj  Kuj  }(j  KJj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j%  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'symbols: list[Symbol] = []h)j
  u}(j  nodej  K
j  }(j  }(j  KLj  Kuj  }(j  KLj  Kuuj  }(j  }(j  KLj  Kuj  }(j  KLj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j2  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'node in tree.body:h)j
  u}(j  itemj  K
j  }(j  }(j  KRj  Kuj  }(j  KRj  Kuuj  }(j  }(j  KRj  Kuj  }(j  KRj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j?  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'item in node.body:h)j
  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda tree: isinstance(tree, ast.Module))
def _extract_symbols(tree: ast.Module) -> list[Symbol]:
    """
    Extract function, class, and method symbols from AST.

    Examples:
        >>> import ast
        >>> tree = ast.parse("class Foo:\\n    def bar(self): pass")
        >>> symbols = _extract_symbols(tree)
        >>> len(symbols)
        2
        >>> symbols[0].kind.value
        'class'
        >>> symbols[1].kind.value
        'method'
    """
    symbols: list[Symbol] = []

    for node in tree.body:
        if isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef):
            symbols.append(_parse_function(node))
        elif isinstance(node, ast.ClassDef):
            symbols.append(_parse_class(node))
            # Extract methods from class body
            for item in node.body:
                if isinstance(item, ast.FunctionDef | ast.AsyncFunctionDef):
                    symbols.append(_parse_method(item, node.name))

    return symbolsh)j  u}(j  _parse_functionj  Kj  }(j  }(j  KYj  K uj  }(j  Kuj  Kuuj  }(j  }(j  K[j  Kuj  }(j  K[j  Kuuj  ](}(j  nodej  K
j  }(j  }(j  K[j  Kuj  }(j  K[j  K@uuj  }(j  }(j  K[j  Kuj  }(j  K[j  K@uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jY  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'8node: ast.FunctionDef | ast.AsyncFunctionDef) -> Symbol:h)jN  u}(j  	contractsj  K
j  }(j  }(j  K]j  Kuj  }(j  K]j  K
uuj  }(j  }(j  K]j  Kuj  }(j  K]j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jf  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'$contracts = _extract_contracts(node)h)jN  u}(j  	docstringj  K
j  }(j  }(j  K^j  Kuj  }(j  K^j  K
uuj  }(j  }(j  K^j  Kuj  }(j  K^j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#js  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'#docstring = ast.get_docstring(node)h)jN  u}(j  has_doctestj  K
j  }(j  }(j  K_j  Kuj  }(j  K_j  Kuuj  }(j  }(j  K_j  Kuj  }(j  K_j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh':has_doctest = docstring is not None and ">>>" in docstringh)jN  u}(j  	signaturej  K
j  }(j  }(j  K`j  Kuj  }(j  K`j  K
uuj  }(j  }(j  K`j  Kuj  }(j  K`j  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'"signature = _build_signature(node)h)jN  u}(j  internal_importsj  K
j  }(j  }(j  Kaj  Kuj  }(j  Kaj  Kuuj  }(j  }(j  Kaj  Kuj  }(j  Kaj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'1internal_imports = extract_internal_imports(node)h)jN  u}(j  impure_callsj  K
j  }(j  }(j  Kbj  Kuj  }(j  Kbj  Kuuj  }(j  }(j  Kbj  Kuj  }(j  Kbj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh')impure_calls = extract_impure_calls(node)h)jN  u}(j  
code_linesj  K
j  }(j  }(j  Kcj  Kuj  }(j  Kcj  Kuuj  }(j  }(j  Kcj  Kuj  }(j  Kcj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'#code_lines = count_code_lines(node)h)jN  u}(j  
doctest_linesj  K
j  }(j  }(j  Kdj  Kuj  }(j  Kdj  Kuuj  }(j  }(j  Kdj  Kuj  }(j  Kdj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh')doctest_lines = count_doctest_lines(node)h)jN  u}(j  function_callsj  K
j  }(j  }(j  Kej  Kuj  }(j  Kej  Kuuj  }(j  }(j  Kej  Kuj  }(j  Kej  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'4function_calls = extract_function_calls(node)  # P25h)jN  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jP  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: result.kind == SymbolKind.FUNCTION)
def _parse_function(node: ast.FunctionDef | ast.AsyncFunctionDef) -> Symbol:
    """Parse a function definition into a Symbol."""
    contracts = _extract_contracts(node)
    docstring = ast.get_docstring(node)
    has_doctest = docstring is not None and ">>>" in docstring
    signature = _build_signature(node)
    internal_imports = extract_internal_imports(node)
    impure_calls = extract_impure_calls(node)
    code_lines = count_code_lines(node)
    doctest_lines = count_doctest_lines(node)
    function_calls = extract_function_calls(node)  # P25

    return Symbol(
        name=node.name,
        kind=SymbolKind.FUNCTION,
        line=node.lineno,
        end_line=node.end_lineno or node.lineno,
        signature=signature,
        docstring=docstring,
        contracts=contracts,
        has_doctest=has_doctest,
        internal_imports=internal_imports,
        impure_calls=impure_calls,
        code_lines=code_lines,
        doctest_lines=doctest_lines,
        function_calls=function_calls,
    )h)j  u}(j  
_parse_methodj  Kj  }(j  }(j  Kxj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kzj  Kuj  }(j  Kzj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kzj  Kuj  }(j  Kzj  K>uuj  }(j  }(j  Kzj  Kuj  }(j  Kzj  K>uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'Inode: ast.FunctionDef | ast.AsyncFunctionDef, class_name: str) -> Symbol:h)j  u}(j  
class_namej  K
j  }(j  }(j  Kzj  K@uj  }(j  Kzj  KOuuj  }(j  }(j  Kzj  K@uj  }(j  Kzj  KOuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'class_name: str) -> Symbol:h)j  u}(j  	contractsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'$contracts = _extract_contracts(node)h)j  u}(j  	docstringj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'#docstring = ast.get_docstring(node)h)j  u}(j  has_doctestj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh':has_doctest = docstring is not None and ">>>" in docstringh)j  u}(j  	signaturej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j)  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'"signature = _build_signature(node)h)j  u}(j  internal_importsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j6  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'1internal_imports = extract_internal_imports(node)h)j  u}(j  impure_callsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jC  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh')impure_calls = extract_impure_calls(node)h)j  u}(j  
code_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jP  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'#code_lines = count_code_lines(node)h)j  u}(j  
doctest_linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j]  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh')doctest_lines = count_doctest_lines(node)h)j  u}(j  function_callsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jj  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'4function_calls = extract_function_calls(node)  # P25h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda node, class_name: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: result.kind == SymbolKind.METHOD)
def _parse_method(node: ast.FunctionDef | ast.AsyncFunctionDef, class_name: str) -> Symbol:
    """
    Parse a method definition into a Symbol.

    Examples:
        >>> import ast
        >>> tree = ast.parse("class Foo:\\n    def bar(self): pass")
        >>> method_node = tree.body[0].body[0]
        >>> sym = _parse_method(method_node, "Foo")
        >>> sym.name
        'Foo.bar'
        >>> sym.kind.value
        'method'
    """
    contracts = _extract_contracts(node)
    docstring = ast.get_docstring(node)
    has_doctest = docstring is not None and ">>>" in docstring
    signature = _build_signature(node)
    internal_imports = extract_internal_imports(node)
    impure_calls = extract_impure_calls(node)
    code_lines = count_code_lines(node)
    doctest_lines = count_doctest_lines(node)
    function_calls = extract_function_calls(node)  # P25

    return Symbol(
        name=f"{class_name}.{node.name}",
        kind=SymbolKind.METHOD,
        line=node.lineno,
        end_line=node.end_lineno or node.lineno,
        signature=signature,
        docstring=docstring,
        contracts=contracts,
        has_doctest=has_doctest,
        internal_imports=internal_imports,
        impure_calls=impure_calls,
        code_lines=code_lines,
        doctest_lines=doctest_lines,
        function_calls=function_calls,
    )h)j  u}(j  _parse_classj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K#uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K#uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'node: ast.ClassDef) -> Symbol:h)jy  u}(j  	docstringj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'#docstring = ast.get_docstring(node)h)jy  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j{  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda node: isinstance(node, ast.ClassDef))
@post(lambda result: result.kind == SymbolKind.CLASS)
def _parse_class(node: ast.ClassDef) -> Symbol:
    """Parse a class definition into a Symbol."""
    docstring = ast.get_docstring(node)

    return Symbol(
        name=node.name,
        kind=SymbolKind.CLASS,
        line=node.lineno,
        end_line=node.end_lineno or node.lineno,
        docstring=docstring,
    )h)j  u}(j  _extract_contractsj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  KCuuj  }(j  }(j  Kj  Kuj  }(j  Kj  KCuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'@node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[Contract]:h)j  u}(j  	contractsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'contracts: list[Contract] = []h)j  u}(j  	decoratorj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'!decorator in node.decorator_list:h)j  u}(j  contractj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'2contract = _parse_decorator_as_contract(decorator)h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: all(c.kind in ("pre", "post") for c in result))
def _extract_contracts(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[Contract]:
    """Extract @pre and @post contracts from function decorators."""
    contracts: list[Contract] = []

    for decorator in node.decorator_list:
        contract = _parse_decorator_as_contract(decorator)
        if contract:
            contracts.append(contract)

    return contractsh)j  u}(j  _parse_decorator_as_contractj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  K uuj  ](}(j  	decoratorj  K
j  }(j  }(j  Kj  K!uj  }(j  Kj  K4uuj  }(j  }(j  Kj  K!uj  }(j  Kj  K4uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'(decorator: ast.expr) -> Contract | None:h)j  u}(j  funcj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'func = decorator.funch)j  u}(j  exprj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'*expr = _get_contract_expression(decorator)h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @post(lambda result: result is None or result.kind in ("pre", "post"))
def _parse_decorator_as_contract(decorator: ast.expr) -> Contract | None:
    """Try to parse a decorator as a contract (@pre or @post)."""
    # Handle @pre(...) or @post(...)
    if isinstance(decorator, ast.Call):
        func = decorator.func
        if isinstance(func, ast.Name) and func.id in ("pre", "post"):
            expr = _get_contract_expression(decorator)
            return Contract(
                kind="pre" if func.id == "pre" else "post",
                expression=expr,
                line=decorator.lineno,
            )
        # Handle deal.pre(...) or deal.post(...)
        if isinstance(func, ast.Attribute) and func.attr in ("pre", "post"):
            expr = _get_contract_expression(decorator)
            return Contract(
                kind="pre" if func.attr == "pre" else "post",
                expression=expr,
                line=decorator.lineno,
            )

    return Noneh)j  u}(j  _get_contract_expressionj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]}(j  callj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K+uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K+uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j   h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'call: ast.Call) -> str:h)j  uah}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'@pre(lambda call: isinstance(call, ast.Call))
def _get_contract_expression(call: ast.Call) -> str:
    """Extract the expression string from a contract decorator call."""
    if call.args:
        return ast.unparse(call.args[0])
    return ""h)j  u}(j  _build_signaturej  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  KAuuj  }(j  }(j  Kj  Kuj  }(j  Kj  KAuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j:  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'5node: ast.FunctionDef | ast.AsyncFunctionDef) -> str:h)j/  u}(j  argsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jG  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'args = node.argsh)j/  u}(j  partsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jT  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'parts: list[str] = []h)j/  u}(j  argj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#ja  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'arg in args.args:h)j/  u}(j  partj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#jn  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'part = arg.argh)j/  u}(j  sigj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j{  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'sig = f"({', '.join(parts)})"h)j/  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j1  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: result.startswith("(") and ")" in result)
def _build_signature(node: ast.FunctionDef | ast.AsyncFunctionDef) -> str:
    """Build a signature string from function arguments."""
    args = node.args
    parts: list[str] = []

    # Regular args
    for arg in args.args:
        part = arg.arg
        if arg.annotation:
            part += f": {ast.unparse(arg.annotation)}"
        parts.append(part)

    sig = f"({', '.join(parts)})"

    # Return type
    if node.returns:
        sig += f" -> {ast.unparse(node.returns)}"

    return sigh)j  u}(j  _extract_importsj  Kj  }(j  }(j  Kj  K uj  }(j  Mj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  treej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'tree: ast.Module) -> list[str]:h)j  u}(j  importsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'imports: list[str] = []h)j  u}(j  nodej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'node in tree.body:h)j  u}(j  aliasj  K
j  }(j  }(j  M j  Kuj  }(j  M j  Kuuj  }(j  }(j  M j  Kuj  }(j  M j  Kuuj  ]h}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'alias in node.names:h)j  ueh}(h!:file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyh#j  h$3/Users/tefx/Projects/Invar/src/invar/core/parser.pyh&j  uh'X]  @pre(lambda tree: isinstance(tree, ast.Module))
@post(lambda result: all(isinstance(s, str) and s for s in result))
def _extract_imports(tree: ast.Module) -> list[str]:
    """Extract imported module names from AST (top-level only)."""
    imports: list[str] = []

    for node in tree.body:
        if isinstance(node, ast.Import):
            for alias in node.names:
                imports.append(alias.name.split(".")[0])
        elif isinstance(node, ast.ImportFrom):
            if node.module:
                imports.append(node.module.split(".")[0])

    return list(set(imports))  # Deduplicateh)j  ueh)j  u}(j  inspectj	  j  h#}(j  }(j  K j  K uj  }(j  Kj  K uuj  j  h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&src/invar/core/inspect.pyuj  ](}(nameFileContextkindKrange}(start}(lineK	characterK uend}(j  K7j  K.uuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  pathj  K
j  }(j  }(j  K&j  Kuj  }(j  K&j  Kuuj  }(j  }(j  K&j  Kuj  }(j  K&j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&src/invar/core/inspect.pyuh'	path: strh)j  u}(j  linesj  K
j  }(j  }(j  K'j  Kuj  }(j  K'j  K	uuj  }(j  }(j  K'j  Kuj  }(j  K'j  K	uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'
lines: inth)j  u}(j  	max_linesj  K
j  }(j  }(j  K(j  Kuj  }(j  K(j  K
uuj  }(j  }(j  K(j  Kuj  }(j  K(j  K
uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'max_lines: inth)j  u}(j  functions_totalj  K
j  }(j  }(j  K)j  Kuj  }(j  K)j  Kuuj  }(j  }(j  K)j  Kuj  }(j  K)j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'functions_total: inth)j  u}(j  functions_with_contractsj  K
j  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'functions_with_contracts: inth)j  u}(j  contract_examplesj  K
j  }(j  }(j  K+j  Kuj  }(j  K+j  Kuuj  }(j  }(j  K+j  Kuj  }(j  K+j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j+  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'contract_examples: list[str]h)j  u}(j  
percentagej  Kj  }(j  }(j  K-j  Kuj  }(j  K2j  K5uuj  }(j  }(j  K.j  Kuj  }(j  K.j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j8  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'@property
    def percentage(self) -> int:
        """Percentage of max lines used."""
        if self.max_lines == 0:
            return 0
        return int(self.lines / self.max_lines * 100)h)j  u}(j  has_patternsj  Kj  }(j  }(j  K4j  Kuj  }(j  K7j  K.uuj  }(j  }(j  K5j  Kuj  }(j  K5j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#jE  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'@property
    def has_patterns(self) -> bool:
        """Whether there are contract patterns to show."""
        return len(self.contract_examples) > 0h)j  ueh}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'X  @dataclass
class FileContext:
    """
    Context information about a file for inspection.

    Examples:
        >>> ctx = FileContext(
        ...     path="src/core/calc.py",
        ...     lines=150,
        ...     max_lines=500,
        ...     functions_total=5,
        ...     functions_with_contracts=3,
        ...     contract_examples=["@pre(lambda x: x > 0)", "@post(lambda result: result is not None)"]
        ... )
        >>> ctx.percentage
        30
        >>> ctx.has_patterns
        True
    """

    path: str
    lines: int
    max_lines: int
    functions_total: int
    functions_with_contracts: int
    contract_examples: list[str]

    @property
    def percentage(self) -> int:
        """Percentage of max lines used."""
        if self.max_lines == 0:
            return 0
        return int(self.lines / self.max_lines * 100)

    @property
    def has_patterns(self) -> bool:
        """Whether there are contract patterns to show."""
        return len(self.contract_examples) > 0h)j  u}(j  analyze_file_contextj  Kj  }(j  }(j  K:j  K uj  }(j  Koj  Kuuj  }(j  }(j  K;j  Kuj  }(j  K;j  Kuuj  ](}(j  sourcej  K
j  }(j  }(j  K;j  Kuj  }(j  K;j  K$uuj  }(j  }(j  K;j  Kuj  }(j  K;j  K$uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j_  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'=source: str, path: str, max_lines: int = 500) -> FileContext:h)jT  u}(j  pathj  K
j  }(j  }(j  K;j  K&uj  }(j  K;j  K/uuj  }(j  }(j  K;j  K&uj  }(j  K;j  K/uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#jl  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'0path: str, max_lines: int = 500) -> FileContext:h)jT  u}(j  	max_linesj  K
j  }(j  }(j  K;j  K1uj  }(j  K;j  KEuuj  }(j  }(j  K;j  K1uj  }(j  K;j  KEuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#jy  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'%max_lines: int = 500) -> FileContext:h)jT  u}(j  linesj  K
j  }(j  }(j  KPj  Kuj  }(j  KPj  K	uuj  }(j  }(j  KPj  Kuj  }(j  KPj  K	uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'lines = source.count("\n") + 1h)jT  u}(j  	file_infoj  K
j  }(j  }(j  KSj  Kuj  }(j  KSj  K
uuj  }(j  }(j  KSj  Kuj  }(j  KSj  K
uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'&file_info = parse_source(source, path)h)jT  u}(j  	functionsj  K
j  }(j  }(j  K^j  Kuj  }(j  K^j  K
uuj  }(j  }(j  K^j  Kuj  }(j  K^j  K
uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'`functions = [s for s in file_info.symbols if s.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD)]h)jT  u}(j  contract_examplesj  K
j  }(j  }(j  Kaj  Kuj  }(j  Kaj  Kuuj  }(j  }(j  Kaj  Kuj  }(j  Kaj  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'6contract_examples = _extract_contract_patterns(source)h)jT  u}(j  functions_with_contractsj  K
j  }(j  }(j  Kdj  Kuj  }(j  Kdj  Kuuj  }(j  }(j  Kdj  Kuj  }(j  Kdj  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'functions_with_contracts = sum(h)jT  ueh}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#jV  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'X  @pre(lambda source, path, max_lines: isinstance(source, str) and max_lines > 0)
def analyze_file_context(source: str, path: str, max_lines: int = 500) -> FileContext:
    """
    Analyze a source file to extract context for inspection.

    Examples:
        >>> source = '''
        ... from deal import pre
        ... @pre(lambda x: x > 0)
        ... def positive(x: int) -> int:
        ...     return x * 2
        ... def no_contract(y):
        ...     return y
        ... '''
        >>> ctx = analyze_file_context(source.strip(), "test.py", 500)
        >>> ctx.functions_total
        2
        >>> ctx.functions_with_contracts
        1
        >>> "@pre(lambda x: x > 0)" in ctx.contract_examples
        True
    """
    lines = source.count("\n") + 1

    # Parse to find functions
    file_info = parse_source(source, path)
    if file_info is None:
        return FileContext(
            path=path,
            lines=lines,
            max_lines=max_lines,
            functions_total=0,
            functions_with_contracts=0,
            contract_examples=[],
        )

    functions = [s for s in file_info.symbols if s.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD)]

    # Find contract patterns in source
    contract_examples = _extract_contract_patterns(source)

    # Count functions with contracts (Symbol.contracts is non-empty)
    functions_with_contracts = sum(
        1 for f in functions if len(f.contracts) > 0
    )

    return FileContext(
        path=path,
        lines=lines,
        max_lines=max_lines,
        functions_total=len(functions),
        functions_with_contracts=functions_with_contracts,
        contract_examples=contract_examples[:3],  # Limit to 3 examples
    )h)j  u}(j  _extract_contract_patternsj  Kj  }(j  }(j  Krj  K uj  }(j  Kj  Kuuj  }(j  }(j  Krj  Kuj  }(j  Krj  Kuuj  ](}(j  sourcej  K
j  }(j  }(j  Krj  Kuj  }(j  Krj  K*uuj  }(j  }(j  Krj  Kuj  }(j  Krj  K*uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'source: str) -> list[str]:h)j  u}(j  patternsj  K
j  }(j  }(j  K~j  Kuj  }(j  K~j  Kuuj  }(j  }(j  K~j  Kuj  }(j  K~j  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'
patterns = []h)j  u}(j  matchj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'6match in re.finditer(r"@(pre|post)\([^)]+\)", source):h)j  u}(j  patternj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'pattern = match.group(0)h)j  ueh}(h!;file:///Users/tefx/Projects/Invar/src/invar/core/inspect.pyh#j  h$4/Users/tefx/Projects/Invar/src/invar/core/inspect.pyh&j  uh'X  def _extract_contract_patterns(source: str) -> list[str]:
    """
    Extract @pre/@post patterns from source.

    Examples:
        >>> src = "@pre(lambda x: x > 0)\\n@post(lambda r: r is not None)"
        >>> patterns = _extract_contract_patterns(src)
        >>> len(patterns)
        2
        >>> "@pre(lambda x: x > 0)" in patterns
        True
    """
    patterns = []

    # Match @pre(...) and @post(...) decorators
    for match in re.finditer(r"@(pre|post)\([^)]+\)", source):
        pattern = match.group(0)
        # Simplify if too long
        if len(pattern) > 60:
            pattern = pattern[:57] + "..."
        if pattern not in patterns:
            patterns.append(pattern)

    return patternsh)j  ueh)j  u}(j  
extractionj	  j  h#}(j  }(j  K j  K uj  }(j  Kj  K uuj  j  h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&src/invar/core/extraction.pyuj  ](}(namefind_extractable_groupskindKrange}(start}(lineK
	characterK uend}(j  KVj  KuuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  	file_infoj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K/uuj   }(j  }(j  Kj  Kuj  }(j  Kj  K/uuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j(  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&src/invar/core/extraction.pyuh'#file_info: FileInfo) -> list[dict]:h)j  u}(j  funcsj  K
j  }(j  }(j  K'j  Kuj  }(j  K'j  K	uuj   }(j  }(j  K'j  Kuj  }(j  K'j  K	uuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j6  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'-funcs = {s.name: s for s in file_info.symbolsh)j  u}(j  
func_namesj  K
j  }(j  }(j  K.j  Kuj  }(j  K.j  Kuuj   }(j  }(j  K.j  Kuj  }(j  K.j  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jC  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'func_names = set(funcs.keys())h)j  u}(j  graphj  K
j  }(j  }(j  K/j  Kuj  }(j  K/j  K	uuj   }(j  }(j  K/j  Kuj  }(j  K/j  K	uuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jP  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'Agraph: dict[str, set[str]] = {name: set() for name in func_names}h)j  u}(j  namej  K
j  }(j  }(j  K1j  Kuj  }(j  K1j  Kuuj   }(j  }(j  K1j  Kuj  }(j  K1j  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j]  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'name, sym in funcs.items():h)j  u}(j  symj  K
j  }(j  }(j  K1j  Kuj  }(j  K1j  Kuuj   }(j  }(j  K1j  Kuj  }(j  K1j  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jj  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'sym in funcs.items():h)j  u}(j  calledj  K
j  }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj   }(j  }(j  K2j  Kuj  }(j  K2j  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jw  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'called in sym.function_calls:h)j  u}(j  visitedj  K
j  }(j  }(j  K8j  Kuj  }(j  K8j  Kuuj   }(j  }(j  K8j  Kuj  }(j  K8j  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'visited: set[str] = set()h)j  u}(j  groupsj  K
j  }(j  }(j  K9j  Kuj  }(j  K9j  K
uuj   }(j  }(j  K9j  Kuj  }(j  K9j  K
uuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'groups: list[dict] = []h)j  u}(j  	componentj  K
j  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj   }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'component: list[str] = []h)j  u}(j  queuej  K
j  }(j  }(j  KAj  Kuj  }(j  KAj  K
uuj   }(j  }(j  KAj  Kuj  }(j  KAj  K
uuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'queue = [name]h)j  u}(j  currentj  K
j  }(j  }(j  KCj  Kuj  }(j  KCj  Kuuj   }(j  }(j  KCj  Kuj  }(j  KCj  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'current = queue.pop(0)h)j  u}(j  total_linesj  K
j  }(j  }(j  KKj  Kuj  }(j  KKj  Kuuj   }(j  }(j  KKj  Kuj  }(j  KKj  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'Ktotal_lines = sum(funcs[n].end_line - funcs[n].line + 1 for n in component)h)j  u}(j  depsj  K
j  }(j  }(j  KLj  Kuj  }(j  KLj  Kuuj   }(j  }(j  KLj  Kuj  }(j  KLj  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'Cdeps = _get_group_dependencies(component, funcs, file_info.imports)h)j  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'XL
  @pre(lambda file_info: isinstance(file_info, FileInfo))
def find_extractable_groups(file_info: FileInfo) -> list[dict]:
    """
    Find groups of related functions that could be extracted together.

    Uses function call relationships to identify connected components.
    Returns groups sorted by total lines (largest first).

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> s1 = Symbol(name="main", kind=SymbolKind.FUNCTION, line=1, end_line=20,
        ...     function_calls=["helper"])
        >>> s2 = Symbol(name="helper", kind=SymbolKind.FUNCTION, line=21, end_line=30,
        ...     function_calls=[])
        >>> s3 = Symbol(name="unrelated", kind=SymbolKind.FUNCTION, line=31, end_line=40,
        ...     function_calls=[])
        >>> info = FileInfo(path="test.py", lines=40, symbols=[s1, s2, s3])
        >>> groups = find_extractable_groups(info)
        >>> len(groups)
        2
        >>> sorted(groups[0]["functions"])  # Largest group first
        ['helper', 'main']
        >>> groups[0]["lines"]
        30
    """
    # Get only functions/methods
    funcs = {s.name: s for s in file_info.symbols
             if s.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD)}

    if not funcs:
        return []

    # Build call graph (only internal calls)
    func_names = set(funcs.keys())
    graph: dict[str, set[str]] = {name: set() for name in func_names}

    for name, sym in funcs.items():
        for called in sym.function_calls:
            if called in func_names:
                graph[name].add(called)
                graph[called].add(name)  # Bidirectional for grouping

    # Find connected components
    visited: set[str] = set()
    groups: list[dict] = []

    for name in func_names:
        if name in visited:
            continue

        # BFS to find all connected functions
        component: list[str] = []
        queue = [name]
        while queue:
            current = queue.pop(0)
            if current in visited:
                continue
            visited.add(current)
            component.append(current)
            queue.extend(n for n in graph[current] if n not in visited)

        # Calculate group stats
        total_lines = sum(funcs[n].end_line - funcs[n].line + 1 for n in component)
        deps = _get_group_dependencies(component, funcs, file_info.imports)

        groups.append({
            "functions": sorted(component),
            "lines": total_lines,
            "dependencies": sorted(deps),
        })

    # Sort by lines (largest first)
    groups.sort(key=lambda g: -g["lines"])
    return groupsh)j
  u}(j  _get_group_dependenciesj  Kj  }(j  }(j  KYj  K uj  }(j  Khj  KIuuj   }(j  }(j  KYj  Kuj  }(j  KYj  Kuuj$  ](}(j  
func_namesj  K
j  }(j  }(j  KZj  Kuj  }(j  KZj  Kuuj   }(j  }(j  KZj  Kuj  }(j  KZj  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'func_names: list[str],h)j  u}(j  funcsj  K
j  }(j  }(j  K[j  Kuj  }(j  K[j  Kuuj   }(j  }(j  K[j  Kuj  }(j  K[j  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'funcs: dict[str, Symbol],h)j  u}(j  file_importsj  K
j  }(j  }(j  K\j  Kuj  }(j  K\j  Kuuj   }(j  }(j  K\j  Kuj  }(j  K\j  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'file_imports: list[str],h)j  u}(j  depsj  K
j  }(j  }(j  K_j  Kuj  }(j  K_j  Kuuj   }(j  }(j  K_j  Kuj  }(j  K_j  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'deps: set[str] = set()h)j  u}(j  namej  K
j  }(j  }(j  Kaj  Kuj  }(j  Kaj  Kuuj   }(j  }(j  Kaj  Kuj  }(j  Kaj  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j   h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'name in func_names:h)j  u}(j  symj  K
j  }(j  }(j  Kbj  Kuj  }(j  Kbj  Kuuj   }(j  }(j  Kbj  Kuj  }(j  Kbj  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j-  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'sym = funcs[name]h)j  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'X/  def _get_group_dependencies(
    func_names: list[str],
    funcs: dict[str, Symbol],
    file_imports: list[str],
) -> set[str]:
    """Get external dependencies used by a group of functions."""
    deps: set[str] = set()

    for name in func_names:
        sym = funcs[name]
        # Add internal imports used by this function
        deps.update(sym.internal_imports)

    # Filter to only include actual imports from file
    # (some internal_imports might be from nested scopes)
    return deps.intersection(set(file_imports)) if file_imports else depsh)j
  u}(j  format_extraction_hintj  Kj  }(j  }(j  Kkj  K uj  }(j  Kj  Kuuj   }(j  }(j  Klj  Kuj  }(j  Klj  Kuuj$  ](}(j  	file_infoj  K
j  }(j  }(j  Klj  Kuj  }(j  Klj  K.uuj   }(j  }(j  Klj  Kuj  }(j  Klj  K.uuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jG  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'1file_info: FileInfo, max_groups: int = 3) -> str:h)j<  u}(j  
max_groupsj  K
j  }(j  }(j  Klj  K0uj  }(j  Klj  KCuuj   }(j  }(j  Klj  K0uj  }(j  Klj  KCuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jT  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'max_groups: int = 3) -> str:h)j<  u}(j  groupsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj   }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#ja  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'+groups = find_extractable_groups(file_info)h)j<  u}(j  hintsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj   }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#jn  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'hints: list[str] = []h)j<  u}(j  ij  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj   }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j{  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'+i, group in enumerate(groups[:max_groups]):h)j<  u}(j  groupj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'(group in enumerate(groups[:max_groups]):h)j<  u}(j  funcsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj   }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'%funcs = ", ".join(group["functions"])h)j<  u}(j  linesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj   }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'lines = group["lines"]h)j<  u}(j  depsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj$  ]h}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'Ldeps = ", ".join(group["dependencies"]) if group["dependencies"] else "none"h)j<  ueh}(h!>file:///Users/tefx/Projects/Invar/src/invar/core/extraction.pyh#j>  h$7/Users/tefx/Projects/Invar/src/invar/core/extraction.pyh&j2  uh'XU  @pre(lambda file_info, max_groups=3: isinstance(file_info, FileInfo))
def format_extraction_hint(file_info: FileInfo, max_groups: int = 3) -> str:
    """
    Format extraction suggestions for file_size_warning.

    P25: Shows extractable function groups with dependencies.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> s1 = Symbol(name="parse", kind=SymbolKind.FUNCTION, line=1, end_line=50,
        ...     function_calls=["validate"], internal_imports=["ast"])
        >>> s2 = Symbol(name="validate", kind=SymbolKind.FUNCTION, line=51, end_line=80,
        ...     function_calls=[], internal_imports=["ast"])
        >>> info = FileInfo(path="test.py", lines=100, symbols=[s1, s2], imports=["ast", "re"])
        >>> hint = format_extraction_hint(info)
        >>> "parse, validate" in hint
        True
        >>> "(80L)" in hint
        True
    """
    groups = find_extractable_groups(file_info)

    if not groups:
        return ""

    # Format top N groups
    hints: list[str] = []
    for i, group in enumerate(groups[:max_groups]):
        funcs = ", ".join(group["functions"])
        lines = group["lines"]
        deps = ", ".join(group["dependencies"]) if group["dependencies"] else "none"
        hints.append(f"[{chr(65+i)}] {funcs} ({lines}L) | Deps: {deps}")

    return "\n".join(hints)h)j
  ueh)j  u}(j  utilsj	  j  h#}(j  }(j  K j  K uj  }(j  Kj  K uuj  j  h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&src/invar/core/utils.pyuj  ](}(name
get_exit_codekindKrange}(start}(lineK	characterK uend}(j  K$j  KuuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren](}(j  reportj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&src/invar/core/utils.pyuh'*report: GuardReport, strict: bool) -> int:h)j  u}(j  strictj  K
j  }(j  }(j  Kj  K'uj  }(j  Kj  K3uuj  }(j  }(j  Kj  K'uj  }(j  Kj  K3uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'strict: bool) -> int:h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'Xx  @pre(lambda report, strict: isinstance(report, GuardReport))
@post(lambda result: result in (0, 1))
def get_exit_code(report: GuardReport, strict: bool) -> int:
    """
    Determine exit code based on report and strict mode.

    Examples:
        >>> from invar.core.models import GuardReport
        >>> get_exit_code(GuardReport(files_checked=1), strict=False)
        0
        >>> report = GuardReport(files_checked=1)
        >>> report.errors = 1
        >>> get_exit_code(report, strict=False)
        1
    """
    if report.errors > 0:
        return 1
    if strict and report.warnings > 0:
        return 1
    return 0h)j  u}(j  extract_guard_sectionj  Kj  }(j  }(j  K'j  K uj  }(j  K8j  K uuj  }(j  }(j  K)j  Kuj  }(j  K)j  Kuuj  ](}(j  dataj  K
j  }(j  }(j  K)j  Kuj  }(j  K)j  K.uuj  }(j  }(j  K)j  Kuj  }(j  K)j  K.uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'5data: dict[str, Any], source: str) -> dict[str, Any]:h)j  u}(j  sourcej  K
j  }(j  }(j  K)j  K0uj  }(j  K)j  K;uuj  }(j  }(j  K)j  K0uj  }(j  K)j  K;uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'source: str) -> dict[str, Any]:h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'X  @pre(lambda data, source: isinstance(data, dict))
@post(lambda result: isinstance(result, dict))
def extract_guard_section(data: dict[str, Any], source: str) -> dict[str, Any]:
    """
    Extract guard config section based on source type.

    Examples:
        >>> extract_guard_section({"tool": {"invar": {"guard": {"x": 1}}}}, "pyproject")
        {'x': 1}
        >>> extract_guard_section({"guard": {"y": 2}}, "invar")
        {'y': 2}
        >>> extract_guard_section({}, "default")
        {}
    """
    if source == "pyproject":
        return data.get("tool", {}).get("invar", {}).get("guard", {})
    # invar.toml and .invar/config.toml use [guard] directly
    return data.get("guard", {})h)j  u}(j  parse_guard_configj  Kj  }(j  }(j  K;j  K uj  }(j  K}j  Kuuj  }(j  }(j  K=j  Kuj  }(j  K=j  Kuuj  ](}(j  guard_configj  K
j  }(j  }(j  K=j  Kuj  }(j  K=j  K3uuj  }(j  }(j  K=j  Kuj  }(j  K=j  K3uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j+  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh',guard_config: dict[str, Any]) -> RuleConfig:h)j   u}(j  kwargsj  K
j  }(j  }(j  KNj  Kuj  }(j  KNj  K
uuj  }(j  }(j  KNj  Kuj  }(j  KNj  K
uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j8  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'kwargs: dict[str, Any] = {}h)j   u}(j  
exclusionsj  K
j  }(j  }(j  Kjj  Kuj  }(j  Kjj  Kuuj  }(j  }(j  Kjj  Kuj  }(j  Kjj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jE  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'exclusions = []h)j   u}(j  exclj  K
j  }(j  }(j  Kkj  Kuj  }(j  Kkj  Kuuj  }(j  }(j  Kkj  Kuj  }(j  Kkj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jR  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'(excl in guard_config["rule_exclusions"]:h)j   u}(j  defaultsj  K
j  }(j  }(j  Kuj  Kuj  }(j  Kuj  Kuuj  }(j  }(j  Kuj  Kuj  }(j  Kuj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j_  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'-defaults = {"redundant_type_contract": "off"}h)j   ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j"  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'X	  @pre(lambda guard_config: isinstance(guard_config, dict))
@post(lambda result: isinstance(result, RuleConfig))
def parse_guard_config(guard_config: dict[str, Any]) -> RuleConfig:
    """
    Parse configuration from guard section.

    Examples:
        >>> cfg = parse_guard_config({"max_file_lines": 400})
        >>> cfg.max_file_lines
        400
        >>> cfg = parse_guard_config({})
        >>> cfg.max_file_lines  # Phase 9 P1: Default is now 500
        500
        >>> cfg = parse_guard_config({"rule_exclusions": [{"pattern": "**/gen/**", "rules": ["*"]}]})
        >>> len(cfg.rule_exclusions)
        1
        >>> cfg.rule_exclusions[0].pattern
        '**/gen/**'
    """
    kwargs: dict[str, Any] = {}

    if "max_file_lines" in guard_config:
        kwargs["max_file_lines"] = guard_config["max_file_lines"]

    if "max_function_lines" in guard_config:
        kwargs["max_function_lines"] = guard_config["max_function_lines"]

    if "forbidden_imports" in guard_config:
        kwargs["forbidden_imports"] = tuple(guard_config["forbidden_imports"])

    if "require_contracts" in guard_config:
        kwargs["require_contracts"] = guard_config["require_contracts"]

    if "require_doctests" in guard_config:
        kwargs["require_doctests"] = guard_config["require_doctests"]

    if "strict_pure" in guard_config:
        kwargs["strict_pure"] = guard_config["strict_pure"]

    if "use_code_lines" in guard_config:
        kwargs["use_code_lines"] = guard_config["use_code_lines"]

    if "exclude_doctest_lines" in guard_config:
        kwargs["exclude_doctest_lines"] = guard_config["exclude_doctest_lines"]

    # Phase 9 P1: Parse rule_exclusions
    if "rule_exclusions" in guard_config:
        exclusions = []
        for excl in guard_config["rule_exclusions"]:
            exclusions.append(RuleExclusion(
                pattern=excl["pattern"],
                rules=excl["rules"],
            ))
        kwargs["rule_exclusions"] = exclusions

    # Phase 9 P2: Parse severity_overrides (merge with defaults)
    if "severity_overrides" in guard_config:
        # Get default overrides and update with user config
        defaults = {"redundant_type_contract": "off"}
        defaults.update(guard_config["severity_overrides"])
        kwargs["severity_overrides"] = defaults

    # Phase 9 P8: Parse size_warning_threshold
    if "size_warning_threshold" in guard_config:
        kwargs["size_warning_threshold"] = guard_config["size_warning_threshold"]

    return RuleConfig(**kwargs)h)j  u}(j  matches_patternj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  	file_pathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K"uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K"uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jy  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'-file_path: str, patterns: list[str]) -> bool:h)jn  u}(j  patternsj  K
j  }(j  }(j  Kj  K$uj  }(j  Kj  K7uuj  }(j  }(j  Kj  K$uj  }(j  Kj  K7uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'patterns: list[str]) -> bool:h)jn  u}(j  patternj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'pattern in patterns:h)jn  u}(j  partsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'parts = file_path.split("/")h)jn  u}(j  jz  j  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'i in range(len(parts)):h)jn  u}(j  subpathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  !      h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'subpath = "/".join(parts[i:])h)jn  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jp  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'XP  @pre(lambda file_path, patterns: isinstance(file_path, str) and isinstance(patterns, list))
def matches_pattern(file_path: str, patterns: list[str]) -> bool:
    """
    Check if a file path matches any of the glob patterns.

    Examples:
        >>> matches_pattern("src/domain/models.py", ["**/domain/**"])
        True
        >>> matches_pattern("src/api/views.py", ["**/domain/**"])
        False
        >>> matches_pattern("src/core/logic.py", ["src/core/**", "**/models/**"])
        True
    """
    for pattern in patterns:
        if fnmatch.fnmatch(file_path, pattern):
            return True
        # Also check with leading path component for ** patterns
        if pattern.startswith("**/"):
            # Match anywhere in path
            if fnmatch.fnmatch(file_path, pattern[3:]):
                return True
            # Try matching each subpath
            parts = file_path.split("/")
            for i in range(len(parts)):
                subpath = "/".join(parts[i:])
                if fnmatch.fnmatch(subpath, pattern[3:]):
                    return True
    return Falseh)j  u}(j  matches_path_prefixj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  K9uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  	file_pathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K&uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K&uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'-file_path: str, prefixes: list[str]) -> bool:h)j  u}(j  prefixesj  K
j  }(j  }(j  Kj  K(uj  }(j  Kj  K;uuj  }(j  }(j  Kj  K(uj  }(j  Kj  K;uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'prefixes: list[str]) -> bool:h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'X  @pre(lambda file_path, prefixes: isinstance(file_path, str) and isinstance(prefixes, list))
def matches_path_prefix(file_path: str, prefixes: list[str]) -> bool:
    """
    Check if file_path starts with any of the given prefixes.

    Examples:
        >>> matches_path_prefix("src/core/logic.py", ["src/core", "src/domain"])
        True
        >>> matches_path_prefix("src/shell/cli.py", ["src/core", "src/domain"])
        False
    """
    return any(file_path.startswith(p) for p in prefixes)h)j  u}(j  match_glob_patternj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  	file_pathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'&file_path: str, pattern: str) -> bool:h)j  u}(j  patternj  K
j  }(j  }(j  Kj  K'uj  }(j  Kj  K3uuj  }(j  }(j  Kj  K'uj  }(j  Kj  K3uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'pattern: str) -> bool:h)j  u}(j  
path_partsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'!path_parts = file_path.split("/")h)j  u}(j  middlej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j!  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'middle = pattern[3:-3]h)j  u}(j  suffixj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j.  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'suffix = pattern[3:]h)j  u}(j  jz  j  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j:  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'i in range(len(path_parts)):h)j  u}(j  prefixj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jG  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'prefix = pattern[:-3]h)j  u}(j  partsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K	uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jT  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'parts = pattern.split("**/")h)j  u}(j  headj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#ja  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'0head = "/".join(path_parts[:i]) if i > 0 else ""h)j  u}(j  tailj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#jn  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'tail = "/".join(path_parts[i:])h)j  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'X  def match_glob_pattern(file_path: str, pattern: str) -> bool:
    """
    Check if file path matches a glob pattern with ** support.

    Uses fnmatch for single-segment wildcards, handles ** for multi-segment.

    Examples:
        >>> match_glob_pattern("src/generated/foo.py", "**/generated/**")
        True
        >>> match_glob_pattern("generated/foo.py", "**/generated/**")
        True
        >>> match_glob_pattern("src/core/calc.py", "**/generated/**")
        False
        >>> match_glob_pattern("src/core/data.py", "src/core/data.py")
        True
        >>> match_glob_pattern("src/core/calc.py", "src/core/*.py")
        True
        >>> match_glob_pattern("src/core/sub/calc.py", "src/core/*.py")
        False
        >>> match_glob_pattern("src/core/sub/calc.py", "src/core/**/*.py")
        True
    """
    file_path = file_path.replace("\\", "/")
    pattern = pattern.replace("\\", "/")
    if "**" not in pattern:
        if file_path.count("/") != pattern.count("/"):
            return False
        return fnmatch.fnmatch(file_path, pattern)
    path_parts = file_path.split("/")
    if pattern.startswith("**/") and pattern.endswith("/**"):
        middle = pattern[3:-3]
        if "/" not in middle and "*" not in middle:
            return middle in path_parts[:-1]
    if pattern.startswith("**/") and not pattern.endswith("/**"):
        suffix = pattern[3:]
        for i in range(len(path_parts)):
            if fnmatch.fnmatch("/".join(path_parts[i:]), suffix):
                return True
        return False
    if pattern.endswith("/**") and not pattern.startswith("**/"):
        prefix = pattern[:-3]
        return file_path.startswith(prefix + "/") or file_path == prefix
    parts = pattern.split("**/")
    if len(parts) == 2:
        prefix, suffix = parts[0].rstrip("/"), parts[1].lstrip("/").rstrip("/**")
        for i in range(len(path_parts) + 1):
            head = "/".join(path_parts[:i]) if i > 0 else ""
            tail = "/".join(path_parts[i:])
            if (not prefix or fnmatch.fnmatch(head, prefix)) and \
               (not suffix or fnmatch.fnmatch(tail, suffix) or fnmatch.fnmatch(tail, "*/" + suffix)):
                return True
    return Falseh)j  u}(j  get_excluded_rulesj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  	file_pathj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K%uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'0file_path: str, config: RuleConfig) -> set[str]:h)j}  u}(j  configj  K
j  }(j  }(j  Kj  K'uj  }(j  Kj  K9uuj  }(j  }(j  Kj  K'uj  }(j  Kj  K9uuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh' config: RuleConfig) -> set[str]:h)j}  u}(j  excludedj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'excluded: set[str] = set()h)j}  u}(j  	exclusionj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ]h}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'$exclusion in config.rule_exclusions:h)j}  ueh}(h!9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyh#j  h$2/Users/tefx/Projects/Invar/src/invar/core/utils.pyh&j  uh'X  @pre(lambda file_path, config: isinstance(config, RuleConfig))
def get_excluded_rules(file_path: str, config: RuleConfig) -> set[str]:
    """
    Get the set of rules to exclude for a given file path.

    Examples:
        >>> from invar.core.models import RuleConfig, RuleExclusion
        >>> excl = RuleExclusion(pattern="**/generated/**", rules=["*"])
        >>> cfg = RuleConfig(rule_exclusions=[excl])
        >>> get_excluded_rules("src/generated/foo.py", cfg)
        {'*'}
        >>> get_excluded_rules("src/core/calc.py", cfg)
        set()
        >>> excl2 = RuleExclusion(pattern="**/data/**", rules=["file_size"])
        >>> cfg2 = RuleConfig(rule_exclusions=[excl, excl2])
        >>> sorted(get_excluded_rules("src/data/big.py", cfg2))
        ['file_size']
    """
    excluded: set[str] = set()
    for exclusion in config.rule_exclusions:
        if match_glob_pattern(file_path, exclusion.pattern):
            excluded.update(exclusion.rules)
    return excludedh)j  ueh)j  u}(j  lambda_helpersj	  j  h#}(j  }(j  K j  K uj  }(j  K~j  K uuj  j  h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh& src/invar/core/lambda_helpers.pyuj  ](}(namefind_lambdakindKrange}(start}(lineK	characterK uend}(j  Kj  KOuuselectionRange}(j  }(j  Kj  Kuj  }(j  Kj  Kuuchildren]}(j  treej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K$uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K$uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh& src/invar/core/lambda_helpers.pyuh'+tree: ast.Expression) -> ast.Lambda | None:h)j  uah}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'X  def find_lambda(tree: ast.Expression) -> ast.Lambda | None:
    """Find the lambda node in an expression tree.

    Examples:
        >>> tree = ast.parse("lambda x: x > 0", mode="eval")
        >>> find_lambda(tree) is not None
        True
        >>> tree = ast.parse("x + y", mode="eval")
        >>> find_lambda(tree) is None
        True
    """
    return next((n for n in ast.walk(tree) if isinstance(n, ast.Lambda)), None)h)j  u}(j  extract_annotationsj  Kj  }(j  }(j  Kj  K uj  }(j  K.j  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  ](}(j  	signaturej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K&uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K&uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'"signature: str) -> dict[str, str]:h)j  u}(j  annotationsj  K
j  }(j  }(j  K#j  Kuj  }(j  K#j  Kuuj  }(j  }(j  K#j  Kuj  }(j  K#j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'annotations = {}h)j  u}(j  matchj  K
j  }(j  }(j  K$j  Kuj  }(j  K$j  K	uuj  }(j  }(j  K$j  Kuj  }(j  K$j  K	uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'+match = re.match(r"\(([^)]*)\)", signature)h)j  u}(j  paramj  K
j  }(j  }(j  K'j  Kuj  }(j  K'j  K
uuj  }(j  }(j  K'j  Kuj  }(j  K'j  K
uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'#param in match.group(1).split(","):h)j  u}(j  namej  K
j  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j+  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'&name, type_hint = param.split(": ", 1)h)j  u}(j  	type_hintj  K
j  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  }(j  }(j  K*j  Kuj  }(j  K*j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j8  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh' type_hint = param.split(": ", 1)h)j  ueh}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'Xz  def extract_annotations(signature: str) -> dict[str, str]:
    """Extract parameter type annotations from signature.

    Examples:
        >>> extract_annotations("(x: int, y: str) -> bool")
        {'x': 'int', 'y': 'str'}
        >>> extract_annotations("(items: list[int]) -> None")
        {'items': 'list[int]'}
        >>> extract_annotations("(x, y)")
        {}
    """
    if not signature or not signature.startswith("("):
        return {}
    annotations = {}
    match = re.match(r"\(([^)]*)\)", signature)
    if not match:
        return annotations
    for param in match.group(1).split(","):
        param = param.strip()
        if ": " in param:
            name, type_hint = param.split(": ", 1)
            if "=" in type_hint:
                type_hint = type_hint.split("=")[0].strip()
            annotations[name.strip()] = type_hint.strip()
    return annotationsh)j  u}(j  extract_lambda_paramsj  Kj  }(j  }(j  K1j  K uj  }(j  KCj  Kuuj  }(j  }(j  K1j  Kuj  }(j  K1j  Kuuj  ](}(j  
expressionj  K
j  }(j  }(j  K1j  Kuj  }(j  K1j  K)uuj  }(j  }(j  K1j  Kuj  }(j  K1j  K)uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#jR  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'%expression: str) -> list[str] | None:h)jG  u}(j  treej  K
j  }(j  }(j  K?j  Kuj  }(j  K?j  Kuuj  }(j  }(j  K?j  Kuj  }(j  K?j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j_  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh')tree = ast.parse(expression, mode="eval")h)jG  u}(j  lambda_nodej  K
j  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj  }(j  }(j  K@j  Kuj  }(j  K@j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#jl  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'lambda_node = find_lambda(tree)h)jG  ueh}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#jI  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'X  def extract_lambda_params(expression: str) -> list[str] | None:
    """Extract parameter names from a lambda expression.

    Examples:
        >>> extract_lambda_params("lambda x, y: x > 0")
        ['x', 'y']
        >>> extract_lambda_params("lambda: True")
        []
        >>> extract_lambda_params("not a lambda") is None
        True
    """
    if not expression.strip() or "lambda" not in expression:
        return None
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        return [arg.arg for arg in lambda_node.args.args] if lambda_node else None
    except SyntaxError:
        return Noneh)j  u}(j  extract_func_param_namesj  Kj  }(j  }(j  KFj  K uj  }(j  Kjj  Kuuj  }(j  }(j  KFj  Kuj  }(j  KFj  Kuuj  ](}(j  	signaturej  K
j  }(j  }(j  KFj  Kuj  }(j  KFj  K+uuj  }(j  }(j  KFj  Kuj  }(j  KFj  K+uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'$signature: str) -> list[str] | None:h)j{  u}(j  matchj  K
j  }(j  }(j  KSj  Kuj  }(j  KSj  K	uuj  }(j  }(j  KSj  Kuj  }(j  KSj  K	uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'+match = re.match(r"\(([^)]*)\)", signature)h)j{  u}(j  contentj  K
j  }(j  }(j  KVj  Kuj  }(j  KVj  Kuuj  }(j  }(j  KVj  Kuj  }(j  KVj  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh' content = match.group(1).strip()h)j{  u}(j  paramsj  K
j  }(j  }(j  KZj  Kuj  }(j  KZj  K
uuj  }(j  }(j  KZj  Kuj  }(j  KZj  K
uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'params = []h)j{  u}(j  currentj  K
j  }(j  }(j  K[j  Kuj  }(j  K[j  Kuuj  }(j  }(j  K[j  Kuj  }(j  K[j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'current = ""h)j{  u}(j  depthj  K
j  }(j  }(j  K\j  Kuj  }(j  K\j  K	uuj  }(j  }(j  K\j  Kuj  }(j  K\j  K	uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'	depth = 0h)j{  u}(j  charj  K
j  }(j  }(j  K]j  Kuj  }(j  K]j  Kuuj  }(j  }(j  K]j  Kuj  }(j  K]j  Kuuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'char in content:h)j{  ueh}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j}  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'X  def extract_func_param_names(signature: str) -> list[str] | None:
    """Extract parameter names from a function signature (handles nested brackets).

    Examples:
        >>> extract_func_param_names("(x: int, y: int) -> int")
        ['x', 'y']
        >>> extract_func_param_names("(items: dict[str, int]) -> None")
        ['items']
        >>> extract_func_param_names("() -> bool")
        []
    """
    if not signature or not signature.startswith("("):
        return None
    match = re.match(r"\(([^)]*)\)", signature)
    if not match:
        return None
    content = match.group(1).strip()
    if not content:
        return []
    # Split by comma, but respect brackets (for dict[K, V], tuple[A, B], etc.)
    params = []
    current = ""
    depth = 0
    for char in content:
        if char in "([{":
            depth += 1
        elif char in ")]}":
            depth -= 1
        elif char == "," and depth == 0:
            if current.strip():
                params.append(current.strip().split(":")[0].split("=")[0].strip())
            current = ""
            continue
        current += char
    if current.strip():
        params.append(current.strip().split(":")[0].split("=")[0].strip())
    return paramsh)j  u}(j  extract_used_namesj  Kj  }(j  }(j  Kmj  K uj  }(j  K|j  Kuuj  }(j  }(j  Kmj  Kuj  }(j  Kmj  Kuuj  ](}(j  nodej  K
j  }(j  }(j  Kmj  Kuj  }(j  Kmj  K%uuj  }(j  }(j  Kmj  Kuj  }(j  Kmj  K%uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'node: ast.expr) -> set[str]:h)j  u}(j  namesj  K
j  }(j  }(j  Kxj  Kuj  }(j  Kxj  K	uuj  }(j  }(j  Kxj  Kuj  }(j  Kxj  K	uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'names: set[str] = set()h)j  u}(j  childj  K
j  }(j  }(j  Kyj  Kuj  }(j  Kyj  K
uuj  }(j  }(j  Kyj  Kuj  }(j  Kyj  K
uuj  ]h}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'child in ast.walk(node):h)j  ueh}(h!Bfile:///Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh#j  h$;/Users/tefx/Projects/Invar/src/invar/core/lambda_helpers.pyh&j  uh'XK  def extract_used_names(node: ast.expr) -> set[str]:
    """Extract all variable names used in an expression (Load context).

    Examples:
        >>> tree = ast.parse("x + y", mode="eval")
        >>> sorted(extract_used_names(tree.body))
        ['x', 'y']
        >>> tree = ast.parse("len(items) > 0", mode="eval")
        >>> sorted(extract_used_names(tree.body))
        ['items', 'len']
    """
    names: set[str] = set()
    for child in ast.walk(node):
        if isinstance(child, ast.Name) and isinstance(child.ctx, ast.Load):
            names.add(child.id)
    return namesh)j  ueh)j  u}(j  	contractsj	  j  h#}(j  }(j  K j  K uj  }(j  Mj  K uuj  j  h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&src/invar/core/contracts.pyuj  ](}(nameis_empty_contractkindKrange}(start}(lineK	characterK uend}(j)  K"j*  KuuselectionRange}(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuchildren](}(j"  
expressionj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K%uuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K%uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j5  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&src/invar/core/contracts.pyuh'expression: str) -> bool:h)j!  u}(j"  treej$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jC  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh')tree = ast.parse(expression, mode="eval")h)j!  u}(j"  lambda_nodej$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jP  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'lambda_node = find_lambda(tree)h)j!  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j&  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X  @pre(lambda expression: "lambda" in expression or not expression.strip())
def is_empty_contract(expression: str) -> bool:
    """Check if a contract expression is always True (tautological).

    Examples:
        >>> is_empty_contract("lambda: True"), is_empty_contract("lambda x: True")
        (True, True)
        >>> is_empty_contract("lambda x: x > 0"), is_empty_contract("")
        (False, False)
    """
    if not expression.strip():
        return False
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        return lambda_node is not None and isinstance(lambda_node.body, ast.Constant) and lambda_node.body.value is True
    except SyntaxError:
        return Falseh)j  u}(j"  is_semantic_tautologyj$  Kj%  }(j'  }(j)  K(j*  K uj+  }(j)  KJj*  Kuuj-  }(j'  }(j)  K)j*  Kuj+  }(j)  K)j*  Kuuj1  ](}(j"  
expressionj$  K
j%  }(j'  }(j)  K)j*  Kuj+  }(j)  K)j*  K)uuj-  }(j'  }(j)  K)j*  Kuj+  }(j)  K)j*  K)uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jj  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'%expression: str) -> tuple[bool, str]:h)j_  u}(j"  treej$  K
j%  }(j'  }(j)  KDj*  Kuj+  }(j)  KDj*  Kuuj-  }(j'  }(j)  KDj*  Kuj+  }(j)  KDj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jw  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh')tree = ast.parse(expression, mode="eval")h)j_  u}(j"  lambda_nodej$  K
j%  }(j'  }(j)  KEj*  Kuj+  }(j)  KEj*  Kuuj-  }(j'  }(j)  KEj*  Kuj+  }(j)  KEj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'lambda_node = find_lambda(tree)h)j_  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#ja  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X{  @pre(lambda expression: "lambda" in expression or not expression.strip())
def is_semantic_tautology(expression: str) -> tuple[bool, str]:
    """Check if a contract expression is a semantic tautology.

    Returns (is_tautology, pattern_description).

    P7: Detects patterns that are always true:
    - x == x (identity comparison)
    - len(x) >= 0 (length always non-negative)
    - isinstance(x, object) (everything is object)
    - x or True (always true due to True)
    - True and x (simplifies but starts with True)

    Examples:
        >>> is_semantic_tautology("lambda x: x == x")
        (True, 'x == x is always True')
        >>> is_semantic_tautology("lambda x: len(x) >= 0")
        (True, 'len(x) >= 0 is always True for any sequence')
        >>> is_semantic_tautology("lambda x: isinstance(x, object)")
        (True, 'isinstance(x, object) is always True')
        >>> is_semantic_tautology("lambda x: x > 0")
        (False, '')
        >>> is_semantic_tautology("lambda x: x or True")
        (True, 'expression contains unconditional True')
    """
    if not expression.strip():
        return (False, "")
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        if lambda_node is None:
            return (False, "")
        return _check_tautology_patterns(lambda_node.body)
    except SyntaxError:
        return (False, "")h)j  u}(j"  _check_tautology_patternsj$  Kj%  }(j'  }(j)  KMj*  K uj+  }(j)  Ksj*  Kuuj-  }(j'  }(j)  KMj*  Kuj+  }(j)  KMj*  Kuuj1  ](}(j"  nodej$  K
j%  }(j'  }(j)  KMj*  Kuj+  }(j)  KMj*  K,uuj-  }(j'  }(j)  KMj*  Kuj+  }(j)  KMj*  K,uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'$node: ast.expr) -> tuple[bool, str]:h)j  u}(j"  leftj$  K
j%  }(j'  }(j)  KRj*  Kuj+  }(j)  KRj*  Kuuj-  }(j'  }(j)  KRj*  Kuj+  }(j)  KRj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'left = ast.unparse(node.left)h)j  u}(j"  rightj$  K
j%  }(j'  }(j)  KSj*  Kuj+  }(j)  KSj*  Kuuj-  }(j'  }(j)  KSj*  Kuj+  }(j)  KSj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'(right = ast.unparse(node.comparators[0])h)j  u}(j"  opj$  K
j%  }(j'  }(j)  K[j*  Kuj+  }(j)  K[j*  Kuuj-  }(j'  }(j)  K[j*  Kuj+  }(j)  K[j*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'op = node.ops[0]h)j  u}(j"  argj$  K
j%  }(j'  }(j)  Kaj*  Kuj+  }(j)  Kaj*  Kuuj-  }(j'  }(j)  Kaj*  Kuj+  }(j)  Kaj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'5arg = ast.unparse(left.args[0]) if left.args else "x"h)j  u}(j"  type_argj$  K
j%  }(j'  }(j)  Khj*  Kuj+  }(j)  Khj*  Kuuj-  }(j'  }(j)  Khj*  Kuj+  }(j)  Khj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'type_arg = node.args[1]h)j  u}(j"  valj$  K
j%  }(j'  }(j)  Koj*  Kuj+  }(j)  Koj*  Kuuj-  }(j'  }(j)  Koj*  Kuj+  }(j)  Koj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'val in node.values:h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Xj  def _check_tautology_patterns(node: ast.expr) -> tuple[bool, str]:
    """Check for common tautology patterns in AST node."""
    # Pattern: x == x (identity comparison)
    if isinstance(node, ast.Compare):
        if len(node.ops) == 1 and isinstance(node.ops[0], (ast.Eq, ast.Is)):
            left = ast.unparse(node.left)
            right = ast.unparse(node.comparators[0])
            if left == right:
                return (True, f"{left} == {right} is always True")

    # Pattern: len(x) >= 0 or len(x) > -1 (length always non-negative)
    if isinstance(node, ast.Compare):
        if len(node.ops) == 1 and len(node.comparators) == 1:
            left = node.left
            op = node.ops[0]
            right = node.comparators[0]
            # len(x) >= 0
            if (isinstance(left, ast.Call) and isinstance(left.func, ast.Name)
                    and left.func.id == "len" and isinstance(op, ast.GtE)
                    and isinstance(right, ast.Constant) and right.value == 0):
                arg = ast.unparse(left.args[0]) if left.args else "x"
                return (True, f"len({arg}) >= 0 is always True for any sequence")

    # Pattern: isinstance(x, object)
    if isinstance(node, ast.Call):
        if (isinstance(node.func, ast.Name) and node.func.id == "isinstance"
                and len(node.args) == 2):
            type_arg = node.args[1]
            if isinstance(type_arg, ast.Name) and type_arg.id == "object":
                arg = ast.unparse(node.args[0])
                return (True, f"isinstance({arg}, object) is always True")

    # Pattern: x or True, True or x (always true)
    if isinstance(node, ast.BoolOp) and isinstance(node.op, ast.Or):
        for val in node.values:
            if isinstance(val, ast.Constant) and val.value is True:
                return (True, "expression contains unconditional True")

    return (False, "")h)j  u}(j"  is_redundant_type_contractj$  Kj%  }(j'  }(j)  Kvj*  K uj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kwj*  Kuj+  }(j)  Kwj*  Kuuj1  ](}(j"  
expressionj$  K
j%  }(j'  }(j)  Kwj*  Kuj+  }(j)  Kwj*  K.uuj-  }(j'  }(j)  Kwj*  Kuj+  }(j)  Kwj*  K.uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'6expression: str, annotations: dict[str, str]) -> bool:h)j  u}(j"  annotationsj$  K
j%  }(j'  }(j)  Kwj*  K0uj+  }(j)  Kwj*  KKuuj-  }(j'  }(j)  Kwj*  K0uj+  }(j)  Kwj*  KKuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'%annotations: dict[str, str]) -> bool:h)j  u}(j"  treej$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh')tree = ast.parse(expression, mode="eval")h)j  u}(j"  lambda_nodej$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j-  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'lambda_node = find_lambda(tree)h)j  u}(j"  checksj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j:  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'5checks = _extract_isinstance_checks(lambda_node.body)h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X  @pre(lambda expression, annotations: "lambda" in expression or not expression.strip())
def is_redundant_type_contract(expression: str, annotations: dict[str, str]) -> bool:
    """Check if a contract only checks types already in annotations.

    Examples:
        >>> is_redundant_type_contract("lambda x: isinstance(x, int)", {"x": "int"})
        True
        >>> is_redundant_type_contract("lambda x: isinstance(x, int) and x > 0", {"x": "int"})
        False
    """
    if not expression.strip() or not annotations:
        return False
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        if lambda_node is None:
            return False
        checks = _extract_isinstance_checks(lambda_node.body)
        if checks is None:
            return False
        return all(p in annotations and _types_match(annotations[p], t) for p, t in checks)
    except SyntaxError:
        return Falseh)j  u}(j"  _extract_isinstance_checksj$  Kj%  }(j'  }(j)  Kj*  K uj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ](}(j"  nodej$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K-uuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K-uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jT  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'0node: ast.expr) -> list[tuple[str, str]] | None:h)jI  u}(j"  checkj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K
uuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K
uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#ja  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'$check = _parse_isinstance_call(node)h)jI  u}(j"  checksj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jn  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Tchecks = [_parse_isinstance_call(v) for v in node.values if isinstance(v, ast.Call)]h)jI  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jK  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X  def _extract_isinstance_checks(node: ast.expr) -> list[tuple[str, str]] | None:
    """Extract isinstance checks. Returns None if other logic present."""
    if isinstance(node, ast.Call):
        check = _parse_isinstance_call(node)
        return [check] if check else None
    if isinstance(node, ast.BoolOp) and isinstance(node.op, ast.And):
        checks = [_parse_isinstance_call(v) for v in node.values if isinstance(v, ast.Call)]
        return checks if len(checks) == len(node.values) and all(checks) else None
    return Noneh)j  u}(j"  _parse_isinstance_callj$  Kj%  }(j'  }(j)  Kj*  K uj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ](}(j"  nodej$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K)uuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K)uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'*node: ast.Call) -> tuple[str, str] | None:h)j}  u}(j"  paramj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K	uuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K	uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'/param, type_arg = node.args[0].id, node.args[1]h)j}  u}(j"  type_argj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'(type_arg = node.args[0].id, node.args[1]h)j}  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X,  def _parse_isinstance_call(node: ast.Call) -> tuple[str, str] | None:
    """Parse isinstance(x, Type) call. Returns (param, type) or None."""
    if not (isinstance(node.func, ast.Name) and node.func.id == "isinstance"):
        return None
    if len(node.args) != 2 or not isinstance(node.args[0], ast.Name):
        return None
    param, type_arg = node.args[0].id, node.args[1]
    if isinstance(type_arg, ast.Name):
        return (param, type_arg.id)
    if isinstance(type_arg, ast.Attribute):
        return (param, type_arg.attr)
    return Noneh)j  u}(j"  _types_matchj$  Kj%  }(j'  }(j)  Kj*  K uj+  }(j)  Kj*  K@uuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ](}(j"  
annotationj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K uuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh')annotation: str, type_name: str) -> bool:h)j  u}(j"  	type_namej$  K
j%  }(j'  }(j)  Kj*  K"uj+  }(j)  Kj*  K0uuj-  }(j'  }(j)  Kj*  K"uj+  }(j)  Kj*  K0uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'type_name: str) -> bool:h)j  u}(j"  
base_matchj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'.base_match = re.match(r"^(\w+)\[", annotation)h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X  def _types_match(annotation: str, type_name: str) -> bool:
    """Check if type annotation matches isinstance check.

    Examples:
        >>> _types_match("int", "int"), _types_match("list[int]", "list")
        (True, True)
    """
    if annotation == type_name:
        return True
    base_match = re.match(r"^(\w+)\[", annotation)
    return bool(base_match and base_match.group(1) == type_name)h)j  u}(j"  has_unused_paramsj$  Kj%  }(j'  }(j)  Kj*  K uj+  }(j)  Kj*  K?uuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ](}(j"  
expressionj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K%uuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K%uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Fexpression: str, signature: str) -> tuple[bool, list[str], list[str]]:h)j  u}(j"  	signaturej$  K
j%  }(j'  }(j)  Kj*  K'uj+  }(j)  Kj*  K5uuj-  }(j'  }(j)  Kj*  K'uj+  }(j)  Kj*  K5uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'5signature: str) -> tuple[bool, list[str], list[str]]:h)j  u}(j"  
lambda_paramsj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j
   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'1lambda_params = extract_lambda_params(expression)h)j  u}(j"  func_paramsj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'1func_params = extract_func_param_names(signature)h)j  u}(j"  treej$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j$   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh')tree = ast.parse(expression, mode="eval")h)j  u}(j"  lambda_nodej$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j1   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'lambda_node = find_lambda(tree)h)j  u}(j"  
used_namesj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j>   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'1used_names = extract_used_names(lambda_node.body)h)j  u}(j"  used_paramsj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jK   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh';used_params = [p for p in lambda_params if p in used_names]h)j  u}(j"  
unused_paramsj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jX   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Aunused_params = [p for p in lambda_params if p not in used_names]h)j  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X  @pre(lambda expression, signature: "lambda" in expression or not expression.strip())
def has_unused_params(expression: str, signature: str) -> tuple[bool, list[str], list[str]]:
    """
    Check if lambda has params it doesn't use (P28: Partial Contract Detection).

    Returns (has_unused, unused_params, used_params).

    Different from param_mismatch:
    - param_mismatch: lambda param COUNT != function param count (ERROR)
    - unused_params: lambda has all params but doesn't USE all (WARN)

    Examples:
        >>> has_unused_params("lambda x, y: x > 0", "(x: int, y: int) -> int")
        (True, ['y'], ['x'])
        >>> has_unused_params("lambda x, y: x > 0 and y < 10", "(x: int, y: int) -> int")
        (False, [], ['x', 'y'])
        >>> has_unused_params("lambda x: x > 0", "(x: int, y: int) -> int")
        (False, [], [])
        >>> has_unused_params("lambda items: len(items) > 0", "(items: list) -> int")
        (False, [], ['items'])
    """
    if not expression.strip() or not signature:
        return (False, [], [])

    lambda_params = extract_lambda_params(expression)
    func_params = extract_func_param_names(signature)

    if lambda_params is None or func_params is None:
        return (False, [], [])

    # Only check when lambda has same param count as function
    # (if different count, that's param_mismatch, not this check)
    if len(lambda_params) != len(func_params):
        return (False, [], [])

    # Extract used names from lambda body
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        if lambda_node is None:
            return (False, [], [])
        used_names = extract_used_names(lambda_node.body)
    except SyntaxError:
        return (False, [], [])

    # Check which params are actually used
    used_params = [p for p in lambda_params if p in used_names]
    unused_params = [p for p in lambda_params if p not in used_names]

    return (len(unused_params) > 0, unused_params, used_params)h)j  u}(j"  has_param_mismatchj$  Kj%  }(j'  }(j)  Kj*  K uj+  }(j)  M	j*  Kuuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  Kuuj1  ](}(j"  
expressionj$  K
j%  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K&uuj-  }(j'  }(j)  Kj*  Kuj+  }(j)  Kj*  K&uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jr   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'5expression: str, signature: str) -> tuple[bool, str]:h)jg   u}(j"  	signaturej$  K
j%  }(j'  }(j)  Kj*  K(uj+  }(j)  Kj*  K6uuj-  }(j'  }(j)  Kj*  K(uj+  }(j)  Kj*  K6uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'$signature: str) -> tuple[bool, str]:h)jg   u}(j"  
lambda_paramsj$  K
j%  }(j'  }(j)  M j*  Kuj+  }(j)  M j*  Kuuj-  }(j'  }(j)  M j*  Kuj+  }(j)  M j*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'1lambda_params = extract_lambda_params(expression)h)jg   u}(j"  func_paramsj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'1func_params = extract_func_param_names(signature)h)jg   ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#ji   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X  @pre(lambda expression, signature: "lambda" in expression or not expression.strip())
def has_param_mismatch(expression: str, signature: str) -> tuple[bool, str]:
    """
    Check if lambda params don't match function params.

    Returns (has_mismatch, error_description).

    Examples:
        >>> has_param_mismatch("lambda x: x > 0", "(x: int, y: int) -> int")
        (True, 'lambda has 1 param(s) but function has 2')
        >>> has_param_mismatch("lambda x, y: x > 0", "(x: int, y: int) -> int")
        (False, '')
        >>> has_param_mismatch("lambda x, y=0: x > 0", "(x: int, y: int = 0) -> int")
        (False, '')
        >>> has_param_mismatch("lambda: True", "() -> bool")
        (False, '')
    """
    if not expression.strip() or not signature:
        return (False, "")

    lambda_params = extract_lambda_params(expression)
    func_params = extract_func_param_names(signature)

    if lambda_params is None or func_params is None:
        return (False, "")  # Can't determine, skip

    if len(lambda_params) != len(func_params):
        return (True, f"lambda has {len(lambda_params)} param(s) but function has {len(func_params)}")

    return (False, "")h)j  u}(j"  check_empty_contractsj$  Kj%  }(j'  }(j)  Mj*  K uj+  }(j)  M(j*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ](}(j"  	file_infoj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  K-uuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  K-uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j   u}(j"  configj$  K
j%  }(j'  }(j)  Mj*  K/uj+  }(j)  Mj*  KAuuj-  }(j'  }(j)  Mj*  K/uj+  }(j)  Mj*  KAuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh''config: RuleConfig) -> list[Violation]:h)j   u}(j"  
violationsj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh' violations: list[Violation] = []h)j   u}(j"  symbolj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'symbol in file_info.symbols:h)j   u}(j"  contractj$  K
j%  }(j'  }(j)  M j*  Kuj+  }(j)  M j*  Kuuj-  }(j'  }(j)  M j*  Kuj+  }(j)  M j*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'contract in symbol.contracts:h)j   u}(j"  kindj$  K
j%  }(j'  }(j)  M"j*  Kuj+  }(j)  M"j*  Kuuj-  }(j'  }(j)  M"j*  Kuj+  }(j)  M"j*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j   ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j   h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_empty_contracts(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check for empty/tautological contracts. Core files only.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: True", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, contracts=[c])
        >>> check_empty_contracts(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())[0].rule
        'empty_contract'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            continue
        for contract in symbol.contracts:
            if is_empty_contract(contract.expression):
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(Violation(
                    rule="empty_contract", severity=Severity.WARNING, file=file_info.path, line=contract.line,
                    message=f"{kind} '{symbol.name}' has empty contract: @{contract.kind}({contract.expression})",
                    suggestion=format_suggestion_for_violation(symbol, "empty_contract"),
                ))
    return violationsh)j  u}(j"  check_semantic_tautologyj$  Kj%  }(j'  }(j)  M+j*  K uj+  }(j)  MIj*  Kuuj-  }(j'  }(j)  M,j*  Kuj+  }(j)  M,j*  Kuuj1  ](}(j"  	file_infoj$  K
j%  }(j'  }(j)  M,j*  Kuj+  }(j)  M,j*  K0uuj-  }(j'  }(j)  M,j*  Kuj+  }(j)  M,j*  K0uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j!  u}(j"  configj$  K
j%  }(j'  }(j)  M,j*  K2uj+  }(j)  M,j*  KDuuj-  }(j'  }(j)  M,j*  K2uj+  }(j)  M,j*  KDuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh''config: RuleConfig) -> list[Violation]:h)j!  u}(j"  
violationsj$  K
j%  }(j'  }(j)  M:j*  Kuj+  }(j)  M:j*  Kuuj-  }(j'  }(j)  M:j*  Kuj+  }(j)  M:j*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j(!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh' violations: list[Violation] = []h)j!  u}(j"  symbolj$  K
j%  }(j'  }(j)  M=j*  Kuj+  }(j)  M=j*  Kuuj-  }(j'  }(j)  M=j*  Kuj+  }(j)  M=j*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j5!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'symbol in file_info.symbols:h)j!  u}(j"  contractj$  K
j%  }(j'  }(j)  M@j*  Kuj+  }(j)  M@j*  Kuuj-  }(j'  }(j)  M@j*  Kuj+  }(j)  M@j*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jB!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'contract in symbol.contracts:h)j!  u}(j"  is_tautologyj$  K
j%  }(j'  }(j)  MAj*  Kuj+  }(j)  MAj*  Kuuj-  }(j'  }(j)  MAj*  Kuj+  }(j)  MAj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jO!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Gis_tautology, pattern_desc = is_semantic_tautology(contract.expression)h)j!  u}(j"  pattern_descj$  K
j%  }(j'  }(j)  MAj*  Kuj+  }(j)  MAj*  K&uuj-  }(j'  }(j)  MAj*  Kuj+  }(j)  MAj*  K&uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j\!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'9pattern_desc = is_semantic_tautology(contract.expression)h)j!  u}(j"  kindj$  K
j%  }(j'  }(j)  MCj*  Kuj+  }(j)  MCj*  Kuuj-  }(j'  }(j)  MCj*  Kuj+  }(j)  MCj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#ji!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j!  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X{  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_semantic_tautology(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check for semantic tautology contracts. Core files only.

    P7: Detects contracts that are always true due to semantic patterns:
    - x == x, len(x) >= 0, isinstance(x, object), x or True

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: x == x", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, contracts=[c])
        >>> vs = check_semantic_tautology(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())
        >>> vs[0].rule
        'semantic_tautology'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            continue
        for contract in symbol.contracts:
            is_tautology, pattern_desc = is_semantic_tautology(contract.expression)
            if is_tautology:
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(Violation(
                    rule="semantic_tautology", severity=Severity.WARNING, file=file_info.path, line=contract.line,
                    message=f"{kind} '{symbol.name}' has tautological contract: {pattern_desc}",
                    suggestion=format_suggestion_for_violation(symbol, "semantic_tautology"),
                ))
    return violationsh)j  u}(j"  check_redundant_type_contractsj$  Kj%  }(j'  }(j)  MLj*  K uj+  }(j)  Mhj*  Kuuj-  }(j'  }(j)  MMj*  Kuj+  }(j)  MMj*  K"uuj1  ](}(j"  	file_infoj$  K
j%  }(j'  }(j)  MMj*  K#uj+  }(j)  MMj*  K6uuj-  }(j'  }(j)  MMj*  K#uj+  }(j)  MMj*  K6uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)jx!  u}(j"  configj$  K
j%  }(j'  }(j)  MMj*  K8uj+  }(j)  MMj*  KJuuj-  }(j'  }(j)  MMj*  K8uj+  }(j)  MMj*  KJuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh''config: RuleConfig) -> list[Violation]:h)jx!  u}(j"  
violationsj$  K
j%  }(j'  }(j)  MWj*  Kuj+  }(j)  MWj*  Kuuj-  }(j'  }(j)  MWj*  Kuj+  }(j)  MWj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh' violations: list[Violation] = []h)jx!  u}(j"  symbolj$  K
j%  }(j'  }(j)  MZj*  Kuj+  }(j)  MZj*  Kuuj-  }(j'  }(j)  MZj*  Kuj+  }(j)  MZj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'symbol in file_info.symbols:h)jx!  u}(j"  annotationsj$  K
j%  }(j'  }(j)  M]j*  Kuj+  }(j)  M]j*  Kuuj-  }(j'  }(j)  M]j*  Kuj+  }(j)  M]j*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'3annotations = extract_annotations(symbol.signature)h)jx!  u}(j"  contractj$  K
j%  }(j'  }(j)  M`j*  Kuj+  }(j)  M`j*  Kuuj-  }(j'  }(j)  M`j*  Kuj+  }(j)  M`j*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'contract in symbol.contracts:h)jx!  u}(j"  kindj$  K
j%  }(j'  }(j)  Mbj*  Kuj+  }(j)  Mbj*  Kuuj-  }(j'  }(j)  Mbj*  Kuj+  }(j)  Mbj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)jx!  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jz!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_redundant_type_contracts(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check for contracts that only check types in annotations. Core files only. INFO severity.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: isinstance(x, int)", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, signature="(x: int) -> int", contracts=[c])
        >>> check_redundant_type_contracts(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())[0].severity.value
        'info'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            continue
        annotations = extract_annotations(symbol.signature)
        if not annotations:
            continue
        for contract in symbol.contracts:
            if is_redundant_type_contract(contract.expression, annotations):
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(Violation(
                    rule="redundant_type_contract", severity=Severity.INFO, file=file_info.path, line=contract.line,
                    message=f"{kind} '{symbol.name}' contract only checks types already in annotations",
                    suggestion=format_suggestion_for_violation(symbol, "redundant_type_contract"),
                ))
    return violationsh)j  u}(j"  check_param_mismatchj$  Kj%  }(j'  }(j)  Mkj*  K uj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mlj*  Kuj+  }(j)  Mlj*  Kuuj1  ](}(j"  	file_infoj$  K
j%  }(j'  }(j)  Mlj*  Kuj+  }(j)  Mlj*  K,uuj-  }(j'  }(j)  Mlj*  Kuj+  }(j)  Mlj*  K,uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)j!  u}(j"  configj$  K
j%  }(j'  }(j)  Mlj*  K.uj+  }(j)  Mlj*  K@uuj-  }(j'  }(j)  Mlj*  K.uj+  }(j)  Mlj*  K@uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh''config: RuleConfig) -> list[Violation]:h)j!  u}(j"  
violationsj$  K
j%  }(j'  }(j)  Mxj*  Kuj+  }(j)  Mxj*  Kuuj-  }(j'  }(j)  Mxj*  Kuj+  }(j)  Mxj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh' violations: list[Violation] = []h)j!  u}(j"  symbolj$  K
j%  }(j'  }(j)  M{j*  Kuj+  }(j)  M{j*  Kuuj-  }(j'  }(j)  M{j*  Kuj+  }(j)  M{j*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'symbol in file_info.symbols:h)j!  u}(j"  contractj$  K
j%  }(j'  }(j)  M~j*  Kuj+  }(j)  M~j*  Kuuj-  }(j'  }(j)  M~j*  Kuj+  }(j)  M~j*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'contract in symbol.contracts:h)j!  u}(j"  mismatchj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.py      h#j,"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Jmismatch, desc = has_param_mismatch(contract.expression, symbol.signature)h)j!  u}(j"  descj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j9"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'@desc = has_param_mismatch(contract.expression, symbol.signature)h)j!  u}(j"  kindj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jF"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)j!  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j!  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_param_mismatch(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check @pre lambda params match function params. Core files only. ERROR severity.

    Only checks @pre contracts (@post takes 'result' param, different signature).

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: x > 0", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, signature="(x: int, y: int) -> int", contracts=[c])
        >>> check_param_mismatch(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())[0].rule
        'param_mismatch'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD) or not symbol.signature:
            continue
        for contract in symbol.contracts:
            # Only check @pre contracts (not @post which takes 'result')
            if contract.kind != "pre":
                continue
            mismatch, desc = has_param_mismatch(contract.expression, symbol.signature)
            if mismatch:
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(Violation(
                    rule="param_mismatch", severity=Severity.ERROR, file=file_info.path, line=contract.line,
                    message=f"{kind} '{symbol.name}' @pre {desc}",
                    suggestion="Lambda must include ALL function parameters",
                ))
    return violationsh)j  u}(j"  check_partial_contractj$  Kj%  }(j'  }(j)  Mj*  K uj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ](}(j"  	file_infoj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  K.uuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  K.uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j`"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'<file_info: FileInfo, config: RuleConfig) -> list[Violation]:h)jU"  u}(j"  configj$  K
j%  }(j'  }(j)  Mj*  K0uj+  }(j)  Mj*  KBuuj-  }(j'  }(j)  Mj*  K0uj+  }(j)  Mj*  KBuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jm"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh''config: RuleConfig) -> list[Violation]:h)jU"  u}(j"  
violationsj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jz"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh' violations: list[Violation] = []h)jU"  u}(j"  symbolj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'symbol in file_info.symbols:h)jU"  u}(j"  contractj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'contract in symbol.contracts:h)jU"  u}(j"  
has_unusedj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Shas_unused, unused, used = has_unused_params(contract.expression, symbol.signature)h)jU"  u}(j"  unusedj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Gunused, used = has_unused_params(contract.expression, symbol.signature)h)jU"  u}(j"  usedj$  K
j%  }(j'  }(j)  Mj*  K uj+  }(j)  Mj*  K$uuj-  }(j'  }(j)  Mj*  K uj+  }(j)  Mj*  K$uuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'?used = has_unused_params(contract.expression, symbol.signature)h)jU"  u}(j"  kindj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"h)jU"  u}(j"  
unused_strj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'0unused_str = ", ".join(f"'{p}'" for p in unused)h)jU"  u}(j"  used_strj$  K
j%  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj-  }(j'  }(j)  Mj*  Kuj+  }(j)  Mj*  Kuuj1  ]h}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#j"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'@used_str = ", ".join(f"'{p}'" for p in used) if used else "none"h)jU"  ueh}(h!=file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyh#jW"  h$6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyh&j?  uh'X	  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_partial_contract(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check @pre contracts that don't use all declared params (P28). Core files only. WARN severity.

    P28: Detects hidden formal compliance - lambda declares all params but doesn't use all.
    Forces Agent to think about whether unchecked params need constraints.

    Different from param_mismatch (P8.3):
    - param_mismatch: lambda param COUNT != function param count (ERROR)
    - partial_contract: lambda has all params but doesn't USE all (WARN)

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x, y: x > 0", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, signature="(x: int, y: int) -> int", contracts=[c])
        >>> vs = check_partial_contract(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())
        >>> vs[0].rule
        'partial_contract'
        >>> vs[0].severity
        <Severity.WARNING: 'warning'>
        >>> "y" in vs[0].message
        True
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD) or not symbol.signature:
            continue
        for contract in symbol.contracts:
            # Only check @pre contracts (not @post which takes 'result')
            if contract.kind != "pre":
                continue
            has_unused, unused, used = has_unused_params(contract.expression, symbol.signature)
            if has_unused:
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                unused_str = ", ".join(f"'{p}'" for p in unused)
                used_str = ", ".join(f"'{p}'" for p in used) if used else "none"
                violations.append(Violation(
                    rule="partial_contract",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=contract.line,
                    message=f"{kind} '{symbol.name}' @pre checks {used_str} but not {unused_str}",
                    suggestion=f"Signature: {symbol.signature}\n→ Add constraint for {unused_str} or verify it needs none",
                ))
    return violationsh)j  ueh)j  ueuuu}(j  generate_contract_suggestionj  Kj  }(j  }(j  K$j  K uj  }(j  KOj  K:uuj  }(j  }(j  K%j  Kuj  }(j  K%j  K uuj   ](}(j  	signaturej  K
j  }(j  }(j  K%j  K!uj  }(j  K%j  K/uuj  }(j  }(j  K%j  K!uj  }(j  K%j  K/uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j"  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'signature: str) -> str:h)j"  u}(j  paramsj  K
j  }(j  }(j  K:j  Kuj  }(j  K:j  K
uuj  }(j  }(j  K:j  Kuj  }(j  K:j  K
uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j	#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'#params = _extract_params(signature)h)j"  u}(j  constraintsj  K
j  }(j  }(j  K>j  Kuj  }(j  K>j  Kuuj  }(j  }(j  K>j  Kuj  }(j  K>j  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'constraints = []h)j"  u}(j  param_namesj  K
j  }(j  }(j  K?j  Kuj  }(j  K?j  Kuuj  }(j  }(j  K?j  Kuj  }(j  K?j  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j##  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'param_names = []h)j"  u}(j  namej  K
j  }(j  }(j  KAj  Kuj  }(j  KAj  Kuuj  }(j  }(j  KAj  Kuj  }(j  KAj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j0#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'name, type_hint in params:h)j"  u}(j  	type_hintj  K
j  }(j  }(j  KAj  Kuj  }(j  KAj  Kuuj  }(j  }(j  KAj  Kuj  }(j  KAj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j=#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'type_hint in params:h)j"  u}(j  
constraintj  K
j  }(j  }(j  KFj  Kuj  }(j  KFj  Kuuj  }(j  }(j  KFj  Kuj  }(j  KFj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jJ#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'1constraint = _suggest_constraint(name, type_hint)h)j"  u}(j  
params_strj  K
j  }(j  }(j  KMj  Kuj  }(j  KMj  Kuuj  }(j  }(j  KMj  Kuj  }(j  KMj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jW#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'#params_str = ", ".join(param_names)h)j"  u}(j  constraints_strj  K
j  }(j  }(j  KNj  Kuj  }(j  KNj  Kuuj  }(j  }(j  KNj  Kuj  }(j  KNj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jd#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'+constraints_str = " and ".join(constraints)h)j"  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j"  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'X  @pre(lambda signature: signature.startswith("(") or signature == "")
def generate_contract_suggestion(signature: str) -> str:
    """
    Generate a suggested @pre contract based on function signature.

    Uses common patterns:
    - int/float: param >= 0
    - str/list/dict/set/tuple: len(param) > 0
    - Optional/None union: param is not None

    Examples:
        >>> generate_contract_suggestion("(x: int, y: int) -> int")
        '@pre(lambda x, y: x >= 0 and y >= 0)'
        >>> generate_contract_suggestion("(name: str) -> bool")
        '@pre(lambda name: len(name) > 0)'
        >>> generate_contract_suggestion("(items: list[int]) -> int")
        '@pre(lambda items: len(items) > 0)'
        >>> generate_contract_suggestion("(x, y)")
        ''
        >>> generate_contract_suggestion("(value: Optional[str]) -> str")
        '@pre(lambda value: value is not None)'
    """
    params = _extract_params(signature)
    if not params:
        return ""

    constraints = []
    param_names = []

    for name, type_hint in params:
        param_names.append(name)
        if not type_hint:
            continue

        constraint = _suggest_constraint(name, type_hint)
        if constraint:
            constraints.append(constraint)

    if not constraints:
        return ""

    params_str = ", ".join(param_names)
    constraints_str = " and ".join(constraints)
    return f"@pre(lambda {params_str}: {constraints_str})"h)j  u}(j  _extract_paramsj  Kj  }(j  }(j  KRj  K uj  }(j  Kxj  Kuuj  }(j  }(j  KSj  Kuj  }(j  KSj  Kuuj   ](}(j  	signaturej  K
j  }(j  }(j  KSj  Kuj  }(j  KSj  K"uuj  }(j  }(j  KSj  Kuj  }(j  KSj  K"uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j~#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'0signature: str) -> list[tuple[str, str | None]]:h)js#  u}(j  matchj  K
j  }(j  }(j  Kbj  Kuj  }(j  Kbj  K	uuj  }(j  }(j  Kbj  Kuj  }(j  Kbj  K	uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'+match = re.match(r"\(([^)]*)\)", signature)h)js#  u}(j  paramsj  K
j  }(j  }(j  Kfj  Kuj  }(j  Kfj  K
uuj  }(j  }(j  Kfj  Kuj  }(j  Kfj  K
uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'params = []h)js#  u}(j  paramj  K
j  }(j  }(j  Kgj  Kuj  }(j  Kgj  K
uuj  }(j  }(j  Kgj  Kuj  }(j  Kgj  K
uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'#param in match.group(1).split(","):h)js#  u}(j  namej  K
j  }(j  }(j  Kmj  Kuj  }(j  Kmj  Kuuj  }(j  }(j  Kmj  Kuj  }(j  Kmj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'&name, type_hint = param.split(": ", 1)h)js#  u}(j  	type_hintj  K
j  }(j  }(j  Kmj  Kuj  }(j  Kmj  Kuuj  }(j  }(j  Kmj  Kuj  }(j  Kmj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh' type_hint = param.split(": ", 1)h)js#  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#ju#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'X  @pre(lambda signature: signature.startswith("(") or signature == "")
def _extract_params(signature: str) -> list[tuple[str, str | None]]:
    """
    Extract parameters and their types from a signature.

    Examples:
        >>> _extract_params("(x: int, y: str) -> bool")
        [('x', 'int'), ('y', 'str')]
        >>> _extract_params("(x, y)")
        [('x', None), ('y', None)]
        >>> _extract_params("(items: list[int], n: int = 10) -> list")
        [('items', 'list[int]'), ('n', 'int')]
    """
    if not signature:
        return []

    match = re.match(r"\(([^)]*)\)", signature)
    if not match:
        return []

    params = []
    for param in match.group(1).split(","):
        param = param.strip()
        if not param:
            continue

        if ": " in param:
            name, type_hint = param.split(": ", 1)
            # Handle default values
            if "=" in type_hint:
                type_hint = type_hint.split("=")[0].strip()
            params.append((name.strip(), type_hint.strip()))
        else:
            # No type annotation
            if "=" in param:
                param = param.split("=")[0].strip()
            params.append((param, None))

    return paramsh)j  u}(j  _suggest_constraintj  Kj  }(j  }(j  K{j  K uj  }(j  Kj  Kuuj  }(j  }(j  K|j  Kuj  }(j  K|j  Kuuj   ](}(j  namej  K
j  }(j  }(j  K|j  Kuj  }(j  K|j  K!uuj  }(j  }(j  K|j  Kuj  }(j  K|j  K!uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh')name: str, type_hint: str) -> str | None:h)j#  u}(j  	type_hintj  K
j  }(j  }(j  K|j  K#uj  }(j  K|j  K1uuj  }(j  }(j  K|j  K#uj  }(j  K|j  K1uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'type_hint: str) -> str | None:h)j#  u}(j  
base_matchj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'=base_match = re.match(r"^(list|dict|set|tuple)\[", type_hint)h)j#  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j#  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'X  @pre(lambda name, type_hint: len(name) > 0 and len(type_hint) > 0)
def _suggest_constraint(name: str, type_hint: str) -> str | None:
    """
    Suggest a constraint for a parameter based on its type.

    Examples:
        >>> _suggest_constraint("x", "int")
        'x >= 0'
        >>> _suggest_constraint("name", "str")
        'len(name) > 0'
        >>> _suggest_constraint("items", "list[str]")
        'len(items) > 0'
        >>> _suggest_constraint("value", "Optional[int]")
        'value is not None'
        >>> _suggest_constraint("x", "SomeCustomType")
    """
    # Numeric types: suggest non-negative
    if type_hint in ("int", "float"):
        return f"{name} >= 0"

    # Collection types: suggest non-empty
    if type_hint in ("str", "list", "dict", "set", "tuple", "bytes"):
        return f"len({name}) > 0"

    # Generic collections: list[X], dict[K, V], etc.
    base_match = re.match(r"^(list|dict|set|tuple)\[", type_hint)
    if base_match:
        return f"len({name}) > 0"

    # Optional types: suggest not None
    if type_hint.startswith("Optional[") or " | None" in type_hint or "None |" in type_hint:
        return f"{name} is not None"

    return Noneh)j  u}(j  _get_pattern_alternativesj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ](}(j  namej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K'uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K'uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j
$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'(name: str, type_hint: str) -> list[str]:h)j$  u}(j  	type_hintj  K
j  }(j  }(j  Kj  K)uj  }(j  Kj  K7uuj  }(j  }(j  Kj  K)uj  }(j  Kj  K7uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'type_hint: str) -> list[str]:h)j$  u}(j  
base_matchj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j'$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'=base_match = re.match(r"^(list|dict|set|tuple)\[", type_hint)h)j$  u}(j  	base_typej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j4$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'base_type = base_match.group(1)h)j$  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'X#  @pre(lambda name, type_hint: len(name) > 0 and len(type_hint) > 0)
def _get_pattern_alternatives(name: str, type_hint: str) -> list[str]:
    """
    Get multiple constraint pattern alternatives for a parameter (P27).

    Returns up to 3 common patterns for the type.

    Examples:
        >>> _get_pattern_alternatives("x", "int")
        ['x >= 0', 'x > 0', 'x != 0']
        >>> _get_pattern_alternatives("name", "str")
        ['len(name) > 0', 'name', 'name.strip()']
        >>> _get_pattern_alternatives("value", "Optional[int]")
        ['value is not None', 'value']
        >>> _get_pattern_alternatives("x", "CustomType")
        []
    """
    # Check exact type matches
    if type_hint in CONSTRAINT_PATTERNS:
        return [p.format(name=name) for p in CONSTRAINT_PATTERNS[type_hint]]

    # Generic collections: list[X], dict[K, V], etc.
    base_match = re.match(r"^(list|dict|set|tuple)\[", type_hint)
    if base_match:
        base_type = base_match.group(1)
        if base_type in CONSTRAINT_PATTERNS:
            return [p.format(name=name) for p in CONSTRAINT_PATTERNS[base_type]]

    # Optional types
    if type_hint.startswith("Optional[") or " | None" in type_hint or "None |" in type_hint:
        return [p.format(name=name) for p in CONSTRAINT_PATTERNS["Optional"]]

    return []h)j  u}(j  generate_pattern_optionsj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  K1uuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ](}(j  	signaturej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K+uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K+uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jN$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'signature: str) -> str:h)jC$  u}(j  paramsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j[$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'#params = _extract_params(signature)h)jC$  u}(j  all_patternsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jh$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'all_patterns: list[str] = []h)jC$  u}(j  namej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#ju$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'name, type_hint in params:h)jC$  u}(j  	type_hintj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'type_hint in params:h)jC$  u}(j  patternsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'5patterns = _get_pattern_alternatives(name, type_hint)h)jC$  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#jE$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'X  @pre(lambda signature: signature.startswith("(") or signature == "")
def generate_pattern_options(signature: str) -> str:
    """
    Generate multiple constraint pattern options for each parameter (P27).

    Returns a formatted string showing alternatives for each typed parameter.

    Examples:
        >>> generate_pattern_options("(x: int, y: str) -> int")
        'Patterns: x >= 0 | x > 0 | x != 0, len(y) > 0 | y | y.strip()'
        >>> generate_pattern_options("(data, config)")
        ''
    """
    params = _extract_params(signature)
    if not params:
        return ""

    all_patterns: list[str] = []
    for name, type_hint in params:
        if not type_hint:
            continue
        patterns = _get_pattern_alternatives(name, type_hint)
        if patterns:
            all_patterns.append(" | ".join(patterns))

    if not all_patterns:
        return ""

    return f"Patterns: {', '.join(all_patterns)}"h)j  u}(j  _generate_lambda_skeletonj  Kj  }(j  }(j  Kj  K uj  }(j  Kj  KYuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ](}(j  	signaturej  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K,uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K,uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'signature: str) -> str:h)j$  u}(j  paramsj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K
uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'#params = _extract_params(signature)h)j$  u}(j  param_namesj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'*param_names = [name for name, _ in params]h)j$  u}(j  
params_strj  K
j  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj  }(j  }(j  Kj  Kuj  }(j  Kj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'#params_str = ", ".join(param_names)h)j$  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'X{  def _generate_lambda_skeleton(signature: str) -> str:
    """
    Generate a lambda skeleton from function signature (P4).

    Returns skeleton with parameters extracted, condition placeholder.

    Examples:
        >>> _generate_lambda_skeleton("(x: int, y: int) -> int")
        '@pre(lambda x, y: <condition>) or @post(lambda result: <condition>)'
        >>> _generate_lambda_skeleton("(items: list) -> None")
        '@pre(lambda items: <condition>) or @post(lambda result: <condition>)'
        >>> _generate_lambda_skeleton("() -> int")
        '@post(lambda result: <condition>)'
    """
    params = _extract_params(signature)
    param_names = [name for name, _ in params]

    if not param_names:
        return "@post(lambda result: <condition>)"

    params_str = ", ".join(param_names)
    return f"@pre(lambda {params_str}: <condition>) or @post(lambda result: <condition>)"h)j  u}(j  format_suggestion_for_violationj  Kj  }(j  }(j  Kj  K uj  }(j  MBj  K
uuj  }(j  }(j  Kj  Kuj  }(j  Kj  K#uuj   ](}(j  symbolj  K
j  }(j  }(j  Kj  K$uj  }(j  Kj  K2uuj  }(j  }(j  Kj  K$uj  }(j  Kj  K2uuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh',symbol: Symbol, violation_type: str) -> str:h)j$  u}(j  violation_typej  K
j  }(j  }(j  Kj  K4uj  }(j  Kj  KGuuj  }(j  }(j  Kj  K4uj  }(j  Kj  KGuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'violation_type: str) -> str:h)j$  u}(j  patternsj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j%  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'5patterns = generate_pattern_options(symbol.signature)h)j$  u}(j  
suggestionj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j%  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh';suggestion = generate_contract_suggestion(symbol.signature)h)j$  u}(j  resultj  K
j  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj  }(j  }(j  Mj  Kuj  }(j  Mj  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j%  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'result = f"Add: {suggestion}"h)j$  u}(j  skeletonj  K
j  }(j  }(j  M j  Kuj  }(j  M j  Kuuj  }(j  }(j  M j  Kuj  }(j  M j  Kuuj   ]h}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j+%  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'6skeleton = _generate_lambda_skeleton(symbol.signature)h)j$  ueh}(h!?file:///Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh#j$  h$8/Users/tefx/Projects/Invar/src/invar/core/suggestions.pyh&j  uh'X  @pre(lambda symbol, violation_type: violation_type in ("missing_contract", "empty_contract", "redundant_type_contract", "semantic_tautology", ""))
def format_suggestion_for_violation(symbol: Symbol, violation_type: str) -> str:
    """
    Format a complete suggestion message for a violation.

    Phase 9.2 P4: Generate lambda skeletons when no type-based suggestion available.
    P7: Added semantic_tautology support.
    P27: Show pattern alternatives (Guard provides options, Agent decides).

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind
        >>> sym = Symbol(name="calc", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     signature="(x: int, y: int) -> int")
        >>> msg = format_suggestion_for_violation(sym, "missing_contract")
        >>> "@pre(lambda x, y: x >= 0 and y >= 0)" in msg
        True
        >>> "Patterns:" in msg  # P27: shows alternatives
        True
        >>> # P4: skeleton when no type-based suggestion
        >>> sym2 = Symbol(name="process", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     signature="(data, config)")
        >>> msg2 = format_suggestion_for_violation(sym2, "missing_contract")
        >>> "@pre(lambda data, config: <condition>)" in msg2
        True
    """
    if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD):
        return ""

    # P27: Get pattern alternatives
    patterns = generate_pattern_options(symbol.signature)

    if violation_type == "missing_contract":
        suggestion = generate_contract_suggestion(symbol.signature)
        if suggestion:
            result = f"Add: {suggestion}"
            if patterns:
                result += f"\n{patterns}"
            return result
        # P4: Generate lambda skeleton when no type-based suggestion
        skeleton = _generate_lambda_skeleton(symbol.signature)
        return f"Add: {skeleton}"

    if violation_type == "empty_contract":
        suggestion = generate_contract_suggestion(symbol.signature)
        if suggestion:
            result = f"Replace with: {suggestion}"
            if patterns:
                result += f"\n{patterns}"
            return result
        skeleton = _generate_lambda_skeleton(symbol.signature)
        return f"Replace with: {skeleton}"

    if violation_type == "redundant_type_contract":
        suggestion = generate_contract_suggestion(symbol.signature)
        if suggestion:
            result = f"Replace with business logic: {suggestion}"
            if patterns:
                result += f"\n{patterns}"
            return result
        skeleton = _generate_lambda_skeleton(symbol.signature)
        return f"Replace with: {skeleton}"

    if violation_type == "semantic_tautology":
        # P7: Semantic tautology - suggest meaningful constraint
        suggestion = generate_contract_suggestion(symbol.signature)
        if suggestion:
            result = f"Replace tautology with meaningful constraint: {suggestion}"
            if patterns:
                result += f"\n{patterns}"
            return result
        skeleton = _generate_lambda_skeleton(symbol.signature)
        return f"Replace tautology with: {skeleton}"

    return ""h)j  ueja  Nubj   adfd023d6277b1597b247263af1ef55ah)}(h](}(name
SymbolKindkindKrange}(start}(lineK	characterK uend}(jG%  KjH%  KuuselectionRange}(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  Kuuchildren](}(j@%  FUNCTIONjB%  KjC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jS%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  src/invar/core/models.pyuj  FUNCTION = "function"j  j?%  u}(j@%  CLASSjB%  KjC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  K	uujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  K	uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  ja%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  CLASS = "class"j  j?%  u}(j@%  METHODjB%  KjC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  K
uujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  K
uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jn%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  METHOD = "method"j  j?%  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jD%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  class SymbolKind(str, Enum):
    """Kind of symbol extracted from Python code."""

    FUNCTION = "function"
    CLASS = "class"
    METHOD = "method"j  Nu}(j@%  SeverityjB%  KjC%  }(jE%  }(jG%  KjH%  K ujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ](}(j@%  ERRORjB%  KjC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  K	uujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  K	uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  ERROR = "error"j  j}%  u}(j@%  WARNINGjB%  KjC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  WARNING = "warning"j  j}%  u}(j@%  INFOjB%  KjC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  PINFO = "info"  # Phase 7: For informational issues like redundant type contractsj  j}%  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  class Severity(str, Enum):
    """Severity level for violations."""

    ERROR = "error"
    WARNING = "warning"
    INFO = "info"  # Phase 7: For informational issues like redundant type contractsj  Nu}(j@%  ContractjB%  KjC%  }(jE%  }(jG%  K jH%  K ujI%  }(jG%  K%jH%  K
uujK%  }(jE%  }(jG%  K jH%  KujI%  }(jG%  K jH%  KuujO%  ](}(j@%  kindjB%  K
jC%  }(jE%  }(jG%  K#jH%  KujI%  }(jG%  K#jH%  KuujK%  }(jE%  }(jG%  K#jH%  KujI%  }(jG%  K#jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  kind: Literal["pre", "post"]j  j%  u}(j@%  
expressionjB%  K
jC%  }(jE%  }(jG%  K$jH%  KujI%  }(jG%  K$jH%  KuujK%  }(jE%  }(jG%  K$jH%  KujI%  }(jG%  K$jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  expression: strj  j%  u}(j@%  linejB%  K
jC%  }(jE%  }(jG%  K%jH%  KujI%  }(jG%  K%jH%  KuujK%  }(jE%  }(jG%  K%jH%  KujI%  }(jG%  K%jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  	line: intj  j%  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  class Contract(BaseModel):
    """A contract (precondition or postcondition) on a function."""

    kind: Literal["pre", "post"]
    expression: str
    line: intj  Nu}(j@%  SymboljB%  KjC%  }(jE%  }(jG%  K(jH%  K ujI%  }(jG%  K:jH%  K;uujK%  }(jE%  }(jG%  K(jH%  KujI%  }(jG%  K(jH%  KuujO%  ](}(j@%  namejB%  K
jC%  }(jE%  }(jG%  K+jH%  KujI%  }(jG%  K+jH%  KuujK%  }(jE%  }(jG%  K+jH%  KujI%  }(jG%  K+jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  	name: strj  j%  u}(j@%  kindjB%  K
jC%  }(jE%  }(jG%  K,jH%  KujI%  }(jG%  K,jH%  KuujK%  }(jE%  }(jG%  K,jH%  KujI%  }(jG%  K,jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  kind: SymbolKindj  j%  u}(j@%  linejB%  K
jC%  }(jE%  }(jG%  K-jH%  KujI%  }(jG%  K-jH%  KuujK%  }(jE%  }(jG%  K-jH%  KujI%  }(jG%  K-jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j
&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  	line: intj  j%  u}(j@%  end_linejB%  K
jC%  }(jE%  }(jG%  K.jH%  KujI%  }(jG%  K.jH%  KuujK%  }(jE%  }(jG%  K.jH%  KujI%  }(jG%  K.jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  
end_line: intj  j%  u}(j@%  	signaturejB%  K
jC%  }(jE%  }(jG%  K/jH%  KujI%  }(jG%  K/jH%  K
uujK%  }(jE%  }(jG%  K/jH%  KujI%  }(jG%  K/jH%  K
uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j$&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  signature: str = ""j  j%  u}(j@%  	docstringjB%  K
jC%  }(jE%  }(jG%  K0jH%  KujI%  }(jG%  K0jH%  K
uujK%  }(jE%  }(jG%  K0jH%  KujI%  }(jG%  K0jH%  K
uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j1&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  docstring: str | None = Nonej  j%  u}(j@%  	contractsjB%  K
jC%  }(jE%  }(jG%  K1jH%  KujI%  }(jG%  K1jH%  K
uujK%  }(jE%  }(jG%  K1jH%  KujI%  }(jG%  K1jH%  K
uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j>&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  7contracts: list[Contract] = Field(default_factory=list)j  j%  u}(j@%  has_doctestjB%  K
jC%  }(jE%  }(jG%  K2jH%  KujI%  }(jG%  K2jH%  KuujK%  }(jE%  }(jG%  K2jH%  KujI%  }(jG%  K2jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jK&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  has_doctest: bool = Falsej  j%  u}(j@%  internal_importsjB%  K
jC%  }(jE%  }(jG%  K4jH%  KujI%  }(jG%  K4jH%  KuujK%  }(jE%  }(jG%  K4jH%  KujI%  }(jG%  K4jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jX&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  9internal_imports: list[str] = Field(default_factory=list)j  j%  u}(j@%  impure_callsjB%  K
jC%  }(jE%  }(jG%  K5jH%  KujI%  }(jG%  K5jH%  KuujK%  }(jE%  }(jG%  K5jH%  KujI%  }(jG%  K5jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  je&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  5impure_calls: list[str] = Field(default_factory=list)j  j%  u}(j@%  
code_linesjB%  K
jC%  }(jE%  }(jG%  K6jH%  KujI%  }(jG%  K6jH%  KuujK%  }(jE%  }(jG%  K6jH%  KujI%  }(jG%  K6jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jr&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  Ccode_lines: int | None = None  # Lines excluding docstring/commentsj  j%  u}(j@%  
doctest_linesjB%  K
jC%  }(jE%  }(jG%  K8jH%  KujI%  }(jG%  K8jH%  KuujK%  }(jE%  }(jG%  K8jH%  KujI%  }(jG%  K8jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  Cdoctest_lines: int = 0  # Number of lines that are doctest examplesj  j%  u}(j@%  function_callsjB%  K
jC%  }(jE%  }(jG%  K:jH%  KujI%  }(jG%  K:jH%  KuujK%  }(jE%  }(jG%  K:jH%  KujI%  }(jG%  K:jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  `function_calls: list[str] = Field(default_factory=list)  # Functions called within this functionj  j%  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j%  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  X  class Symbol(BaseModel):
    """A symbol extracted from Python source code."""

    name: str
    kind: SymbolKind
    line: int
    end_line: int
    signature: str = ""
    docstring: str | None = None
    contracts: list[Contract] = Field(default_factory=list)
    has_doctest: bool = False
    # Phase 3: Guard Enhancement
    internal_imports: list[str] = Field(default_factory=list)
    impure_calls: list[str] = Field(default_factory=list)
    code_lines: int | None = None  # Lines excluding docstring/comments
    # Phase 6: Verification Completeness
    doctest_lines: int = 0  # Number of lines that are doctest examples
    # Phase 11 P25: For extraction analysis
    function_calls: list[str] = Field(default_factory=list)  # Functions called within this functionj  Nu}(j@%  FileInfojB%  KjC%  }(jE%  }(jG%  K=jH%  K ujI%  }(jG%  KEjH%  KuujK%  }(jE%  }(jG%  K=jH%  KujI%  }(jG%  K=jH%  KuujO%  ](}(j@%  pathjB%  K
jC%  }(jE%  }(jG%  K@jH%  KujI%  }(jG%  K@jH%  KuujK%  }(jE%  }(jG%  K@jH%  KujI%  }(jG%  K@jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  	path: strj  j&  u}(j@%  linesjB%  K
jC%  }(jE%  }(jG%  KAjH%  KujI%  }(jG%  KAjH%  K	uujK%  }(jE%  }(jG%  KAjH%  KujI%  }(jG%  KAjH%  K	uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  
lines: intj  j&  u}(j@%  symbolsjB%  K
jC%  }(jE%  }(jG%  KBjH%  KujI%  }(jG%  KBjH%  KuujK%  }(jE%  }(jG%  KBjH%  KujI%  }(jG%  KBjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  3symbols: list[Symbol] = Field(default_factory=list)j  j&  u}(j@%  importsjB%  K
jC%  }(jE%  }(jG%  KCjH%  KujI%  }(jG%  KCjH%  KuujK%  }(jE%  }(jG%  KCjH%  KujI%  }(jG%  KCjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  0imports: list[str] = Field(default_factory=list)j  j&  u}(j@%  is_corejB%  K
jC%  }(jE%  }(jG%  KDjH%  KujI%  }(jG%  KDjH%  KuujK%  }(jE%  }(jG%  KDjH%  KujI%  }(jG%  KDjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  is_core: bool = Falsej  j&  u}(j@%  is_shelljB%  K
jC%  }(jE%  }(jG%  KEjH%  KujI%  }(jG%  KEjH%  KuujK%  }(jE%  }(jG%  KEjH%  KujI%  }(jG%  KEjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  is_shell: bool = Falsej  j&  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  X  class FileInfo(BaseModel):
    """Information about a Python file."""

    path: str
    lines: int
    symbols: list[Symbol] = Field(default_factory=list)
    imports: list[str] = Field(default_factory=list)
    is_core: bool = False
    is_shell: bool = Falsej  Nu}(j@%  	ViolationjB%  KjC%  }(jE%  }(jG%  KHjH%  K ujI%  }(jG%  KPjH%  K!uujK%  }(jE%  }(jG%  KHjH%  KujI%  }(jG%  KHjH%  KuujO%  ](}(j@%  rulejB%  K
jC%  }(jE%  }(jG%  KKjH%  KujI%  }(jG%  KKjH%  KuujK%  }(jE%  }(jG%  KKjH%  KujI%  }(jG%  KKjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  	rule: strj  j&  u}(j@%  severityjB%  K
jC%  }(jE%  }(jG%  KLjH%  KujI%  }(jG%  KLjH%  KuujK%  }(jE%  }(jG%  KLjH%  KujI%  }(jG%  KLjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  severity: Severityj  j&  u}(j@%  filejB%  K
jC%  }(jE%  }(jG%  KMjH%  KujI%  }(jG%  KMjH%  KuujK%  }(jE%  }(jG%  KMjH%  KujI%  }(jG%  KMjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  	file: strj  j&  u}(j@%  linejB%  K
jC%  }(jE%  }(jG%  KNjH%  KujI%  }(jG%  KNjH%  KuujK%  }(jE%  }(jG%  KNjH%  KujI%  }(jG%  KNjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j('  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  line: int | None = Nonej  j&  u}(j@%  messagejB%  K
jC%  }(jE%  }(jG%  KOjH%  KujI%  }(jG%  KOjH%  KuujK%  }(jE%  }(jG%  KOjH%  KujI%  }(jG%  KOjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j5'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  message: strj  j&  u}(j@%  
suggestionjB%  K
jC%  }(jE%  }(jG%  KPjH%  KujI%  }(jG%  KPjH%  KuujK%  }(jE%  }(jG%  KPjH%  KujI%  }(jG%  KPjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jB'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  suggestion: str | None = Nonej  j&  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j&  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  class Violation(BaseModel):
    """A rule violation found by Guard."""

    rule: str
    severity: Severity
    file: str
    line: int | None = None
    message: str
    suggestion: str | None = Nonej  Nu}(j@%  GuardReportjB%  KjC%  }(jE%  }(jG%  KSjH%  K ujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KSjH%  KujI%  }(jG%  KSjH%  KuujO%  ](}(j@%  
files_checkedjB%  K
jC%  }(jE%  }(jG%  KVjH%  KujI%  }(jG%  KVjH%  KuujK%  }(jE%  }(jG%  KVjH%  KujI%  }(jG%  KVjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j\'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  files_checked: intj  jQ'  u}(j@%  
violationsjB%  K
jC%  }(jE%  }(jG%  KWjH%  KujI%  }(jG%  KWjH%  KuujK%  }(jE%  }(jG%  KWjH%  KujI%  }(jG%  KWjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  ji'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  9violations: list[Violation] = Field(default_factory=list)j  jQ'  u}(j@%  errorsjB%  K
jC%  }(jE%  }(jG%  KXjH%  KujI%  }(jG%  KXjH%  K
uujK%  }(jE%  }(jG%  KXjH%  KujI%  }(jG%  KXjH%  K
uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jv'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  errors: int = 0j  jQ'  u}(j@%  warningsjB%  K
jC%  }(jE%  }(jG%  KYjH%  KujI%  }(jG%  KYjH%  KuujK%  }(jE%  }(jG%  KYjH%  KujI%  }(jG%  KYjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  warnings: int = 0j  jQ'  u}(j@%  infosjB%  K
jC%  }(jE%  }(jG%  KZjH%  KujI%  }(jG%  KZjH%  K	uujK%  }(jE%  }(jG%  KZjH%  KujI%  }(jG%  KZjH%  K	uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  2infos: int = 0  # Phase 7: Track INFO-level issuesj  jQ'  u}(j@%  core_functions_totaljB%  K
jC%  }(jE%  }(jG%  K\jH%  KujI%  }(jG%  K\jH%  KuujK%  }(jE%  }(jG%  K\jH%  KujI%  }(jG%  K\jH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  core_functions_total: int = 0j  jQ'  u}(j@%  core_functions_with_contractsjB%  K
jC%  }(jE%  }(jG%  K]jH%  KujI%  }(jG%  K]jH%  K!uujK%  }(jE%  }(jG%  K]jH%  KujI%  }(jG%  K]jH%  K!uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  &core_functions_with_contracts: int = 0j  jQ'  u}(j@%  
add_violationjB%  KjC%  }(jE%  }(jG%  K_jH%  KujI%  }(jG%  KrjH%  KuujK%  }(jE%  }(jG%  K`jH%  KujI%  }(jG%  K`jH%  KuujO%  ]}(j@%  	violationjB%  K
jC%  }(jE%  }(jG%  K`jH%  KujI%  }(jG%  K`jH%  K0uujK%  }(jE%  }(jG%  K`jH%  KujI%  }(jG%  K`jH%  K0uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  violation: Violation) -> None:j  j'  uaj  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  X  @pre(lambda self, violation: isinstance(violation, Violation))
    def add_violation(self, violation: Violation) -> None:
        """
        Add a violation and update counts.

        Examples:
            >>> from invar.core.models import Violation, Severity, GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> v = Violation(rule="test", severity=Severity.ERROR, file="x.py", message="err")
            >>> report.add_violation(v)
            >>> report.errors
            1
        """
        self.violations.append(violation)
        if violation.severity == Severity.ERROR:
            self.errors += 1
        elif violation.severity == Severity.WARNING:
            self.warnings += 1
        else:
            self.infos += 1j  jQ'  u}(j@%  update_coveragejB%  KjC%  }(jE%  }(jG%  KtjH%  KujI%  }(jG%  KjH%  K<uujK%  }(jE%  }(jG%  KujH%  KujI%  }(jG%  KujH%  KuujO%  ](}(j@%  totaljB%  K
jC%  }(jE%  }(jG%  KujH%  KujI%  }(jG%  KujH%  K(uujK%  }(jE%  }(jG%  KujH%  KujI%  }(jG%  KujH%  K(uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  )total: int, with_contracts: int) -> None:j  j'  u}(j@%  with_contractsjB%  K
jC%  }(jE%  }(jG%  KujH%  K*ujI%  }(jG%  KujH%  K=uujK%  }(jE%  }(jG%  KujH%  K*ujI%  }(jG%  KujH%  K=uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  with_contracts: int) -> None:j  j'  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  Xv  @pre(lambda self, total, with_contracts: total >= 0 and with_contracts >= 0)
    def update_coverage(self, total: int, with_contracts: int) -> None:
        """
        Update contract coverage statistics (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.core_functions_total
            10
            >>> report.core_functions_with_contracts
            8
        """
        self.core_functions_total += total
        self.core_functions_with_contracts += with_contractsj  jQ'  u}(j@%  contract_coverage_pctjB%  KjC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KXuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  X:  @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_coverage_pct(self) -> int:
        """
        Get contract coverage percentage (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.contract_coverage_pct
            80
        """
        if self.core_functions_total == 0:
            return 100
        return int(self.core_functions_with_contracts / self.core_functions_total * 100)j  jQ'  u}(j@%  contract_issue_countsjB%  KjC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ](}(j@%  countsjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  Ccounts = {"tautology": 0, "empty": 0, "partial": 0, "type_only": 0}j  j(  u}(j@%  j  jB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  K
uujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  K
uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  v in self.violations:j  j(  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  X  @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_issue_counts(self) -> dict[str, int]:
        """
        Count contract quality issues by type (P24).

        Examples:
            >>> from invar.core.models import GuardReport, Violation, Severity
            >>> report = GuardReport(files_checked=1)
            >>> v1 = Violation(rule="empty_contract", severity=Severity.WARNING, file="x.py", message="m")
            >>> v2 = Violation(rule="semantic_tautology", severity=Severity.WARNING, file="x.py", message="m")
            >>> report.add_violation(v1)
            >>> report.add_violation(v2)
            >>> report.contract_issue_counts
            {'tautology': 1, 'empty': 1, 'partial': 0, 'type_only': 0}
        """
        counts = {"tautology": 0, "empty": 0, "partial": 0, "type_only": 0}
        for v in self.violations:
            if v.rule == "semantic_tautology":
                counts["tautology"] += 1
            elif v.rule == "empty_contract":
                counts["empty"] += 1
            elif v.rule == "partial_contract":
                counts["partial"] += 1
            elif v.rule == "redundant_type_contract":
                counts["type_only"] += 1
        return countsj  jQ'  u}(j@%  passedjB%  KjC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j+(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  Xq  @property
    @pre(lambda self: isinstance(self, GuardReport))
    def passed(self) -> bool:
        """
        Check if guard passed (no errors).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.passed
            True
        """
        return self.errors == 0j  jQ'  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jS'  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  X  class GuardReport(BaseModel):
    """Complete Guard report for a project."""

    files_checked: int
    violations: list[Violation] = Field(default_factory=list)
    errors: int = 0
    warnings: int = 0
    infos: int = 0  # Phase 7: Track INFO-level issues
    # P24: Contract coverage statistics (Core files only)
    core_functions_total: int = 0
    core_functions_with_contracts: int = 0

    @pre(lambda self, violation: isinstance(violation, Violation))
    def add_violation(self, violation: Violation) -> None:
        """
        Add a violation and update counts.

        Examples:
            >>> from invar.core.models import Violation, Severity, GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> v = Violation(rule="test", severity=Severity.ERROR, file="x.py", message="err")
            >>> report.add_violation(v)
            >>> report.errors
            1
        """
        self.violations.append(violation)
        if violation.severity == Severity.ERROR:
            self.errors += 1
        elif violation.severity == Severity.WARNING:
            self.warnings += 1
        else:
            self.infos += 1

    @pre(lambda self, total, with_contracts: total >= 0 and with_contracts >= 0)
    def update_coverage(self, total: int, with_contracts: int) -> None:
        """
        Update contract coverage statistics (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.core_functions_total
            10
            >>> report.core_functions_with_contracts
            8
        """
        self.core_functions_total += total
        self.core_functions_with_contracts += with_contracts

    @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_coverage_pct(self) -> int:
        """
        Get contract coverage percentage (P24).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.update_coverage(10, 8)
            >>> report.contract_coverage_pct
            80
        """
        if self.core_functions_total == 0:
            return 100
        return int(self.core_functions_with_contracts / self.core_functions_total * 100)

    @property
    @pre(lambda self: isinstance(self, GuardReport))
    def contract_issue_counts(self) -> dict[str, int]:
        """
        Count contract quality issues by type (P24).

        Examples:
            >>> from invar.core.models import GuardReport, Violation, Severity
            >>> report = GuardReport(files_checked=1)
            >>> v1 = Violation(rule="empty_contract", severity=Severity.WARNING, file="x.py", message="m")
            >>> v2 = Violation(rule="semantic_tautology", severity=Severity.WARNING, file="x.py", message="m")
            >>> report.add_violation(v1)
            >>> report.add_violation(v2)
            >>> report.contract_issue_counts
            {'tautology': 1, 'empty': 1, 'partial': 0, 'type_only': 0}
        """
        counts = {"tautology": 0, "empty": 0, "partial": 0, "type_only": 0}
        for v in self.violations:
            if v.rule == "semantic_tautology":
                counts["tautology"] += 1
            elif v.rule == "empty_contract":
                counts["empty"] += 1
            elif v.rule == "partial_contract":
                counts["partial"] += 1
            elif v.rule == "redundant_type_contract":
                counts["type_only"] += 1
        return counts

    @property
    @pre(lambda self: isinstance(self, GuardReport))
    def passed(self) -> bool:
        """
        Check if guard passed (no errors).

        Examples:
            >>> from invar.core.models import GuardReport
            >>> report = GuardReport(files_checked=1)
            >>> report.passed
            True
        """
        return self.errors == 0j  Nu}(j@%  
RuleExclusionjB%  KjC%  }(jE%  }(jG%  KjH%  K ujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ](}(j@%  patternjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jE(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  <pattern: str  # Glob pattern (fnmatch style with ** support)j  j:(  u}(j@%  rulesjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  K	uujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  K	uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jR(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  ;rules: list[str]  # Rule names to exclude, or ["*"] for allj  j:(  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j<(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  X  class RuleExclusion(BaseModel):
    """
    A rule exclusion pattern for specific files.

    Examples:
        >>> excl = RuleExclusion(pattern="**/generated/**", rules=["*"])
        >>> excl.pattern
        '**/generated/**'
        >>> excl.rules
        ['*']
    """

    pattern: str  # Glob pattern (fnmatch style with ** support)
    rules: list[str]  # Rule names to exclude, or ["*"] for all      j  Nu}(j@%  
RuleConfigjB%  KjC%  }(jE%  }(jG%  KjH%  K ujI%  }(jG%  KjH%  K'uujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ](}(j@%  max_file_linesjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jl(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  Jmax_file_lines: int = 500  # Phase 9 P1: Raised from 300 for less frictionj  ja(  u}(j@%  max_function_linesjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jy(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  max_function_lines: int = 50j  ja(  u}(j@%  forbidden_importsjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  &forbidden_imports: tuple[str, ...] = (j  ja(  u}(j@%  require_contractsjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  require_contracts: bool = Truej  ja(  u}(j@%  require_doctestsjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  require_doctests: bool = Truej  ja(  u}(j@%  strict_purejB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  Dstrict_pure: bool = True  # Phase 9 P12: Default ON for agent-nativej  ja(  u}(j@%  use_code_linesjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  use_code_lines: bool = Falsej  ja(  u}(j@%  exclude_doctest_linesjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  #exclude_doctest_lines: bool = Falsej  ja(  u}(j@%  rule_exclusionsjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  Brule_exclusions: list[RuleExclusion] = Field(default_factory=list)j  ja(  u}(j@%  severity_overridesjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  +severity_overrides: dict[str, str] = Field(j  ja(  u}(j@%  size_warning_thresholdjB%  K
jC%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  #size_warning_threshold: float = 0.8j  ja(  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jc(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  X:  class RuleConfig(BaseModel):
    """
    Configuration for rule checking.

    Examples:
        >>> config = RuleConfig()
        >>> config.max_file_lines  # Phase 9 P1: Raised from 300
        500
        >>> config.strict_pure  # Phase 9 P12: Default ON for agents
        True
    """

    max_file_lines: int = 500  # Phase 9 P1: Raised from 300 for less friction
    max_function_lines: int = 50
    forbidden_imports: tuple[str, ...] = (
        "os",
        "sys",
        "socket",
        "requests",
        "urllib",
        "subprocess",
        "shutil",
        "io",
        "pathlib",
    )
    require_contracts: bool = True
    require_doctests: bool = True
    strict_pure: bool = True  # Phase 9 P12: Default ON for agent-native
    use_code_lines: bool = False
    exclude_doctest_lines: bool = False
    # Phase 9 P1: Rule exclusions for specific file patterns
    rule_exclusions: list[RuleExclusion] = Field(default_factory=list)
    # Phase 9 P2: Per-rule severity overrides (off, info, warning, error)
    severity_overrides: dict[str, str] = Field(
        default_factory=lambda: {
            "redundant_type_contract": "off",  # Expected behavior when forcing contracts
        }
    )
    # Phase 9 P8: File size warning threshold (0 to disable, 0.8 = warn at 80%)
    size_warning_threshold: float = 0.8j  Nu}(j@%  
SymbolRefsjB%  KjC%  }(jE%  }(jG%  KjH%  K ujI%  }(jG%  MjH%  KuujK%  }(jE%  }(jG%  KjH%  KujI%  }(jG%  KjH%  KuujO%  ](}(j@%  symboljB%  K
jC%  }(jE%  }(jG%  M
jH%  KujI%  }(jG%  M
jH%  K
uujK%  }(jE%  }(jG%  M
jH%  KujI%  }(jG%  M
jH%  K
uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j)  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  symbol: Symbolj  j(  u}(j@%  	file_pathjB%  K
jC%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  K
uujK%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  K
uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j)  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  file_path: strj  j(  u}(j@%  	ref_countjB%  K
jC%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  K
uujK%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  K
uujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j")  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  ref_count: int = 0j  j(  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j(  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  X  class SymbolRefs(BaseModel):
    """
    A symbol with its cross-file reference count.

    Examples:
        >>> from invar.core.models import Symbol, SymbolKind, SymbolRefs
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5)
        >>> sr = SymbolRefs(symbol=sym, file_path="core/calc.py", ref_count=10)
        >>> sr.ref_count
        10
    """

    symbol: Symbol
    file_path: str
    ref_count: int = 0j  Nu}(j@%  
PerceptionMapjB%  KjC%  }(jE%  }(jG%  MjH%  K ujI%  }(jG%  MjH%  K;uujK%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  KuujO%  ](}(j@%  project_rootjB%  K
jC%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  KuujK%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j<)  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  project_root: strj  j1)  u}(j@%  total_filesjB%  K
jC%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  KuujK%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jI)  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  total_files: intj  j1)  u}(j@%  
total_symbolsjB%  K
jC%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  KuujK%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jV)  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  total_symbols: intj  j1)  u}(j@%  symbolsjB%  K
jC%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  KuujK%  }(jE%  }(jG%  MjH%  KujI%  }(jG%  MjH%  KuujO%  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  jc)  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  7symbols: list[SymbolRefs] = Field(default_factory=list)j  j1)  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/models.pyj  j3)  j  3/Users/tefx/Projects/Invar/src/invar/core/models.pyj  j]%  uj  Xc  class PerceptionMap(BaseModel):
    """
    Complete perception map for a project.

    Examples:
        >>> pm = PerceptionMap(project_root="/test", total_files=5, total_symbols=20)
        >>> pm.total_files
        5
    """

    project_root: str
    total_files: int
    total_symbols: int
    symbols: list[SymbolRefs] = Field(default_factory=list)j  Nueja  Nubj
   cb0a5f3729c85f8fb6b2e8c79392b042h)}(h](}(nameIMPURE_FUNCTIONSkindKrange}(start}(lineK	characterK uend}(j)  Kj)  KuuselectionRange}(j})  }(j)  Kj)  K uj)  }(j)  Kj)  Kuuchildren]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j|)  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  src/invar/core/purity.pyuj  IMPURE_FUNCTIONS: set[str] = {j  Nu}(jx)  IMPURE_PATTERNSjz)  Kj{)  }(j})  }(j)  K%j)  K uj)  }(j)  K%j)  Kuuj)  }(j})  }(j)  K%j)  K uj)  }(j)  K%j)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  )IMPURE_PATTERNS: set[tuple[str, str]] = {j  Nu}(jx)  extract_internal_importsjz)  Kj{)  }(j})  }(j)  K5j)  K uj)  }(j)  KPj)  Kuuj)  }(j})  }(j)  K6j)  Kuj)  }(j)  K6j)  Kuuj)  ](}(jx)  nodejz)  K
j{)  }(j})  }(j)  K6j)  Kuj)  }(j)  K6j)  KIuuj)  }(j})  }(j)  K6j)  Kuj)  }(j)  K6j)  KIuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  ;node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:j  j)  u}(jx)  importsjz)  K
j{)  }(j})  }(j)  KGj)  Kuj)  }(j)  KGj)  Kuuj)  }(j})  }(j)  KGj)  Kuj)  }(j)  KGj)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  imports: list[str] = []j  j)  u}(jx)  childjz)  K
j{)  }(j})  }(j)  KIj)  Kuj)  }(j)  KIj)  K
uuj)  }(j})  }(j)  KIj)  Kuj)  }(j)  KIj)  K
uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  child in ast.walk(node):j  j)  u}(jx)  aliasjz)  K
j{)  }(j})  }(j)  KKj)  Kuj)  }(j)  KKj)  Kuuj)  }(j})  }(j)  KKj)  Kuj)  }(j)  KKj)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  alias in child.names:j  j)  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def extract_internal_imports(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:
    """
    Extract imports inside a function body.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     import os
        ...     from pathlib import Path
        ...     return Path(".")
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> sorted(extract_internal_imports(func))
        ['os', 'pathlib']
    """
    imports: list[str] = []

    for child in ast.walk(node):
        if isinstance(child, ast.Import):
            for alias in child.names:
                imports.append(alias.name.split(".")[0])
        elif isinstance(child, ast.ImportFrom) and child.module:
            imports.append(child.module.split(".")[0])

    return list(set(imports))j  Nu}(jx)  extract_impure_callsjz)  Kj{)  }(j})  }(j)  KSj)  K uj)  }(j)  Kmj)  Kuuj)  }(j})  }(j)  KTj)  Kuj)  }(j)  KTj)  Kuuj)  ](}(jx)  nodejz)  K
j{)  }(j})  }(j)  KTj)  Kuj)  }(j)  KTj)  KEuuj)  }(j})  }(j)  KTj)  Kuj)  }(j)  KTj)  KEuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  ;node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:j  j)  u}(jx)  impurejz)  K
j{)  }(j})  }(j)  Kej)  Kuj)  }(j)  Kej)  K
uuj)  }(j})  }(j)  Kej)  Kuj)  }(j)  Kej)  K
uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  impure: list[str] = []j  j)  u}(jx)  childjz)  K
j{)  }(j})  }(j)  Kgj)  Kuj)  }(j)  Kgj)  K
uuj)  }(j})  }(j)  Kgj)  Kuj)  }(j)  Kgj)  K
uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  child in ast.walk(node):j  j)  u}(jx)  	call_namejz)  K
j{)  }(j})  }(j)  Kij)  Kuj)  }(j)  Kij)  Kuuj)  }(j})  }(j)  Kij)  Kuj)  }(j)  Kij)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  !call_name = _get_call_name(child)j  j)  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  XC  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def extract_impure_calls(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:
    """
    Extract calls to known impure functions.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     x = datetime.now()
        ...     print("hello")
        ...     return x
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> sorted(extract_impure_calls(func))
        ['datetime.now', 'print']
    """
    impure: list[str] = []

    for child in ast.walk(node):
        if isinstance(child, ast.Call):
            call_name = _get_call_name(child)
            if call_name and _is_impure_call(call_name):
                impure.append(call_name)

    return list(set(impure))j  Nu}(jx)  extract_function_callsjz)  Kj{)  }(j})  }(j)  Kpj)  K uj)  }(j)  Kj)  Kuuj)  }(j})  }(j)  Kqj)  Kuj)  }(j)  Kqj)  Kuuj)  ](}(jx)  nodejz)  K
j{)  }(j})  }(j)  Kqj)  Kuj)  }(j)  Kqj)  KGuuj)  }(j})  }(j)  Kqj)  Kuj)  }(j)  Kqj)  KGuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j(*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  ;node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:j  j*  u}(jx)  callsjz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K	uuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K	uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j5*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  calls: list[str] = []j  j*  u}(jx)  childjz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K
uuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K
uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  jB*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  child in ast.walk(node):j  j*  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  X5  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def extract_function_calls(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[str]:
    """
    Extract all function calls from a function body (P25: for extraction analysis).

    Only extracts simple function calls (not method calls on objects).
    Used to build call graph for grouping related functions.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     helper()
        ...     result = calculate(x)
        ...     return result
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> sorted(extract_function_calls(func))
        ['calculate', 'helper']
        >>> # Method calls are excluded
        >>> code2 = '''
        ... def bar():
        ...     self.method()
        ...     obj.call()
        ...     helper()
        ... '''
        >>> tree2 = ast.parse(code2)
        >>> func2 = tree2.body[0]
        >>> extract_function_calls(func2)
        ['helper']
    """
    calls: list[str] = []

    for child in ast.walk(node):
        if isinstance(child, ast.Call):
            # Only simple function calls (not x.method())
            if isinstance(child.func, ast.Name):
                calls.append(child.func.id)

    return list(set(calls))j  Nu}(jx)  _get_call_namejz)  Kj{)  }(j})  }(j)  Kj)  K uj)  }(j)  Kj)  Kuuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  ](}(jx)  calljz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K!uuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K!uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j\*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  call: ast.Call) -> str | None:j  jQ*  u}(jx)  funcjz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  ji*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  func = call.funcj  jQ*  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  jS*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  X  @pre(lambda call: isinstance(call, ast.Call))
def _get_call_name(call: ast.Call) -> str | None:
    """Get the name of a function call as a string."""
    func = call.func

    # Simple name: print(), open()
    if isinstance(func, ast.Name):
        return func.id

    # Attribute: datetime.now(), random.randint()
    if isinstance(func, ast.Attribute) and isinstance(func.value, ast.Name):
        return f"{func.value.id}.{func.attr}"

    return Nonej  Nu}(jx)  _is_impure_calljz)  Kj{)  }(j})  }(j)  Kj)  K uj)  }(j)  Kj)  Kuuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  ](}(jx)  	call_namejz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K"uuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K"uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  call_name: str) -> bool:j  jx*  u}(jx)  partsjz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K
uuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K
uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  parts = call_name.split(".")j  jx*  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  jz*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  X  @pre(lambda call_name: isinstance(call_name, str) and len(call_name) > 0)
def _is_impure_call(call_name: str) -> bool:
    """Check if a call name represents an impure function."""
    # Check simple names
    if call_name in IMPURE_FUNCTIONS:
        return True

    # Check patterns like datetime.now
    if "." in call_name:
        parts = call_name.split(".")
        if len(parts) == 2 and (parts[0], parts[1]) in IMPURE_PATTERNS:
            return True

    return Falsej  Nu}(jx)  count_code_linesjz)  Kj{)  }(j})  }(j)  Kj)  K uj)  }(j)  Kj)  K(uuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  ](}(jx)  nodejz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  KAuuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  KAuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  5node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:j  j*  u}(jx)  total_linesjz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  @total_lines = (node.end_lineno or node.lineno) - node.lineno + 1j  j*  u}(jx)  docstring_linesjz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  docstring_lines = 0j  j*  u}(jx)  docstring_nodejz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  docstring_node = node.body[0]j  j*  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  Xc  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def count_code_lines(node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:
    """
    Count lines of code excluding docstring.

    The total function lines minus docstring lines gives the actual code lines.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     \"\"\"This is a docstring.\"\"\"
        ...     x = 1
        ...     return x
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> count_code_lines(func)
        3
    """
    total_lines = (node.end_lineno or node.lineno) - node.lineno + 1

    # Check for docstring
    docstring_lines = 0
    if (
        node.body
        and isinstance(node.body[0], ast.Expr)
        and isinstance(node.body[0].value, ast.Constant)
        and isinstance(node.body[0].value.value, str)
    ):
        docstring_node = node.body[0]
        docstring_lines = (
            (docstring_node.end_lineno or docstring_node.lineno) - docstring_node.lineno + 1
        )

    return total_lines - docstring_linesj  Nu}(jx)  count_doctest_linesjz)  Kj{)  }(j})  }(j)  Kj)  K uj)  }(j)  Mj)  Kuuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  Kuuj)  ](}(jx)  nodejz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  KDuuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  KDuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  5node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:j  j*  u}(jx)  	docstringjz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K
uuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K
uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  #docstring = ast.get_docstring(node)j  j*  u}(jx)  countjz)  K
j{)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K	uuj)  }(j})  }(j)  Kj)  Kuj)  }(j)  Kj)  K	uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  	count = 0j  j*  u}(jx)  
in_doctestjz)  K
j{)  }(j})  }(j)  M j)  Kuj)  }(j)  M j)  Kuuj)  }(j})  }(j)  M j)  Kuj)  }(j)  M j)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  in_doctest = Falsej  j*  u}(jx)  linejz)  K
j{)  }(j})  }(j)  Mj)  Kuj)  }(j)  Mj)  Kuuj)  }(j})  }(j)  Mj)  Kuj)  }(j)  Mj)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  line in docstring.split("\n"):j  j*  u}(jx)  strippedjz)  K
j{)  }(j})  }(j)  Mj)  Kuj)  }(j)  Mj)  Kuuj)  }(j})  }(j)  Mj)  Kuj)  }(j)  Mj)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j,+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  stripped = line.strip()j  j*  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j*  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  Xd  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
def count_doctest_lines(node: ast.FunctionDef | ast.AsyncFunctionDef) -> int:
    """
    Count lines that are doctest examples in the docstring.

    Counts both `>>> ` input lines and their expected output lines.

    Examples:
        >>> import ast
        >>> code = '''
        ... def foo():
        ...     \"\"\"Example.
        ...
        ...     Examples:
        ...         >>> foo()
        ...         42
        ...         >>> foo() + 1
        ...         43
        ...     \"\"\"
        ...     return 42
        ... '''
        >>> tree = ast.parse(code)
        >>> func = tree.body[0]
        >>> count_doctest_lines(func)
        4
    """
    docstring = ast.get_docstring(node)
    if not docstring:
        return 0

    count = 0
    in_doctest = False
    for line in docstring.split("\n"):
        stripped = line.strip()
        if stripped.startswith(">>> "):
            count += 1
            in_doctest = True
        elif stripped.startswith("... "):
            count += 1  # Continuation line
        elif in_doctest and stripped and not stripped.startswith(">>>"):
            count += 1  # Expected output line
            if not stripped:  # Empty line ends output
                in_doctest = False
        else:
            in_doctest = False
    return countj  Nu}(jx)  check_internal_importsjz)  Kj{)  }(j})  }(j)  Mj)  K uj)  }(j)  M9j)  Kuuj)  }(j})  }(j)  Mj)  Kuj)  }(j)  Mj)  Kuuj)  ](}(jx)  	file_infojz)  K
j{)  }(j})  }(j)  Mj)  Kuj)  }(j)  Mj)  K.uuj)  }(j})  }(j)  Mj)  Kuj)  }(j)  Mj)  K.uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  jF+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j;+  u}(jx)  configjz)  K
j{)  }(j})  }(j)  Mj)  K0uj)  }(j)  Mj)  KBuuj)  }(j})  }(j)  Mj)  K0uj)  }(j)  Mj)  KBuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  jS+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  'config: RuleConfig) -> list[Violation]:j  j;+  u}(jx)  
violationsjz)  K
j{)  }(j})  }(j)  M&j)  Kuj)  }(j)  M&j)  Kuuj)  }(j})  }(j)  M&j)  Kuj)  }(j)  M&j)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j`+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj   violations: list[Violation] = []j  j;+  u}(jx)  symboljz)  K
j{)  }(j})  }(j)  M+j)  Kuj)  }(j)  M+j)  Kuuj)  }(j})  }(j)  M+j)  Kuj)  }(j)  M+j)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  jm+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  symbol in file_info.symbols:j  j;+  u}(jx)  	kind_namejz)  K
j{)  }(j})  }(j)  M-j)  Kuj)  }(j)  M-j)  Kuuj)  }(j})  }(j)  M-j)  Kuj)  }(j)  M-j)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  jz+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"j  j;+  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j=+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_internal_imports(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check for imports inside function bodies.

    Only applies to Core files when strict_pure is enabled.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, RuleConfig
        >>> sym = Symbol(
        ...     name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     internal_imports=["os"]
        ... )
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> violations = check_internal_imports(info, RuleConfig(strict_pure=True))
        >>> len(violations)
        1
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.strict_pure:
        return violations

    for symbol in file_info.symbols:
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD) and symbol.internal_imports:
            kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
            violations.append(
                Violation(
                    rule="internal_import",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"{kind_name} '{symbol.name}' has internal imports: {', '.join(symbol.internal_imports)}",
                    suggestion="Move imports to top of file or move function to Shell",
                )
            )

    return violationsj  Nu}(jx)  check_impure_callsjz)  Kj{)  }(j})  }(j)  M<j)  K uj)  }(j)  Mlj)  Kuuj)  }(j})  }(j)  M=j)  Kuj)  }(j)  M=j)  Kuuj)  ](}(jx)  	file_infojz)  K
j{)  }(j})  }(j)  M=j)  Kuj)  }(j)  M=j)  K*uuj)  }(j})  }(j)  M=j)  Kuj)  }(j)  M=j)  K*uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j+  u}(jx)  configjz)  K
j{)  }(j})  }(j)  M=j)  K,uj)  }(j)  M=j)  K>uuj)  }(j})  }(j)  M=j)  K,uj)  }(j)  M=j)  K>uuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  'config: RuleConfig) -> list[Violation]:j  j+  u}(jx)  
violationsjz)  K
j{)  }(j})  }(j)  MSj)  Kuj)  }(j)  MSj)  Kuuj)  }(j})  }(j)  MSj)  Kuj)  }(j)  MSj)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj   violations: list[Violation] = []j  j+  u}(jx)  pure_setjz)  K
j{)  }(j})  }(j)  MYj)  Kuj)  }(j)  MYj)  Kuuj)  }(j})  }(j)  MYj)  Kuj)  }(j)  MYj)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  "pure_set = set(config.purity_pure)j  j+  u}(jx)  symboljz)  K
j{)  }(j})  }(j)  M[j)  Kuj)  }(j)  M[j)  Kuuj)  }(j})  }(j)  M[j)  Kuj)  }(j)  M[j)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  symbol in file_info.symbols:j  j+  u}(jx)  
actual_impurejz)  K
j{)  }(j})  }(j)  M^j)  Kuj)  }(j)  M^j)  Kuuj)  }(j})  }(j)  M^j)  Kuj)  }(j)  M^j)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  Eactual_impure = [c for c in symbol.impure_calls if c not in pure_set]j  j+  u}(jx)  	kind_namejz)  K
j{)  }(j})  }(j)  M`j)  Kuj)  }(j)  M`j)  Kuuj)  }(j})  }(j)  M`j)  Kuj)  }(j)  M`j)  Kuuj)  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"j  j+  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j+  j  3/Users/tefx/Projects/Invar/src/invar/core/purity.pyj  j)  uj  XY  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_impure_calls(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check for calls to known impure functions.

    Only applies to Core files when strict_pure is enabled.
    Respects config.purity_pure for user-declared pure functions.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, RuleConfig
        >>> sym = Symbol(
        ...     name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     impure_calls=["datetime.now", "print"]
        ... )
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> violations = check_impure_calls(info, RuleConfig(strict_pure=True))
        >>> len(violations)
        1
        >>> # User declares print as pure → no violation
        >>> violations = check_impure_calls(info, RuleConfig(purity_pure=["print"]))
        >>> any("print" in v.message for v in violations)
        False
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.strict_pure:
        return violations

    # B4: User-declared pure functions override blacklist
    pure_set = set(config.purity_pure)

    for symbol in file_info.symbols:
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD) and symbol.impure_calls:
            # Filter out user-declared pure functions
            actual_impure = [c for c in symbol.impure_calls if c not in pure_set]
            if actual_impure:
                kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(
                    Violation(
                        rule="impure_call",
                        severity=Severity.ERROR,
                        file=file_info.path,
                        line=symbol.line,
                        message=f"{kind_name} '{symbol.name}' calls impure functions: {', '.join(actual_impure)}",
                        suggestion="Inject dependencies or move function to Shell",
                    )
                )

    return violationsj  Nueja  Nubju   230722960bd238a6e7bd95824f8e6597h)}(hjV  ja  Nubsrc/invar/core/__init__.py 404c968b10271f91e39639c0cd2ed068h)}(hj>  ja  Nubj^   e347e1485102bbe47bd1709fc52baa59h)}(h](}(nameFORBIDDEN_IMPORT_ALTERNATIVESkindKrange}(start}(lineK	characterK uend}(j,  Kj,  KuuselectionRange}(j,  }(j,  Kj,  K uj	,  }(j,  Kj,  Kuuchildren]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  2/Users/tefx/Projects/Invar/src/invar/core/rules.pyj  src/invar/core/rules.pyuj  1FORBIDDEN_IMPORT_ALTERNATIVES: dict[str, str] = {j  Nu}(j ,  RuleFuncj,  K
j,  }(j,  }(j,  K'j,  K uj	,  }(j,  K'j,  Kuuj,  }(j,  }(j,  K'j,  K uj	,  }(j,  K'j,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj  <RuleFunc = Callable[[FileInfo, RuleConfig], list[Violation]]j  Nu}(j ,  check_file_sizej,  Kj,  }(j,  }(j,  K*j,  K uj	,  }(j,  Kqj,  Kuuj,  }(j,  }(j,  K+j,  Kuj	,  }(j,  K+j,  Kuuj,  ](}(j ,  	file_infoj,  K
j,  }(j,  }(j,  K+j,  Kuj	,  }(j,  K+j,  K'uuj,  }(j,  }(j,  K+j,  Kuj	,  }(j,  K+j,  K'uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-,  j  j,  j  j,  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j",  u}(j ,  configj,  K
j,  }(j,  }(j,  K+j,  K)uj	,  }(j,  K+j,  K;uuj,  }(j,  }(j,  K+j,  K)uj	,  }(j,  K+j,  K;uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j9,  j  j,  j  j,  uj  'config: RuleConfig) -> list[Violation]:j  j",  u}(j ,  
violationsj,  K
j,  }(j,  }(j,  K=j,  Kuj	,  }(j,  K=j,  Kuuj,  }(j,  }(j,  K=j,  Kuj	,  }(j,  K=j,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  jE,  j  j,  j  j,  uj   violations: list[Violation] = []j  j",  u}(j ,  funcsj,  K
j,  }(j,  }(j,  K?j,  Kuj	,  }(j,  K?j,  K	uuj,  }(j,  }(j,  K?j,  Kuj	,  }(j,  K?j,  K	uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  jQ,  j  j,  j  j,  uj  funcs = sorted(j  j",  u}(j ,  	func_hintj,  K
j,  }(j,  }(j,  KGj,  Kuj	,  }(j,  KGj,  K
uuj,  }(j,  }(j,  KGj,  Kuj	,  }(j,  KGj,  K
uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j],  j  j,  j  j,  uj  Yfunc_hint = f" Functions: {', '.join(f'{n}({sz}L)' for n, sz in funcs)}" if funcs else ""j  j",  u}(j ,  extraction_hintj,  K
j,  }(j,  }(j,  KJj,  Kuj	,  }(j,  KJj,  Kuuj,  }(j,  }(j,  KJj,  Kuj	,  }(j,  KJj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  ji,  j  j,  j  j,  uj  3extraction_hint = format_extraction_hint(file_info)j  j",  u}(j ,  
suggestionj,  K
j,  }(j,  }(j,  KMj,  Kuj	,  }(j,  KMj,  Kuuj,  }(j,  }(j,  KMj,  Kuj	,  }(j,  KMj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  ju,  j  j,  j  j,  uj  *suggestion = "Split into smaller modules."j  j",  u}(j ,  threshold_linesj,  K
j,  }(j,  }(j,  K^j,  Kuj	,  }(j,  K^j,  Kuuj,  }(j,  }(j,  K^j,  Kuj	,  }(j,  K^j,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj  Lthreshold_lines = int(config.max_file_lines * config.size_warning_threshold)j  j",  u}(j ,  pctj,  K
j,  }(j,  }(j,  K`j,  Kuj	,  }(j,  K`j,  Kuuj,  }(j,  }(j,  K`j,  Kuj	,  }(j,  K`j,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj  8pct = int(file_info.lines / config.max_file_lines * 100)j  j",  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j$,  j  j,  j  j,  uj  X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_file_size(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check if file exceeds maximum line count or warning threshold.

    P18: Shows function groups in size warnings to help agents decide what to extract.
    P25: Shows extractable groups with dependencies for warnings.

    Examples:
        >>> from invar.core.models import FileInfo, RuleConfig
        >>> check_file_size(FileInfo(path="ok.py", lines=100), RuleConfig())
        []
        >>> len(check_file_size(FileInfo(path="big.py", lines=600), RuleConfig()))
        1
        >>> # P8: Warning at 80% threshold (400 lines when max is 500)
        >>> vs = check_file_size(FileInfo(path="growing.py", lines=420), RuleConfig())
        >>> len(vs) == 1 and vs[0].rule == "file_size_warning"
        True
    """
    violations: list[Violation] = []
    # P18: Show top 5 largest functions in size warnings
    funcs = sorted(
        [
            (s.name, s.end_line - s.line + 1)
            for s in file_info.symbols
            if s.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD)
        ],
        key=lambda x: -x[1],
    )[:5]
    func_hint = f" Functions: {', '.join(f'{n}({sz}L)' for n, sz in funcs)}" if funcs else ""

    # P25: Get extractable groups with dependencies
    extraction_hint = format_extraction_hint(file_info)

    if file_info.lines > config.max_file_lines:
        suggestion = "Split into smaller modules."
        if extraction_hint:
            suggestion += f"\nExtractable groups:\n{extraction_hint}"
        elif func_hint:
            suggestion += func_hint
        violations.append(
            Violation(
                rule="file_size",
                severity=Severity.ERROR,
                file=file_info.path,
                line=None,
                message=f"File has {file_info.lines} lines (max: {config.max_file_lines})",
                suggestion=suggestion,
            )
        )
    # Phase 9 P8: Warning at configurable threshold (default 80%)
    elif config.size_warning_threshold > 0:
        threshold_lines = int(config.max_file_lines * config.size_warning_threshold)
        if file_info.lines >= threshold_lines:
            pct = int(file_info.lines / config.max_file_lines * 100)
            suggestion = "Consider splitting before reaching limit."
            if extraction_hint:
                suggestion += f"\nExtractable groups:\n{extraction_hint}"
            elif func_hint:
                suggestion += func_hint
            violations.append(
                Violation(
                    rule="file_size_warning",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=None,
                    message=f"File has {file_info.lines} lines ({pct}% of {config.max_file_lines} limit)",
                    suggestion=suggestion,
                )
            )

    return violationsj  Nu}(j ,  check_function_sizej,  Kj,  }(j,  }(j,  Ktj,  K uj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kuj,  Kuj	,  }(j,  Kuj,  Kuuj,  ](}(j ,  	file_infoj,  K
j,  }(j,  }(j,  Kuj,  Kuj	,  }(j,  Kuj,  K+uuj,  }(j,  }(j,  Kuj,  Kuj	,  }(j,  Kuj,  K+uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j,  u}(j ,  configj,  K
j,  }(j,  }(j,  Kuj,  K-uj	,  }(j,  Kuj,  K?uuj,  }(j,  }(j,  Kuj,  K-uj	,  }(j,  Kuj,  K?uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj  'config: RuleConfig) -> list[Violation]:j  j,  u}(j ,  
violationsj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj   violations: list[Violation] = []j  j,  u}(j ,  symbolj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj  symbol in file_info.symbols:j  j,  u}(j ,  total_linesj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj  /total_lines = symbol.end_line - symbol.line + 1j  j,  u}(j ,  
func_linesj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj  func_lines = symbol.code_linesj  j,  u}(j ,  	line_typej,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj  line_type = "code lines"j  j,  u}(j ,  	code_onlyj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj  .code_only = total_lines - symbol.doctest_linesj  j,  u}(j ,  	breakdownj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj  Cbreakdown = f" ({code_only} code + {symbol.doctest_lines} doctest)"j  j,  u}(j ,  
suggestionj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj  Ksuggestion = f"Extract helper or set exclude_doctest_lines=true{breakdown}"j  j,  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j,  j  j,  j  j,  uj  X	  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_function_size(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check if any function exceeds maximum line count.

    When use_code_lines is True, uses code_lines (excluding docstring).
    When exclude_doctest_lines is True, subtracts doctest lines from count.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind
        >>> sym = Symbol(name="foo", kind=SymbolKind.FUNCTION, line=1, end_line=10)
        >>> info = FileInfo(path="test.py", lines=20, symbols=[sym])
        >>> cfg = RuleConfig(max_function_lines=50)
        >>> check_function_size(info, cfg)
        []
    """
    violations: list[Violation] = []

    for symbol in file_info.symbols:
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            total_lines = symbol.end_line - symbol.line + 1
            # Calculate effective line count based on config
            if config.use_code_lines and symbol.code_lines is not None:
                func_lines = symbol.code_lines
                line_type = "code lines"
            else:
                func_lines = total_lines
                line_type = "lines"
            # Optionally exclude doctest lines
            if config.exclude_doctest_lines and symbol.doctest_lines > 0:
                func_lines -= symbol.doctest_lines
                line_type = f"{line_type} (excl. doctest)"

            if func_lines > config.max_function_lines:
                # P19: Show breakdown if doctest lines exist
                if symbol.doctest_lines > 0 and not config.exclude_doctest_lines:
                    code_only = total_lines - symbol.doctest_lines
                    breakdown = f" ({code_only} code + {symbol.doctest_lines} doctest)"
                    suggestion = f"Extract helper or set exclude_doctest_lines=true{breakdown}"
                else:
                    suggestion = "Extract helper functions"
                violations.append(
                    Violation(
                        rule="function_size",
                        severity=Severity.WARNING,
                        file=file_info.path,
                        line=symbol.line,
                        message=f"Function '{symbol.name}' has {func_lines} {line_type} (max: {config.max_function_lines})",
                        suggestion=suggestion,
                    )
                )

    return violationsj  Nu}(j ,  check_forbidden_importsj,  Kj,  }(j,  }(j,  Kj,  K uj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ](}(j ,  	file_infoj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  K/uuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  K/uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j)-  j  j,  j  j,  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j-  u}(j ,  configj,  K
j,  }(j,  }(j,  Kj,  K1uj	,  }(j,  Kj,  KCuuj,  }(j,  }(j,  Kj,  K1uj	,  }(j,  Kj,  KCuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j5-  j  j,  j  j,  uj  'config: RuleConfig) -> list[Violation]:j  j-  u}(j ,  
violationsj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  jA-  j  j,  j  j,  uj   violations: list[Violation] = []j  j-  u}(j ,  impj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  jM-  j  j,  j  j,  uj  imp in file_info.imports:j  j-  u}(j ,  altj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  jY-  j  j,  j  j,  uj  0alt = FORBIDDEN_IMPORT_ALTERNATIVES.get(imp, "")j  j-  u}(j ,  
suggestionj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  je-  j  j,  j  j,  uj  4suggestion = f"Move I/O code using '{imp}' to Shell"j  j-  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j -  j  j,  j  j,  uj  X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_forbidden_imports(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check for forbidden imports in Core files.

    Only applies to files marked as Core.

    Examples:
        >>> from invar.core.models import FileInfo
        >>> info = FileInfo(path="core/calc.py", lines=10, imports=["math"], is_core=True)
        >>> cfg = RuleConfig()
        >>> check_forbidden_imports(info, cfg)
        []
        >>> info = FileInfo(path="core/bad.py", lines=10, imports=["os"], is_core=True)
        >>> violations = check_forbidden_imports(info, cfg)
        >>> len(violations)
        1
    """
    violations: list[Violation] = []

    if not file_info.is_core:
        return violations

    for imp in file_info.imports:
        if imp in config.forbidden_imports:
            # P17: Include pure alternative in suggestion
            alt = FORBIDDEN_IMPORT_ALTERNATIVES.get(imp, "")
            suggestion = f"Move I/O code using '{imp}' to Shell"
            if alt:
                suggestion += f". Alternative: {alt}"
            violations.append(
                Violation(
                    rule="forbidden_import",
                    severity=Severity.ERROR,
                    file=file_info.path,
                    line=None,
                    message=f"Imports '{imp}' (forbidden in Core)",
                    suggestion=suggestion,
                )
            )

    return violationsj  Nu}(j ,  check_contractsj,  Kj,  }(j,  }(j,  Kj,  K uj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ](}(j ,  	file_infoj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  K'uuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  K'uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j}-  j  j,  j  j,  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  jr-  u}(j ,  configj,  K
j,  }(j,  }(j,  Kj,  K)uj	,  }(j,  Kj,  K;uuj,  }(j,  }(j,  Kj,  K)uj	,  }(j,  Kj,  K;uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj  'config: RuleConfig) -> list[Violation]:j  jr-  u}(j ,  
violationsj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj   violations: list[Violation] = []j  jr-  u}(j ,  symbolj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj  symbol in file_info.symbols:j  jr-  u}(j ,  	kind_namej,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj  Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"j  jr-  u}(j ,  
suggestionj,  K
j,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  }(j,  }(j,  Kj,  Kuj	,  }(j,  Kj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj  Hsuggestion = format_suggestion_for_violation(symbol, "missing_contract")j  jr-  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  jt-  j  j,  j  j,  uj  X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_contracts(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check that public Core functions have contracts.

    Only applies to files marked as Core when require_contracts is True.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract
        >>> contract = Contract(kind="pre", expression="x > 0", line=1)
        >>> sym = Symbol(name="calc", kind=SymbolKind.FUNCTION, line=1, end_line=5, contracts=[contract])
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> cfg = RuleConfig(require_contracts=True)
        >>> check_contracts(info, cfg)
        []
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.require_contracts:
        return violations

    for symbol in file_info.symbols:
        # Check all functions and methods - agent needs contracts everywhere
        if symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD) and not symbol.contracts:
            kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
            suggestion = format_suggestion_for_violation(symbol, "missing_contract")
            violations.append(
                Violation(
                    rule="missing_contract",
                    severity=Severity.ERROR,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"{kind_name} '{symbol.name}' has no @pre or @post contract",
                    suggestion=suggestion,
                )
            )

    return violationsj  Nu}(j ,  check_doctestsj,  Kj,  }(j,  }(j,  Kj,  K uj	,  }(j,  M.j,  Kuuj,  }(j,  }(j,  M j,  Kuj	,  }(j,  M j,  Kuuj,  ](}(j ,  	file_infoj,  K
j,  }(j,  }(j,  M j,  Kuj	,  }(j,  M j,  K&uuj,  }(j,  }(j,  M j,  Kuj	,  }(j,  M j,  K&uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j-  u}(j ,  configj,  K
j,  }(j,  }(j,  M j,  K(uj	,  }(j,  M j,  K:uuj,  }(j,  }(j,  M j,  K(uj	,  }(j,  M j,  K:uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj  'config: RuleConfig) -> list[Violation]:j  j-  u}(j ,  
violationsj,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj   violations: list[Violation] = []j  j-  u}(j ,  symbolj,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj  symbol in file_info.symbols:j  j-  u}(j ,  	name_partj,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  Mname_part = symbol.name.split(".")[-1] if "." in symbol.name else symbol.namej  j-  u}(j ,  	is_publicj,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j
.  j  j,  j  j,  uj  )is_public = not name_part.startswith("_")j  j-  u}(j ,  	kind_namej,  K
j,  }(j,  }(j,  M"j,  Kuj	,  }(j,  M"j,  Kuuj,  }(j,  }(j,  M"j,  Kuj	,  }(j,  M"j,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  Hkind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"j  j-  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j-  j  j,  j  j,  uj  X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_doctests(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check that contracted functions have doctest examples.

    Only applies to files marked as Core when require_doctests is True.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract
        >>> contract = Contract(kind="pre", expression="x > 0", line=1)
        >>> sym = Symbol(
        ...     name="calc", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     contracts=[contract], has_doctest=True
        ... )
        >>> info = FileInfo(path="core/calc.py", lines=10, symbols=[sym], is_core=True)
        >>> cfg = RuleConfig(require_doctests=True)
        >>> check_doctests(info, cfg)
        []
    """
    violations: list[Violation] = []

    if not file_info.is_core or not config.require_doctests:
        return violations

    for symbol in file_info.symbols:
        # Only public functions/methods require doctests (private can skip)
        # For methods, check if method name (after dot) starts with _
        name_part = symbol.name.split(".")[-1] if "." in symbol.name else symbol.name
        is_public = not name_part.startswith("_")
        if (
            symbol.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD)
            and is_public
            and symbol.contracts
            and not symbol.has_doctest
        ):
            kind_name = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
            violations.append(
                Violation(
                    rule="missing_doctest",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"{kind_name} '{symbol.name}' has contracts but no doctest examples",
                    suggestion="Add >>> examples in docstring",
                )
            )

    return violationsj  Nu}(j ,  check_shell_resultj,  Kj,  }(j,  }(j,  M1j,  K uj	,  }(j,  MXj,  Kuuj,  }(j,  }(j,  M2j,  Kuj	,  }(j,  M2j,  Kuuj,  ](}(j ,  	file_infoj,  K
j,  }(j,  }(j,  M2j,  Kuj	,  }(j,  M2j,  K*uuj,  }(j,  }(j,  M2j,  Kuj	,  }(j,  M2j,  K*uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j1.  j  j,  j  j,  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j&.  u}(j ,  configj,  K
j,  }(j,  }(j,  M2j,  K,uj	,  }(j,  M2j,  K>uuj,  }(j,  }(j,  M2j,  K,uj	,  }(j,  M2j,  K>uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j=.  j  j,  j  j,  uj  'config: RuleConfig) -> list[Violation]:j  j&.  u}(j ,  
violationsj,  K
j,  }(j,  }(j,  M@j,  Kuj	,  }(j,  M@j,  Kuuj,  }(j,  }(j,  M@j,  Kuj	,  }(j,  M@j,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  jI.  j  j,  j  j,  uj   violations: list[Violation] = []j  j&.  u}(j ,  symbolj,  K
j,  }(j,  }(j,  MDj,  Kuj	,  }(j,  MDj,  Kuuj,  }(j,  }(j,  MDj,  Kuj	,  }(j,  MDj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  jU.  j  j,  j  j,  uj  symbol in file_info.symbols:j  j&.  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j(.  j  j,  j  j,  uj  X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_shell_result(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Check that Shell functions with return values use Result[T, E].

    Skips: functions returning None (CLI entry points).

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, RuleConfig
        >>> sym = Symbol(name="load", kind=SymbolKind.FUNCTION, line=1, end_line=5,
        ...     signature="(path: str) -> Result[str, str]")
        >>> info = FileInfo(path="shell/fs.py", lines=10, symbols=[sym], is_shell=True)
        >>> check_shell_result(info, RuleConfig())
        []
    """
    violations: list[Violation] = []
    if not file_info.is_shell:
        return violations

    for symbol in file_info.symbols:
        if symbol.kind != SymbolKind.FUNCTION:
            continue
        # Skip functions with no return type or returning None
        if "-> None" in symbol.signature or "->" not in symbol.signature:
            continue
        # Skip generators (Iterator/Generator) - acceptable exception per protocol
        if "Iterator[" in symbol.signature or "Generator[" in symbol.signature:
            continue
        if "Result[" not in symbol.signature:
            violations.append(
                Violation(
                    rule="shell_result",
                    severity=Severity.WARNING,
                    file=file_info.path,
                    line=symbol.line,
                    message=f"Shell function '{symbol.name}' should return Result[T, E]",
                    suggestion="Use Result[T, E] from returns library",
                )
            )
    return violationsj  Nu}(j ,  
get_all_rulesj,  Kj,  }(j,  }(j,  M[j,  K uj	,  }(j,  Msj,  Kuuj,  }(j,  }(j,  M\j,  Kuj	,  }(j,  M\j,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  jd.  j  j,  j  j,  uj  Xy  @post(lambda result: len(result) > 0)
def get_all_rules() -> list[RuleFunc]:
    """
    Return all available rule functions.

    Examples:
        >>> len(get_all_rules()) >= 5
        True
    """
    return [
        check_file_size,
        check_function_size,
        check_forbidden_imports,
        check_contracts,
        check_doctests,
        check_shell_result,
        check_internal_imports,
        check_impure_calls,
        check_empty_contracts,
        check_semantic_tautology,
        check_redundant_type_contracts,
        check_param_mismatch,
        check_partial_contract,
        check_must_use,
    ]     j  Nu}(j ,  _apply_severity_overridej,  Kj,  }(j,  }(j,  Mvj,  K uj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mwj,  Kuj	,  }(j,  Mwj,  Kuuj,  ](}(j ,  j  j,  K
j,  }(j,  }(j,  Mwj,  Kuj	,  }(j,  Mwj,  K)uuj,  }(j,  }(j,  Mwj,  Kuj	,  }(j,  Mwj,  K)uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  jx.  j  j,  j  j,  uj  =v: Violation, overrides: dict[str, str]) -> Violation | None:j  jn.  u}(j ,  	overridesj,  K
j,  }(j,  }(j,  Mwj,  K+uj	,  }(j,  Mwj,  KDuuj,  }(j,  }(j,  Mwj,  K+uj	,  }(j,  Mwj,  KDuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  /overrides: dict[str, str]) -> Violation | None:j  jn.  u}(j ,  overridej,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj   override = overrides.get(v.rule)j  jn.  u}(j ,  severity_mapj,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  \severity_map = {"info": Severity.INFO, "warning": Severity.WARNING, "error": Severity.ERROR}j  jn.  u}(j ,  new_severityj,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  )new_severity = severity_map.get(override)j  jn.  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  jp.  j  j,  j  j,  uj  X  @post(lambda result: result is None or isinstance(result, Violation))
def _apply_severity_override(v: Violation, overrides: dict[str, str]) -> Violation | None:
    """
    Apply severity override to a violation.

    Returns None if rule is set to "off", otherwise returns violation
    with potentially updated severity.

    Examples:
        >>> from invar.core.models import Violation, Severity
        >>> v = Violation(rule="test", severity=Severity.INFO, file="x.py", message="msg")
        >>> _apply_severity_override(v, {"test": "off"}) is None
        True
        >>> v2 = _apply_severity_override(v, {"test": "error"})
        >>> v2.severity
        <Severity.ERROR: 'error'>
        >>> _apply_severity_override(v, {}).severity  # No override
        <Severity.INFO: 'info'>
    """
    override = overrides.get(v.rule)
    if override is None:
        return v
    if override == "off":
        return None
    # Map string to Severity enum
    severity_map = {"info": Severity.INFO, "warning": Severity.WARNING, "error": Severity.ERROR}
    new_severity = severity_map.get(override)
    if new_severity is None:
        return v  # Invalid override, keep original
    # Create new violation with updated severity
    return Violation(
        rule=v.rule,
        severity=new_severity,
        file=v.file,
        line=v.line,
        message=v.message,
        suggestion=v.suggestion,
    )j  Nu}(j ,  check_all_rulesj,  Kj,  }(j,  }(j,  Mj,  K uj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ](}(j ,  	file_infoj,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  K'uuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  K'uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j.  u}(j ,  configj,  K
j,  }(j,  }(j,  Mj,  K)uj	,  }(j,  Mj,  K;uuj,  }(j,  }(j,  Mj,  K)uj	,  }(j,  Mj,  K;uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  'config: RuleConfig) -> list[Violation]:j  j.  u}(j ,  excludedj,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  5excluded = get_excluded_rules(file_info.path, config)j  j.  u}(j ,  exclude_allj,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  exclude_all = "*" in excludedj  j.  u}(j ,  
violationsj,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  violations = []j  j.  u}(j ,  rulej,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  Kuuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  rule in get_all_rules():j  j.  u}(j ,  j  j,  K
j,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  K
uuj,  }(j,  }(j,  Mj,  Kuj	,  }(j,  Mj,  K
uuj,  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j/  j  j,  j  j,  uj  v in rule(file_info, config):j  j.  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/rules.pyj  j.  j  j,  j  j,  uj  X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_all_rules(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """
    Run all rules against a file and collect violations.

    Respects rule_exclusions and severity_overrides config.

    Examples:
        >>> from invar.core.models import FileInfo, RuleConfig, RuleExclusion
        >>> violations = check_all_rules(FileInfo(path="test.py", lines=50), RuleConfig())
        >>> isinstance(violations, list)
        True
        >>> # Test exclusion: file_size excluded for generated files
        >>> excl = RuleExclusion(pattern="**/generated/**", rules=["file_size"])
        >>> cfg = RuleConfig(rule_exclusions=[excl])
        >>> big_file = FileInfo(path="src/generated/data.py", lines=600)
        >>> vs = check_all_rules(big_file, cfg)
        >>> any(v.rule == "file_size" for v in vs)
        False
    """
    # Phase 9 P1: Get excluded rules for this file
    excluded = get_excluded_rules(file_info.path, config)
    exclude_all = "*" in excluded

    violations = []
    for rule in get_all_rules():
        for v in rule(file_info, config):
            # Skip if rule is excluded (either specifically or via "*")
            if exclude_all or v.rule in excluded:
                continue
            # Phase 9 P2: Apply severity overrides
            v = _apply_severity_override(v, config.severity_overrides)
            if v is not None:
                violations.append(v)
    return violationsj  Nueja  Nubj   33a9fbcc1f6c98945c6691bdc78108d7h)}(h](}(nameparse_sourcekindKrange}(start}(lineK	characterK uend}(j!/  K:j"/  KuuselectionRange}(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuchildren](}(j/  sourcej/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j-/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  src/invar/core/parser.pyuj  8source: str, path: str = "<string>") -> FileInfo | None:j  j/  u}(j/  pathj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K4uuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K4uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j;/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  +path: str = "<string>") -> FileInfo | None:j  j/  u}(j/  treej/  K
j/  }(j/  }(j!/  K-j"/  Kuj#/  }(j!/  K-j"/  Kuuj%/  }(j/  }(j!/  K-j"/  Kuj#/  }(j!/  K-j"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  jH/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  tree = ast.parse(source)j  j/  u}(j/  linesj/  K
j/  }(j/  }(j!/  K1j"/  Kuj#/  }(j!/  K1j"/  K	uuj%/  }(j/  }(j!/  K1j"/  Kuj#/  }(j!/  K1j"/  K	uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  jU/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  lines = source.count("\n") + 1j  j/  u}(j/  symbolsj/  K
j/  }(j/  }(j!/  K2j"/  Kuj#/  }(j!/  K2j"/  Kuuj%/  }(j/  }(j!/  K2j"/  Kuj#/  }(j!/  K2j"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  jb/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj   symbols = _extract_symbols(tree)j  j/  u}(j/  importsj/  K
j/  }(j/  }(j!/  K3j"/  Kuj#/  }(j!/  K3j"/  Kuuj%/  }(j/  }(j!/  K3j"/  Kuj#/  }(j!/  K3j"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  jo/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj   imports = _extract_imports(tree)j  j/  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  X  @pre(lambda source, path="<string>": isinstance(source, str))
def parse_source(source: str, path: str = "<string>") -> FileInfo | None:
    """
    Parse Python source code and extract symbols.

    Args:
        source: Python source code as string
        path: Path for reporting (not used for I/O)

    Returns:
        FileInfo with extracted symbols, or None if syntax error

    Examples:
        >>> info = parse_source("def foo(): pass")
        >>> info is not None
        True
        >>> len(info.symbols)
        1
        >>> info.symbols[0].name
        'foo'
    """
    try:
        tree = ast.parse(source)
    except SyntaxError:
        return None

    lines = source.count("\n") + 1
    symbols = _extract_symbols(tree)
    imports = _extract_imports(tree)

    return FileInfo(
        path=path,
        lines=lines,
        symbols=symbols,
        imports=imports,
    )j  Nu}(j/  _extract_symbolsj/  Kj/  }(j/  }(j!/  K=j"/  K uj#/  }(j!/  KYj"/  Kuuj%/  }(j/  }(j!/  K>j"/  Kuj#/  }(j!/  K>j"/  Kuuj)/  ](}(j/  treej/  K
j/  }(j/  }(j!/  K>j"/  Kuj#/  }(j!/  K>j"/  K%uuj%/  }(j/  }(j!/  K>j"/  Kuj#/  }(j!/  K>j"/  K%uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  "tree: ast.Module) -> list[Symbol]:j  j~/  u}(j/  symbolsj/  K
j/  }(j/  }(j!/  KMj"/  Kuj#/  }(j!/  KMj"/  Kuuj%/  }(j/  }(j!/  KMj"/  Kuj#/  }(j!/  KMj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  symbols: list[Symbol] = []j  j~/  u}(j/  nodej/  K
j/  }(j/  }(j!/  KOj"/  Kuj#/  }(j!/  KOj"/  Kuuj%/  }(j/  }(j!/  KOj"/  Kuj#/  }(j!/  KOj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  node in tree.body:j  j~/  u}(j/  itemj/  K
j/  }(j/  }(j!/  KUj"/  Kuj#/  }(j!/  KUj"/  Kuuj%/  }(j/  }(j!/  KUj"/  Kuj#/  }(j!/  KUj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  item in node.body:j  j~/  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  X  @pre(lambda tree: isinstance(tree, ast.Module))
def _extract_symbols(tree: ast.Module) -> list[Symbol]:
    """
    Extract function, class, and method symbols from AST.

    Examples:
        >>> import ast
        >>> tree = ast.parse("class Foo:\\n    def bar(self): pass")
        >>> symbols = _extract_symbols(tree)
        >>> len(symbols)
        2
        >>> symbols[0].kind.value
        'class'
        >>> symbols[1].kind.value
        'method'
    """
    symbols: list[Symbol] = []

    for node in tree.body:
        if isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef):
            symbols.append(_parse_function(node))
        elif isinstance(node, ast.ClassDef):
            symbols.append(_parse_class(node))
            # Extract methods from class body
            for item in node.body:
                if isinstance(item, ast.FunctionDef | ast.AsyncFunctionDef):
                    symbols.append(_parse_method(item, node.name))

    return symbolsj  Nu}(j/  _parse_functionj/  Kj/  }(j/  }(j!/  K\j"/  K uj#/  }(j!/  Kxj"/  Kuuj%/  }(j/  }(j!/  K^j"/  Kuj#/  }(j!/  K^j"/  Kuuj)/  ](}(j/  nodej/  K
j/  }(j/  }(j!/  K^j"/  Kuj#/  }(j!/  K^j"/  K@uuj%/  }(j/  }(j!/  K^j"/  Kuj#/  }(j!/  K^j"/  K@uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  8node: ast.FunctionDef | ast.AsyncFunctionDef) -> Symbol:j  j/  u}(j/  	contractsj/  K
j/  }(j/  }(j!/  K`j"/  Kuj#/  }(j!/  K`j"/  K
uuj%/  }(j/  }(j!/  K`j"/  Kuj#/  }(j!/  K`j"/  K
uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  $contracts = _extract_contracts(node)j  j/  u}(j/  	docstringj/  K
j/  }(j/  }(j!/  Kaj"/  Kuj#/  }(j!/  Kaj"/  K
uuj%/  }(j/  }(j!/  Kaj"/  Kuj#/  }(j!/  Kaj"/  K
uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  #docstring = ast.get_docstring(node)j  j/  u}(j/  has_doctestj/  K
j/  }(j/  }(j!/  Kbj"/  Kuj#/  }(j!/  Kbj"/  Kuuj%/  }(j/  }(j!/  Kbj"/  Kuj#/  }(j!/  Kbj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  :has_doctest = docstring is not None and ">>>" in docstringj  j/  u}(j/  	signaturej/  K
j/  }(j/  }(j!/  Kcj"/  Kuj#/  }(j!/  Kcj"/  K
uuj%/  }(j/  }(j!/  Kcj"/  Kuj#/  }(j!/  Kcj"/  K
uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  "signature = _build_signature(node)j  j/  u}(j/  internal_importsj/  K
j/  }(j/  }(j!/  Kdj"/  Kuj#/  }(j!/  Kdj"/  Kuuj%/  }(j/  }(j!/  Kdj"/  Kuj#/  }(j!/  Kdj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  1internal_imports = extract_internal_imports(node)j  j/  u}(j/  impure_callsj/  K
j/  }(j/  }(j!/  Kej"/  Kuj#/  }(j!/  Kej"/  Kuuj%/  }(j/  }(j!/  Kej"/  Kuj#/  }(j!/  Kej"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  )impure_calls = extract_impure_calls(node)j  j/  u}(j/  
code_linesj/  K
j/  }(j/  }(j!/  Kfj"/  Kuj#/  }(j!/  Kfj"/  Kuuj%/  }(j/  }(j!/  Kfj"/  Kuj#/  }(j!/  Kfj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j%0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  #code_lines = count_code_lines(node)j  j/  u}(j/  
doctest_linesj/  K
j/  }(j/  }(j!/  Kgj"/  Kuj#/  }(j!/  Kgj"/  Kuuj%/  }(j/  }(j!/  Kgj"/  Kuj#/  }(j!/  Kgj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j20  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  )doctest_lines = count_doctest_lines(node)j  j/  u}(j/  function_callsj/  K
j/  }(j/  }(j!/  Khj"/  Kuj#/  }(j!/  Khj"/  Kuuj%/  }(j/  }(j!/  Khj"/  Kuj#/  }(j!/  Khj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j?0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  4function_calls = extract_function_calls(node)  # P25j  j/  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j/  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: result.kind == SymbolKind.FUNCTION)
def _parse_function(node: ast.FunctionDef | ast.AsyncFunctionDef) -> Symbol:
    """Parse a function definition into a Symbol."""
    contracts = _extract_contracts(node)
    docstring = ast.get_docstring(node)
    has_doctest = docstring is not None and ">>>" in docstring
    signature = _build_signature(node)
    internal_imports = extract_internal_imports(node)
    impure_calls = extract_impure_calls(node)
    code_lines = count_code_lines(node)
    doctest_lines = count_doctest_lines(node)
    function_calls = extract_function_calls(node)  # P25

    return Symbol(
        name=node.name,
        kind=SymbolKind.FUNCTION,
        line=node.lineno,
        end_line=node.end_lineno or node.lineno,
        signature=signature,
        docstring=docstring,
        contracts=contracts,
        has_doctest=has_doctest,
        internal_imports=internal_imports,
        impure_calls=impure_calls,
        code_lines=code_lines,
        doctest_lines=doctest_lines,
        function_calls=function_calls,
    )j  Nu}(j/  
_parse_methodj/  Kj/  }(j/  }(j!/  K{j"/  K uj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  K}j"/  Kuj#/  }(j!/  K}j"/  Kuuj)/  ](}(j/  nodej/  K
j/  }(j/  }(j!/  K}j"/  Kuj#/  }(j!/  K}j"/  K>uuj%/  }(j/  }(j!/  K}j"/  Kuj#/  }(j!/  K}j"/  K>uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  jY0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  Inode: ast.FunctionDef | ast.AsyncFunctionDef, class_name: str) -> Symbol:j  jN0  u}(j/  
class_namej/  K
j/  }(j/  }(j!/  K}j"/  K@uj#/  }(j!/  K}j"/  KOuuj%/  }(j/  }(j!/  K}j"/  K@uj#/  }(j!/  K}j"/  KOuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  jf0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  class_name: str) -> Symbol:j  jN0  u}(j/  	contractsj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K
uuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K
uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  js0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  $contracts = _extract_contracts(node)j  jN0  u}(j/  	docstringj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K
uuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K
uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  #docstring = ast.get_docstring(node)j  jN0  u}(j/  has_doctestj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  :has_doctest = docstring is not None and ">>>" in docstringj  jN0  u}(j/  	signaturej/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K
uuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K
uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  "signature = _build_signature(node)j  jN0  u}(j/  internal_importsj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  1internal_imports = extract_internal_imports(node)j  jN0  u}(j/  impure_callsj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  )impure_calls = extract_impure_calls(node)j  jN0  u}(j/  
code_linesj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  #code_lines = count_code_lines(node)j  jN0  u}(j/  
doctest_linesj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  )doctest_lines = count_doctest_lines(node)j  jN0  u}(j/  function_callsj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  4function_calls = extract_function_calls(node)  # P25j  jN0  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  jP0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  X  @pre(lambda node, class_name: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: result.kind == SymbolKind.METHOD)
def _parse_method(node: ast.FunctionDef | ast.AsyncFunctionDef, class_name: str) -> Symbol:
    """
    Parse a method definition into a Symbol.

    Examples:
        >>> import ast
        >>> tree = ast.parse("class Foo:\\n    def bar(self): pass")
        >>> method_node = tree.body[0].body[0]
        >>> sym = _parse_method(method_node, "Foo")
        >>> sym.name
        'Foo.bar'
        >>> sym.kind.value
        'method'
    """
    contracts = _extract_contracts(node)
    docstring = ast.get_docstring(node)
    has_doctest = docstring is not None and ">>>" in docstring
    signature = _build_signature(node)
    internal_imports = extract_internal_imports(node)
    impure_calls = extract_impure_calls(node)
    code_lines = count_code_lines(node)
    doctest_lines = count_doctest_lines(node)
    function_calls = extract_function_calls(node)  # P25

    return Symbol(
        name=f"{class_name}.{node.name}",
        kind=SymbolKind.METHOD,
        line=node.lineno,
        end_line=node.end_lineno or node.lineno,
        signature=signature,
        docstring=docstring,
        contracts=contracts,
        has_doctest=has_doctest,
        internal_imports=internal_imports,
        impure_calls=impure_calls,
        code_lines=code_lines,
        doctest_lines=doctest_lines,
        function_calls=function_calls,
    )j  Nu}(j/  _parse_classj/  Kj/  }(j/  }(j!/  Kj"/  K uj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ](}(j/  nodej/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K#uuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K#uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  node: ast.ClassDef) -> Symbol:j  j0  u}(j/  	docstringj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K
uuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K
uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  #docstring = ast.get_docstring(node)j  j0  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j0  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  X  @pre(lambda node: isinstance(node, ast.ClassDef))
@post(lambda result: result.kind == SymbolKind.CLASS)
def _parse_class(node: ast.ClassDef) -> Symbol:
    """Parse a class definition into a Symbol."""
    docstring = ast.get_docstring(node)

    return Symbol(
        name=node.name,
        kind=SymbolKind.CLASS,
        line=node.lineno,
        end_line=node.end_lineno or node.lineno,
        docstring=docstring,
    )j  Nu}(j/  _extract_contractsj/  Kj/  }(j/  }(j!/  Kj"/  K uj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ](}(j/  nodej/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  KCuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  KCuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  @node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[Contract]:j  j1  u}(j/  	contractsj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K
uuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K
uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j)1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  contracts: list[Contract] = []j  j1  u}(j/  	decoratorj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j61  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  !decorator in node.decorator_list:j  j1  u}(j/  contractj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  jC1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  2contract = _parse_decorator_as_contract(decorator)j  j1  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: all(c.kind in ("pre", "post") for c in result))
def _extract_contracts(node: ast.FunctionDef | ast.AsyncFunctionDef) -> list[Contract]:
    """Extract @pre and @post contracts from function decorators."""
    contracts: list[Contract] = []

    for decorator in node.decorator_list:
        contract = _parse_decorator_as_contract(decorator)
        if contract:
            contracts.append(contract)

    return contractsj  Nu}(j/  _parse_decorator_as_contractj/  Kj/  }(j/  }(j!/  Kj"/  K uj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K uuj)/  ](}(j/  	decoratorj/  K
j/  }(j/  }(j!/  Kj"/  K!uj#/  }(j!/  Kj"/  K4uuj%/  }(j/  }(j!/  Kj"/  K!uj#/  }(j!/  Kj"/  K4uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j]1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  (decorator: ast.expr) -> Contract | None:j  jR1  u}(j/  funcj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  jj1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  func = decorator.funcj  jR1  u}(j/  exprj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  jw1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  *expr = _get_contract_expression(decorator)j  jR1  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  jT1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  X  @post(lambda result: result is None or result.kind in ("pre", "post"))
def _parse_decorator_as_contract(decorator: ast.expr) -> Contract | None:
    """Try to parse a decorator as a contract (@pre or @post)."""
    # Handle @pre(...) or @post(...)
    if isinstance(decorator, ast.Call):
        func = decorator.func
        if isinstance(func, ast.Name) and func.id in ("pre", "post"):
            expr = _get_contract_expression(decorator)
            return Contract(
                kind="pre" if func.id == "pre" else "post",
                expression=expr,
                line=decorator.lineno,
            )
        # Handle deal.pre(...) or deal.post(...)
        if isinstance(func, ast.Attribute) and func.attr in ("pre", "post"):
            expr = _get_contract_expression(decorator)
            return Contract(
                kind="pre" if func.attr == "pre" else "post",
                expression=expr,
                line=decorator.lineno,
            )

    return Nonej  Nu}(j/  _get_contract_expressionj/  Kj/  }(j/  }(j!/  Kj"/  K uj#/  }(j!/  Kj"/  K
uuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]}(j/  callj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K+uuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K+uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  call: ast.Call) -> str:j  j1  uaj  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  @pre(lambda call: isinstance(call, ast.Call))
def _get_contract_expression(call: ast.Call) -> str:
    """Extract the expression string from a contract decorator call."""
    if call.args:
        return ast.unparse(call.args[0])
    return ""j  Nu}(j/  _build_signaturej/  Kj/  }(j/  }(j!/  Kj"/  K uj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ](}(j/  nodej/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  KAuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  KAuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  5node: ast.FunctionDef | ast.AsyncFunctionDef) -> str:j  j1  u}(j/  argsj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  args = node.argsj  j1  u}(j/  partsj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K	uuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K	uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  parts: list[str] = []j  j1  u}(j/  argj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  arg in args.args:j  j1  u}(j/  partj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  part = arg.argj  j1  u}(j/  sigj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  sig = f"({', '.join(parts)})"j  j1  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  X  @pre(lambda node: isinstance(node, ast.FunctionDef | ast.AsyncFunctionDef))
@post(lambda result: result.startswith("(") and ")" in result)
def _build_signature(node: ast.FunctionDef | ast.AsyncFunctionDef) -> str:
    """Build a signature string from function arguments."""
    args = node.args
    parts: list[str] = []

    # Regular args
    for arg in args.args:
        part = arg.arg
        if arg.annotation:
            part += f": {ast.unparse(arg.annotation)}"
        parts.append(part)

    sig = f"({', '.join(parts)})"

    # Return type
    if node.returns:
        sig += f" -> {ast.unparse(node.returns)}"

    return sigj  Nu}(j/  _extract_importsj/  Kj/  }(j/  }(j!/  Kj"/  K uj#/  }(j!/  Mj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ](}(j/  treej/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K%uuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  K%uuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j2  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  tree: ast.Module) -> list[str]:j  j1  u}(j/  importsj/  K
j/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj%/  }(j/  }(j!/  Kj"/  Kuj#/  }(j!/  Kj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j2  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  imports: list[str] = []j  j1  u}(j/  nodej/  K
j/  }(j/  }(j!/  Mj"/  Kuj#/  }(j!/  Mj"/  Kuuj%/  }(j/  }(j!/  Mj"/  Kuj#/  }(j!/  Mj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j 2  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  node in tree.body:j  j1  u}(j/  aliasj/  K
j/  }(j/  }(j!/  Mj"/  Kuj#/  }(j!/  Mj"/  Kuuj%/  }(j/  }(j!/  Mj"/  Kuj#/  }(j!/  Mj"/  Kuuj)/  ]j  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j-2  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  alias in node.names:j  j1  uej  }(j  :file:///Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j1  j  3/Users/tefx/Projects/Invar/src/invar/core/parser.pyj  j7/  uj  XM  @pre(lambda tree: isinstance(tree, ast.Module))
@post(lambda result: all(isinstance(s, str) and s for s in result))
def _extract_imports(tree: ast.Module) -> list[str]:
    """Extract imported module names from AST (top-level only)."""
    imports: list[str] = []

    for node in tree.body:
        if isinstance(node, ast.Import):
            for alias in node.names:
                imports.append(alias.name.split(".")[0])
        elif isinstance(node, ast.ImportFrom) and node.module:
            imports.append(node.module.split(".")[0])

    return list(set(imports))  # Deduplicatej  Nueja  Nubj   dd4adff7ae129bc65ce0846356775487h)}(hj  ja  Nubj2   1a3a81d07805dd0c4ceb4692d45541deh)}(hj  ja  Nubj   e976d3e25b279042c092bca8faad5877h)}(h](}(name
get_exit_codekindKrange}(start}(lineK	characterK uend}(jQ2  K$jR2  KuuselectionRange}(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  Kuuchildren](}(jJ2  reportjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  K%uujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  K%uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j]2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  src/invar/core/utils.pyuj  *report: GuardReport, strict: bool) -> int:j  jI2  u}(jJ2  strictjL2  K
jM2  }(jO2  }(jQ2  KjR2  K'ujS2  }(jQ2  KjR2  K3uujU2  }(jO2  }(jQ2  KjR2  K'ujS2  }(jQ2  KjR2  K3uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jk2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  strict: bool) -> int:j  jI2  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jN2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  Xx  @pre(lambda report, strict: isinstance(report, GuardReport))
@post(lambda result: result in (0, 1))
def get_exit_code(report: GuardReport, strict: bool) -> int:
    """
    Determine exit code based on report and strict mode.

    Examples:
        >>> from invar.core.models import GuardReport
        >>> get_exit_code(GuardReport(files_checked=1), strict=False)
        0
        >>> report = GuardReport(files_checked=1)
        >>> report.errors = 1
        >>> get_exit_code(report, strict=False)
        1
    """
    if report.errors > 0:
        return 1
    if strict and report.warnings > 0:
        return 1
    return 0j  Nu}(jJ2  extract_guard_sectionjL2  KjM2  }(jO2  }(jQ2  K'jR2  K ujS2  }(jQ2  KBjR2  K5uujU2  }(jO2  }(jQ2  K)jR2  KujS2  }(jQ2  K)jR2  KuujY2  ](}(jJ2  datajL2  K
jM2  }(jO2  }(jQ2  K)jR2  KujS2  }(jQ2  K)jR2  K.uujU2  }(jO2  }(jQ2  K)jR2  KujS2  }(jQ2  K)jR2  K.uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  5data: dict[str, Any], source: str) -> dict[str, Any]:j  jz2  u}(jJ2  sourcejL2  K
jM2  }(jO2  }(jQ2  K)jR2  K0ujS2  }(jQ2  K)jR2  K;uujU2  }(jO2  }(jQ2  K)jR2  K0ujS2  }(jQ2  K)jR2  K;uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  source: str) -> dict[str, Any]:j  jz2  u}(jJ2  resultjL2  K
jM2  }(jO2  }(jQ2  K8jR2  KujS2  }(jQ2  K8jR2  KuujU2  }(jO2  }(jQ2  K8jR2  KujS2  }(jQ2  K8jR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  result = data.get("tool", {})j  jz2  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j|2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  Xa  @pre(lambda data, source: isinstance(data, dict) and isinstance(source, str))
@post(lambda result: isinstance(result, dict))
def extract_guard_section(data: dict[str, Any], source: str) -> dict[str, Any]:
    """
    Extract guard config section based on source type.

    Examples:
        >>> extract_guard_section({"tool": {"invar": {"guard": {"x": 1}}}}, "pyproject")
        {'x': 1}
        >>> extract_guard_section({"guard": {"y": 2}}, "invar")
        {'y': 2}
        >>> extract_guard_section({}, "default")
        {}
        >>> extract_guard_section({"guard": 0}, "invar")  # Non-dict value returns empty
        {}
    """
    if source == "pyproject":
        result = data.get("tool", {})
        if not isinstance(result, dict):
            return {}
        result = result.get("invar", {})
        if not isinstance(result, dict):
            return {}
        result = result.get("guard", {})
        return result if isinstance(result, dict) else {}
    # invar.toml and .invar/config.toml use [guard] directly
    result = data.get("guard", {})
    return result if isinstance(result, dict) else {}j  Nu}(jJ2  	_get_booljL2  KjM2  }(jO2  }(jQ2  KEjR2  K ujS2  }(jQ2  KSjR2  KuujU2  }(jO2  }(jQ2  KGjR2  KujS2  }(jQ2  KGjR2  K
uujY2  ](}(jJ2  configjL2  K
jM2  }(jO2  }(jQ2  KGjR2  KujS2  }(jQ2  KGjR2  K$uujU2  }(jO2  }(jQ2  KGjR2  KujS2  }(jQ2  KGjR2  K$uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  1config: dict[str, Any], key: str) -> bool | None:j  j2  u}(jJ2  keyjL2  K
jM2  }(jO2  }(jQ2  KGjR2  K&ujS2  }(jQ2  KGjR2  K.uujU2  }(jO2  }(jQ2  KGjR2  K&ujS2  }(jQ2  KGjR2  K.uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  key: str) -> bool | None:j  j2  u}(jJ2  valjL2  K
jM2  }(jO2  }(jQ2  KPjR2  KujS2  }(jQ2  KPjR2  KuujU2  }(jO2  }(jQ2  KPjR2  KujS2  }(jQ2  KPjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  val = config.get(key)j  j2  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  X  @pre(lambda config, key: isinstance(config, dict) and isinstance(key, str))
@post(lambda result: result is None or isinstance(result, bool))
def _get_bool(config: dict[str, Any], key: str) -> bool | None:
    """
    Safely extract a boolean from config, returning None if invalid.

    >>> _get_bool({"a": True}, "a")
    True
    >>> _get_bool({"a": "not bool"}, "a") is None
    True
    """
    val = config.get(key)
    if isinstance(val, bool):
        return bool(val)  # Convert to ensure real Python bool
    return Nonej  Nu}(jJ2  _get_intjL2  KjM2  }(jO2  }(jQ2  KVjR2  K ujS2  }(jQ2  KdjR2  KuujU2  }(jO2  }(jQ2  KXjR2  KujS2  }(jQ2  KXjR2  KuujY2  ](}(jJ2  configjL2  K
jM2  }(jO2  }(jQ2  KXjR2  K
ujS2  }(jQ2  KXjR2  K#uujU2  }(jO2  }(jQ2  KXjR2  K
ujS2  }(jQ2  KXjR2  K#uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  0config: dict[str, Any], key: str) -> int | None:j  j2  u}(jJ2  keyjL2  K
jM2  }(jO2  }(jQ2  KXjR2  K%ujS2  }(jQ2  KXjR2  K-uujU2  }(jO2  }(jQ2  KXjR2  K%ujS2  }(jQ2  KXjR2  K-uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  key: str) -> int | None:j  j2  u}(jJ2  valjL2  K
jM2  }(jO2  }(jQ2  KajR2  KujS2  }(jQ2  KajR2  KuujU2  }(jO2  }(jQ2  KajR2  KujS2  }(jQ2  KajR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  val = config.get(key)j  j2  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j2  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  X#  @pre(lambda config, key: isinstance(config, dict) and isinstance(key, str))
@post(lambda result: result is None or isinstance(result, int))
def _get_int(config: dict[str, Any], key: str) -> int | None:
    """
    Safely extract an integer from config, returning None if invalid.

    >>> _get_int({"a": 42}, "a")
    42
    >>> _get_int({"a": "not int"}, "a") is None
    True
    """
    val = config.get(key)
    if isinstance(val, int) and not isinstance(val, bool):
        return int(val)  # Convert to ensure real Python int
    return Nonej  Nu}(jJ2  
_get_floatjL2  KjM2  }(jO2  }(jQ2  KgjR2  K ujS2  }(jQ2  KwjR2  KuujU2  }(jO2  }(jQ2  KijR2  KujS2  }(jQ2  KijR2  KuujY2  ](}(jJ2  configjL2  K
jM2  }(jO2  }(jQ2  KijR2  KujS2  }(jQ2  KijR2  K%uujU2  }(jO2  }(jQ2  KijR2  KujS2  }(jQ2  KijR2  K%uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j!3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  2config: dict[str, Any], key: str) -> float | None:j  j3  u}(jJ2  keyjL2  K
jM2  }(jO2  }(jQ2  KijR2  K'ujS2  }(jQ2  KijR2  K/uujU2  }(jO2  }(jQ2  KijR2  K'ujS2  }(jQ2  KijR2  K/uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j.3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  key: str) -> float | None:j  j3  u}(jJ2  valjL2  K
jM2  }(jO2  }(jQ2  KtjR2  KujS2  }(jQ2  KtjR2  KuujU2  }(jO2  }(jQ2  KtjR2  KujS2  }(jQ2  KtjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j;3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  val = config.get(key)j  j3  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  XB  @pre(lambda config, key: isinstance(config, dict) and isinstance(key, str))
@post(lambda result: result is None or isinstance(result, float))
def _get_float(config: dict[str, Any], key: str) -> float | None:
    """
    Safely extract a float from config, returning None if invalid.

    >>> _get_float({"a": 3.14}, "a")
    3.14
    >>> _get_float({"a": 10}, "a")
    10.0
    >>> _get_float({"a": "not float"}, "a") is None
    True
    """
    val = config.get(key)
    if isinstance(val, (int, float)) and not isinstance(val, bool):
        return float(val)
    return Nonej  Nu}(jJ2  parse_guard_configjL2  KjM2  }(jO2  }(jQ2  KzjR2  K ujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  K|jR2  KujS2  }(jQ2  K|jR2  KuujY2  ](}(jJ2  guard_configjL2  K
jM2  }(jO2  }(jQ2  K|jR2  KujS2  }(jQ2  K|jR2  K3uujU2  }(jO2  }(jQ2  K|jR2  KujS2  }(jQ2  K|jR2  K3uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jU3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  ,guard_config: dict[str, Any]) -> RuleConfig:j  jJ3  u}(jJ2  kwargsjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  K
uujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  K
uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jb3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  kwargs: dict[str, Any] = {}j  jJ3  u}(jJ2  valjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jo3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  .val = _get_int(guard_config, "max_file_lines")j  jJ3  u}(jJ2  j  jL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  K	uujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  K	uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j{3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  %v = guard_config["forbidden_imports"]j  jJ3  u}(jJ2  bvaljL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  3bval = _get_bool(guard_config, "require_contracts")j  jJ3  u}(jJ2  raw_exclusionsjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  0raw_exclusions = guard_config["rule_exclusions"]j  jJ3  u}(jJ2  
exclusionsjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  exclusions = []j  jJ3  u}(jJ2  excljL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  excl in raw_exclusions:j  jJ3  u}(jJ2  patternjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  pattern = excl["pattern"]j  jJ3  u}(jJ2  rulesjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  rules = excl["rules"]j  jJ3  u}(jJ2  
raw_overridesjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  2raw_overrides = guard_config["severity_overrides"]j  jJ3  u}(jJ2  defaultsjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  =defaults: dict[str, str] = {"redundant_type_contract": "off"}j  jJ3  u}(jJ2  kjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  k, v in raw_overrides.items():j  jJ3  u}(jJ2  fvaljL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  9fval = _get_float(guard_config, "size_warning_threshold")j  jJ3  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jL3  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  X  @pre(lambda guard_config: isinstance(guard_config, dict))
@post(lambda result: isinstance(result, RuleConfig))
def parse_guard_config(guard_config: dict[str, Any]) -> RuleConfig:
    """
    Parse configuration from guard section.

    Examples:
        >>> cfg = parse_guard_config({"max_file_lines": 400})
        >>> cfg.max_file_lines
        400
        >>> cfg = parse_guard_config({})
        >>> cfg.max_file_lines  # Phase 9 P1: Default is now 500
        500
        >>> cfg = parse_guard_config({"rule_exclusions": [{"pattern": "**/gen/**", "rules": ["*"]}]})
        >>> len(cfg.rule_exclusions)
        1
        >>> cfg.rule_exclusions[0].pattern
        '**/gen/**'
        >>> cfg = parse_guard_config({"use_code_lines": "invalid"})  # Invalid type ignored
        >>> cfg.use_code_lines  # Falls back to model default (False)
        False
    """
    kwargs: dict[str, Any] = {}

    val = _get_int(guard_config, "max_file_lines")
    if val is not None:
        kwargs["max_file_lines"] = val

    val = _get_int(guard_config, "max_function_lines")
    if val is not None:
        kwargs["max_function_lines"] = val

    if "forbidden_imports" in guard_config:
        v = guard_config["forbidden_imports"]
        if isinstance(v, (list, tuple)):
            kwargs["forbidden_imports"] = tuple(v)

    bval = _get_bool(guard_config, "require_contracts")
    if bval is not None:
        kwargs["require_contracts"] = bval

    bval = _get_bool(guard_config, "require_doctests")
    if bval is not None:
        kwargs["require_doctests"] = bval

    bval = _get_bool(guard_config, "strict_pure")
    if bval is not None:
        kwargs["strict_pure"] = bval

    bval = _get_bool(guard_config, "use_code_lines")
    if bval is not None:
        kwargs["use_code_lines"] = bval

    bval = _get_bool(guard_config, "exclude_doctest_lines")
    if bval is not None:
        kwargs["exclude_doctest_lines"] = bval

    # Phase 9 P1: Parse rule_exclusions
    if "rule_exclusions" in guard_config:
        raw_exclusions = guard_config["rule_exclusions"]
        if isinstance(raw_exclusions, list):
            exclusions = []
            for excl in raw_exclusions:
                if isinstance(excl, dict) and "pattern" in excl and "rules" in excl:
                    pattern = excl["pattern"]
                    rules = excl["rules"]
                    if isinstance(pattern, str) and isinstance(rules, list):
                        exclusions.append(
                            RuleExclusion(pattern=str(pattern), rules=[str(r) for r in rules])
                        )
            if exclusions:
                kwargs["rule_exclusions"] = exclusions

    # Phase 9 P2: Parse severity_overrides (merge with defaults)
    if "severity_overrides" in guard_config:
        raw_overrides = guard_config["severity_overrides"]
        if isinstance(raw_overrides, dict):
            defaults: dict[str, str] = {"redundant_type_contract": "off"}
            for k, v in raw_overrides.items():
                if isinstance(k, str) and isinstance(v, str):
                    defaults[str(k)] = str(v)  # Convert to real Python strings
            kwargs["severity_overrides"] = defaults

    # Phase 9 P8: Parse size_warning_threshold
    fval = _get_float(guard_config, "size_warning_threshold")
    if fval is not None:
        kwargs["size_warning_threshold"] = fval

    # B4: Parse purity declarations
    if "purity_pure" in guard_config:
        v = guard_config["purity_pure"]
        if isinstance(v, (list, tuple)):
            kwargs["purity_pure"] = [str(x) for x in v if isinstance(x, str)]
    if "purity_impure" in guard_config:
        v = guard_config["purity_impure"]
        if isinstance(v, (list, tuple)):
            kwargs["purity_impure"] = [str(x) for x in v if isinstance(x, str)]

    try:
        return RuleConfig(**kwargs)
    except Exception:
        # Invalid config values - return defaults
        return RuleConfig()j  Nu}(jJ2  matches_patternjL2  KjM2  }(jO2  }(jQ2  KjR2  K ujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ](}(jJ2  	file_pathjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  K"uujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  K"uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  -file_path: str, patterns: list[str]) -> bool:j  j4  u}(jJ2  patternsjL2  K
jM2  }(jO2  }(jQ2  KjR2  K$ujS2  }(jQ2  KjR2  K7uujU2  }(jO2  }(jQ2  KjR2  K$ujS2  }(jQ2  KjR2  K7uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j$4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  patterns: list[str]) -> bool:j  j4  u}(jJ2  patternjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j14  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  pattern in patterns:j  j4  u}(jJ2  partsjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j>4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  parts = file_path.split("/")j  j4  u}(jJ2  jz  jL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jJ4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  i in range(len(parts)):j  j4  u}(jJ2  subpathjL2  K
jM2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujU2  }(jO2  }(jQ2  KjR2  KujS2  }(jQ2  KjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jW4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  subpath = "/".join(parts[i:])j  j4  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  XP  @pre(lambda file_path, patterns: isinstance(file_path, str) and isinstance(patterns, list))
def matches_pattern(file_path: str, patterns: list[str]) -> bool:
    """
    Check if a file path matches any of the glob patterns.

    Examples:
        >>> matches_pattern("src/domain/models.py", ["**/domain/**"])
        True
        >>> matches_pattern("src/api/views.py", ["**/domain/**"])
        False
        >>> matches_pattern("src/core/logic.py", ["src/core/**", "**/models/**"])
        True
    """
    for pattern in patterns:
        if fnmatch.fnmatch(file_path, pattern):
            return True
        # Also check with leading path component for ** patterns
        if pattern.startswith("**/"):
            # Match anywhere in path
            if fnmatch.fnmatch(file_path, pattern[3:]):
                return True
            # Try matching each subpath
            parts = file_path.split("/")
            for i in range(len(parts)):
                subpath = "/".join(parts[i:])
                if fnmatch.fnmatch(subpath, pattern[3:]):
                    return True
    return Falsej  Nu}(jJ2  matches_path_prefixjL2  KjM2  }(jO2  }(jQ2  MjR2  K ujS2  }(jQ2  MjR2  K9uujU2  }(jO2  }(jQ2  MjR2  KujS2  }(jQ2  MjR2  KuujY2  ](}(jJ2  	file_pathjL2  K
jM2  }(jO2  }(jQ2  MjR2  KujS2  }(jQ2  MjR2  K&uujU2  }(jO2  }(jQ2  MjR2  KujS2  }(jQ2  MjR2  K&uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jq4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  -file_path: str, prefixes: list[str]) -> bool:j  jf4  u}(jJ2  prefixesjL2  K
jM2  }(jO2  }(jQ2  MjR2  K(ujS2  }(jQ2  MjR2  K;uujU2  }(jO2  }(jQ2  MjR2  K(ujS2  }(jQ2  MjR2  K;uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j~4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  prefixes: list[str]) -> bool:j  jf4  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jh4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  X  @pre(lambda file_path, prefixes: isinstance(file_path, str) and isinstance(prefixes, list))
def matches_path_prefix(file_path: str, prefixes: list[str]) -> bool:
    """
    Check if file_path starts with any of the given prefixes.

    Examples:
        >>> matches_path_prefix("src/core/logic.py", ["src/core", "src/domain"])
        True
        >>> matches_path_prefix("src/shell/cli.py", ["src/core", "src/domain"])
        False
    """
    return any(file_path.startswith(p) for p in prefixes)j  Nu}(jJ2  match_glob_patternjL2  KjM2  }(jO2  }(jQ2  MjR2  K ujS2  }(jQ2  MDjR2  KuujU2  }(jO2  }(jQ2  MjR2  KujS2  }(jQ2  MjR2  KuujY2  ](}(jJ2  	file_pathjL2  K
jM2  }(jO2  }(jQ2  MjR2  KujS2  }(jQ2  MjR2  K%uujU2  }(jO2  }(jQ2  MjR2  KujS2  }(jQ2  MjR2  K%uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  &file_path: str, pattern: str) -> bool:j  j4  u}(jJ2  patternjL2  K
jM2  }(jO2  }(jQ2  MjR2  K'ujS2  }(jQ2  MjR2  K3uujU2  }(jO2  }(jQ2  MjR2  K'ujS2  }(jQ2  MjR2  K3uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  pattern: str) -> bool:j  j4  u}(jJ2  
path_partsjL2  K
jM2  }(jO2  }(jQ2  M,jR2  KujS2  }(jQ2  M,jR2  KuujU2  }(jO2  }(jQ2  M,jR2  KujS2  }(jQ2  M,jR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  !path_parts = file_path.split("/")j  j4  u}(jJ2  middlejL2  K
jM2  }(jO2  }(jQ2  M.jR2  KujS2  }(jQ2  M.jR2  KuujU2  }(jO2  }(jQ2  M.jR2  KujS2  }(jQ2  M.jR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  middle = pattern[3:-3]j  j4  u}(jJ2  suffixjL2  K
jM2  }(jO2  }(jQ2  M2jR2  KujS2  }(jQ2  M2jR2  KuujU2  }(jO2  }(jQ2  M2jR2  KujS2  }(jQ2  M2jR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  suffix = pattern[3:]j  j4  u}(jJ2  jz  jL2  K
jM2  }(jO2  }(jQ2  M3jR2  KujS2  }(jQ2  M3jR2  K
uujU2  }(jO2  }(jQ2  M3jR2  KujS2  }(jQ2  M3jR2  K
uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  i in range(len(path_parts)):j  j4  u}(jJ2  prefixjL2  K
jM2  }(jO2  }(jQ2  M8jR2  KujS2  }(jQ2  M8jR2  KuujU2  }(jO2  }(jQ2  M8jR2  KujS2  }(jQ2  M8jR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  prefix = pattern[:-3]j  j4  u}(jJ2  partsjL2  K
jM2  }(jO2  }(jQ2  M:jR2  KujS2  }(jQ2  M:jR2  K	uujU2  }(jO2  }(jQ2  M:jR2  KujS2  }(jQ2  M:jR2  K	uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  parts = pattern.split("**/")j  j4  u}(jJ2  headjL2  K
jM2  }(jO2  }(jQ2  M>jR2  KujS2  }(jQ2  M>jR2  KuujU2  }(jO2  }(jQ2  M>jR2  KujS2  }(jQ2  M>jR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  0head = "/".join(path_parts[:i]) if i > 0 else ""j  j4  u}(jJ2  tailjL2  K
jM2  }(jO2  }(jQ2  M?jR2  KujS2  }(jQ2  M?jR2  KuujU2  }(jO2  }(jQ2  M?jR2  KujS2  }(jQ2  M?jR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j5  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  tail = "/".join(path_parts[i:])j  j4  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j4  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  X  @post(lambda result: isinstance(result, bool))
def match_glob_pattern(file_path: str, pattern: str) -> bool:
    """
    Check if file path matches a glob pattern with ** support.

    Uses fnmatch for single-segment wildcards, handles ** for multi-segment.

    Examples:
        >>> match_glob_pattern("src/generated/foo.py", "**/generated/**")
        True
        >>> match_glob_pattern("generated/foo.py", "**/generated/**")
        True
        >>> match_glob_pattern("src/core/calc.py", "**/generated/**")
        False
        >>> match_glob_pattern("src/core/data.py", "src/core/data.py")
        True
        >>> match_glob_pattern("src/core/calc.py", "src/core/*.py")
        True
        >>> match_glob_pattern("src/core/sub/calc.py", "src/core/*.py")
        False
        >>> match_glob_pattern("src/core/sub/calc.py", "src/core/**/*.py")
        True
    """
    file_path = file_path.replace("\\", "/")
    pattern = pattern.replace("\\", "/")
    if "**" not in pattern:
        if file_path.count("/") != pattern.count("/"):
            return False
        return fnmatch.fnmatch(file_path, pattern)
    path_parts = file_path.split("/")
    if pattern.startswith("**/") and pattern.endswith("/**"):
        middle = pattern[3:-3]
        if "/" not in middle and "*" not in middle:
            return middle in path_parts[:-1]
    if pattern.startswith("**/") and not pattern.endswith("/**"):
        suffix = pattern[3:]
        for i in range(len(path_parts)):
            if fnmatch.fnmatch("/".join(path_parts[i:]), suffix):
                return True
        return False
    if pattern.endswith("/**") and not pattern.startswith("**/"):
        prefix = pattern[:-3]
        return file_path.startswith(prefix + "/") or file_path == prefix
    parts = pattern.split("**/")
    if len(parts) == 2:
        prefix, suffix = parts[0].rstrip("/"), parts[1].lstrip("/").rstrip("/**")
        for i in range(len(path_parts) + 1):
            head = "/".join(path_parts[:i]) if i > 0 else ""
            tail = "/".join(path_parts[i:])
            if (not prefix or fnmatch.fnmatch(head, prefix)) and (
                not suffix or fnmatch.fnmatch(tail, suffix) or fnmatch.fnmatch(tail, "*/" + suffix)
            ):
                return True
    return Falsep     j  Nu}(jJ2  get_excluded_rulesjL2  KjM2  }(jO2  }(jQ2  MGjR2  K ujS2  }(jQ2  M]jR2  KuujU2  }(jO2  }(jQ2  MHjR2  KujS2  }(jQ2  MHjR2  KuujY2  ](}(jJ2  	file_pathjL2  K
jM2  }(jO2  }(jQ2  MHjR2  KujS2  }(jQ2  MHjR2  K%uujU2  }(jO2  }(jQ2  MHjR2  KujS2  }(jQ2  MHjR2  K%uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j&5  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  0file_path: str, config: RuleConfig) -> set[str]:j  j5  u}(jJ2  configjL2  K
jM2  }(jO2  }(jQ2  MHjR2  K'ujS2  }(jQ2  MHjR2  K9uujU2  }(jO2  }(jQ2  MHjR2  K'ujS2  }(jQ2  MHjR2  K9uujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j35  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj   config: RuleConfig) -> set[str]:j  j5  u}(jJ2  excludedjL2  K
jM2  }(jO2  }(jQ2  MYjR2  KujS2  }(jQ2  MYjR2  KuujU2  }(jO2  }(jQ2  MYjR2  KujS2  }(jQ2  MYjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j@5  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  excluded: set[str] = set()j  j5  u}(jJ2  	exclusionjL2  K
jM2  }(jO2  }(jQ2  MZjR2  KujS2  }(jQ2  MZjR2  KuujU2  }(jO2  }(jQ2  MZjR2  KujS2  }(jQ2  MZjR2  KuujY2  ]j  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jM5  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  $exclusion in config.rule_exclusions:j  j5  uej  }(j  9file:///Users/tefx/Projects/Invar/src/invar/core/utils.pyj  j5  j  2/Users/tefx/Projects/Invar/src/invar/core/utils.pyj  jg2  uj  X  @pre(lambda file_path, config: isinstance(config, RuleConfig))
def get_excluded_rules(file_path: str, config: RuleConfig) -> set[str]:
    """
    Get the set of rules to exclude for a given file path.

    Examples:
        >>> from invar.core.models import RuleConfig, RuleExclusion
        >>> excl = RuleExclusion(pattern="**/generated/**", rules=["*"])
        >>> cfg = RuleConfig(rule_exclusions=[excl])
        >>> get_excluded_rules("src/generated/foo.py", cfg)
        {'*'}
        >>> get_excluded_rules("src/core/calc.py", cfg)
        set()
        >>> excl2 = RuleExclusion(pattern="**/data/**", rules=["file_size"])
        >>> cfg2 = RuleConfig(rule_exclusions=[excl, excl2])
        >>> sorted(get_excluded_rules("src/data/big.py", cfg2))
        ['file_size']
    """
    excluded: set[str] = set()
    for exclusion in config.rule_exclusions:
        if match_glob_pattern(file_path, exclusion.pattern):
            excluded.update(exclusion.rules)
    return excludedj  Nueja  Nubj   265451569eb2f4c4f012fc17f94ddf14h)}(hj  ja  Nubj?   2c1730910a3c5e3b22cff2a17a1579f1h)}(h](}(nameis_empty_contractkindKrange}(start}(lineK	characterK uend}(jm5  K*jn5  KuuselectionRange}(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuchildren](}(jf5  
expressionjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K%uujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K%uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jy5  j  6/Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  src/invar/core/contracts.pyuj  expression: str) -> bool:j  je5  u}(jf5  treejh5  K
ji5  }(jk5  }(jm5  K"jn5  Kujo5  }(jm5  K"jn5  Kuujq5  }(jk5  }(jm5  K"jn5  Kujo5  }(jm5  K"jn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j5  j  j5  j  j5  uj  )tree = ast.parse(expression, mode="eval")j  je5  u}(jf5  lambda_nodejh5  K
ji5  }(jk5  }(jm5  K#jn5  Kujo5  }(jm5  K#jn5  Kuujq5  }(jk5  }(jm5  K#jn5  Kujo5  }(jm5  K#jn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j5  j  j5  j  j5  uj  lambda_node = find_lambda(tree)j  je5  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jj5  j  j5  j  j5  uj  X	  @pre(lambda expression: "lambda" in expression or not expression.strip())
def is_empty_contract(expression: str) -> bool:
    """Check if a contract expression is always True (tautological).

    Examples:
        >>> is_empty_contract("lambda: True"), is_empty_contract("lambda x: True")
        (True, True)
        >>> is_empty_contract("lambda x: x > 0"), is_empty_contract("")
        (False, False)
    """
    if not expression.strip():
        return False
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        return (
            lambda_node is not None
            and isinstance(lambda_node.body, ast.Constant)
            and lambda_node.body.value is True
        )
    except SyntaxError:
        return Falsej  Nu}(jf5  is_semantic_tautologyjh5  Kji5  }(jk5  }(jm5  K0jn5  K ujo5  }(jm5  KRjn5  Kuujq5  }(jk5  }(jm5  K1jn5  Kujo5  }(jm5  K1jn5  Kuuju5  ](}(jf5  
expressionjh5  K
ji5  }(jk5  }(jm5  K1jn5  Kujo5  }(jm5  K1jn5  K)uujq5  }(jk5  }(jm5  K1jn5  Kujo5  }(jm5  K1jn5  K)uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j5  j  j5  j  j5  uj  %expression: str) -> tuple[bool, str]:j  j5  u}(jf5  treejh5  K
ji5  }(jk5  }(jm5  KLjn5  Kujo5  }(jm5  KLjn5  Kuujq5  }(jk5  }(jm5  KLjn5  Kujo5  }(jm5  KLjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j5  j  j5  j  j5  uj  )tree = ast.parse(expression, mode="eval")j  j5  u}(jf5  lambda_nodejh5  K
ji5  }(jk5  }(jm5  KMjn5  Kujo5  }(jm5  KMjn5  Kuujq5  }(jk5  }(jm5  KMjn5  Kujo5  }(jm5  KMjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j5  j  j5  j  j5  uj  lambda_node = find_lambda(tree)j  j5  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j5  j  j5  j  j5  uj  X{  @pre(lambda expression: "lambda" in expression or not expression.strip())
def is_semantic_tautology(expression: str) -> tuple[bool, str]:
    """Check if a contract expression is a semantic tautology.

    Returns (is_tautology, pattern_description).

    P7: Detects patterns that are always true:
    - x == x (identity comparison)
    - len(x) >= 0 (length always non-negative)
    - isinstance(x, object) (everything is object)
    - x or True (always true due to True)
    - True and x (simplifies but starts with True)

    Examples:
        >>> is_semantic_tautology("lambda x: x == x")
        (True, 'x == x is always True')
        >>> is_semantic_tautology("lambda x: len(x) >= 0")
        (True, 'len(x) >= 0 is always True for any sequence')
        >>> is_semantic_tautology("lambda x: isinstance(x, object)")
        (True, 'isinstance(x, object) is always True')
        >>> is_semantic_tautology("lambda x: x > 0")
        (False, '')
        >>> is_semantic_tautology("lambda x: x or True")
        (True, 'expression contains unconditional True')
    """
    if not expression.strip():
        return (False, "")
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        if lambda_node is None:
            return (False, "")
        return _check_tautology_patterns(lambda_node.body)
    except SyntaxError:
        return (False, "")j  Nu}(jf5  _check_tautology_patternsjh5  Kji5  }(jk5  }(jm5  KUjn5  K ujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  KVjn5  Kujo5  }(jm5  KVjn5  Kuuju5  ](}(jf5  nodejh5  K
ji5  }(jk5  }(jm5  KVjn5  Kujo5  }(jm5  KVjn5  K,uujq5  }(jk5  }(jm5  KVjn5  Kujo5  }(jm5  KVjn5  K,uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j5  j  j5  j  j5  uj  $node: ast.expr) -> tuple[bool, str]:j  j5  u}(jf5  leftjh5  K
ji5  }(jk5  }(jm5  K^jn5  Kujo5  }(jm5  K^jn5  Kuujq5  }(jk5  }(jm5  K^jn5  Kujo5  }(jm5  K^jn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j5  j  j5  j  j5  uj  left = ast.unparse(node.left)j  j5  u}(jf5  rightjh5  K
ji5  }(jk5  }(jm5  K_jn5  Kujo5  }(jm5  K_jn5  K
uujq5  }(jk5  }(jm5  K_jn5  Kujo5  }(jm5  K_jn5  K
uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j5  j  j5  j  j5  uj  (right = ast.unparse(node.comparators[0])j  j5  u}(jf5  opjh5  K
ji5  }(jk5  }(jm5  Kfjn5  Kujo5  }(jm5  Kfjn5  K
uujq5  }(jk5  }(jm5  Kfjn5  Kujo5  }(jm5  Kfjn5  K
uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j5  j  j5  j  j5  uj  op = node.ops[0]j  j5  u}(jf5  argjh5  K
ji5  }(jk5  }(jm5  Kpjn5  Kujo5  }(jm5  Kpjn5  Kuujq5  }(jk5  }(jm5  Kpjn5  Kujo5  }(jm5  Kpjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  5arg = ast.unparse(left.args[0]) if left.args else "x"j  j5  u}(jf5  type_argjh5  K
ji5  }(jk5  }(jm5  Kzjn5  Kujo5  }(jm5  Kzjn5  Kuujq5  }(jk5  }(jm5  Kzjn5  Kujo5  }(jm5  Kzjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  type_arg = node.args[1]j  j5  u}(jf5  valjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j#6  j  j5  j  j5  uj  val in node.values:j  j5  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j5  j  j5  j  j5  uj  X  @post(lambda result: isinstance(result, tuple) and len(result) == 2)
def _check_tautology_patterns(node: ast.expr) -> tuple[bool, str]:
    """Check for common tautology patterns in AST node."""
    # Identity comparison pattern (e.g., x == x)
    if (
        isinstance(node, ast.Compare)
        and len(node.ops) == 1
        and isinstance(node.ops[0], (ast.Eq, ast.Is))
    ):
        left = ast.unparse(node.left)
        right = ast.unparse(node.comparators[0])
        if left == right:
            return (True, f"{left} == {right} is always True")

    # Length non-negative pattern (e.g., len(x) >= 0)
    if isinstance(node, ast.Compare) and len(node.ops) == 1 and len(node.comparators) == 1:
        left = node.left
        op = node.ops[0]
        right = node.comparators[0]
        if (
            isinstance(left, ast.Call)
            and isinstance(left.func, ast.Name)
            and left.func.id == "len"
            and isinstance(op, ast.GtE)
            and isinstance(right, ast.Constant)
            and right.value == 0
        ):
            arg = ast.unparse(left.args[0]) if left.args else "x"
            return (True, f"len({arg}) >= 0 is always True for any sequence")

    # isinstance with object pattern (always True)
    if (
        isinstance(node, ast.Call)
        and isinstance(node.func, ast.Name)
        and node.func.id == "isinstance"
        and len(node.args) == 2
    ):
        type_arg = node.args[1]
        if isinstance(type_arg, ast.Name) and type_arg.id == "object":
            arg = ast.unparse(node.args[0])
            return (True, f"isinstance({arg}, object) is always True")

    # Pattern: x or True, True or x (always true)
    if isinstance(node, ast.BoolOp) and isinstance(node.op, ast.Or):
        for val in node.values:
            if isinstance(val, ast.Constant) and val.value is True:
                return (True, "expression contains unconditional True")

    return (False, "")j  Nu}(jf5  is_redundant_type_contractjh5  Kji5  }(jk5  }(jm5  Kjn5  K ujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ](}(jf5  
expressionjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K.uujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K.uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j;6  j  j5  j  j5  uj  6expression: str, annotations: dict[str, str]) -> bool:j  j06  u}(jf5  annotationsjh5  K
ji5  }(jk5  }(jm5  Kjn5  K0ujo5  }(jm5  Kjn5  KKuujq5  }(jk5  }(jm5  Kjn5  K0ujo5  }(jm5  Kjn5  KKuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jG6  j  j5  j  j5  uj  %annotations: dict[str, str]) -> bool:j  j06  u}(jf5  treejh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jS6  j  j5  j  j5  uj  )tree = ast.parse(expression, mode="eval")j  j06  u}(jf5  lambda_nodejh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j_6  j  j5  j  j5  uj  lambda_node = find_lambda(tree)j  j06  u}(jf5  checksjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jk6  j  j5  j  j5  uj  5checks = _extract_isinstance_checks(lambda_node.body)j  j06  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j26  j  j5  j  j5  uj  X  @pre(lambda expression, annotations: "lambda" in expression or not expression.strip())
def is_redundant_type_contract(expression: str, annotations: dict[str, str]) -> bool:
    """Check if a contract only checks types already in annotations.

    Examples:
        >>> is_redundant_type_contract("lambda x: isinstance(x, int)", {"x": "int"})
        True
        >>> is_redundant_type_contract("lambda x: isinstance(x, int) and x > 0", {"x": "int"})
        False
    """
    if not expression.strip() or not annotations:
        return False
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        if lambda_node is None:
            return False
        checks = _extract_isinstance_checks(lambda_node.body)
        if checks is None:
            return False
        return all(p in annotations and _types_match(annotations[p], t) for p, t in checks)
    except SyntaxError:
        return Falsej  Nu}(jf5  _extract_isinstance_checksjh5  Kji5  }(jk5  }(jm5  Kjn5  K ujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ](}(jf5  nodejh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K-uujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K-uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  0node: ast.expr) -> list[tuple[str, str]] | None:j  jx6  u}(jf5  checkjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K
uujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K
uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  $check = _parse_isinstance_call(node)j  jx6  u}(jf5  checksjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  Tchecks = [_parse_isinstance_call(v) for v in node.values if isinstance(v, ast.Call)]j  jx6  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jz6  j  j5  j  j5  uj  XZ  @post(lambda result: result is None or isinstance(result, list))
def _extract_isinstance_checks(node: ast.expr) -> list[tuple[str, str]] | None:
    """Extract isinstance checks. Returns None if other logic present."""
    if isinstance(node, ast.Call):
        check = _parse_isinstance_call(node)
        return [check] if check else None
    if isinstance(node, ast.BoolOp) and isinstance(node.op, ast.And):
        checks = [_parse_isinstance_call(v) for v in node.values if isinstance(v, ast.Call)]
        return checks if len(checks) == len(node.values) and all(checks) else None
    return Nonej  Nu}(jf5  _parse_isinstance_calljh5  Kji5  }(jk5  }(jm5  Kjn5  K ujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ](}(jf5  nodejh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K)uujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K)uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  *node: ast.Call) -> tuple[str, str] | None:j  j6  u}(jf5  paramjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K	uujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K	uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  /param, type_arg = node.args[0].id, node.args[1]j  j6  u}(jf5  type_argjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  (type_arg = node.args[0].id, node.args[1]j  j6  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  X  @post(lambda result: result is None or (isinstance(result, tuple) and len(result) == 2))
def _parse_isinstance_call(node: ast.Call) -> tuple[str, str] | None:
    """Parse isinstance(x, Type) call. Returns (param, type) or None."""
    if not (isinstance(node.func, ast.Name) and node.func.id == "isinstance"):
        return None
    if len(node.args) != 2 or not isinstance(node.args[0], ast.Name):
        return None
    param, type_arg = node.args[0].id, node.args[1]
    if isinstance(type_arg, ast.Name):
        return (param, type_arg.id)
    if isinstance(type_arg, ast.Attribute):
        return (param, type_arg.attr)
    return Nonej  Nu}(jf5  _types_matchjh5  Kji5  }(jk5  }(jm5  Kjn5  K ujo5  }(jm5  Kjn5  K@uujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ](}(jf5  
annotationjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K uujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  )annotation: str, type_name: str) -> bool:j  j6  u}(jf5  	type_namejh5  K
ji5  }(jk5  }(jm5  Kjn5  K"ujo5  }(jm5  Kjn5  K0uujq5  }(jk5  }(jm5  Kjn5  K"ujo5  }(jm5  Kjn5  K0uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  type_name: str) -> bool:j  j6  u}(jf5  
base_matchjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  .base_match = re.match(r"^(\w+)\[", annotation)j  j6  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j6  j  j5  j  j5  uj  X  @post(lambda result: isinstance(result, bool))
def _types_match(annotation: str, type_name: str) -> bool:
    """Check if type annotation matches isinstance check.

    Examples:
        >>> _types_match("int", "int"), _types_match("list[int]", "list")
        (True, True)
    """
    if annotation == type_name:
        return True
    base_match = re.match(r"^(\w+)\[", annotation)
    return bool(base_match and base_match.group(1) == type_name)j  Nu}(jf5  has_unused_paramsjh5  Kji5  }(jk5  }(jm5  Kjn5  K ujo5  }(jm5  Kjn5  K?uujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ](}(jf5  
expressionjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K%uujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  K%uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  Fexpression: str, signature: str) -> tuple[bool, list[str], list[str]]:j  j7  u}(jf5  	signaturejh5  K
ji5  }(jk5  }(jm5  Kjn5  K'ujo5  }(jm5  Kjn5  K5uujq5  }(jk5  }(jm5  Kjn5  K'ujo5  }(jm5  Kjn5  K5uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  5signature: str) -> tuple[bool, list[str], list[str]]:j  j7  u}(jf5  
lambda_paramsjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j+7  j  j5  j  j5  uj  1lambda_params = extract_lambda_params(expression)j  j7  u}(jf5  func_paramsjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j77  j  j5  j  j5  uj  1func_params = extract_func_param_names(signature)j  j7  u}(jf5  treejh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jC7  j  j5  j  j5  uj  )tree = ast.parse(expression, mode="eval")j  j7  u}(jf5  lambda_nodejh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jO7  j  j5  j  j5  uj  lambda_node = find_lambda(tree)j  j7  u}(jf5  
used_namesjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j[7  j  j5  j  j5  uj  1used_names = extract_used_names(lambda_node.body)j  j7  u}(jf5  used_paramsjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jg7  j  j5  j  j5  uj  ;used_params = [p for p in lambda_params if p in used_names]j  j7  u}(jf5  
unused_paramsjh5  K
ji5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuujq5  }(jk5  }(jm5  Kjn5  Kujo5  }(jm5  Kjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  js7  j  j5  j  j5  uj  Aunused_params = [p for p in lambda_params if p not in used_names]j  j7  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j
7  j  j5  j  j5  uj  X  @pre(lambda expression, signature: "lambda" in expression or not expression.strip())
def has_unused_params(expression: str, signature: str) -> tuple[bool, list[str], list[str]]:
    """
    Check if lambda has params it doesn't use (P28: Partial Contract Detection).

    Returns (has_unused, unused_params, used_params).

    Different from param_mismatch:
    - param_mismatch: lambda param COUNT != function param count (ERROR)
    - unused_params: lambda has all params but doesn't USE all (WARN)

    Examples:
        >>> has_unused_params("lambda x, y: x > 0", "(x: int, y: int) -> int")
        (True, ['y'], ['x'])
        >>> has_unused_params("lambda x, y: x > 0 and y < 10", "(x: int, y: int) -> int")
        (False, [], ['x', 'y'])
        >>> has_unused_params("lambda x: x > 0", "(x: int, y: int) -> int")
        (False, [], [])
        >>> has_unused_params("lambda items: len(items) > 0", "(items: list) -> int")
        (False, [], ['items'])
    """
    if not expression.strip() or not signature:
        return (False, [], [])

    lambda_params = extract_lambda_params(expression)
    func_params = extract_func_param_names(signature)

    if lambda_params is None or func_params is None:
        return (False, [], [])

    # Only check when lambda has same param count as function
    # (if different count, that's param_mismatch, not this check)
    if len(lambda_params) != len(func_params):
        return (False, [], [])

    # Extract used names from lambda body
    try:
        tree = ast.parse(expression, mode="eval")
        lambda_node = find_lambda(tree)
        if lambda_node is None:
            return (False, [], [])
        used_names = extract_used_names(lambda_node.body)
    except SyntaxError:
        return (False, [], [])

    # Check which params are actually used
    used_params = [p for p in lambda_params if p in used_names]
    unused_params = [p for p in lambda_params if p not in used_names]

    return (len(unused_params) > 0, unused_params, used_params)j  Nu}(jf5  has_param_mismatchjh5  Kji5  }(jk5  }(jm5  Mjn5  K ujo5  }(jm5  M!jn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ](}(jf5  
expressionjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  K&uujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  K&uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  5expression: str, signature: str) -> tuple[bool, str]:j  j7  u}(jf5  	signaturejh5  K
ji5  }(jk5  }(jm5  Mjn5  K(ujo5  }(jm5  Mjn5  K6uujq5  }(jk5  }(jm5  Mjn5  K(ujo5  }(jm5  Mjn5  K6uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  $signature: str) -> tuple[bool, str]:j  j7  u}(jf5  
lambda_paramsjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  1lambda_params = extract_lambda_params(expression)j  j7  u}(jf5  func_paramsjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  1func_params = extract_func_param_names(signature)j  j7  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  X  @pre(lambda expression, signature: "lambda" in expression or not expression.strip())
def has_param_mismatch(expression: str, signature: str) -> tuple[bool, str]:
    """
    Check if lambda params don't match function params.

    Returns (has_mismatch, error_description).

    Examples:
        >>> has_param_mismatch("lambda x: x > 0", "(x: int, y: int) -> int")
        (True, 'lambda has 1 param(s) but function has 2')
        >>> has_param_mismatch("lambda x, y: x > 0", "(x: int, y: int) -> int")
        (False, '')
        >>> has_param_mismatch("lambda x, y=0: x > 0", "(x: int, y: int = 0) -> int")
        (False, '')
        >>> has_param_mismatch("lambda: True", "() -> bool")
        (False, '')
    """
    if not expression.strip() or not signature:
        return (False, "")

    lambda_params = extract_lambda_params(expression)
    func_params = extract_func_param_names(signature)

    if lambda_params is None or func_params is None:
        return (False, "")  # Can't determine, skip

    if len(lambda_params) != len(func_params):
        return (
            True,
            f"lambda has {len(lambda_params)} param(s) but function has {len(func_params)}",
        )

    return (False, "")j  Nu}(jf5  check_empty_contractsjh5  Kji5  }(jk5  }(jm5  M'jn5  K ujo5  }(jm5  MEjn5  Kuujq5  }(jk5  }(jm5  M(jn5  Kujo5  }(jm5  M(jn5  Kuuju5  ](}(jf5  	file_infojh5  K
ji5  }(jk5  }(jm5  M(jn5  Kujo5  }(jm5  M(jn5  K-uujq5  }(jk5  }(jm5  M(jn5  Kujo5  }(jm5  M(jn5  K-uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j7  u}(jf5  configjh5  K
ji5  }(jk5  }(jm5  M(jn5  K/ujo5  }(jm5  M(jn5  KAuujq5  }(jk5  }(jm5  M(jn5  K/ujo5  }(jm5  M(jn5  KAuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  'config: RuleConfig) -> list[Violation]:j  j7  u}(jf5  
violationsjh5  K
ji5  }(jk5  }(jm5  M2jn5  Kujo5  }(jm5  M2jn5  Kuujq5  }(jk5  }(jm5  M2jn5  Kujo5  }(jm5  M2jn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj   violations: list[Violation] = []j  j7  u}(jf5  symboljh5  K
ji5  }(jk5  }(jm5  M5jn5  Kujo5  }(jm5  M5jn5  Kuujq5  }(jk5  }(jm5  M5jn5  Kujo5  }(jm5  M5jn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  symbol in file_info.symbols:j  j7  u}(jf5  contractjh5  K
ji5  }(jk5  }(jm5  M8jn5  Kujo5  }(jm5  M8jn5  Kuujq5  }(jk5  }(jm5  M8jn5  Kujo5  }(jm5  M8jn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  contract in symbol.contracts:j  j7  u}(jf5  kindjh5  K
ji5  }(jk5  }(jm5  M:jn5  Kujo5  }(jm5  M:jn5  Kuujq5  }(jk5  }(jm5  M:jn5  Kujo5  }(jm5  M:jn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"j  j7  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j7  j  j5  j  j5  uj  X!  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_empty_contracts(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check for empty/tautological contracts. Core files only.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: True", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, contracts=[c])
        >>> check_empty_contracts(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())[0].rule
        'empty_contract'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            continue
        for contract in symbol.contracts:
            if is_empty_contract(contract.expression):
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(
                    Violation(
                        rule="empty_contract",
                        severity=Severity.ERROR,
                        file=file_info.path,
                        line=contract.line,
                        message=f"{kind} '{symbol.name}' has empty contract: @{contract.kind}({contract.expression})",
                        suggestion=format_suggestion_for_violation(symbol, "empty_contract"),
                    )
                )
    return violationsj  Nu}(jf5  check_semantic_tautologyjh5  Kji5  }(jk5  }(jm5  MHjn5  K ujo5  }(jm5  Mkjn5  Kuujq5  }(jk5  }(jm5  MIjn5  Kujo5  }(jm5  MIjn5  Kuuju5  ](}(jf5  	file_infojh5  K
ji5  }(jk5  }(jm5  MIjn5  Kujo5  }(jm5  MIjn5  K0uujq5  }(jk5  }(jm5  MIjn5  Kujo5  }(jm5  MIjn5  K0uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j8  u}(jf5  configjh5  K
ji5  }(jk5  }(jm5  MIjn5  K2ujo5  }(jm5  MIjn5  KDuujq5  }(jk5  }(jm5  MIjn5  K2ujo5  }(jm5  MIjn5  KDuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j'8  j  j5  j  j5  uj  'config: RuleConfig) -> list[Violation]:j  j8  u}(jf5  
violationsjh5  K
ji5  }(jk5  }(jm5  MWjn5  Kujo5  }(jm5  MWjn5  Kuujq5  }(jk5  }(jm5  MWjn5  Kujo5  }(jm5  MWjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j38  j  j5  j  j5  uj   violations: list[Violation] = []j  j8  u}(jf5  symboljh5  K
ji5  }(jk5  }(jm5  MZjn5  Kujo5  }(jm5  MZjn5  Kuujq5  }(jk5  }(jm5  MZjn5  Kujo5  }(jm5  MZjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j?8  j  j5  j  j5  uj  symbol in file_info.symbols:j  j8  u}(jf5  contractjh5  K
ji5  }(jk5  }(jm5  M]jn5  Kujo5  }(jm5  M]jn5  Kuujq5  }(jk5  }(jm5  M]jn5  Kujo5  }(jm5  M]jn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jK8  j  j5  j  j5  uj  contract in symbol.contracts:j  j8  u}(jf5  is_tautologyjh5  K
ji5  }(jk5  }(jm5  M^jn5  Kujo5  }(jm5  M^jn5  Kuujq5  }(jk5  }(jm5  M^jn5  Kujo5  }(jm5  M^jn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jW8  j  j5  j  j5  uj  Gis_tautology, pattern_desc = is_semantic_tautology(contract.expression)j  j8  u}(jf5  pattern_descjh5  K
ji5  }(jk5  }(jm5  M^jn5  Kujo5  }(jm5  M^jn5  K&uujq5  }(jk5  }(jm5  M^jn5  Kujo5  }(jm5  M^jn5  K&uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jc8  j  j5  j  j5  uj  9pattern_desc = is_semantic_tautology(contract.expression)j  j8  u}(jf5  kindjh5  K
ji5  }(jk5  }(jm5  M`jn5  Kujo5  }(jm5  M`jn5  Kuujq5  }(jk5  }(jm5  M`jn5  Kujo5  }(jm5  M`jn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jo8  j  j5  j  j5  uj  Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"j  j8  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  X  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_semantic_tautology(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check for semantic tautology contracts. Core files only.

    P7: Detects contracts that are always true due to semantic patterns:
    - x == x, len(x) >= 0, isinstance(x, object), x or True

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: x == x", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, contracts=[c])
        >>> vs = check_semantic_tautology(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())
        >>> vs[0].rule
        'semantic_tautology'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            continue
        for contract in symbol.contracts:
            is_tautology, pattern_desc = is_semantic_tautology(contract.expression)
            if is_tautology:
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(
                    Violation(
                        rule="semantic_tautology",
                        severity=Severity.WARNING,
                        file=file_info.path,
                        line=contract.line,
                        message=f"{kind} '{symbol.name}' has tautological contract: {pattern_desc}",
                        suggestion=format_suggestion_for_violation(symbol, "semantic_tautology"),
                    )
                )
    return violationsj  Nu}(jf5  check_redundant_type_contractsjh5  Kji5  }(jk5  }(jm5  Mnjn5  K ujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mojn5  Kujo5  }(jm5  Mojn5  K"uuju5  ](}(jf5  	file_infojh5  K
ji5  }(jk5  }(jm5  Mojn5  K#ujo5  }(jm5  Mojn5  K6uujq5  }(jk5  }(jm5  Mojn5  K#ujo5  }(jm5  Mojn5  K6uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j|8  u}(jf5  configjh5  K
ji5  }(jk5  }(jm5  Mojn5  K8ujo5  }(jm5  Mojn5  KJuujq5  }(jk5  }(jm5  Mojn5  K8ujo5  }(jm5  Mojn5  KJuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  'config: RuleConfig) -> list[Violation]:j  j|8  u}(jf5  
violationsjh5  K
ji5  }(jk5  }(jm5  Myjn5  Kujo5  }(jm5  Myjn5  Kuujq5  }(jk5  }(jm5  Myjn5  Kujo5  }(jm5  Myjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj   violations: list[Violation] = []j  j|8  u}(jf5  symboljh5  K
ji5  }(jk5  }(jm5  M|jn5  Kujo5  }(jm5  M|jn5  Kuujq5  }(jk5  }(jm5  M|jn5  Kujo5  }(jm5  M|jn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  symbol in file_info.symbols:j  j|8  u}(jf5  annotationsjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  3annotations = extract_annotations(symbol.signature)j  j|8  u}(jf5  contractjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  contract in symbol.contracts:j  j|8  u}(jf5  kindjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"j  j|8  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j~8  j  j5  j  j5  uj  X?  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_redundant_type_contracts(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check for contracts that only check types in annotations. Core files only. INFO severity.

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: isinstance(x, int)", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, signature="(x: int) -> int", contracts=[c])
        >>> check_redundant_type_contracts(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())[0].severity.value
        'info'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            continue
        annotations = extract_annotations(symbol.signature)
        if not annotations:
            continue
        for contract in symbol.contracts:
            if is_redundant_type_contract(contract.expression, annotations):
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                violations.append(
                    Violation(
                        rule="redundant_type_contract",
                        severity=Severity.INFO,
                        file=file_info.path,
                        line=contract.line,
                        message=f"{kind} '{symbol.name}' contract only checks types already in annotations",
                        suggestion=format_suggestion_for_violation(
                            symbol, "redundant_type_contract"
                        ),
                    )
                )
    return violationsj  Nu}(jf5  check_param_mismatchjh5  Kji5  }(jk5  }(jm5  Mjn5  K ujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ](}(jf5  	file_infojh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  K,uujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  K,uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  j8  u}(jf5  configjh5  K
ji5  }(jk5  }(jm5  Mjn5  K.ujo5  }(jm5  Mjn5  K@uujq5  }(jk5  }(jm5  Mjn5  K.ujo5  }(jm5  Mjn5  K@uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  'config: RuleConfig) -> list[Violation]:j  j8  u}(jf5  
violationsjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj   violations: list[Violation] = []j  j8  u}(jf5  symboljh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j9  j  j5  j  j5  uj  symbol in file_info.symbols:j  j8  u}(jf5  contractjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j9  j  j5  j  j5  uj  contract in symbol.contracts:j  j8  u}(jf5  mismatchjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j#9  j  j5  j  j5  uj  Jmismatch, desc = has_param_mismatch(contract.expression, symbol.signature)j  j8  u}(jf5  descjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j/9  j  j5  j  j5  uj  @desc = has_param_mismatch(contract.expression, symbol.signature)j  j8  u}(jf5  kindjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j;9  j  j5  j  j5  uj  Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"j  j8  u}(jf5  fix_templatejh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jG9  j  j5  j  j5  uj  4fix_template = generate_lambda_fix(symbol.signature)j  j8  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j8  j  j5  j  j5  uj  X=  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_param_mismatch(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check @pre lambda params match function params. Core files only. ERROR severity.

    Only checks @pre contracts (@post takes 'result' param, different signature).

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x: x > 0", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, signature="(x: int, y: int) -> int", contracts=[c])
        >>> v = check_param_mismatch(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())[0]
        >>> v.rule
        'param_mismatch'
        >>> v.suggestion  # DX-01: Now includes fix template
        'Fix: @pre(lambda x, y: <condition>)'
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD) or not symbol.signature:
            continue
        for contract in symbol.contracts:
            # Only check @pre contracts (not @post which takes 'result')
            if contract.kind != "pre":
                continue
            mismatch, desc = has_param_mismatch(contract.expression, symbol.signature)
            if mismatch:
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                # DX-01: Generate copy-pastable lambda fix template
                fix_template = generate_lambda_fix(symbol.signature)
                violations.append(
                    Violation(
                        rule="param_mismatch",
                        severity=Severity.ERROR,
                        file=file_info.path,
                        line=contract.line,
                        message=f"{kind} '{symbol.name}' @pre {desc}",
                        suggestion=f"Fix: {fix_template}",
                    )
                )
    return violationsj  Nu}(jf5  check_partial_contractjh5  Kji5  }(jk5  }(jm5  Mjn5  K ujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ](}(jf5  	file_infojh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  K.uujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  K.uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j_9  j  j5  j  j5  uj  <file_info: FileInfo, config: RuleConfig) -> list[Violation]:j  jT9  u}(jf5  configjh5  K
ji5  }(jk5  }(jm5  Mjn5  K0ujo5  }(jm5  Mjn5  KBuujq5  }(jk5  }(jm5  Mjn5  K0ujo5  }(jm5  Mjn5  KBuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jk9  j  j5  j  j5  uj  'config: RuleConfig) -> list[Violation]:j  jT9  u}(jf5  
violationsjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jw9  j  j5  j  j5  uj   violations: list[Violation] = []j  jT9  u}(jf5  symboljh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j9  j  j5  j  j5  uj  symbol in file_info.symbols:j  jT9  u}(jf5  contractjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j9  j  j5  j  j5  uj  contract in symbol.contracts:j  jT9  u}(jf5  
has_unusedjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j9  j  j5  j  j5  uj  Shas_unused, unused, used = has_unused_params(contract.expression, symbol.signature)j  jT9  u}(jf5  unusedjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j9  j  j5  j  j5  uj  Gunused, used = has_unused_params(contract.expression, symbol.signature)j  jT9  u}(jf5  usedjh5  K
ji5  }(jk5  }(jm5  Mjn5  K ujo5  }(jm5  Mjn5  K$uujq5  }(jk5  }(jm5  Mjn5  K ujo5  }(jm5  Mjn5  K$uuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j9  j  j5  j  j5  uj  ?used = has_unused_params(contract.expression, symbol.signature)j  jT9  u}(jf5  kindjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j9  j  j5  j  j5  uj  Ckind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"j  jT9  u}(jf5  
unused_strjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j9  j  j5  j  j5  uj  0unused_str = ", ".join(f"'{p}'" for p in unused)j  jT9  u}(jf5  used_strjh5  K
ji5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuujq5  }(jk5  }(jm5  Mjn5  Kujo5  }(jm5  Mjn5  Kuuju5  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  j9  j  j5  j  j5  uj  @used_str = ", ".join(f"'{p}'" for p in used) if used else "none"j  jT9  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/core/contracts.pyj  jV9  j  j5  j  j5  uj  X	  @pre(lambda file_info, config: isinstance(file_info, FileInfo))
def check_partial_contract(file_info: FileInfo, config: RuleConfig) -> list[Violation]:
    """Check @pre contracts that don't use all declared params (P28). Core files only. WARN severity.

    P28: Detects hidden formal compliance - lambda declares all params but doesn't use all.
    Forces Agent to think about whether unchecked params need constraints.

    Different from param_mismatch (P8.3):
    - param_mismatch: lambda param COUNT != function param count (ERROR)
    - partial_contract: lambda has all params but doesn't USE all (WARN)

    Examples:
        >>> from invar.core.models import FileInfo, Symbol, SymbolKind, Contract, RuleConfig
        >>> c = Contract(kind="pre", expression="lambda x, y: x > 0", line=1)
        >>> s = Symbol(name="f", kind=SymbolKind.FUNCTION, line=1, end_line=5, signature="(x: int, y: int) -> int", contracts=[c])
        >>> vs = check_partial_contract(FileInfo(path="c.py", lines=10, symbols=[s], is_core=True), RuleConfig())
        >>> vs[0].rule
        'partial_contract'
        >>> vs[0].severity
        <Severity.WARNING: 'warning'>
        >>> "y" in vs[0].message
        True
    """
    violations: list[Violation] = []
    if not file_info.is_core:
        return violations
    for symbol in file_info.symbols:
        if symbol.kind not in (SymbolKind.FUNCTION, SymbolKind.METHOD) or not symbol.signature:
            continue
        for contract in symbol.contracts:
            # Only check @pre contracts (not @post which takes 'result')
            if contract.kind != "pre":
                continue
            has_unused, unused, used = has_unused_params(contract.expression, symbol.signature)
            if has_unused:
                kind = "Method" if symbol.kind == SymbolKind.METHOD else "Function"
                unused_str = ", ".join(f"'{p}'" for p in unused)
                used_str = ", ".join(f"'{p}'" for p in used) if used else "none"
                violations.append(
                    Violation(
                        rule="partial_contract",
                        severity=Severity.WARNING,
                        file=file_info.path,
                        line=contract.line,
                        message=f"{kind} '{symbol.name}' @pre checks {used_str} but not {unused_str}",
                        suggestion=f"Signature: {symbol.signature}\n→ Add constraint for {unused_str} or verify it needs none",
                    )
                )
    return violationsj  Nueja  Nubsrc/invar/shell/config.py e1da44928d9d144f5441c60f19dc9f1eh)}(h](}(nameConfigSourcekindK
range}(start}(lineK	characterK uend}(j9  Kj9  KuuselectionRange}(j9  }(j9  Kj9  K uj9  }(j9  Kj9  Kuuchildren]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  DConfigSource = Literal["pyproject", "invar", "invar_dir", "default"]j  Nu}(j9  _find_config_sourcej9  Kj9  }(j9  }(j9  K!j9  K uj9  }(j9  K@j9  K5uuj9  }(j9  }(j9  K!j9  Kuj9  }(j9  K!j9  Kuuj9  ](}(j9  project_rootj9  K
j9  }(j9  }(j9  K!j9  Kuj9  }(j9  K!j9  K*uuj9  }(j9  }(j9  K!j9  Kuj9  }(j9  K!j9  K*uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  Eproject_root: Path) -> Result[tuple[Path | None, ConfigSource], str]:j  j :  u}(j9  	pyprojectj9  K
j9  }(j9  }(j9  K2j9  Kuj9  }(j9  K2j9  Kuuj9  }(j9  }(j9  K2j9  Kuj9  }(j9  K2j9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  +pyproject = project_root / "pyproject.toml"j  j :  u}(j9  
invar_tomlj9  K
j9  }(j9  }(j9  K6j9  Kuj9  }(j9  K6j9  Kuuj9  }(j9  }(j9  K6j9  Kuj9  }(j9  K6j9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j%:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  (invar_toml = project_root / "invar.toml"j  j :  u}(j9  invar_configj9  K
j9  }(j9  }(j9  K:j9  Kuj9  }(j9  K:j9  Kuuj9  }(j9  }(j9  K:j9  Kuj9  }(j9  K:j9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j2:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  6invar_config = project_root / ".invar" / "config.toml"j  j :  u}(j9  hj9  K
j9  }(j9  }(j9  K?j9  Kuj9  }(j9  K?j9  Kuuj9  }(j9  }(j9  K?j9  Kuj9  }(j9  K?j9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j>:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  e:j  j :  uej  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  X"  def _find_config_source(project_root: Path) -> Result[tuple[Path | None, ConfigSource], str]:
    """
    Find the first available config file.

    Returns:
        Result containing tuple of (config_path, source_type)

    Examples:
        >>> from pathlib import Path
        >>> import tempfile
        >>> with tempfile.TemporaryDirectory() as tmpdir:
        ...     root = Path(tmpdir)
        ...     result = _find_config_source(root)
        ...     result.unwrap()[1]
        'default'
    """
    try:
        pyproject = project_root / "pyproject.toml"
        if pyproject.exists():
            return Success((pyproject, "pyproject"))

        invar_toml = project_root / "invar.toml"
        if invar_toml.exists():
            return Success((invar_toml, "invar"))

        invar_config = project_root / ".invar" / "config.toml"
        if invar_config.exists():
            return Success((invar_config, "invar_dir"))

        return Success((None, "default"))
    except OSError as e:
        return Failure(f"Failed to find config: {e}")j  Nu}(j9  
_read_tomlj9  Kj9  }(j9  }(j9  KCj9  K uj9  }(j9  KKj9  K:uuj9  }(j9  }(j9  KCj9  Kuj9  }(j9  KCj9  Kuuj9  ](}(j9  pathj9  K
j9  }(j9  }(j9  KCj9  Kuj9  }(j9  KCj9  Kuuj9  }(j9  }(j9  KCj9  Kuj9  }(j9  KCj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  jX:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  +path: Path) -> Result[dict[str, Any], str]:j  jM:  u}(j9  contentj9  K
j9  }(j9  }(j9  KFj9  Kuj9  }(j9  KFj9  Kuuj9  }(j9  }(j9  KFj9  Kuj9  }(j9  KFj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  je:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  *content = path.read_text(encoding="utf-8")j  jM:  u}(j9  hj9  K
j9  }(j9  }(j9  KHj9  K&uj9  }(j9  KHj9  K'uuj9  }(j9  }(j9  KHj9  K&uj9  }(j9  KHj9  K'uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  jq:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  e:j  jM:  uej  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  jO:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  X  def _read_toml(path: Path) -> Result[dict[str, Any], str]:
    """Read and parse a TOML file."""
    try:
        content = path.read_text(encoding="utf-8")
        return Success(tomllib.loads(content))
    except tomllib.TOMLDecodeError as e:
        return Failure(f"Invalid TOML in {path.name}: {e}")
    except OSError as e:
        return Failure(f"Failed to read {path.name}: {e}")j  Nu}(j9  load_configj9  Kj9  }(j9  }(j9  KNj9  K uj9  }(j9  Ksj9  K4uuj9  }(j9  }(j9  KNj9  Kuj9  }(j9  KNj9  Kuuj9  ](}(j9  project_rootj9  K
j9  }(j9  }(j9  KNj9  Kuj9  }(j9  KNj9  K"uuj9  }(j9  }(j9  KNj9  Kuj9  }(j9  KNj9  K"uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  /project_root: Path) -> Result[RuleConfig, str]:j  j:  u}(j9  find_resultj9  K
j9  }(j9  }(j9  K^j9  Kuj9  }(j9  K^j9  Kuuj9  }(j9  }(j9  K^j9  Kuj9  }(j9  K^j9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  /find_result = _find_config_source(project_root)j  j:  u}(j9  config_pathj9  K
j9  }(j9  }(j9  Kaj9  Kuj9  }(j9  Kaj9  Kuuj9  }(j9  }(j9  Kaj9  Kuj9  }(j9  Kaj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  *config_path, source = find_result.unwrap()j  j:  u}(j9  sourcej9  K
j9  }(j9  }(j9  Kaj9  Kuj9  }(j9  Kaj9  Kuuj9  }(j9  }(j9  Kaj9  Kuj9  }(j9  Kaj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  source = find_result.unwrap()j  j:  u}(j9  resultj9  K
j9  }(j9  }(j9  Kgj9  Kuj9  }(j9  Kgj9  K
uuj9  }(j9  }(j9  Kgj9  Kuj9  }(j9  Kgj9  K
uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj   result = _read_toml(config_path)j  j:  u}(j9  dataj9  K
j9  }(j9  }(j9  Klj9  Kuj9  }(j9  Klj9  Kuuj9  }(j9  }(j9  Klj9  Kuj9  }(j9  Klj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  data = result.unwrap()j  j:  u}(j9  guard_configj9  K
j9  }(j9  }(j9  Kmj9  Kuj9  }(j9  Kmj9  Kuuj9  }(j9  }(j9  Kmj9  Kuj9  }(j9  Kmj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  2guard_config = extract_guard_section(data, source)j  j:  uej  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  Xr  def load_config(project_root: Path) -> Result[RuleConfig, str]:
    """
    Load Invar configuration from available sources.

    Tries sources in priority order:
    1. pyproject.toml [tool.invar.guard]
    2. invar.toml [guard]
    3. .invar/config.toml [guard]
    4. Built-in defaults

    Args:
        project_root: Path to project root directory

    Returns:
        Result containing RuleConfig or error message
    """
    find_result = _find_config_source(project_root)
    if isinstance(find_result, Failure):
        return find_result
    config_path, source = find_result.unwrap()

    if source == "default":
        return Success(RuleConfig())

    assert config_path is not None  # source != "default" guarantees path exists
    result = _read_toml(config_path)

    if isinstance(result, Failure):
        return result

    data = result.unwrap()
    guard_config = extract_guard_section(data, source)

    # For pyproject.toml, if no [tool.invar.guard] section, use defaults
    if source == "pyproject" and not guard_config:
        return Success(RuleConfig())

    return Success(parse_guard_config(guard_config))j  Nu}(j9  _DEFAULT_CORE_PATHSj9  Kj9  }(j9  }(j9  Kwj9  K uj9  }(j9  Kwj9  Kuuj9  }(j9  }(j9  Kwj9  K uj9  }(j9  Kwj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  *_DEFAULT_CORE_PATHS = ["src/core", "core"]j  Nu}(j9  _DEFAULT_SHELL_PATHSj9  Kj9  }(j9  }(j9  Kxj9  K uj9  }(j9  Kxj9  Kuuj9  }(j9  }(j9  Kxj9  K uj9  }(j9  Kxj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j:  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  -_DEFAULT_SHELL_PATHS = ["src/shell", "shell"]j  Nu}(j9  _DEFAULT_EXCLUDE_PATHSj9  Kj9  }(j9  }(j9  K{j9  K uj9  }(j9  K{j9  Kuuj9  }(j9  }(j9  K{j9  K uj9  }(j9  K{j9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  _DEFAULT_EXCLUDE_PATHS = [j  Nu}(j9  _get_classification_configj9  Kj9  }(j9  }(j9  Kj9  K uj9  }(j9  Kj9  K7uuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ](}(j9  project_rootj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K1uuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K1uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  3project_root: Path) -> Result[dict[str, Any], str]:j  j;  u}(j9  find_resultj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j';  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  /find_result = _find_config_source(project_root)j  j;  u}(j9  config_pathj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j4;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  *config_path, source = find_result.unwrap()j  j;  u}(j9  sourcej9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  jA;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  source = find_result.unwrap()j  j;  u}(j9  resultj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K
uuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K
uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  jN;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj   result = _read_toml(config_path)j  j;  u}(j9  dataj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j[;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  data = result.unwrap()j  j;  uej  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  X  def _get_classification_config(project_root: Path) -> Result[dict[str, Any], str]:
    """Get classification-related config (paths and patterns)."""
    find_result = _find_config_source(project_root)
    if isinstance(find_result, Failure):
        return Success({})  # Return empty on error
    config_path, source = find_result.unwrap()

    if source == "default":
        return Success({})

    assert config_path is not None
    result = _read_toml(config_path)

    if isinstance(result, Failure):
        return Success({})  # Return empty on error

    data = result.unwrap()
    return Success(extract_guard_section(data, source))+      j  Nu}(j9  get_path_classificationj9  Kj9  }(j9  }(j9  Kj9  K uj9  }(j9  Kj9  K-uuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ](}(j9  project_rootj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K.uuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K.uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  ju;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  @project_root: Path) -> Result[tuple[list[str], list[str]], str]:j  jj;  u}(j9  
config_resultj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  8config_result = _get_classification_config(project_root)j  jj;  u}(j9  guard_configj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  Sguard_config = config_result.unwrap() if isinstance(config_result, Success) else {}j  jj;  u}(j9  
core_pathsj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  @core_paths = guard_config.get("core_paths", _DEFAULT_CORE_PATHS)j  jj;  u}(j9  shell_pathsj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  Cshell_paths = guard_config.get("shell_paths", _DEFAULT_SHELL_PATHS)j  jj;  uej  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  jl;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  XB  def get_path_classification(project_root: Path) -> Result[tuple[list[str], list[str]], str]:
    """
    Get Core and Shell path prefixes from configuration.

    Returns:
        Result containing tuple of (core_paths, shell_paths)
    """
    config_result = _get_classification_config(project_root)
    guard_config = config_result.unwrap() if isinstance(config_result, Success) else {}

    core_paths = guard_config.get("core_paths", _DEFAULT_CORE_PATHS)
    shell_paths = guard_config.get("shell_paths", _DEFAULT_SHELL_PATHS)

    return Success((core_paths, shell_paths))j  Nu}(j9  get_pattern_classificationj9  Kj9  }(j9  }(j9  Kj9  K uj9  }(j9  Kj9  K3uuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ](}(j9  project_rootj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K1uuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K1uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  @project_root: Path) -> Result[tuple[list[str], list[str]], str]:j  j;  u}(j9  
config_resultj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  8config_result = _get_classification_config(project_root)j  j;  u}(j9  guard_configj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  Sguard_config = config_result.unwrap() if isinstance(config_result, Success) else {}j  j;  u}(j9  
core_patternsj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  5core_patterns = guard_config.get("core_patterns", [])j  j;  u}(j9  shell_patternsj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  7shell_patterns = guard_config.get("shell_patterns", [])j  j;  uej  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j;  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  X:  def get_pattern_classification(project_root: Path) -> Result[tuple[list[str], list[str]], str]:
    """
    Get Core and Shell glob patterns from configuration.

    Returns:
        Result containing tuple of (core_patterns, shell_patterns)
    """
    config_result = _get_classification_config(project_root)
    guard_config = config_result.unwrap() if isinstance(config_result, Success) else {}

    core_patterns = guard_config.get("core_patterns", [])
    shell_patterns = guard_config.get("shell_patterns", [])

    return Success((core_patterns, shell_patterns))j  Nu}(j9  get_exclude_pathsj9  Kj9  }(j9  }(j9  Kj9  K uj9  }(j9  Kj9  KTuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ](}(j9  project_rootj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K(uuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K(uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  .project_root: Path) -> Result[list[str], str]:j  j<  u}(j9  
config_resultj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  8config_result = _get_classification_config(project_root)j  j<  u}(j9  guard_configj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j+<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  Sguard_config = config_result.unwrap() if isinstance(config_result, Success) else {}j  j<  uej  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  X  def get_exclude_paths(project_root: Path) -> Result[list[str], str]:
    """
    Get paths to exclude from checking.

    Returns:
        Result containing list of path patterns to exclude
    """
    config_result = _get_classification_config(project_root)
    guard_config = config_result.unwrap() if isinstance(config_result, Success) else {}
    return Success(guard_config.get("exclude_paths", _DEFAULT_EXCLUDE_PATHS.copy()))j  Nu}(j9  
classify_filej9  Kj9  }(j9  }(j9  Kj9  K uj9  }(j9  Kj9  K"uuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ](}(j9  	file_pathj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K uuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  jE<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  Ffile_path: str, project_root: Path) -> Result[tuple[bool, bool], str]:j  j:<  u}(j9  project_rootj9  K
j9  }(j9  }(j9  Kj9  K"uj9  }(j9  Kj9  K4uuj9  }(j9  }(j9  Kj9  K"uj9  }(j9  Kj9  K4uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  jR<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  6project_root: Path) -> Result[tuple[bool, bool], str]:j  j:<  u}(j9  pattern_resultj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j_<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  9pattern_result = get_pattern_classification(project_root)j  j:<  u}(j9  
core_patternsj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  jl<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  !core_patterns, shell_patterns = (j  j:<  u}(j9  shell_patternsj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K!uuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  K!uuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  jy<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  shell_patterns = (j  j:<  u}(j9  path_resultj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  3path_result = get_path_classification(project_root)j  j:<  u}(j9  
core_pathsj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  core_paths, shell_paths = (j  j:<  u}(j9  shell_pathsj9  K
j9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  }(j9  }(j9  Kj9  Kuj9  }(j9  Kj9  Kuuj9  ]j  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  shell_paths = (j  j:<  uej  }(j  ;file:///Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j<<  j  4/Users/tefx/Projects/Invar/src/invar/shell/config.pyj  j9  uj  X  def classify_file(file_path: str, project_root: Path) -> Result[tuple[bool, bool], str]:
    """
    Classify a file as Core, Shell, or neither.

    Priority: patterns > paths > uncategorized.

    Examples:
        >>> import tempfile
        >>> from pathlib import Path
        >>> with tempfile.TemporaryDirectory() as tmpdir:
        ...     root = Path(tmpdir)
        ...     result = classify_file("src/core/logic.py", root)
        ...     result.unwrap()[0]
        True
    """
    pattern_result = get_pattern_classification(project_root)
    core_patterns, shell_patterns = (
        pattern_result.unwrap() if isinstance(pattern_result, Success) else ([], [])
    )

    path_result = get_path_classification(project_root)
    core_paths, shell_paths = (
        path_result.unwrap()
        if isinstance(path_result, Success)
        else (_DEFAULT_CORE_PATHS, _DEFAULT_SHELL_PATHS)
    )

    # Priority 1: Pattern-based classification
    if core_patterns and matches_pattern(file_path, core_patterns):
        return Success((True, False))
    if shell_patterns and matches_pattern(file_path, shell_patterns):
        return Success((False, True))

    # Priority 2: Path-based classification
    if matches_path_prefix(file_path, core_paths):
        return Success((True, False))
    if matches_path_prefix(file_path, shell_paths):
        return Success((False, True))

    return Success((False, False))j  Nueja  Nubsrc/invar/shell/cli.py d3bb690e5a8c20d6bab41e858726daech)}(h](}(name_detect_agent_modekindKrange}(start}(lineK	characterK uend}(j<  Kj<  KHuuselectionRange}(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuchildren]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  src/invar/shell/cli.pyuj  def _detect_agent_mode() -> bool:
    """Detect agent context: INVAR_MODE=agent OR non-TTY (pipe/redirect)."""
    import sys
    return os.getenv("INVAR_MODE") == "agent" or not sys.stdout.isatty()j  Nu}(j<  appj<  K
j<  }(j<  }(j<  K j<  K uj<  }(j<  K j<  Kuuj<  }(j<  }(j<  K j<  K uj<  }(j<  K j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  app = typer.Typer(j  Nu}(j<  consolej<  K
j<  }(j<  }(j<  K%j<  K uj<  }(j<  K%j<  Kuuj<  }(j<  }(j<  K%j<  K uj<  }(j<  K%j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  console = Console()j  Nu}(j<  _count_core_functionsj<  Kj<  }(j<  }(j<  K(j<  K uj<  }(j<  K6j<  K"uuj<  }(j<  }(j<  K(j<  Kuj<  }(j<  K(j<  Kuuj<  ](}(j<  	file_infoj<  K
j<  }(j<  }(j<  K(j<  Kuj<  }(j<  K(j<  K#uuj<  }(j<  }(j<  K(j<  Kuj<  }(j<  K(j<  K#uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  file_info) -> tuple[int, int]:j  j<  u}(j<  totalj<  K
j<  }(j<  }(j<  K/j<  Kuj<  }(j<  K/j<  K	uuj<  }(j<  }(j<  K/j<  Kuj<  }(j<  K/j<  K	uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  	total = 0j  j<  u}(j<  with_contractsj<  K
j<  }(j<  }(j<  K0j<  Kuj<  }(j<  K0j<  Kuuj<  }(j<  }(j<  K0j<  Kuj<  }(j<  K0j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  with_contracts = 0j  j<  u}(j<  symj<  K
j<  }(j<  }(j<  K1j<  Kuj<  }(j<  K1j<  Kuuj<  }(j<  }(j<  K1j<  Kuj<  }(j<  K1j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  sym in file_info.symbols:j  j<  uej  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  X  def _count_core_functions(file_info) -> tuple[int, int]:
    """Count functions and functions with contracts in a Core file (P24)."""
    from invar.core.models import SymbolKind

    if not file_info.is_core:
        return (0, 0)

    total = 0
    with_contracts = 0
    for sym in file_info.symbols:
        if sym.kind in (SymbolKind.FUNCTION, SymbolKind.METHOD):
            total += 1
            if sym.contracts:
                with_contracts += 1
    return (total, with_contracts)j  Nu}(j<  _scan_and_checkj<  Kj<  }(j<  }(j<  K9j<  K uj<  }(j<  KIj<  Kuuj<  }(j<  }(j<  K9j<  Kuj<  }(j<  K9j<  Kuuj<  ](}(j<  pathj<  K
j<  }(j<  }(j<  K:j<  Kuj<  }(j<  K:j<  Kuuj<  }(j<  }(j<  K:j<  Kuj<  }(j<  K:j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j2=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Cpath: Path, config: RuleConfig, only_files: set[Path] | None = Nonej  j'=  u}(j<  configj<  K
j<  }(j<  }(j<  K:j<  Kuj<  }(j<  K:j<  K"uuj<  }(j<  }(j<  K:j<  Kuj<  }(j<  K:j<  K"uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  7config: RuleConfig, only_files: set[Path] | None = Nonej  j'=  u}(j<  
only_filesj<  K
j<  }(j<  }(j<  K:j<  K$uj<  }(j<  K:j<  KGuuj<  }(j<  }(j<  K:j<  K$uj<  }(j<  K:j<  KGuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jL=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  #only_files: set[Path] | None = Nonej  j'=  u}(j<  reportj<  K
j<  }(j<  }(j<  K=j<  Kuj<  }(j<  K=j<  K
uuj<  }(j<  }(j<  K=j<  Kuj<  }(j<  K=j<  K
uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jY=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  %report = GuardReport(files_checked=0)j  j'=  u}(j<  file_resultj<  K
j<  }(j<  }(j<  K>j<  Kuj<  }(j<  K>j<  Kuuj<  }(j<  }(j<  K>j<  Kuj<  }(j<  K>j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jf=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  .file_result in scan_project(path, only_files):j  j'=  u}(j<  	file_infoj<  K
j<  }(j<  }(j<  KBj<  Kuj<  }(j<  KBj<  Kuuj<  }(j<  }(j<  KBj<  Kuj<  }(j<  KBj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  js=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj   file_info = file_result.unwrap()j  j'=  u}(j<  totalj<  K
j<  }(j<  }(j<  KEj<  Kuj<  }(j<  KEj<  K
uuj<  }(j<  }(j<  KEj<  Kuj<  }(j<  KEj<  K
uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  8total, with_contracts = _count_core_functions(file_info)j  j'=  u}(j<  with_contractsj<  K
j<  }(j<  }(j<  KEj<  Kuj<  }(j<  KEj<  Kuuj<  }(j<  }(j<  KEj<  Kuj<  }(j<  KEj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  1with_contracts = _count_core_functions(file_info)j  j'=  u}(j<  	violationj<  K
j<  }(j<  }(j<  KGj<  Kuj<  }(j<  KGj<  Kuuj<  }(j<  }(j<  KGj<  Kuj<  }(j<  KGj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  0violation in check_all_rules(file_info, config):j  j'=  uej  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j)=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  X   def _scan_and_check(
    path: Path, config: RuleConfig, only_files: set[Path] | None = None
) -> Result[GuardReport, str]:
    """Scan project files and check against rules."""
    report = GuardReport(files_checked=0)
    for file_result in scan_project(path, only_files):
        if isinstance(file_result, Failure):
            console.print(f"[yellow]Warning:[/yellow] {file_result.failure()}")
            continue
        file_info = file_result.unwrap()
        report.files_checked += 1
        # P24: Track contract coverage for Core files
        total, with_contracts = _count_core_functions(file_info)
        report.update_coverage(total, with_contracts)
        for violation in check_all_rules(file_info, config):
            report.add_violation(violation)
    return Success(report)j  Nu}(j<  guardj<  Kj<  }(j<  }(j<  KLj<  K uj<  }(j<  MMj<  K uuj<  }(j<  }(j<  KMj<  Kuj<  }(j<  KMj<  K	uuj<  ](}(j<  pathj<  K
j<  }(j<  }(j<  KNj<  Kuj<  }(j<  KPj<  Kuuj<  }(j<  }(j<  KNj<  Kuj<  }(j<  KPj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  ~path: Path = typer.Argument(
        Path(), help="Project root directory", exists=True, file_okay=False, dir_okay=True
    ),j  j=  u}(j<  strictj<  K
j<  }(j<  }(j<  KQj<  Kuj<  }(j<  KQj<  KSuuj<  }(j<  }(j<  KQj<  Kuj<  }(j<  KQj<  KSuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Pstrict: bool = typer.Option(False, "--strict", help="Treat warnings as errors"),j  j=  u}(j<  no_strict_purej<  K
j<  }(j<  }(j<  KRj<  Kuj<  }(j<  KTj<  Kuuj<  }(j<  }(j<  KRj<  Kuj<  }(j<  KTj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  no_strict_pure: bool = typer.Option(
        False, "--no-strict-pure", help="Disable purity checks (internal imports, impure calls)"
    ),j  j=  u}(j<  pedanticj<  K
j<  }(j<  }(j<  KUj<  Kuj<  }(j<  KWj<  Kuuj<  }(j<  }(j<  KUj<  Kuj<  }(j<  KWj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  |pedantic: bool = typer.Option(
        False, "--pedantic", help="Show all violations including off-by-default rules"
    ),j  j=  u}(j<  explainj<  K
j<  }(j<  }(j<  KXj<  Kuj<  }(j<  KZj<  Kuuj<  }(j<  }(j<  KXj<  Kuj<  }(j<  KZj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  rexplain: bool = typer.Option(
        False, "--explain", help="Show detailed explanations and limitations"
    ),j  j=  u}(j<  changedj<  K
j<  }(j<  }(j<  K[j<  Kuj<  }(j<  K]j<  Kuuj<  }(j<  }(j<  K[j<  Kuj<  }(j<  K]j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  echanged: bool = typer.Option(
        False, "--changed", help="Only check git-modified files"
    ),j  j=  u}(j<  agentj<  K
j<  }(j<  }(j<  K^j<  Kuj<  }(j<  K`j<  Kuuj<  }(j<  }(j<  K^j<  Kuj<  }(j<  K`j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  pagent: bool = typer.Option(
        False, "--agent", help="Output JSON with fix instructions for agents"
    ),j  j=  u}(j<  json_outputj<  K
j<  }(j<  }(j<  Kaj<  Kuj<  }(j<  Kaj<  KLuuj<  }(j<  }(j<  Kaj<  Kuj<  }(j<  Kaj<  KLuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Ijson_output: bool = typer.Option(False, "--json", help="Output as JSON"),j  j=  u}(j<  quickj<  K
j<  }(j<  }(j<  Kcj<  Kuj<  }(j<  Kej<  Kuuj<  }(j<  }(j<  Kcj<  Kuj<  }(j<  Kej<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  gquick: bool = typer.Option(
        False, "--quick", help="Static analysis only, skip doctests"
    ),j  j=  u}(j<  provej<  K
j<  }(j<  }(j<  Kfj<  Kuj<  }(j<  Khj<  Kuuj<  }(j<  }(j<  Kfj<  Kuj<  }(j<  Khj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j)>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  lprove: bool = typer.Option(
        False, "--prove", help="Add symbolic verification with CrossHair"
    ),j  j=  u}(j<  
config_resultj<  K
j<  }(j<  }(j<  Kxj<  Kuj<  }(j<  Kxj<  Kuuj<  }(j<  }(j<  Kxj<  Kuj<  }(j<  Kxj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j6>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  !config_result = load_config(path)j  j=  u}(j<  configj<  K
j<  }(j<  }(j<  K}j<  Kuj<  }(j<  K}j<  K
uuj<  }(j<  }(j<  K}j<  Kuj<  }(j<  K}j<  K
uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jC>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  config = config_result.unwrap()j  j=  u}(j<  
only_filesj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jP>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  #only_files: set[Path] | None = Nonej  j=  u}(j<  
checked_filesj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j]>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  checked_files: list[Path] = []j  j=  u}(j<  changed_resultj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jj>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  (changed_result = get_changed_files(path)j  j=  u}(j<  scan_resultj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jw>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  7scan_result = _scan_and_check(path, config, only_files)j  j=  u}(j<  reportj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  K
uuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  K
uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  report = scan_result.unwrap()j  j=  u}(j<  use_agent_outputj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  0use_agent_output = agent or _detect_agent_mode()j  j=  u}(j<  verification_levelj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  ,verification_level = VerificationLevel.PROVEj  j=  u}(j<  level_labelsj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  level_labels = {j  j=  u}(j<  
level_namej<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  -level_name = level_labels[verification_level]j  j=  u}(j<  human_labelsj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  human_labels = {j  j=  u}(j<  doctest_passedj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  doctest_passed = Truej  j=  u}(j<  doctest_outputj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  doctest_output = ""j  j=  u}(j<  crosshair_passedj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  crosshair_passed = Truej  j=  u}(j<  crosshair_outputj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j>  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  crosshair_output: dict = {}j  j=  u}(j<  static_exit_codej<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  0static_exit_code = get_exit_code(report, strict)j  j=  u}(j<  path_resultj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  +path_result = get_path_classification(path)j  j=  u}(j<  
core_pathsj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j ?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  .core_paths, shell_paths = path_result.unwrap()j  j=  u}(j<  shell_pathsj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  K'uuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  K'uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j-?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  "shell_paths = path_result.unwrap()j  j=  u}(j<  	core_pathj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j:?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  core_path in core_paths:j  j=  u}(j<  	full_pathj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jG?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  full_path = path / core_pathj  j=  u}(j<  
shell_pathj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jT?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  shell_path in shell_paths:j  j=  u}(j<  doctest_resultj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  ja?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Fdoctest_result = run_doctests_on_files(checked_files, verbose=explain)j  j=  u}(j<  result_dataj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jn?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  %result_data = doctest_result.unwrap()j  j=  u}(j<  
core_filesj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j{?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  ;core_files = [f for f in checked_files if "core" in str(f)]j  j=  u}(j<  files_to_provej<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  K"uuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  K"uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  $files_to_prove = get_files_to_prove(j  j=  u}(j<  cachej<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  7cache = ProveCache(path / ".invar" / "cache" / "prove")j  j=  u}(j<  crosshair_resultj<  K
j<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  K(uuj<  }(j<  }(j<  Kj<  Kuj<  }(j<  Kj<  K(uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  *crosshair_result = run_crosshair_parallel(j  j=  u}(j<  statusj<  K
j<  }(j<  }(j<  M'j<  Kuj<  }(j<  M'j<  Kuuj<  }(j<  }(j<  M'j<  Kuj<  }(j<  M'j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  2status = crosshair_output.get("status", "unknown")j  j=  u}(j<  verified_countj<  K
j<  }(j<  }(j<  M*j<  Kuj<  }(j<  M*j<  K"uuj<  }(j<  }(j<  M*j<  Kuj<  }(j<  M*j<  K"uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  :verified_count = crosshair_output.get("files_verified", 0)j  j=  u}(j<  cached_countj<  K
j<  }(j<  }(j<  M+j<  Kuj<  }(j<  M+j<  K uuj<  }(j<  }(j<  M+j<  Kuj<  }(j<  M+j<  K uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  6cached_count = crosshair_output.get("files_cached", 0)j  j=  u}(j<  time_msj<  K
j<  }(j<  }(j<  M,j<  Kuj<  }(j<  M,j<  Kuuj<  }(j<  }(j<  M,j<  Kuj<  }(j<  M,j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  2time_ms = crosshair_output.get("total_time_ms", 0)j  j=  u}(j<  workersj<  K
j<  }(j<  }(j<  M-j<  Kuj<  }(j<  M-j<  Kuuj<  }(j<  }(j<  M-j<  Kuj<  }(j<  M-j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  ,workers = crosshair_output.get("workers", 1)j  j=  u}(j<  reasonj<  K
j<  }(j<  }(j<  M1j<  Kuj<  }(j<  M1j<  Kuuj<  }(j<  }(j<  M1j<  Kuj<  }(j<  M1j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  1reason = crosshair_output.get("reason", "cached")j  j=  u}(j<  time_secj<  K
j<  }(j<  }(j<  M4j<  Kuj<  }(j<  M4j<  K uuj<  }(j<  }(j<  M4j<  Kuj<  }(j<  M4j<  K uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j?  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  time_sec = time_ms / 1000j  j=  u}(j<  statsj<  K
j<  }(j<  }(j<  M5j<  Kuj<  }(j<  M5j<  Kuuj<  }(j<  }(j<  M5j<  Kuj<  }(j<  M5j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j
@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  $stats = f"{verified_count} verified"j  j=  u}(j<  cej<  K
j<  }(j<  }(j<  MEj<  Kuj<  }(j<  MEj<  Kuuj<  }(j<  }(j<  MEj<  Kuj<  }(j<  MEj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  6ce in crosshair_output.get("counterexamples", [])[:5]:j  j=  u}(j<  
all_passedj<  K
j<  }(j<  }(j<  MKj<  Kuj<  }(j<  MKj<  Kuuj<  }(j<  }(j<  MKj<  Kuj<  }(j<  MKj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j$@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  0all_passed = doctest_passed and crosshair_passedj  j=  u}(j<  
final_exitj<  K
j<  }(j<  }(j<  MLj<  Kuj<  }(j<  MLj<  Kuuj<  }(j<  }(j<  MLj<  Kuj<  }(j<  MLj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j1@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  2final_exit = static_exit_code if all_passed else 1j  j=  uej  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j=  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  XN-  @app.command()
def guard(
    path: Path = typer.Argument(
        Path(), help="Project root directory", exists=True, file_okay=False, dir_okay=True
    ),
    strict: bool = typer.Option(False, "--strict", help="Treat warnings as errors"),
    no_strict_pure: bool = typer.Option(
        False, "--no-strict-pure", help="Disable purity checks (internal imports, impure calls)"
    ),
    pedantic: bool = typer.Option(
        False, "--pedantic", help="Show all violations including off-by-default rules"
    ),
    explain: bool = typer.Option(
        False, "--explain", help="Show detailed explanations and limitations"
    ),
    changed: bool = typer.Option(
        False, "--changed", help="Only check git-modified files"
    ),
    agent: bool = typer.Option(
        False, "--agent", help="Output JSON with fix instructions for agents"
    ),
    json_output: bool = typer.Option(False, "--json", help="Output as JSON"),
    # Smart Guard flags
    quick: bool = typer.Option(
        False, "--quick", help="Static analysis only, skip doctests"
    ),
    prove: bool = typer.Option(
        False, "--prove", help="Add symbolic verification with CrossHair"
    ),
) -> None:
    """Check project against Invar architecture rules.

    Smart Guard: Automatically runs doctests after static analysis.
    Use --quick for static-only, --prove for symbolic verification.
    """
    from invar.shell.prove_cache import ProveCache
    from invar.shell.testing import (
        VerificationLevel,
        detect_verification_context,
        get_files_to_prove,
        run_crosshair_parallel,
        run_doctests_on_files,
    )

    config_result = load_config(path)
    if isinstance(config_result, Failure):
        console.print(f"[red]Error:[/red] {config_result.failure()}")
        raise typer.Exit(1)

    config = config_result.unwrap()
    if no_strict_pure:
        config.strict_pure = False
    # Phase 9 P2: --pedantic shows all rules including off-by-default
    if pedantic:
        config.severity_overrides = {}

    # Phase 8.1: --changed mode
    only_files: set[Path] | None = None
    checked_files: list[Path] = []
    if changed:
        if not is_git_repo(path):
            console.print("[red]Error:[/red] --changed requires a git repository")
            raise typer.Exit(1)
        changed_result = get_changed_files(path)
        if isinstance(changed_result, Failure):
            console.print(f"[red]Error:[/red] {changed_result.failure()}")
            raise typer.Exit(1)
        only_files = changed_result.unwrap()
        if not only_files:
            console.print("[green]No changed Python files.[/green]")
            raise typer.Exit(0)
        checked_files = list(only_files)

    scan_result = _scan_and_check(path, config, only_files)
    if isinstance(scan_result, Failure):
        console.print(f"[red]Error:[/red] {scan_result.failure()}")
        raise typer.Exit(1)
    report = scan_result.unwrap()

    # Phase 9 P11: Auto-detect agent mode from environment
    use_agent_output = agent or _detect_agent_mode()

    # DX-06: Smart Guard - determine verification level
    # Note: --prove takes precedence (explicit > implicit, higher tier > lower)
    if prove:
        verification_level = VerificationLevel.PROVE
    elif quick:
        verification_level = VerificationLevel.STATIC
    else:
        verification_level = detect_verification_context()

    # DX-09: Verification level labels (used for both human and agent output)
    level_labels = {
        VerificationLevel.STATIC: "static",
        VerificationLevel.STANDARD: "standard",
        VerificationLevel.PROVE: "prove",
    }
    level_name = level_labels[verification_level]

    # DX-09: Show verification level (human mode)
    if not use_agent_output:
        human_labels = {
            VerificationLevel.STATIC: "[yellow]--quick[/yellow] (static only, doctests skipped)",
            VerificationLevel.STANDARD: "default (static + doctests)",
            VerificationLevel.PROVE: "--prove (static + doctests + CrossHair)",
        }
        console.print(f"[dim]Verification: {human_labels[verification_level]}[/dim]")

    # DX-06: Run doctests if not --quick and static analysis passed
    doctest_passed = True
    doctest_output = ""
    crosshair_passed = True
    crosshair_output: dict = {}
    static_exit_code = get_exit_code(report, strict)

    if verification_level >= VerificationLevel.STANDARD and static_exit_code == 0:
        # Collect files to test
        if not checked_files:
            # DX-07: Get core/shell paths from config (not RuleConfig)
            path_result = get_path_classification(path)
            if isinstance(path_result, Success):
                core_paths, shell_paths = path_result.unwrap()
            else:
                core_paths, shell_paths = ["src/core"], ["src/shell"]
            # Scan for Python files in core/shell paths
            for core_path in core_paths:
                full_path = path / core_path
                if full_path.exists():
                    checked_files.extend(full_path.rglob("*.py"))
            for shell_path in shell_paths:
                full_path = path / shell_path
                if full_path.exists():
                    checked_files.extend(full_path.rglob("*.py"))
            # DX-07: Fallback - if no configured paths found, scan path directly
            if not checked_files and path.exists():
                checked_files.extend(path.rglob("*.py"))

        if checked_files:
            doctest_result = run_doctests_on_files(checked_files, verbose=explain)
            if isinstance(doctest_result, Success):
                result_data = doctest_result.unwrap()
                doctest_passed = result_data.get("status") in ("passed", "skipped")
                doctest_output = result_data.get("stdout", "")
            else:
                doctest_passed = False
                doctest_output = doctest_result.failure()

    # DX-06: Run CrossHair if --prove and doctests passed
    # DX-13: Uses incremental mode, parallel execution, and caching
    if verification_level >= VerificationLevel.PROVE:
        if doctest_passed and static_exit_code == 0:
            if checked_files:
                # Only verify Core files (pure logic)
                core_files = [f for f in checked_files if "core" in str(f)]
                if core_files:
                    # DX-13: Automatic incremental mode - only verify changed files
                    files_to_prove = get_files_to_prove(
                        path, core_files, changed_only=True
                    )

                    if not files_to_prove:
                        crosshair_output = {
                            "status": "verified",
                            "reason": "no changes to verify",
                            "files_verified": 0,
                            "files_cached": len(core_files),
                        }
                    else:
                        # DX-13: Create cache for verification results
                        cache = ProveCache(path / ".invar" / "cache" / "prove")

                        # DX-13: Run parallel verification with caching
                        crosshair_result = run_crosshair_parallel(
                            files_to_prove,
                            max_iterations=5,  # Fast mode
                            max_workers=None,  # Auto-detect
                            cache=cache,
                        )
                        if isinstance(crosshair_result, Success):
                            crosshair_output = crosshair_result.unwrap()
                            crosshair_passed = crosshair_output.get("status") in (
                                "verified",
                                "skipped",
                            )
                        else:
                            crosshair_passed = False
                            crosshair_output = {
                                "status": "error",
                                "error": crosshair_result.failure(),
                            }
                else:
                    crosshair_output = {"status": "skipped", "reason": "no core files found"}
            else:
                crosshair_output = {"status": "skipped", "reason": "no files to verify"}
        else:
            crosshair_output = {"status": "skipped", "reason": "prior failures"}

    # Output results
    if use_agent_output:
        output_agent(report, doctest_passed, doctest_output, crosshair_output, level_name)
    elif json_output:
        output_json(report)
    else:
        output_rich(report, config.strict_pure, changed, pedantic, explain)
        # DX-06: Show doctest results
        if verification_level >= VerificationLevel.STANDARD:
            if static_exit_code == 0:
                if doctest_passed:
                    console.print("[green]✓ Doctests passed[/green]")
                else:
                    console.print("[red]✗ Doctests failed[/red]")
                    if doctest_output and explain:
                        console.print(doctest_output)
            else:
                console.print("[dim]⊘ Doctests skipped (static errors)[/dim]")
        # DX-06: Show CrossHair results
        # DX-13: Enhanced output with stats (verified, cached, time, workers)
        if verification_level >= VerificationLevel.PROVE:
            if static_exit_code == 0 and doctest_passed:
                status = crosshair_output.get("status", "unknown")
                if status == "verified":
                    # DX-13: Show detailed stats
                    verified_count = crosshair_output.get("files_verified", 0)
                    cached_count = crosshair_output.get("files_cached", 0)
                    time_ms = crosshair_output.get("total_time_ms", 0)
                    workers = crosshair_output.get("workers", 1)

                    if verified_count == 0 and cached_count > 0:
                        # All from cache/no changes
                        reason = crosshair_output.get("reason", "cached")
                        console.print(f"[green]✓ CrossHair verified ({reason})[/green]")
                    elif time_ms > 0:
                        time_sec = time_ms / 1000
                        stats = f"{verified_count} verified"
                        if cached_count > 0:
                            stats += f", {cached_count} cached"
                        if workers > 1:
                            stats += f", {workers} workers"
                        console.print(
                            f"[green]✓ CrossHair verified[/green] "
                            f"[dim]({stats}, {time_sec:.1f}s)[/dim]"
                        )
                    else:
                        console.print("[green]✓ CrossHair verified[/green]")
                elif status == "skipped":
                    reason = crosshair_output.get("reason", "no files")
                    console.print(f"[dim]⊘ CrossHair skipped ({reason})[/dim]")
                else:
                    console.print("[yellow]! CrossHair found counterexamples[/yellow]")
                    for ce in crosshair_output.get("counterexamples", [])[:5]:
                        console.print(f"  {ce}")
            else:
                console.print("[dim]⊘ CrossHair skipped (prior failures)[/dim]")

    # Exit with combined status
    all_passed = doctest_passed and crosshair_passed
    final_exit = static_exit_code if all_passed else 1
    raise typer.Exit(final_exit)j  Nu}(j<  versionj<  Kj<  }(j<  }(j<  MPj<  K uj<  }(j<  MSj<  K)uuj<  }(j<  }(j<  MQj<  Kuj<  }(j<  MQj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jB@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  m@app.command()
def version() -> None:
    """Show Invar version."""
    console.print(f"invar {__version__}")j  Nu}(j<  map_commandj<  Kj<  }(j<  }(j<  MVj<  K uj<  }(j<  Mdj<  Kuuj<  }(j<  }(j<  MWj<  Kuj<  }(j<  MWj<  Kuuj<  ](}(j<  pathj<  K
j<  }(j<  }(j<  MXj<  Kuj<  }(j<  MXj<  KFuuj<  }(j<  }(j<  MXj<  Kuj<  }(j<  MXj<  KFuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jX@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Cpath: Path = typer.Argument(Path(), help="Project root directory"),j  jM@  u}(j<  topj<  K
j<  }(j<  }(j<  MYj<  Kuj<  }(j<  MYj<  KRuuj<  }(j<  }(j<  MYj<  Kuj<  }(j<  MYj<  KRuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  je@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Otop: int = typer.Option(0, "--top", help="Show top N most-referenced symbols"),j  jM@  u}(j<  json_outputj<  K
j<  }(j<  }(j<  MZj<  Kuj<  }(j<  MZj<  KLuuj<  }(j<  }(j<  MZj<  Kuj<  }(j<  MZj<  KLuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jr@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Ijson_output: bool = typer.Option(False, "--json", help="Output as JSON"),j  jM@  u}(j<  use_jsonj<  K
j<  }(j<  }(j<  M`j<  Kuj<  }(j<  M`j<  Kuuj<  }(j<  }(j<  M`j<  Kuj<  }(j<  M`j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  .use_json = json_output or _detect_agent_mode()j  jM@  u}(j<  resultj<  K
j<  }(j<  }(j<  Maj<  Kuj<  }(j<  Maj<  K
uuj<  }(j<  }(j<  Maj<  Kuj<  }(j<  Maj<  K
uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  %result = run_map(path, top, use_json)j  jM@  uej  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jO@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  X  @app.command("map")
def map_command(
    path: Path = typer.Argument(Path(), help="Project root directory"),
    top: int = typer.Option(0, "--top", help="Show top N most-referenced symbols"),
    json_output: bool = typer.Option(False, "--json", help="Output as JSON"),
) -> None:
    """Generate symbol map with reference counts."""
    from invar.shell.perception import run_map

    # Phase 9 P11: Auto-detect agent mode
    use_json = json_output or _detect_agent_mode()
    result = run_map(path, top, use_json)
    if isinstance(result, Failure):
        console.print(f"[red]Error:[/red] {result.failure()}")
        raise typer.Exit(1)j  Nu}(j<  sig_commandj<  Kj<  }(j<  }(j<  Mgj<  K uj<  }(j<  Mtj<  Kuuj<  }(j<  }(j<  Mhj<  Kuj<  }(j<  Mhj<  Kuuj<  ](}(j<  targetj<  K
j<  }(j<  }(j<  Mij<  Kuj<  }(j<  Mij<  KGuuj<  }(j<  }(j<  Mij<  Kuj<  }(j<  Mij<  KGuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Dtarget: str = typer.Argument(..., help="File or file::symbol path"),j  j@  u}(j<  json_outputj<  K
j<  }(j<  }(j<  Mjj<  Kuj<  }(j<  Mjj<  KLuuj<  }(j<  }(j<  Mjj<  Kuj<  }(j<  Mjj<  KLuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Ijson_output: bool = typer.Option(False, "--json", help="Output as JSON"),j  j@  u}(j<  use_jsonj<  K
j<  }(j<  }(j<  Mpj<  Kuj<  }(j<  Mpj<  Kuuj<  }(j<  }(j<  Mpj<  Kuj<  }(j<  Mpj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  .use_json = json_output or _detect_agent_mode()j  j@  u}(j<  resultj<  K
j<  }(j<  }(j<  Mqj<  Kuj<  }(j<  Mqj<  K
uuj<  }(j<  }(j<  Mqj<  Kuj<  }(j<  Mqj<  K
uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  "result = run_sig(target, use_json)j  j@  uej  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  X-  @app.command("sig")
def sig_command(
    target: str = typer.Argument(..., help="File or file::symbol path"),
    json_output: bool = typer.Option(False, "--json", help="Output as JSON"),
) -> None:
    """Extract signatures from a file or symbol."""
    from invar.shell.perception import run_sig

    # Phase 9 P11: Auto-detect agent mode
    use_json = json_output or _detect_agent_mode()
    result = run_sig(target, use_json)
    if isinstance(result, Failure):
        console.print(f"[red]Error:[/red] {result.failure()}")
        raise typer.Exit(1)j  Nu}(j<  rulesj<  Kj<  }(j<  }(j<  Mwj<  K uj<  }(j<  Mj<  Kbuuj<  }(j<  }(j<  Mxj<  Kuj<  }(j<  Mxj<  K	uuj<  ](}(j<  json_outputj<  K
j<  }(j<  }(j<  Myj<  Kuj<  }(j<  Myj<  KLuuj<  }(j<  }(j<  Myj<  Kuj<  }(j<  Myj<  KLuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Ijson_output: bool = typer.Option(False, "--json", help="Output as JSON"),j  j@  u}(j<  categoryj<  K
j<  }(j<  }(j<  Mzj<  Kuj<  }(j<  M|j<  Kuuj<  }(j<  }(j<  Mzj<  Kuj<  }(j<  M|j<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  category: str = typer.Option(
        None, "--category", "-c", help="Filter by category (size, contracts, purity, shell, docs)"
    ),j  j@  u}(j<  use_jsonj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  .use_json = json_output or _detect_agent_mode()j  j@  u}(j<  catj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  $cat = RuleCategory(category.lower())j  j@  u}(j<  
rules_listj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  'rules_list = get_rules_by_category(cat)j  j@  u}(j<  validj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j(A  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  0valid = ", ".join(c.value for c in RuleCategory)j  j@  u}(j<  dataj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j5A  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  data = {j  j@  u}(j<  tablej<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K
uuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K
uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jBA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  (table = Table(title="Invar Guard Rules")j  j@  u}(j<  rj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K
uuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K
uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jOA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  r in rules_list:j  j@  u}(j<  	sev_stylej<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j\A  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Fsev_style = {"error": "red", "warning": "yellow", "info": "blue"}.get(j  j@  uej  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j@  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  X	  @app.command()
def rules(
    json_output: bool = typer.Option(False, "--json", help="Output as JSON"),
    category: str = typer.Option(
        None, "--category", "-c", help="Filter by category (size, contracts, purity, shell, docs)"
    ),
) -> None:
    """
    List all Guard rules with their metadata.

    Shows what each rule detects and its limitations.
    """
    import json as json_lib

    from invar.core.rule_meta import RULE_META, RuleCategory, get_rules_by_category

    # Phase 9 P11: Auto-detect agent mode
    use_json = json_output or _detect_agent_mode()

    # Filter by category if specified
    if category:
        try:
            cat = RuleCategory(category.lower())
            rules_list = get_rules_by_category(cat)
        except ValueError:
            valid = ", ".join(c.value for c in RuleCategory)
            console.print(f"[red]Error:[/red] Invalid category '{category}'. Valid: {valid}")
            raise typer.Exit(1)
    else:
        rules_list = list(RULE_META.values())

    if use_json:
        # JSON output for agents
        data = {
            "rules": [
                {
                    "name": r.name,
                    "severity": r.severity.value,
                    "category": r.category.value,
                    "detects": r.detects,
                    "cannot_detect": list(r.cannot_detect),
                    "hint": r.hint,
                }
                for r in rules_list
            ]
        }
        console.print(json_lib.dumps(data, indent=2))
    else:
        # Rich table output for humans
        table = Table(title="Invar Guard Rules")
        table.add_column("Rule", style="cyan")
        table.add_column("Severity", style="yellow")
        table.add_column("Category")
        table.add_column("Detects")
        table.add_column("Hint", style="green")

        for r in rules_list:
            sev_style = {"error": "red", "warning": "yellow", "info": "blue"}.get(
                r.severity.value, ""
            )
            table.add_row(
                r.name,
                f"[{sev_style}]{r.severity.value.upper()}[/{sev_style}]",
                r.category.value,
                r.detects[:50] + "..." if len(r.detects) > 50 else r.detects,
                r.hint[:40] + "..." if len(r.hint) > 40 else r.hint,
            )

        console.print(table)
        console.print(f"\n[dim]{len(rules_list)} rules total. Use --json for full details.[/dim]")j  Nu}(j<  testj<  Kj<  }(j<  }(j<  Mj<  K uj<  }(j<  Mj<  Kuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  ](}(j<  targetj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K:uuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K:uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jvA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  7target: str = typer.Argument(..., help="File to test"),j  jkA  u}(j<  verbosej<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  KQuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  KQuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Nverbose: bool = typer.Option(False, "-v", "--verbose", help="Verbose output"),j  jkA  u}(j<  json_outputj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  KLuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  KLuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Ijson_output: bool = typer.Option(False, "--json", help="Output as JSON"),j  jkA  u}(j<  use_jsonj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  .use_json = json_output or _detect_agent_mode()j  jkA  u}(j<  resultj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K
uuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K
uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  ,result = run_test(target, use_json, verbose)j  jkA  uej  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jmA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  XU  @app.command()
def test(
    target: str = typer.Argument(..., help="File to test"),
    verbose: bool = typer.Option(False, "-v", "--verbose", help="Verbose output"),
    json_output: bool = typer.Option(False, "--json", help="Output as JSON"),
) -> None:
    """Run property-based tests using Hypothesis via deal.cases."""
    from invar.shell.testing import run_test

    use_json = json_output or _detect_agent_mode()
    result = run_test(target, use_json, verbose)
    if isinstance(result, Failure):
        console.print(f"[red]Error:[/red] {result.failure()}")
        raise typer.Exit(1)j  Nu}(j<  verifyj<  Kj<  }(j<  }(j<  Mj<  K uj<  }(j<  Mj<  Kuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K
uuj<  ](}(j<  targetj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K<uuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K<uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.py      j  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  9target: str = typer.Argument(..., help="File to verify"),j  jA  u}(j<  timeoutj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  KWuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  KWuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Ttimeout: int = typer.Option(30, "--timeout", help="Timeout per function (seconds)"),j  jA  u}(j<  json_outputj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  KLuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  KLuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  Ijson_output: bool = typer.Option(False, "--json", help="Output as JSON"),j  jA  u}(j<  use_jsonj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  Kuuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  .use_json = json_output or _detect_agent_mode()j  jA  u}(j<  resultj<  K
j<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K
uuj<  }(j<  }(j<  Mj<  Kuj<  }(j<  Mj<  K
uuj<  ]j  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  .result = run_verify(target, use_json, timeout)j  jA  uej  }(j  8file:///Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  jA  j  1/Users/tefx/Projects/Invar/src/invar/shell/cli.pyj  j<  uj  XT  @app.command()
def verify(
    target: str = typer.Argument(..., help="File to verify"),
    timeout: int = typer.Option(30, "--timeout", help="Timeout per function (seconds)"),
    json_output: bool = typer.Option(False, "--json", help="Output as JSON"),
) -> None:
    """Run symbolic verification using CrossHair."""
    from invar.shell.testing import run_verify

    use_json = json_output or _detect_agent_mode()
    result = run_verify(target, use_json, timeout)
    if isinstance(result, Failure):
        console.print(f"[red]Error:[/red] {result.failure()}")
        raise typer.Exit(1)j  Nueja  Nubsrc/invar/shell/init_cmd.py 19ab85d31f9fbb3c6394b699afd97567h)}(h](}(nameconsolekindK
range}(start}(lineK	characterK uend}(jB  KjB  KuuselectionRange}(jB  }(jB  KjB  K ujB  }(jB  KjB  Kuuchildren]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  src/invar/shell/init_cmd.pyuj  console = Console()j  Nu}(jB  initjB  KjB  }(jB  }(jB  KjB  K ujB  }(jB  KjB  KCuujB  }(jB  }(jB  KjB  KujB  }(jB  KjB  KuujB  ](}(jB  pathjB  K
jB  }(jB  }(jB  KjB  KujB  }(jB  KjB  KFuujB  }(jB  }(jB  KjB  KujB  }(jB  KjB  KFuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j/B  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  Cpath: Path = typer.Argument(Path(), help="Project root directory"),j  j$B  u}(jB  dirsjB  K
jB  }(jB  }(jB  KjB  KujB  }(jB  KjB  KuujB  }(jB  }(jB  KjB  KujB  }(jB  KjB  KuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j<B  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  tdirs: bool = typer.Option(
        None, "--dirs/--no-dirs", help="Create src/core and src/shell directories"
    ),j  j$B  u}(jB  hooksjB  K
jB  }(jB  }(jB  K jB  KujB  }(jB  K"jB  KuujB  }(jB  }(jB  K jB  KujB  }(jB  K"jB  KuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jIB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  thooks: bool = typer.Option(
        True, "--hooks/--no-hooks", help="Install pre-commit hooks (default: ON)"
    ),j  j$B  u}(jB  yesjB  K
jB  }(jB  }(jB  K#jB  KujB  }(jB  K%jB  KuujB  }(jB  }(jB  K#jB  KujB  }(jB  K%jB  KuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jVB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  gyes: bool = typer.Option(
        False, "--yes", "-y", help="Accept defaults without prompting"
    ),j  j$B  u}(jB  
config_resultjB  K
jB  }(jB  }(jB  K2jB  KujB  }(jB  K2jB  KuujB  }(jB  }(jB  K2jB  KujB  }(jB  K2jB  KuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jcB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  )config_result = add_config(path, console)j  j$B  u}(jB  config_addedjB  K
jB  }(jB  }(jB  K6jB  KujB  }(jB  K6jB  KuujB  }(jB  }(jB  K6jB  KujB  }(jB  K6jB  KuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jpB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  %config_added = config_result.unwrap()j  j$B  u}(jB  resultjB  K
jB  }(jB  }(jB  K9jB  KujB  }(jB  K9jB  K
uujB  }(jB  }(jB  K9jB  KujB  }(jB  K9jB  K
uujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j}B  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  (result = copy_template("INVAR.md", path)j  j$B  u}(jB  	invar_dirjB  K
jB  }(jB  }(jB  KAjB  KujB  }(jB  KAjB  K
uujB  }(jB  }(jB  KAjB  KujB  }(jB  KAjB  K
uujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  invar_dir = path / ".invar"j  j$B  u}(jB  
proposals_dirjB  K
jB  }(jB  }(jB  KIjB  KujB  }(jB  KIjB  KuujB  }(jB  }(jB  KIjB  KujB  }(jB  KIjB  KuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  'proposals_dir = invar_dir / "proposals"j  j$B  u}(jB  agent_resultjB  K
jB  }(jB  }(jB  KRjB  KujB  }(jB  KRjB  KuujB  }(jB  }(jB  KRjB  KujB  }(jB  KRjB  KuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  )agent_result = detect_agent_configs(path)j  j$B  u}(jB  agent_statusjB  K
jB  }(jB  }(jB  KUjB  KujB  }(jB  KUjB  KuujB  }(jB  }(jB  KUjB  KujB  }(jB  KUjB  KuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  !agent_status: dict[str, str] = {}j  j$B  u}(jB  agentjB  K
jB  }(jB  }(jB  KZjB  KujB  }(jB  KZjB  K
uujB  }(jB  }(jB  KZjB  KujB  }(jB  KZjB  K
uujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  &agent, status in agent_status.items():j  j$B  u}(jB  statusjB  K
jB  }(jB  }(jB  KZjB  KujB  }(jB  KZjB  KuujB  }(jB  }(jB  KZjB  KujB  }(jB  KZjB  KuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  status in agent_status.items():j  j$B  u}(jB  
claude_statusjB  K
jB  }(jB  }(jB  KejB  KujB  }(jB  KejB  KuujB  }(jB  }(jB  KejB  KujB  }(jB  KejB  KuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  7claude_status = agent_status.get("claude", "not_found")j  j$B  u}(jB  
other_missingjB  K
jB  }(jB  }(jB  KojB  KujB  }(jB  KojB  KuujB  }(jB  }(jB  KojB  KujB  }(jB  KojB  KuujB  ]j  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  jB  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  other_missing = [j  j$B  uej  }(j  =file:///Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j&B  j  6/Users/tefx/Projects/Invar/src/invar/shell/init_cmd.pyj  j"B  uj  X`  def init(
    path: Path = typer.Argument(Path(), help="Project root directory"),
    dirs: bool = typer.Option(
        None, "--dirs/--no-dirs", help="Create src/core and src/shell directories"
    ),
    hooks: bool = typer.Option(
        True, "--hooks/--no-hooks", help="Install pre-commit hooks (default: ON)"
    ),
    yes: bool = typer.Option(
        False, "--yes", "-y", help="Accept defaults without prompting"
    ),
) -> None:
    """
    Initialize Invar configuration in a project.

    Works with or without pyproject.toml:
    - If pyproject.toml exists: adds [tool.invar.guard] section
    - Otherwise: creates invar.toml

    Use --dirs to always create directories, --no-dirs to skip.
    Use --no-hooks to skip pre-commit hooks installation.
    Use --yes to accept defaults without prompting.
    """
    config_result = add_config(path, console)
    if isinstance(config_result, Failure):
        console.print(f"[red]Error:[/red] {config_result.failure()}")
        raise typer.Exit(1)
    config_added = config_result.unwrap()

    # Create INVAR.md (protocol)
    result = copy_template("INVAR.md", path)
    if isinstance(result, Success) and result.unwrap():
        console.print("[green]Created[/green] INVAR.md (Invar Protocol)")

    # Copy examples directory
    copy_examples_directory(path, console)

    # Create .invar directory structure
    invar_dir = path / ".invar"
    if not invar_dir.exists():
        invar_dir.mkdir()
        result = copy_template("context.md.template", invar_dir, "context.md")
        if isinstance(result, Success) and result.unwrap():
            console.print("[green]Created[/green] .invar/context.md (context management)")

    # Create proposals directory for protocol governance
    proposals_dir = invar_dir / "proposals"
    if not proposals_dir.exists():
        proposals_dir.mkdir()
        result = copy_template("proposal.md.template", proposals_dir, "TEMPLATE.md")
        if isinstance(result, Success) and result.unwrap():
            console.print("[green]Created[/green] .invar/proposals/TEMPLATE.md")

    # Agent detection and configuration (DX-11)
    console.print("\n[bold]Checking for agent configurations...[/bold]")
    agent_result = detect_agent_configs(path)
    if isinstance(agent_result, Failure):
        console.print(f"[yellow]Warning:[/yellow] {agent_result.failure()}")
        agent_status: dict[str, str] = {}
    else:
        agent_status = agent_result.unwrap()

    # Handle existing configs
    for agent, status in agent_status.items():
        if status == "configured":
            console.print(f"  [green]✓[/green] {agent}: already configured")
        elif status == "found":
            # Ask before modifying
            if yes or typer.confirm(f"  Add Invar reference to {agent} config?", default=True):
                add_invar_reference(path, agent, console)
            else:
                console.print(f"  [yellow]○[/yellow] {agent}: skipped")

    # Handle missing CLAUDE.md specifically
    claude_status = agent_status.get("claude", "not_found")
    if claude_status == "not_found":
        # Create CLAUDE.md from template
        result = copy_template("CLAUDE.md.template", path, "CLAUDE.md")
        if isinstance(result, Success) and result.unwrap():
            console.print("[green]Created[/green] CLAUDE.md (project guide)")
        elif isinstance(result, Failure):
            console.print(f"[yellow]Warning:[/yellow] {result.failure()}")

    # Show guidance for other agents
    other_missing = [
        agent for agent, status in agent_status.items()
        if status == "not_found" and agent != "claude"
    ]
    if other_missing:
        console.print("\n[dim]For other agents, add to their config:[/dim]")
        console.print('[dim]  "Follow the Invar Protocol in INVAR.md"[/dim]')

    # Handle directory creation based on --dirs flag
    if dirs is not False:
        create_directories(path, console)

    # Install pre-commit hooks if requested
    if hooks:
        install_hooks(path, console)

    if not config_added and not (path / "INVAR.md").exists():
        console.print("[yellow]Invar already configured.[/yellow]")j  Nueja  Nubsrc/invar/shell/templates.py 6690399a4361f37b89d9a234a1265d4bh)}(h](}(name_DEFAULT_PYPROJECT_CONFIGkindKrange}(start}(lineK
	characterK uend}(jC  K
jC  KuuselectionRange}(j C  }(jC  K
jC  K ujC  }(jC  K
jC  Kuuchildren]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  6_DEFAULT_PYPROJECT_CONFIG = """\n# Invar Configurationj  Nu}(jB  _DEFAULT_INVAR_TOMLjB  KjB  }(j C  }(jC  KjC  K ujC  }(jC  KjC  KuujC  }(j C  }(jC  KjC  K ujC  }(jC  KjC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  ._DEFAULT_INVAR_TOML = """# Invar Configurationj  Nu}(jB  get_template_pathjB  KjB  }(j C  }(jC  K,jC  K ujC  }(jC  K4jC  K;uujC  }(j C  }(jC  K,jC  KujC  }(jC  K,jC  Kuuj
C  ](}(jB  namejB  K
jB  }(j C  }(jC  K,jC  KujC  }(jC  K,jC  KuujC  }(j C  }(jC  K,jC  KujC  }(jC  K,jC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  j(C  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj   name: str) -> Result[Path, str]:j  jC  u}(jB  pathjB  K
jB  }(j C  }(jC  K/jC  KujC  }(jC  K/jC  KuujC  }(j C  }(jC  K/jC  KujC  }(jC  K/jC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  j5C  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  Cpath = Path(str(resources.files("invar.templates").joinpath(name)))j  jC  u}(jB  hjB  K
jB  }(j C  }(jC  K3jC  KujC  }(jC  K3jC  KuujC  }(j C  }(jC  K3jC  KujC  }(jC  K3jC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jAC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  e:j  jC  uej  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  X  def get_template_path(name: str) -> Result[Path, str]:
    """Get path to a template file."""
    try:
        path = Path(str(resources.files("invar.templates").joinpath(name)))
        if not path.exists():
            return Failure(f"Template '{name}' not found")
        return Success(path)
    except Exception as e:
        return Failure(f"Failed to get template path: {e}")j  Nu}(jB  
copy_templatejB  KjB  }(j C  }(jC  K7jC  K ujC  }(jC  KHjC  K7uujC  }(j C  }(jC  K7jC  KujC  }(jC  K7jC  Kuuj
C  ](}(jB  
template_namejB  K
jB  }(j C  }(jC  K8jC  KujC  }(jC  K8jC  KuujC  }(j C  }(jC  K8jC  KujC  }(jC  K8jC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  j[C  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  <template_name: str, dest: Path, dest_name: str | None = Nonej  jPC  u}(jB  destjB  K
jB  }(j C  }(jC  K8jC  KujC  }(jC  K8jC  K"uujC  }(j C  }(jC  K8jC  KujC  }(jC  K8jC  K"uuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jhC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  (dest: Path, dest_name: str | None = Nonej  jPC  u}(jB  	dest_namejB  K
jB  }(j C  }(jC  K8jC  K$ujC  }(jC  K8jC  K@uujC  }(j C  }(jC  K8jC  K$ujC  }(jC  K8jC  K@uuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  juC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  dest_name: str | None = Nonej  jPC  u}(jB  	dest_filejB  K
jB  }(j C  }(jC  K=jC  KujC  }(jC  K=jC  K
uujC  }(j C  }(jC  K=jC  KujC  }(jC  K=jC  K
uuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  dest_file = dest / dest_namej  jPC  u}(jB  template_resultjB  K
jB  }(j C  }(jC  K@jC  KujC  }(jC  K@jC  KuujC  }(j C  }(jC  K@jC  KujC  }(jC  K@jC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  2template_result = get_template_path(template_name)j  jPC  u}(jB  
template_pathjB  K
jB  }(j C  }(jC  KCjC  KujC  }(jC  KCjC  KuujC  }(j C  }(jC  KCjC  KujC  }(jC  KCjC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  (template_path = template_result.unwrap()j  jPC  u}(jB  hjB  K
jB  }(j C  }(jC  KGjC  KujC  }(jC  KGjC  KuujC  }(j C  }(jC  KGjC  KujC  }(jC  KGjC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  e:j  jPC  uej  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jRC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  X  def copy_template(
    template_name: str, dest: Path, dest_name: str | None = None
) -> Result[bool, str]:
    """Copy a template file to destination. Returns Success(True) if copied, Success(False) if skipped."""
    if dest_name is None:
        dest_name = template_name.replace(".template", "")
    dest_file = dest / dest_name
    if dest_file.exists():
        return Success(False)
    template_result = get_template_path(template_name)
    if isinstance(template_result, Failure):
        return template_result
    template_path = template_result.unwrap()
    try:
        dest_file.write_text(template_path.read_text())
        return Success(True)
    except OSError as e:
        return Failure(f"Failed to copy template: {e}")j  Nu}(jB  
add_configjB  KjB  }(j C  }(jC  KKjC  K ujC  }(jC  KajC  K4uujC  }(j C  }(jC  KKjC  KujC  }(jC  KKjC  Kuuj
C  ](}(jB  pathjB  K
jB  }(j C  }(jC  KKjC  KujC  }(jC  KKjC  KuujC  }(j C  }(jC  KKjC  KujC  }(jC  KKjC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  *path: Path, console) -> Result[bool, str]:j  jC  u}(jB  consolejB  K
jB  }(j C  }(jC  KKjC  KujC  }(jC  KKjC  K"uujC  }(j C  }(jC  KKjC  KujC  }(jC  KKjC  K"uuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  console) -> Result[bool, str]:j  jC  u}(jB  	pyprojectjB  K
jB  }(j C  }(jC  KMjC  KujC  }(jC  KMjC  K
uujC  }(j C  }(jC  KMjC  KujC  }(jC  KMjC  K
uuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  #pyproject = path / "pyproject.toml"j  jC  u}(jB  
invar_tomljB  K
jB  }(j C  }(jC  KNjC  KujC  }(jC  KNjC  KuujC  }(j C  }(jC  KNjC  KujC  }(jC  KNjC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj   invar_toml = path / "invar.toml"j  jC  u}(jB  contentjB  K
jB  }(j C  }(jC  KRjC  KujC  }(jC  KRjC  KuujC  }(j C  }(jC  KRjC  KujC  }(jC  KRjC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  content = pyproject.read_text()j  jC  u}(jB  fjB  K
jB  }(j C  }(jC  KTjC  K,ujC  }(jC  KTjC  K-uujC  }(j C  }(jC  KTjC  K,ujC  }(jC  KTjC  K-uuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jD  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  f:j  jC  u}(jB  hjB  K
jB  }(j C  }(jC  K`jC  KujC  }(jC  K`jC  KuujC  }(j C  }(jC  K`jC  KujC  }(jC  K`jC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jD  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  e:j  jC  uej  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jC  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  X  def add_config(path: Path, console) -> Result[bool, str]:
    """Add configuration to project. Returns Success(True) if added, Success(False) if skipped."""
    pyproject = path / "pyproject.toml"
    invar_toml = path / "invar.toml"

    try:
        if pyproject.exists():
            content = pyproject.read_text()
            if "[tool.invar]" not in content:
                with pyproject.open("a") as f:
                    f.write(_DEFAULT_PYPROJECT_CONFIG)
                console.print("[green]Added[/green] [tool.invar.guard] to pyproject.toml")
                return Success(True)
            return Success(False)

        if not invar_toml.exists():
            invar_toml.write_text(_DEFAULT_INVAR_TOML)
            console.print("[green]Created[/green] invar.toml")
            return Success(True)

        return Success(False)
    except OSError as e:
        return Failure(f"Failed to add config: {e}")j  Nu}(jB  create_directoriesjB  KjB  }(j C  }(jC  KdjC  K ujC  }(jC  KqjC  K:uujC  }(j C  }(jC  KdjC  KujC  }(jC  KdjC  Kuuj
C  ](}(jB  pathjB  K
jB  }(j C  }(jC  KdjC  KujC  }(jC  KdjC  K!uujC  }(j C  }(jC  KdjC  KujC  }(jC  KdjC  K!uuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  j)D  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  path: Path, console) -> None:j  jD  u}(jB  consolejB  K
jB  }(j C  }(jC  KdjC  K#ujC  }(jC  KdjC  K*uujC  }(j C  }(jC  KdjC  K#ujC  }(jC  KdjC  K*uuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  j6D  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  console) -> None:j  jD  u}(jB  	core_pathjB  K
jB  }(j C  }(jC  KfjC  KujC  }(jC  KfjC  K
uujC  }(j C  }(jC  KfjC  KujC  }(jC  KfjC  K
uuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jCD  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  !core_path = path / "src" / "core"j  jD  u}(jB  
shell_pathjB  K
jB  }(j C  }(jC  KgjC  KujC  }(jC  KgjC  KuujC  }(j C  }(jC  KgjC  KujC  }(jC  KgjC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jPD  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  #shell_path = path / "src" / "shell"j  jD  uej  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  j D  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  X  def create_directories(path: Path, console) -> None:
    """Create src/core and src/shell directories."""
    core_path = path / "src" / "core"
    shell_path = path / "src" / "shell"

    if not core_path.exists():
        core_path.mkdir(parents=True)
        (core_path / "__init__.py").touch()
        console.print("[green]Created[/green] src/core/")

    if not shell_path.exists():
        shell_path.mkdir(parents=True)
        (shell_path / "__init__.py").touch()
        console.print("[green]Created[/green] src/shell/")j  Nu}(jB  
install_hooksjB  KjB  }(j C  }(jC  KtjC  K ujC  }(jC  KjC  KuujC  }(j C  }(jC  KtjC  KujC  }(jC  KtjC  Kuuj
C  ](}(jB  pathjB  K
jB  }(j C  }(jC  KtjC  KujC  }(jC  KtjC  KuujC  }(j C  }(jC  KtjC  KujC  }(jC  KtjC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jjD  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  *path: Path, console) -> Result[bool, str]:j  j_D  u}(jB  consolejB  K
jB  }(j C  }(jC  KtjC  KujC  }(jC  KtjC  K%uujC  }(j C  }(jC  KtjC  KujC  }(jC  KtjC  K%uuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jwD  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  console) -> Result[bool, str]:j  j_D  u}(jB  pre_commit_configjB  K
jB  }(j C  }(jC  KxjC  KujC  }(jC  KxjC  KuujC  }(j C  }(jC  KxjC  KujC  }(jC  KxjC  Kuuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jD  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  4pre_commit_config = path / ".pre-commit-config.yaml"j  j_D  u}(jB  resultjB  K
jB  }(j C  }(jC  K~jC  KujC  }(jC  K~jC  K
uujC  }(j C  }(jC  K~jC  KujC  }(jC  K~jC  K
uuj
C  ]j  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jD  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  Zresult = copy_template("pre-commit-config.yaml.template", path, ".pre-commit-config.yaml")j  j_D  uej  }(j  >file:///Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jaD  j  7/Users/tefx/Projects/Invar/src/invar/shell/templates.pyj  jB  uj  X  def install_hooks(path: Path, console) -> Result[bool, str]:
    """Install pre-commit hooks configuration and activate them."""
    import subprocess

    pre_commit_config = path / ".pre-commit-config.yaml"

    if pre_commit_config.exists():
        console.print("[yellow]Skipped[/yellow] .pre-commit-config.yaml (already exists)")
        return Success(False)

    result = copy_template("pre-commit-config.yaml.template", path, ".pre-commit-config.yaml")
    if isinstance(result, Failure):
        return result

    if result.unwrap():
        console.print("[green]Created[/green] .pre-commit-config.yaml")

        # Auto-install hooks (Automatic > Opt-in)
        try:
            subprocess.run(
                ["pre-commit", "install"],
                cwd=path,
                check=True,
                capture_output=True,
            )
            console.print("[green]Installed[/green] pre-commit hooks")
        except FileNotFoundError:
            console.print("[dim]Run: pre-commit install (pre-commit not in PATH)[/dim]")
        except subprocess.CalledProcessError:
            console.print("[dim]Run: pre-commit install (not a git repo?)[/dim]")

        return Success(True)

    return Success(False)j  Nueja  Nub'src/invar/core/hypothesis_strategies.py fee3e1da5a92e325a2fbecb776f0225bh)}(h](}(name_hypothesis_availablekindK
range}(start}(lineK	characterK uend}(jD  KjD  KuuselectionRange}(jD  }(jD  KjD  K ujD  }(jD  KjD  Kuuchildren]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  _hypothesis_available = Falsej  Nu}(jD  _numpy_availablejD  K
jD  }(jD  }(jD  KjD  K ujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  K ujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  _numpy_available = Falsej  Nu}(jD  _ensure_hypothesisjD  KjD  }(jD  }(jD  KjD  K ujD  }(jD  K"jD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X5  @post(lambda result: isinstance(result, bool))
def _ensure_hypothesis() -> bool:
    """Check if hypothesis is available."""
    global _hypothesis_available
    try:
        import hypothesis  # noqa: F401

        _hypothesis_available = True
        return True
    except ImportError:
        return Falsej  Nu}(jD  
_ensure_numpyjD  KjD  }(jD  }(jD  K%jD  K ujD  }(jD  K/jD  KuujD  }(jD  }(jD  K&jD  KujD  }(jD  K&jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @post(lambda result: isinstance(result, bool))
def _ensure_numpy() -> bool:
    """Check if numpy is available."""
    global _numpy_available
    try:
        import numpy  # noqa: F401

        _numpy_available = True
        return True
    except ImportError:
        return Falsej  Nu}(jD  TimeoutTierjD  KjD  }(jD  }(jD  K7jD  K ujD  }(jD  K=jD  KuujD  }(jD  }(jD  K8jD  KujD  }(jD  K8jD  KuujD  ](}(jD  namejD  K
jD  }(jD  }(jD  K;jD  KujD  }(jD  K;jD  KuujD  }(jD  }(jD  K;jD  KujD  }(jD  K;jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  	name: strj  jD  u}(jD  timeoutjD  K
jD  }(jD  }(jD  K<jD  KujD  }(jD  K<jD  KuujD  }(jD  }(jD  K<jD  KujD  }(jD  K<jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  timeout: intj  jD  u}(jD  descriptionjD  K
jD  }(jD  }(jD  K=jD  KujD  }(jD  K=jD  KuujD  }(jD  }(jD  K=jD  KujD  }(jD  K=jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  description: strj  jD  uej  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  @dataclass
class TimeoutTier:
    """Timeout tier for CrossHair based on code characteristics."""

    name: str
    timeout: int
    description: strj  Nu}(jD  
TIMEOUT_TIERSjD  KjD  }(jD  }(jD  K@jD  K ujD  }(jD  K@jD  K
uujD  }(jD  }(jD  K@jD  K ujD  }(jD  K@jD  K
uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  TIMEOUT_TIERS = {j  Nu}(jD  LIBRARY_BLACKLISTjD  KjD  }(jD  }(jD  KHjD  K ujD  }(jD  KHjD  KuujD  }(jD  }(jD  KHjD  K ujD  }(jD  KHjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j&E  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  LIBRARY_BLACKLIST = frozenset([j  Nu}(jD  
infer_timeoutjD  KjD  }(jD  }(jD  KNjD  K ujD  }(jD  KrjD  K/uujD  }(jD  }(jD  KPjD  KujD  }(jD  KPjD  KuujD  ](}(jD  funcjD  K
jD  }(jD  }(jD  KPjD  KujD  }(jD  KPjD  K uujD  }(jD  }(jD  KPjD  KujD  }(jD  KPjD  K uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j<E  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  func: Callable) -> int:j  j1E  u}(jD  sourcejD  K
jD  }(jD  }(jD  K_jD  KujD  }(jD  K_jD  KuujD  }(jD  }(jD  K_jD  KujD  }(jD  K_jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jIE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj   source = inspect.getsource(func)j  j1E  u}(jD  libjD  K
jD  }(jD  }(jD  KdjD  KujD  }(jD  KdjD  KuujD  }(jD  }(jD  KdjD  KujD  }(jD  KdjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jVE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  lib in LIBRARY_BLACKLIST:j  j1E  u}(jD  
nesting_depthjD  K
jD  }(jD  }(jD  KijD  KujD  }(jD  KijD  KuujD  }(jD  }(jD  KijD  KujD  }(jD  KijD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jcE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  /nesting_depth = _estimate_nesting_depth(source)j  j1E  u}(jD  branch_countjD  K
jD  }(jD  }(jD  KjjD  KujD  }(jD  KjjD  KuujD  }(jD  }(jD  KjjD  KujD  }(jD  KjjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jpE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  &branch_count = _count_branches(source)j  j1E  uej  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j3E  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X3  @pre(lambda func: callable(func))
@post(lambda result: isinstance(result, int) and result > 0)
def infer_timeout(func: Callable) -> int:
    """
    Infer appropriate CrossHair timeout from function source.

    Args:
        func: The function to analyze

    Returns:
        Timeout in seconds

    >>> def pure_func(x: int) -> int: return x * 2
    >>> infer_timeout(pure_func)
    10
    """
    try:
        source = inspect.getsource(func)
    except (OSError, TypeError):
        return TIMEOUT_TIERS["pure_python"].timeout

    # Check for blacklisted libraries
    for lib in LIBRARY_BLACKLIST:
        if re.search(rf"\b{lib}\b", source):
            return TIMEOUT_TIERS["numpy_pandas"].timeout

    # Count complexity indicators
    nesting_depth = _estimate_nesting_depth(source)
    branch_count = _count_branches(source)

    if nesting_depth > 4 or branch_count > 10:
        return TIMEOUT_TIERS["complex_nested"].timeout

    if _uses_only_stdlib(source):
        return TIMEOUT_TIERS["stdlib_only"].timeout

    return TIMEOUT_TIERS["pure_python"].timeoutj  Nu}(jD  _estimate_nesting_depthjD  KjD  }(jD  }(jD  KujD  K ujD  }(jD  KjD  KuujD  }(jD  }(jD  KwjD  KujD  }(jD  KwjD  KuujD  ](}(jD  sourcejD  K
jD  }(jD  }(jD  KwjD  KujD  }(jD  KwjD  K'uujD  }(jD  }(jD  KwjD  KujD  }(jD  KwjD  K'uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  source: str) -> int:j  jE  u}(jD  
max_indentjD  K
jD  }(jD  }(jD  KyjD  KujD  }(jD  KyjD  KuujD  }(jD  }(jD  KyjD  KujD  }(jD  KyjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  max_indent = 0j  jE  u}(jD  linejD  K
jD  }(jD  }(jD  KzjD  KujD  }(jD  KzjD  KuujD  }(jD  }(jD  KzjD  KujD  }(jD  KzjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  line in source.split("\n"):j  jE  u}(jD  strippedjD  K
jD  }(jD  }(jD  K{jD  KujD  }(jD  K{jD  KuujD  }(jD  }(jD  K{jD  KujD  }(jD  K{jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  stripped = line.lstrip()j  jE  u}(jD  indentjD  K
jD  }(jD  }(jD  K}jD  KujD  }(jD  K}jD  KuujD  }(jD  }(jD  K}jD  KujD  }(jD  K}jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  "indent = len(line) - len(stripped)j  jE  u}(jD  spacesjD  K
jD  }(jD  }(jD  K~jD  KujD  }(jD  K~jD  KuujD  }(jD  }(jD  K~jD  KujD  }(jD  K~jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  /spaces = indent // 4  # Assuming 4-space indentj  jE  uej  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @pre(lambda source: isinstance(source, str))
@post(lambda result: isinstance(result, int) and result >= 0)
def _estimate_nesting_depth(source: str) -> int:
    """Estimate maximum nesting depth from indentation."""
    max_indent = 0
    for line in source.split("\n"):
        stripped = line.lstrip()
        if stripped and not stripped.startswith("#"):
            indent = len(line) - len(stripped)
            spaces = indent // 4  # Assuming 4-space indent
            max_indent = max(max_indent, spaces)
    return max_indentj  Nu}(jD  _count_branchesjD  KjD  }(jD  }(jD  KjD  K ujD  }(jD  KjD  KIuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]}(jD  sourcejD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  source: str) -> int:j  jE  uaj  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @pre(lambda source: isinstance(source, str))
@post(lambda result: isinstance(result, int) and result >= 0)
def _count_branches(source: str) -> int:
    """Count branching statements (if, for, while, try)."""
    return len(re.findall(r"\b(if|for|while|try|elif|except)\b", source))j  Nu}(jD  _uses_only_stdlibjD  KjD  }(jD  }(jD  KjD  K ujD  }(jD  KjD  K-uujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ](}(jD  sourcejD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  K!uujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  K!uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  source: str) -> bool:j  jE  u}(jD  stdlib_patternsjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  Tstdlib_patterns = ["collections", "itertools", "functools", "typing", "dataclasses"]j  jE  u}(jD  third_party_patternsjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  Ithird_party_patterns = ["pandas", "numpy", "requests", "flask", "django"]j  jE  u}(jD  
has_stdlibjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j&F  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  :has_stdlib = any(pat in source for pat in stdlib_patterns)j  jE  u}(jD  has_third_partyjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j3F  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  Dhas_third_party = any(pat in source for pat in third_party_patterns)j  jE  uej  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jE  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @pre(lambda source: isinstance(source, str))
@post(lambda result: isinstance(result, bool))
def _uses_only_stdlib(source: str) -> bool:
    """Check if source only uses standard library."""
    stdlib_patterns = ["collections", "itertools", "functools", "typing", "dataclasses"]
    third_party_patterns = ["pandas", "numpy", "requests", "flask", "django"]

    has_stdlib = any(pat in source for pat in stdlib_patterns)
    has_third_party = any(pat in source for pat in third_party_patterns)

    return has_stdlib and not has_third_partyj  Nu}(jD  StrategySpecjD  KjD  }(jD  }(jD  KjD  K ujD  }(jD  KjD  K1uujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ](}(jD  
strategy_namejD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jMF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  strategy_name: strj  jBF  u}(jD  kwargsjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  K
uujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  K
uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jZF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  4kwargs: dict[str, Any] = field(default_factory=dict)j  jBF  u}(jD  descriptionjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jgF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  description: str = ""j  jBF  u}(jD  to_codejD  KjD  }(jD  }(jD  KjD  KujD  }(jD  KjD  K1uujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]}(jD  argsjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j}F  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  >args = ", ".join(f"{k}={v!r}" for k, v in self.kwargs.items())j  jrF  uaj  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jtF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @post(lambda result: isinstance(result, str) and result.startswith("st."))
    def to_code(self) -> str:
        """
        Generate Hypothesis strategy code.

        >>> spec = StrategySpec("integers", {"min_value": 0, "max_value": 100})
        >>> spec.to_code()
        'st.integers(min_value=0, max_value=100)'
        """
        if not self.kwargs:
            return f"st.{self.strategy_name}()"
        args = ", ".join(f"{k}={v!r}" for k, v in self.kwargs.items())
        return f"st.{self.strategy_name}({args})"j  jBF  uej  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jDF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @dataclass
class StrategySpec:
    """Specification for a Hypothesis strategy."""

    strategy_name: str
    kwargs: dict[str, Any] = field(default_factory=dict)
    description: str = ""

    @post(lambda result: isinstance(result, str) and result.startswith("st."))
    def to_code(self) -> str:
        """
        Generate Hypothesis strategy code.

        >>> spec = StrategySpec("integers", {"min_value": 0, "max_value": 100})
        >>> spec.to_code()
        'st.integers(min_value=0, max_value=100)'
        """
        if not self.kwargs:
            return f"st.{self.strategy_name}()"
        args = ", ".join(f"{k}={v!r}" for k, v in self.kwargs.items())
        return f"st.{self.strategy_name}({args})"j  Nu}(jD  TYPE_STRATEGIESjD  KjD  }(jD  }(jD  KjD  K ujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  K ujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  -TYPE_STRATEGIES: dict[type, StrategySpec] = {j  Nu}(jD  strategy_from_typejD  KjD  }(jD  }(jD  KjD  K ujD  }(jD  MjD  K?uujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ](}(jD  hintjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  K!uujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  K!uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  hint: type) -> StrategySpec:j  jF  u}(jD  originjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  K
uujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  K
uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  origin = get_origin(hint)j  jF  u}(jD  argsjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  args = get_args(hint)j  jF  u}(jD  element_typejD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  'element_type = args[0] if args else intj  jF  u}(jD  element_strategyjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  3element_strategy = strategy_from_type(element_type)j  jF  u}(jD  key_typejD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  ,key_type = args[0] if len(args) > 0 else strj  jF  u}(jD  val_typejD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  ,val_type = args[1] if len(args) > 1 else intj  jF  u}(jD  
element_specsjD  K
jD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  }(jD  }(jD  KjD  KujD  }(jD  KjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  ?element_specs = [strategy_from_type(a).to_code() for a in args]j  jF  uej  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jF  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @pre(lambda hint: hint is not None)
@post(lambda result: isinstance(result, StrategySpec))
def strategy_from_type(hint: type) -> StrategySpec:
    """
    Generate Hypothesis strategy specification from type annotation.

    >>> strategy_from_type(int).strategy_name
    'integers'

    >>> strategy_from_type(float).kwargs['allow_nan']
    False

    >>> strategy_from_type(list).strategy_name
    'lists'
    """
    # Direct type match
    if hint in TYPE_STRATEGIES:
        return TYPE_STRATEGIES[hint]

    # Handle generic types
    origin = get_origin(hint)
    args = get_args(hint)

    # Handle bare list/dict/tuple/set (without type args)
    if hint is list:
        return StrategySpec("lists", {"elements": "st.integers()"}, "Lists of int")
    if hint is dict:
        return StrategySpec("dictionaries", {"keys": "st.text()", "values": "st.integers()"}, "Dict")
    if hint is tuple:
        return StrategySpec("tuples", {}, "Tuple")
    if hint is set:
        return StrategySpec("frozensets", {"elements": "st.integers()"}, "Set of int")

    if origin is list:
        element_type = args[0] if args else int
        element_strategy = strategy_from_type(element_type)
        return StrategySpec(
            "lists",
            {"elements": element_strategy.to_code()},
            f"Lists of {element_type.__name__ if hasattr(element_type, '__name__') else element_type}",
        )

    if origin is dict:
        key_type = args[0] if len(args) > 0 else str
        val_type = args[1] if len(args) > 1 else int
        return StrategySpec(
            "dictionaries",
            {
                "keys": strategy_from_type(key_type).to_code(),
                "values": strategy_from_type(val_type).to_code(),
            },
            f"Dict[{key_type}, {val_type}]",
        )

    if origin is tuple:
        if args:
            element_specs = [strategy_from_type(a).to_code() for a in args]
            return StrategySpec("tuples", {"*args": element_specs}, f"Tuple{args}")
        return StrategySpec("tuples", {}, "Empty tuple")

    if origin is set:
        element_type = args[0] if args else int
        element_strategy = strategy_from_type(element_type)
        return StrategySpec(
            "frozensets",
            {"elements": element_strategy.to_code()},
            f"Sets of {element_type}",
        )

    # Check for numpy array
    if _ensure_numpy():
        import numpy as np

        if hint is np.ndarray or (hasattr(hint, "__name__") and "ndarray" in str(hint)):
            return StrategySpec(
                "arrays",
                {
                    "dtype": "np.float64",
                    "shape": "st.integers(1, 100)",
                    "elements": "st.floats(-1e6, 1e6, allow_nan=False)",
                },
                "NumPy float64 array",
            )

    # Fallback to nothing for unknown types
    return StrategySpec("nothing", {}, f"Unknown type: {hint}")j  Nu}(jD  strategies_from_signaturejD  KjD  }(jD  }(jD  MjD  K ujD  }(jD  M1jD  KuujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  ](}(jD  funcjD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  K,uujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  K,uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  +func: Callable) -> dict[str, StrategySpec]:j  jG  u}(jD  hintsjD  K
jD  }(jD  }(jD  M'jD  KujD  }(jD  M'jD  K
uujD  }(jD  }(jD  M'jD  KujD  }(jD  M'jD  K
uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j*G  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  hints = get_type_hints(func)j  jG  u}(jD  resultjD  K
jD  }(jD  }(jD  M+jD  KujD  }(jD  M+jD  K
uujD  }(jD  }(jD  M+jD  KujD  }(jD  M+jD  K
uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j7G  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  result = {}j  jG  u}(jD  namejD  K
jD  }(jD  }(jD  M,jD  KujD  }(jD  M,jD  KuujD  }(jD  }(jD  M,jD  KujD  }(jD  M,jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jDG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  name, hint in hints.items():j  jG  u}(jD  hintjD  K
jD  }(jD  }(jD  M,jD  KujD  }(jD  M,jD  KuujD  }(jD  }(jD  M,jD  KujD  }(jD  M,jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jQG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  hint in hints.items():j  jG  uej  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @pre(lambda func: callable(func))
@post(lambda result: isinstance(result, dict))
def strategies_from_signature(func: Callable) -> dict[str, StrategySpec]:
    """
    Generate strategies for all parameters from function signature.

    >>> def example(x: int, y: float) -> bool: return x > y
    >>> specs = strategies_from_signature(example)
    >>> specs['x'].strategy_name
    'integers'
    >>> specs['y'].strategy_name
    'floats'
    """
    try:
        hints = get_type_hints(func)
    except Exception:
        return {}

    result = {}
    for name, hint in hints.items():
        if name == "return":
            continue
        result[name] = strategy_from_type(hint)

    return resultj  Nu}(jD  refine_strategyjD  KjD  }(jD  }(jD  M9jD  K ujD  }(jD  MRjD  KuujD  }(jD  }(jD  M:jD  KujD  }(jD  M:jD  KuujD  ](}(jD  basejD  K
jD  }(jD  }(jD  M:jD  KujD  }(jD  M:jD  K&uujD  }(jD  }(jD  M:jD  KujD  }(jD  M:jD  K&uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jkG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  3base: StrategySpec, **kwargs: Any) -> StrategySpec:j  j`G  u}(jD  kwargsjD  K
jD  }(jD  }(jD  M:jD  K(ujD  }(jD  M:jD  K5uujD  }(jD  }(jD  M:jD  K(ujD  }(jD  M:jD  K5uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jxG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  **kwargs: Any) -> StrategySpec:j  j`G  u}(jD  
merged_kwargsjD  K
jD  }(jD  }(jD  MEjD  KujD  }(jD  MEjD  KuujD  }(jD  }(jD  MEjD  KujD  }(jD  MEjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  )merged_kwargs = {**base.kwargs, **kwargs}j  j`G  uej  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jbG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @post(lambda result: isinstance(result, StrategySpec))
def refine_strategy(base: StrategySpec, **kwargs: Any) -> StrategySpec:
    """
    Refine a base strategy with additional constraints.

    >>> base = StrategySpec("floats", {"allow_nan": False})
    >>> refined = refine_strategy(base, min_value=0, max_value=1)
    >>> refined.kwargs['min_value']
    0
    >>> refined.kwargs['max_value']
    1
    """
    merged_kwargs = {**base.kwargs, **kwargs}

    # Handle exclude_min/exclude_max for integers (not supported)
    if base.strategy_name == "integers":
        if merged_kwargs.pop("exclude_min", False) and "min_value" in merged_kwargs:
            merged_kwargs["min_value"] += 1
        if merged_kwargs.pop("exclude_max", False) and "max_value" in merged_kwargs:
            merged_kwargs["max_value"] -= 1

    return StrategySpec(
        strategy_name=base.strategy_name,
        kwargs=merged_kwargs,
        description=f"{base.description} (refined)",
    )j  Nu}(jD  infer_strategies_for_functionjD  KjD  }(jD  }(jD  MZjD  K ujD  }(jD  MjD  KuujD  }(jD  }(jD  M\jD  KujD  }(jD  M\jD  K!uujD  ](}(jD  funcjD  K
jD  }(jD  }(jD  M\jD  K"ujD  }(jD  M\jD  K0uujD  }(jD  }(jD  M\jD  K"ujD  }(jD  M\jD  K0uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  +func: Callable) -> dict[str, StrategySpec]:j  jG  u}(jD  
type_specsjD  K
jD  }(jD  }(jD  MnjD  KujD  }(jD  MnjD  KuujD  }(jD  }(jD  MnjD  KujD  }(jD  MnjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  ,type_specs = strategies_from_signature(func)j  jG  u}(jD  pre_sourcesjD  K
jD  }(jD  }(jD  MqjD  KujD  }(jD  MqjD  KuujD  }(jD  }(jD  MqjD  KujD  }(jD  MqjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  (pre_sources = _extract_pre_sources(func)j  jG  u}(jD  resultjD  K
jD  }(jD  }(jD  MwjD  KujD  }(jD  MwjD  K
uujD  }(jD  }(jD  MwjD  KujD  }(jD  MwjD  K
uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  result = {}j  jG  u}(jD  
param_namejD  K
jD  }(jD  }(jD  MxjD  KujD  }(jD  MxjD  KuujD  }(jD  }(jD  MxjD  KujD  }(jD  MxjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  'param_name, spec in type_specs.items():j  jG  u}(jD  specjD  K
jD  }(jD  }(jD  MxjD  KujD  }(jD  MxjD  KuujD  }(jD  }(jD  MxjD  KujD  }(jD  MxjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  spec in type_specs.items():j  jG  u}(jD  hintsjD  K
jD  }(jD  }(jD  M{jD  KujD  }(jD  M{jD  KuujD  }(jD  }(jD  M{jD  KujD  }(jD  M{jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  hints = get_type_hints(func)j  jG  u}(jD  
param_typejD  K
jD  }(jD  }(jD  M|jD  KujD  }(jD  M|jD  KuujD  }(jD  }(jD  M|jD  KujD  }(jD  M|jD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  "param_type = hints.get(param_name)j  jG  u}(jD  
all_boundsjD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jH  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  all_bounds: dict[str, Any] = {}j  jG  u}(jD  sourcejD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jH  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  source in pre_sources:j  jG  u}(jD  hintjD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j!H  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  8hint = infer_from_lambda(source, param_name, param_type)j  jG  u}(jD  strategy_kwargsjD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j.H  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  Lstrategy_kwargs = _bounds_to_strategy_kwargs(all_bounds, spec.strategy_name)j  jG  uej  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jG  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @pre(lambda func: callable(func))
@post(lambda result: isinstance(result, dict))
def infer_strategies_for_function(func: Callable) -> dict[str, StrategySpec]:
    """
    Infer complete strategies for a function from types and @pre contracts.

    This combines:
    1. Type-based strategy generation
    2. @pre contract bound extraction (via strategies.infer_from_lambda)

    >>> def constrained(x: float) -> float:
    ...     '''Requires x > 0.'''
    ...     return x ** 0.5
    >>> specs = infer_strategies_for_function(constrained)
    >>> specs['x'].strategy_name
    'floats'
    """
    from invar.core.strategies import infer_from_lambda

    # Start with type-based strategies
    type_specs = strategies_from_signature(func)

    # Try to extract @pre contracts
    pre_sources = _extract_pre_sources(func)

    if not pre_sources:
        return type_specs

    # Refine strategies with @pre bounds
    result = {}
    for param_name, spec in type_specs.items():
        # Get type for this param
        try:
            hints = get_type_hints(func)
            param_type = hints.get(param_name)
        except Exception:
            param_type = None

        # Infer bounds from @pre sources
        all_bounds: dict[str, Any] = {}
        for source in pre_sources:
            hint = infer_from_lambda(source, param_name, param_type)
            all_bounds.update(hint.constraints)

        if all_bounds:
            # Convert to strategy kwargs
            strategy_kwargs = _bounds_to_strategy_kwargs(all_bounds, spec.strategy_name)
            result[param_name] = refine_strategy(spec, **strategy_kwargs)
        else:
            result[param_name] = spec

    return result\      j  Nu}(jD  _extract_pre_sourcesjD  KjD  }(jD  }(jD  MjD  K ujD  }(jD  MjD  KuujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  ](}(jD  funcjD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  K'uujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  K'uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jHH  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  func: Callable) -> list[str]:j  j=H  u}(jD  pre_sourcesjD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jUH  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  pre_sources: list[str] = []j  j=H  u}(jD  sourcejD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jbH  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj   source = inspect.getsource(func)j  j=H  u}(jD  pre_patternjD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  joH  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  /pre_pattern = r"@pre\s*\(\s*(lambda[^)]+)\s*\)"j  j=H  u}(jD  matchesjD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j|H  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  )matches = re.findall(pre_pattern, source)j  j=H  uej  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  j?H  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @pre(lambda func: callable(func))
@post(lambda result: isinstance(result, list))
def _extract_pre_sources(func: Callable) -> list[str]:
    """Extract @pre contract source strings from a function."""
    pre_sources: list[str] = []

    # Check for deal contracts
    if hasattr(func, "__wrapped__"):
        # deal stores contracts in _deal attribute
        pass

    # Try to extract from source
    try:
        source = inspect.getsource(func)
        # Find @pre decorators
        pre_pattern = r"@pre\s*\(\s*(lambda[^)]+)\s*\)"
        matches = re.findall(pre_pattern, source)
        pre_sources.extend(matches)
    except (OSError, TypeError):
        pass

    return pre_sourcesj  Nu}(jD  _bounds_to_strategy_kwargsjD  KjD  }(jD  }(jD  MjD  K ujD  }(jD  MjD  KuujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  KuujD  ](}(jD  boundsjD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  K5uujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  K5uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jH  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  >bounds: dict[str, Any], strategy_name: str) -> dict[str, Any]:j  jH  u}(jD  
strategy_namejD  K
jD  }(jD  }(jD  MjD  K7ujD  }(jD  MjD  KIuujD  }(jD  }(jD  MjD  K7ujD  }(jD  MjD  KIuujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jH  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  &strategy_name: str) -> dict[str, Any]:j  jH  u}(jD  kwargsjD  K
jD  }(jD  }(jD  MjD  KujD  }(jD  MjD  K
uujD  }(jD  }(jD  MjD  KujD  }(jD  MjD  K
uujD  ]j  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jH  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  kwargs = {}j  jH  uej  }(j  Ifile:///Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jH  j  B/Users/tefx/Projects/Invar/src/invar/core/hypothesis_strategies.pyj  jD  uj  X  @pre(lambda bounds, strategy_name: isinstance(bounds, dict) and isinstance(strategy_name, str))
@post(lambda result: isinstance(result, dict))
def _bounds_to_strategy_kwargs(bounds: dict[str, Any], strategy_name: str) -> dict[str, Any]:
    """Convert bound constraints to Hypothesis strategy kwargs."""
    kwargs = {}

    # Numeric bounds
    if "min_value" in bounds:
        kwargs["min_value"] = bounds["min_value"]
    if "max_value" in bounds:
        kwargs["max_value"] = bounds["max_value"]

    # Size bounds (for collections)
    if "min_size" in bounds:
        kwargs["min_size"] = bounds["min_size"]
    if "max_size" in bounds:
        kwargs["max_size"] = bounds["max_size"]

    # Exclusion flags for floats
    if strategy_name == "floats":
        if bounds.get("exclude_min"):
            kwargs["exclude_min"] = True
        if bounds.get("exclude_max"):
            kwargs["exclude_max"] = True

    return kwargsj  Nueja  Nubuu.