import base64
import re


class MsgTypes:
    """消息类型"""
    AtMsg = 'AtMsg'
    PicMsg = 'PicMsg'
    TextMsg = 'TextMsg'
    ReplyMsg = 'ReplyMsg'
    VoiceMsg = 'VoiceMsg'
    VideoMsg = 'VideoMsg'
    RedBagMsg = 'RedBagMsg'
    TempSessionMsg = 'TempSessionMsg'


class EventNames:
    """事件类型"""
    ON_EVENT_GROUP_REVOKE = 'ON_EVENT_GROUP_REVOKE'
    ON_EVENT_GROUP_EXIT = 'ON_EVENT_GROUP_EXIT'
    ON_EVENT_GROUP_JOIN = 'ON_EVENT_GROUP_JOIN'
    ON_EVENT_GROUP_ADMINSYSNOTIFY = 'ON_EVENT_GROUP_ADMINSYSNOTIFY'
    ON_EVENT_FRIEND_REVOKE = 'ON_EVENT_FRIEND_REVOKE'
    ON_EVENT_FRIEND_DELETE = 'ON_EVENT_FRIEND_DELETE'
    ON_EVENT_GROUP_SHUT = 'ON_EVENT_GROUP_SHUT'
    ON_EVENT_GROUP_ADMIN = 'ON_EVENT_GROUP_ADMIN'


# pylint: disable=non-ascii-name
class Emoticons:
    """表情"""
    k歌 = '[表情140]'
    爱你 = '[表情122]'
    爱情 = '[表情42]'
    爱心 = '[表情66]'
    傲慢 = '[表情23]'
    白眼 = '[表情22]'
    棒棒糖 = '[表情142]'
    抱拳 = '[表情118]'
    爆筋 = '[表情142]'
    鄙视 = '[表情105]'
    闭嘴 = '[表情7]'
    鞭炮 = '[表情137]'
    便便 = '[表情59]'
    不 = '[表情123]'
    搽汗 = '[表情97]'
    彩球 = '[表情164]'
    菜刀 = '[表情112]'
    差劲 = '[表情121]'
    钞票 = '[表情158]'
    车厢 = '[表情154]'
    呲牙 = '[表情13]'
    打伞 = '[表情163]'
    大兵 = '[表情29]'
    大哭 = '[表情9]'
    蛋糕 = '[表情53]'
    刀 = '[表情56]'
    得意 = '[表情4]'
    灯笼 = '[表情138]'
    灯泡 = '[表情160]'
    凋谢 = '[表情64]'
    多云 = '[表情156]'
    发财 = '[表情139]'
    发呆 = '[表情3]'
    发抖 = '[表情41]'
    发怒 = '[表情11]'
    饭 = '[表情61]'
    飞机 = '[表情151]'
    飞吻 = '[表情85]'
    奋斗 = '[表情30]'
    风车 = '[表情161]'
    尴尬 = '[表情10]'
    高铁右车头 = '[表情155]'
    高铁左车头 = '[表情153]'
    勾引 = '[表情119]'
    购物 = '[表情141]'
    鼓掌 = '[表情99]'
    哈欠 = '[表情104]'
    害羞 = '[表情6]'
    憨笑 = '[表情28]'
    好 = '[表情124]'
    喝彩 = '[表情144]'
    喝奶 = '[表情148]'
    坏笑 = '[表情101]'
    揉手 = '[表情129]'
    回头 = '[表情127]'
    饥饿 = '[表情24]'
    激动 = '[表情130]'
    街舞 = '[表情131]'
    惊恐 = '[表情26]'
    惊讶 = '[表情0]'
    咖啡 = '[表情60]'
    开车 = '[表情152]'
    磕头 = '[表情126]'
    可爱 = '[表情21]'
    可怜 = '[表情111]'
    抠鼻 = '[表情98]'
    骷髅 = '[表情37]'
    酷 = '[表情16]'
    快哭了 = '[表情107]'
    困 = '[表情25]'
    篮球 = '[表情114]'
    冷汗 = '[表情96]'
    礼物 = '[表情69]'
    流汗 = '[表情27]'
    流泪 = '[表情5]'
    玫瑰 = '[表情63]'
    难过 = '[表情15]'
    闹钟 = '[表情162]'
    怄火 = '[表情86]'
    啤酒 = '[表情113]'
    瓢虫 = '[表情117]'
    撇嘴 = '[表情1]'
    乒乓 = '[表情115]'
    祈祷 = '[表情145]'
    强 = '[表情76]'
    敲打 = '[表情38]'
    亲亲 = '[表情109]'
    青蛙 = '[表情170]'
    糗大了 = '[表情100]'
    拳头 = '[表情120]'
    弱 = '[表情77]'
    色 = '[表情2]'
    沙发 = '[表情166]'
    闪电 = '[表情54]'
    胜利 = '[表情79]'
    示爱 = '[表情110]'
    手枪 = '[表情169]'
    衰 = '[表情36]'
    帅 = '[表情143]'
    双喜 = '[表情136]'
    睡 = '[表情8]'
    太阳 = '[表情74]'
    调皮 = '[表情12]'
    跳绳 = '[表情128]'
    跳跳 = '[表情43]'
    偷笑 = '[表情20]'
    吐 = '[表情19]'
    微笑 = '[表情14]'
    委屈 = '[表情106]'
    握手 = '[表情78]'
    西瓜 = '[表情89]'
    下面 = '[表情149]'
    下雨 = '[表情157]'
    吓 = '[表情110]'
    献吻 = '[表情132]'
    香蕉 = '[表情150]'
    心碎 = '[表情67]'
    熊猫 = '[表情159]'
    药 = '[表情168]'
    疑问 = '[表情32]'
    阴险 = '[表情108]'
    拥抱 = '[表情49]'
    邮件 = '[表情142]'
    右哼哼 = '[表情103]'
    右太极 = '[表情134]'
    月亮 = '[表情75]'
    晕 = '[表情34]'
    再见 = '[表情39]'
    炸弹 = '[表情55]'
    折磨 = '[表情35]'
    纸巾 = '[表情167]'
    咒骂 = '[表情31]'
    猪头 = '[表情46]'
    抓狂 = '[表情18]'
    转圈 = '[表情125]'
    足球 = '[表情57]'
    钻戒 = '[表情165]'
    左哼哼 = '[表情102]'
    左太极 = '[表情133]'


def file_to_base64(path):
    with open(path, 'rb') as f:
        content = f.read()
    return base64.b64encode(content).decode()


def check_schema(url: str) -> str:
    url = url.strip('/')
    if not re.findall(r'(http://|https://)', url):
        return "http://" + url
    return url
