[![Publish ipay-python](https://github.com/Softech-Technologies/ipay/actions/workflows/publish.yaml/badge.svg?branch=main)](https://github.com/Softech-Technologies/ipay/actions/workflows/publish.yaml)  [![PyPI version](https://badge.fury.io/py/python-ipay.svg)](https://badge.fury.io/py/python-ipay) [![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT) [![codecov](https://codecov.io/gh/Softech-Technologies/ipay/branch/main/graph/badge.svg?token=ZQZQZQZQZQ)](https://codecov.io/gh/Softech-Technologies/ipay) [![Maintainability](https://api.codeclimate.com/v1/badges/4b0b0b0b0b0b0b0b0b0b/maintainability)](https://codeclimate.com/github/Softech-Technologies/ipay/maintainability) [![Test Coverage](https://api.codeclimate.com/v1/badges/4b0b0b0b0b0b0b0b0b0b/test_coverage)](https://codeclimate.com/github/Softech-Technologies/ipay/test_coverage) [![Documentation Status](https://readthedocs.org/projects/ipay/badge/?version=latest)](https://ipay.readthedocs.io/en/latest/?badge=latest) [![.github/workflows/pylint.yml](https://github.com/Softech-Technologies/ipay/actions/workflows/pylint.yml/badge.svg?branch=main)](https://github.com/Softech-Technologies/ipay/actions/workflows/pylint.yml)
# iPay Python SDK

<img src="https://www.ipayafrica.com/sites/default/files/logo-45-percent_01.svg" alt="ipay_logo" height="100" width="100">

[//]: # (![iPay Logo]&#40;https://www.ipayafrica.com/sites/default/files/logo-45-percent_01.svg&#41;)

The iPay Python SDK provides a comprehensive set of tools for interacting with the iPay API, making it easier to integrate iPay payment functionality into your Python applications.

## Description

This SDK simplifies the process of initiating payments, querying transaction status, and handling various iPay functionalities. It includes classes and methods for working with different iPay data models, making it convenient for developers to integrate iPay into their projects.

## Table of Contents

- [Installation](#installation)
- [Usage](#usage)
- [Configuration](#configuration)
- [Contribution](#contribution)
- [License](#license)

## Installation

Install the iPay Python SDK using pip:

```bash
pip install python-ipay
```

## Usage

### Importing the SDK

Import the SDK into your project:

```python
from ipay import Ipay
```

### Initializing the service 
```python
c2b = C2B()
```

### C2B
```python
from ipay import C2B
from ipay import IPayDataV1

c2b = C2B()
i_pay_data = IPayDataV1(
         live=0,
         oid="123456789",
         inv="123456789",
         amount=100,
         tel="254712345678",
         eml="johndoe@email.com",
         vid="demo",
         curr="KES",
         cst=1,
         cbk="http://localhost:8000/api/v1/ipn",
         crl=0,
         hash_value="",
         auto_pay=1
     )
c2b.initiate_payment(i_pay_data)

```

### C2BV2
```python
from ipay import C2BV2
from ipay import IPayDataV2

c2b = C2BV2()
i_pay_data = IPayDataV2(
         live=0,
         oid="123456789",
         inv="123456789",
         amount=100,
         tel="254712345678",
         eml="johndoe@email.com",
         vid="demo",
         curr="KES",
         cst=1,
         cbk="http://localhost:8000/api/v1/ipn",
         crl=0,
         hash_value="",
         auto_pay=1,
         p1="",
         p2="",
         p3="",
         p4="",
         cst="",
         crl="",
         hsh="",
         secret_key="demoCHANHED",
         )
link = c2b.initiate_payment(i_pay_data)["link"]
```
            

### Configuration
You can set the following environment variables to configure the SDK:

- `i_pay_secret`: Your iPay vendor secret key.

## Contribution

Contributions are welcome! If you would like to contribute to the development of this SDK, please follow the guidelines in [CONTRIBUTING.md](https://github.com/Softech-Technologies/ipay/blob/dev/CONTRIBUTING.md). You can also contribute by reporting a bug or suggesting a feature you would like to see.

## License
This SDK is licensed under the [MIT License](https://github.com/Softech-Technologies/ipay/blob/dev/LICENSE) - see the LICENSE file for details.



