from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.0.2'
DESCRIPTION = 'Python Library for starting and managing simulations in the Intelligent Quads Cloud'
LONG_DESCRIPTION = 'Python Library for starting and managing simulations in the Intelligent Quads Cloud'

# Setting up
setup(
    name="python-iq-sim",
    version=VERSION,
    author="Eric Johnson",
    author_email="",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=['requests'],
    keywords=['python', 'sim', 'cloud', 'mavlink', 'ardupilot', 'px4'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)