class Basket(object):
    def __init__(self, data):
        self.amount = len(data.get('items'))
        self.price_currency = data.get("prices").get("total").get("currency")
        self.price_amount = data.get("prices").get("total").get("amount")

    @property
    def price(self):
        return self.price_currency + " " + str(self.price_amount / 100)

    def __str__(self):
        return f"{self.amount} {self.price_currency} {self.price_amount} {self.price}"
