# coding: utf-8

"""
ApisextensionsvbetaApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ApisextensionsvbetaApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient('https://10.10.10.10:443/')
            self.api_client = config.api_client

    def get_api_resources(self, **kwargs):
        """
        get available resources
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_api_resources(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_resources" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json', 'application/yaml'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_daemon_set(self, **kwargs):
        """
        list or watch objects of kind DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_daemon_set(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1DaemonSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/daemonsets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1DaemonSetList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_deployment(self, **kwargs):
        """
        list or watch objects of kind Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_deployment(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1DeploymentList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/deployments'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1DeploymentList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_horizontal_pod_autoscaler(self, **kwargs):
        """
        list or watch objects of kind HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_horizontal_pod_autoscaler(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1HorizontalPodAutoscalerList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_horizontal_pod_autoscaler" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/horizontalpodautoscalers'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1HorizontalPodAutoscalerList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_ingress(self, **kwargs):
        """
        list or watch objects of kind Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_ingress(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1IngressList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_ingress" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/ingresses'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1IngressList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_job(self, **kwargs):
        """
        list or watch objects of kind Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_job(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1JobList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_job" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/jobs'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1JobList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_daemon_set(self, namespace, **kwargs):
        """
        list or watch objects of kind DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_daemon_set(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1DaemonSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_daemon_set`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1DaemonSetList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_daemon_set(self, body, namespace, **kwargs):
        """
        create a DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_daemon_set(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1DaemonSet body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_daemon_set`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_daemon_set`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1DaemonSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_daemon_set(self, namespace, **kwargs):
        """
        delete collection of DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_daemon_set(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_daemon_set`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_daemon_set(self, namespace, name, **kwargs):
        """
        read the specified DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_daemon_set(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the DaemonSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_daemon_set`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_daemon_set`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1DaemonSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_daemon_set(self, body, namespace, name, **kwargs):
        """
        replace the specified DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_daemon_set(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1DaemonSet body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the DaemonSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_daemon_set`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_daemon_set`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_daemon_set`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1DaemonSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_daemon_set(self, body, namespace, name, **kwargs):
        """
        delete a DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_daemon_set(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the DaemonSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_daemon_set`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_daemon_set`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_daemon_set`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_daemon_set(self, body, namespace, name, **kwargs):
        """
        partially update the specified DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_daemon_set(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the DaemonSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_daemon_set`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_daemon_set`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_daemon_set`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1DaemonSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_daemon_set_status(self, body, namespace, name, **kwargs):
        """
        replace status of the specified DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_daemon_set_status(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1DaemonSet body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the DaemonSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_daemon_set_status`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_daemon_set_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_daemon_set_status`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_daemon_set_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1DaemonSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_deployment(self, namespace, **kwargs):
        """
        list or watch objects of kind Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_deployment(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1DeploymentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_deployment`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1DeploymentList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_deployment(self, body, namespace, **kwargs):
        """
        create a Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_deployment(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Deployment body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_deployment`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_deployment`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Deployment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_deployment(self, namespace, **kwargs):
        """
        delete collection of Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_deployment(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_deployment`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_deployment(self, namespace, name, **kwargs):
        """
        read the specified Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_deployment(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Deployment (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_deployment`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_deployment`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Deployment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_deployment(self, body, namespace, name, **kwargs):
        """
        replace the specified Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_deployment(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Deployment body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Deployment (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_deployment`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_deployment`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_deployment`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Deployment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_deployment(self, body, namespace, name, **kwargs):
        """
        delete a Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_deployment(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Deployment (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_deployment`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_deployment`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_deployment`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_deployment(self, body, namespace, name, **kwargs):
        """
        partially update the specified Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_deployment(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Deployment (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_deployment`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_deployment`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_deployment`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Deployment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_deployment_rollback_rollback(self, body, namespace, name, **kwargs):
        """
        create rollback of a DeploymentRollback
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_deployment_rollback_rollback(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1DeploymentRollback body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the DeploymentRollback (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DeploymentRollback
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_deployment_rollback_rollback`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_deployment_rollback_rollback`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `create_namespaced_deployment_rollback_rollback`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_deployment_rollback_rollback" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/rollback'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1DeploymentRollback',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_scale_scale(self, namespace, name, **kwargs):
        """
        read scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_scale_scale(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_scale_scale`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_scale_scale`")

        all_params = ['namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_scale_scale" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/scale'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_scale_scale(self, body, namespace, name, **kwargs):
        """
        replace scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_scale_scale(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Scale body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_scale_scale`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_scale_scale`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_scale_scale`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_scale_scale" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/scale'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_scale_scale(self, body, namespace, name, **kwargs):
        """
        partially update scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_scale_scale(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_scale_scale`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_scale_scale`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_scale_scale`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_scale_scale" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/scale'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_deployment_status(self, body, namespace, name, **kwargs):
        """
        replace status of the specified Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_deployment_status(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Deployment body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Deployment (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_deployment_status`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_deployment_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_deployment_status`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_deployment_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Deployment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_horizontal_pod_autoscaler(self, namespace, **kwargs):
        """
        list or watch objects of kind HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_horizontal_pod_autoscaler(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1HorizontalPodAutoscalerList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_horizontal_pod_autoscaler`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_horizontal_pod_autoscaler" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/horizontalpodautoscalers'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1HorizontalPodAutoscalerList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_horizontal_pod_autoscaler(self, body, namespace, **kwargs):
        """
        create a HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_horizontal_pod_autoscaler(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1HorizontalPodAutoscaler body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1HorizontalPodAutoscaler
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_horizontal_pod_autoscaler`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_horizontal_pod_autoscaler`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_horizontal_pod_autoscaler" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/horizontalpodautoscalers'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1HorizontalPodAutoscaler',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_horizontal_pod_autoscaler(self, namespace, **kwargs):
        """
        delete collection of HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_horizontal_pod_autoscaler(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_horizontal_pod_autoscaler`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_horizontal_pod_autoscaler" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/horizontalpodautoscalers'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_horizontal_pod_autoscaler(self, namespace, name, **kwargs):
        """
        read the specified HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_horizontal_pod_autoscaler(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the HorizontalPodAutoscaler (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1beta1HorizontalPodAutoscaler
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_horizontal_pod_autoscaler`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_horizontal_pod_autoscaler`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_horizontal_pod_autoscaler" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/horizontalpodautoscalers/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1HorizontalPodAutoscaler',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_horizontal_pod_autoscaler(self, body, namespace, name, **kwargs):
        """
        replace the specified HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_horizontal_pod_autoscaler(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1HorizontalPodAutoscaler body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the HorizontalPodAutoscaler (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1HorizontalPodAutoscaler
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_horizontal_pod_autoscaler`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_horizontal_pod_autoscaler`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_horizontal_pod_autoscaler`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_horizontal_pod_autoscaler" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/horizontalpodautoscalers/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1HorizontalPodAutoscaler',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_horizontal_pod_autoscaler(self, body, namespace, name, **kwargs):
        """
        delete a HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_horizontal_pod_autoscaler(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the HorizontalPodAutoscaler (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_horizontal_pod_autoscaler`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_horizontal_pod_autoscaler`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_horizontal_pod_autoscaler`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_horizontal_pod_autoscaler" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/horizontalpodautoscalers/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_horizontal_pod_autoscaler(self, body, namespace, name, **kwargs):
        """
        partially update the specified HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_horizontal_pod_autoscaler(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the HorizontalPodAutoscaler (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1HorizontalPodAutoscaler
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_horizontal_pod_autoscaler`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_horizontal_pod_autoscaler`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_horizontal_pod_autoscaler`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_horizontal_pod_autoscaler" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/horizontalpodautoscalers/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1HorizontalPodAutoscaler',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_horizontal_pod_autoscaler_status(self, body, namespace, name, **kwargs):
        """
        replace status of the specified HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_horizontal_pod_autoscaler_status(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1HorizontalPodAutoscaler body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the HorizontalPodAutoscaler (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1HorizontalPodAutoscaler
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_horizontal_pod_autoscaler_status`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_horizontal_pod_autoscaler_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_horizontal_pod_autoscaler_status`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_horizontal_pod_autoscaler_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1HorizontalPodAutoscaler',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_ingress(self, namespace, **kwargs):
        """
        list or watch objects of kind Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_ingress(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1IngressList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_ingress`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1IngressList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_ingress(self, body, namespace, **kwargs):
        """
        create a Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_ingress(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Ingress body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_ingress`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_ingress`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Ingress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_ingress(self, namespace, **kwargs):
        """
        delete collection of Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_ingress(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_ingress`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_ingress(self, namespace, name, **kwargs):
        """
        read the specified Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_ingress(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Ingress (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_ingress`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_ingress`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Ingress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_ingress(self, body, namespace, name, **kwargs):
        """
        replace the specified Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_ingress(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Ingress body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Ingress (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_ingress`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_ingress`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_ingress`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Ingress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_ingress(self, body, namespace, name, **kwargs):
        """
        delete a Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_ingress(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Ingress (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_ingress`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_ingress`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_ingress`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_ingress(self, body, namespace, name, **kwargs):
        """
        partially update the specified Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_ingress(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Ingress (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_ingress`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_ingress`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_ingress`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Ingress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_ingress_status(self, body, namespace, name, **kwargs):
        """
        replace status of the specified Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_ingress_status(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Ingress body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Ingress (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_ingress_status`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_ingress_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_ingress_status`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_ingress_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Ingress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_job(self, namespace, **kwargs):
        """
        list or watch objects of kind Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_job(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1JobList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_job`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_job" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/jobs'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1JobList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_job(self, body, namespace, **kwargs):
        """
        create a Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_job(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Job body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_job`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_job`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_job" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/jobs'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Job',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_job(self, namespace, **kwargs):
        """
        delete collection of Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_job(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_job`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_job" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/jobs'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_job(self, namespace, name, **kwargs):
        """
        read the specified Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_job(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Job (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1beta1Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_job`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_job`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_job" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/jobs/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Job',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_job(self, body, namespace, name, **kwargs):
        """
        replace the specified Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_job(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Job body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Job (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_job`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_job`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_job`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_job" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/jobs/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Job',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_job(self, body, namespace, name, **kwargs):
        """
        delete a Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_job(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Job (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_job`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_job`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_job`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_job" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/jobs/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_job(self, body, namespace, name, **kwargs):
        """
        partially update the specified Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_job(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Job (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_job`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_job`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_job`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_job" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/jobs/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Job',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_job_status(self, body, namespace, name, **kwargs):
        """
        replace status of the specified Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_job_status(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Job body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Job (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_job_status`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_job_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_job_status`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_job_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/jobs/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Job',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_replica_set(self, namespace, **kwargs):
        """
        list or watch objects of kind ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_replica_set(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1ReplicaSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_replica_set`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1ReplicaSetList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_replica_set(self, body, namespace, **kwargs):
        """
        create a ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_replica_set(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1ReplicaSet body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_replica_set`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_replica_set`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1ReplicaSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_replica_set(self, namespace, **kwargs):
        """
        delete collection of ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_replica_set(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_replica_set`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_replica_set(self, namespace, name, **kwargs):
        """
        read the specified ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_replica_set(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicaSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_replica_set`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_replica_set`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1ReplicaSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_replica_set(self, body, namespace, name, **kwargs):
        """
        replace the specified ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replica_set(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1ReplicaSet body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicaSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_replica_set`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_replica_set`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_replica_set`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1ReplicaSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_replica_set(self, body, namespace, name, **kwargs):
        """
        delete a ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_replica_set(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicaSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_replica_set`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_replica_set`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_replica_set`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_replica_set(self, body, namespace, name, **kwargs):
        """
        partially update the specified ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_replica_set(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicaSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_replica_set`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_replica_set`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_replica_set`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1ReplicaSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_scale_scale_1(self, namespace, name, **kwargs):
        """
        read scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_scale_scale_1(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_scale_scale_1`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_scale_scale_1`")

        all_params = ['namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_scale_scale_1" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/scale'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_scale_scale_2(self, body, namespace, name, **kwargs):
        """
        replace scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_scale_scale_2(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Scale body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_scale_scale_2`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_scale_scale_2`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_scale_scale_2`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_scale_scale_2" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/scale'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_scale_scale_3(self, body, namespace, name, **kwargs):
        """
        partially update scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_scale_scale_3(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_scale_scale_3`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_scale_scale_3`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_scale_scale_3`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_scale_scale_3" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/scale'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_replica_set_status(self, body, namespace, name, **kwargs):
        """
        replace status of the specified ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replica_set_status(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1ReplicaSet body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicaSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_replica_set_status`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_replica_set_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_replica_set_status`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_replica_set_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1ReplicaSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_scale_scale_4(self, namespace, name, **kwargs):
        """
        read scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_scale_scale_4(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_scale_scale_4`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_scale_scale_4`")

        all_params = ['namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_scale_scale_4" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicationcontrollers/{name}/scale'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_scale_scale_5(self, body, namespace, name, **kwargs):
        """
        replace scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_scale_scale_5(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1Scale body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_scale_scale_5`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_scale_scale_5`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_scale_scale_5`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_scale_scale_5" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicationcontrollers/{name}/scale'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_scale_scale_6(self, body, namespace, name, **kwargs):
        """
        partially update scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_scale_scale_6(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_scale_scale_6`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_scale_scale_6`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_scale_scale_6`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_scale_scale_6" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicationcontrollers/{name}/scale'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_replica_set(self, **kwargs):
        """
        list or watch objects of kind ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_replica_set(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1beta1ReplicaSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_replica_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/replicasets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1beta1ReplicaSetList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_daemon_set_list(self, **kwargs):
        """
        watch individual changes to a list of DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_daemon_set_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_daemon_set_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/daemonsets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_deployment_list(self, **kwargs):
        """
        watch individual changes to a list of Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_deployment_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_deployment_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/deployments'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_horizontal_pod_autoscaler_list(self, **kwargs):
        """
        watch individual changes to a list of HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_horizontal_pod_autoscaler_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_horizontal_pod_autoscaler_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/horizontalpodautoscalers'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_ingress_list(self, **kwargs):
        """
        watch individual changes to a list of Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_ingress_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_ingress_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/ingresses'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_job_list(self, **kwargs):
        """
        watch individual changes to a list of Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_job_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_job_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/jobs'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_daemon_set_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_daemon_set_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_daemon_set_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_daemon_set_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/daemonsets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_daemon_set(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind DaemonSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_daemon_set(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the DaemonSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_daemon_set`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_daemon_set`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/daemonsets/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_deployment_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_deployment_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_deployment_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_deployment_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/deployments'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_deployment(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind Deployment
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_deployment(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Deployment (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_deployment`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_deployment`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/deployments/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_horizontal_pod_autoscaler_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_horizontal_pod_autoscaler_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_horizontal_pod_autoscaler_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_horizontal_pod_autoscaler_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/horizontalpodautoscalers'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_horizontal_pod_autoscaler(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind HorizontalPodAutoscaler
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_horizontal_pod_autoscaler(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the HorizontalPodAutoscaler (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_horizontal_pod_autoscaler`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_horizontal_pod_autoscaler`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_horizontal_pod_autoscaler" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/horizontalpodautoscalers/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_ingress_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_ingress_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_ingress_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_ingress_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/ingresses'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_ingress(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind Ingress
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_ingress(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Ingress (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_ingress`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_ingress`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/ingresses/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_job_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_job_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_job_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_job_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/jobs'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_job(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind Job
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_job(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Job (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_job`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_job`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_job" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/jobs/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_replica_set_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_replica_set_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_replica_set_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_replica_set_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/replicasets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_replica_set(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_replica_set(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicaSet (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_replica_set`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_replica_set`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/namespaces/{namespace}/replicasets/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_replica_set_list(self, **kwargs):
        """
        watch individual changes to a list of ReplicaSet
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_replica_set_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_replica_set_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/apis/extensions/v1beta1/watch/replicasets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
