use std::{env, path::PathBuf};

fn main() {
    let deps = system_deps::Config::new().probe().unwrap();

    let mut builder = bindgen::builder()
        .header("src/wrapper.h")
        .allowlist_type("(_|)kadm5.*")
        .allowlist_function("kadm5.*")
        .allowlist_var("KADM5_.*")
        .allowlist_var("KRB5_NT_SRV_HST")
        .allowlist_var("KRB5_OK")
        .allowlist_var("ENCTYPE_.*")
        .allowlist_var("KRB5_KDB_SALTTYPE_.*")
        .allowlist_function("krb5_init_context")
        .allowlist_function("krb5_free_context")
        .allowlist_function("krb5_get_error_message")
        .allowlist_function("krb5_free_error_message")
        .allowlist_function("krb5_parse_name")
        .allowlist_function("krb5_sname_to_principal")
        .allowlist_function("krb5_free_principal")
        .allowlist_function("krb5_unparse_name")
        .allowlist_function("krb5_free_unparsed_name")
        .allowlist_function("krb5_cc_get_principal")
        .allowlist_function("krb5_cc_default")
        .allowlist_function("krb5_cc_resolve")
        .allowlist_function("krb5_cc_close")
        .allowlist_function("krb5_get_default_realm")
        .allowlist_function("krb5_free_default_realm")
        .allowlist_function("krb5_string_to_enctype")
        .allowlist_function("krb5_string_to_salttype")
        .allowlist_function("krb5_enctype_to_string")
        .allowlist_function("krb5_salttype_to_string")
        .clang_arg("-fparse-all-comments")
        .derive_default(true)
        .generate_cstr(true)
        .parse_callbacks(Box::new(bindgen::CargoCallbacks::new()));

    for include_path in deps.all_include_paths() {
        builder = builder.clang_arg(format!("-I{}", include_path.display()));
    }

    let bindings = builder.generate().expect("Unable to generate bindings");

    let out_path = PathBuf::from(env::var("OUT_DIR").unwrap());
    bindings
        .write_to_file(out_path.join("bindings.rs"))
        .expect("Couldn't write bindings!");
}
