import datetime
from typing import Self, final
from typing_extensions import disjoint_base

__version__: str
exceptions: object
sys: object

@final
class KAdminApiVersion:
    Version2: Self
    Version3: Self
    Version4: Self

@final
class KAdm5Variant:
    MitClient: Self
    MitServer: Self
    HeimdalClient: Self
    HeimdalServer: Self

@final
class KAdmin:
    def add_principal(self, name, **kwargs) -> Principal: ...
    def rename_principal(self, old_name: str, new_name: str): ...
    def delete_principal(self, name: str): ...
    def get_principal(self, name: str) -> Principal | None: ...
    def principal_exists(self, name: str) -> bool: ...
    def principal_change_password(
        self,
        name: str,
        password: str,
        keepold: bool | None = None,
        keysalts: KeySalts | None = None,
    ): ...
    def principal_randkey(
        self,
        name: str,
        keepold: bool | None = None,
        keysalts: KeySalts | None = None,
    ): ...
    def principal_get_strings(self, name: str) -> dict[str, str]: ...
    def principal_set_string(self, name: str, key: str, value: str | None): ...
    def list_principals(self, query: str | None = None) -> list[str]: ...
    def add_policy(self, name: str, **kwargs) -> Policy: ...
    def delete_policy(self, name: str) -> None: ...
    def get_policy(self, name: str) -> Policy | None: ...
    def policy_exists(self, name: str) -> bool: ...
    def list_policies(self, query: str | None = None) -> list[str]: ...
    def get_privileges(self) -> int: ...
    @staticmethod
    def with_password(
        variant: KAdm5Variant,
        client_name: str,
        password: str,
        params: Params | None = None,
        db_args: DbArgs | None = None,
        api_version: KAdminApiVersion | None = None,
        library_path: str | None = None,
    ) -> KAdmin: ...
    @staticmethod
    def with_keytab(
        variant: KAdm5Variant,
        client_name: str | None = None,
        keytab: str | None = None,
        params: Params | None = None,
        db_args: DbArgs | None = None,
        api_version: KAdminApiVersion | None = None,
        library_path: str | None = None,
    ) -> KAdmin: ...
    @staticmethod
    def with_ccache(
        variant: KAdm5Variant,
        client_name: str | None = None,
        ccache_name: str | None = None,
        params: Params | None = None,
        db_args: DbArgs | None = None,
        api_version: KAdminApiVersion | None = None,
        library_path: str | None = None,
    ) -> KAdmin: ...
    @staticmethod
    def with_anonymous(
        variant: KAdm5Variant,
        client_name: str,
        params: Params | None = None,
        db_args: DbArgs | None = None,
        api_version: KAdminApiVersion | None = None,
        library_path: str | None = None,
    ) -> KAdmin: ...
    @staticmethod
    def with_local(
        variant: KAdm5Variant,
        params: Params | None = None,
        db_args: DbArgs | None = None,
        api_version: KAdminApiVersion | None = None,
        library_path: str | None = None,
    ) -> KAdmin: ...

@final
class Principal:
    name: str
    expire_time: datetime.datetime | None
    last_password_change: datetime.datetime | None
    password_expiration: datetime.datetime | None
    max_life: datetime.timedelta | None
    modified_by: str
    modified_at: datetime.datetime | None
    attributes: int
    kvno: int
    mkvno: int
    policy: str | None
    aux_attributes: int
    max_renewable_life: datetime.timedelta | None
    last_success: datetime.datetime | None
    last_failed: datetime.datetime | None
    fail_auth_count: int
    tl_data: TlData

    def modify(self, kadmin: KAdmin, **kwargs) -> Policy: ...
    def delete(self, kadmin: KAdmin): ...
    def change_password(
        self,
        kadmin: KAdmin,
        password: str,
        keepold: bool | None = None,
        keysalts: KeySalts | None = None,
    ): ...
    def randkey(
        self,
        kadmin: KAdmin,
        keepold: bool | None = None,
        keysalts: KeySalts | None = None,
    ): ...
    def unlock(self, kadmin: KAdmin): ...
    def get_strings(self, kadmin: KAdmin) -> dict[str, str]: ...
    def set_string(self, kadmin: KAdmin, key: str, value: str | None): ...

@disjoint_base
class NewPrincipalKey:
    @final
    class Password(NewPrincipalKey):
        __match_args__: tuple
        def __new__(cls, _0: str): ...

    @final
    class NoKey(NewPrincipalKey):
        __match_args__: tuple
        def __init__(self): ...

    @final
    class RandKey(NewPrincipalKey):
        __match_args__: tuple
        def __init__(self): ...

    @final
    class ServerRandKey(NewPrincipalKey):
        __match_args__: tuple
        def __init__(self): ...

    @final
    class OldStyleRandKey(NewPrincipalKey):
        __match_args__: tuple
        def __init__(self): ...

@final
class Policy:
    name: str
    password_min_life: datetime.timedelta | None
    password_max_life: datetime.timedelta | None
    password_min_length: int
    password_min_classes: int
    password_history_num: int
    policy_refcnt: int
    password_max_fail: int
    password_failcount_interval: datetime.timedelta | None
    password_lockout_duration: datetime.timedelta | None
    attributes: int
    max_life: datetime.timedelta | None
    max_renewable_life: datetime.timedelta | None
    allowed_keysalts: KeySalts | None
    tl_data: TlData

    def modify(self, kadmin: KAdmin, **kwargs) -> Policy: ...
    def delete(self, kadmin: KAdmin) -> None: ...

@final
class Params:
    def __new__(
        cls,
        realm: str | None = None,
        kadmind_port: int | None = None,
        kpasswd_port: int | None = None,
        admin_server: str | None = None,
        dbname: str | None = None,
        acl_file: str | None = None,
        dict_file: str | None = None,
        stash_file: str | None = None,
    ): ...

@final
class DbArgs:
    def __new__(cls, /, *args, **kwargs: str | None): ...

@final
class EncryptionType:
    def __new__(cls, enctype: int): ...

@final
class SaltType:
    def __new__(cls, salttype: int | None = None): ...

@final
class KeySalt:
    enctype: EncryptionType
    salttype: SaltType

    def __new__(cls, enctype: EncryptionType, salttype: SaltType | None = None): ...

@final
class KeySalts:
    keysalts: set[KeySalt]

    def __new__(cls, keysalts: set[KeySalt]): ...

@final
class TlDataEntry:
    data_type: int
    contents: list[int]

    def __new__(cls, data_type: int, contents: list[int]): ...

@final
class TlData:
    entries: list[TlDataEntry]

    def __new__(cls, entries: list[TlDataEntry]): ...

__all__ = [
    "DbArgs",
    "EncryptionType",
    "KAdmin",
    "KAdminApiVersion",
    "KAdm5Variant",
    "KeySalt",
    "KeySalts",
    "NewPrincipalKey",
    "Params",
    "Policy",
    "Principal",
    "SaltType",
    "TlData",
    "TlDataEntry",
    "__version__",
    "exceptions",
    "sys",
]
