# API Reference

## Discover


```{module} kasa
```

```{eval-rst}
.. autoclass:: Discover
    :members:
```

## Device


```{eval-rst}
.. autoclass:: Device
    :members:
    :undoc-members:
```


## Device Config


```{eval-rst}
.. autoclass:: Credentials
    :members:
    :undoc-members:
    :noindex:
```


```{eval-rst}
.. autoclass:: DeviceConfig
    :members:
    :undoc-members:
```


```{eval-rst}
.. autoclass:: DeviceFamily
    :members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: DeviceConnectionParameters
    :members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: DeviceEncryptionType
    :members:
    :undoc-members:
```

## Modules and Features

```{eval-rst}
.. autoclass:: Module
    :noindex:
    :members:
    :inherited-members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: Feature
    :noindex:
    :members:
    :inherited-members:
    :undoc-members:
```

```{eval-rst}
.. automodule:: kasa.interfaces
    :noindex:
    :members:
    :inherited-members:
    :undoc-members:
```

## Protocols and transports

```{eval-rst}
.. autoclass:: kasa.protocol.BaseProtocol
    :members:
    :inherited-members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: kasa.iotprotocol.IotProtocol
    :members:
    :inherited-members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: kasa.smartprotocol.SmartProtocol
    :members:
    :inherited-members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: kasa.protocol.BaseTransport
    :members:
    :inherited-members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: kasa.xortransport.XorTransport
    :members:
    :inherited-members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: kasa.klaptransport.KlapTransport
    :members:
    :inherited-members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: kasa.klaptransport.KlapTransportV2
    :members:
    :inherited-members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: kasa.aestransport.AesTransport
    :members:
    :inherited-members:
    :undoc-members:
```

## Errors and exceptions

```{eval-rst}
.. autoclass:: kasa.exceptions.KasaException
    :members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: kasa.exceptions.DeviceError
    :members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: kasa.exceptions.AuthenticationError
    :members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: kasa.exceptions.UnsupportedDeviceError
    :members:
    :undoc-members:
```

```{eval-rst}
.. autoclass:: kasa.exceptions.TimeoutError
    :members:
    :undoc-members:
