from collections import OrderedDict

try:
    import unittest.mock as mock
except ImportError:
    import mock

patch = mock.patch
from nose.tools import assert_equal
from python_kemptech_api.client import LoadMaster


class Test_build_virtual_service:
    def __init__(self):
        """
        Layout of the test XML, starting with 2 top level VSs
        VS - subVS - real server
           |       \ real server
            \subVS

        VS - subVS
        """

    def test_build_virtual_service_with_top_level_vs(self):
        list_vs_response = """<?xml version="1.0" encoding="ISO-8859-1"?> <Response stat="200" code="ok"> <Success><Data><VS> <Status>Down</Status> <Index>2</Index> <VSAddress>10.154.0.11</VSAddress> <VSPort>80</VSPort> <Enable>Y</Enable> <SSLReverse>N</SSLReverse> <SSLReencrypt>N</SSLReencrypt> <Intercept>N</Intercept> <InterceptOpts><Opt>opnormal</Opt> <Opt>auditrelevant</Opt> <Opt>reqdatadisable</Opt> <Opt>resdatadisable</Opt> </InterceptOpts><AlertThreshold>0</AlertThreshold> <Transactionlimit>0</Transactionlimit> <Transparent>Y</Transparent> <SubnetOriginating>N</SubnetOriginating> <ServerInit>0</ServerInit> <StartTLSMode>0</StartTLSMode> <Idletime>0</Idletime> <Cache>N</Cache> <Compress>N</Compress> <Verify>0</Verify> <UseforSnat>N</UseforSnat> <ForceL7>Y</ForceL7> <MultiConnect>N</MultiConnect> <ClientCert>0</ClientCert> <ErrorCode>0</ErrorCode> <CheckUse1.1>N</CheckUse1.1> <MatchLen>0</MatchLen> <CheckUseGet>0</CheckUseGet> <SSLRewrite>0</SSLRewrite> <VStype>http</VStype> <FollowVSID>0</FollowVSID> <Protocol>tcp</Protocol> <Schedule>rr</Schedule> <CheckType>http</CheckType> <PersistTimeout>0</PersistTimeout> <CheckPort>0</CheckPort> <NRules>0</NRules> <NRequestRules>0</NRequestRules> <NResponseRules>0</NResponseRules> <NPreProcessRules>0</NPreProcessRules> <EspEnabled>N</EspEnabled> <InputAuthMode>0</InputAuthMode> <OutputAuthMode>0</OutputAuthMode> <MasterVS>2</MasterVS> <MasterVSID>0</MasterVSID> <AddVia>0</AddVia> <QoS>0</QoS> <TlsType>0</TlsType> <NeedHostName>N</NeedHostName> <OCSPVerify>N</OCSPVerify> <RsMinimum>0</RsMinimum> <NumberOfRSs>2</NumberOfRSs> <SubVS> <Status>Down</Status> <VSIndex>6</VSIndex> <RsIndex>5</RsIndex> <Name>-</Name> <Forward>nat</Forward> <Weight>1000</Weight> <Limit>0</Limit> <Enable>Y</Enable> <Critical>N</Critical> </SubVS> <SubVS> <Status>Down</Status> <VSIndex>7</VSIndex> <RsIndex>6</RsIndex> <Name>-</Name> <Forward>nat</Forward> <Weight>1000</Weight> <Limit>0</Limit> <Enable>Y</Enable> <Critical>N</Critical> </SubVS> </VS> <VS> <Status>Down</Status> <Index>3</Index> <VSAddress>10.154.0.12</VSAddress> <VSPort>80</VSPort> <Enable>Y</Enable> <SSLReverse>N</SSLReverse> <SSLReencrypt>N</SSLReencrypt> <Intercept>N</Intercept> <InterceptOpts><Opt>opnormal</Opt> <Opt>auditrelevant</Opt> <Opt>reqdatadisable</Opt> <Opt>resdatadisable</Opt> </InterceptOpts><AlertThreshold>0</AlertThreshold> <Transactionlimit>0</Transactionlimit> <Transparent>Y</Transparent> <SubnetOriginating>N</SubnetOriginating> <ServerInit>0</ServerInit> <StartTLSMode>0</StartTLSMode> <Idletime>0</Idletime> <Cache>N</Cache> <Compress>N</Compress> <Verify>0</Verify> <UseforSnat>N</UseforSnat> <ForceL7>Y</ForceL7> <MultiConnect>N</MultiConnect> <ClientCert>0</ClientCert> <ErrorCode>0</ErrorCode> <CheckUse1.1>N</CheckUse1.1> <MatchLen>0</MatchLen> <CheckUseGet>0</CheckUseGet> <SSLRewrite>0</SSLRewrite> <VStype>http</VStype> <FollowVSID>0</FollowVSID> <Protocol>tcp</Protocol> <Schedule>rr</Schedule> <CheckType>http</CheckType> <PersistTimeout>0</PersistTimeout> <CheckPort>0</CheckPort> <NRules>0</NRules> <NRequestRules>0</NRequestRules> <NResponseRules>0</NResponseRules> <NPreProcessRules>0</NPreProcessRules> <EspEnabled>N</EspEnabled> <InputAuthMode>0</InputAuthMode> <OutputAuthMode>0</OutputAuthMode> <MasterVS>1</MasterVS> <MasterVSID>0</MasterVSID> <AddVia>0</AddVia> <QoS>0</QoS> <TlsType>0</TlsType> <NeedHostName>N</NeedHostName> <OCSPVerify>N</OCSPVerify> <RsMinimum>0</RsMinimum> <NumberOfRSs>1</NumberOfRSs> <SubVS> <Status>Down</Status> <VSIndex>8</VSIndex> <RsIndex>9</RsIndex> <Name>-</Name> <Forward>nat</Forward> <Weight>1000</Weight> <Limit>0</Limit> <Enable>Y</Enable> <Critical>N</Critical> </SubVS> </VS> <VS> <Status>Down</Status> <Index>8</Index> <VSPort>0</VSPort> <Enable>Y</Enable> <SSLReverse>N</SSLReverse> <SSLReencrypt>N</SSLReencrypt> <Intercept>N</Intercept> <InterceptOpts><Opt>opnormal</Opt> <Opt>auditnone</Opt> <Opt>reqdatadisable</Opt> <Opt>resdatadisable</Opt> </InterceptOpts><AlertThreshold>0</AlertThreshold> <Transactionlimit>0</Transactionlimit> <Transparent>Y</Transparent> <SubnetOriginating>N</SubnetOriginating> <ServerInit>0</ServerInit> <StartTLSMode>0</StartTLSMode> <Idletime>0</Idletime> <Cache>N</Cache> <Compress>N</Compress> <Verify>0</Verify> <UseforSnat>N</UseforSnat> <ForceL7>Y</ForceL7> <MultiConnect>N</MultiConnect> <ClientCert>0</ClientCert> <ErrorCode>0</ErrorCode> <CheckUse1.1>N</CheckUse1.1> <MatchLen>0</MatchLen> <CheckUseGet>0</CheckUseGet> <SSLRewrite>0</SSLRewrite> <VStype>http</VStype> <FollowVSID>0</FollowVSID> <Protocol>tcp</Protocol> <Schedule>rr</Schedule> <CheckType>http</CheckType> <PersistTimeout>0</PersistTimeout> <CheckPort>0</CheckPort> <NRules>0</NRules> <NRequestRules>0</NRequestRules> <NResponseRules>0</NResponseRules> <NPreProcessRules>0</NPreProcessRules> <EspEnabled>N</EspEnabled> <InputAuthMode>0</InputAuthMode> <OutputAuthMode>0</OutputAuthMode> <MasterVS>0</MasterVS> <MasterVSID>3</MasterVSID> <AddVia>0</AddVia> <QoS>0</QoS> <TlsType>0</TlsType> <NeedHostName>N</NeedHostName> <OCSPVerify>N</OCSPVerify> <EnhancedHealthChecks>N</EnhancedHealthChecks> <RsMinimum>0</RsMinimum> <NumberOfRSs>0</NumberOfRSs> </VS> <VS> <Status>Down</Status> <Index>7</Index> <VSPort>0</VSPort> <Enable>Y</Enable> <SSLReverse>N</SSLReverse> <SSLReencrypt>N</SSLReencrypt> <Intercept>N</Intercept> <InterceptOpts><Opt>opnormal</Opt> <Opt>auditnone</Opt> <Opt>reqdatadisable</Opt> <Opt>resdatadisable</Opt> </InterceptOpts><AlertThreshold>0</AlertThreshold> <Transactionlimit>0</Transactionlimit> <Transparent>Y</Transparent> <SubnetOriginating>N</SubnetOriginating> <ServerInit>0</ServerInit> <StartTLSMode>0</StartTLSMode> <Idletime>0</Idletime> <Cache>N</Cache> <Compress>N</Compress> <Verify>0</Verify> <UseforSnat>N</UseforSnat> <ForceL7>Y</ForceL7> <MultiConnect>N</MultiConnect> <ClientCert>0</ClientCert> <ErrorCode>0</ErrorCode> <CheckUse1.1>N</CheckUse1.1> <MatchLen>0</MatchLen> <CheckUseGet>0</CheckUseGet> <SSLRewrite>0</SSLRewrite> <VStype>http</VStype> <FollowVSID>0</FollowVSID> <Protocol>tcp</Protocol> <Schedule>rr</Schedule> <CheckType>http</CheckType> <PersistTimeout>0</PersistTimeout> <CheckPort>0</CheckPort> <NRules>0</NRules> <NRequestRules>0</NRequestRules> <NResponseRules>0</NResponseRules> <NPreProcessRules>0</NPreProcessRules> <EspEnabled>N</EspEnabled> <InputAuthMode>0</InputAuthMode> <OutputAuthMode>0</OutputAuthMode> <MasterVS>0</MasterVS> <MasterVSID>2</MasterVSID> <AddVia>0</AddVia> <QoS>0</QoS> <TlsType>0</TlsType> <NeedHostName>N</NeedHostName> <OCSPVerify>N</OCSPVerify> <EnhancedHealthChecks>N</EnhancedHealthChecks> <RsMinimum>0</RsMinimum> <NumberOfRSs>0</NumberOfRSs> </VS> <VS> <Status>Down</Status> <Index>6</Index> <VSPort>0</VSPort> <Enable>Y</Enable> <SSLReverse>N</SSLReverse> <SSLReencrypt>N</SSLReencrypt> <Intercept>N</Intercept> <InterceptOpts><Opt>opnormal</Opt> <Opt>auditnone</Opt> <Opt>reqdatadisable</Opt> <Opt>resdatadisable</Opt> </InterceptOpts><AlertThreshold>0</AlertThreshold> <Transactionlimit>0</Transactionlimit> <Transparent>Y</Transparent> <SubnetOriginating>N</SubnetOriginating> <ServerInit>0</ServerInit> <StartTLSMode>0</StartTLSMode> <Idletime>0</Idletime> <Cache>N</Cache> <Compress>N</Compress> <Verify>0</Verify> <UseforSnat>N</UseforSnat> <ForceL7>Y</ForceL7> <MultiConnect>N</MultiConnect> <ClientCert>0</ClientCert> <ErrorCode>0</ErrorCode> <CheckUse1.1>N</CheckUse1.1> <MatchLen>0</MatchLen> <CheckUseGet>0</CheckUseGet> <SSLRewrite>0</SSLRewrite> <VStype>http</VStype> <FollowVSID>0</FollowVSID> <Protocol>tcp</Protocol> <Schedule>rr</Schedule> <CheckType>http</CheckType> <PersistTimeout>0</PersistTimeout> <CheckPort>0</CheckPort> <NRules>0</NRules> <NRequestRules>0</NRequestRules> <NResponseRules>0</NResponseRules> <NPreProcessRules>0</NPreProcessRules> <EspEnabled>N</EspEnabled> <InputAuthMode>0</InputAuthMode> <OutputAuthMode>0</OutputAuthMode> <MasterVS>0</MasterVS> <MasterVSID>2</MasterVSID> <AddVia>0</AddVia> <QoS>0</QoS> <TlsType>0</TlsType> <NeedHostName>N</NeedHostName> <OCSPVerify>N</OCSPVerify> <EnhancedHealthChecks>N</EnhancedHealthChecks> <RsMinimum>0</RsMinimum> <NumberOfRSs>2</NumberOfRSs> <Rs> <Status>Down</Status> <VSIndex>6</VSIndex> <RsIndex>7</RsIndex> <Addr>10.154.0.100</Addr> <Port>80</Port> <Forward>nat</Forward> <Weight>1000</Weight> <Limit>0</Limit> <Enable>Y</Enable> <Critical>N</Critical> </Rs> <Rs> <Status>Down</Status> <VSIndex>6</VSIndex> <RsIndex>8</RsIndex> <Addr>10.154.0.102</Addr> <Port>80</Port> <Forward>nat</Forward> <Weight>1000</Weight> <Limit>0</Limit> <Enable>Y</Enable> <Critical>N</Critical> </Rs> </VS> </Data> </Success> </Response> """
        service = OrderedDict([('Status', 'Down'), ('Index', '2'), ('VSAddress', '10.154.0.11'), ('VSPort', '80'), ('Enable', 'Y'), ('SSLReverse', 'N'), ('SSLReencrypt', 'N'), ('Intercept', 'N'), ('InterceptOpts', OrderedDict([('Opt', ['opnormal', 'auditrelevant', 'reqdatadisable', 'resdatadisable'])])), ('AlertThreshold', '0'), ('Transactionlimit', '0'), ('Transparent', 'Y'), ('SubnetOriginating', 'N'), ('ServerInit', '0'), ('StartTLSMode', '0'), ('Idletime', '0'), ('Cache', 'N'), ('Compress', 'N'), ('Verify', '0'), ('UseforSnat', 'N'), ('ForceL7', 'Y'), ('MultiConnect', 'N'), ('ClientCert', '0'), ('ErrorCode', '0'), ('CheckUse1.1', 'N'), ('MatchLen', '0'), ('CheckUseGet', '0'), ('SSLRewrite', '0'), ('VStype', 'http'), ('FollowVSID', '0'), ('Protocol', 'tcp'), ('Schedule', 'rr'), ('CheckType', 'http'), ('PersistTimeout', '0'), ('CheckPort', '0'), ('NRules', '0'), ('NRequestRules', '0'), ('NResponseRules', '0'), ('NPreProcessRules', '0'), ('EspEnabled', 'N'), ('InputAuthMode', '0'), ('OutputAuthMode', '0'), ('MasterVS', '2'), ('MasterVSID', '0'), ('AddVia', '0'), ('QoS', '0'), ('TlsType', '0'), ('NeedHostName', 'N'), ('OCSPVerify', 'N'), ('RsMinimum', '0'), ('NumberOfRSs', '2'), ('SubVS', [OrderedDict([('Status', 'Down'), ('VSIndex', '6'), ('RsIndex', '5'), ('Name', '-'), ('Forward', 'nat'), ('Weight', '1000'), ('Limit', '0'), ('Enable', 'Y'), ('Critical', 'N')]), OrderedDict([('Status', 'Down'), ('VSIndex', '7'), ('RsIndex', '6'), ('Name', '-'), ('Forward', 'nat'), ('Weight', '1000'), ('Limit', '0'), ('Enable', 'Y'), ('Critical', 'N')])])])
        expected_vs_string = "Virtual Service TCP 10.154.0.11:80 on LoadMaster 10.154.190.153"

        lm_test = LoadMaster("10.154.190.153", "bal", "2fourall")
        actual_vs = lm_test.build_virtual_service(service, list_vs_response)
        assert_equal(expected_vs_string, str(actual_vs))
        assert_equal(len(actual_vs.subvs_entries), 2)

    def test_build_virtual_service_with_sub_vs(self):
        service = OrderedDict([('Status', 'Down'), ('Index', '8'), ('VSPort', '0'), ('Enable', 'Y'), ('SSLReverse', 'N'), ('SSLReencrypt', 'N'), ('Intercept', 'N'), ('InterceptOpts', OrderedDict([('Opt', ['opnormal', 'auditnone', 'reqdatadisable', 'resdatadisable'])])), ('AlertThreshold', '0'), ('Transactionlimit', '0'), ('Transparent', 'Y'), ('SubnetOriginating', 'N'), ('ServerInit', '0'), ('StartTLSMode', '0'), ('Idletime', '0'), ('Cache', 'N'), ('Compress', 'N'), ('Verify', '0'), ('UseforSnat', 'N'), ('ForceL7', 'Y'), ('MultiConnect', 'N'), ('ClientCert', '0'), ('ErrorCode', '0'), ('CheckUse1.1', 'N'), ('MatchLen', '0'), ('CheckUseGet', '0'), ('SSLRewrite', '0'), ('VStype', 'http'), ('FollowVSID', '0'), ('Protocol', 'tcp'), ('Schedule', 'rr'), ('CheckType', 'http'), ('PersistTimeout', '0'), ('CheckPort', '0'), ('NRules', '0'), ('NRequestRules', '0'), ('NResponseRules', '0'), ('NPreProcessRules', '0'), ('EspEnabled', 'N'), ('InputAuthMode', '0'), ('OutputAuthMode', '0'), ('MasterVS', '0'), ('MasterVSID', '3'), ('AddVia', '0'), ('QoS', '0'), ('TlsType', '0'), ('NeedHostName', 'N'), ('OCSPVerify', 'N'), ('EnhancedHealthChecks', 'N'), ('RsMinimum', '0'), ('NumberOfRSs', '0')])
        expected_vs_string = "Sub Virtual Service 8 on LoadMaster 10.154.190.153"
        expected_subvs_data = OrderedDict([('Status', 'Down'), ('VSIndex', '8'), ('RsIndex', '9'), ('Name', '-'), ('Forward', 'nat'), ('Weight', '1000'), ('Limit', '0'), ('Enable', 'Y'), ('Critical', 'N'), ('parentvs', '3')])

        lm_test = LoadMaster("10.154.190.153", "bal", "2fourall")
        parent_vs = OrderedDict([('Status', 'Down'), ('Index', '3'), ('VSAddress', '10.154.0.12'), ('VSPort', '80'), ('Enable', 'Y'), ('SSLReverse', 'N'), ('SSLReencrypt', 'N'), ('Intercept', 'N'), ('InterceptOpts', OrderedDict([('Opt', ['opnormal', 'auditrelevant', 'reqdatadisable', 'resdatadisable'])])), ('AlertThreshold', '0'), ('Transactionlimit', '0'), ('Transparent', 'Y'), ('SubnetOriginating', 'N'), ('ServerInit', '0'), ('StartTLSMode', '0'), ('Idletime', '0'), ('Cache', 'N'), ('Compress', 'N'), ('Verify', '0'), ('UseforSnat', 'N'), ('ForceL7', 'Y'), ('MultiConnect', 'N'), ('ClientCert', '0'), ('ErrorCode', '0'), ('CheckUse1.1', 'N'), ('MatchLen', '0'), ('CheckUseGet', '0'), ('SSLRewrite', '0'), ('VStype', 'http'), ('FollowVSID', '0'), ('Protocol', 'tcp'), ('Schedule', 'rr'), ('CheckType', 'http'), ('PersistTimeout', '0'), ('CheckPort', '0'), ('NRules', '0'), ('NRequestRules', '0'), ('NResponseRules', '0'), ('NPreProcessRules', '0'), ('EspEnabled', 'N'), ('InputAuthMode', '0'), ('OutputAuthMode', '0'), ('MasterVS', '1'), ('MasterVSID', '0'), ('AddVia', '0'), ('QoS', '0'), ('TlsType', '0'), ('NeedHostName', 'N'), ('OCSPVerify', 'N'), ('RsMinimum', '0'), ('NumberOfRSs', '1'), ('SubVS', OrderedDict([('Status', 'Down'), ('VSIndex', '8'), ('RsIndex', '9'), ('Name', '-'), ('Forward', 'nat'), ('Weight', '1000'), ('Limit', '0'), ('Enable', 'Y'), ('Critical', 'N')]))])
        actual_vs = lm_test.build_virtual_service(service, parent_vs)
        assert_equal(expected_vs_string, str(actual_vs))
        assert_equal(expected_subvs_data, actual_vs.subvs_data)

