# Copyright 2014 IBM Corp.
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import testresources

from keystoneclient.tests.unit import client_fixtures
from keystoneclient.tests.unit.v2_0 import utils


class CertificateTests(utils.TestCase, testresources.ResourcedTestCase):

    resources = [('examples', client_fixtures.EXAMPLES_RESOURCE)]

    def test_get_ca_certificate(self):
        self.stub_url('GET', ['certificates', 'ca'],
                      headers={'Content-Type': 'text/html; charset=UTF-8'},
                      text=self.examples.SIGNING_CA)
        res = self.client.certificates.get_ca_certificate()
        self.assertEqual(self.examples.SIGNING_CA, res)

    def test_get_signing_certificate(self):
        self.stub_url('GET', ['certificates', 'signing'],
                      headers={'Content-Type': 'text/html; charset=UTF-8'},
                      text=self.examples.SIGNING_CERT)
        res = self.client.certificates.get_signing_certificate()
        self.assertEqual(self.examples.SIGNING_CERT, res)


def load_tests(loader, tests, pattern):
    return testresources.OptimisingTestSuite(tests)
