# Welcome to python-kraken-sdk contributing guide

Thank you for investing your time in contributing to the
[python-kraken-sdk](https://github.com/btschwertfeger/python-kraken-sdk/)
project! 🔥

Read our [Code of Conduct](./CODE_OF_CONDUCT.md) to keep our community
approachable and respectable.

If you have any questions, comments, suggestions or general topics, please feel
free to open or join a thread at
[python-kraken-sdk/discussions](https://github.com/btschwertfeger/python-kraken-sdk/discussions).
We are looking forward to nice conversations, strategy exchange and an knowledge
transfer!

## Getting started 🚀

In this guide you will get an overview of the contribution workflow from opening
an issue, creating a PR, reviewing, and merging the PR.

### Issues

#### Create a new issue

If you have an issue that's not yet listed in the troubleshooting section of
[README.md](https://github.com/btschwertfeger/python-kraken-sdk#readme) or in
[documentation](https://python-kraken-sdk.readthedocs.io/en/stable), feel free
to create a new
[issue](https://github.com/btschwertfeger/python-kraken-sdk/issues) if there is
no similar one listed among the existing ones. Also, for any features that are
missing, this is the right place to request them.

#### Solve an issue

Scan through our [existing issues](https://github.com/github/docs/issues) to
find one that interests you. If the future brings more and more features or
issues - you can also filter for specific `labels`.

### Make Changes

1. Fork the repository

```bash
git clone https://github.com/btschwertfeger/python-kraken-sdk.git
```

2. Install the provided [pre-commit](https://pre-commit.com/) hooks within the
   repository and make sure that all hooks run through, before pushing changes.

```bash
python-kraken-sdk~$: pre-commit install
python-kraken-sdk~$: pre-commit run -a
```

3. Create a new branch and start implementing your changes.

   In the project provides a `Makefile` which offers many shortcuts to execute
   different commands. For example, you can use `make test` to run all unit
   tests or `make build` to build the package. `make dev` installs the
   python-kraken-sdk in editable state into the current environment. However,
   for development it is recommended to set up a virtual environment first.

### Commit your updates 🎬

Once you're happy or reached some minor goal - commit the changes. Please take
care to address **all** requirements of the [self-review
checklist](./.github/self-review.md) before creating a PR to speed up the review
process. ⚡️

### Pull Request

When you're finished with the changes, create a pull request.

- All checks of the [self-review checklist](./.github/self-review.md) must be
  addressed.
- Don't forget to link PR to an issue or create one to link if there is no
  existing issue.
- You may asked for changes to be made before a PR can be merged, either using
  _suggested changes_ or pull request _comments_. You can make any other changes
  in your fork, then commit them to your branch.
- As you update your PR and apply changes, mark each conversation as resolved.

### Your PR is merged! 🏅

Great! We're happy and proud of any contribution made on this project. So you
may want to start to work on the next issue? 🔥

---

This file is based on the
[CONTRIBUTING.md](https://github.com/github/docs/blob/v1.0.1/CONTRIBUTING.md)
file provided by [GitHub Docs](https://github.com/github/docs).
