"""
This type stub file was generated by pyright.
"""

import _ldap
import ldap
from ldap.pkginfo import __version__
from pyasn1.error import PyAsn1Error
from ldap.controls.simple import *
from ldap.controls.libldap import *

"""
controls.py - support classes for LDAP controls

See https://www.python-ldap.org/ for details.

Description:
The ldap.controls module provides LDAPControl classes.
Each class provides support for a certain control.
"""
__all__ = ['KNOWN_RESPONSE_CONTROLS', 'AssertionControl', 'BooleanControl', 'LDAPControl', 'ManageDSAITControl', 'MatchedValuesControl', 'RelaxRulesControl', 'RequestControl', 'ResponseControl', 'SimplePagedResultsControl', 'ValueLessRequestControl', 'RequestControlTuples', 'DecodeControlTuples']
KNOWN_RESPONSE_CONTROLS = ...
class RequestControl:
  """
  Base class for all request controls

  controlType
      OID as string of the LDAPv3 extended request control
  criticality
      sets the criticality of the control (boolean)
  encodedControlValue
      control value of the LDAPv3 extended request control
      (here it is the BER-encoded ASN.1 control value)
  """
  def __init__(self, controlType=..., criticality=..., encodedControlValue=...) -> None:
    ...
  
  def encodeControlValue(self): # -> None:
    """
    sets class attribute encodedControlValue to the BER-encoded ASN.1
    control value composed by class attributes set before
    """
    ...
  


class ResponseControl:
  """
  Base class for all response controls

  controlType
      OID as string of the LDAPv3 extended response control
  criticality
      sets the criticality of the received control (boolean)
  """
  def __init__(self, controlType=..., criticality=...) -> None:
    ...
  
  def decodeControlValue(self, encodedControlValue): # -> None:
    """
    decodes the BER-encoded ASN.1 control value and sets the appropriate
    class attributes
    """
    ...
  


class LDAPControl(RequestControl, ResponseControl):
  """
  Base class for combined request/response controls mainly
  for backward-compatibility to python-ldap 2.3.x
  """
  def __init__(self, controlType=..., criticality=..., controlValue=..., encodedControlValue=...) -> None:
    ...
  


def RequestControlTuples(ldapControls): # -> list[tuple[Any, Any, Any]] | None:
  """
  Return list of readily encoded 3-tuples which can be directly
  passed to C module _ldap

  ldapControls
      sequence-type of RequestControl objects
  """
  ...

def DecodeControlTuples(ldapControlTuples, knownLDAPControls=...): # -> list[Any]:
  """
  Returns list of readily decoded ResponseControl objects

  ldapControlTuples
      Sequence-type of 3-tuples returned by _ldap.result4() containing
      the encoded ASN.1 control values of response controls.
  knownLDAPControls
      Dictionary mapping extended control's OID to ResponseControl class
      of response controls known by the application. If None
      ldap.controls.KNOWN_RESPONSE_CONTROLS is used here.
  """
  ...

