"""
This type stub file was generated by pyright.
"""

from ldap.schema.models import *

"""
ldap.schema.subentry -  subschema subentry handling

See https://www.python-ldap.org/ for details.
"""
SCHEMA_CLASS_MAPPING = ...
SCHEMA_ATTR_MAPPING = ...
SCHEMA_ATTRS = ...
class SubschemaError(ValueError):
  ...


class OIDNotUnique(SubschemaError):
  def __init__(self, desc) -> None:
    ...
  
  def __str__(self) -> str:
    ...
  


class NameNotUnique(SubschemaError):
  def __init__(self, desc) -> None:
    ...
  
  def __str__(self) -> str:
    ...
  


class SubSchema:
  """
  Arguments:

  sub_schema_sub_entry
      Dictionary usually returned by LDAP search or the LDIF parser
      containing the sub schema sub entry

  check_uniqueness
      Defines whether uniqueness of OIDs and NAME is checked.

      0
        no check
      1
        check but add schema description with work-around
      2
        check and raise exception if non-unique OID or NAME is found

  Class attributes:

  sed
    Dictionary holding the subschema information as pre-parsed
    SchemaElement objects (do not access directly!)
  name2oid
    Dictionary holding the mapping from NAMEs to OIDs
    (do not access directly!)
  non_unique_oids
    List of OIDs used at least twice in the subschema
  non_unique_names
    List of NAMEs used at least twice in the subschema for the same schema element
  """
  def __init__(self, sub_schema_sub_entry, check_uniqueness=...) -> None:
    ...
  
  def ldap_entry(self): # -> dict[Any, Any]:
    """
    Returns a dictionary containing the sub schema sub entry
    """
    ...
  
  def listall(self, schema_element_class, schema_element_filters=...): # -> list[Any]:
    """
    Returns a list of OIDs of all available schema
    elements of a given schema element class.
    """
    ...
  
  def tree(self, schema_element_class, schema_element_filters=...): # -> cidict:
    """
    Returns a ldap.cidict.cidict dictionary representing the
    tree structure of the schema elements.
    """
    ...
  
  def getoid(self, se_class, nameoroid, raise_keyerror=...):
    """
    Get an OID by name or OID
    """
    ...
  
  def get_inheritedattr(self, se_class, nameoroid, name): # -> Any | None:
    """
    Get a possibly inherited attribute specified by name
    of a schema element specified by nameoroid.
    Returns None if class attribute is not set at all.

    Raises KeyError if no schema element is found by nameoroid.
    """
    ...
  
  def get_obj(self, se_class, nameoroid, default=..., raise_keyerror=...): # -> None:
    """
    Get a schema element by name or OID
    """
    ...
  
  def get_inheritedobj(self, se_class, nameoroid, inherited=...):
    """
    Get a schema element by name or OID with all class attributes
    set including inherited class attributes
    """
    ...
  
  def get_syntax(self, nameoroid): # -> None:
    """
    Get the syntax of an attribute type specified by name or OID
    """
    ...
  
  def get_structural_oc(self, oc_list): # -> None:
    """
    Returns OID of structural object class in oc_list
    if any is present. Returns None else.
    """
    ...
  
  def get_applicable_aux_classes(self, nameoroid): # -> list[Any]:
    """
    Return a list of the applicable AUXILIARY object classes
    for a STRUCTURAL object class specified by 'nameoroid'
    if the object class is governed by a DIT content rule.
    If there's no DIT content rule all available AUXILIARY
    object classes are returned.
    """
    ...
  
  def attribute_types(self, object_class_list, attr_type_filter=..., raise_keyerror=..., ignore_dit_content_rule=...): # -> tuple[cidict, cidict]:
    """
    Returns a 2-tuple of all must and may attributes including
    all inherited attributes of superior object classes
    by walking up classes along the SUP attribute.

    The attributes are stored in a ldap.cidict.cidict dictionary.

    object_class_list
        list of strings specifying object class names or OIDs
    attr_type_filter
        list of 2-tuples containing lists of class attributes
        which has to be matched
    raise_keyerror
        All KeyError exceptions for non-existent schema elements
        are ignored
    ignore_dit_content_rule
        A DIT content rule governing the structural object class
        is ignored
    """
    ...
  


def urlfetch(uri, trace_level=...): # -> tuple[Any | None, Any | None]:
  """
  Fetches a parsed schema entry by uri.

  If uri is a LDAP URL the LDAP server is queried directly.
  Otherwise uri is assumed to point to a LDIF file which
  is loaded with urllib.
  """
  ...

