/*
 * Decompiled with CFR 0.152.
 */
package com.github.trevershick.test.ldap;

import com.github.trevershick.test.ldap.annotations.LdapAttribute;
import com.github.trevershick.test.ldap.annotations.LdapConfiguration;
import com.github.trevershick.test.ldap.annotations.LdapEntry;
import com.github.trevershick.test.ldap.annotations.Ldif;
import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.BindException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@LdapConfiguration
public class LdapServerResource {
    private InMemoryDirectoryServer server;
    private LdapConfiguration config;

    public LdapServerResource() {
        this(null);
    }

    public LdapServerResource(Object annotated) {
        LdapConfiguration ldapConfiguration = this.config = annotated == null ? null : annotated.getClass().getAnnotation(LdapConfiguration.class);
        if (this.config == null) {
            this.config = this.defaultConfiguration();
        }
    }

    public int port() {
        if (!this.isStarted()) {
            throw new IllegalStateException("The LDAP server is not started");
        }
        return this.server.getListenPort();
    }

    public void stop() {
        if (this.server != null) {
            this.server.shutDown(true);
        }
        this.server = null;
    }

    public boolean isStarted() {
        return this.server != null;
    }

    public boolean isStopped() {
        return !this.isStarted();
    }

    public LdapServerResource start() throws Exception {
        if (this.server != null) {
            throw new IllegalStateException("server is already initialized");
        }
        try {
            this.server = this.configureWithPort(this.config.port());
        }
        catch (BindException be) {
            if (this.config.useRandomPortAsFallback()) {
                this.server = this.configureWithPort(0);
            }
            throw be;
        }
        this.loadLdifFiles();
        this.loadRootEntry();
        this.loadEntries();
        return this;
    }

    protected InMemoryDirectoryServer configureWithPort(int port) throws LDAPException, BindException {
        InMemoryListenerConfig listenerConfig = port > 0 ? InMemoryListenerConfig.createLDAPConfig("default", this.config.port()) : InMemoryListenerConfig.createLDAPConfig("default");
        InMemoryDirectoryServerConfig c = new InMemoryDirectoryServerConfig(new DN(this.config.base().dn()));
        c.setListenerConfigs(listenerConfig);
        c.addAdditionalBindCredentials(this.config.bindDn(), this.config.password());
        this.server = new InMemoryDirectoryServer(c);
        try {
            this.server.startListening();
            return this.server;
        }
        catch (LDAPException ldape) {
            if (ldape.getMessage().contains("java.net.BindException")) {
                throw new BindException(ldape.getMessage());
            }
            throw ldape;
        }
    }

    protected LdapConfiguration defaultConfiguration() {
        return LdapServerResource.class.getAnnotation(LdapConfiguration.class);
    }

    protected void loadRootEntry() throws LDAPException {
        SearchResultEntry entry = this.server.getEntry(this.config.base().dn());
        if (entry == null) {
            this.server.add(this.entry(this.config.base()));
        }
    }

    protected void loadEntries() throws LDAPException {
        LdapEntry[] entries = this.config.entries();
        if (entries == null || entries.length == 0) {
            return;
        }
        for (int i = 0; i < entries.length; ++i) {
            Entry entry = this.entry(entries[i]);
            this.server.add(entry);
        }
    }

    private Entry entry(LdapEntry ldapEntry) {
        Entry e = new Entry(ldapEntry.dn());
        e.addAttribute("objectClass", ldapEntry.objectclass());
        LdapAttribute[] attrs = ldapEntry.attributes();
        for (int i = 0; attrs != null && i < attrs.length; ++i) {
            e.addAttribute(attrs[i].name(), attrs[i].value());
        }
        return e;
    }

    protected void loadLdifFiles() throws Exception {
        Iterable<String> ldifResources = this.ldifResources();
        for (String ldif : ldifResources) {
            InputStream resourceAsStream = this.getClass().getResourceAsStream(ldif);
            if (resourceAsStream == null) {
                throw new FileNotFoundException("Should be able to load " + ldif);
            }
            LDIFReader r = new LDIFReader(resourceAsStream);
            LDIFChangeRecord readEntry = null;
            while ((readEntry = r.readChangeRecord()) != null) {
                readEntry.processChange(this.server);
            }
            resourceAsStream.close();
        }
    }

    protected Iterable<String> ldifResources() {
        Ldif[] annotation = this.config.ldifs();
        ArrayList<String> ldifs = new ArrayList<String>(0);
        for (int i = 0; annotation != null && i < annotation.length; ++i) {
            ldifs.add(annotation[i].value());
        }
        return ldifs;
    }
}

