/*
 * Decompiled with CFR 0.152.
 */
package net.zoldar.ldap.testserver;

import com.github.trevershick.test.ldap.LdapServerResource;
import com.github.trevershick.test.ldap.annotations.LdapConfiguration;
import java.util.HashMap;
import java.util.Map;
import net.zoldar.ldap.testserver.LdapServerResourceCreator;
import py4j.GatewayServer;

public class Server {
    private static GatewayServer gateway;
    private Map<Integer, LdapServerResource> servers = new HashMap<Integer, LdapServerResource>();

    public static void main(String[] args) throws Exception {
        gateway = new GatewayServer(new Server());
        gateway.start();
        System.out.println("Gateway server started on port " + gateway.getPort() + "!");
    }

    private Server() {
    }

    public int create(LdapConfiguration config) throws Exception {
        int port = config.port();
        if (this.servers.containsKey(port) && this.servers.get(port).isStarted()) {
            throw new IllegalStateException("LDAP server already running on port " + port);
        }
        LdapServerResource newServer = new LdapServerResourceCreator(config).getResource();
        this.servers.put(port, newServer);
        return port;
    }

    public void destroy() {
        for (int serverId : this.servers.keySet()) {
            this.destroy(serverId);
        }
    }

    public void destroy(int serverId) {
        if (this.servers.containsKey(serverId)) {
            this.servers.get(serverId).stop();
        }
        this.servers.remove(serverId);
    }

    public void start() throws Exception {
        for (int serverId : this.servers.keySet()) {
            if (this.servers.get(serverId).isStarted()) continue;
            this.servers.get(serverId).start();
        }
    }

    public void start(int serverId) throws Exception {
        if (!this.servers.get(serverId).isStarted()) {
            this.servers.get(serverId).start();
        }
    }

    public void stop() {
        for (int serverId : this.servers.keySet()) {
            this.servers.get(serverId).stop();
        }
    }

    public void stop(int serverId) {
        if (this.servers.containsKey(serverId)) {
            this.servers.get(serverId).stop();
        }
    }

    public void start(LdapConfiguration config) throws Exception {
        LdapServerResource newServer = new LdapServerResourceCreator(config).getResource();
        newServer.start();
        this.destroy();
        this.servers.put(newServer.port(), newServer);
    }

    public int port() {
        return this.servers.values().iterator().next().port();
    }
}

