# Python Learning Tracker

**Python Learning Tracker** — це Python-пакет для аналізу прогресу у вивченні Python.

## **Особливості**
- Порівняння планового та фактичного часу навчання.
- Оцінка рівня розуміння тем.
- Генерація звіту з рекомендаціями.
- Мотиваційні фрази для натхнення.

## **Встановлення**
```powershell
pip install python_learning_tracker
```

## **Використання**
```powershell
learning-tracker --files <шлях_до_папки> [--start YYYY-MM-DD] [--end YYYY-MM-DD] [--topic "Назва теми"] [--motivate]
```

### **Аргументи:**
- `--files <шлях_до_папки>` – шлях до папки з вашими CSV-файлами.
- `--start YYYY-MM-DD` – дата початку періоду (необов’язково).
- `--end YYYY-MM-DD` – дата кінця періоду (необов’язково).
- `--topic "Назва теми"` – звіт лише для вказаної теми (необов’язково).
- `--motivate` – додати мотиваційну фразу.

### **Приклади запуску:**
- Проста команда:
  ```powershell
  learning-tracker --files ./data --motivate
  ```
- Аналіз за період:
  ```powershell
  learning-tracker --files ./data --start 2023-12-01 --end 2023-12-03
  ```
- Звіт по одній темі:
  ```powershell
  learning-tracker --files ./data --topic "Функції"
  ```

## **Формат даних**
Програма очікує CSV-файли з планом навчання, фактичними даними та мотиваційними фразами. **Користувач може використовувати власні дані, вказавши шлях до своїх файлів**.

## **Приклад даних**
Приклади CSV-файлів можна переглянути у [репозиторії за посиланням](https://git.foxminded.ua/povh_andriy/task-6_extra_learning-python/-/tree/dev/data?ref_type=heads).

## **Ліцензія**
MIT License. Див. файл LICENSE.

