from .imports import *

renameDictionary = {
    "Lærere": "Lærer",
    "Lokaler": "Lokale"
}
def fravær(self):
    url = f"https://www.lectio.dk/lectio/{self.skoleId}/subnav/fravaerelev.aspx?elevid={self.elevId}"
    resp = self.session.get(url)
    if resp.url != url:
        raise Exception("lectio-cookie udløbet")
    soup = BeautifulSoup(resp.text, "html.parser")

    fravær = {
        "generalt": [],
        "moduler": {
            "manglende_fraværsårsager": [],
            "oversigt": []
        },
        "grafisk_oversigt": "https://www.lectio.dk" + soup.find("img", {"class": "fravaer_billede"}).get("src")
    }

    for hold in soup.find("table", {"id": "s_m_Content_Content_SFTabStudentAbsenceDataTable"}).find_all("tr"):
        if hold.get("id") == None:
            row = hold.find_all("td")
            fravær["generalt"].append({
                "hold": row[0].text,
                "opgjort_fravær_procent": row[1].text,
                "opgjort_fravær_moduler": row[2].text,
                "heleåret_fravær_procent": row[3].text,
                "heleåret_fravær_moduler": row[4].text,
            })

    resp = self.session.get(f"https://www.lectio.dk/lectio/{self.skoleId}/subnav/fravaerelev_fravaersaarsager.aspx?elevid={self.elevId}")
    soup = BeautifulSoup(resp.text, "html.parser")

    manglende = soup.find("table", {"id": "s_m_Content_Content_FatabMissingAarsagerGV"})
    if "Der er ingen manglende fraværsårsager..." not in str(manglende):
        for tr in manglende.find_all("tr")[1:]:
            modul = tr.find("a", class_="s2skemabrik")
            modulDetaljer = modul["data-additionalinfo"].split("\n\n")[0].split("\n")

            modulDict = {
                "navn": None,
                "tidspunkt": None,
                "hold": None,
                "lærer": None,
                "lokale": None,
                "absid": re.search('absid=[0-9]+', modul["href"]).group().replace("absid=", "")
            }
            for modulDetalje in modulDetaljer:
                if (value := ": ".join(modulDetalje.split(": ")[1:])) != "":
                    if (navn := modulDetalje.split(": ")[0]) in renameDictionary:
                        navn = renameDictionary[navn]

                    modulDict[navn.lower()] = value
                else:
                    try:
                        int(datetime.strptime(modulDetalje.split(": ")[0].split(" til")[0],
                                              "%d/%m-%Y %H:%M").timestamp())
                        modulDict["tidspunkt"] = modulDetalje
                    except Exception:
                        modulDict["navn"] = modulDetalje.split(": ")[0]

            tds = tr.find_all("td")

            fravær["moduler"]["manglende_fraværsårsager"].append({
                "type": tds[0].text.lstrip(),
                "uge": tds[1].text.lstrip(),
                "aktivitet": modulDict,
                "fravær": tds[3].text.lstrip(),
                "fraværstype": tds[4].text.lstrip(),
                "registreret": tds[5].text.lstrip(),
                "lærer": tds[6].text.lstrip(),
                "bemærkning": None
            })

    oversigt = soup.find("table", {"id": "s_m_Content_Content_FatabAbsenceFravaerGV"})
    if "Der er ikke indtastet nogen fraværsårsager" not in str(oversigt):
        for tr in oversigt.find_all("tr")[1:]:
            modul = tr.find("a", class_="s2skemabrik")
            modulDetaljer = modul["data-additionalinfo"].split("\n\n")[0].split("\n")

            modulDict = {
                "navn": None,
                "tidspunkt": None,
                "hold": None,
                "lærer": None,
                "lokale": None,
                "absid": re.search('absid=[0-9]+', modul["href"]).group().replace("absid=", "")
            }
            for modulDetalje in modulDetaljer:
                if (value := ": ".join(modulDetalje.split(": ")[1:])) != "":
                    if (navn := modulDetalje.split(": ")[0]) in renameDictionary:
                        navn = renameDictionary[navn]

                    modulDict[navn.lower()] = value
                else:
                    try:
                        int(datetime.strptime(modulDetalje.split(": ")[0].split(" til")[0],
                                              "%d/%m-%Y %H:%M").timestamp())
                        modulDict["tidspunkt"] = modulDetalje
                    except Exception:
                        modulDict["navn"] = modulDetalje.split(": ")[0]

            tds = tr.find_all("td")

            registreretLærer = tds[4].text.lstrip().split("\n\t\t\t\t\t\t")
            årsagÅrsagsnote = tds[6].text.lstrip().split("\n\t\t\t\t\t\t")
            if len(årsagÅrsagsnote) == 1:
                årsagÅrsagsnote.append("")

            fravær["moduler"]["oversigt"].append({
                "type": "Lektion", # De har fjernet det fra tabellen, måske skal vi også gøre det samme.
                "uge": tds[0].text.lstrip(),
                "aktivitet": modulDict,
                "fravær": tds[2].text.lstrip(),
                "fraværstype": tds[3].text.lstrip(),
                "registreret": registreretLærer[0],
                "lærer": registreretLærer[1],
                "bemærkning": tds[5].text.lstrip(),
                "årsag": årsagÅrsagsnote[0],
                "årsagsnote": årsagÅrsagsnote[1],
            })
            print(fravær["moduler"]["oversigt"])

    return fravær
