
# import statement needed on some systems
import sys
import os.path
import inspect
try: 
  _filename = inspect.getframeinfo(inspect.currentframe()).filename
except:
  _filename = __file__
_path = os.path.dirname(os.path.abspath(_filename))
if not _path in sys.path:
  sys.path.append(_path)

# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _libcombine
else:
    import _libcombine

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcombine.delete_SwigPyIterator

    def value(self):
        return _libcombine.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _libcombine.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _libcombine.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _libcombine.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _libcombine.SwigPyIterator_equal(self, x)

    def copy(self):
        return _libcombine.SwigPyIterator_copy(self)

    def next(self):
        return _libcombine.SwigPyIterator_next(self)

    def __next__(self):
        return _libcombine.SwigPyIterator___next__(self)

    def previous(self):
        return _libcombine.SwigPyIterator_previous(self)

    def advance(self, n):
        return _libcombine.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _libcombine.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _libcombine.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _libcombine.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _libcombine.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _libcombine.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _libcombine.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _libcombine:
_libcombine.SwigPyIterator_swigregister(SwigPyIterator)

class ASTNodeList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libcombine.ASTNodeList_swiginit(self, _libcombine.new_ASTNodeList())
    __swig_destroy__ = _libcombine.delete_ASTNodeList

    def add(self, item):
        return _libcombine.ASTNodeList_add(self, item)

    def get(self, n):
        return _libcombine.ASTNodeList_get(self, n)

    def prepend(self, item):
        return _libcombine.ASTNodeList_prepend(self, item)

    def remove(self, n):
        return _libcombine.ASTNodeList_remove(self, n)

    def getSize(self):
        return _libcombine.ASTNodeList_getSize(self)

# Register ASTNodeList in _libcombine:
_libcombine.ASTNodeList_swigregister(ASTNodeList)

class CaNamespacesList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libcombine.CaNamespacesList_swiginit(self, _libcombine.new_CaNamespacesList())
    __swig_destroy__ = _libcombine.delete_CaNamespacesList

    def add(self, item):
        return _libcombine.CaNamespacesList_add(self, item)

    def get(self, n):
        return _libcombine.CaNamespacesList_get(self, n)

    def prepend(self, item):
        return _libcombine.CaNamespacesList_prepend(self, item)

    def remove(self, n):
        return _libcombine.CaNamespacesList_remove(self, n)

    def getSize(self):
        return _libcombine.CaNamespacesList_getSize(self)

# Register CaNamespacesList in _libcombine:
_libcombine.CaNamespacesList_swigregister(CaNamespacesList)

class CaBaseList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libcombine.CaBaseList_swiginit(self, _libcombine.new_CaBaseList())
    __swig_destroy__ = _libcombine.delete_CaBaseList

    def add(self, item):
        return _libcombine.CaBaseList_add(self, item)

    def get(self, n):
        return _libcombine.CaBaseList_get(self, n)

    def prepend(self, item):
        return _libcombine.CaBaseList_prepend(self, item)

    def remove(self, n):
        return _libcombine.CaBaseList_remove(self, n)

    def getSize(self):
        return _libcombine.CaBaseList_getSize(self)

# Register CaBaseList in _libcombine:
_libcombine.CaBaseList_swigregister(CaBaseList)

class SBaseList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libcombine.SBaseList_swiginit(self, _libcombine.new_SBaseList())
    __swig_destroy__ = _libcombine.delete_SBaseList

    def add(self, item):
        return _libcombine.SBaseList_add(self, item)

    def get(self, n):
        return _libcombine.SBaseList_get(self, n)

    def prepend(self, item):
        return _libcombine.SBaseList_prepend(self, item)

    def remove(self, n):
        return _libcombine.SBaseList_remove(self, n)

    def getSize(self):
        return _libcombine.SBaseList_getSize(self)

# Register SBaseList in _libcombine:
_libcombine.SBaseList_swigregister(SBaseList)



class AutoProperty(type):
    """
    A metaclass for automatically detecting getX/setX methods at class creation
    time (not instantiation), and adding properties (directly calling C methods
    where possible) to the class dictionary.
    """
    def __new__(cls, classname, bases, classdict):
        """
        Iterate over the items in the classdict looking for get/set pairs
        and declaring them as properties.
        """

        import re
        import keyword

        re_mangle = re.compile(r'[A-Za-z][a-z]+|[A-Z]+(?=$|[A-Z0-9])|\d+')
        re_id = re.compile(r'^[A-Za-z_][A-Za-z0-9_]*$')
        re_getdoc = re.compile(r'^\s*[A-Za-z_][A-Za-z0-9_]*\(self\)')
        re_setdoc = re.compile(r'^\s*[A-Za-z_][A-Za-z0-9_]*\(self,[^,)]+\)')

#convert ACapitalCasedStringXYZ123 -> a_capital_cased_string_xyz_123
        mangle_name = lambda x: ('_'.join(re_mangle.findall(x))).lower()

        get_methods = set()
        set_methods = set()
        swig_setter = classdict.get('__swig_setmethods__', {})

#only search for get/set methods
#we assume that any unset method also has either get or set
#a small number of set without get cases exist so we can't only
#search for get methods
        for k, v in classdict.items():
            name = k[3:]
            prefix = k[:3]
            mangled = mangle_name(name)
            if name:
                if callable(v):
                    if re_id.match(mangled) and mangled not in keyword.kwlist:
                        if prefix == 'get':
                            get_methods.add(name)
                        elif prefix == 'set':
                            set_methods.add(name)

        for name in get_methods | set_methods:

            mangled = mangle_name(name)

#ListOfFoobars -> foobars
            if mangled.startswith('list_of_'):
                mangled = mangled[8:]

            getter = setter = deleter = None
            if name in get_methods:
                getter = classdict['get'+name]

#this is a very dirty way of checking if the get method
#requires extra arguments (and hence cannot be a property)
#it should be possible to do this properly in SWIG?
                if getter.__doc__:
                    if not re_getdoc.match(getter.__doc__):
                        continue

#use the c-level get function if the python function
#only consists of a call to it
                cname = classname + '_get' + name
#test if function is "return _libsbml.CLASS_getNAME(__args__)"
                if getter.func_code.co_names == ('_libsbml', cname):
                    getter = getattr(_libsbml, cname)

            if name in set_methods:
                setter = classdict['set'+name]
                if setter.__doc__:
                    if not re_setdoc.match(setter.__doc__):
                        continue

                cname = classname + '_set' + name
                if setter.func_code.co_names == ('_libsbml', cname):
                    setter = getattr(_libsbml, cname)
#property fget does not get intercepted by __getattr__
#but fset does, so we implement property setting via
#the __swig_setmethods__ dict
                swig_setter[mangled] = setter

            if 'unset' + name in classdict:
                deleter = classdict['unset'+name]
                if deleter.__doc__:
#like a get method, a delete method should
#only require a self argument
                    if not re_getdoc.match(deleter.__doc__):
                        continue

                cname = classname + '_unset' + name
                if deleter.func_code.co_names == ('_libsbml', cname):
                    deleter = getattr(_libsbml, cname)

            if getter or setter or deleter:
#fset is technically redundant since the method is dispatched
#via _swig_setattr rather than through the property due to that
#function not delegating to object.__setattr__ which properly
#handles properties
                classdict[mangled] = property(fget=getter, fset=setter, fdel=deleter)

            def __repr__(self):
                desc = self.__class__.__name__
                if hasattr(self, '__len__'):
                    desc += '[%s]' % self.__len__()
                if hasattr(self, 'id') and self.id:
                    desc += ' %s' % self.id
                if hasattr(self, 'name') and self.name:
                    desc += ' "%s"' % self.name
                return '<' + desc + '>'

            if classdict.get('__repr__', None) in (_swig_repr, None):
                classdict['__repr__'] = __repr__


        return type.__new__(cls, classname, bases, classdict)


class string(object):
    r"""Proxy of C++ std::basic_string< char > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def length(self):
        r"""length(string self) -> std::basic_string< char >::size_type"""
        return _libcombine.string_length(self)

    def max_size(self):
        r"""max_size(string self) -> std::basic_string< char >::size_type"""
        return _libcombine.string_max_size(self)

    def copy(self, __s, __n, __pos=0):
        r"""copy(string self, char * __s, std::basic_string< char >::size_type __n, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type"""
        return _libcombine.string_copy(self, __s, __n, __pos)

    def c_str(self):
        r"""c_str(string self) -> char const *"""
        return _libcombine.string_c_str(self)

    def find(self, *args):
        r"""
        find(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find(string self, string __str, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        find(string self, char __c, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        """
        return _libcombine.string_find(self, *args)

    def rfind(self, *args):
        r"""
        rfind(string self, string __str, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        rfind(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        rfind(string self, char __c, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        """
        return _libcombine.string_rfind(self, *args)

    def find_first_of(self, *args):
        r"""
        find_first_of(string self, string __str, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        find_first_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_first_of(string self, char __c, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        """
        return _libcombine.string_find_first_of(self, *args)

    def find_last_of(self, *args):
        r"""
        find_last_of(string self, string __str, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        find_last_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_last_of(string self, char __c, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        """
        return _libcombine.string_find_last_of(self, *args)

    def find_first_not_of(self, *args):
        r"""
        find_first_not_of(string self, string __str, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        find_first_not_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_first_not_of(string self, char __c, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        """
        return _libcombine.string_find_first_not_of(self, *args)

    def find_last_not_of(self, *args):
        r"""
        find_last_not_of(string self, string __str, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        find_last_not_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_last_not_of(string self, char __c, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        """
        return _libcombine.string_find_last_not_of(self, *args)

    def substr(self, *args):
        r"""substr(string self, std::basic_string< char >::size_type __pos=0, std::basic_string< char >::size_type __n=std::basic_string< char >::npos) -> string"""
        return _libcombine.string_substr(self, *args)

    def empty(self):
        r"""empty(string self) -> bool"""
        return _libcombine.string_empty(self)

    def size(self):
        r"""size(string self) -> std::basic_string< char >::size_type"""
        return _libcombine.string_size(self)

    def swap(self, v):
        r"""swap(string self, string v)"""
        return _libcombine.string_swap(self, v)

    def erase(self, *args):
        r"""
        erase(string self, std::basic_string< char >::size_type __pos=0, std::basic_string< char >::size_type __n=std::basic_string< char >::npos) -> string
        erase(string self, std::basic_string< char >::iterator pos) -> std::basic_string< char >::iterator
        erase(string self, std::basic_string< char >::iterator first, std::basic_string< char >::iterator last) -> std::basic_string< char >::iterator
        """
        return _libcombine.string_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(string self, char const * __s, std::basic_string< char >::size_type __n) -> string
        __init__(string self) -> string
        __init__(string self, string other) -> string
        __init__(string self, std::basic_string< char >::size_type size, std::basic_string< char >::value_type value) -> string
        """
        _libcombine.string_swiginit(self, _libcombine.new_string(*args))

    def assign(self, *args):
        r"""
        assign(string self, string __str) -> string
        assign(string self, string __str, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> string
        assign(string self, char const * __s, std::basic_string< char >::size_type __n) -> string
        assign(string self, std::basic_string< char >::size_type n, std::basic_string< char >::value_type x)
        """
        return _libcombine.string_assign(self, *args)

    def resize(self, *args):
        r"""
        resize(string self, std::basic_string< char >::size_type new_size)
        resize(string self, std::basic_string< char >::size_type new_size, std::basic_string< char >::value_type x)
        """
        return _libcombine.string_resize(self, *args)

    def iterator(self):
        r"""iterator(string self) -> SwigPyIterator"""
        return _libcombine.string_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(string self) -> bool"""
        return _libcombine.string___nonzero__(self)

    def __bool__(self):
        r"""__bool__(string self) -> bool"""
        return _libcombine.string___bool__(self)

    def __len__(self):
        r"""__len__(string self) -> std::basic_string< char >::size_type"""
        return _libcombine.string___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j) -> string"""
        return _libcombine.string___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j)
        __setslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j, string v)
        """
        return _libcombine.string___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j)"""
        return _libcombine.string___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(string self, std::basic_string< char >::difference_type i)
        __delitem__(string self, PySliceObject * slice)
        """
        return _libcombine.string___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(string self, PySliceObject * slice) -> string
        __getitem__(string self, std::basic_string< char >::difference_type i) -> std::basic_string< char >::value_type
        """
        return _libcombine.string___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(string self, PySliceObject * slice, string v)
        __setitem__(string self, PySliceObject * slice)
        __setitem__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::value_type x)
        """
        return _libcombine.string___setitem__(self, *args)

    def insert(self, *args):
        r"""
        insert(string self, std::basic_string< char >::size_type __pos1, string __str) -> string
        insert(string self, std::basic_string< char >::size_type __pos1, string __str, std::basic_string< char >::size_type __pos2, std::basic_string< char >::size_type __n) -> string
        insert(string self, std::basic_string< char >::size_type __pos, char const * __s, std::basic_string< char >::size_type __n) -> string
        insert(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n, char __c) -> string
        insert(string self, std::basic_string< char >::iterator pos, std::basic_string< char >::value_type x) -> std::basic_string< char >::iterator
        insert(string self, std::basic_string< char >::iterator pos, std::basic_string< char >::size_type n, std::basic_string< char >::value_type x)
        insert(string self, std::basic_string< char >::iterator __p, std::basic_string< char >::size_type __n, char __c)
        """
        return _libcombine.string_insert(self, *args)

    def replace(self, *args):
        r"""
        replace(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n, string __str) -> string
        replace(string self, std::basic_string< char >::size_type __pos1, std::basic_string< char >::size_type __n1, string __str, std::basic_string< char >::size_type __pos2, std::basic_string< char >::size_type __n2) -> string
        replace(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n1, char const * __s, std::basic_string< char >::size_type __n2) -> string
        replace(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n1, std::basic_string< char >::size_type __n2, char __c) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, string __str) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, char const * __s, std::basic_string< char >::size_type __n) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, std::basic_string< char >::size_type __n, char __c) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, char const * __k1, char const * __k2) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, std::basic_string< char >::const_iterator __k1, std::basic_string< char >::const_iterator __k2) -> string
        """
        return _libcombine.string_replace(self, *args)

    def __iadd__(self, v):
        r"""__iadd__(string self, string v) -> string"""
        return _libcombine.string___iadd__(self, v)

    def __add__(self, v):
        r"""__add__(string self, string v) -> string"""
        return _libcombine.string___add__(self, v)

    def __radd__(self, v):
        r"""__radd__(string self, string v) -> string"""
        return _libcombine.string___radd__(self, v)

    def __str__(self):
        r"""__str__(string self) -> string"""
        return _libcombine.string___str__(self)

    def __rlshift__(self, out):
        r"""__rlshift__(string self, ostream out) -> ostream"""
        return _libcombine.string___rlshift__(self, out)

    def __eq__(self, v):
        r"""__eq__(string self, string v) -> bool"""
        return _libcombine.string___eq__(self, v)

    def __ne__(self, v):
        r"""__ne__(string self, string v) -> bool"""
        return _libcombine.string___ne__(self, v)

    def __gt__(self, v):
        r"""__gt__(string self, string v) -> bool"""
        return _libcombine.string___gt__(self, v)

    def __lt__(self, v):
        r"""__lt__(string self, string v) -> bool"""
        return _libcombine.string___lt__(self, v)

    def __ge__(self, v):
        r"""__ge__(string self, string v) -> bool"""
        return _libcombine.string___ge__(self, v)

    def __le__(self, v):
        r"""__le__(string self, string v) -> bool"""
        return _libcombine.string___le__(self, v)
    __swig_destroy__ = _libcombine.delete_string

# Register string in _libcombine:
_libcombine.string_swigregister(string)
cvar = _libcombine.cvar
string.npos = _libcombine.cvar.string_npos

class ostream(object):
    r"""Proxy of C++ std::basic_ostream< char > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        r"""__init__(ostream self, std::basic_streambuf< char,std::char_traits< char > > * __sb) -> ostream"""
        _libcombine.ostream_swiginit(self, _libcombine.new_ostream(__sb))
    __swig_destroy__ = _libcombine.delete_ostream

# Register ostream in _libcombine:
_libcombine.ostream_swigregister(ostream)

class ostringstream(ostream):
    r"""Proxy of C++ std::basic_ostringstream< char > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(ostringstream self, std::ios_base::openmode __mode=std::ios_base::out) -> ostringstream"""
        _libcombine.ostringstream_swiginit(self, _libcombine.new_ostringstream(*args))
    __swig_destroy__ = _libcombine.delete_ostringstream

    def str(self, *args):
        r"""
        str(ostringstream self) -> string
        str(ostringstream self, string __s)
        """
        return _libcombine.ostringstream_str(self, *args)

# Register ostringstream in _libcombine:
_libcombine.ostringstream_swigregister(ostringstream)


def endl(arg1):
    r"""endl(ostream arg1) -> ostream"""
    return _libcombine.endl(arg1)

def flush(arg1):
    r"""flush(ostream arg1) -> ostream"""
    return _libcombine.flush(arg1)

import sys
import os.path

# @cond doxygen-libsedml-internal

def conditional_abspath (filename):
  """conditional_abspath (filename) -> filename

  Returns filename with an absolute path prepended, if necessary.
  Some combinations of platforms and underlying XML parsers *require*
  an absolute path to a filename while others do not.  This function
  encapsulates the appropriate logic.  It is used by readCaML() and
  CaReader.readCaML().
  """
  if sys.platform.find('cygwin') != -1:
    return filename
  else:
    return os.path.abspath(filename)

# @endcond


def readOMEX(*args):
  """
  readOMEX(self, string filename) -> CaOmexManifest

  Reads an SEDML document from a file.

  This method is identical to readOMEXFromFile().

  If the file named 'filename' does not exist or its content is not
  valid SEDML, one or more errors will be logged with the CaOmexManifest
  object returned by this method.  Callers can use the methods on
  CaOmexManifest such as CaOmexManifest.getNumErrors() and
  CaOmexManifest.getError() to get the errors.  The object returned by
  CaOmexManifest.getError() is an CaError object, and it has methods to
  get the error code, category, and severity level of the problem, as
  well as a textual description of the problem.  The possible severity
  levels range from informational messages to fatal errors; see the
  documentation for CaError for more information.

  If the file 'filename' could not be read, the file-reading error will
  appear first.  The error code can provide a clue about what happened.
  For example, a file might be unreadable (either because it does not
  actually exist or because the user does not have the necessary access
  priviledges to read it) or some sort of file operation error may have
  been reported by the underlying operating system.  Callers can check
  for these situations using a program fragment such as the following:

   reader = CaReader()
   doc    = reader.readOMEX(filename)

   if doc.getNumErrors() > 0:
     if doc.getError(0).getErrorId() == libsedml.XMLFileUnreadable:
# Handle case of unreadable file here.
     elif doc.getError(0).getErrorId() == libsedml.XMLFileOperationError:
# Handle case of other file error here.
     else:
# Handle other error cases here.

  If the given filename ends with the suffix \".gz\" (for example,
  \"myfile.xml.gz\"), the file is assumed to be compressed in gzip format
  and will be automatically decompressed upon reading.  Similarly, if the
  given filename ends with \".zip\" or \".bz2\", the file is assumed to be
  compressed in zip or bzip2 format (respectively).  Files whose names
  lack these suffixes will be read uncompressed.  Note that if the file
  is in zip format but the archive contains more than one file, only the
  first file in the archive will be read and the rest ignored.

  To read a gzip/zip file, libSEDML needs to be configured and linked with
  the zlib library at compile time.  It also needs to be linked with the
  bzip2 library to read files in bzip2 format.  (Both of these are the
  default configurations for libSEDML.)  Errors about unreadable files
  will be logged if a compressed filename is given and libSEDML was not
  linked with the corresponding required library.

  Parameter 'filename is the name or full pathname of the file to be
  read.

  Returns a pointer to the CaOmexManifest created from the SEDML content.

  See also CaError.

  Note:

  LibSEDML versions 2.x and later versions behave differently in
  error handling in several respects.  One difference is how early some
  errors are caught and whether libSEDML continues processing a file in
  the face of some early errors.  In general, libSEDML versions after 2.x
  stop parsing SEDML inputs sooner than libSEDML version 2.x in the face
  of XML errors, because the errors may invalidate any further SEDML
  content.  For example, a missing XML declaration at the beginning of
  the file was ignored by libSEDML 2.x but in version 3.x and later, it
  will cause libSEDML to stop parsing the rest of the input altogether.
  While this behavior may seem more severe and intolerant, it was
  necessary in order to provide uniform behavior regardless of which
  underlying XML parser (Expat, Xerces, libxml2) is being used by
  libSEDML.  The XML parsers themselves behave differently in their error
  reporting, and sometimes libSEDML has to resort to the lowest common
  denominator.
  """
  reader = CaReader()
  return reader.readOMEX(args[0])

class DoubleStdVector(object):
    r"""Proxy of C++ std::vector< double > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(DoubleStdVector self) -> SwigPyIterator"""
        return _libcombine.DoubleStdVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(DoubleStdVector self) -> bool"""
        return _libcombine.DoubleStdVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(DoubleStdVector self) -> bool"""
        return _libcombine.DoubleStdVector___bool__(self)

    def __len__(self):
        r"""__len__(DoubleStdVector self) -> std::vector< double >::size_type"""
        return _libcombine.DoubleStdVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(DoubleStdVector self, std::vector< double >::difference_type i, std::vector< double >::difference_type j) -> DoubleStdVector"""
        return _libcombine.DoubleStdVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(DoubleStdVector self, std::vector< double >::difference_type i, std::vector< double >::difference_type j)
        __setslice__(DoubleStdVector self, std::vector< double >::difference_type i, std::vector< double >::difference_type j, DoubleStdVector v)
        """
        return _libcombine.DoubleStdVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(DoubleStdVector self, std::vector< double >::difference_type i, std::vector< double >::difference_type j)"""
        return _libcombine.DoubleStdVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(DoubleStdVector self, std::vector< double >::difference_type i)
        __delitem__(DoubleStdVector self, PySliceObject * slice)
        """
        return _libcombine.DoubleStdVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(DoubleStdVector self, PySliceObject * slice) -> DoubleStdVector
        __getitem__(DoubleStdVector self, std::vector< double >::difference_type i) -> std::vector< double >::value_type const &
        """
        return _libcombine.DoubleStdVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(DoubleStdVector self, PySliceObject * slice, DoubleStdVector v)
        __setitem__(DoubleStdVector self, PySliceObject * slice)
        __setitem__(DoubleStdVector self, std::vector< double >::difference_type i, std::vector< double >::value_type const & x)
        """
        return _libcombine.DoubleStdVector___setitem__(self, *args)

    def pop(self):
        r"""pop(DoubleStdVector self) -> std::vector< double >::value_type"""
        return _libcombine.DoubleStdVector_pop(self)

    def append(self, x):
        r"""append(DoubleStdVector self, std::vector< double >::value_type const & x)"""
        return _libcombine.DoubleStdVector_append(self, x)

    def empty(self):
        r"""empty(DoubleStdVector self) -> bool"""
        return _libcombine.DoubleStdVector_empty(self)

    def size(self):
        r"""size(DoubleStdVector self) -> std::vector< double >::size_type"""
        return _libcombine.DoubleStdVector_size(self)

    def swap(self, v):
        r"""swap(DoubleStdVector self, DoubleStdVector v)"""
        return _libcombine.DoubleStdVector_swap(self, v)

    def begin(self):
        r"""begin(DoubleStdVector self) -> std::vector< double >::iterator"""
        return _libcombine.DoubleStdVector_begin(self)

    def end(self):
        r"""end(DoubleStdVector self) -> std::vector< double >::iterator"""
        return _libcombine.DoubleStdVector_end(self)

    def rbegin(self):
        r"""rbegin(DoubleStdVector self) -> std::vector< double >::reverse_iterator"""
        return _libcombine.DoubleStdVector_rbegin(self)

    def rend(self):
        r"""rend(DoubleStdVector self) -> std::vector< double >::reverse_iterator"""
        return _libcombine.DoubleStdVector_rend(self)

    def clear(self):
        r"""clear(DoubleStdVector self)"""
        return _libcombine.DoubleStdVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(DoubleStdVector self) -> std::vector< double >::allocator_type"""
        return _libcombine.DoubleStdVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(DoubleStdVector self)"""
        return _libcombine.DoubleStdVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(DoubleStdVector self, std::vector< double >::iterator pos) -> std::vector< double >::iterator
        erase(DoubleStdVector self, std::vector< double >::iterator first, std::vector< double >::iterator last) -> std::vector< double >::iterator
        """
        return _libcombine.DoubleStdVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(DoubleStdVector self) -> DoubleStdVector
        __init__(DoubleStdVector self, DoubleStdVector other) -> DoubleStdVector
        __init__(DoubleStdVector self, std::vector< double >::size_type size) -> DoubleStdVector
        __init__(DoubleStdVector self, std::vector< double >::size_type size, std::vector< double >::value_type const & value) -> DoubleStdVector
        """
        _libcombine.DoubleStdVector_swiginit(self, _libcombine.new_DoubleStdVector(*args))

    def push_back(self, x):
        r"""push_back(DoubleStdVector self, std::vector< double >::value_type const & x)"""
        return _libcombine.DoubleStdVector_push_back(self, x)

    def front(self):
        r"""front(DoubleStdVector self) -> std::vector< double >::value_type const &"""
        return _libcombine.DoubleStdVector_front(self)

    def back(self):
        r"""back(DoubleStdVector self) -> std::vector< double >::value_type const &"""
        return _libcombine.DoubleStdVector_back(self)

    def assign(self, n, x):
        r"""assign(DoubleStdVector self, std::vector< double >::size_type n, std::vector< double >::value_type const & x)"""
        return _libcombine.DoubleStdVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(DoubleStdVector self, std::vector< double >::size_type new_size)
        resize(DoubleStdVector self, std::vector< double >::size_type new_size, std::vector< double >::value_type const & x)
        """
        return _libcombine.DoubleStdVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(DoubleStdVector self, std::vector< double >::iterator pos, std::vector< double >::value_type const & x) -> std::vector< double >::iterator
        insert(DoubleStdVector self, std::vector< double >::iterator pos, std::vector< double >::size_type n, std::vector< double >::value_type const & x)
        """
        return _libcombine.DoubleStdVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(DoubleStdVector self, std::vector< double >::size_type n)"""
        return _libcombine.DoubleStdVector_reserve(self, n)

    def capacity(self):
        r"""capacity(DoubleStdVector self) -> std::vector< double >::size_type"""
        return _libcombine.DoubleStdVector_capacity(self)
    __swig_destroy__ = _libcombine.delete_DoubleStdVector

# Register DoubleStdVector in _libcombine:
_libcombine.DoubleStdVector_swigregister(DoubleStdVector)
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

class XmlErrorStdVector(object):
    r"""Proxy of C++ std::vector< XMLError * > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(XmlErrorStdVector self) -> SwigPyIterator"""
        return _libcombine.XmlErrorStdVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(XmlErrorStdVector self) -> bool"""
        return _libcombine.XmlErrorStdVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(XmlErrorStdVector self) -> bool"""
        return _libcombine.XmlErrorStdVector___bool__(self)

    def __len__(self):
        r"""__len__(XmlErrorStdVector self) -> std::vector< XMLError * >::size_type"""
        return _libcombine.XmlErrorStdVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(XmlErrorStdVector self, std::vector< XMLError * >::difference_type i, std::vector< XMLError * >::difference_type j) -> XmlErrorStdVector"""
        return _libcombine.XmlErrorStdVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(XmlErrorStdVector self, std::vector< XMLError * >::difference_type i, std::vector< XMLError * >::difference_type j)
        __setslice__(XmlErrorStdVector self, std::vector< XMLError * >::difference_type i, std::vector< XMLError * >::difference_type j, XmlErrorStdVector v)
        """
        return _libcombine.XmlErrorStdVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(XmlErrorStdVector self, std::vector< XMLError * >::difference_type i, std::vector< XMLError * >::difference_type j)"""
        return _libcombine.XmlErrorStdVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(XmlErrorStdVector self, std::vector< XMLError * >::difference_type i)
        __delitem__(XmlErrorStdVector self, PySliceObject * slice)
        """
        return _libcombine.XmlErrorStdVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(XmlErrorStdVector self, PySliceObject * slice) -> XmlErrorStdVector
        __getitem__(XmlErrorStdVector self, std::vector< XMLError * >::difference_type i) -> XMLError
        """
        return _libcombine.XmlErrorStdVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(XmlErrorStdVector self, PySliceObject * slice, XmlErrorStdVector v)
        __setitem__(XmlErrorStdVector self, PySliceObject * slice)
        __setitem__(XmlErrorStdVector self, std::vector< XMLError * >::difference_type i, XMLError x)
        """
        return _libcombine.XmlErrorStdVector___setitem__(self, *args)

    def pop(self):
        r"""pop(XmlErrorStdVector self) -> XMLError"""
        return _libcombine.XmlErrorStdVector_pop(self)

    def append(self, x):
        r"""append(XmlErrorStdVector self, XMLError x)"""
        return _libcombine.XmlErrorStdVector_append(self, x)

    def empty(self):
        r"""empty(XmlErrorStdVector self) -> bool"""
        return _libcombine.XmlErrorStdVector_empty(self)

    def size(self):
        r"""size(XmlErrorStdVector self) -> std::vector< XMLError * >::size_type"""
        return _libcombine.XmlErrorStdVector_size(self)

    def swap(self, v):
        r"""swap(XmlErrorStdVector self, XmlErrorStdVector v)"""
        return _libcombine.XmlErrorStdVector_swap(self, v)

    def begin(self):
        r"""begin(XmlErrorStdVector self) -> std::vector< XMLError * >::iterator"""
        return _libcombine.XmlErrorStdVector_begin(self)

    def end(self):
        r"""end(XmlErrorStdVector self) -> std::vector< XMLError * >::iterator"""
        return _libcombine.XmlErrorStdVector_end(self)

    def rbegin(self):
        r"""rbegin(XmlErrorStdVector self) -> std::vector< XMLError * >::reverse_iterator"""
        return _libcombine.XmlErrorStdVector_rbegin(self)

    def rend(self):
        r"""rend(XmlErrorStdVector self) -> std::vector< XMLError * >::reverse_iterator"""
        return _libcombine.XmlErrorStdVector_rend(self)

    def clear(self):
        r"""clear(XmlErrorStdVector self)"""
        return _libcombine.XmlErrorStdVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(XmlErrorStdVector self) -> std::vector< XMLError * >::allocator_type"""
        return _libcombine.XmlErrorStdVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(XmlErrorStdVector self)"""
        return _libcombine.XmlErrorStdVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(XmlErrorStdVector self, std::vector< XMLError * >::iterator pos) -> std::vector< XMLError * >::iterator
        erase(XmlErrorStdVector self, std::vector< XMLError * >::iterator first, std::vector< XMLError * >::iterator last) -> std::vector< XMLError * >::iterator
        """
        return _libcombine.XmlErrorStdVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(XmlErrorStdVector self) -> XmlErrorStdVector
        __init__(XmlErrorStdVector self, XmlErrorStdVector other) -> XmlErrorStdVector
        __init__(XmlErrorStdVector self, std::vector< XMLError * >::size_type size) -> XmlErrorStdVector
        __init__(XmlErrorStdVector self, std::vector< XMLError * >::size_type size, XMLError value) -> XmlErrorStdVector
        """
        _libcombine.XmlErrorStdVector_swiginit(self, _libcombine.new_XmlErrorStdVector(*args))

    def push_back(self, x):
        r"""push_back(XmlErrorStdVector self, XMLError x)"""
        return _libcombine.XmlErrorStdVector_push_back(self, x)

    def front(self):
        r"""front(XmlErrorStdVector self) -> XMLError"""
        return _libcombine.XmlErrorStdVector_front(self)

    def back(self):
        r"""back(XmlErrorStdVector self) -> XMLError"""
        return _libcombine.XmlErrorStdVector_back(self)

    def assign(self, n, x):
        r"""assign(XmlErrorStdVector self, std::vector< XMLError * >::size_type n, XMLError x)"""
        return _libcombine.XmlErrorStdVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(XmlErrorStdVector self, std::vector< XMLError * >::size_type new_size)
        resize(XmlErrorStdVector self, std::vector< XMLError * >::size_type new_size, XMLError x)
        """
        return _libcombine.XmlErrorStdVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(XmlErrorStdVector self, std::vector< XMLError * >::iterator pos, XMLError x) -> std::vector< XMLError * >::iterator
        insert(XmlErrorStdVector self, std::vector< XMLError * >::iterator pos, std::vector< XMLError * >::size_type n, XMLError x)
        """
        return _libcombine.XmlErrorStdVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(XmlErrorStdVector self, std::vector< XMLError * >::size_type n)"""
        return _libcombine.XmlErrorStdVector_reserve(self, n)

    def capacity(self):
        r"""capacity(XmlErrorStdVector self) -> std::vector< XMLError * >::size_type"""
        return _libcombine.XmlErrorStdVector_capacity(self)
    __swig_destroy__ = _libcombine.delete_XmlErrorStdVector

# Register XmlErrorStdVector in _libcombine:
_libcombine.XmlErrorStdVector_swigregister(XmlErrorStdVector)

class CaErrorStdVector(object):
    r"""Proxy of C++ std::vector< CaError > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(CaErrorStdVector self) -> SwigPyIterator"""
        return _libcombine.CaErrorStdVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(CaErrorStdVector self) -> bool"""
        return _libcombine.CaErrorStdVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(CaErrorStdVector self) -> bool"""
        return _libcombine.CaErrorStdVector___bool__(self)

    def __len__(self):
        r"""__len__(CaErrorStdVector self) -> std::vector< CaError >::size_type"""
        return _libcombine.CaErrorStdVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(CaErrorStdVector self, std::vector< CaError >::difference_type i, std::vector< CaError >::difference_type j) -> CaErrorStdVector"""
        return _libcombine.CaErrorStdVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(CaErrorStdVector self, std::vector< CaError >::difference_type i, std::vector< CaError >::difference_type j)
        __setslice__(CaErrorStdVector self, std::vector< CaError >::difference_type i, std::vector< CaError >::difference_type j, CaErrorStdVector v)
        """
        return _libcombine.CaErrorStdVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(CaErrorStdVector self, std::vector< CaError >::difference_type i, std::vector< CaError >::difference_type j)"""
        return _libcombine.CaErrorStdVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(CaErrorStdVector self, std::vector< CaError >::difference_type i)
        __delitem__(CaErrorStdVector self, PySliceObject * slice)
        """
        return _libcombine.CaErrorStdVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(CaErrorStdVector self, PySliceObject * slice) -> CaErrorStdVector
        __getitem__(CaErrorStdVector self, std::vector< CaError >::difference_type i) -> CaError
        """
        return _libcombine.CaErrorStdVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(CaErrorStdVector self, PySliceObject * slice, CaErrorStdVector v)
        __setitem__(CaErrorStdVector self, PySliceObject * slice)
        __setitem__(CaErrorStdVector self, std::vector< CaError >::difference_type i, CaError x)
        """
        return _libcombine.CaErrorStdVector___setitem__(self, *args)

    def pop(self):
        r"""pop(CaErrorStdVector self) -> CaError"""
        return _libcombine.CaErrorStdVector_pop(self)

    def append(self, x):
        r"""append(CaErrorStdVector self, CaError x)"""
        return _libcombine.CaErrorStdVector_append(self, x)

    def empty(self):
        r"""empty(CaErrorStdVector self) -> bool"""
        return _libcombine.CaErrorStdVector_empty(self)

    def size(self):
        r"""size(CaErrorStdVector self) -> std::vector< CaError >::size_type"""
        return _libcombine.CaErrorStdVector_size(self)

    def swap(self, v):
        r"""swap(CaErrorStdVector self, CaErrorStdVector v)"""
        return _libcombine.CaErrorStdVector_swap(self, v)

    def begin(self):
        r"""begin(CaErrorStdVector self) -> std::vector< CaError >::iterator"""
        return _libcombine.CaErrorStdVector_begin(self)

    def end(self):
        r"""end(CaErrorStdVector self) -> std::vector< CaError >::iterator"""
        return _libcombine.CaErrorStdVector_end(self)

    def rbegin(self):
        r"""rbegin(CaErrorStdVector self) -> std::vector< CaError >::reverse_iterator"""
        return _libcombine.CaErrorStdVector_rbegin(self)

    def rend(self):
        r"""rend(CaErrorStdVector self) -> std::vector< CaError >::reverse_iterator"""
        return _libcombine.CaErrorStdVector_rend(self)

    def clear(self):
        r"""clear(CaErrorStdVector self)"""
        return _libcombine.CaErrorStdVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(CaErrorStdVector self) -> std::vector< CaError >::allocator_type"""
        return _libcombine.CaErrorStdVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(CaErrorStdVector self)"""
        return _libcombine.CaErrorStdVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(CaErrorStdVector self, std::vector< CaError >::iterator pos) -> std::vector< CaError >::iterator
        erase(CaErrorStdVector self, std::vector< CaError >::iterator first, std::vector< CaError >::iterator last) -> std::vector< CaError >::iterator
        """
        return _libcombine.CaErrorStdVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(CaErrorStdVector self) -> CaErrorStdVector
        __init__(CaErrorStdVector self, CaErrorStdVector other) -> CaErrorStdVector
        __init__(CaErrorStdVector self, std::vector< CaError >::size_type size) -> CaErrorStdVector
        __init__(CaErrorStdVector self, std::vector< CaError >::size_type size, CaError value) -> CaErrorStdVector
        """
        _libcombine.CaErrorStdVector_swiginit(self, _libcombine.new_CaErrorStdVector(*args))

    def push_back(self, x):
        r"""push_back(CaErrorStdVector self, CaError x)"""
        return _libcombine.CaErrorStdVector_push_back(self, x)

    def front(self):
        r"""front(CaErrorStdVector self) -> CaError"""
        return _libcombine.CaErrorStdVector_front(self)

    def back(self):
        r"""back(CaErrorStdVector self) -> CaError"""
        return _libcombine.CaErrorStdVector_back(self)

    def assign(self, n, x):
        r"""assign(CaErrorStdVector self, std::vector< CaError >::size_type n, CaError x)"""
        return _libcombine.CaErrorStdVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(CaErrorStdVector self, std::vector< CaError >::size_type new_size)
        resize(CaErrorStdVector self, std::vector< CaError >::size_type new_size, CaError x)
        """
        return _libcombine.CaErrorStdVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(CaErrorStdVector self, std::vector< CaError >::iterator pos, CaError x) -> std::vector< CaError >::iterator
        insert(CaErrorStdVector self, std::vector< CaError >::iterator pos, std::vector< CaError >::size_type n, CaError x)
        """
        return _libcombine.CaErrorStdVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(CaErrorStdVector self, std::vector< CaError >::size_type n)"""
        return _libcombine.CaErrorStdVector_reserve(self, n)

    def capacity(self):
        r"""capacity(CaErrorStdVector self) -> std::vector< CaError >::size_type"""
        return _libcombine.CaErrorStdVector_capacity(self)
    __swig_destroy__ = _libcombine.delete_CaErrorStdVector

# Register CaErrorStdVector in _libcombine:
_libcombine.CaErrorStdVector_swigregister(CaErrorStdVector)

class StringVector(object):
    r"""Proxy of C++ std::vector< std::string > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(StringVector self) -> SwigPyIterator"""
        return _libcombine.StringVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(StringVector self) -> bool"""
        return _libcombine.StringVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(StringVector self) -> bool"""
        return _libcombine.StringVector___bool__(self)

    def __len__(self):
        r"""__len__(StringVector self) -> std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::size_type"""
        return _libcombine.StringVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::difference_type i, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::difference_type j) -> StringVector"""
        return _libcombine.StringVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::difference_type i, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::difference_type j)
        __setslice__(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::difference_type i, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::difference_type j, StringVector v)
        """
        return _libcombine.StringVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::difference_type i, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::difference_type j)"""
        return _libcombine.StringVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::difference_type i)
        __delitem__(StringVector self, PySliceObject * slice)
        """
        return _libcombine.StringVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(StringVector self, PySliceObject * slice) -> StringVector
        __getitem__(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::difference_type i) -> string
        """
        return _libcombine.StringVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(StringVector self, PySliceObject * slice, StringVector v)
        __setitem__(StringVector self, PySliceObject * slice)
        __setitem__(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::difference_type i, string x)
        """
        return _libcombine.StringVector___setitem__(self, *args)

    def pop(self):
        r"""pop(StringVector self) -> string"""
        return _libcombine.StringVector_pop(self)

    def append(self, x):
        r"""append(StringVector self, string x)"""
        return _libcombine.StringVector_append(self, x)

    def empty(self):
        r"""empty(StringVector self) -> bool"""
        return _libcombine.StringVector_empty(self)

    def size(self):
        r"""size(StringVector self) -> std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::size_type"""
        return _libcombine.StringVector_size(self)

    def swap(self, v):
        r"""swap(StringVector self, StringVector v)"""
        return _libcombine.StringVector_swap(self, v)

    def begin(self):
        r"""begin(StringVector self) -> std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::iterator"""
        return _libcombine.StringVector_begin(self)

    def end(self):
        r"""end(StringVector self) -> std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::iterator"""
        return _libcombine.StringVector_end(self)

    def rbegin(self):
        r"""rbegin(StringVector self) -> std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::reverse_iterator"""
        return _libcombine.StringVector_rbegin(self)

    def rend(self):
        r"""rend(StringVector self) -> std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::reverse_iterator"""
        return _libcombine.StringVector_rend(self)

    def clear(self):
        r"""clear(StringVector self)"""
        return _libcombine.StringVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(StringVector self) -> std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::allocator_type"""
        return _libcombine.StringVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(StringVector self)"""
        return _libcombine.StringVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::iterator pos) -> std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::iterator
        erase(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::iterator first, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::iterator last) -> std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::iterator
        """
        return _libcombine.StringVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(StringVector self) -> StringVector
        __init__(StringVector self, StringVector other) -> StringVector
        __init__(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::size_type size) -> StringVector
        __init__(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::size_type size, string value) -> StringVector
        """
        _libcombine.StringVector_swiginit(self, _libcombine.new_StringVector(*args))

    def push_back(self, x):
        r"""push_back(StringVector self, string x)"""
        return _libcombine.StringVector_push_back(self, x)

    def front(self):
        r"""front(StringVector self) -> string"""
        return _libcombine.StringVector_front(self)

    def back(self):
        r"""back(StringVector self) -> string"""
        return _libcombine.StringVector_back(self)

    def assign(self, n, x):
        r"""assign(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::size_type n, string x)"""
        return _libcombine.StringVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::size_type new_size)
        resize(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::size_type new_size, string x)
        """
        return _libcombine.StringVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::iterator pos, string x) -> std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::iterator
        insert(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::iterator pos, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::size_type n, string x)
        """
        return _libcombine.StringVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(StringVector self, std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::size_type n)"""
        return _libcombine.StringVector_reserve(self, n)

    def capacity(self):
        r"""capacity(StringVector self) -> std::vector< std::basic_string< char,std::char_traits< char >,std::allocator< char > > >::size_type"""
        return _libcombine.StringVector_capacity(self)
    __swig_destroy__ = _libcombine.delete_StringVector

# Register StringVector in _libcombine:
_libcombine.StringVector_swigregister(StringVector)

class VCardVector(object):
    r"""Proxy of C++ std::vector< VCard > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(VCardVector self) -> SwigPyIterator"""
        return _libcombine.VCardVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(VCardVector self) -> bool"""
        return _libcombine.VCardVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(VCardVector self) -> bool"""
        return _libcombine.VCardVector___bool__(self)

    def __len__(self):
        r"""__len__(VCardVector self) -> std::vector< VCard >::size_type"""
        return _libcombine.VCardVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(VCardVector self, std::vector< VCard >::difference_type i, std::vector< VCard >::difference_type j) -> VCardVector"""
        return _libcombine.VCardVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(VCardVector self, std::vector< VCard >::difference_type i, std::vector< VCard >::difference_type j)
        __setslice__(VCardVector self, std::vector< VCard >::difference_type i, std::vector< VCard >::difference_type j, VCardVector v)
        """
        return _libcombine.VCardVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(VCardVector self, std::vector< VCard >::difference_type i, std::vector< VCard >::difference_type j)"""
        return _libcombine.VCardVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(VCardVector self, std::vector< VCard >::difference_type i)
        __delitem__(VCardVector self, PySliceObject * slice)
        """
        return _libcombine.VCardVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(VCardVector self, PySliceObject * slice) -> VCardVector
        __getitem__(VCardVector self, std::vector< VCard >::difference_type i) -> VCard
        """
        return _libcombine.VCardVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(VCardVector self, PySliceObject * slice, VCardVector v)
        __setitem__(VCardVector self, PySliceObject * slice)
        __setitem__(VCardVector self, std::vector< VCard >::difference_type i, VCard x)
        """
        return _libcombine.VCardVector___setitem__(self, *args)

    def pop(self):
        r"""pop(VCardVector self) -> VCard"""
        return _libcombine.VCardVector_pop(self)

    def append(self, x):
        r"""append(VCardVector self, VCard x)"""
        return _libcombine.VCardVector_append(self, x)

    def empty(self):
        r"""empty(VCardVector self) -> bool"""
        return _libcombine.VCardVector_empty(self)

    def size(self):
        r"""size(VCardVector self) -> std::vector< VCard >::size_type"""
        return _libcombine.VCardVector_size(self)

    def swap(self, v):
        r"""swap(VCardVector self, VCardVector v)"""
        return _libcombine.VCardVector_swap(self, v)

    def begin(self):
        r"""begin(VCardVector self) -> std::vector< VCard >::iterator"""
        return _libcombine.VCardVector_begin(self)

    def end(self):
        r"""end(VCardVector self) -> std::vector< VCard >::iterator"""
        return _libcombine.VCardVector_end(self)

    def rbegin(self):
        r"""rbegin(VCardVector self) -> std::vector< VCard >::reverse_iterator"""
        return _libcombine.VCardVector_rbegin(self)

    def rend(self):
        r"""rend(VCardVector self) -> std::vector< VCard >::reverse_iterator"""
        return _libcombine.VCardVector_rend(self)

    def clear(self):
        r"""clear(VCardVector self)"""
        return _libcombine.VCardVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(VCardVector self) -> std::vector< VCard >::allocator_type"""
        return _libcombine.VCardVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(VCardVector self)"""
        return _libcombine.VCardVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(VCardVector self, std::vector< VCard >::iterator pos) -> std::vector< VCard >::iterator
        erase(VCardVector self, std::vector< VCard >::iterator first, std::vector< VCard >::iterator last) -> std::vector< VCard >::iterator
        """
        return _libcombine.VCardVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(VCardVector self) -> VCardVector
        __init__(VCardVector self, VCardVector other) -> VCardVector
        __init__(VCardVector self, std::vector< VCard >::size_type size) -> VCardVector
        __init__(VCardVector self, std::vector< VCard >::size_type size, VCard value) -> VCardVector
        """
        _libcombine.VCardVector_swiginit(self, _libcombine.new_VCardVector(*args))

    def push_back(self, x):
        r"""push_back(VCardVector self, VCard x)"""
        return _libcombine.VCardVector_push_back(self, x)

    def front(self):
        r"""front(VCardVector self) -> VCard"""
        return _libcombine.VCardVector_front(self)

    def back(self):
        r"""back(VCardVector self) -> VCard"""
        return _libcombine.VCardVector_back(self)

    def assign(self, n, x):
        r"""assign(VCardVector self, std::vector< VCard >::size_type n, VCard x)"""
        return _libcombine.VCardVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(VCardVector self, std::vector< VCard >::size_type new_size)
        resize(VCardVector self, std::vector< VCard >::size_type new_size, VCard x)
        """
        return _libcombine.VCardVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(VCardVector self, std::vector< VCard >::iterator pos, VCard x) -> std::vector< VCard >::iterator
        insert(VCardVector self, std::vector< VCard >::iterator pos, std::vector< VCard >::size_type n, VCard x)
        """
        return _libcombine.VCardVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(VCardVector self, std::vector< VCard >::size_type n)"""
        return _libcombine.VCardVector_reserve(self, n)

    def capacity(self):
        r"""capacity(VCardVector self) -> std::vector< VCard >::size_type"""
        return _libcombine.VCardVector_capacity(self)
    __swig_destroy__ = _libcombine.delete_VCardVector

# Register VCardVector in _libcombine:
_libcombine.VCardVector_swigregister(VCardVector)

class MetadataVector(object):
    r"""Proxy of C++ std::vector< OmexDescription > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(MetadataVector self) -> SwigPyIterator"""
        return _libcombine.MetadataVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(MetadataVector self) -> bool"""
        return _libcombine.MetadataVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(MetadataVector self) -> bool"""
        return _libcombine.MetadataVector___bool__(self)

    def __len__(self):
        r"""__len__(MetadataVector self) -> std::vector< OmexDescription >::size_type"""
        return _libcombine.MetadataVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(MetadataVector self, std::vector< OmexDescription >::difference_type i, std::vector< OmexDescription >::difference_type j) -> MetadataVector"""
        return _libcombine.MetadataVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(MetadataVector self, std::vector< OmexDescription >::difference_type i, std::vector< OmexDescription >::difference_type j)
        __setslice__(MetadataVector self, std::vector< OmexDescription >::difference_type i, std::vector< OmexDescription >::difference_type j, MetadataVector v)
        """
        return _libcombine.MetadataVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(MetadataVector self, std::vector< OmexDescription >::difference_type i, std::vector< OmexDescription >::difference_type j)"""
        return _libcombine.MetadataVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(MetadataVector self, std::vector< OmexDescription >::difference_type i)
        __delitem__(MetadataVector self, PySliceObject * slice)
        """
        return _libcombine.MetadataVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(MetadataVector self, PySliceObject * slice) -> MetadataVector
        __getitem__(MetadataVector self, std::vector< OmexDescription >::difference_type i) -> OmexDescription
        """
        return _libcombine.MetadataVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(MetadataVector self, PySliceObject * slice, MetadataVector v)
        __setitem__(MetadataVector self, PySliceObject * slice)
        __setitem__(MetadataVector self, std::vector< OmexDescription >::difference_type i, OmexDescription x)
        """
        return _libcombine.MetadataVector___setitem__(self, *args)

    def pop(self):
        r"""pop(MetadataVector self) -> OmexDescription"""
        return _libcombine.MetadataVector_pop(self)

    def append(self, x):
        r"""append(MetadataVector self, OmexDescription x)"""
        return _libcombine.MetadataVector_append(self, x)

    def empty(self):
        r"""empty(MetadataVector self) -> bool"""
        return _libcombine.MetadataVector_empty(self)

    def size(self):
        r"""size(MetadataVector self) -> std::vector< OmexDescription >::size_type"""
        return _libcombine.MetadataVector_size(self)

    def swap(self, v):
        r"""swap(MetadataVector self, MetadataVector v)"""
        return _libcombine.MetadataVector_swap(self, v)

    def begin(self):
        r"""begin(MetadataVector self) -> std::vector< OmexDescription >::iterator"""
        return _libcombine.MetadataVector_begin(self)

    def end(self):
        r"""end(MetadataVector self) -> std::vector< OmexDescription >::iterator"""
        return _libcombine.MetadataVector_end(self)

    def rbegin(self):
        r"""rbegin(MetadataVector self) -> std::vector< OmexDescription >::reverse_iterator"""
        return _libcombine.MetadataVector_rbegin(self)

    def rend(self):
        r"""rend(MetadataVector self) -> std::vector< OmexDescription >::reverse_iterator"""
        return _libcombine.MetadataVector_rend(self)

    def clear(self):
        r"""clear(MetadataVector self)"""
        return _libcombine.MetadataVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(MetadataVector self) -> std::vector< OmexDescription >::allocator_type"""
        return _libcombine.MetadataVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(MetadataVector self)"""
        return _libcombine.MetadataVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(MetadataVector self, std::vector< OmexDescription >::iterator pos) -> std::vector< OmexDescription >::iterator
        erase(MetadataVector self, std::vector< OmexDescription >::iterator first, std::vector< OmexDescription >::iterator last) -> std::vector< OmexDescription >::iterator
        """
        return _libcombine.MetadataVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(MetadataVector self) -> MetadataVector
        __init__(MetadataVector self, MetadataVector other) -> MetadataVector
        __init__(MetadataVector self, std::vector< OmexDescription >::size_type size) -> MetadataVector
        __init__(MetadataVector self, std::vector< OmexDescription >::size_type size, OmexDescription value) -> MetadataVector
        """
        _libcombine.MetadataVector_swiginit(self, _libcombine.new_MetadataVector(*args))

    def push_back(self, x):
        r"""push_back(MetadataVector self, OmexDescription x)"""
        return _libcombine.MetadataVector_push_back(self, x)

    def front(self):
        r"""front(MetadataVector self) -> OmexDescription"""
        return _libcombine.MetadataVector_front(self)

    def back(self):
        r"""back(MetadataVector self) -> OmexDescription"""
        return _libcombine.MetadataVector_back(self)

    def assign(self, n, x):
        r"""assign(MetadataVector self, std::vector< OmexDescription >::size_type n, OmexDescription x)"""
        return _libcombine.MetadataVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(MetadataVector self, std::vector< OmexDescription >::size_type new_size)
        resize(MetadataVector self, std::vector< OmexDescription >::size_type new_size, OmexDescription x)
        """
        return _libcombine.MetadataVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(MetadataVector self, std::vector< OmexDescription >::iterator pos, OmexDescription x) -> std::vector< OmexDescription >::iterator
        insert(MetadataVector self, std::vector< OmexDescription >::iterator pos, std::vector< OmexDescription >::size_type n, OmexDescription x)
        """
        return _libcombine.MetadataVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(MetadataVector self, std::vector< OmexDescription >::size_type n)"""
        return _libcombine.MetadataVector_reserve(self, n)

    def capacity(self):
        r"""capacity(MetadataVector self) -> std::vector< OmexDescription >::size_type"""
        return _libcombine.MetadataVector_capacity(self)
    __swig_destroy__ = _libcombine.delete_MetadataVector

# Register MetadataVector in _libcombine:
_libcombine.MetadataVector_swigregister(MetadataVector)

class DateVector(object):
    r"""Proxy of C++ std::vector< Date > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(DateVector self) -> SwigPyIterator"""
        return _libcombine.DateVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(DateVector self) -> bool"""
        return _libcombine.DateVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(DateVector self) -> bool"""
        return _libcombine.DateVector___bool__(self)

    def __len__(self):
        r"""__len__(DateVector self) -> std::vector< Date >::size_type"""
        return _libcombine.DateVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(DateVector self, std::vector< Date >::difference_type i, std::vector< Date >::difference_type j) -> DateVector"""
        return _libcombine.DateVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(DateVector self, std::vector< Date >::difference_type i, std::vector< Date >::difference_type j)
        __setslice__(DateVector self, std::vector< Date >::difference_type i, std::vector< Date >::difference_type j, DateVector v)
        """
        return _libcombine.DateVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(DateVector self, std::vector< Date >::difference_type i, std::vector< Date >::difference_type j)"""
        return _libcombine.DateVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(DateVector self, std::vector< Date >::difference_type i)
        __delitem__(DateVector self, PySliceObject * slice)
        """
        return _libcombine.DateVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(DateVector self, PySliceObject * slice) -> DateVector
        __getitem__(DateVector self, std::vector< Date >::difference_type i) -> Date
        """
        return _libcombine.DateVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(DateVector self, PySliceObject * slice, DateVector v)
        __setitem__(DateVector self, PySliceObject * slice)
        __setitem__(DateVector self, std::vector< Date >::difference_type i, Date x)
        """
        return _libcombine.DateVector___setitem__(self, *args)

    def pop(self):
        r"""pop(DateVector self) -> Date"""
        return _libcombine.DateVector_pop(self)

    def append(self, x):
        r"""append(DateVector self, Date x)"""
        return _libcombine.DateVector_append(self, x)

    def empty(self):
        r"""empty(DateVector self) -> bool"""
        return _libcombine.DateVector_empty(self)

    def size(self):
        r"""size(DateVector self) -> std::vector< Date >::size_type"""
        return _libcombine.DateVector_size(self)

    def swap(self, v):
        r"""swap(DateVector self, DateVector v)"""
        return _libcombine.DateVector_swap(self, v)

    def begin(self):
        r"""begin(DateVector self) -> std::vector< Date >::iterator"""
        return _libcombine.DateVector_begin(self)

    def end(self):
        r"""end(DateVector self) -> std::vector< Date >::iterator"""
        return _libcombine.DateVector_end(self)

    def rbegin(self):
        r"""rbegin(DateVector self) -> std::vector< Date >::reverse_iterator"""
        return _libcombine.DateVector_rbegin(self)

    def rend(self):
        r"""rend(DateVector self) -> std::vector< Date >::reverse_iterator"""
        return _libcombine.DateVector_rend(self)

    def clear(self):
        r"""clear(DateVector self)"""
        return _libcombine.DateVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(DateVector self) -> std::vector< Date >::allocator_type"""
        return _libcombine.DateVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(DateVector self)"""
        return _libcombine.DateVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(DateVector self, std::vector< Date >::iterator pos) -> std::vector< Date >::iterator
        erase(DateVector self, std::vector< Date >::iterator first, std::vector< Date >::iterator last) -> std::vector< Date >::iterator
        """
        return _libcombine.DateVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(DateVector self) -> DateVector
        __init__(DateVector self, DateVector other) -> DateVector
        __init__(DateVector self, std::vector< Date >::size_type size) -> DateVector
        __init__(DateVector self, std::vector< Date >::size_type size, Date value) -> DateVector
        """
        _libcombine.DateVector_swiginit(self, _libcombine.new_DateVector(*args))

    def push_back(self, x):
        r"""push_back(DateVector self, Date x)"""
        return _libcombine.DateVector_push_back(self, x)

    def front(self):
        r"""front(DateVector self) -> Date"""
        return _libcombine.DateVector_front(self)

    def back(self):
        r"""back(DateVector self) -> Date"""
        return _libcombine.DateVector_back(self)

    def assign(self, n, x):
        r"""assign(DateVector self, std::vector< Date >::size_type n, Date x)"""
        return _libcombine.DateVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(DateVector self, std::vector< Date >::size_type new_size)
        resize(DateVector self, std::vector< Date >::size_type new_size, Date x)
        """
        return _libcombine.DateVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(DateVector self, std::vector< Date >::iterator pos, Date x) -> std::vector< Date >::iterator
        insert(DateVector self, std::vector< Date >::iterator pos, std::vector< Date >::size_type n, Date x)
        """
        return _libcombine.DateVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(DateVector self, std::vector< Date >::size_type n)"""
        return _libcombine.DateVector_reserve(self, n)

    def capacity(self):
        r"""capacity(DateVector self) -> std::vector< Date >::size_type"""
        return _libcombine.DateVector_capacity(self)
    __swig_destroy__ = _libcombine.delete_DateVector

# Register DateVector in _libcombine:
_libcombine.DateVector_swigregister(DateVector)

LIBCOMBINE_DOTTED_VERSION = _libcombine.LIBCOMBINE_DOTTED_VERSION

LIBCOMBINE_VERSION = _libcombine.LIBCOMBINE_VERSION

LIBCOMBINE_VERSION_STRING = _libcombine.LIBCOMBINE_VERSION_STRING


def getLibCombineVersion():
    r"""getLibCombineVersion() -> int"""
    return _libcombine.getLibCombineVersion()

def getLibCombineDottedVersion():
    r"""getLibCombineDottedVersion() -> char const *"""
    return _libcombine.getLibCombineDottedVersion()

def getLibCombineVersionString():
    r"""getLibCombineVersionString() -> char const *"""
    return _libcombine.getLibCombineVersionString()
LIBCOMBINE_OPERATION_SUCCESS = _libcombine.LIBCOMBINE_OPERATION_SUCCESS

LIBCOMBINE_INDEX_EXCEEDS_SIZE = _libcombine.LIBCOMBINE_INDEX_EXCEEDS_SIZE

LIBCOMBINE_UNEXPECTED_ATTRIBUTE = _libcombine.LIBCOMBINE_UNEXPECTED_ATTRIBUTE

LIBCOMBINE_OPERATION_FAILED = _libcombine.LIBCOMBINE_OPERATION_FAILED

LIBCOMBINE_INVALID_ATTRIBUTE_VALUE = _libcombine.LIBCOMBINE_INVALID_ATTRIBUTE_VALUE

LIBCOMBINE_INVALID_OBJECT = _libcombine.LIBCOMBINE_INVALID_OBJECT

LIBCOMBINE_DUPLICATE_OBJECT_ID = _libcombine.LIBCOMBINE_DUPLICATE_OBJECT_ID

LIBCOMBINE_LEVEL_MISMATCH = _libcombine.LIBCOMBINE_LEVEL_MISMATCH

LIBCOMBINE_VERSION_MISMATCH = _libcombine.LIBCOMBINE_VERSION_MISMATCH

LIBCOMBINE_INVALID_XML_OPERATION = _libcombine.LIBCOMBINE_INVALID_XML_OPERATION

LIBCOMBINE_NAMESPACES_MISMATCH = _libcombine.LIBCOMBINE_NAMESPACES_MISMATCH

LIBCOMBINE_DUPLICATE_ANNOTATION_NS = _libcombine.LIBCOMBINE_DUPLICATE_ANNOTATION_NS

LIBCOMBINE_ANNOTATION_NAME_NOT_FOUND = _libcombine.LIBCOMBINE_ANNOTATION_NAME_NOT_FOUND

LIBCOMBINE_ANNOTATION_NS_NOT_FOUND = _libcombine.LIBCOMBINE_ANNOTATION_NS_NOT_FOUND

LIBCOMBINE_MISSING_METAID = _libcombine.LIBCOMBINE_MISSING_METAID

LIBCOMBINE_DEPRECATED_ATTRIBUTE = _libcombine.LIBCOMBINE_DEPRECATED_ATTRIBUTE


def CaOperationReturnValue_toString(returnValue):
    r"""CaOperationReturnValue_toString(int returnValue) -> char const *"""
    return _libcombine.CaOperationReturnValue_toString(returnValue)
LIBSBML_DOTTED_VERSION = _libcombine.LIBSBML_DOTTED_VERSION

LIBSBML_VERSION = _libcombine.LIBSBML_VERSION

LIBSBML_VERSION_STRING = _libcombine.LIBSBML_VERSION_STRING


def getLibSBMLVersion():
    r"""getLibSBMLVersion() -> int"""
    return _libcombine.getLibSBMLVersion()

def getLibSBMLDottedVersion():
    r"""getLibSBMLDottedVersion() -> char const *"""
    return _libcombine.getLibSBMLDottedVersion()

def getLibSBMLVersionString():
    r"""getLibSBMLVersionString() -> char const *"""
    return _libcombine.getLibSBMLVersionString()

def isLibSBMLCompiledWith(option):
    r"""isLibSBMLCompiledWith(char const * option) -> int"""
    return _libcombine.isLibSBMLCompiledWith(option)

def getLibSBMLDependencyVersionOf(option):
    r"""getLibSBMLDependencyVersionOf(char const * option) -> char const *"""
    return _libcombine.getLibSBMLDependencyVersionOf(option)
class Date(object):
    r"""Proxy of C++ Date class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcombine.delete_Date

    def __init__(self, *args):
        r"""
        __init__(Date self, unsigned int year=2000, unsigned int month=1, unsigned int day=1, unsigned int hour=0, unsigned int minute=0, unsigned int second=0, unsigned int sign=0, unsigned int hoursOffset=0, unsigned int minutesOffset=0) -> Date
        __init__(Date self, string date) -> Date
        __init__(Date self, Date orig) -> Date
        """
        _libcombine.Date_swiginit(self, _libcombine.new_Date(*args))

    def clone(self):
        r"""clone(Date self) -> Date"""
        return _libcombine.Date_clone(self)

    def getYear(self):
        r"""getYear(Date self) -> unsigned int"""
        return _libcombine.Date_getYear(self)

    def getMonth(self):
        r"""getMonth(Date self) -> unsigned int"""
        return _libcombine.Date_getMonth(self)

    def getDay(self):
        r"""getDay(Date self) -> unsigned int"""
        return _libcombine.Date_getDay(self)

    def getHour(self):
        r"""getHour(Date self) -> unsigned int"""
        return _libcombine.Date_getHour(self)

    def getMinute(self):
        r"""getMinute(Date self) -> unsigned int"""
        return _libcombine.Date_getMinute(self)

    def getSecond(self):
        r"""getSecond(Date self) -> unsigned int"""
        return _libcombine.Date_getSecond(self)

    def getSignOffset(self):
        r"""getSignOffset(Date self) -> unsigned int"""
        return _libcombine.Date_getSignOffset(self)

    def getHoursOffset(self):
        r"""getHoursOffset(Date self) -> unsigned int"""
        return _libcombine.Date_getHoursOffset(self)

    def getMinutesOffset(self):
        r"""getMinutesOffset(Date self) -> unsigned int"""
        return _libcombine.Date_getMinutesOffset(self)

    def getDateAsString(self):
        r"""getDateAsString(Date self) -> string"""
        return _libcombine.Date_getDateAsString(self)

    def setYear(self, year):
        r"""setYear(Date self, unsigned int year) -> int"""
        return _libcombine.Date_setYear(self, year)

    def setMonth(self, month):
        r"""setMonth(Date self, unsigned int month) -> int"""
        return _libcombine.Date_setMonth(self, month)

    def setDay(self, day):
        r"""setDay(Date self, unsigned int day) -> int"""
        return _libcombine.Date_setDay(self, day)

    def setHour(self, hour):
        r"""setHour(Date self, unsigned int hour) -> int"""
        return _libcombine.Date_setHour(self, hour)

    def setMinute(self, minute):
        r"""setMinute(Date self, unsigned int minute) -> int"""
        return _libcombine.Date_setMinute(self, minute)

    def setSecond(self, second):
        r"""setSecond(Date self, unsigned int second) -> int"""
        return _libcombine.Date_setSecond(self, second)

    def setSignOffset(self, sign):
        r"""setSignOffset(Date self, unsigned int sign) -> int"""
        return _libcombine.Date_setSignOffset(self, sign)

    def setHoursOffset(self, hoursOffset):
        r"""setHoursOffset(Date self, unsigned int hoursOffset) -> int"""
        return _libcombine.Date_setHoursOffset(self, hoursOffset)

    def setMinutesOffset(self, minutesOffset):
        r"""setMinutesOffset(Date self, unsigned int minutesOffset) -> int"""
        return _libcombine.Date_setMinutesOffset(self, minutesOffset)

    def setDateAsString(self, date):
        r"""setDateAsString(Date self, string date) -> int"""
        return _libcombine.Date_setDateAsString(self, date)

    def representsValidDate(self):
        r"""representsValidDate(Date self) -> bool"""
        return _libcombine.Date_representsValidDate(self)

    def hasBeenModified(self):
        r"""hasBeenModified(Date self) -> bool"""
        return _libcombine.Date_hasBeenModified(self)

    def resetModifiedFlags(self):
        r"""resetModifiedFlags(Date self)"""
        return _libcombine.Date_resetModifiedFlags(self)

# Register Date in _libcombine:
_libcombine.Date_swigregister(Date)

LIBSBML_OPERATION_SUCCESS = _libcombine.LIBSBML_OPERATION_SUCCESS

LIBSBML_INDEX_EXCEEDS_SIZE = _libcombine.LIBSBML_INDEX_EXCEEDS_SIZE

LIBSBML_UNEXPECTED_ATTRIBUTE = _libcombine.LIBSBML_UNEXPECTED_ATTRIBUTE

LIBSBML_OPERATION_FAILED = _libcombine.LIBSBML_OPERATION_FAILED

LIBSBML_INVALID_ATTRIBUTE_VALUE = _libcombine.LIBSBML_INVALID_ATTRIBUTE_VALUE

LIBSBML_INVALID_OBJECT = _libcombine.LIBSBML_INVALID_OBJECT

LIBSBML_DUPLICATE_OBJECT_ID = _libcombine.LIBSBML_DUPLICATE_OBJECT_ID

LIBSBML_LEVEL_MISMATCH = _libcombine.LIBSBML_LEVEL_MISMATCH

LIBSBML_VERSION_MISMATCH = _libcombine.LIBSBML_VERSION_MISMATCH

LIBSBML_INVALID_XML_OPERATION = _libcombine.LIBSBML_INVALID_XML_OPERATION

LIBSBML_NAMESPACES_MISMATCH = _libcombine.LIBSBML_NAMESPACES_MISMATCH

LIBSBML_DUPLICATE_ANNOTATION_NS = _libcombine.LIBSBML_DUPLICATE_ANNOTATION_NS

LIBSBML_ANNOTATION_NAME_NOT_FOUND = _libcombine.LIBSBML_ANNOTATION_NAME_NOT_FOUND

LIBSBML_ANNOTATION_NS_NOT_FOUND = _libcombine.LIBSBML_ANNOTATION_NS_NOT_FOUND

LIBSBML_MISSING_METAID = _libcombine.LIBSBML_MISSING_METAID

LIBSBML_DEPRECATED_ATTRIBUTE = _libcombine.LIBSBML_DEPRECATED_ATTRIBUTE

LIBSBML_USE_ID_ATTRIBUTE_FUNCTION = _libcombine.LIBSBML_USE_ID_ATTRIBUTE_FUNCTION

LIBSBML_PKG_VERSION_MISMATCH = _libcombine.LIBSBML_PKG_VERSION_MISMATCH

LIBSBML_PKG_UNKNOWN = _libcombine.LIBSBML_PKG_UNKNOWN

LIBSBML_PKG_UNKNOWN_VERSION = _libcombine.LIBSBML_PKG_UNKNOWN_VERSION

LIBSBML_PKG_DISABLED = _libcombine.LIBSBML_PKG_DISABLED

LIBSBML_PKG_CONFLICTED_VERSION = _libcombine.LIBSBML_PKG_CONFLICTED_VERSION

LIBSBML_PKG_CONFLICT = _libcombine.LIBSBML_PKG_CONFLICT

LIBSBML_CONV_INVALID_TARGET_NAMESPACE = _libcombine.LIBSBML_CONV_INVALID_TARGET_NAMESPACE

LIBSBML_CONV_PKG_CONVERSION_NOT_AVAILABLE = _libcombine.LIBSBML_CONV_PKG_CONVERSION_NOT_AVAILABLE

LIBSBML_CONV_INVALID_SRC_DOCUMENT = _libcombine.LIBSBML_CONV_INVALID_SRC_DOCUMENT

LIBSBML_CONV_CONVERSION_NOT_AVAILABLE = _libcombine.LIBSBML_CONV_CONVERSION_NOT_AVAILABLE

LIBSBML_CONV_PKG_CONSIDERED_UNKNOWN = _libcombine.LIBSBML_CONV_PKG_CONSIDERED_UNKNOWN


def OperationReturnValue_toString(returnValue):
    r"""OperationReturnValue_toString(int returnValue) -> char const *"""
    return _libcombine.OperationReturnValue_toString(returnValue)
class SyntaxChecker(object):
    r"""Proxy of C++ SyntaxChecker class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def isValidSBMLSId(sid):
        r"""isValidSBMLSId(string sid) -> bool"""
        return _libcombine.SyntaxChecker_isValidSBMLSId(sid)

    @staticmethod
    def isValidXMLID(id):
        r"""isValidXMLID(string id) -> bool"""
        return _libcombine.SyntaxChecker_isValidXMLID(id)

    @staticmethod
    def isValidXMLanyURI(uri):
        r"""isValidXMLanyURI(string uri) -> bool"""
        return _libcombine.SyntaxChecker_isValidXMLanyURI(uri)

    @staticmethod
    def isValidUnitSId(units):
        r"""isValidUnitSId(string units) -> bool"""
        return _libcombine.SyntaxChecker_isValidUnitSId(units)

    @staticmethod
    def hasExpectedXHTMLSyntax(xhtml, sbmlns=None):
        r"""hasExpectedXHTMLSyntax(XMLNode xhtml, SBMLNamespaces * sbmlns=None) -> bool"""
        return _libcombine.SyntaxChecker_hasExpectedXHTMLSyntax(xhtml, sbmlns)

    @staticmethod
    def isValidInternalSId(sid):
        r"""isValidInternalSId(string sid) -> bool"""
        return _libcombine.SyntaxChecker_isValidInternalSId(sid)

    @staticmethod
    def isValidInternalUnitSId(sid):
        r"""isValidInternalUnitSId(string sid) -> bool"""
        return _libcombine.SyntaxChecker_isValidInternalUnitSId(sid)

    def __init__(self):
        r"""__init__(SyntaxChecker self) -> SyntaxChecker"""
        _libcombine.SyntaxChecker_swiginit(self, _libcombine.new_SyntaxChecker())
    __swig_destroy__ = _libcombine.delete_SyntaxChecker

# Register SyntaxChecker in _libcombine:
_libcombine.SyntaxChecker_swigregister(SyntaxChecker)

def SyntaxChecker_isValidSBMLSId(sid):
    r"""SyntaxChecker_isValidSBMLSId(string sid) -> bool"""
    return _libcombine.SyntaxChecker_isValidSBMLSId(sid)

def SyntaxChecker_isValidXMLID(id):
    r"""SyntaxChecker_isValidXMLID(string id) -> bool"""
    return _libcombine.SyntaxChecker_isValidXMLID(id)

def SyntaxChecker_isValidXMLanyURI(uri):
    r"""SyntaxChecker_isValidXMLanyURI(string uri) -> bool"""
    return _libcombine.SyntaxChecker_isValidXMLanyURI(uri)

def SyntaxChecker_isValidUnitSId(units):
    r"""SyntaxChecker_isValidUnitSId(string units) -> bool"""
    return _libcombine.SyntaxChecker_isValidUnitSId(units)

def SyntaxChecker_hasExpectedXHTMLSyntax(xhtml, sbmlns=None):
    r"""SyntaxChecker_hasExpectedXHTMLSyntax(XMLNode xhtml, SBMLNamespaces * sbmlns=None) -> bool"""
    return _libcombine.SyntaxChecker_hasExpectedXHTMLSyntax(xhtml, sbmlns)

def SyntaxChecker_isValidInternalSId(sid):
    r"""SyntaxChecker_isValidInternalSId(string sid) -> bool"""
    return _libcombine.SyntaxChecker_isValidInternalSId(sid)

def SyntaxChecker_isValidInternalUnitSId(sid):
    r"""SyntaxChecker_isValidInternalUnitSId(string sid) -> bool"""
    return _libcombine.SyntaxChecker_isValidInternalUnitSId(sid)

class XMLAttributes(object):
    r"""Proxy of C++ XMLAttributes class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcombine.delete_XMLAttributes

    def __init__(self, *args):
        r"""
        __init__(XMLAttributes self) -> XMLAttributes
        __init__(XMLAttributes self, XMLAttributes orig) -> XMLAttributes
        """
        _libcombine.XMLAttributes_swiginit(self, _libcombine.new_XMLAttributes(*args))

    def clone(self):
        r"""clone(XMLAttributes self) -> XMLAttributes"""
        return _libcombine.XMLAttributes_clone(self)

    def add(self, *args):
        r"""
        add(XMLAttributes self, string name, string value, string namespaceURI="", string prefix="") -> int
        add(XMLAttributes self, XMLTriple triple, string value) -> int
        """
        return _libcombine.XMLAttributes_add(self, *args)

    def addResource(self, name, value):
        r"""addResource(XMLAttributes self, string name, string value) -> int"""
        return _libcombine.XMLAttributes_addResource(self, name, value)

    def removeResource(self, n):
        r"""removeResource(XMLAttributes self, int n) -> int"""
        return _libcombine.XMLAttributes_removeResource(self, n)

    def remove(self, *args):
        r"""
        remove(XMLAttributes self, int n) -> int
        remove(XMLAttributes self, string name, string uri="") -> int
        remove(XMLAttributes self, XMLTriple triple) -> int
        """
        return _libcombine.XMLAttributes_remove(self, *args)

    def clear(self):
        r"""clear(XMLAttributes self) -> int"""
        return _libcombine.XMLAttributes_clear(self)

    def getIndex(self, *args):
        r"""
        getIndex(XMLAttributes self, string name) -> int
        getIndex(XMLAttributes self, string name, string uri) -> int
        getIndex(XMLAttributes self, XMLTriple triple) -> int
        """
        return _libcombine.XMLAttributes_getIndex(self, *args)

    def getLength(self):
        r"""getLength(XMLAttributes self) -> int"""
        return _libcombine.XMLAttributes_getLength(self)

    def getNumAttributes(self):
        r"""getNumAttributes(XMLAttributes self) -> int"""
        return _libcombine.XMLAttributes_getNumAttributes(self)

    def getName(self, index):
        r"""getName(XMLAttributes self, int index) -> string"""
        return _libcombine.XMLAttributes_getName(self, index)

    def getPrefix(self, index):
        r"""getPrefix(XMLAttributes self, int index) -> string"""
        return _libcombine.XMLAttributes_getPrefix(self, index)

    def getPrefixedName(self, index):
        r"""getPrefixedName(XMLAttributes self, int index) -> string"""
        return _libcombine.XMLAttributes_getPrefixedName(self, index)

    def getURI(self, index):
        r"""getURI(XMLAttributes self, int index) -> string"""
        return _libcombine.XMLAttributes_getURI(self, index)

    def getValue(self, *args):
        r"""
        getValue(XMLAttributes self, int index) -> string
        getValue(XMLAttributes self, string name) -> string
        getValue(XMLAttributes self, string name, string uri) -> string
        getValue(XMLAttributes self, XMLTriple triple) -> string
        """
        return _libcombine.XMLAttributes_getValue(self, *args)

    def hasAttribute(self, *args):
        r"""
        hasAttribute(XMLAttributes self, int index) -> bool
        hasAttribute(XMLAttributes self, string name, string uri="") -> bool
        hasAttribute(XMLAttributes self, XMLTriple triple) -> bool
        """
        return _libcombine.XMLAttributes_hasAttribute(self, *args)

    def isEmpty(self):
        r"""isEmpty(XMLAttributes self) -> bool"""
        return _libcombine.XMLAttributes_isEmpty(self)

    def write(self, stream):
        r"""write(XMLAttributes self, XMLOutputStream stream)"""
        return _libcombine.XMLAttributes_write(self, stream)

    def setErrorLog(self, log):
        r"""setErrorLog(XMLAttributes self, XMLErrorLog log) -> int"""
        return _libcombine.XMLAttributes_setErrorLog(self, log)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLAttributes in _libcombine:
_libcombine.XMLAttributes_swigregister(XMLAttributes)

class XMLNamespaces(object):
    r"""Proxy of C++ XMLNamespaces class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcombine.delete_XMLNamespaces

    def __init__(self, *args):
        r"""
        __init__(XMLNamespaces self) -> XMLNamespaces
        __init__(XMLNamespaces self, XMLNamespaces orig) -> XMLNamespaces
        """
        _libcombine.XMLNamespaces_swiginit(self, _libcombine.new_XMLNamespaces(*args))

    def clone(self):
        r"""clone(XMLNamespaces self) -> XMLNamespaces"""
        return _libcombine.XMLNamespaces_clone(self)

    def add(self, *args):
        r"""add(XMLNamespaces self, string uri, string prefix="") -> int"""
        return _libcombine.XMLNamespaces_add(self, *args)

    def remove(self, *args):
        r"""
        remove(XMLNamespaces self, int index) -> int
        remove(XMLNamespaces self, string prefix) -> int
        """
        return _libcombine.XMLNamespaces_remove(self, *args)

    def clear(self):
        r"""clear(XMLNamespaces self) -> int"""
        return _libcombine.XMLNamespaces_clear(self)

    def getIndex(self, uri):
        r"""getIndex(XMLNamespaces self, string uri) -> int"""
        return _libcombine.XMLNamespaces_getIndex(self, uri)

    def containsUri(self, uri):
        r"""containsUri(XMLNamespaces self, string uri) -> bool"""
        return _libcombine.XMLNamespaces_containsUri(self, uri)

    def getIndexByPrefix(self, prefix):
        r"""getIndexByPrefix(XMLNamespaces self, string prefix) -> int"""
        return _libcombine.XMLNamespaces_getIndexByPrefix(self, prefix)

    def getLength(self):
        r"""getLength(XMLNamespaces self) -> int"""
        return _libcombine.XMLNamespaces_getLength(self)

    def getNumNamespaces(self):
        r"""getNumNamespaces(XMLNamespaces self) -> int"""
        return _libcombine.XMLNamespaces_getNumNamespaces(self)

    def getPrefix(self, *args):
        r"""
        getPrefix(XMLNamespaces self, int index) -> string
        getPrefix(XMLNamespaces self, string uri) -> string
        """
        return _libcombine.XMLNamespaces_getPrefix(self, *args)

    def getURI(self, *args):
        r"""
        getURI(XMLNamespaces self, int index) -> string
        getURI(XMLNamespaces self, string prefix="") -> string
        """
        return _libcombine.XMLNamespaces_getURI(self, *args)

    def isEmpty(self):
        r"""isEmpty(XMLNamespaces self) -> bool"""
        return _libcombine.XMLNamespaces_isEmpty(self)

    def hasURI(self, uri):
        r"""hasURI(XMLNamespaces self, string uri) -> bool"""
        return _libcombine.XMLNamespaces_hasURI(self, uri)

    def hasPrefix(self, prefix):
        r"""hasPrefix(XMLNamespaces self, string prefix) -> bool"""
        return _libcombine.XMLNamespaces_hasPrefix(self, prefix)

    def hasNS(self, uri, prefix):
        r"""hasNS(XMLNamespaces self, string uri, string prefix) -> bool"""
        return _libcombine.XMLNamespaces_hasNS(self, uri, prefix)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLNamespaces in _libcombine:
_libcombine.XMLNamespaces_swigregister(XMLNamespaces)

class XMLToken(object):
    r"""Proxy of C++ XMLToken class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcombine.delete_XMLToken

    def __init__(self, *args):
        r"""
        __init__(XMLToken self) -> XMLToken
        __init__(XMLToken self, XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, unsigned int const line=0, unsigned int const column=0) -> XMLToken
        __init__(XMLToken self, XMLTriple triple, XMLAttributes attributes, unsigned int const line=0, unsigned int const column=0) -> XMLToken
        __init__(XMLToken self, XMLTriple triple, unsigned int const line=0, unsigned int const column=0) -> XMLToken
        __init__(XMLToken self, string chars, unsigned int const line=0, unsigned int const column=0) -> XMLToken
        __init__(XMLToken self, XMLToken orig) -> XMLToken
        """
        _libcombine.XMLToken_swiginit(self, _libcombine.new_XMLToken(*args))

    def clone(self):
        r"""clone(XMLToken self) -> XMLToken"""
        return _libcombine.XMLToken_clone(self)

    def getAttributes(self):
        r"""getAttributes(XMLToken self) -> XMLAttributes"""
        return _libcombine.XMLToken_getAttributes(self)

    def setAttributes(self, attributes):
        r"""setAttributes(XMLToken self, XMLAttributes attributes) -> int"""
        return _libcombine.XMLToken_setAttributes(self, attributes)

    def addAttr(self, *args):
        r"""
        addAttr(XMLToken self, string name, string value, string namespaceURI="", string prefix="") -> int
        addAttr(XMLToken self, XMLTriple triple, string value) -> int
        """
        return _libcombine.XMLToken_addAttr(self, *args)

    def removeAttr(self, *args):
        r"""
        removeAttr(XMLToken self, int n) -> int
        removeAttr(XMLToken self, string name, string uri="") -> int
        removeAttr(XMLToken self, XMLTriple triple) -> int
        """
        return _libcombine.XMLToken_removeAttr(self, *args)

    def clearAttributes(self):
        r"""clearAttributes(XMLToken self) -> int"""
        return _libcombine.XMLToken_clearAttributes(self)

    def getAttrIndex(self, *args):
        r"""
        getAttrIndex(XMLToken self, string name, string uri="") -> int
        getAttrIndex(XMLToken self, XMLTriple triple) -> int
        """
        return _libcombine.XMLToken_getAttrIndex(self, *args)

    def getAttributesLength(self):
        r"""getAttributesLength(XMLToken self) -> int"""
        return _libcombine.XMLToken_getAttributesLength(self)

    def getAttrName(self, index):
        r"""getAttrName(XMLToken self, int index) -> string"""
        return _libcombine.XMLToken_getAttrName(self, index)

    def getAttrPrefix(self, index):
        r"""getAttrPrefix(XMLToken self, int index) -> string"""
        return _libcombine.XMLToken_getAttrPrefix(self, index)

    def getAttrPrefixedName(self, index):
        r"""getAttrPrefixedName(XMLToken self, int index) -> string"""
        return _libcombine.XMLToken_getAttrPrefixedName(self, index)

    def getAttrURI(self, index):
        r"""getAttrURI(XMLToken self, int index) -> string"""
        return _libcombine.XMLToken_getAttrURI(self, index)

    def getAttrValue(self, *args):
        r"""
        getAttrValue(XMLToken self, int index) -> string
        getAttrValue(XMLToken self, string name, string uri="") -> string
        getAttrValue(XMLToken self, XMLTriple triple) -> string
        """
        return _libcombine.XMLToken_getAttrValue(self, *args)

    def hasAttr(self, *args):
        r"""
        hasAttr(XMLToken self, int index) -> bool
        hasAttr(XMLToken self, string name, string uri="") -> bool
        hasAttr(XMLToken self, XMLTriple triple) -> bool
        """
        return _libcombine.XMLToken_hasAttr(self, *args)

    def isAttributesEmpty(self):
        r"""isAttributesEmpty(XMLToken self) -> bool"""
        return _libcombine.XMLToken_isAttributesEmpty(self)

    def getNamespaces(self):
        r"""getNamespaces(XMLToken self) -> XMLNamespaces"""
        return _libcombine.XMLToken_getNamespaces(self)

    def setNamespaces(self, namespaces):
        r"""setNamespaces(XMLToken self, XMLNamespaces namespaces) -> int"""
        return _libcombine.XMLToken_setNamespaces(self, namespaces)

    def addNamespace(self, *args):
        r"""addNamespace(XMLToken self, string uri, string prefix="") -> int"""
        return _libcombine.XMLToken_addNamespace(self, *args)

    def removeNamespace(self, *args):
        r"""
        removeNamespace(XMLToken self, int index) -> int
        removeNamespace(XMLToken self, string prefix) -> int
        """
        return _libcombine.XMLToken_removeNamespace(self, *args)

    def clearNamespaces(self):
        r"""clearNamespaces(XMLToken self) -> int"""
        return _libcombine.XMLToken_clearNamespaces(self)

    def getNamespaceIndex(self, uri):
        r"""getNamespaceIndex(XMLToken self, string uri) -> int"""
        return _libcombine.XMLToken_getNamespaceIndex(self, uri)

    def getNamespaceIndexByPrefix(self, prefix):
        r"""getNamespaceIndexByPrefix(XMLToken self, string prefix) -> int"""
        return _libcombine.XMLToken_getNamespaceIndexByPrefix(self, prefix)

    def getNamespacesLength(self):
        r"""getNamespacesLength(XMLToken self) -> int"""
        return _libcombine.XMLToken_getNamespacesLength(self)

    def getNamespacePrefix(self, *args):
        r"""
        getNamespacePrefix(XMLToken self, int index) -> string
        getNamespacePrefix(XMLToken self, string uri) -> string
        """
        return _libcombine.XMLToken_getNamespacePrefix(self, *args)

    def getNamespaceURI(self, *args):
        r"""
        getNamespaceURI(XMLToken self, int index) -> string
        getNamespaceURI(XMLToken self, string prefix="") -> string
        """
        return _libcombine.XMLToken_getNamespaceURI(self, *args)

    def isNamespacesEmpty(self):
        r"""isNamespacesEmpty(XMLToken self) -> bool"""
        return _libcombine.XMLToken_isNamespacesEmpty(self)

    def hasNamespaceURI(self, uri):
        r"""hasNamespaceURI(XMLToken self, string uri) -> bool"""
        return _libcombine.XMLToken_hasNamespaceURI(self, uri)

    def hasNamespacePrefix(self, prefix):
        r"""hasNamespacePrefix(XMLToken self, string prefix) -> bool"""
        return _libcombine.XMLToken_hasNamespacePrefix(self, prefix)

    def hasNamespaceNS(self, uri, prefix):
        r"""hasNamespaceNS(XMLToken self, string uri, string prefix) -> bool"""
        return _libcombine.XMLToken_hasNamespaceNS(self, uri, prefix)

    def setTriple(self, triple):
        r"""setTriple(XMLToken self, XMLTriple triple) -> int"""
        return _libcombine.XMLToken_setTriple(self, triple)

    def getName(self):
        r"""getName(XMLToken self) -> string"""
        return _libcombine.XMLToken_getName(self)

    def getPrefix(self):
        r"""getPrefix(XMLToken self) -> string"""
        return _libcombine.XMLToken_getPrefix(self)

    def getURI(self):
        r"""getURI(XMLToken self) -> string"""
        return _libcombine.XMLToken_getURI(self)

    def getCharacters(self):
        r"""getCharacters(XMLToken self) -> string"""
        return _libcombine.XMLToken_getCharacters(self)

    def setCharacters(self, chars):
        r"""setCharacters(XMLToken self, string chars) -> int"""
        return _libcombine.XMLToken_setCharacters(self, chars)

    def append(self, chars):
        r"""append(XMLToken self, string chars) -> int"""
        return _libcombine.XMLToken_append(self, chars)

    def getColumn(self):
        r"""getColumn(XMLToken self) -> unsigned int"""
        return _libcombine.XMLToken_getColumn(self)

    def getLine(self):
        r"""getLine(XMLToken self) -> unsigned int"""
        return _libcombine.XMLToken_getLine(self)

    def isElement(self):
        r"""isElement(XMLToken self) -> bool"""
        return _libcombine.XMLToken_isElement(self)

    def isEnd(self):
        r"""isEnd(XMLToken self) -> bool"""
        return _libcombine.XMLToken_isEnd(self)

    def isEndFor(self, element):
        r"""isEndFor(XMLToken self, XMLToken element) -> bool"""
        return _libcombine.XMLToken_isEndFor(self, element)

    def isEOF(self):
        r"""isEOF(XMLToken self) -> bool"""
        return _libcombine.XMLToken_isEOF(self)

    def isStart(self):
        r"""isStart(XMLToken self) -> bool"""
        return _libcombine.XMLToken_isStart(self)

    def isText(self):
        r"""isText(XMLToken self) -> bool"""
        return _libcombine.XMLToken_isText(self)

    def setEnd(self):
        r"""setEnd(XMLToken self) -> int"""
        return _libcombine.XMLToken_setEnd(self)

    def setEOF(self):
        r"""setEOF(XMLToken self) -> int"""
        return _libcombine.XMLToken_setEOF(self)

    def unsetEnd(self):
        r"""unsetEnd(XMLToken self) -> int"""
        return _libcombine.XMLToken_unsetEnd(self)

    def toString(self):
        r"""toString(XMLToken self) -> string"""
        return _libcombine.XMLToken_toString(self)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLToken in _libcombine:
_libcombine.XMLToken_swigregister(XMLToken)

class XMLNode(XMLToken):
    r"""Proxy of C++ XMLNode class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcombine.delete_XMLNode

    def __init__(self, *args):
        r"""
        __init__(XMLNode self) -> XMLNode
        __init__(XMLNode self, XMLToken token) -> XMLNode
        __init__(XMLNode self, XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, unsigned int const line=0, unsigned int const column=0) -> XMLNode
        __init__(XMLNode self, XMLTriple triple, XMLAttributes attributes, unsigned int const line=0, unsigned int const column=0) -> XMLNode
        __init__(XMLNode self, XMLTriple triple, unsigned int const line=0, unsigned int const column=0) -> XMLNode
        __init__(XMLNode self, string chars, unsigned int const line=0, unsigned int const column=0) -> XMLNode
        __init__(XMLNode self, XMLInputStream stream) -> XMLNode
        __init__(XMLNode self, XMLNode orig) -> XMLNode
        """
        _libcombine.XMLNode_swiginit(self, _libcombine.new_XMLNode(*args))

    def clone(self):
        r"""clone(XMLNode self) -> XMLNode"""
        return _libcombine.XMLNode_clone(self)

    def addChild(self, node):
        r"""addChild(XMLNode self, XMLNode node) -> int"""
        return _libcombine.XMLNode_addChild(self, node)

    def insertChild(self, n, node):
        r"""insertChild(XMLNode self, unsigned int n, XMLNode node) -> XMLNode"""
        return _libcombine.XMLNode_insertChild(self, n, node)

    def removeChild(self, n):
        r"""removeChild(XMLNode self, unsigned int n) -> XMLNode"""
        return _libcombine.XMLNode_removeChild(self, n)

    def removeChildren(self):
        r"""removeChildren(XMLNode self) -> int"""
        return _libcombine.XMLNode_removeChildren(self)

    def getChild(self, *args):
        r"""
        getChild(XMLNode self, unsigned int n) -> XMLNode
        getChild(XMLNode self, unsigned int n) -> XMLNode
        getChild(XMLNode self, string name) -> XMLNode
        getChild(XMLNode self, string name) -> XMLNode
        """
        return _libcombine.XMLNode_getChild(self, *args)

    def getIndex(self, name):
        r"""getIndex(XMLNode self, string name) -> int"""
        return _libcombine.XMLNode_getIndex(self, name)

    def hasChild(self, name):
        r"""hasChild(XMLNode self, string name) -> bool"""
        return _libcombine.XMLNode_hasChild(self, name)

    def equals(self, other, ignoreURI=False, ignoreAttributeValues=False):
        r"""equals(XMLNode self, XMLNode other, bool ignoreURI=False, bool ignoreAttributeValues=False) -> bool"""
        return _libcombine.XMLNode_equals(self, other, ignoreURI, ignoreAttributeValues)

    def getNumChildren(self):
        r"""getNumChildren(XMLNode self) -> unsigned int"""
        return _libcombine.XMLNode_getNumChildren(self)

    def writeToStream(self, stream):
        r"""writeToStream(XMLNode self, XMLOutputStream stream)"""
        return _libcombine.XMLNode_writeToStream(self, stream)

    def toXMLString(self):
        r"""toXMLString(XMLNode self) -> string"""
        return _libcombine.XMLNode_toXMLString(self)

    @staticmethod
    def convertXMLNodeToString(node):
        r"""convertXMLNodeToString(XMLNode node) -> string"""
        return _libcombine.XMLNode_convertXMLNodeToString(node)

    @staticmethod
    def convertStringToXMLNode(xmlstr, xmlns=None):
        r"""convertStringToXMLNode(string xmlstr, XMLNamespaces xmlns=None) -> XMLNode"""
        return _libcombine.XMLNode_convertStringToXMLNode(xmlstr, xmlns)

# Register XMLNode in _libcombine:
_libcombine.XMLNode_swigregister(XMLNode)

def XMLNode_convertXMLNodeToString(node):
    r"""XMLNode_convertXMLNodeToString(XMLNode node) -> string"""
    return _libcombine.XMLNode_convertXMLNodeToString(node)

def XMLNode_convertStringToXMLNode(xmlstr, xmlns=None):
    r"""XMLNode_convertStringToXMLNode(string xmlstr, XMLNamespaces xmlns=None) -> XMLNode"""
    return _libcombine.XMLNode_convertStringToXMLNode(xmlstr, xmlns)

class XMLTriple(object):
    r"""Proxy of C++ XMLTriple class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(XMLTriple self) -> XMLTriple
        __init__(XMLTriple self, string name, string uri, string prefix) -> XMLTriple
        __init__(XMLTriple self, string triplet, char const sepchar=' ') -> XMLTriple
        __init__(XMLTriple self, XMLTriple orig) -> XMLTriple
        """
        _libcombine.XMLTriple_swiginit(self, _libcombine.new_XMLTriple(*args))
    __swig_destroy__ = _libcombine.delete_XMLTriple

    def clone(self):
        r"""clone(XMLTriple self) -> XMLTriple"""
        return _libcombine.XMLTriple_clone(self)

    def getName(self):
        r"""getName(XMLTriple self) -> string"""
        return _libcombine.XMLTriple_getName(self)

    def getPrefix(self):
        r"""getPrefix(XMLTriple self) -> string"""
        return _libcombine.XMLTriple_getPrefix(self)

    def getURI(self):
        r"""getURI(XMLTriple self) -> string"""
        return _libcombine.XMLTriple_getURI(self)

    def getPrefixedName(self):
        r"""getPrefixedName(XMLTriple self) -> string"""
        return _libcombine.XMLTriple_getPrefixedName(self)

    def isEmpty(self):
        r"""isEmpty(XMLTriple self) -> bool"""
        return _libcombine.XMLTriple_isEmpty(self)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLTriple in _libcombine:
_libcombine.XMLTriple_swigregister(XMLTriple)

class XMLOutputStream(object):
    r"""Proxy of C++ XMLOutputStream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(XMLOutputStream self, ostream stream, string encoding="UTF-8", bool writeXMLDecl=True, string programName="", string programVersion="") -> XMLOutputStream"""
        _libcombine.XMLOutputStream_swiginit(self, _libcombine.new_XMLOutputStream(*args))
    __swig_destroy__ = _libcombine.delete_XMLOutputStream

    def endElement(self, *args):
        r"""
        endElement(XMLOutputStream self, string name, string prefix="")
        endElement(XMLOutputStream self, XMLTriple triple, bool text=False)
        """
        return _libcombine.XMLOutputStream_endElement(self, *args)

    def setAutoIndent(self, indent):
        r"""setAutoIndent(XMLOutputStream self, bool indent)"""
        return _libcombine.XMLOutputStream_setAutoIndent(self, indent)

    def startElement(self, *args):
        r"""
        startElement(XMLOutputStream self, string name, string prefix="")
        startElement(XMLOutputStream self, XMLTriple triple)
        """
        return _libcombine.XMLOutputStream_startElement(self, *args)

    def startEndElement(self, *args):
        r"""
        startEndElement(XMLOutputStream self, string name, string prefix="")
        startEndElement(XMLOutputStream self, XMLTriple triple)
        """
        return _libcombine.XMLOutputStream_startEndElement(self, *args)

    def writeAttribute(self, *args):
        r"""
        writeAttribute(XMLOutputStream self, string name, string value)
        writeAttribute(XMLOutputStream self, string name, string prefix, string value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, string value)
        writeAttribute(XMLOutputStream self, string name, char const * value)
        writeAttribute(XMLOutputStream self, string name, string prefix, char const * value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, char const * value)
        writeAttribute(XMLOutputStream self, string name, bool const & value)
        writeAttribute(XMLOutputStream self, string name, string prefix, bool const & value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, bool const & value)
        writeAttribute(XMLOutputStream self, string name, double const & value)
        writeAttribute(XMLOutputStream self, string name, string prefix, double const & value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, double const & value)
        writeAttribute(XMLOutputStream self, string name, long const & value)
        writeAttribute(XMLOutputStream self, string name, string prefix, long const & value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, long const & value)
        writeAttribute(XMLOutputStream self, string name, int const & value)
        writeAttribute(XMLOutputStream self, string name, string prefix, int const & value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, int const & value)
        writeAttribute(XMLOutputStream self, string name, string prefix, unsigned int const & value)
        """

        if type(args[1]) == type(True): return _libsedml.XMLOutputStream_writeAttributeBool(self, *args)


        return _libcombine.XMLOutputStream_writeAttribute(self, *args)


    def writeXMLDecl(self):
        r"""writeXMLDecl(XMLOutputStream self)"""
        return _libcombine.XMLOutputStream_writeXMLDecl(self)

    def writeComment(self, programName, programVersion, writeTimestamp=True):
        r"""writeComment(XMLOutputStream self, string programName, string programVersion, bool writeTimestamp=True)"""
        return _libcombine.XMLOutputStream_writeComment(self, programName, programVersion, writeTimestamp)

    def downIndent(self):
        r"""downIndent(XMLOutputStream self)"""
        return _libcombine.XMLOutputStream_downIndent(self)

    def upIndent(self):
        r"""upIndent(XMLOutputStream self)"""
        return _libcombine.XMLOutputStream_upIndent(self)

    def getSBMLNamespaces(self):
        r"""getSBMLNamespaces(XMLOutputStream self) -> SBMLNamespaces *"""
        return _libcombine.XMLOutputStream_getSBMLNamespaces(self)

    def setSBMLNamespaces(self, sbmlns):
        r"""setSBMLNamespaces(XMLOutputStream self, SBMLNamespaces * sbmlns)"""
        return _libcombine.XMLOutputStream_setSBMLNamespaces(self, sbmlns)

    @staticmethod
    def getWriteComment():
        r"""getWriteComment() -> bool"""
        return _libcombine.XMLOutputStream_getWriteComment()

    @staticmethod
    def setWriteComment(writeComment):
        r"""setWriteComment(bool writeComment)"""
        return _libcombine.XMLOutputStream_setWriteComment(writeComment)

    @staticmethod
    def getWriteTimestamp():
        r"""getWriteTimestamp() -> bool"""
        return _libcombine.XMLOutputStream_getWriteTimestamp()

    @staticmethod
    def setWriteTimestamp(writeTimestamp):
        r"""setWriteTimestamp(bool writeTimestamp)"""
        return _libcombine.XMLOutputStream_setWriteTimestamp(writeTimestamp)

    @staticmethod
    def getLibraryName():
        r"""getLibraryName() -> string"""
        return _libcombine.XMLOutputStream_getLibraryName()

    @staticmethod
    def setLibraryName(libraryName):
        r"""setLibraryName(string libraryName)"""
        return _libcombine.XMLOutputStream_setLibraryName(libraryName)

    @staticmethod
    def getLibraryVersion():
        r"""getLibraryVersion() -> string"""
        return _libcombine.XMLOutputStream_getLibraryVersion()

    @staticmethod
    def setLibraryVersion(libraryVersion):
        r"""setLibraryVersion(string libraryVersion)"""
        return _libcombine.XMLOutputStream_setLibraryVersion(libraryVersion)

    def getIndent(self):
        r"""getIndent(XMLOutputStream self) -> unsigned int"""
        return _libcombine.XMLOutputStream_getIndent(self)

    def setIndent(self, indent):
        r"""setIndent(XMLOutputStream self, unsigned int indent)"""
        return _libcombine.XMLOutputStream_setIndent(self, indent)

    def writeAttributeBool(self, *args):
        r"""
        writeAttributeBool(XMLOutputStream self, string name, bool const & value)
        writeAttributeBool(XMLOutputStream self, XMLTriple name, bool const & value)
        """
        return _libcombine.XMLOutputStream_writeAttributeBool(self, *args)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLOutputStream in _libcombine:
_libcombine.XMLOutputStream_swigregister(XMLOutputStream)

def XMLOutputStream_getWriteComment():
    r"""XMLOutputStream_getWriteComment() -> bool"""
    return _libcombine.XMLOutputStream_getWriteComment()

def XMLOutputStream_setWriteComment(writeComment):
    r"""XMLOutputStream_setWriteComment(bool writeComment)"""
    return _libcombine.XMLOutputStream_setWriteComment(writeComment)

def XMLOutputStream_getWriteTimestamp():
    r"""XMLOutputStream_getWriteTimestamp() -> bool"""
    return _libcombine.XMLOutputStream_getWriteTimestamp()

def XMLOutputStream_setWriteTimestamp(writeTimestamp):
    r"""XMLOutputStream_setWriteTimestamp(bool writeTimestamp)"""
    return _libcombine.XMLOutputStream_setWriteTimestamp(writeTimestamp)

def XMLOutputStream_getLibraryName():
    r"""XMLOutputStream_getLibraryName() -> string"""
    return _libcombine.XMLOutputStream_getLibraryName()

def XMLOutputStream_setLibraryName(libraryName):
    r"""XMLOutputStream_setLibraryName(string libraryName)"""
    return _libcombine.XMLOutputStream_setLibraryName(libraryName)

def XMLOutputStream_getLibraryVersion():
    r"""XMLOutputStream_getLibraryVersion() -> string"""
    return _libcombine.XMLOutputStream_getLibraryVersion()

def XMLOutputStream_setLibraryVersion(libraryVersion):
    r"""XMLOutputStream_setLibraryVersion(string libraryVersion)"""
    return _libcombine.XMLOutputStream_setLibraryVersion(libraryVersion)

class XMLOwningOutputStringStream(object):
    r"""Proxy of C++ XMLOwningOutputStringStream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(XMLOwningOutputStringStream self, string encoding="UTF-8", bool writeXMLDecl=True, string programName="", string programVersion="") -> XMLOwningOutputStringStream"""
        _libcombine.XMLOwningOutputStringStream_swiginit(self, _libcombine.new_XMLOwningOutputStringStream(*args))
    __swig_destroy__ = _libcombine.delete_XMLOwningOutputStringStream

# Register XMLOwningOutputStringStream in _libcombine:
_libcombine.XMLOwningOutputStringStream_swigregister(XMLOwningOutputStringStream)

class XMLOwningOutputFileStream(object):
    r"""Proxy of C++ XMLOwningOutputFileStream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(XMLOwningOutputFileStream self, string filename, string encoding="UTF-8", bool writeXMLDecl=True, string programName="", string programVersion="") -> XMLOwningOutputFileStream"""
        _libcombine.XMLOwningOutputFileStream_swiginit(self, _libcombine.new_XMLOwningOutputFileStream(*args))
    __swig_destroy__ = _libcombine.delete_XMLOwningOutputFileStream

# Register XMLOwningOutputFileStream in _libcombine:
_libcombine.XMLOwningOutputFileStream_swigregister(XMLOwningOutputFileStream)

class XMLInputStream(object):
    r"""Proxy of C++ XMLInputStream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(XMLInputStream self, char const * content, bool isFile=True, string library="", XMLErrorLog errorLog=None) -> XMLInputStream"""
        _libcombine.XMLInputStream_swiginit(self, _libcombine.new_XMLInputStream(*args))
    __swig_destroy__ = _libcombine.delete_XMLInputStream

    def getEncoding(self):
        r"""getEncoding(XMLInputStream self) -> string"""
        return _libcombine.XMLInputStream_getEncoding(self)

    def getVersion(self):
        r"""getVersion(XMLInputStream self) -> string"""
        return _libcombine.XMLInputStream_getVersion(self)

    def getErrorLog(self):
        r"""getErrorLog(XMLInputStream self) -> XMLErrorLog"""
        return _libcombine.XMLInputStream_getErrorLog(self)

    def isEOF(self):
        r"""isEOF(XMLInputStream self) -> bool"""
        return _libcombine.XMLInputStream_isEOF(self)

    def isError(self):
        r"""isError(XMLInputStream self) -> bool"""
        return _libcombine.XMLInputStream_isError(self)

    def isGood(self):
        r"""isGood(XMLInputStream self) -> bool"""
        return _libcombine.XMLInputStream_isGood(self)

    def next(self):
        r"""next(XMLInputStream self) -> XMLToken"""
        return _libcombine.XMLInputStream_next(self)

    def peek(self):
        r"""peek(XMLInputStream self) -> XMLToken"""
        return _libcombine.XMLInputStream_peek(self)

    def skipPastEnd(self, element):
        r"""skipPastEnd(XMLInputStream self, XMLToken element)"""
        return _libcombine.XMLInputStream_skipPastEnd(self, element)

    def skipText(self):
        r"""skipText(XMLInputStream self)"""
        return _libcombine.XMLInputStream_skipText(self)

    def setErrorLog(self, log):
        r"""setErrorLog(XMLInputStream self, XMLErrorLog log) -> int"""
        return _libcombine.XMLInputStream_setErrorLog(self, log)

    def toString(self):
        r"""toString(XMLInputStream self) -> string"""
        return _libcombine.XMLInputStream_toString(self)

    def getSBMLNamespaces(self):
        r"""getSBMLNamespaces(XMLInputStream self) -> SBMLNamespaces *"""
        return _libcombine.XMLInputStream_getSBMLNamespaces(self)

    def setSBMLNamespaces(self, sbmlns):
        r"""setSBMLNamespaces(XMLInputStream self, SBMLNamespaces * sbmlns)"""
        return _libcombine.XMLInputStream_setSBMLNamespaces(self, sbmlns)

    def determineNumberChildren(self, *args):
        r"""determineNumberChildren(XMLInputStream self, string elementName="") -> unsigned int"""
        return _libcombine.XMLInputStream_determineNumberChildren(self, *args)

    def determineNumSpecificChildren(self, childName, container):
        r"""determineNumSpecificChildren(XMLInputStream self, string childName, string container) -> unsigned int"""
        return _libcombine.XMLInputStream_determineNumSpecificChildren(self, childName, container)

    def containsChild(self, childName, container):
        r"""containsChild(XMLInputStream self, string childName, string container) -> bool"""
        return _libcombine.XMLInputStream_containsChild(self, childName, container)

# Register XMLInputStream in _libcombine:
_libcombine.XMLInputStream_swigregister(XMLInputStream)

XMLUnknownError = _libcombine.XMLUnknownError

XMLOutOfMemory = _libcombine.XMLOutOfMemory

XMLFileUnreadable = _libcombine.XMLFileUnreadable

XMLFileUnwritable = _libcombine.XMLFileUnwritable

XMLFileOperationError = _libcombine.XMLFileOperationError

XMLNetworkAccessError = _libcombine.XMLNetworkAccessError

InternalXMLParserError = _libcombine.InternalXMLParserError

UnrecognizedXMLParserCode = _libcombine.UnrecognizedXMLParserCode

XMLTranscoderError = _libcombine.XMLTranscoderError

MissingXMLDecl = _libcombine.MissingXMLDecl

MissingXMLEncoding = _libcombine.MissingXMLEncoding

BadXMLDecl = _libcombine.BadXMLDecl

BadXMLDOCTYPE = _libcombine.BadXMLDOCTYPE

InvalidCharInXML = _libcombine.InvalidCharInXML

BadlyFormedXML = _libcombine.BadlyFormedXML

UnclosedXMLToken = _libcombine.UnclosedXMLToken

InvalidXMLConstruct = _libcombine.InvalidXMLConstruct

XMLTagMismatch = _libcombine.XMLTagMismatch

DuplicateXMLAttribute = _libcombine.DuplicateXMLAttribute

UndefinedXMLEntity = _libcombine.UndefinedXMLEntity

BadProcessingInstruction = _libcombine.BadProcessingInstruction

BadXMLPrefix = _libcombine.BadXMLPrefix

BadXMLPrefixValue = _libcombine.BadXMLPrefixValue

MissingXMLRequiredAttribute = _libcombine.MissingXMLRequiredAttribute

XMLAttributeTypeMismatch = _libcombine.XMLAttributeTypeMismatch

XMLBadUTF8Content = _libcombine.XMLBadUTF8Content

MissingXMLAttributeValue = _libcombine.MissingXMLAttributeValue

BadXMLAttributeValue = _libcombine.BadXMLAttributeValue

BadXMLAttribute = _libcombine.BadXMLAttribute

UnrecognizedXMLElement = _libcombine.UnrecognizedXMLElement

BadXMLComment = _libcombine.BadXMLComment

BadXMLDeclLocation = _libcombine.BadXMLDeclLocation

XMLUnexpectedEOF = _libcombine.XMLUnexpectedEOF

BadXMLIDValue = _libcombine.BadXMLIDValue

BadXMLIDRef = _libcombine.BadXMLIDRef

UninterpretableXMLContent = _libcombine.UninterpretableXMLContent

BadXMLDocumentStructure = _libcombine.BadXMLDocumentStructure

InvalidAfterXMLContent = _libcombine.InvalidAfterXMLContent

XMLExpectedQuotedString = _libcombine.XMLExpectedQuotedString

XMLEmptyValueNotPermitted = _libcombine.XMLEmptyValueNotPermitted

XMLBadNumber = _libcombine.XMLBadNumber

XMLBadColon = _libcombine.XMLBadColon

MissingXMLElements = _libcombine.MissingXMLElements

XMLContentEmpty = _libcombine.XMLContentEmpty

XMLErrorCodesUpperBound = _libcombine.XMLErrorCodesUpperBound

LIBSBML_CAT_INTERNAL = _libcombine.LIBSBML_CAT_INTERNAL

LIBSBML_CAT_SYSTEM = _libcombine.LIBSBML_CAT_SYSTEM

LIBSBML_CAT_XML = _libcombine.LIBSBML_CAT_XML

LIBSBML_SEV_INFO = _libcombine.LIBSBML_SEV_INFO

LIBSBML_SEV_WARNING = _libcombine.LIBSBML_SEV_WARNING

LIBSBML_SEV_ERROR = _libcombine.LIBSBML_SEV_ERROR

LIBSBML_SEV_FATAL = _libcombine.LIBSBML_SEV_FATAL

LIBSBML_OVERRIDE_DISABLED = _libcombine.LIBSBML_OVERRIDE_DISABLED

LIBSBML_OVERRIDE_DONT_LOG = _libcombine.LIBSBML_OVERRIDE_DONT_LOG

LIBSBML_OVERRIDE_WARNING = _libcombine.LIBSBML_OVERRIDE_WARNING

LIBSBML_OVERRIDE_ERROR = _libcombine.LIBSBML_OVERRIDE_ERROR

class XMLError(object):
    r"""Proxy of C++ XMLError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(XMLError self, int const errorId=0, string details="", unsigned int const line=0, unsigned int const column=0, unsigned int const severity=LIBSBML_SEV_FATAL, unsigned int const category=LIBSBML_CAT_INTERNAL) -> XMLError
        __init__(XMLError self, XMLError orig) -> XMLError
        """
        _libcombine.XMLError_swiginit(self, _libcombine.new_XMLError(*args))
    __swig_destroy__ = _libcombine.delete_XMLError

    def getErrorId(self):
        r"""getErrorId(XMLError self) -> unsigned int"""
        return _libcombine.XMLError_getErrorId(self)

    def getMessage(self):
        r"""getMessage(XMLError self) -> string"""
        return _libcombine.XMLError_getMessage(self)

    def getShortMessage(self):
        r"""getShortMessage(XMLError self) -> string"""
        return _libcombine.XMLError_getShortMessage(self)

    def getLine(self):
        r"""getLine(XMLError self) -> unsigned int"""
        return _libcombine.XMLError_getLine(self)

    def getColumn(self):
        r"""getColumn(XMLError self) -> unsigned int"""
        return _libcombine.XMLError_getColumn(self)

    def getSeverity(self):
        r"""getSeverity(XMLError self) -> unsigned int"""
        return _libcombine.XMLError_getSeverity(self)

    def getSeverityAsString(self):
        r"""getSeverityAsString(XMLError self) -> string"""
        return _libcombine.XMLError_getSeverityAsString(self)

    def getCategory(self):
        r"""getCategory(XMLError self) -> unsigned int"""
        return _libcombine.XMLError_getCategory(self)

    def getCategoryAsString(self):
        r"""getCategoryAsString(XMLError self) -> string"""
        return _libcombine.XMLError_getCategoryAsString(self)

    def setErrorId(self, errorId):
        r"""setErrorId(XMLError self, unsigned int errorId) -> int"""
        return _libcombine.XMLError_setErrorId(self, errorId)

    def setMessage(self, message):
        r"""setMessage(XMLError self, string message) -> int"""
        return _libcombine.XMLError_setMessage(self, message)

    def setShortMessage(self, shortMessage):
        r"""setShortMessage(XMLError self, string shortMessage) -> int"""
        return _libcombine.XMLError_setShortMessage(self, shortMessage)

    def setSeverity(self, severity):
        r"""setSeverity(XMLError self, unsigned int severity) -> int"""
        return _libcombine.XMLError_setSeverity(self, severity)

    def setSeverityString(self, severityString):
        r"""setSeverityString(XMLError self, string severityString) -> int"""
        return _libcombine.XMLError_setSeverityString(self, severityString)

    def setCategory(self, category):
        r"""setCategory(XMLError self, unsigned int category) -> int"""
        return _libcombine.XMLError_setCategory(self, category)

    def setCategoryString(self, categoryString):
        r"""setCategoryString(XMLError self, string categoryString) -> int"""
        return _libcombine.XMLError_setCategoryString(self, categoryString)

    def isInfo(self):
        r"""isInfo(XMLError self) -> bool"""
        return _libcombine.XMLError_isInfo(self)

    def isWarning(self):
        r"""isWarning(XMLError self) -> bool"""
        return _libcombine.XMLError_isWarning(self)

    def isError(self):
        r"""isError(XMLError self) -> bool"""
        return _libcombine.XMLError_isError(self)

    def isFatal(self):
        r"""isFatal(XMLError self) -> bool"""
        return _libcombine.XMLError_isFatal(self)

    def isInternal(self):
        r"""isInternal(XMLError self) -> bool"""
        return _libcombine.XMLError_isInternal(self)

    def isSystem(self):
        r"""isSystem(XMLError self) -> bool"""
        return _libcombine.XMLError_isSystem(self)

    def isXML(self):
        r"""isXML(XMLError self) -> bool"""
        return _libcombine.XMLError_isXML(self)

    def isValid(self):
        r"""isValid(XMLError self) -> bool"""
        return _libcombine.XMLError_isValid(self)

    def setLine(self, line):
        r"""setLine(XMLError self, unsigned int line) -> int"""
        return _libcombine.XMLError_setLine(self, line)

    def setColumn(self, column):
        r"""setColumn(XMLError self, unsigned int column) -> int"""
        return _libcombine.XMLError_setColumn(self, column)

    @staticmethod
    def getStandardMessage(code):
        r"""getStandardMessage(int const code) -> string"""
        return _libcombine.XMLError_getStandardMessage(code)

    def getPackage(self):
        r"""getPackage(XMLError self) -> string"""
        return _libcombine.XMLError_getPackage(self)

    def getErrorIdOffset(self):
        r"""getErrorIdOffset(XMLError self) -> unsigned int"""
        return _libcombine.XMLError_getErrorIdOffset(self)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLError in _libcombine:
_libcombine.XMLError_swigregister(XMLError)

def XMLError_getStandardMessage(code):
    r"""XMLError_getStandardMessage(int const code) -> string"""
    return _libcombine.XMLError_getStandardMessage(code)

class XMLErrorLog(object):
    r"""Proxy of C++ XMLErrorLog class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getNumErrors(self):
        r"""getNumErrors(XMLErrorLog self) -> unsigned int"""
        return _libcombine.XMLErrorLog_getNumErrors(self)

    def getError(self, n):
        r"""getError(XMLErrorLog self, unsigned int n) -> XMLError"""
        return _libcombine.XMLErrorLog_getError(self, n)

    def clearLog(self):
        r"""clearLog(XMLErrorLog self)"""
        return _libcombine.XMLErrorLog_clearLog(self)

    def __init__(self, *args):
        r"""
        __init__(XMLErrorLog self) -> XMLErrorLog
        __init__(XMLErrorLog self, XMLErrorLog other) -> XMLErrorLog
        """
        _libcombine.XMLErrorLog_swiginit(self, _libcombine.new_XMLErrorLog(*args))
    __swig_destroy__ = _libcombine.delete_XMLErrorLog

    def add(self, *args):
        r"""
        add(XMLErrorLog self, XMLError error)
        add(XMLErrorLog self, XmlErrorStdVector errors)
        """
        return _libcombine.XMLErrorLog_add(self, *args)

    def toString(self):
        r"""toString(XMLErrorLog self) -> string"""
        return _libcombine.XMLErrorLog_toString(self)

    def printErrors(self, *args):
        r"""
        printErrors(XMLErrorLog self, ostream stream=cerr)
        printErrors(XMLErrorLog self, ostream stream, unsigned int severity)
        """
        return _libcombine.XMLErrorLog_printErrors(self, *args)

    def isSeverityOverridden(self):
        r"""isSeverityOverridden(XMLErrorLog self) -> bool"""
        return _libcombine.XMLErrorLog_isSeverityOverridden(self)

    def unsetSeverityOverride(self):
        r"""unsetSeverityOverride(XMLErrorLog self)"""
        return _libcombine.XMLErrorLog_unsetSeverityOverride(self)

    def getSeverityOverride(self):
        r"""getSeverityOverride(XMLErrorLog self) -> XMLErrorSeverityOverride_t"""
        return _libcombine.XMLErrorLog_getSeverityOverride(self)

    def setSeverityOverride(self, severity):
        r"""setSeverityOverride(XMLErrorLog self, XMLErrorSeverityOverride_t severity)"""
        return _libcombine.XMLErrorLog_setSeverityOverride(self, severity)

    def changeErrorSeverity(self, *args):
        r"""changeErrorSeverity(XMLErrorLog self, XMLErrorSeverity_t originalSeverity, XMLErrorSeverity_t targetSeverity, string package="all")"""
        return _libcombine.XMLErrorLog_changeErrorSeverity(self, *args)

    def contains(self, errorId):
        r"""contains(XMLErrorLog self, unsigned int const errorId) -> bool"""
        return _libcombine.XMLErrorLog_contains(self, errorId)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLErrorLog in _libcombine:
_libcombine.XMLErrorLog_swigregister(XMLErrorLog)

class ASTNode(object):
    r"""Proxy of C++ ASTNode class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ASTNode self, ASTNodeType_t type=AST_UNKNOWN) -> ASTNode
        __init__(ASTNode self, ASTNode orig) -> ASTNode
        """
        _libcombine.ASTNode_swiginit(self, _libcombine.new_ASTNode(*args))
    __swig_destroy__ = _libcombine.delete_ASTNode

    def freeName(self):
        r"""freeName(ASTNode self) -> int"""
        return _libcombine.ASTNode_freeName(self)

    def canonicalize(self):
        r"""canonicalize(ASTNode self) -> bool"""
        return _libcombine.ASTNode_canonicalize(self)

    def addChild(self, disownedChild, inRead=False):
        r"""addChild(ASTNode self, ASTNode disownedChild, bool inRead=False) -> int"""

        if args[0] is not None: args[0].thisown = 0


        return _libcombine.ASTNode_addChild(self, disownedChild, inRead)


    def prependChild(self, disownedChild):
        r"""prependChild(ASTNode self, ASTNode disownedChild) -> int"""

        if args[0] is not None: args[0].thisown = 0


        return _libcombine.ASTNode_prependChild(self, disownedChild)


    def removeChild(self, n):
        r"""removeChild(ASTNode self, unsigned int n) -> int"""
        return _libcombine.ASTNode_removeChild(self, n)

    def replaceChild(self, n, disownedChild, delreplaced=False):
        r"""replaceChild(ASTNode self, unsigned int n, ASTNode disownedChild, bool delreplaced=False) -> int"""

        if args[1] is not None: args[1].thisown = 0


        return _libcombine.ASTNode_replaceChild(self, n, disownedChild, delreplaced)


    def insertChild(self, n, disownedChild):
        r"""insertChild(ASTNode self, unsigned int n, ASTNode disownedChild) -> int"""

        if args[1] is not None: args[1].thisown = 0


        return _libcombine.ASTNode_insertChild(self, n, disownedChild)


    def deepCopy(self):
        r"""deepCopy(ASTNode self) -> ASTNode"""
        return _libcombine.ASTNode_deepCopy(self)

    def getChild(self, n):
        r"""getChild(ASTNode self, unsigned int n) -> ASTNode"""
        return _libcombine.ASTNode_getChild(self, n)

    def getLeftChild(self):
        r"""getLeftChild(ASTNode self) -> ASTNode"""
        return _libcombine.ASTNode_getLeftChild(self)

    def getRightChild(self):
        r"""getRightChild(ASTNode self) -> ASTNode"""
        return _libcombine.ASTNode_getRightChild(self)

    def getNumChildren(self):
        r"""getNumChildren(ASTNode self) -> unsigned int"""
        return _libcombine.ASTNode_getNumChildren(self)

    def addSemanticsAnnotation(self, disownedAnnotation):
        r"""addSemanticsAnnotation(ASTNode self, XMLNode disownedAnnotation) -> int"""

        if args[0] is not None: args[0].thisown = 0


        return _libcombine.ASTNode_addSemanticsAnnotation(self, disownedAnnotation)


    def getNumSemanticsAnnotations(self):
        r"""getNumSemanticsAnnotations(ASTNode self) -> unsigned int"""
        return _libcombine.ASTNode_getNumSemanticsAnnotations(self)

    def getSemanticsAnnotation(self, n):
        r"""getSemanticsAnnotation(ASTNode self, unsigned int n) -> XMLNode"""
        return _libcombine.ASTNode_getSemanticsAnnotation(self, n)

    def getCharacter(self):
        r"""getCharacter(ASTNode self) -> char"""
        return _libcombine.ASTNode_getCharacter(self)

    def getId(self):
        r"""getId(ASTNode self) -> string"""
        return _libcombine.ASTNode_getId(self)

    def getClass(self):
        r"""getClass(ASTNode self) -> string"""
        return _libcombine.ASTNode_getClass(self)

    def getStyle(self):
        r"""getStyle(ASTNode self) -> string"""
        return _libcombine.ASTNode_getStyle(self)

    def getInteger(self):
        r"""getInteger(ASTNode self) -> long"""
        return _libcombine.ASTNode_getInteger(self)

    def getName(self):
        r"""getName(ASTNode self) -> char const *"""
        return _libcombine.ASTNode_getName(self)

    def getOperatorName(self):
        r"""getOperatorName(ASTNode self) -> char const *"""
        return _libcombine.ASTNode_getOperatorName(self)

    def getNumerator(self):
        r"""getNumerator(ASTNode self) -> long"""
        return _libcombine.ASTNode_getNumerator(self)

    def getDenominator(self):
        r"""getDenominator(ASTNode self) -> long"""
        return _libcombine.ASTNode_getDenominator(self)

    def getReal(self):
        r"""getReal(ASTNode self) -> double"""
        return _libcombine.ASTNode_getReal(self)

    def getMantissa(self):
        r"""getMantissa(ASTNode self) -> double"""
        return _libcombine.ASTNode_getMantissa(self)

    def getExponent(self):
        r"""getExponent(ASTNode self) -> long"""
        return _libcombine.ASTNode_getExponent(self)

    def getValue(self):
        r"""getValue(ASTNode self) -> double"""
        return _libcombine.ASTNode_getValue(self)

    def getPrecedence(self):
        r"""getPrecedence(ASTNode self) -> int"""
        return _libcombine.ASTNode_getPrecedence(self)

    def getType(self):
        r"""getType(ASTNode self) -> ASTNodeType_t"""
        return _libcombine.ASTNode_getType(self)

    def getUnits(self):
        r"""getUnits(ASTNode self) -> string"""
        return _libcombine.ASTNode_getUnits(self)

    def isAvogadro(self):
        r"""isAvogadro(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isAvogadro(self)

    def isBoolean(self):
        r"""isBoolean(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isBoolean(self)

    def returnsBoolean(self, model=None):
        r"""returnsBoolean(ASTNode self, Model const * model=None) -> bool"""
        return _libcombine.ASTNode_returnsBoolean(self, model)

    def isConstant(self):
        r"""isConstant(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isConstant(self)

    def isCiNumber(self):
        r"""isCiNumber(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isCiNumber(self)

    def isConstantNumber(self):
        r"""isConstantNumber(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isConstantNumber(self)

    def isCSymbolFunction(self):
        r"""isCSymbolFunction(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isCSymbolFunction(self)

    def isFunction(self):
        r"""isFunction(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isFunction(self)

    def isInfinity(self):
        r"""isInfinity(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isInfinity(self)

    def isInteger(self):
        r"""isInteger(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isInteger(self)

    def isLambda(self):
        r"""isLambda(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isLambda(self)

    def isLog10(self):
        r"""isLog10(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isLog10(self)

    def isLogical(self):
        r"""isLogical(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isLogical(self)

    def isName(self):
        r"""isName(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isName(self)

    def isNaN(self):
        r"""isNaN(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isNaN(self)

    def isNegInfinity(self):
        r"""isNegInfinity(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isNegInfinity(self)

    def isNumber(self):
        r"""isNumber(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isNumber(self)

    def isOperator(self):
        r"""isOperator(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isOperator(self)

    def isPiecewise(self):
        r"""isPiecewise(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isPiecewise(self)

    def isRational(self):
        r"""isRational(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isRational(self)

    def isReal(self):
        r"""isReal(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isReal(self)

    def isRelational(self):
        r"""isRelational(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isRelational(self)

    def isSqrt(self):
        r"""isSqrt(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isSqrt(self)

    def isUMinus(self):
        r"""isUMinus(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isUMinus(self)

    def isUPlus(self):
        r"""isUPlus(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isUPlus(self)

    def isUserFunction(self):
        r"""isUserFunction(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isUserFunction(self)

    def hasTypeAndNumChildren(self, type, numchildren):
        r"""hasTypeAndNumChildren(ASTNode self, ASTNodeType_t type, unsigned int numchildren) -> int"""
        return _libcombine.ASTNode_hasTypeAndNumChildren(self, type, numchildren)

    def isUnknown(self):
        r"""isUnknown(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isUnknown(self)

    def isSetId(self):
        r"""isSetId(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isSetId(self)

    def isSetClass(self):
        r"""isSetClass(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isSetClass(self)

    def isSetStyle(self):
        r"""isSetStyle(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isSetStyle(self)

    def isSetUnits(self):
        r"""isSetUnits(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isSetUnits(self)

    def hasUnits(self):
        r"""hasUnits(ASTNode self) -> bool"""
        return _libcombine.ASTNode_hasUnits(self)

    def setCharacter(self, value):
        r"""setCharacter(ASTNode self, char value) -> int"""
        return _libcombine.ASTNode_setCharacter(self, value)

    def setId(self, id):
        r"""setId(ASTNode self, string id) -> int"""
        return _libcombine.ASTNode_setId(self, id)

    def setClass(self, className):
        r"""setClass(ASTNode self, string className) -> int"""
        return _libcombine.ASTNode_setClass(self, className)

    def setStyle(self, style):
        r"""setStyle(ASTNode self, string style) -> int"""
        return _libcombine.ASTNode_setStyle(self, style)

    def setName(self, name):
        r"""setName(ASTNode self, char const * name) -> int"""
        return _libcombine.ASTNode_setName(self, name)

    def setValue(self, *args):
        r"""
        setValue(ASTNode self, long value) -> int
        setValue(ASTNode self, long numerator, long denominator) -> int
        setValue(ASTNode self, double value) -> int
        setValue(ASTNode self, double mantissa, long exponent) -> int
        """
        return _libcombine.ASTNode_setValue(self, *args)

    def setType(self, type):
        r"""setType(ASTNode self, ASTNodeType_t type) -> int"""
        return _libcombine.ASTNode_setType(self, type)

    def setUnits(self, units):
        r"""setUnits(ASTNode self, string units) -> int"""
        return _libcombine.ASTNode_setUnits(self, units)

    def swapChildren(self, that):
        r"""swapChildren(ASTNode self, ASTNode that) -> int"""
        return _libcombine.ASTNode_swapChildren(self, that)

    def renameSIdRefs(self, oldid, newid):
        r"""renameSIdRefs(ASTNode self, string oldid, string newid)"""
        return _libcombine.ASTNode_renameSIdRefs(self, oldid, newid)

    def renameUnitSIdRefs(self, oldid, newid):
        r"""renameUnitSIdRefs(ASTNode self, string oldid, string newid)"""
        return _libcombine.ASTNode_renameUnitSIdRefs(self, oldid, newid)

    def replaceIDWithFunction(self, id, function):
        r"""replaceIDWithFunction(ASTNode self, string id, ASTNode function)"""
        return _libcombine.ASTNode_replaceIDWithFunction(self, id, function)

    def multiplyTimeBy(self, function):
        r"""multiplyTimeBy(ASTNode self, ASTNode function)"""
        return _libcombine.ASTNode_multiplyTimeBy(self, function)

    def unsetUnits(self):
        r"""unsetUnits(ASTNode self) -> int"""
        return _libcombine.ASTNode_unsetUnits(self)

    def unsetId(self):
        r"""unsetId(ASTNode self) -> int"""
        return _libcombine.ASTNode_unsetId(self)

    def unsetClass(self):
        r"""unsetClass(ASTNode self) -> int"""
        return _libcombine.ASTNode_unsetClass(self)

    def unsetStyle(self):
        r"""unsetStyle(ASTNode self) -> int"""
        return _libcombine.ASTNode_unsetStyle(self)

    def getDefinitionURL(self):
        r"""getDefinitionURL(ASTNode self) -> XMLAttributes"""
        return _libcombine.ASTNode_getDefinitionURL(self)

    def replaceArgument(self, bvar, arg):
        r"""replaceArgument(ASTNode self, string bvar, ASTNode arg)"""
        return _libcombine.ASTNode_replaceArgument(self, bvar, arg)

    def getParentSBMLObject(self):
        r"""getParentSBMLObject(ASTNode self) -> SBase *"""
        return _libcombine.ASTNode_getParentSBMLObject(self)

    def unsetParentSBMLObject(self):
        r"""unsetParentSBMLObject(ASTNode self) -> int"""
        return _libcombine.ASTNode_unsetParentSBMLObject(self)

    def isSetParentSBMLObject(self):
        r"""isSetParentSBMLObject(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isSetParentSBMLObject(self)

    def reduceToBinary(self):
        r"""reduceToBinary(ASTNode self)"""
        return _libcombine.ASTNode_reduceToBinary(self)

    def unsetUserData(self):
        r"""unsetUserData(ASTNode self) -> int"""
        return _libcombine.ASTNode_unsetUserData(self)

    def isSetUserData(self):
        r"""isSetUserData(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isSetUserData(self)

    def isWellFormedASTNode(self):
        r"""isWellFormedASTNode(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isWellFormedASTNode(self)

    def hasCorrectNumberArguments(self):
        r"""hasCorrectNumberArguments(ASTNode self) -> bool"""
        return _libcombine.ASTNode_hasCorrectNumberArguments(self)

    def getDefinitionURLString(self):
        r"""getDefinitionURLString(ASTNode self) -> string"""
        return _libcombine.ASTNode_getDefinitionURLString(self)

    def representsBvar(self):
        r"""representsBvar(ASTNode self) -> bool"""
        return _libcombine.ASTNode_representsBvar(self)

    def isBvar(self):
        r"""isBvar(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isBvar(self)

    def setBvar(self):
        r"""setBvar(ASTNode self)"""
        return _libcombine.ASTNode_setBvar(self)

    def usesL3V2MathConstructs(self):
        r"""usesL3V2MathConstructs(ASTNode self) -> bool"""
        return _libcombine.ASTNode_usesL3V2MathConstructs(self)

    def usesRateOf(self):
        r"""usesRateOf(ASTNode self) -> bool"""
        return _libcombine.ASTNode_usesRateOf(self)

    def isQualifier(self):
        r"""isQualifier(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isQualifier(self)

    def isSemantics(self):
        r"""isSemantics(ASTNode self) -> bool"""
        return _libcombine.ASTNode_isSemantics(self)

    def getNumBvars(self):
        r"""getNumBvars(ASTNode self) -> unsigned int"""
        return _libcombine.ASTNode_getNumBvars(self)

    def addPlugin(self, plugin):
        r"""addPlugin(ASTNode self, ASTBasePlugin * plugin)"""
        return _libcombine.ASTNode_addPlugin(self, plugin)

    def loadASTPlugins(self, sbmlns):
        r"""loadASTPlugins(ASTNode self, SBMLNamespaces const * sbmlns)"""
        return _libcombine.ASTNode_loadASTPlugins(self, sbmlns)

    def loadASTPlugin(self, pkgName):
        r"""loadASTPlugin(ASTNode self, string pkgName)"""
        return _libcombine.ASTNode_loadASTPlugin(self, pkgName)

    def getASTPlugin(self, *args):
        r"""
        getASTPlugin(ASTNode self, SBMLNamespaces const * sbmlns) -> ASTBasePlugin
        getASTPlugin(ASTNode self, ASTNodeType_t type) -> ASTBasePlugin
        getASTPlugin(ASTNode self, string name, bool isCsymbol=False, bool strCmpIsCaseSensitive=False) -> ASTBasePlugin
        getASTPlugin(ASTNode self, SBMLNamespaces const * sbmlns) -> ASTBasePlugin const
        getASTPlugin(ASTNode self, ASTNodeType_t type) -> ASTBasePlugin const
        getASTPlugin(ASTNode self, string name, bool isCsymbol=False, bool strCmpIsCaseSensitive=False) -> ASTBasePlugin const
        """
        return _libcombine.ASTNode_getASTPlugin(self, *args)

    def getPlugin(self, *args):
        r"""
        getPlugin(ASTNode self, string package) -> ASTBasePlugin
        getPlugin(ASTNode self, string package) -> ASTBasePlugin const
        getPlugin(ASTNode self, unsigned int n) -> ASTBasePlugin
        getPlugin(ASTNode self, unsigned int n) -> ASTBasePlugin const *
        """
        return _libcombine.ASTNode_getPlugin(self, *args)

    def getNumPlugins(self):
        r"""getNumPlugins(ASTNode self) -> unsigned int"""
        return _libcombine.ASTNode_getNumPlugins(self)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


    def getListOfNodes(self):
        r"""getListOfNodes(ASTNode self) -> ASTNodeList"""
        return _libcombine.ASTNode_getListOfNodes(self)

# Register ASTNode in _libcombine:
_libcombine.ASTNode_swigregister(ASTNode)


def readMathMLFromString(xml):
    r"""readMathMLFromString(char const * xml) -> ASTNode"""
    return _libcombine.readMathMLFromString(xml)

def readMathMLFromStringWithNamespaces(xml, xmlns):
    r"""readMathMLFromStringWithNamespaces(char const * xml, XMLNamespaces_t * xmlns) -> ASTNode"""
    return _libcombine.readMathMLFromStringWithNamespaces(xml, xmlns)

def writeMathMLToString(node):
    r"""writeMathMLToString(ASTNode node) -> char *"""
    return _libcombine.writeMathMLToString(node)

def writeMathMLWithNamespaceToString(node, sbmlns):
    r"""writeMathMLWithNamespaceToString(ASTNode node, SBMLNamespaces_t * sbmlns) -> char *"""
    return _libcombine.writeMathMLWithNamespaceToString(node, sbmlns)

def parseFormula(formula):
    r"""parseFormula(char const * formula) -> ASTNode"""
    return _libcombine.parseFormula(formula)

def formulaToL3String(tree):
    r"""formulaToL3String(ASTNode tree) -> char *"""
    return _libcombine.formulaToL3String(tree)

def formulaToL3StringWithSettings(tree, settings):
    r"""formulaToL3StringWithSettings(ASTNode tree, L3ParserSettings_t const * settings) -> char *"""
    return _libcombine.formulaToL3StringWithSettings(tree, settings)

def formulaToString(tree):
    r"""formulaToString(ASTNode tree) -> char *"""
    return _libcombine.formulaToString(tree)

def parseL3Formula(formula):
    r"""parseL3Formula(char const * formula) -> ASTNode"""
    return _libcombine.parseL3Formula(formula)

def parseL3FormulaWithModel(formula, model):
    r"""parseL3FormulaWithModel(char const * formula, Model_t const * model) -> ASTNode"""
    return _libcombine.parseL3FormulaWithModel(formula, model)

def parseL3FormulaWithSettings(formula, settings):
    r"""parseL3FormulaWithSettings(char const * formula, L3ParserSettings_t const * settings) -> ASTNode"""
    return _libcombine.parseL3FormulaWithSettings(formula, settings)

def getDefaultL3ParserSettings():
    r"""getDefaultL3ParserSettings() -> L3ParserSettings_t *"""
    return _libcombine.getDefaultL3ParserSettings()

def getLastParseL3Error():
    r"""getLastParseL3Error() -> char *"""
    return _libcombine.getLastParseL3Error()

def SBML_deleteL3Parser():
    r"""SBML_deleteL3Parser()"""
    return _libcombine.SBML_deleteL3Parser()
L3P_PARSE_LOG_AS_LOG10 = _libcombine.L3P_PARSE_LOG_AS_LOG10

L3P_PARSE_LOG_AS_LN = _libcombine.L3P_PARSE_LOG_AS_LN

L3P_PARSE_LOG_AS_ERROR = _libcombine.L3P_PARSE_LOG_AS_ERROR

L3P_COLLAPSE_UNARY_MINUS = _libcombine.L3P_COLLAPSE_UNARY_MINUS

L3P_EXPAND_UNARY_MINUS = _libcombine.L3P_EXPAND_UNARY_MINUS

L3P_PARSE_UNITS = _libcombine.L3P_PARSE_UNITS

L3P_NO_UNITS = _libcombine.L3P_NO_UNITS

L3P_AVOGADRO_IS_CSYMBOL = _libcombine.L3P_AVOGADRO_IS_CSYMBOL

L3P_AVOGADRO_IS_NAME = _libcombine.L3P_AVOGADRO_IS_NAME

L3P_COMPARE_BUILTINS_CASE_INSENSITIVE = _libcombine.L3P_COMPARE_BUILTINS_CASE_INSENSITIVE

L3P_COMPARE_BUILTINS_CASE_SENSITIVE = _libcombine.L3P_COMPARE_BUILTINS_CASE_SENSITIVE

L3P_MODULO_IS_REM = _libcombine.L3P_MODULO_IS_REM

L3P_MODULO_IS_PIECEWISE = _libcombine.L3P_MODULO_IS_PIECEWISE

L3P_PARSE_L3V2_FUNCTIONS_DIRECTLY = _libcombine.L3P_PARSE_L3V2_FUNCTIONS_DIRECTLY

L3P_PARSE_L3V2_FUNCTIONS_AS_GENERIC = _libcombine.L3P_PARSE_L3V2_FUNCTIONS_AS_GENERIC

L3P_PARSE_PACKAGE_MATH_DIRECTLY = _libcombine.L3P_PARSE_PACKAGE_MATH_DIRECTLY

L3P_PARSE_PACKAGE_MATH_AS_GENERIC = _libcombine.L3P_PARSE_PACKAGE_MATH_AS_GENERIC

INFIX_SYNTAX_NAMED_SQUARE_BRACKETS = _libcombine.INFIX_SYNTAX_NAMED_SQUARE_BRACKETS

INFIX_SYNTAX_CURLY_BRACES = _libcombine.INFIX_SYNTAX_CURLY_BRACES

INFIX_SYNTAX_CURLY_BRACES_SEMICOLON = _libcombine.INFIX_SYNTAX_CURLY_BRACES_SEMICOLON

class L3ParserSettings(object):
    r"""Proxy of C++ L3ParserSettings class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(L3ParserSettings self) -> L3ParserSettings
        __init__(L3ParserSettings self, Model * model, ParseLogType_t parselog, bool collapseminus, bool parseunits, bool avocsymbol, bool caseSensitive=False, SBMLNamespaces * sbmlns=None, bool moduloL3v2=False, bool l3v2functions=False) -> L3ParserSettings
        __init__(L3ParserSettings self, L3ParserSettings source) -> L3ParserSettings
        """
        _libcombine.L3ParserSettings_swiginit(self, _libcombine.new_L3ParserSettings(*args))
    __swig_destroy__ = _libcombine.delete_L3ParserSettings

    def setModel(self, model):
        r"""setModel(L3ParserSettings self, Model const * model)"""
        return _libcombine.L3ParserSettings_setModel(self, model)

    def getModel(self):
        r"""getModel(L3ParserSettings self) -> Model const *"""
        return _libcombine.L3ParserSettings_getModel(self)

    def unsetModel(self):
        r"""unsetModel(L3ParserSettings self)"""
        return _libcombine.L3ParserSettings_unsetModel(self)

    def setParseLog(self, type):
        r"""setParseLog(L3ParserSettings self, ParseLogType_t type)"""
        return _libcombine.L3ParserSettings_setParseLog(self, type)

    def getParseLog(self):
        r"""getParseLog(L3ParserSettings self) -> ParseLogType_t"""
        return _libcombine.L3ParserSettings_getParseLog(self)

    def setParseCollapseMinus(self, collapseminus):
        r"""setParseCollapseMinus(L3ParserSettings self, bool collapseminus)"""
        return _libcombine.L3ParserSettings_setParseCollapseMinus(self, collapseminus)

    def getParseCollapseMinus(self):
        r"""getParseCollapseMinus(L3ParserSettings self) -> bool"""
        return _libcombine.L3ParserSettings_getParseCollapseMinus(self)

    def setParseUnits(self, units):
        r"""setParseUnits(L3ParserSettings self, bool units)"""
        return _libcombine.L3ParserSettings_setParseUnits(self, units)

    def getParseUnits(self):
        r"""getParseUnits(L3ParserSettings self) -> bool"""
        return _libcombine.L3ParserSettings_getParseUnits(self)

    def setParseAvogadroCsymbol(self, l2only):
        r"""setParseAvogadroCsymbol(L3ParserSettings self, bool l2only)"""
        return _libcombine.L3ParserSettings_setParseAvogadroCsymbol(self, l2only)

    def getParseAvogadroCsymbol(self):
        r"""getParseAvogadroCsymbol(L3ParserSettings self) -> bool"""
        return _libcombine.L3ParserSettings_getParseAvogadroCsymbol(self)

    def setComparisonCaseSensitivity(self, strcmp):
        r"""setComparisonCaseSensitivity(L3ParserSettings self, bool strcmp)"""
        return _libcombine.L3ParserSettings_setComparisonCaseSensitivity(self, strcmp)

    def getComparisonCaseSensitivity(self):
        r"""getComparisonCaseSensitivity(L3ParserSettings self) -> bool"""
        return _libcombine.L3ParserSettings_getComparisonCaseSensitivity(self)

    def setParseModuloL3v2(self, modulol3v2):
        r"""setParseModuloL3v2(L3ParserSettings self, bool modulol3v2)"""
        return _libcombine.L3ParserSettings_setParseModuloL3v2(self, modulol3v2)

    def getParseModuloL3v2(self):
        r"""getParseModuloL3v2(L3ParserSettings self) -> bool"""
        return _libcombine.L3ParserSettings_getParseModuloL3v2(self)

    def setParseL3v2Functions(self, l3v2functions):
        r"""setParseL3v2Functions(L3ParserSettings self, bool l3v2functions)"""
        return _libcombine.L3ParserSettings_setParseL3v2Functions(self, l3v2functions)

    def getParseL3v2Functions(self):
        r"""getParseL3v2Functions(L3ParserSettings self) -> bool"""
        return _libcombine.L3ParserSettings_getParseL3v2Functions(self)

    def setParsePackageMath(self, package, parsepackage):
        r"""setParsePackageMath(L3ParserSettings self, ExtendedMathType_t package, bool parsepackage)"""
        return _libcombine.L3ParserSettings_setParsePackageMath(self, package, parsepackage)

    def getParsePackageMath(self, package):
        r"""getParsePackageMath(L3ParserSettings self, ExtendedMathType_t package) -> bool"""
        return _libcombine.L3ParserSettings_getParsePackageMath(self, package)

    def visitPackageInfixSyntax(self, parent, node, sb):
        r"""visitPackageInfixSyntax(L3ParserSettings self, ASTNode parent, ASTNode node, StringBuffer_t * sb)"""
        return _libcombine.L3ParserSettings_visitPackageInfixSyntax(self, parent, node, sb)

# Register L3ParserSettings in _libcombine:
_libcombine.L3ParserSettings_swigregister(L3ParserSettings)

class CaReader(object):
    r"""Proxy of C++ CaReader class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(CaReader self) -> CaReader"""
        _libcombine.CaReader_swiginit(self, _libcombine.new_CaReader())
    __swig_destroy__ = _libcombine.delete_CaReader

    def readOMEX(*args):
      """
      readOMEX(self, string filename) -> CaOmexManifest

      Reads an SEDML document from a file.

      This method is identical to readOMEXFromFile().

      If the file named 'filename' does not exist or its content is not
      valid SEDML, one or more errors will be logged with the CaOmexManifest
      object returned by this method.  Callers can use the methods on
      CaOmexManifest such as CaOmexManifest.getNumErrors() and
      CaOmexManifest.getError() to get the errors.  The object returned by
      CaOmexManifest.getError() is an CaError object, and it has methods to
      get the error code, category, and severity level of the problem, as
      well as a textual description of the problem.  The possible severity
      levels range from informational messages to fatal errors; see the
      documentation for CaError for more information.

      If the file 'filename' could not be read, the file-reading error will
      appear first.  The error code can provide a clue about what happened.
      For example, a file might be unreadable (either because it does not
      actually exist or because the user does not have the necessary access
      priviledges to read it) or some sort of file operation error may have
      been reported by the underlying operating system.  Callers can check
      for these situations using a program fragment such as the following:

       reader = CaReader()
       doc    = reader.readOMEX(filename)

       if doc.getNumErrors() > 0:
         if doc.getError(0).getErrorId() == libsedml.XMLFileUnreadable:
    # Handle case of unreadable file here.
         elif doc.getError(0).getErrorId() == libsedml.XMLFileOperationError:
    # Handle case of other file error here.
         else:
    # Handle other error cases here.

      If the given filename ends with the suffix \".gz\" (for example,
      \"myfile.xml.gz\"), the file is assumed to be compressed in gzip format
      and will be automatically decompressed upon reading.  Similarly, if the
      given filename ends with \".zip\" or \".bz2\", the file is assumed to be
      compressed in zip or bzip2 format (respectively).  Files whose names
      lack these suffixes will be read uncompressed.  Note that if the file
      is in zip format but the archive contains more than one file, only the
      first file in the archive will be read and the rest ignored.

      To read a gzip/zip file, libSEDML needs to be configured and linked with
      the zlib library at compile time.  It also needs to be linked with the
      bzip2 library to read files in bzip2 format.  (Both of these are the
      default configurations for libSEDML.)  Errors about unreadable files
      will be logged if a compressed filename is given and libSEDML was not
      linked with the corresponding required library.

      Parameter 'filename is the name or full pathname of the file to be
      read.

      Returns a pointer to the CaOmexManifest created from the SEDML content.

      See also CaError.

      Note:

      LibSEDML versions 2.x and later versions behave differently in
      error handling in several respects.  One difference is how early some
      errors are caught and whether libSEDML continues processing a file in
      the face of some early errors.  In general, libSEDML versions after 2.x
      stop parsing SEDML inputs sooner than libSEDML version 2.x in the face
      of XML errors, because the errors may invalidate any further SEDML
      content.  For example, a missing XML declaration at the beginning of
      the file was ignored by libSEDML 2.x but in version 3.x and later, it
      will cause libSEDML to stop parsing the rest of the input altogether.
      While this behavior may seem more severe and intolerant, it was
      necessary in order to provide uniform behavior regardless of which
      underlying XML parser (Expat, Xerces, libxml2) is being used by
      libSEDML.  The XML parsers themselves behave differently in their error
      reporting, and sometimes libSEDML has to resort to the lowest common
      denominator.
      """
      args_copy    = list(args)
      args_copy[1] = conditional_abspath(args[1])
      return _libsedml.CaReader_readOMEX(*args_copy)



    def readOMEXFromFile(*args):
      """
      readOMEXFromFile(self, string filename) -> CaOmexManifest

      Reads an SEDML document from a file.

      This method is identical to readOMEXFromFile().

      If the file named 'filename' does not exist or its content is not
      valid SEDML, one or more errors will be logged with the CaOmexManifest
      object returned by this method.  Callers can use the methods on
      CaOmexManifest such as CaOmexManifest.getNumErrors() and
      CaOmexManifest.getError() to get the errors.  The object returned by
      CaOmexManifest.getError() is an CaError object, and it has methods to
      get the error code, category, and severity level of the problem, as
      well as a textual description of the problem.  The possible severity
      levels range from informational messages to fatal errors; see the
      documentation for CaError for more information.

      If the file 'filename' could not be read, the file-reading error will
      appear first.  The error code can provide a clue about what happened.
      For example, a file might be unreadable (either because it does not
      actually exist or because the user does not have the necessary access
      priviledges to read it) or some sort of file operation error may have
      been reported by the underlying operating system.  Callers can check
      for these situations using a program fragment such as the following:

       reader = CaReader()
       doc    = reader.readOMEX(filename)

       if doc.getNumErrors() > 0:
         if doc.getError(0).getErrorId() == libsedml.XMLFileUnreadable:
    # Handle case of unreadable file here.
         elif doc.getError(0).getErrorId() == libsedml.XMLFileOperationError:
    # Handle case of other file error here.
         else:
    # Handle other error cases here.

      If the given filename ends with the suffix \".gz\" (for example,
      \"myfile.xml.gz\"), the file is assumed to be compressed in gzip format
      and will be automatically decompressed upon reading.  Similarly, if the
      given filename ends with \".zip\" or \".bz2\", the file is assumed to be
      compressed in zip or bzip2 format (respectively).  Files whose names
      lack these suffixes will be read uncompressed.  Note that if the file
      is in zip format but the archive contains more than one file, only the
      first file in the archive will be read and the rest ignored.

      To read a gzip/zip file, libSEDML needs to be configured and linked with
      the zlib library at compile time.  It also needs to be linked with the
      bzip2 library to read files in bzip2 format.  (Both of these are the
      default configurations for libSEDML.)  Errors about unreadable files
      will be logged if a compressed filename is given and libSEDML was not
      linked with the corresponding required library.

      Parameter 'filename is the name or full pathname of the file to be
      read.

      Returns a pointer to the CaOmexManifest created from the SEDML content.

      See also CaError.

      Note:

      LibSEDML versions 2.x and later versions behave differently in
      error handling in several respects.  One difference is how early some
      errors are caught and whether libSEDML continues processing a file in
      the face of some early errors.  In general, libSEDML versions after 2.x
      stop parsing SEDML inputs sooner than libSEDML version 2.x in the face
      of XML errors, because the errors may invalidate any further SEDML
      content.  For example, a missing XML declaration at the beginning of
      the file was ignored by libSEDML 2.x but in version 3.x and later, it
      will cause libSEDML to stop parsing the rest of the input altogether.
      While this behavior may seem more severe and intolerant, it was
      necessary in order to provide uniform behavior regardless of which
      underlying XML parser (Expat, Xerces, libxml2) is being used by
      libSEDML.  The XML parsers themselves behave differently in their error
      reporting, and sometimes libSEDML has to resort to the lowest common
      denominator.
      """
      args_copy    = list(args)
      args_copy[1] = conditional_abspath(args[1])
      return _libsedml.CaReader_readOMEX(*args_copy)



    def readOMEXFromString(self, xml):
        r"""readOMEXFromString(CaReader self, string xml) -> CaOmexManifest"""
        return _libcombine.CaReader_readOMEXFromString(self, xml)

    @staticmethod
    def hasZlib():
        r"""hasZlib() -> bool"""
        return _libcombine.CaReader_hasZlib()

    @staticmethod
    def hasBzip2():
        r"""hasBzip2() -> bool"""
        return _libcombine.CaReader_hasBzip2()

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register CaReader in _libcombine:
_libcombine.CaReader_swigregister(CaReader)

def CaReader_hasZlib():
    r"""CaReader_hasZlib() -> bool"""
    return _libcombine.CaReader_hasZlib()

def CaReader_hasBzip2():
    r"""CaReader_hasBzip2() -> bool"""
    return _libcombine.CaReader_hasBzip2()


def readOMEXFromFile(filename):
    r"""readOMEXFromFile(char const * filename) -> CaOmexManifest"""
    return _libcombine.readOMEXFromFile(filename)

def readOMEXFromString(xml):
    r"""readOMEXFromString(char const * xml) -> CaOmexManifest"""
    return _libcombine.readOMEXFromString(xml)
class CaWriter(object):
    r"""Proxy of C++ CaWriter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(CaWriter self) -> CaWriter"""
        _libcombine.CaWriter_swiginit(self, _libcombine.new_CaWriter())
    __swig_destroy__ = _libcombine.delete_CaWriter

    def setProgramName(self, name):
        r"""setProgramName(CaWriter self, string name) -> int"""
        return _libcombine.CaWriter_setProgramName(self, name)

    def setProgramVersion(self, version):
        r"""setProgramVersion(CaWriter self, string version) -> int"""
        return _libcombine.CaWriter_setProgramVersion(self, version)

    def writeOMEX(self, *args):
        r"""
        writeOMEX(CaWriter self, CaOmexManifest d, string filename) -> bool
        writeOMEX(CaWriter self, CaOmexManifest d, ostream stream) -> bool
        """
        return _libcombine.CaWriter_writeOMEX(self, *args)

    def writeToString(self, d):
        r"""writeToString(CaWriter self, CaOmexManifest d) -> char *"""
        return _libcombine.CaWriter_writeToString(self, d)

    def writeOMEXToFile(self, d, filename):
        r"""writeOMEXToFile(CaWriter self, CaOmexManifest d, string filename) -> bool"""
        return _libcombine.CaWriter_writeOMEXToFile(self, d, filename)

    def writeOMEXToString(self, d):
        r"""writeOMEXToString(CaWriter self, CaOmexManifest d) -> char *"""
        return _libcombine.CaWriter_writeOMEXToString(self, d)

    @staticmethod
    def hasZlib():
        r"""hasZlib() -> bool"""
        return _libcombine.CaWriter_hasZlib()

    @staticmethod
    def hasBzip2():
        r"""hasBzip2() -> bool"""
        return _libcombine.CaWriter_hasBzip2()

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register CaWriter in _libcombine:
_libcombine.CaWriter_swigregister(CaWriter)

def CaWriter_hasZlib():
    r"""CaWriter_hasZlib() -> bool"""
    return _libcombine.CaWriter_hasZlib()

def CaWriter_hasBzip2():
    r"""CaWriter_hasBzip2() -> bool"""
    return _libcombine.CaWriter_hasBzip2()


def writeOMEX(d, filename):
    r"""writeOMEX(CaOmexManifest d, char const * filename) -> int"""
    return _libcombine.writeOMEX(d, filename)

def writeOMEXToString(d):
    r"""writeOMEXToString(CaOmexManifest d) -> char *"""
    return _libcombine.writeOMEXToString(d)

def writeOMEXToFile(d, filename):
    r"""writeOMEXToFile(CaOmexManifest d, char const * filename) -> int"""
    return _libcombine.writeOMEXToFile(d, filename)
OMEX_UNKNOWN = _libcombine.OMEX_UNKNOWN

LIB_COMBINE_CONTENT = _libcombine.LIB_COMBINE_CONTENT

LIB_COMBINE_OMEXMANIFEST = _libcombine.LIB_COMBINE_OMEXMANIFEST

LIB_COMBINE_CROSSREF = _libcombine.LIB_COMBINE_CROSSREF

OMEX_LIST_OF = _libcombine.OMEX_LIST_OF


def CaTypeCode_toString(tc):
    r"""CaTypeCode_toString(int tc) -> char const *"""
    return _libcombine.CaTypeCode_toString(tc)
class CaBase(object):
    r"""Proxy of C++ CaBase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcombine.delete_CaBase

    def clone(self):
        r"""clone(CaBase self) -> CaBase"""
        return _libcombine.CaBase_clone(self)

    def getElementBySId(self, *args):
        r"""
        getElementBySId(CaBase self, string id) -> CaBase
        getElementBySId(CaBase self, string metaid) -> CaBase
        """
        return _libcombine.CaBase_getElementBySId(self, *args)

    def getElementByMetaId(self, *args):
        r"""
        getElementByMetaId(CaBase self, string metaid) -> CaBase
        getElementByMetaId(CaBase self, string metaid) -> CaBase
        """
        return _libcombine.CaBase_getElementByMetaId(self, *args)

    def getMetaId(self):
        r"""getMetaId(CaBase self) -> string"""
        return _libcombine.CaBase_getMetaId(self)

    def getId(self):
        r"""getId(CaBase self) -> string"""
        return _libcombine.CaBase_getId(self)

    def getNotes(self, *args):
        r"""
        getNotes(CaBase self) -> XMLNode
        getNotes(CaBase self) -> XMLNode
        """
        return _libcombine.CaBase_getNotes(self, *args)

    def getNotesString(self, *args):
        r"""
        getNotesString(CaBase self) -> string
        getNotesString(CaBase self) -> string
        """
        return _libcombine.CaBase_getNotesString(self, *args)

    def getAnnotation(self, *args):
        r"""
        getAnnotation(CaBase self) -> XMLNode
        getAnnotation(CaBase self) -> XMLNode
        """
        return _libcombine.CaBase_getAnnotation(self, *args)

    def getAnnotationString(self, *args):
        r"""
        getAnnotationString(CaBase self) -> string
        getAnnotationString(CaBase self) -> string
        """
        return _libcombine.CaBase_getAnnotationString(self, *args)

    def getNamespaces(self, *args):
        r"""
        getNamespaces(CaBase self) -> XMLNamespaces
        getNamespaces(CaBase self) -> XMLNamespaces
        """
        return _libcombine.CaBase_getNamespaces(self, *args)

    def getCaOmexManifest(self, *args):
        r"""
        getCaOmexManifest(CaBase self) -> CaOmexManifest
        getCaOmexManifest(CaBase self) -> CaOmexManifest
        """
        return _libcombine.CaBase_getCaOmexManifest(self, *args)

    def getParentCaObject(self, *args):
        r"""
        getParentCaObject(CaBase self) -> CaBase
        getParentCaObject(CaBase self) -> CaBase
        """
        return _libcombine.CaBase_getParentCaObject(self, *args)

    def getAncestorOfType(self, *args):
        r"""
        getAncestorOfType(CaBase self, int type) -> CaBase
        getAncestorOfType(CaBase self, int type) -> CaBase
        """
        return _libcombine.CaBase_getAncestorOfType(self, *args)

    def getLine(self):
        r"""getLine(CaBase self) -> unsigned int"""
        return _libcombine.CaBase_getLine(self)

    def getColumn(self):
        r"""getColumn(CaBase self) -> unsigned int"""
        return _libcombine.CaBase_getColumn(self)

    def isSetMetaId(self):
        r"""isSetMetaId(CaBase self) -> bool"""
        return _libcombine.CaBase_isSetMetaId(self)

    def isSetId(self):
        r"""isSetId(CaBase self) -> bool"""
        return _libcombine.CaBase_isSetId(self)

    def isSetNotes(self):
        r"""isSetNotes(CaBase self) -> bool"""
        return _libcombine.CaBase_isSetNotes(self)

    def isSetAnnotation(self):
        r"""isSetAnnotation(CaBase self) -> bool"""
        return _libcombine.CaBase_isSetAnnotation(self)

    def setMetaId(self, metaid):
        r"""setMetaId(CaBase self, string metaid) -> int"""
        return _libcombine.CaBase_setMetaId(self, metaid)

    def setId(self, sid):
        r"""setId(CaBase self, string sid) -> int"""
        return _libcombine.CaBase_setId(self, sid)

    def setAnnotation(self, *args):
        r"""
        setAnnotation(CaBase self, XMLNode annotation) -> int
        setAnnotation(CaBase self, string annotation) -> int
        """
        return _libcombine.CaBase_setAnnotation(self, *args)

    def appendAnnotation(self, *args):
        r"""
        appendAnnotation(CaBase self, XMLNode annotation) -> int
        appendAnnotation(CaBase self, string annotation) -> int
        """
        return _libcombine.CaBase_appendAnnotation(self, *args)

    def removeTopLevelAnnotationElement(self, *args):
        r"""removeTopLevelAnnotationElement(CaBase self, string elementName, string elementURI="") -> int"""
        return _libcombine.CaBase_removeTopLevelAnnotationElement(self, *args)

    def replaceTopLevelAnnotationElement(self, *args):
        r"""
        replaceTopLevelAnnotationElement(CaBase self, XMLNode annotation) -> int
        replaceTopLevelAnnotationElement(CaBase self, string annotation) -> int
        """
        return _libcombine.CaBase_replaceTopLevelAnnotationElement(self, *args)

    def setNotes(self, *args):
        r"""
        setNotes(CaBase self, XMLNode notes) -> int
        setNotes(CaBase self, string notes, bool addXHTMLMarkup=False) -> int
        """
        return _libcombine.CaBase_setNotes(self, *args)

    def appendNotes(self, *args):
        r"""
        appendNotes(CaBase self, XMLNode notes) -> int
        appendNotes(CaBase self, string notes) -> int
        """
        return _libcombine.CaBase_appendNotes(self, *args)

    def connectToParent(self, parent):
        r"""connectToParent(CaBase self, CaBase parent)"""
        return _libcombine.CaBase_connectToParent(self, parent)

    def connectToChild(self):
        r"""connectToChild(CaBase self)"""
        return _libcombine.CaBase_connectToChild(self)

    def setNamespaces(self, xmlns):
        r"""setNamespaces(CaBase self, XMLNamespaces xmlns) -> int"""
        return _libcombine.CaBase_setNamespaces(self, xmlns)

    def unsetMetaId(self):
        r"""unsetMetaId(CaBase self) -> int"""
        return _libcombine.CaBase_unsetMetaId(self)

    def unsetId(self):
        r"""unsetId(CaBase self) -> int"""
        return _libcombine.CaBase_unsetId(self)

    def unsetNotes(self):
        r"""unsetNotes(CaBase self) -> int"""
        return _libcombine.CaBase_unsetNotes(self)

    def unsetAnnotation(self):
        r"""unsetAnnotation(CaBase self) -> int"""
        return _libcombine.CaBase_unsetAnnotation(self)

    def getLevel(self):
        r"""getLevel(CaBase self) -> unsigned int"""
        return _libcombine.CaBase_getLevel(self)

    def getVersion(self):
        r"""getVersion(CaBase self) -> unsigned int"""
        return _libcombine.CaBase_getVersion(self)

    def getTypeCode(self):
        r"""getTypeCode(CaBase self) -> int"""
        return _libcombine.CaBase_getTypeCode(self)

    def hasValidLevelVersionNamespaceCombination(self):
        r"""hasValidLevelVersionNamespaceCombination(CaBase self) -> bool"""
        return _libcombine.CaBase_hasValidLevelVersionNamespaceCombination(self)

    def getElementName(self):
        r"""getElementName(CaBase self) -> string"""
        return _libcombine.CaBase_getElementName(self)

    def toCa(self):
        r"""toCa(CaBase self) -> char *"""
        return _libcombine.CaBase_toCa(self)

    def read(self, stream):
        r"""read(CaBase self, XMLInputStream stream)"""
        return _libcombine.CaBase_read(self, stream)

    def write(self, stream):
        r"""write(CaBase self, XMLOutputStream stream)"""
        return _libcombine.CaBase_write(self, stream)

    def hasRequiredAttributes(self):
        r"""hasRequiredAttributes(CaBase self) -> bool"""
        return _libcombine.CaBase_hasRequiredAttributes(self)

    def hasRequiredElements(self):
        r"""hasRequiredElements(CaBase self) -> bool"""
        return _libcombine.CaBase_hasRequiredElements(self)

    def checkCompatibility(self, object):
        r"""checkCompatibility(CaBase self, CaBase object) -> int"""
        return _libcombine.CaBase_checkCompatibility(self, object)

    def setCaNamespaces(self, omexns):
        r"""setCaNamespaces(CaBase self, CaNamespaces omexns) -> int"""
        return _libcombine.CaBase_setCaNamespaces(self, omexns)

    def setCaNamespacesAndOwn(self, disownedNs):
        r"""setCaNamespacesAndOwn(CaBase self, CaNamespaces disownedNs)"""
        return _libcombine.CaBase_setCaNamespacesAndOwn(self, disownedNs)

    def getCaNamespaces(self):
        r"""getCaNamespaces(CaBase self) -> CaNamespaces"""
        return _libcombine.CaBase_getCaNamespaces(self)

    def removeFromParentAndDelete(self):
        r"""removeFromParentAndDelete(CaBase self) -> int"""
        return _libcombine.CaBase_removeFromParentAndDelete(self)

    def matchesCaNamespaces(self, *args):
        r"""
        matchesCaNamespaces(CaBase self, CaBase sb) -> bool
        matchesCaNamespaces(CaBase self, CaBase sb) -> bool
        """
        return _libcombine.CaBase_matchesCaNamespaces(self, *args)

    def matchesRequiredCaNamespacesForAddition(self, *args):
        r"""
        matchesRequiredCaNamespacesForAddition(CaBase self, CaBase sb) -> bool
        matchesRequiredCaNamespacesForAddition(CaBase self, CaBase sb) -> bool
        """
        return _libcombine.CaBase_matchesRequiredCaNamespacesForAddition(self, *args)

    def isSetUserData(self):
        r"""isSetUserData(CaBase self) -> bool"""
        return _libcombine.CaBase_isSetUserData(self)

    def unsetUserData(self):
        r"""unsetUserData(CaBase self) -> int"""
        return _libcombine.CaBase_unsetUserData(self)

    def getErrorLog(self):
        r"""getErrorLog(CaBase self) -> CaErrorLog"""
        return _libcombine.CaBase_getErrorLog(self)

    __metaclass__ = AutoProperty


    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


    def getListOfAllElements(self):
        r"""getListOfAllElements(CaBase self) -> CaBaseList"""
        return _libcombine.CaBase_getListOfAllElements(self)

# Register CaBase in _libcombine:
_libcombine.CaBase_swigregister(CaBase)

class CaListOf(CaBase):
    r"""Proxy of C++ CaListOf class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcombine.delete_CaListOf

    def __init__(self, *args):
        r"""
        __init__(CaListOf self, unsigned int level=OMEX_DEFAULT_LEVEL, unsigned int version=OMEX_DEFAULT_VERSION) -> CaListOf
        __init__(CaListOf self, CaNamespaces omexns) -> CaListOf
        __init__(CaListOf self, CaListOf orig) -> CaListOf
        """
        _libcombine.CaListOf_swiginit(self, _libcombine.new_CaListOf(*args))

    def clone(self):
        r"""clone(CaListOf self) -> CaListOf"""
        return _libcombine.CaListOf_clone(self)

    def append(self, item):
        r"""append(CaListOf self, CaBase item) -> int"""
        return _libcombine.CaListOf_append(self, item)

    def appendAndOwn(self, disownedItem):
        r"""appendAndOwn(CaListOf self, CaBase disownedItem) -> int"""
        return _libcombine.CaListOf_appendAndOwn(self, disownedItem)

    def appendFrom(self, list):
        r"""appendFrom(CaListOf self, CaListOf list) -> int"""
        return _libcombine.CaListOf_appendFrom(self, list)

    def insert(self, location, item):
        r"""insert(CaListOf self, int location, CaBase item) -> int"""
        return _libcombine.CaListOf_insert(self, location, item)

    def insertAndOwn(self, location, disownedItem):
        r"""insertAndOwn(CaListOf self, int location, CaBase disownedItem) -> int"""
        return _libcombine.CaListOf_insertAndOwn(self, location, disownedItem)

    def get(self, *args):
        r"""
        get(CaListOf self, unsigned int n) -> CaBase
        get(CaListOf self, unsigned int n) -> CaBase
        """
        return _libcombine.CaListOf_get(self, *args)

    def getElementBySId(self, id):
        r"""getElementBySId(CaListOf self, string id) -> CaBase"""
        return _libcombine.CaListOf_getElementBySId(self, id)

    def getElementByMetaId(self, metaid):
        r"""getElementByMetaId(CaListOf self, string metaid) -> CaBase"""
        return _libcombine.CaListOf_getElementByMetaId(self, metaid)

    def clear(self, doDelete=True):
        r"""clear(CaListOf self, bool doDelete=True)"""
        return _libcombine.CaListOf_clear(self, doDelete)

    def removeFromParentAndDelete(self):
        r"""removeFromParentAndDelete(CaListOf self) -> int"""
        return _libcombine.CaListOf_removeFromParentAndDelete(self)

    def remove(self, n):
        r"""remove(CaListOf self, unsigned int n) -> CaBase"""
        return _libcombine.CaListOf_remove(self, n)

    def size(self):
        r"""size(CaListOf self) -> unsigned int"""
        return _libcombine.CaListOf_size(self)

    def connectToChild(self):
        r"""connectToChild(CaListOf self)"""
        return _libcombine.CaListOf_connectToChild(self)

    def getTypeCode(self):
        r"""getTypeCode(CaListOf self) -> int"""
        return _libcombine.CaListOf_getTypeCode(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(CaListOf self) -> int"""
        return _libcombine.CaListOf_getItemTypeCode(self)

    def getElementName(self):
        r"""getElementName(CaListOf self) -> string"""
        return _libcombine.CaListOf_getElementName(self)

    def __len__(self):
        r"""__len__(CaListOf self) -> int"""
        return _libcombine.CaListOf___len__(self)

    def __getitem__(self, key):

      try:
         keyIsSlice = isinstance(key, slice)
      except:
         keyIsSlice = 0

      if keyIsSlice:
        start = key.start
        if start is None:
          start = 0
        stop = key.stop
        if stop is None:
          stop = self.size()
        return [self[i] for i in range(
          self._fixNegativeIndex(start), self._fixNegativeIndex(stop)
        )]

      key = self._fixNegativeIndex(key)
      if key < 0 or key >= self.size():
        raise IndexError(key)
      return self.get(key)


    def _fixNegativeIndex(self, index):
      if index < 0:
        return index + self.size()
      else:
        return index


    def __iter__(self):
      for i in range(self.size()):
        yield self[i]


    def __repr__(self):
      return "[" + ", ".join([repr(self[i]) for i in range(len(self))]) + "]"


    def __str__(self):
      return repr(self)


# Register CaListOf in _libcombine:
_libcombine.CaListOf_swigregister(CaListOf)

class CaOmexManifest(CaBase):
    r"""Proxy of C++ CaOmexManifest class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(CaOmexManifest self) -> CaOmexManifest
        __init__(CaOmexManifest self, CaNamespaces omexns) -> CaOmexManifest
        __init__(CaOmexManifest self, CaOmexManifest orig) -> CaOmexManifest
        """
        _libcombine.CaOmexManifest_swiginit(self, _libcombine.new_CaOmexManifest(*args))

    def clone(self):
        r"""clone(CaOmexManifest self) -> CaOmexManifest"""
        return _libcombine.CaOmexManifest_clone(self)
    __swig_destroy__ = _libcombine.delete_CaOmexManifest

    def getListOfContents(self, *args):
        r"""
        getListOfContents(CaOmexManifest self) -> CaListOfContents
        getListOfContents(CaOmexManifest self) -> CaListOfContents
        """
        return _libcombine.CaOmexManifest_getListOfContents(self, *args)

    def getContent(self, *args):
        r"""
        getContent(CaOmexManifest self, unsigned int n) -> CaContent
        getContent(CaOmexManifest self, unsigned int n) -> CaContent
        """
        return _libcombine.CaOmexManifest_getContent(self, *args)

    def addContent(self, cc):
        r"""addContent(CaOmexManifest self, CaContent cc) -> int"""
        return _libcombine.CaOmexManifest_addContent(self, cc)

    def getNumContents(self):
        r"""getNumContents(CaOmexManifest self) -> unsigned int"""
        return _libcombine.CaOmexManifest_getNumContents(self)

    def createContent(self):
        r"""createContent(CaOmexManifest self) -> CaContent"""
        return _libcombine.CaOmexManifest_createContent(self)

    def removeContent(self, n):
        r"""removeContent(CaOmexManifest self, unsigned int n) -> CaContent"""
        return _libcombine.CaOmexManifest_removeContent(self, n)

    def getElementName(self):
        r"""getElementName(CaOmexManifest self) -> string"""
        return _libcombine.CaOmexManifest_getElementName(self)

    def getTypeCode(self):
        r"""getTypeCode(CaOmexManifest self) -> int"""
        return _libcombine.CaOmexManifest_getTypeCode(self)

    def hasRequiredElements(self):
        r"""hasRequiredElements(CaOmexManifest self) -> bool"""
        return _libcombine.CaOmexManifest_hasRequiredElements(self)

    def connectToChild(self):
        r"""connectToChild(CaOmexManifest self)"""
        return _libcombine.CaOmexManifest_connectToChild(self)

    def getElementBySId(self, id):
        r"""getElementBySId(CaOmexManifest self, string id) -> CaBase"""
        return _libcombine.CaOmexManifest_getElementBySId(self, id)

    def getNamespaces(self, *args):
        r"""
        getNamespaces(CaOmexManifest self) -> XMLNamespaces
        getNamespaces(CaOmexManifest self) -> XMLNamespaces
        """
        return _libcombine.CaOmexManifest_getNamespaces(self, *args)

    def getErrorLog(self, *args):
        r"""
        getErrorLog(CaOmexManifest self) -> CaErrorLog
        getErrorLog(CaOmexManifest self) -> CaErrorLog
        """
        return _libcombine.CaOmexManifest_getErrorLog(self, *args)

    def getError(self, *args):
        r"""
        getError(CaOmexManifest self, unsigned int n) -> CaError
        getError(CaOmexManifest self, unsigned int n) -> CaError
        """
        return _libcombine.CaOmexManifest_getError(self, *args)

    def getNumErrors(self, *args):
        r"""
        getNumErrors(CaOmexManifest self) -> unsigned int
        getNumErrors(CaOmexManifest self, unsigned int severity) -> unsigned int
        """
        return _libcombine.CaOmexManifest_getNumErrors(self, *args)

    def getLevel(self):
        r"""getLevel(CaOmexManifest self) -> unsigned int"""
        return _libcombine.CaOmexManifest_getLevel(self)

    def getVersion(self):
        r"""getVersion(CaOmexManifest self) -> unsigned int"""
        return _libcombine.CaOmexManifest_getVersion(self)

# Register CaOmexManifest in _libcombine:
_libcombine.CaOmexManifest_swigregister(CaOmexManifest)

class CaErrorLog(XMLErrorLog):
    r"""Proxy of C++ CaErrorLog class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getError(self, n):
        r"""getError(CaErrorLog self, unsigned int n) -> CaError"""
        return _libcombine.CaErrorLog_getError(self, n)

    def getErrorWithSeverity(self, n, severity):
        r"""getErrorWithSeverity(CaErrorLog self, unsigned int n, unsigned int severity) -> CaError"""
        return _libcombine.CaErrorLog_getErrorWithSeverity(self, n, severity)

    def getNumFailsWithSeverity(self, *args):
        r"""
        getNumFailsWithSeverity(CaErrorLog self, unsigned int severity) -> unsigned int
        getNumFailsWithSeverity(CaErrorLog self, unsigned int severity) -> unsigned int
        """
        return _libcombine.CaErrorLog_getNumFailsWithSeverity(self, *args)

    def __init__(self, *args):
        r"""
        __init__(CaErrorLog self) -> CaErrorLog
        __init__(CaErrorLog self, CaErrorLog other) -> CaErrorLog
        """
        _libcombine.CaErrorLog_swiginit(self, _libcombine.new_CaErrorLog(*args))
    __swig_destroy__ = _libcombine.delete_CaErrorLog

    def logError(self, *args):
        r"""logError(CaErrorLog self, unsigned int const errorId=0, unsigned int const level=OMEX_DEFAULT_LEVEL, unsigned int const version=OMEX_DEFAULT_VERSION, string details="", unsigned int const line=0, unsigned int const column=0, unsigned int const severity=LIBCOMBINE_SEV_ERROR, unsigned int const category=LIBCOMBINE_CAT_OMEX)"""
        return _libcombine.CaErrorLog_logError(self, *args)

    def add(self, error):
        r"""add(CaErrorLog self, CaError error)"""
        return _libcombine.CaErrorLog_add(self, error)

    def remove(self, errorId):
        r"""remove(CaErrorLog self, unsigned int const errorId)"""
        return _libcombine.CaErrorLog_remove(self, errorId)

    def removeAll(self, errorId):
        r"""removeAll(CaErrorLog self, unsigned int const errorId)"""
        return _libcombine.CaErrorLog_removeAll(self, errorId)

    def contains(self, errorId):
        r"""contains(CaErrorLog self, unsigned int const errorId) -> bool"""
        return _libcombine.CaErrorLog_contains(self, errorId)

# Register CaErrorLog in _libcombine:
_libcombine.CaErrorLog_swigregister(CaErrorLog)

CaUnknown = _libcombine.CaUnknown

CaNotUTF8 = _libcombine.CaNotUTF8

CaUnrecognizedElement = _libcombine.CaUnrecognizedElement

CaNotSchemaConformant = _libcombine.CaNotSchemaConformant

CaInvalidMathElement = _libcombine.CaInvalidMathElement

CaMissingAnnotationNamespace = _libcombine.CaMissingAnnotationNamespace

CaDuplicateAnnotationNamespaces = _libcombine.CaDuplicateAnnotationNamespaces

CaNamespaceInAnnotation = _libcombine.CaNamespaceInAnnotation

CaMultipleAnnotations = _libcombine.CaMultipleAnnotations

CaAnnotationNotElement = _libcombine.CaAnnotationNotElement

CaNotesNotInXHTMLNamespace = _libcombine.CaNotesNotInXHTMLNamespace

CaNotesContainsXMLDecl = _libcombine.CaNotesContainsXMLDecl

CaNotesContainsDOCTYPE = _libcombine.CaNotesContainsDOCTYPE

CaInvalidNotesContent = _libcombine.CaInvalidNotesContent

CaOnlyOneNotesElementAllowed = _libcombine.CaOnlyOneNotesElementAllowed

CombineNSUndeclared = _libcombine.CombineNSUndeclared

CombineElementNotInNs = _libcombine.CombineElementNotInNs

CombineDuplicateComponentId = _libcombine.CombineDuplicateComponentId

CombineIdSyntaxRule = _libcombine.CombineIdSyntaxRule

CaInvalidMetaidSyntax = _libcombine.CaInvalidMetaidSyntax

InvalidNamespaceOnCa = _libcombine.InvalidNamespaceOnCa

AllowedAttributes = _libcombine.AllowedAttributes

CaEmptyListElement = _libcombine.CaEmptyListElement

CombineContentAllowedCoreAttributes = _libcombine.CombineContentAllowedCoreAttributes

CombineContentAllowedCoreElements = _libcombine.CombineContentAllowedCoreElements

CombineContentAllowedAttributes = _libcombine.CombineContentAllowedAttributes

CombineContentAllowedElements = _libcombine.CombineContentAllowedElements

CombineContentLocationMustBeString = _libcombine.CombineContentLocationMustBeString

CombineContentFormatMustBeString = _libcombine.CombineContentFormatMustBeString

CombineContentMasterMustBeBoolean = _libcombine.CombineContentMasterMustBeBoolean

CombineOmexManifestAllowedCoreAttributes = _libcombine.CombineOmexManifestAllowedCoreAttributes

CombineOmexManifestAllowedCoreElements = _libcombine.CombineOmexManifestAllowedCoreElements

CombineOmexManifestAllowedElements = _libcombine.CombineOmexManifestAllowedElements

CombineCrossRefAllowedCoreAttributes = _libcombine.CombineCrossRefAllowedCoreAttributes

CombineCrossRefAllowedCoreElements = _libcombine.CombineCrossRefAllowedCoreElements

CombineCrossRefAllowedAttributes = _libcombine.CombineCrossRefAllowedAttributes

CombineCrossRefLocationMustBeString = _libcombine.CombineCrossRefLocationMustBeString

CaUnknownCoreAttribute = _libcombine.CaUnknownCoreAttribute

CaCodesUpperBound = _libcombine.CaCodesUpperBound

LIBCOMBINE_CAT_INTERNAL = _libcombine.LIBCOMBINE_CAT_INTERNAL

LIBCOMBINE_CAT_SYSTEM = _libcombine.LIBCOMBINE_CAT_SYSTEM

LIBCOMBINE_CAT_XML = _libcombine.LIBCOMBINE_CAT_XML

LIBCOMBINE_CAT_OMEX = _libcombine.LIBCOMBINE_CAT_OMEX

LIBCOMBINE_CAT_GENERAL_CONSISTENCY = _libcombine.LIBCOMBINE_CAT_GENERAL_CONSISTENCY

LIBCOMBINE_CAT_IDENTIFIER_CONSISTENCY = _libcombine.LIBCOMBINE_CAT_IDENTIFIER_CONSISTENCY

LIBCOMBINE_CAT_MATHML_CONSISTENCY = _libcombine.LIBCOMBINE_CAT_MATHML_CONSISTENCY

LIBCOMBINE_CAT_INTERNAL_CONSISTENCY = _libcombine.LIBCOMBINE_CAT_INTERNAL_CONSISTENCY

LIBCOMBINE_SEV_WARNING = _libcombine.LIBCOMBINE_SEV_WARNING

LIBCOMBINE_SEV_ERROR = _libcombine.LIBCOMBINE_SEV_ERROR

LIBCOMBINE_SEV_FATAL = _libcombine.LIBCOMBINE_SEV_FATAL

LIBCOMBINE_SEV_SCHEMA_ERROR = _libcombine.LIBCOMBINE_SEV_SCHEMA_ERROR

LIBCOMBINE_SEV_GENERAL_WARNING = _libcombine.LIBCOMBINE_SEV_GENERAL_WARNING

LIBCOMBINE_SEV_NOT_APPLICABLE = _libcombine.LIBCOMBINE_SEV_NOT_APPLICABLE

class CaError(XMLError):
    r"""Proxy of C++ CaError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(CaError self, unsigned int const errorId=0, unsigned int const level=OMEX_DEFAULT_LEVEL, unsigned int const version=OMEX_DEFAULT_VERSION, string details="", unsigned int const line=0, unsigned int const column=0, unsigned int const severity=LIBCOMBINE_SEV_ERROR, unsigned int const category=LIBCOMBINE_CAT_OMEX) -> CaError
        __init__(CaError self, CaError orig) -> CaError
        """
        _libcombine.CaError_swiginit(self, _libcombine.new_CaError(*args))
    __swig_destroy__ = _libcombine.delete_CaError

# Register CaError in _libcombine:
_libcombine.CaError_swigregister(CaError)

class CaNamespaces(object):
    r"""Proxy of C++ CaNamespaces class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcombine.delete_CaNamespaces

    def __init__(self, *args):
        r"""
        __init__(CaNamespaces self, unsigned int level=OMEX_DEFAULT_LEVEL, unsigned int version=OMEX_DEFAULT_VERSION) -> CaNamespaces
        __init__(CaNamespaces self, CaNamespaces orig) -> CaNamespaces
        """
        _libcombine.CaNamespaces_swiginit(self, _libcombine.new_CaNamespaces(*args))

    def clone(self):
        r"""clone(CaNamespaces self) -> CaNamespaces"""
        return _libcombine.CaNamespaces_clone(self)

    @staticmethod
    def getCaNamespaceURI(level, version):
        r"""getCaNamespaceURI(unsigned int level, unsigned int version) -> string"""
        return _libcombine.CaNamespaces_getCaNamespaceURI(level, version)

    @staticmethod
    def getSupportedNamespaces():
        r"""getSupportedNamespaces() -> List const *"""
        return _libcombine.CaNamespaces_getSupportedNamespaces()

    @staticmethod
    def freeCaNamespaces(supportedNS):
        r"""freeCaNamespaces(List * supportedNS)"""
        return _libcombine.CaNamespaces_freeCaNamespaces(supportedNS)

    def getURI(self):
        r"""getURI(CaNamespaces self) -> string"""
        return _libcombine.CaNamespaces_getURI(self)

    def getLevel(self, *args):
        r"""
        getLevel(CaNamespaces self) -> unsigned int
        getLevel(CaNamespaces self) -> unsigned int
        """
        return _libcombine.CaNamespaces_getLevel(self, *args)

    def getVersion(self, *args):
        r"""
        getVersion(CaNamespaces self) -> unsigned int
        getVersion(CaNamespaces self) -> unsigned int
        """
        return _libcombine.CaNamespaces_getVersion(self, *args)

    def getNamespaces(self, *args):
        r"""
        getNamespaces(CaNamespaces self) -> XMLNamespaces
        getNamespaces(CaNamespaces self) -> XMLNamespaces
        """
        return _libcombine.CaNamespaces_getNamespaces(self, *args)

    def addNamespaces(self, xmlns):
        r"""addNamespaces(CaNamespaces self, XMLNamespaces xmlns) -> int"""
        return _libcombine.CaNamespaces_addNamespaces(self, xmlns)

    def addNamespace(self, uri, prefix):
        r"""addNamespace(CaNamespaces self, string uri, string prefix) -> int"""
        return _libcombine.CaNamespaces_addNamespace(self, uri, prefix)

    def removeNamespace(self, uri):
        r"""removeNamespace(CaNamespaces self, string uri) -> int"""
        return _libcombine.CaNamespaces_removeNamespace(self, uri)

    @staticmethod
    def isCaNamespace(uri):
        r"""isCaNamespace(string uri) -> bool"""
        return _libcombine.CaNamespaces_isCaNamespace(uri)

    def isValidCombination(self):
        r"""isValidCombination(CaNamespaces self) -> bool"""
        return _libcombine.CaNamespaces_isValidCombination(self)

    def setLevel(self, level):
        r"""setLevel(CaNamespaces self, unsigned int level)"""
        return _libcombine.CaNamespaces_setLevel(self, level)

    def setVersion(self, version):
        r"""setVersion(CaNamespaces self, unsigned int version)"""
        return _libcombine.CaNamespaces_setVersion(self, version)

    def setNamespaces(self, xmlns):
        r"""setNamespaces(CaNamespaces self, XMLNamespaces xmlns)"""
        return _libcombine.CaNamespaces_setNamespaces(self, xmlns)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register CaNamespaces in _libcombine:
_libcombine.CaNamespaces_swigregister(CaNamespaces)

def CaNamespaces_getCaNamespaceURI(level, version):
    r"""CaNamespaces_getCaNamespaceURI(unsigned int level, unsigned int version) -> string"""
    return _libcombine.CaNamespaces_getCaNamespaceURI(level, version)

def CaNamespaces_getSupportedNamespaces():
    r"""CaNamespaces_getSupportedNamespaces() -> List const *"""
    return _libcombine.CaNamespaces_getSupportedNamespaces()

def CaNamespaces_freeCaNamespaces(supportedNS):
    r"""CaNamespaces_freeCaNamespaces(List * supportedNS)"""
    return _libcombine.CaNamespaces_freeCaNamespaces(supportedNS)

def CaNamespaces_isCaNamespace(uri):
    r"""CaNamespaces_isCaNamespace(string uri) -> bool"""
    return _libcombine.CaNamespaces_isCaNamespace(uri)

class CaContent(CaBase):
    r"""Proxy of C++ CaContent class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(CaContent self) -> CaContent
        __init__(CaContent self, CaNamespaces omexns) -> CaContent
        __init__(CaContent self, CaContent orig) -> CaContent
        """
        _libcombine.CaContent_swiginit(self, _libcombine.new_CaContent(*args))

    def clone(self):
        r"""clone(CaContent self) -> CaContent"""
        return _libcombine.CaContent_clone(self)
    __swig_destroy__ = _libcombine.delete_CaContent

    def getLocation(self):
        r"""getLocation(CaContent self) -> string"""
        return _libcombine.CaContent_getLocation(self)

    def getFormat(self):
        r"""getFormat(CaContent self) -> string"""
        return _libcombine.CaContent_getFormat(self)

    def isFormat(self, formatKey):
        r"""isFormat(CaContent self, string formatKey) -> bool"""
        return _libcombine.CaContent_isFormat(self, formatKey)

    def getMaster(self):
        r"""getMaster(CaContent self) -> bool"""
        return _libcombine.CaContent_getMaster(self)

    def isSetLocation(self):
        r"""isSetLocation(CaContent self) -> bool"""
        return _libcombine.CaContent_isSetLocation(self)

    def isSetFormat(self):
        r"""isSetFormat(CaContent self) -> bool"""
        return _libcombine.CaContent_isSetFormat(self)

    def isSetMaster(self):
        r"""isSetMaster(CaContent self) -> bool"""
        return _libcombine.CaContent_isSetMaster(self)

    def setLocation(self, location):
        r"""setLocation(CaContent self, string location) -> int"""
        return _libcombine.CaContent_setLocation(self, location)

    def setFormat(self, format):
        r"""setFormat(CaContent self, string format) -> int"""
        return _libcombine.CaContent_setFormat(self, format)

    def setMaster(self, master):
        r"""setMaster(CaContent self, bool master) -> int"""
        return _libcombine.CaContent_setMaster(self, master)

    def unsetLocation(self):
        r"""unsetLocation(CaContent self) -> int"""
        return _libcombine.CaContent_unsetLocation(self)

    def unsetFormat(self):
        r"""unsetFormat(CaContent self) -> int"""
        return _libcombine.CaContent_unsetFormat(self)

    def unsetMaster(self):
        r"""unsetMaster(CaContent self) -> int"""
        return _libcombine.CaContent_unsetMaster(self)

    def getListOfCrossRefs(self, *args):
        r"""
        getListOfCrossRefs(CaContent self) -> CaListOfCrossRefs
        getListOfCrossRefs(CaContent self) -> CaListOfCrossRefs
        """
        return _libcombine.CaContent_getListOfCrossRefs(self, *args)

    def getCrossRef(self, *args):
        r"""
        getCrossRef(CaContent self, unsigned int n) -> CaCrossRef
        getCrossRef(CaContent self, unsigned int n) -> CaCrossRef
        """
        return _libcombine.CaContent_getCrossRef(self, *args)

    def addCrossRef(self, ccr):
        r"""addCrossRef(CaContent self, CaCrossRef ccr) -> int"""
        return _libcombine.CaContent_addCrossRef(self, ccr)

    def getNumCrossRefs(self):
        r"""getNumCrossRefs(CaContent self) -> unsigned int"""
        return _libcombine.CaContent_getNumCrossRefs(self)

    def createCrossRef(self):
        r"""createCrossRef(CaContent self) -> CaCrossRef"""
        return _libcombine.CaContent_createCrossRef(self)

    def removeCrossRef(self, n):
        r"""removeCrossRef(CaContent self, unsigned int n) -> CaCrossRef"""
        return _libcombine.CaContent_removeCrossRef(self, n)

    def getElementName(self):
        r"""getElementName(CaContent self) -> string"""
        return _libcombine.CaContent_getElementName(self)

    def getTypeCode(self):
        r"""getTypeCode(CaContent self) -> int"""
        return _libcombine.CaContent_getTypeCode(self)

    def hasRequiredAttributes(self):
        r"""hasRequiredAttributes(CaContent self) -> bool"""
        return _libcombine.CaContent_hasRequiredAttributes(self)

    def connectToChild(self):
        r"""connectToChild(CaContent self)"""
        return _libcombine.CaContent_connectToChild(self)

    def getElementBySId(self, id):
        r"""getElementBySId(CaContent self, string id) -> CaBase"""
        return _libcombine.CaContent_getElementBySId(self, id)

# Register CaContent in _libcombine:
_libcombine.CaContent_swigregister(CaContent)

class CaCrossRef(CaBase):
    r"""Proxy of C++ CaCrossRef class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(CaCrossRef self) -> CaCrossRef
        __init__(CaCrossRef self, CaNamespaces omexns) -> CaCrossRef
        __init__(CaCrossRef self, CaCrossRef orig) -> CaCrossRef
        """
        _libcombine.CaCrossRef_swiginit(self, _libcombine.new_CaCrossRef(*args))

    def clone(self):
        r"""clone(CaCrossRef self) -> CaCrossRef"""
        return _libcombine.CaCrossRef_clone(self)
    __swig_destroy__ = _libcombine.delete_CaCrossRef

    def getLocation(self):
        r"""getLocation(CaCrossRef self) -> string"""
        return _libcombine.CaCrossRef_getLocation(self)

    def isSetLocation(self):
        r"""isSetLocation(CaCrossRef self) -> bool"""
        return _libcombine.CaCrossRef_isSetLocation(self)

    def setLocation(self, location):
        r"""setLocation(CaCrossRef self, string location) -> int"""
        return _libcombine.CaCrossRef_setLocation(self, location)

    def unsetLocation(self):
        r"""unsetLocation(CaCrossRef self) -> int"""
        return _libcombine.CaCrossRef_unsetLocation(self)

    def getElementName(self):
        r"""getElementName(CaCrossRef self) -> string"""
        return _libcombine.CaCrossRef_getElementName(self)

    def getTypeCode(self):
        r"""getTypeCode(CaCrossRef self) -> int"""
        return _libcombine.CaCrossRef_getTypeCode(self)

    def hasRequiredAttributes(self):
        r"""hasRequiredAttributes(CaCrossRef self) -> bool"""
        return _libcombine.CaCrossRef_hasRequiredAttributes(self)

# Register CaCrossRef in _libcombine:
_libcombine.CaCrossRef_swigregister(CaCrossRef)

class CaListOfContents(CaListOf):
    r"""Proxy of C++ CaListOfContents class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(CaListOfContents self) -> CaListOfContents
        __init__(CaListOfContents self, CaNamespaces omexns) -> CaListOfContents
        __init__(CaListOfContents self, CaListOfContents orig) -> CaListOfContents
        """
        _libcombine.CaListOfContents_swiginit(self, _libcombine.new_CaListOfContents(*args))

    def clone(self):
        r"""clone(CaListOfContents self) -> CaListOfContents"""
        return _libcombine.CaListOfContents_clone(self)
    __swig_destroy__ = _libcombine.delete_CaListOfContents

    def get(self, *args):
        r"""
        get(CaListOfContents self, unsigned int n) -> CaContent
        get(CaListOfContents self, unsigned int n) -> CaContent
        get(CaListOfContents self, string sid) -> CaContent
        get(CaListOfContents self, string sid) -> CaContent
        """
        return _libcombine.CaListOfContents_get(self, *args)

    def remove(self, *args):
        r"""
        remove(CaListOfContents self, unsigned int n) -> CaContent
        remove(CaListOfContents self, string sid) -> CaContent
        """
        return _libcombine.CaListOfContents_remove(self, *args)

    def addContent(self, cc):
        r"""addContent(CaListOfContents self, CaContent cc) -> int"""
        return _libcombine.CaListOfContents_addContent(self, cc)

    def getNumContents(self):
        r"""getNumContents(CaListOfContents self) -> unsigned int"""
        return _libcombine.CaListOfContents_getNumContents(self)

    def createContent(self):
        r"""createContent(CaListOfContents self) -> CaContent"""
        return _libcombine.CaListOfContents_createContent(self)

    def getElementName(self):
        r"""getElementName(CaListOfContents self) -> string"""
        return _libcombine.CaListOfContents_getElementName(self)

    def getTypeCode(self):
        r"""getTypeCode(CaListOfContents self) -> int"""
        return _libcombine.CaListOfContents_getTypeCode(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(CaListOfContents self) -> int"""
        return _libcombine.CaListOfContents_getItemTypeCode(self)

# Register CaListOfContents in _libcombine:
_libcombine.CaListOfContents_swigregister(CaListOfContents)

class CaListOfCrossRefs(CaListOf):
    r"""Proxy of C++ CaListOfCrossRefs class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(CaListOfCrossRefs self) -> CaListOfCrossRefs
        __init__(CaListOfCrossRefs self, CaNamespaces omexns) -> CaListOfCrossRefs
        __init__(CaListOfCrossRefs self, CaListOfCrossRefs orig) -> CaListOfCrossRefs
        """
        _libcombine.CaListOfCrossRefs_swiginit(self, _libcombine.new_CaListOfCrossRefs(*args))

    def clone(self):
        r"""clone(CaListOfCrossRefs self) -> CaListOfCrossRefs"""
        return _libcombine.CaListOfCrossRefs_clone(self)
    __swig_destroy__ = _libcombine.delete_CaListOfCrossRefs

    def get(self, *args):
        r"""
        get(CaListOfCrossRefs self, unsigned int n) -> CaCrossRef
        get(CaListOfCrossRefs self, unsigned int n) -> CaCrossRef
        get(CaListOfCrossRefs self, string sid) -> CaCrossRef
        get(CaListOfCrossRefs self, string sid) -> CaCrossRef
        """
        return _libcombine.CaListOfCrossRefs_get(self, *args)

    def remove(self, *args):
        r"""
        remove(CaListOfCrossRefs self, unsigned int n) -> CaCrossRef
        remove(CaListOfCrossRefs self, string sid) -> CaCrossRef
        """
        return _libcombine.CaListOfCrossRefs_remove(self, *args)

    def addCrossRef(self, ccr):
        r"""addCrossRef(CaListOfCrossRefs self, CaCrossRef ccr) -> int"""
        return _libcombine.CaListOfCrossRefs_addCrossRef(self, ccr)

    def getNumCrossRefs(self):
        r"""getNumCrossRefs(CaListOfCrossRefs self) -> unsigned int"""
        return _libcombine.CaListOfCrossRefs_getNumCrossRefs(self)

    def createCrossRef(self):
        r"""createCrossRef(CaListOfCrossRefs self) -> CaCrossRef"""
        return _libcombine.CaListOfCrossRefs_createCrossRef(self)

    def getElementName(self):
        r"""getElementName(CaListOfCrossRefs self) -> string"""
        return _libcombine.CaListOfCrossRefs_getElementName(self)

    def getTypeCode(self):
        r"""getTypeCode(CaListOfCrossRefs self) -> int"""
        return _libcombine.CaListOfCrossRefs_getTypeCode(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(CaListOfCrossRefs self) -> int"""
        return _libcombine.CaListOfCrossRefs_getItemTypeCode(self)

# Register CaListOfCrossRefs in _libcombine:
_libcombine.CaListOfCrossRefs_swigregister(CaListOfCrossRefs)

class CombineArchive(object):
    r"""Proxy of C++ CombineArchive class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(CombineArchive self) -> CombineArchive"""
        _libcombine.CombineArchive_swiginit(self, _libcombine.new_CombineArchive())
    __swig_destroy__ = _libcombine.delete_CombineArchive

    def addFile(self, *args):
        r"""
        addFile(CombineArchive self, string fileName, string targetName, string format, bool isMaster=False) -> bool
        addFile(CombineArchive self, std::istream & stream, string targetName, string format, bool isMaster=False) -> bool
        """
        return _libcombine.CombineArchive_addFile(self, *args)

    def addFileFromString(self, content, targetName, format, isMaster=False):
        r"""addFileFromString(CombineArchive self, string content, string targetName, string format, bool isMaster=False) -> bool"""
        return _libcombine.CombineArchive_addFileFromString(self, content, targetName, format, isMaster)

    def addMetadata(self, targetName, description):
        r"""addMetadata(CombineArchive self, string targetName, OmexDescription description) -> int"""
        return _libcombine.CombineArchive_addMetadata(self, targetName, description)

    def extractEntry(self, *args):
        r"""extractEntry(CombineArchive self, string name, string destination=std::string()) -> bool"""
        return _libcombine.CombineArchive_extractEntry(self, *args)

    def extractEntryToStream(self, name, stream):
        r"""extractEntryToStream(CombineArchive self, string name, ostream stream) -> bool"""
        return _libcombine.CombineArchive_extractEntryToStream(self, name, stream)

    def extractEntryToString(self, name):
        r"""extractEntryToString(CombineArchive self, string name) -> string"""
        return _libcombine.CombineArchive_extractEntryToString(self, name)

    def extractTo(self, directory):
        r"""extractTo(CombineArchive self, string directory) -> bool"""
        return _libcombine.CombineArchive_extractTo(self, directory)

    def initializeFromDirectory(self, directory):
        r"""initializeFromDirectory(CombineArchive self, string directory) -> bool"""
        return _libcombine.CombineArchive_initializeFromDirectory(self, directory)

    def initializeFromArchive(self, archiveFile, skipOmex=False):
        r"""initializeFromArchive(CombineArchive self, string archiveFile, bool skipOmex=False) -> bool"""
        return _libcombine.CombineArchive_initializeFromArchive(self, archiveFile, skipOmex)

    def getManifest(self, *args):
        r"""
        getManifest(CombineArchive self) -> CaOmexManifest
        getManifest(CombineArchive self) -> CaOmexManifest
        """
        return _libcombine.CombineArchive_getManifest(self, *args)

    def getMasterFile(self, *args):
        r"""
        getMasterFile(CombineArchive self) -> CaContent
        getMasterFile(CombineArchive self, string formatKey) -> CaContent
        """
        return _libcombine.CombineArchive_getMasterFile(self, *args)

    def getEntryByFormat(self, formatKey):
        r"""getEntryByFormat(CombineArchive self, string formatKey) -> CaContent"""
        return _libcombine.CombineArchive_getEntryByFormat(self, formatKey)

    def getEntryByLocation(self, location):
        r"""getEntryByLocation(CombineArchive self, string location) -> CaContent"""
        return _libcombine.CombineArchive_getEntryByLocation(self, location)

    def getAllLocations(self):
        r"""getAllLocations(CombineArchive self) -> StringVector"""
        return _libcombine.CombineArchive_getAllLocations(self)

    def getNumEntries(self):
        r"""getNumEntries(CombineArchive self) -> int"""
        return _libcombine.CombineArchive_getNumEntries(self)

    def getEntry(self, index):
        r"""getEntry(CombineArchive self, int index) -> CaContent"""
        return _libcombine.CombineArchive_getEntry(self, index)

    def getMetadataForLocation(self, location):
        r"""getMetadataForLocation(CombineArchive self, string location) -> OmexDescription"""
        return _libcombine.CombineArchive_getMetadataForLocation(self, location)

    def hasMetadataForLocation(self, location):
        r"""hasMetadataForLocation(CombineArchive self, string location) -> bool"""
        return _libcombine.CombineArchive_hasMetadataForLocation(self, location)

    def setManifest(self, value):
        r"""setManifest(CombineArchive self, CaOmexManifest value)"""
        return _libcombine.CombineArchive_setManifest(self, value)

    def cleanUp(self):
        r"""cleanUp(CombineArchive self) -> bool"""
        return _libcombine.CombineArchive_cleanUp(self)

    def writeToFile(self, fileName):
        r"""writeToFile(CombineArchive self, string fileName) -> bool"""
        return _libcombine.CombineArchive_writeToFile(self, fileName)

    def getStream(self, name, stream):
        r"""getStream(CombineArchive self, string name, std::ifstream & stream) -> bool"""
        return _libcombine.CombineArchive_getStream(self, name, stream)

# Register CombineArchive in _libcombine:
_libcombine.CombineArchive_swigregister(CombineArchive)

class KnownFormats(object):
    r"""Proxy of C++ KnownFormats class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def isFormat(formatKey, format):
        r"""isFormat(string formatKey, string format) -> bool"""
        return _libcombine.KnownFormats_isFormat(formatKey, format)

    @staticmethod
    def lookupFormat(formatKey):
        r"""lookupFormat(string formatKey) -> string"""
        return _libcombine.KnownFormats_lookupFormat(formatKey)

    @staticmethod
    def guessFormat(fileName):
        r"""guessFormat(string fileName) -> string"""
        return _libcombine.KnownFormats_guessFormat(fileName)

    @staticmethod
    def addKnownFormat(formatKey, format):
        r"""addKnownFormat(string formatKey, string format)"""
        return _libcombine.KnownFormats_addKnownFormat(formatKey, format)

    @staticmethod
    def getFormatKeys():
        r"""getFormatKeys() -> StringVector"""
        return _libcombine.KnownFormats_getFormatKeys()

    @staticmethod
    def getKnownFormats():
        r"""getKnownFormats() -> std::map< std::string,std::vector< std::string,std::allocator< std::string > > > &"""
        return _libcombine.KnownFormats_getKnownFormats()

    def __init__(self):
        r"""__init__(KnownFormats self) -> KnownFormats"""
        _libcombine.KnownFormats_swiginit(self, _libcombine.new_KnownFormats())
    __swig_destroy__ = _libcombine.delete_KnownFormats

# Register KnownFormats in _libcombine:
_libcombine.KnownFormats_swigregister(KnownFormats)

def KnownFormats_isFormat(formatKey, format):
    r"""KnownFormats_isFormat(string formatKey, string format) -> bool"""
    return _libcombine.KnownFormats_isFormat(formatKey, format)

def KnownFormats_lookupFormat(formatKey):
    r"""KnownFormats_lookupFormat(string formatKey) -> string"""
    return _libcombine.KnownFormats_lookupFormat(formatKey)

def KnownFormats_guessFormat(fileName):
    r"""KnownFormats_guessFormat(string fileName) -> string"""
    return _libcombine.KnownFormats_guessFormat(fileName)

def KnownFormats_addKnownFormat(formatKey, format):
    r"""KnownFormats_addKnownFormat(string formatKey, string format)"""
    return _libcombine.KnownFormats_addKnownFormat(formatKey, format)

def KnownFormats_getFormatKeys():
    r"""KnownFormats_getFormatKeys() -> StringVector"""
    return _libcombine.KnownFormats_getFormatKeys()

def KnownFormats_getKnownFormats():
    r"""KnownFormats_getKnownFormats() -> std::map< std::string,std::vector< std::string,std::allocator< std::string > > > &"""
    return _libcombine.KnownFormats_getKnownFormats()
KnownFormats.PURL_MEDIATYPES_URL = _libcombine.cvar.KnownFormats_PURL_MEDIATYPES_URL

class OmexDescription(object):
    r"""Proxy of C++ OmexDescription class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(OmexDescription self) -> OmexDescription
        __init__(OmexDescription self, XMLInputStream stream) -> OmexDescription
        """
        _libcombine.OmexDescription_swiginit(self, _libcombine.new_OmexDescription(*args))

    @staticmethod
    def getRdfNS():
        r"""getRdfNS() -> string"""
        return _libcombine.OmexDescription_getRdfNS()

    @staticmethod
    def getDcNS():
        r"""getDcNS() -> string"""
        return _libcombine.OmexDescription_getDcNS()

    @staticmethod
    def parseFile(fileName):
        r"""parseFile(string fileName) -> MetadataVector"""
        return _libcombine.OmexDescription_parseFile(fileName)

    @staticmethod
    def parseString(xml):
        r"""parseString(string xml) -> MetadataVector"""
        return _libcombine.OmexDescription_parseString(xml)

    @staticmethod
    def readFrom(stream):
        r"""readFrom(XMLInputStream stream) -> MetadataVector"""
        return _libcombine.OmexDescription_readFrom(stream)

    def isEmpty(self):
        r"""isEmpty(OmexDescription self) -> bool"""
        return _libcombine.OmexDescription_isEmpty(self)

    def getDescription(self):
        r"""getDescription(OmexDescription self) -> string"""
        return _libcombine.OmexDescription_getDescription(self)

    def setDescription(self, description):
        r"""setDescription(OmexDescription self, string description)"""
        return _libcombine.OmexDescription_setDescription(self, description)

    def getAbout(self):
        r"""getAbout(OmexDescription self) -> string"""
        return _libcombine.OmexDescription_getAbout(self)

    def setAbout(self, about):
        r"""setAbout(OmexDescription self, string about)"""
        return _libcombine.OmexDescription_setAbout(self, about)

    def getCreators(self, *args):
        r"""
        getCreators(OmexDescription self) -> VCardVector
        getCreators(OmexDescription self) -> VCardVector
        """
        return _libcombine.OmexDescription_getCreators(self, *args)

    def getNumCreators(self):
        r"""getNumCreators(OmexDescription self) -> size_t"""
        return _libcombine.OmexDescription_getNumCreators(self)

    def setCreators(self, creators):
        r"""setCreators(OmexDescription self, VCardVector creators)"""
        return _libcombine.OmexDescription_setCreators(self, creators)

    def addCreator(self, creator):
        r"""addCreator(OmexDescription self, VCard creator)"""
        return _libcombine.OmexDescription_addCreator(self, creator)

    def getCreated(self, *args):
        r"""
        getCreated(OmexDescription self) -> Date
        getCreated(OmexDescription self) -> Date
        """
        return _libcombine.OmexDescription_getCreated(self, *args)

    def getCreator(self, index):
        r"""getCreator(OmexDescription self, unsigned int index) -> VCard"""
        return _libcombine.OmexDescription_getCreator(self, index)

    def setCreated(self, created):
        r"""setCreated(OmexDescription self, Date created)"""
        return _libcombine.OmexDescription_setCreated(self, created)

    @staticmethod
    def getCurrentDateAndTime():
        r"""getCurrentDateAndTime() -> Date"""
        return _libcombine.OmexDescription_getCurrentDateAndTime()

    def getModified(self, *args):
        r"""
        getModified(OmexDescription self) -> DateVector
        getModified(OmexDescription self) -> DateVector
        getModified(OmexDescription self, int index) -> Date
        """
        return _libcombine.OmexDescription_getModified(self, *args)

    def getNumModified(self):
        r"""getNumModified(OmexDescription self) -> size_t"""
        return _libcombine.OmexDescription_getNumModified(self)

    def setModified(self, modified):
        r"""setModified(OmexDescription self, DateVector modified)"""
        return _libcombine.OmexDescription_setModified(self, modified)

    def addModification(self, date):
        r"""addModification(OmexDescription self, Date date)"""
        return _libcombine.OmexDescription_addModification(self, date)

    def writeToFile(self, fileName):
        r"""writeToFile(OmexDescription self, string fileName)"""
        return _libcombine.OmexDescription_writeToFile(self, fileName)

    def toXML(self, omitDeclaration=False):
        r"""toXML(OmexDescription self, bool omitDeclaration=False) -> string"""
        return _libcombine.OmexDescription_toXML(self, omitDeclaration)
    __swig_destroy__ = _libcombine.delete_OmexDescription

# Register OmexDescription in _libcombine:
_libcombine.OmexDescription_swigregister(OmexDescription)

def OmexDescription_getRdfNS():
    r"""OmexDescription_getRdfNS() -> string"""
    return _libcombine.OmexDescription_getRdfNS()

def OmexDescription_getDcNS():
    r"""OmexDescription_getDcNS() -> string"""
    return _libcombine.OmexDescription_getDcNS()

def OmexDescription_parseFile(fileName):
    r"""OmexDescription_parseFile(string fileName) -> MetadataVector"""
    return _libcombine.OmexDescription_parseFile(fileName)

def OmexDescription_parseString(xml):
    r"""OmexDescription_parseString(string xml) -> MetadataVector"""
    return _libcombine.OmexDescription_parseString(xml)

def OmexDescription_readFrom(stream):
    r"""OmexDescription_readFrom(XMLInputStream stream) -> MetadataVector"""
    return _libcombine.OmexDescription_readFrom(stream)

def OmexDescription_getCurrentDateAndTime():
    r"""OmexDescription_getCurrentDateAndTime() -> Date"""
    return _libcombine.OmexDescription_getCurrentDateAndTime()

class Util(object):
    r"""Proxy of C++ Util class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def getTempPath():
        r"""getTempPath() -> string"""
        return _libcombine.Util_getTempPath()

    @staticmethod
    def getTempFilename(*args):
        r"""getTempFilename(string prefix="temp", string ext=".tmp") -> string"""
        return _libcombine.Util_getTempFilename(*args)

    @staticmethod
    def getCurrentMilliseconds():
        r"""getCurrentMilliseconds() -> unsigned long"""
        return _libcombine.Util_getCurrentMilliseconds()

    @staticmethod
    def copyFile(source, destination):
        r"""copyFile(string source, string destination)"""
        return _libcombine.Util_copyFile(source, destination)

    @staticmethod
    def copyStream(_in, out):
        r"""copyStream(std::istream & _in, ostream out)"""
        return _libcombine.Util_copyStream(_in, out)

    @staticmethod
    def getExtension(fileName):
        r"""getExtension(string fileName) -> string"""
        return _libcombine.Util_getExtension(fileName)

    @staticmethod
    def removeFileOrFolder(path):
        r"""removeFileOrFolder(string path) -> bool"""
        return _libcombine.Util_removeFileOrFolder(path)

    def __init__(self):
        r"""__init__(Util self) -> Util"""
        _libcombine.Util_swiginit(self, _libcombine.new_Util())
    __swig_destroy__ = _libcombine.delete_Util

# Register Util in _libcombine:
_libcombine.Util_swigregister(Util)

def Util_getTempPath():
    r"""Util_getTempPath() -> string"""
    return _libcombine.Util_getTempPath()

def Util_getTempFilename(*args):
    r"""Util_getTempFilename(string prefix="temp", string ext=".tmp") -> string"""
    return _libcombine.Util_getTempFilename(*args)

def Util_getCurrentMilliseconds():
    r"""Util_getCurrentMilliseconds() -> unsigned long"""
    return _libcombine.Util_getCurrentMilliseconds()

def Util_copyFile(source, destination):
    r"""Util_copyFile(string source, string destination)"""
    return _libcombine.Util_copyFile(source, destination)

def Util_copyStream(_in, out):
    r"""Util_copyStream(std::istream & _in, ostream out)"""
    return _libcombine.Util_copyStream(_in, out)

def Util_getExtension(fileName):
    r"""Util_getExtension(string fileName) -> string"""
    return _libcombine.Util_getExtension(fileName)

def Util_removeFileOrFolder(path):
    r"""Util_removeFileOrFolder(string path) -> bool"""
    return _libcombine.Util_removeFileOrFolder(path)

class VCard(object):
    r"""Proxy of C++ VCard class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(VCard self) -> VCard
        __init__(VCard self, VCard other) -> VCard
        __init__(VCard self, XMLInputStream stream, XMLToken current) -> VCard
        """
        _libcombine.VCard_swiginit(self, _libcombine.new_VCard(*args))

    def isEmpty(self):
        r"""isEmpty(VCard self) -> bool"""
        return _libcombine.VCard_isEmpty(self)

    def toXML(self):
        r"""toXML(VCard self) -> string"""
        return _libcombine.VCard_toXML(self)

    def getFamilyName(self):
        r"""getFamilyName(VCard self) -> string"""
        return _libcombine.VCard_getFamilyName(self)

    def setFamilyName(self, familyName):
        r"""setFamilyName(VCard self, string familyName)"""
        return _libcombine.VCard_setFamilyName(self, familyName)

    def getGivenName(self):
        r"""getGivenName(VCard self) -> string"""
        return _libcombine.VCard_getGivenName(self)

    def setGivenName(self, givenName):
        r"""setGivenName(VCard self, string givenName)"""
        return _libcombine.VCard_setGivenName(self, givenName)

    def getEmail(self):
        r"""getEmail(VCard self) -> string"""
        return _libcombine.VCard_getEmail(self)

    def setEmail(self, email):
        r"""setEmail(VCard self, string email)"""
        return _libcombine.VCard_setEmail(self, email)

    def getOrganization(self):
        r"""getOrganization(VCard self) -> string"""
        return _libcombine.VCard_getOrganization(self)

    def setOrganization(self, organization):
        r"""setOrganization(VCard self, string organization)"""
        return _libcombine.VCard_setOrganization(self, organization)
    __swig_destroy__ = _libcombine.delete_VCard

# Register VCard in _libcombine:
_libcombine.VCard_swigregister(VCard)




global __version__
__version__ = '0.2.17'
