/**
* Begin svn Header
* $Rev: 27 $:	Revision of last commit
* $Author: josephodada@gmail.com $:	Author of last commit
* $Date: 2013-04-25 10:07:15 +0100 (Thu, 25 Apr 2013) $:	Date of last commit
* $HeadURL: https://numl.googlecode.com/svn/trunk/libnuml/src/common/libnuml-config.h $
* $Id: libnuml-config.h 27 2013-04-25 09:07:15Z josephodada@gmail.com $
* End svn Header
* ***************************************************************************
* This file is part of libNUML.  Please visit http://code.google.com/p/numl/for more
* information about NUML, and the latest version of libNUML.
* Copyright (c) 2013 The University of Manchester.
*
* This library is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as published
* by the Free Software Foundation.  A copy of the license agreement is
* provided in the file named "LICENSE.txt" included with this software
* distribution and also available online as http://www.gnu.org/licenses/lgpl.html
*
* The original code was initially developed by:
*
* 	SBML Team
* 	Control and Dynamical Systems, MC 107-81
* 	California Institute of Technology
* 	Pasadena, CA, 91125, USA
*
*  	http://www.sbml.org
* 	mailto:sbml-team@caltech.edu
*
* Adapted for NUML by:
*
* 	NUML Team
* 	Computational Systems Biology Group
* 	School of Computer Science
* 	The University of Manchester
* 	Manchester, M1 7DN UK
* 	mailto:josephodada@gmail.com
*
*   Contributor(s):
*   Joseph O. Dada, The University of Manchester - initial LIBNUML API and implementation
* ***************************************************************************
**/


/**
 *
 * Some explanations about this file are warranted.  This file includes
 * one of the following (depending on operating system and compiler):
 * 
 * - <tt>libnuml-config-unix.h</tt>
 * - <tt>libnuml-config-win.h</tt>
 * 
 * On Linux, MacOS X, Cygwin, etc., <tt>libnuml-config-unix.h</tt> and
 * <tt>libnuml-package.h</tt> are generated from
 * <tt>libnuml-config-unix.h.in</tt> and <tt>libnuml-package.h.in</tt>,
 * respectively, by the @c configure script at the top level of the libNUML
 * distribution.
 * 
 * On Windows, we cannot rely on <tt>libnuml-config-win.h</tt> being
 * generated by @c configure, since most developers will not be able to run
 * @c configure in that environment.  Instead, both
 * <tt>libnuml-config-win.h</tt> and <tt>libnuml-package.h</tt> (which see)
 * are stored in the source repository and must be updated by the libNUML
 * developers as necessary.  The file <tt>libnuml-config-win.h</tt> should
 * rarely, if ever, need to be updated, while <tt>libnuml-package.h</tt>
 * should require minor updates prior to each libnuml release.  This is
 * admittedly not an ideal and fool-proof arrangement; however, at this
 * time it is the best we have been able to find under the circumstances.
 * 
 * Finally, <tt>libnuml-config.h</tt>, <tt>libnuml-package.h</tt>,
 * <tt>libnuml-config-unix.h</tt>, and (for consistency)
 * <tt>libnuml-config-win.h</tt> are all installed by @c "make install".
 */

#ifndef LIBNUML_CONFIG_H
#define LIBNUML_CONFIG_H 1

#include <numl/common/libnuml-namespace.h>

#include <numl/common/libnuml-config-common.h>

#include <numl/common/libnuml-version.h>


#endif  /* LIBNUML_CONFIG_H */
