/**
 * @file Transition.h
 * @brief Implementation of the Transition class
 * @author Generated by autocreate code
 *
 * <!--------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright (C) 2013-2016 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. EMBL European Bioinformatics Institute (EMBL-EBI), Hinxton, UK
 *     3. University of Heidelberg, Heidelberg, Germany
 * 
 * Copyright (C) 2009-2013 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. EMBL European Bioinformatics Institute (EMBL-EBI), Hinxton, UK
 *
 * Copyright (C) 2006-2008 by the California Institute of Technology,
 *     Pasadena, CA, USA 
 *
 * Copyright (C) 2002-2005 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. Japan Science and Technology Agency, Japan
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 * ------------------------------------------------------------------------ -->
 *
 * @class Transition
 * @sbmlbrief{qual} A transition of a QualitativeSpecies.
 *
 * A Transition element contains at most one ListOfInputs and one
 * ListOfOutputs and exactly one ListOfFunctionTerms.
 *
 * A Transition defines the changes in level associated with the
 * QualitativeSpecies that occur when a Transition is enabled.
 * 
 * In logical models, a Transition is used to specify the logical rule
 * associated with a QualitativeSpecies (that appears as an Output of this
 * Transition). For example, the rule "if A > 1 : B = 2" would be
 * encapsulated as a Transition with QualitativeSpecies "A" as an Input and
 * "B" as an Output; the "if A > 1" rule being encode by the math element of
 * a FunctionTerm with the resultLevel attribute having a value "2".
 *
 * In Petri net models, a Transition is interpreted, using the common Petri
 * net semantics, as events that might occur within the system causing tokens
 * to be moved.
 * 
 */


#ifndef Transition_H__
#define Transition_H__


#include <sbml/common/extern.h>
#include <sbml/common/sbmlfwd.h>
#include <sbml/packages/qual/common/qualfwd.h>


#ifdef __cplusplus


#include <string>


#include <sbml/SBase.h>
#include <sbml/ListOf.h>
#include <sbml/packages/qual/extension/QualExtension.h>

#include <sbml/packages/qual/sbml/Input.h>
#include <sbml/packages/qual/sbml/Output.h>
#include <sbml/packages/qual/sbml/FunctionTerm.h>

LIBSBML_CPP_NAMESPACE_BEGIN


class LIBSBML_EXTERN Transition : public SBase
{

protected:

  /** @cond doxygenLibsbmlInternal */
  std::string   mId;
  std::string   mName;
  ListOfInputs   mInputs;
  ListOfOutputs   mOutputs;
  ListOfFunctionTerms   mFunctionTerms;
  /** @endcond */


public:

  /**
   * Creates a new Transition with the given level, version, and package version.
   *
   * @param level an unsigned int, the SBML Level to assign to this Transition
   *
   * @param version an unsigned int, the SBML Version to assign to this Transition
   *
   * @param pkgVersion an unsigned int, the SBML Qual Version to assign to this Transition
   */
  Transition(unsigned int level      = QualExtension::getDefaultLevel(),
             unsigned int version    = QualExtension::getDefaultVersion(),
             unsigned int pkgVersion = QualExtension::getDefaultPackageVersion());


  /**
   * Creates a new Transition with the given QualPkgNamespaces object.
   *
   * @param qualns the QualPkgNamespaces object
   */
  Transition(QualPkgNamespaces* qualns);


  /**
   * Copy constructor for Transition.
   *
   * @param orig the Transition instance to copy.
   */
  Transition(const Transition& orig);


  /**
   * Assignment operator for Transition.
   *
   * @param rhs the object whose values are used as the basis
   * of the assignment
   */
  Transition& operator=(const Transition& rhs);


  /**
   * Creates and returns a deep copy of this Transition object.
   *
   * @return a (deep) copy of this Transition object.
   */
  virtual Transition* clone () const;


  /**
   * Destructor for Transition.
   */
  virtual ~Transition();


  /**
   * Returns the first child element found that has the given @p id 
   * in the model-wide SId namespace, or @c NULL if no such object is found.
   *
   * @param id string representing the id of objects to find
   *
   * @return a pointer to the SBase element with the given @p id.
   */
  virtual SBase* getElementBySId(const std::string& id);
  
  
  /**
   * Returns the first child element it can find with the given @p metaid, 
   * or itself if it has the given @p metaid, or @c NULL if no such object 
   * is found.
   *
   * @param metaid string representing the metaid of objects to find
   *
   * @return a pointer to the SBase element with the given @p metaid.
   */
  virtual SBase* getElementByMetaId(const std::string& metaid);
  

  /**
   * Returns the value of the "id" attribute of this Transition.
   *
   * @return the value of the "id" attribute of this Transition as a string.
   */
  virtual const std::string& getId() const;


  /**
   * Returns the value of the "name" attribute of this Transition.
   *
   * @return the value of the "name" attribute of this Transition as a string.
   */
  virtual const std::string& getName() const;


  /**
   * Predicate returning @c true or @c false depending on whether this
   * Transition's "id" attribute has been set.
   *
   * @return @c true if this Transition's "id" attribute has been set,
   * otherwise @c false is returned.
   */
  virtual bool isSetId() const;


  /**
   * Predicate returning @c true or @c false depending on whether this
   * Transition's "name" attribute has been set.
   *
   * @return @c true if this Transition's "name" attribute has been set,
   * otherwise @c false is returned.
   */
  virtual bool isSetName() const;


  /**
   * Sets the value of the "id" attribute of this Transition.
   *
   * @param id const std::string& value of the "id" attribute to be set
   *
   * @copydetails doc_returns_success_code
   * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
   * @li @sbmlconstant{LIBSBML_INVALID_ATTRIBUTE_VALUE, OperationReturnValues_t}
   */
  virtual int setId(const std::string& id);


  /**
   * Sets the value of the "name" attribute of this Transition.
   *
   * @param name const std::string& value of the "name" attribute to be set
   *
   * @copydetails doc_returns_success_code
   * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
   * @li @sbmlconstant{LIBSBML_INVALID_ATTRIBUTE_VALUE, OperationReturnValues_t}
   */
  virtual int setName(const std::string& name);


  /**
   * Unsets the value of the "id" attribute of this Transition.
   *
   * @copydetails doc_returns_success_code
   * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
   * @li @sbmlconstant{LIBSBML_OPERATION_FAILED, OperationReturnValues_t}
   */
  virtual int unsetId();


  /**
   * Unsets the value of the "name" attribute of this Transition.
   *
   * @copydetails doc_returns_success_code
   * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
   * @li @sbmlconstant{LIBSBML_OPERATION_FAILED, OperationReturnValues_t}
   */
  virtual int unsetName();


  /**
   * Returns the  "ListOfInputs" in this Transition object.
   *
   * @return the "ListOfInputs" attribute of this Transition.
   */
  const ListOfInputs* getListOfInputs() const;


  /**
   * Returns the  "ListOfInputs" in this Transition object.
   *
   * @return the "ListOfInputs" attribute of this Transition.
   */
  ListOfInputs* getListOfInputs();


  /**
   * Get a Input from the ListOfInputs.
   *
   * @param n the index number of the Input to get.
   *
   * @return the nth Input in the ListOfInputs within this Transition.
   *
   * @see getNumInputs()
   */
  Input* getInput(unsigned int n);


  /**
   * Get a Input from the ListOfInputs.
   *
   * @param n the index number of the Input to get.
   *
   * @return the nth Input in the ListOfInputs within this Transition.
   *
   * @see getNumInputs()
   */
  const Input* getInput(unsigned int n) const;


  /**
   * Get a Input from the ListOfInputs
   * based on its identifier.
   *
   * @param sid a string representing the identifier
   * of the Input to get.
   *
   * @return the Input in the ListOfInputs
   * with the given id or NULL if no such
   * Input exists.
   *
   * @see getInput(unsigned int n)
   * @see getNumInputs()
   */
  Input* getInput(const std::string& sid);


  /**
   * Get a Input from the ListOfInputs
   * based on its identifier.
   *
   * @param sid a string representing the identifier
   * of the Input to get.
   *
   * @return the Input in the ListOfInputs
   * with the given id or NULL if no such
   * Input exists.
   *
   * @see getInput(unsigned int n)
   *
   * @see getNumInputs()
   */
  const Input* getInput(const std::string& sid) const;


  /**
   * Get a Input from the ListOfInputs
   * based on its qualitativeSpecies attribute.
   *
   * @param sid a string representing the qualitativeSpecies
   * of the Input to get.
   *
   * @return the first Input in the ListOfInputs
   * with the given qualitativeSpecies or NULL if no such
   * Input exists.
   *
   * @see getInput(unsigned int n)
   *
   * @see getNumInputs()
   */
  Input* getInputBySpecies(const std::string& sid);


  /**
   * Get a Input from the ListOfInputs
   * based on its qualitativeSpecies attribute.
   *
   * @param sid a string representing the qualitativeSpecies
   * of the Input to get.
   *
   * @return the first Input in the ListOfInputs
   * with the given qualitativeSpecies or NULL if no such
   * Input exists.
   *
   * @see getInput(unsigned int n)
   *
   * @see getNumInputs()
   */
  const Input* getInputBySpecies(const std::string& sid) const;


  /**
   * Adds a copy the given "Input" to this Transition.
   *
   * @param i the Input object to add
   *
   * @copydetails doc_returns_success_code
   * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
   * @li @sbmlconstant{LIBSBML_INVALID_ATTRIBUTE_VALUE, OperationReturnValues_t}
   */
  int addInput(const Input* i);


  /**
   * Get the number of Input objects in this Transition.
   *
   * @return the number of Input objects in this Transition
   */
  unsigned int getNumInputs() const;


  /**
   * Creates a new Input object, adds it to this Transitions
   * ListOfInputs and returns the Input object created. 
   *
   * @return a new Input object instance
   *
   * @see addInput(const Input* i)
   */
  Input* createInput();


  /**
   * Removes the nth Input from the ListOfInputs within this Transition.
   * and returns a pointer to it.
   *
   * The caller owns the returned item and is responsible for deleting it.
   *
   * @param n the index of the Input to remove.
   *
   * @see getNumInputs()
   */
  Input* removeInput(unsigned int n);


  /**
   * Removes the Input with the given identifier from the ListOfInputs within this Transition
   * and returns a pointer to it.
   *
   * The caller owns the returned item and is responsible for deleting it.
   * If none of the items in this list have the identifier @p sid, then
   * @c NULL is returned.
   *
   * @param sid the identifier of the Input to remove.
   *
   * @return the Input removed. As mentioned above, the caller owns the
   * returned item.
   */
  Input* removeInput(const std::string& sid);


  /**
   * Returns the  "ListOfOutputs" in this Transition object.
   *
   * @return the "ListOfOutputs" attribute of this Transition.
   */
  const ListOfOutputs* getListOfOutputs() const;


  /**
   * Returns the  "ListOfOutputs" in this Transition object.
   *
   * @return the "ListOfOutputs" attribute of this Transition.
   */
  ListOfOutputs* getListOfOutputs();


  /**
   * Get a Output from the ListOfOutputs.
   *
   * @param n the index number of the Output to get.
   *
   * @return the nth Output in the ListOfOutputs within this Transition.
   *
   * @see getNumOutputs()
   */
  Output* getOutput(unsigned int n);


  /**
   * Get a Output from the ListOfOutputs.
   *
   * @param n the index number of the Output to get.
   *
   * @return the nth Output in the ListOfOutputs within this Transition.
   *
   * @see getNumOutputs()
   */
  const Output* getOutput(unsigned int n) const;


  /**
   * Get a Output from the ListOfOutputs
   * based on its identifier.
   *
   * @param sid a string representing the identifier
   * of the Output to get.
   *
   * @return the Output in the ListOfOutputs
   * with the given id or NULL if no such
   * Output exists.
   *
   * @see getOutput(unsigned int n)
   *
   * @see getNumOutputs()
   */
  Output* getOutput(const std::string& sid);


  /**
   * Get a Output from the ListOfOutputs
   * based on its identifier.
   *
   * @param sid a string representing the identifier
   * of the Output to get.
   *
   * @return the Output in the ListOfOutputs
   * with the given id or NULL if no such
   * Output exists.
   *
   * @see getOutput(unsigned int n)
   *
   * @see getNumOutputs()
   */
  const Output* getOutput(const std::string& sid) const;


  /**
   * Get a Output from the ListOfOutputs
   * based on its qualitativeSpecies attribute.
   *
   * @param sid a string representing the qualitativeSpecies
   * of the Output to get.
   *
   * @return the first Output in the ListOfOutputs
   * with the given qualitativeSpecies or NULL if no such
   * Output exists.
   *
   * @see getOutput(unsigned int n)
   *
   * @see getNumOutputs()
   */
  Output* getOutputBySpecies(const std::string& sid);


  /**
   * Get a Output from the ListOfOutputs
   * based on its qualitativeSpecies attribute.
   *
   * @param sid a string representing the qualitativeSpecies
   * of the Output to get.
   *
   * @return the first Output in the ListOfOutputs
   * with the given qualitativeSpecies or NULL if no such
   * Output exists.
   *
   * @see getOutput(unsigned int n)
   *
   * @see getNumOutputs()
   */
  const Output* getOutputBySpecies(const std::string& sid) const;


  /**
   * Adds a copy the given "Output" to this Transition.
   *
   * @param o the Output object to add
   *
   * @copydetails doc_returns_success_code
   * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
   * @li @sbmlconstant{LIBSBML_INVALID_ATTRIBUTE_VALUE, OperationReturnValues_t}
   */
  int addOutput(const Output* o);


  /**
   * Get the number of Output objects in this Transition.
   *
   * @return the number of Output objects in this Transition
   */
  unsigned int getNumOutputs() const;


  /**
   * Creates a new Output object, adds it to this Transitions
   * ListOfOutputs and returns the Output object created. 
   *
   * @return a new Output object instance
   *
   * @see addOutput(const Output* o)
   */
  Output* createOutput();


  /**
   * Removes the nth Output from the ListOfOutputs within this Transition.
   * and returns a pointer to it.
   *
   * The caller owns the returned item and is responsible for deleting it.
   *
   * @param n the index of the Output to remove.
   *
   * @see getNumOutputs()
   */
  Output* removeOutput(unsigned int n);


  /**
   * Removes the Output with the given identifier from the ListOfOutputs within this Transition
   * and returns a pointer to it.
   *
   * The caller owns the returned item and is responsible for deleting it.
   * If none of the items in this list have the identifier @p sid, then
   * @c NULL is returned.
   *
   * @param sid the identifier of the Output to remove.
   *
   * @return the Output removed. As mentioned above, the caller owns the
   * returned item.
   */
  Output* removeOutput(const std::string& sid);


  /**
   * Returns the  "ListOfFunctionTerms" in this Transition object.
   *
   * @return the "ListOfFunctionTerms" attribute of this Transition.
   */
  const ListOfFunctionTerms* getListOfFunctionTerms() const;


  /**
   * Returns the  "ListOfFunctionTerms" in this Transition object.
   *
   * @return the "ListOfFunctionTerms" attribute of this Transition.
   */
  ListOfFunctionTerms* getListOfFunctionTerms();


  /**
   * Get a FunctionTerm from the ListOfFunctionTerms.
   *
   * @param n the index number of the FunctionTerm to get.
   *
   * @return the nth FunctionTerm in the ListOfFunctionTerms within this Transition.
   *
   * @see getNumFunctionTerms()
   */
  FunctionTerm* getFunctionTerm(unsigned int n);


  /**
   * Get a FunctionTerm from the ListOfFunctionTerms.
   *
   * @param n the index number of the FunctionTerm to get.
   *
   * @return the nth FunctionTerm in the ListOfFunctionTerms within this Transition.
   *
   * @see getNumFunctionTerms()
   */
  const FunctionTerm* getFunctionTerm(unsigned int n) const;


  /**
   * Get a FunctionTerm from the ListOfFunctionTerms
   * based on its identifier.
   *
   * @param sid a string representing the identifier
   * of the FunctionTerm to get.
   *
   * @return the FunctionTerm in the ListOfFunctionTerms
   * with the given id or NULL if no such
   * FunctionTerm exists.
   *
   * @see getFunctionTerm(unsigned int n)
   *
   * @see getNumFunctionTerms()
   */
  FunctionTerm* getFunctionTerm(const std::string& sid);


  /**
   * Get a FunctionTerm from the ListOfFunctionTerms
   * based on its identifier.
   *
   * @param sid a string representing the identifier
   * of the FunctionTerm to get.
   *
   * @return the FunctionTerm in the ListOfFunctionTerms
   * with the given id or NULL if no such
   * FunctionTerm exists.
   *
   * @see getFunctionTerm(unsigned int n)
   *
   * @see getNumFunctionTerms()
   */
  const FunctionTerm* getFunctionTerm(const std::string& sid) const;


  /**
   * Adds a copy the given "FunctionTerm" to this Transition.
   *
   * @param ft the FunctionTerm object to add
   *
   * @copydetails doc_returns_success_code
   * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
   * @li @sbmlconstant{LIBSBML_INVALID_ATTRIBUTE_VALUE, OperationReturnValues_t}
   */
  int addFunctionTerm(const FunctionTerm* ft);


  /**
   * Get the number of FunctionTerm objects in this Transition.
   *
   * @return the number of FunctionTerm objects in this Transition
   */
  unsigned int getNumFunctionTerms() const;


  /**
   * Creates a new FunctionTerm object, adds it to this Transitions
   * ListOfFunctionTerms and returns the FunctionTerm object created. 
   *
   * @return a new FunctionTerm object instance
   *
   * @see addFunctionTerm(const FunctionTerm* ft)
   */
  FunctionTerm* createFunctionTerm();


  /**
   * Removes the nth FunctionTerm from the ListOfFunctionTerms within this Transition.
   * and returns a pointer to it.
   *
   * The caller owns the returned item and is responsible for deleting it.
   *
   * @param n the index of the FunctionTerm to remove.
   *
   * @see getNumFunctionTerms()
   */
  FunctionTerm* removeFunctionTerm(unsigned int n);


  /**
   * Removes the FunctionTerm with the given identifier from the ListOfFunctionTerms within this Transition
   * and returns a pointer to it.
   *
   * The caller owns the returned item and is responsible for deleting it.
   * If none of the items in this list have the identifier @p sid, then
   * @c NULL is returned.
   *
   * @param sid the identifier of the FunctionTerm to remove.
   *
   * @return the FunctionTerm removed. As mentioned above, the caller owns the
   * returned item.
   */
  FunctionTerm* removeFunctionTerm(const std::string& sid);


  /**
   * Creates a new DefaultTerm object, adds it to this Transitions
   * ListOfFunctionTerms and returns the DefaultTerm object created. 
   *
   * @return a new DefaultTerm object instance
   *
   * @see setDefaultTerm(const DefaultTerm* ft)
   */
   DefaultTerm* createDefaultTerm();


  /**
   * Sets the given "DefaultTerm" to this Transition.
   *
   * @param dt the DefaultTerm object to add
   *
   * @copydetails doc_returns_success_code
   * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
   * @li @sbmlconstant{LIBSBML_INVALID_ATTRIBUTE_VALUE, OperationReturnValues_t}
   */
  int setDefaultTerm(const DefaultTerm* dt);


  /**
   * Predicate returning @c true if the defaultTerm
   * for this Transition object has been set.
   *
   * @return a boolean value indicating whether the defaultTerm
   * child for this object has been defined.
   */
  bool isSetDefaultTerm() const;
  
  /**
   * Get the DefaultTerm from the ListOfFunctionTerms.
   *
   * @return the DefaultTerm in the ListOfFunctionTerms within this Transition, or NULL if no such value is set.
   */
  DefaultTerm* getDefaultTerm();

  /**
   * Get the DefaultTerm from the ListOfFunctionTerms.
   *
   * @return the DefaultTerm in the ListOfFunctionTerms within this Transition, or NULL if no such value is set.
   */
  const DefaultTerm* getDefaultTerm() const;
  
  /**
   * Returns a List of all child SBase objects, including those nested to an
   * arbitary depth.
   *
   * @return a List* of pointers to all child objects.
   */
   virtual List* getAllElements(ElementFilter * filter = NULL);


  /**
   * Returns the XML name of this object.
   *
   * @return the name of this element.
   */
  virtual const std::string& getElementName () const;


  /**
   * Returns the libSBML type code of this object instance.
   *
   * @copydetails doc_what_are_typecodes
   *
   * @return the SBML type code for this object:
   * @sbmlconstant{SBML_QUAL_TRANSITION, SBMLQualTypeCode_t}
   *
   * @copydetails doc_warning_typecodes_not_unique
   *
   * @see getElementName()
   * @see getPackageName()
   */
  virtual int getTypeCode () const;


  /**
   * Predicate returning @c true if all the required attributes
   * for this Transition object have been set.
   *
   * @note The required elements for a Transition object are:
   * @li a "defaultTerm" child of the child ListOfFunctionTerms.
   *
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */
  virtual bool hasRequiredElements() const;


  /** @cond doxygenLibsbmlInternal */
  /**
   * Subclasses should override this method to write out their contained
   * SBML objects as XML elements.  Be sure to call your parents
   * implementation of this method as well.
   */
  virtual void writeElements (XMLOutputStream& stream) const;


  /** @endcond */


  /** @cond doxygenLibsbmlInternal */
  /**
   * Accepts the given SBMLVisitor.
   */
  virtual bool accept (SBMLVisitor& v) const;
  /** @endcond */


  /** @cond doxygenLibsbmlInternal */
  /**
   * Sets the parent SBMLDocument.
   */
  virtual void setSBMLDocument (SBMLDocument* d);


  /** @endcond */


  /** @cond doxygenLibsbmlInternal */
  /**
   * Connects to child elements.
   */
  virtual void connectToChild ();


  /** @endcond */


  /** @cond doxygenLibsbmlInternal */
  /**
   * Enables/Disables the given package with this element.
   */
  virtual void enablePackageInternal(const std::string& pkgURI,
               const std::string& pkgPrefix, bool flag);


  /** @endcond */


protected:

  /** @cond doxygenLibsbmlInternal */
  /**
   * Create and return an SBML object of this class, if present.
   *
   * @return the SBML object corresponding to next XMLToken in the
   * XMLInputStream or @c NULL if the token was not recognized.
   */
  virtual SBase* createObject (XMLInputStream& stream);


  /**
   * Get the list of expected attributes for this element.
   */
  virtual void addExpectedAttributes(ExpectedAttributes& attributes);


  /** @endcond */


  /** @cond doxygenLibsbmlInternal */
  /**
   * Read values from the given XMLAttributes set into their specific fields.
   */
  virtual void readAttributes (const XMLAttributes& attributes,
                               const ExpectedAttributes& expectedAttributes);


  /** @endcond */


  /** @cond doxygenLibsbmlInternal */
  /**
   * Write values of XMLAttributes to the output stream.
   */
  virtual void writeAttributes (XMLOutputStream& stream) const;


  /** @endcond */



};

/**
 * @class ListOfTransitions
 * @sbmlbrief{qual} A list of Transition objects.
 * 
 * The ListOfTransitions is a container for the Transition elements of a Model.
 * 
 * @copydetails doc_what_is_listof
 *
 * @see Transition
 */
class LIBSBML_EXTERN ListOfTransitions : public ListOf
{

public:

  /**
   * Creates a new ListOfTransitions with the given level, version, and package version.
   *
   * @param level an unsigned int, the SBML Level to assign to this ListOfTransitions
   *
   * @param version an unsigned int, the SBML Version to assign to this ListOfTransitions
   *
   * @param pkgVersion an unsigned int, the SBML Qual Version to assign to this ListOfTransitions
   */
  ListOfTransitions(unsigned int level      = QualExtension::getDefaultLevel(),
                    unsigned int version    = QualExtension::getDefaultVersion(),
                    unsigned int pkgVersion = QualExtension::getDefaultPackageVersion());


  /**
   * Creates a new ListOfTransitions with the given QualPkgNamespaces object.
   *
   * @param qualns the QualPkgNamespaces object
   */
  ListOfTransitions(QualPkgNamespaces* qualns);


  /**
   * Creates and returns a deep copy of this ListOfTransitions object.
   *
   * @return a (deep) copy of this ListOfTransitions object.
   */
  virtual ListOfTransitions* clone () const;


  /**
   * Get a Transition from the ListOfTransitions.
   *
   * @param n the index number of the Transition to get.
   *
   * @return the nth Transition in this ListOfTransitions.
   *
   * @see size()
   */
  virtual Transition* get(unsigned int n);


  /**
   * Get a Transition from the ListOfTransitions.
   *
   * @param n the index number of the Transition to get.
   *
   * @return the nth Transition in this ListOfTransitions.
   *
   * @see size()
   */
  virtual const Transition* get(unsigned int n) const;


  /**
   * Get a Transition from the ListOfTransitions
   * based on its identifier.
   *
   * @param sid a string representing the identifier
   * of the Transition to get.
   *
   * @return Transition in this ListOfTransitions
   * with the given id or NULL if no such
   * Transition exists.
   *
   * @see get(unsigned int n)   *
   * @see size()
   */
  virtual Transition* get(const std::string& sid);


  /**
   * Get a Transition from the ListOfTransitions
   * based on its identifier.
   *
   * @param sid a string representing the identifier
   * of the Transition to get.
   *
   * @return Transition in this ListOfTransitions
   * with the given id or NULL if no such
   * Transition exists.
   *
   * @see get(unsigned int n)   *
   * @see size()
   */
  virtual const Transition* get(const std::string& sid) const;


  /**
   * Removes the nth Transition from this ListOfTransitions
   * and returns a pointer to it.
   *
   * The caller owns the returned item and is responsible for deleting it.
   *
   * @param n the index of the Transition to remove.
   *
   * @see size()
   */
  virtual Transition* remove(unsigned int n);


  /**
   * Removes the Transition from this ListOfTransitions with the given identifier
   * and returns a pointer to it.
   *
   * The caller owns the returned item and is responsible for deleting it.
   * If none of the items in this list have the identifier @p sid, then
   * @c NULL is returned.
   *
   * @param sid the identifier of the Transition to remove.
   *
   * @return the Transition removed. As mentioned above, the caller owns the
   * returned item.
   */
  virtual Transition* remove(const std::string& sid);


  /**
   * Returns the XML name of this object.
   *
   * @return the name of this element.
   */
  virtual const std::string& getElementName () const;


  /**
   * Returns the libSBML type code for the SBML objects
   * contained in this ListOf object.
   * 
   * @copydetails doc_what_are_typecodes
   *
   * @return the SBML type code for objects contained in this list:
   * @sbmlconstant{SBML_QUAL_TRANSITION, SBMLTypeCode_t} (default).
   *
   * @see getElementName()
   * @see getPackageName()
   */
  virtual int getItemTypeCode () const;


protected:

  /** @cond doxygenLibsbmlInternal */
  /**
   * Creates a new Transition in this ListOfTransitions
   */
  virtual SBase* createObject(XMLInputStream& stream);


  /** @endcond */


  /** @cond doxygenLibsbmlInternal */
  /**
   * Write the namespace for the Qual package.
   */
  virtual void writeXMLNS(XMLOutputStream& stream) const;


  /** @endcond */



};



LIBSBML_CPP_NAMESPACE_END

#endif  /*  __cplusplus  */

#ifndef SWIG

LIBSBML_CPP_NAMESPACE_BEGIN
BEGIN_C_DECLS

/**
 * Creates a new Transition_t structure using the given SBML @p level
 * and @p version values.
 *
 * @param level an unsigned int, the SBML Level to assign to this
 * Transition_t
 * @param version an unsigned int, the SBML Version to assign to this
 * Transition_t
 * @param pkgVersion an unsigned int, the SBML 'Qual' package Version to assign to this
 * Transition_t
 *
 * @return a pointer to the newly created Transition_t structure.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Transition_t *
Transition_create(unsigned int level, unsigned int version,
                  unsigned int pkgVersion);


/**
 * Frees the given Transition_t structure.
 *
 * @param t the Transition_t structure to free.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
void
Transition_free(Transition_t * t);


/**
 * Returns a copy of the given Transition_t structure.
 *
 * @param t the Transition_t structure to copy.
 * 
 * @return a (deep) copy of the Transition_t.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Transition_t *
Transition_clone(Transition_t * t);


/**
 * Takes an Transition_t structure and returns its identifier.
 *
 * @param t the Transition_t structure whose identifier is sought
 * 
 * @return the identifier of this Transition_t, as a pointer to a string.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
char *
Transition_getId(Transition_t * t);


/**
 * Takes a Transition_t structure and returns its name.
 *
 * @param t the Transition_t whose name is sought.
 *
 * @return the name of this Transition_t, as a pointer to a string.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
char *
Transition_getName(Transition_t * t);


/**
 * Predicate returning @c true or @c false depending on whether the given
 * Transition_t structure's identifier is set.
 *
 * @param t the Transition_t structure to query
 * 
 * @return @c non-zero (true) if the "id" attribute of the given
 * Transition_t structure is set, zero (false) otherwise.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
int
Transition_isSetId(Transition_t * t);


/**
 * Predicate returning @c true or @c false depending on whether the given
 * Transition_t structure's name is set.
 *
 * @param t the Transition_t structure to query
 * 
 * @return @c non-zero (true) if the "name" attribute of the given
 * Transition_t structure is set, zero (false) otherwise.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
int
Transition_isSetName(Transition_t * t);


/**
 * Assigns the identifier of an Transition_t structure.
 *
 * This makes a copy of the string passed in the param @p sid.
 *
 * @param t the Transition_t structure to set.
 * @param sid the string to use as the identifier.
 *
 * @copydetails doc_returns_success_code
 * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_INVALID_ATTRIBUTE_VALUE, OperationReturnValues_t}
 *
 * @note Using this function with an id of NULL is equivalent to
 * unsetting the "id" attribute.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
int
Transition_setId(Transition_t * t, const char * sid);


/**
 * Sets the name of the given Transition_t to a copy of @p name.
 *
 * @param t the Transition_t structure to set
 * @param name the name to assign to the given Transition_t's "name" attribute.
 *
 * @copydetails doc_returns_success_code
 * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_INVALID_ATTRIBUTE_VALUE, OperationReturnValues_t}
 *
 * @note Using this function with the name set to NULL is equivalent to
 * unsetting the "name" attribute.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
int
Transition_setName(Transition_t * t, const char * name);


/**
 * Unsets the "id" attribute of the given Transition_t structure.
 *
 * @param t the Transition_t structure to unset
 *
 * @copydetails doc_returns_success_code
 * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_OPERATION_FAILED, OperationReturnValues_t}
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
int
Transition_unsetId(Transition_t * t);


/**
 * Unsets the "name" attribute of the given Transition_t structure.
 *
 * @param t the Transition_t structure to unset
 *
 * @copydetails doc_returns_success_code
 * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_OPERATION_FAILED, OperationReturnValues_t}
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
int
Transition_unsetName(Transition_t * t);


/**
 * Appends a copy of the given Input_t structure to the given Transition_t
 * structure.
 *
 * @param t the Transition_t structure to which the Input_t should be
 * added
 *
 * @param i an Input_t structure to add
 *
 * @copydetails doc_returns_success_code
 * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_LEVEL_MISMATCH, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_VERSION_MISMATCH, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_PKG_VERSION_MISMATCH, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_DUPLICATE_OBJECT_ID, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_OPERATION_FAILED, OperationReturnValues_t}
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
int
Transition_addInput(Transition_t * t, Input_t * i);


/**
 * Creates a new, empty Input_t structure, adds it to the given
 * Transition_t, and returns the Input_t.
 *
 * @param t the Transition_t structure to which the Input_t should be
 * added
 *
 * @return the newly-created empty Input_t.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Input_t *
Transition_createInput(Transition_t * t);


/**
 * Get the list of Input_t structures from the given Transition_t
 * structure.
 *
 * @param t the Transition_t structure to use.
 *
 * @return the list of Input_t's for the given Transition_t.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
ListOf_t *
Transition_getListOfInputs(Transition_t * t);


/**
 * Return a specific Input_t structure of the given Transition_t.
 *
 * @param t the Transition_t structure to use
 *
 * @param n an integer, the index of the Input_t structure to return
 * 
 * @return the nth Input_t of the given Transition_t, or @c NULL if no such Input_t exists.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Input_t *
Transition_getInput(Transition_t * t, unsigned int n);


/**
 * Return the Input_t indicated by the given @p sid.
 *
 * @param t the Transition_t structure to use
 *
 * @param sid a string, the identifier of the
 * Input_t is being sought.
 *
 * @return the Input_t for the given variable, or @c NULL if no such
 * Input_t exits.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Input_t *
Transition_getInputById(Transition_t * t, const char * sid);


/**
 * Returns the number of EventAssignment_t structures attached to the given
 * Transition_t.
 *
 * @param t the Transition_t structure to use
 * 
 * @return the number of EventAssignment_t structures in the given Transition_t.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
unsigned int
Transition_getNumInputs(Transition_t * t);


/**
 * Removes the nth Input_t structure from the given Transition_t structure and
 * returns a pointer to it.
 *
 * The caller owns the returned structure and is responsible for deleting it.
 *
 * @param t the Transition_t structure
 * @param n the integer index of the Input_t sought
 *
 * @return the Input_t structure removed.  As mentioned above, 
 * the caller owns the returned item. @c NULL is returned if the given index 
 * is out of range.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Input_t *
Transition_removeInput(Transition_t * t, unsigned int n);


/**
 * Removes the Input_t structure with the given @p sid
 * from the given Transition_t structure and returns a pointer to it.
 *
 * The caller owns the returned structure and is responsible for deleting it.
 *
 * @param t the Transition_t structure
 * @param sid the string of the "id" attribute of the Input_t sought
 *
 * @return the Input_t structure removed.  As mentioned above, the 
 * caller owns the returned structure. @c NULL is returned if no Input_t
 * structure with the "id" attribute exists in the given Transition_t structure.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Input_t *
Transition_removeInputById(Transition_t * t, const char * sid);


/**
 * Appends a copy of the given Output_t structure to the given Transition_t
 * structure.
 *
 * @param t the Transition_t structure to which the Output_t should be
 * added
 *
 * @param o an Output_t structure to add
 *
 * @copydetails doc_returns_success_code
 * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_LEVEL_MISMATCH, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_VERSION_MISMATCH, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_PKG_VERSION_MISMATCH, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_DUPLICATE_OBJECT_ID, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_OPERATION_FAILED, OperationReturnValues_t}
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
int
Transition_addOutput(Transition_t * t, Output_t * o);


/**
 * Creates a new, empty Output_t structure, adds it to the given
 * Transition_t, and returns the Output_t.
 *
 * @param t the Transition_t structure to which the Output_t should be
 * added
 *
 * @return the newly-created empty Output_t.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Output_t *
Transition_createOutput(Transition_t * t);


/**
 * Get the list of Output_t structures from the given Transition_t
 * structure.
 *
 * @param t the Transition_t structure to use.
 *
 * @return the list of Output_t's for the given Transition_t.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
ListOf_t *
Transition_getListOfOutputs(Transition_t * t);


/**
 * Return a specific Output_t structure of the given Transition_t.
 *
 * @param t the Transition_t structure to use
 *
 * @param n an integer, the index of the Output_t structure to return
 * 
 * @return the nth Output_t of the given Transition_t, or @c NULL if no such Output_t exists.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Output_t *
Transition_getOutput(Transition_t * t, unsigned int n);


/**
 * Return the Output_t indicated by the given @p sid.
 *
 * @param t the Transition_t structure to use
 *
 * @param sid a string, the identifier of the
 * Output_t is being sought.
 *
 * @return the Output_t for the given variable, or @c NULL if no such
 * Output_t exits.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Output_t *
Transition_getOutputById(Transition_t * t, const char * sid);


/**
 * Returns the number of EventAssignment_t structures attached to the given
 * Transition_t.
 *
 * @param t the Transition_t structure to use
 * 
 * @return the number of EventAssignment_t structures in the given Transition_t.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
unsigned int
Transition_getNumOutputs(Transition_t * t);


/**
 * Removes the nth Output_t structure from the given Transition_t structure and
 * returns a pointer to it.
 *
 * The caller owns the returned structure and is responsible for deleting it.
 *
 * @param t the Transition_t structure
 * @param n the integer index of the Output_t sought
 *
 * @return the Output_t structure removed.  As mentioned above, 
 * the caller owns the returned item. @c NULL is returned if the given index 
 * is out of range.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Output_t *
Transition_removeOutput(Transition_t * t, unsigned int n);


/**
 * Removes the Output_t structure with the given @p sid
 * from the given Transition_t structure and returns a pointer to it.
 *
 * The caller owns the returned structure and is responsible for deleting it.
 *
 * @param t the Transition_t structure
 * @param sid the string of the "id" attribute of the Output_t sought
 *
 * @return the Output_t structure removed.  As mentioned above, the 
 * caller owns the returned structure. @c NULL is returned if no Output_t
 * structure with the "id" attribute exists in the given Transition_t structure.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Output_t *
Transition_removeOutputById(Transition_t * t, const char * sid);


/**
 * Appends a copy of the given FunctionTerm_t structure to the given Transition_t
 * structure.
 *
 * @param t the Transition_t structure to which the FunctionTerm_t should be
 * added
 *
 * @param ft a FunctionTerm_t structure to add
 *
 * @copydetails doc_returns_success_code
 * @li @sbmlconstant{LIBSBML_OPERATION_SUCCESS, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_LEVEL_MISMATCH, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_VERSION_MISMATCH, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_PKG_VERSION_MISMATCH, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_DUPLICATE_OBJECT_ID, OperationReturnValues_t}
 * @li @sbmlconstant{LIBSBML_OPERATION_FAILED, OperationReturnValues_t}
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
int
Transition_addFunctionTerm(Transition_t * t, FunctionTerm_t * ft);


/**
 * Creates a new, empty FunctionTerm_t structure, adds it to the given
 * Transition_t, and returns the FunctionTerm_t.
 *
 * @param t the Transition_t structure to which the FunctionTerm_t should be
 * added
 *
 * @return the newly-created empty FunctionTerm_t.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
FunctionTerm_t *
Transition_createFunctionTerm(Transition_t * t);


/**
 * Get the list of FunctionTerm_t structures from the given Transition_t
 * structure.
 *
 * @param t the Transition_t structure to use.
 *
 * @return the list of FunctionTerm_t's for the given Transition_t.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
ListOf_t *
Transition_getListOfFunctionTerms(Transition_t * t);


/**
 * Return a specific FunctionTerm_t structure of the given Transition_t.
 *
 * @param t the Transition_t structure to use
 *
 * @param n an integer, the index of the FunctionTerm_t structure to return
 * 
 * @return the nth FunctionTerm_t of the given Transition_t, or @c NULL if no such FunctionTerm_t exists.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
FunctionTerm_t *
Transition_getFunctionTerm(Transition_t * t, unsigned int n);


/**
 * Return the FunctionTerm_t indicated by the given @p sid.
 *
 * @param t the Transition_t structure to use
 *
 * @param sid a string, the identifier of the
 * FunctionTerm_t is being sought.
 *
 * @return the FunctionTerm_t for the given variable, or @c NULL if no such
 * FunctionTerm_t exits.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
FunctionTerm_t *
Transition_getFunctionTermById(Transition_t * t, const char * sid);


/**
 * Returns the number of EventAssignment_t structures attached to the given
 * Transition_t.
 *
 * @param t the Transition_t structure to use
 * 
 * @return the number of EventAssignment_t structures in the given Transition_t.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
unsigned int
Transition_getNumFunctionTerms(Transition_t * t);


/**
 * Removes the nth FunctionTerm_t structure from the given Transition_t structure and
 * returns a pointer to it.
 *
 * The caller owns the returned structure and is responsible for deleting it.
 *
 * @param t the Transition_t structure
 * @param n the integer index of the FunctionTerm_t sought
 *
 * @return the FunctionTerm_t structure removed.  As mentioned above, 
 * the caller owns the returned item. @c NULL is returned if the given index 
 * is out of range.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
FunctionTerm_t *
Transition_removeFunctionTerm(Transition_t * t, unsigned int n);


/**
 * Removes the FunctionTerm_t structure with the given @p sid
 * from the given Transition_t structure and returns a pointer to it.
 *
 * The caller owns the returned structure and is responsible for deleting it.
 *
 * @param t the Transition_t structure
 * @param sid the string of the "id" attribute of the FunctionTerm_t sought
 *
 * @return the FunctionTerm_t structure removed.  As mentioned above, the 
 * caller owns the returned structure. @c NULL is returned if no FunctionTerm_t
 * structure with the "id" attribute exists in the given Transition_t structure.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
FunctionTerm_t *
Transition_removeFunctionTermById(Transition_t * t, const char * sid);


/**
  * Predicate returning @c true or @c false depending on whether
  * all the required attributes for the given Transition_t structure
  * have been set.
  *
  * @note The required attributes for a Transition_t structure are:
  *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
int
Transition_hasRequiredAttributes(Transition_t * t);


/**
  * Predicate returning @c true or @c false depending on whether
  * all the required elements for the given Transition_t structure
  * have been set.
  *
  * @note The required elements for an Transition_t structure are:
  * @li a "defaultTerm" child of the child ListOfFunctionTerms.
  *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
int
Transition_hasRequiredElements(Transition_t * t);


/**
 * Return the Transition_t indicated by the given @p sid.
 *
 * @param lo the ListOf_t structure to use
 *
 * @param sid a string, the identifier of the
 * Transition_t is being sought.
 *
 * @return the Transition_t for the given variable, or @c NULL if no such
 * Transition_t exits.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Transition_t *
ListOfTransitions_getById(ListOf_t * lo, const char * sid);


/**
 * Removes the Transition_t structure with the given @p sid
 * from the given ListOf_t structure and returns a pointer to it.
 *
 * The caller owns the returned structure and is responsible for deleting it.
 *
 * @param lo the ListOf_t structure
 * @param sid the string of the "id" attribute of the Transition_t sought
 *
 * @return the Transition_t structure removed.  As mentioned above, the 
 * caller owns the returned structure. @c NULL is returned if no Transition_t
 * structure with the "id" attribute exists in the given ListOf_t structure.
 *
 * @memberof Transition_t
 */
LIBSBML_EXTERN
Transition_t *
ListOfTransitions_removeById(ListOf_t * lo, const char * sid);




END_C_DECLS
LIBSBML_CPP_NAMESPACE_END

#endif  /*  !SWIG  */

#endif /*  Transition_H__  */
