# -*- coding: utf-8 -*-
"""
Created on Mon Jun 21 12:05:03 2021

@author: Lucian
"""

# The KISAO.csv file was taken from https://bioportal.bioontology.org/ontologies/KISAO and will need to be updated periodically.  When you do, run this python script to recreate the kisaomap.cpp file.


import csv

kcpp = open("../sedml/kisaomap.cpp", "w")
kcpp.write("""
/**
 * \\file    kisao.cpp
 * \\brief   KiSAO map
 * \\author  Lucian Smith
 * 
 * <!--------------------------------------------------------------------------
 * 
 * This file is part of libSEDML.  Please visit http://sed-ml.org for more
 * information about SED-ML. The latest version of libSEDML can be found on 
 * github: https://github.com/fbergmann/libSEDML/
 * 
 * 
 * Copyright (c) 2013-2021, Frank T. Bergmann  
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * ---------------------------------------------------------------------- -->
 * 
 */
 
#include <map>
#include <string>
#include "sedml/common/libsedml-version.h"

LIBSEDML_CPP_NAMESPACE_BEGIN

std::map<int, std::string> g_kisaomap = {
""")

allterms = []
with open('KISAO.csv', newline='') as csvfile:
    reader = csv.reader(csvfile)
    for row in reader:
        if "Class ID" in row:
            continue
        k_id = int(row[0].split("_")[-1])
        k_name = row[1]
        if '"' in k_name:
            k_name = k_name.replace('"', "'")
            k_name = k_name.replace("\\", "")
        allterms.append((k_id, k_name))

allterms.sort()
for (k_id, k_name) in allterms:
    kcpp.write('   {' + str(k_id) + ', "' + k_name + '"},\n')
    print(k_id, k_name)
        
kcpp.write("};\nLIBSEDML_CPP_NAMESPACE_END\n\n")
kcpp.close()
