###############################################################################
#
# Description       : CMake build script for adding version to the python file 
# Original author(s): Frank Bergmann <fbergman@caltech.edu>
# Organization      : California Institute of Technology
#
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright (C) 2013-2016 jointly by the following organizations:
#     1. California Institute of Technology, Pasadena, CA, USA
#     2. EMBL European Bioinformatics Institute (EMBL-EBI), Hinxton, UK
#     3. University of Heidelberg, Heidelberg, Germany
#
# Copyright (C) 2009-2013 jointly by the following organizations: 
#     1. California Institute of Technology, Pasadena, CA, USA
#     2. EMBL European Bioinformatics Institute (EMBL-EBI), Hinxton, UK
#  
# Copyright (C) 2006-2008 by the California Institute of Technology,
#     Pasadena, CA, USA 
#  
# Copyright (C) 2002-2005 jointly by the following organizations: 
#     1. California Institute of Technology, Pasadena, CA, USA
#     2. Japan Science and Technology Agency, Japan
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
#
###############################################################################


if(NOT EXISTS ${CUR_BIN_DIRECTORY}/libnuml.py)
  message(FATAL_ERROR "  The SWIG wrapper has not yet been created")
else()

set(WRAPPER_FILE "${CUR_BIN_DIRECTORY}/libnuml.py")


file(READ "${WRAPPER_FILE}" SOURCECODE)

message("Python: patch loader")

file(WRITE "${WRAPPER_FILE}" "
# import statement needed on some systems
import sys
import os.path
import inspect
try: 
  _filename = inspect.getframeinfo(inspect.currentframe()).filename
except:
  _filename = __file__
_path = os.path.dirname(os.path.abspath(_filename))
if not _path in sys.path:
  sys.path.append(_path)

")


file(APPEND  "${WRAPPER_FILE}" "${SOURCECODE}")


message("Python: Add Version to generated file")

file(APPEND "${WRAPPER_FILE}" "
global __version__
__version__ = '${VERSION}'
")
endif()
