""" python-libtiepie - Python interface for libtiepie-hw library

Copyright (c) 2025 TiePie engineering

Website: https://www.tiepie.com/LibTiePie

"""

import sys
from ctypes import *
import platform
from .types import *
from ._platform import DLL_PATH, is_windows
import os


def load_libtiepie():
    """Load libtiepie-hw library and import all functions."""

    if is_windows:
        from ctypes.wintypes import HANDLE, HWND, LPARAM, WPARAM

        try:  # to use Python 3.8's DLL handling
            os.add_dll_directory(os.path.dirname(DLL_PATH))
        except AttributeError:  # <3.8, use PATH
            os.environ['PATH'] = os.path.dirname(DLL_PATH) + os.pathsep + os.environ['PATH']

    api = CDLL(DLL_PATH)

    api.tiepie_hw_init.restype = None
    api.tiepie_hw_init.argtypes = []
    api.tiepie_hw_is_initialized.restype = c_uint8
    api.tiepie_hw_is_initialized.argtypes = []
    api.tiepie_hw_fini.restype = None
    api.tiepie_hw_fini.argtypes = []
    api.tiepie_hw_get_version.restype = POINTER(tiepie_hw_version)
    api.tiepie_hw_get_version.argtypes = []
    api.tiepie_hw_get_config.restype = c_uint32
    api.tiepie_hw_get_config.argtypes = [c_void_p, c_uint32]
    api.tiepie_hw_get_last_status.restype = c_int32
    api.tiepie_hw_get_last_status.argtypes = []
    api.tiepie_hw_get_last_status_str.restype = c_char_p
    api.tiepie_hw_get_last_status_str.argtypes = []
    api.tiepie_hw_devicelist_update.restype = None
    api.tiepie_hw_devicelist_update.argtypes = []
    api.tiepie_hw_devicelist_get_usb_hotplug_detect_enabled.restype = c_uint8
    api.tiepie_hw_devicelist_get_usb_hotplug_detect_enabled.argtypes = []
    api.tiepie_hw_devicelist_set_usb_hotplug_detect_enabled.restype = c_uint8
    api.tiepie_hw_devicelist_set_usb_hotplug_detect_enabled.argtypes = [c_uint8]
    api.tiepie_hw_devicelist_get_count.restype = c_uint32
    api.tiepie_hw_devicelist_get_count.argtypes = []
    api.tiepie_hw_devicelist_get_item_by_product_id.restype = c_uint32
    api.tiepie_hw_devicelist_get_item_by_product_id.argtypes = [c_int32]
    api.tiepie_hw_devicelist_get_item_by_index.restype = c_uint32
    api.tiepie_hw_devicelist_get_item_by_index.argtypes = [c_uint32]
    api.tiepie_hw_devicelist_get_item_by_serial_number.restype = c_uint32
    api.tiepie_hw_devicelist_get_item_by_serial_number.argtypes = [c_uint32]
    api.tiepie_hw_devicelistitem_open_device.restype = c_uint32
    api.tiepie_hw_devicelistitem_open_device.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_devicelistitem_open_oscilloscope.restype = c_uint32
    api.tiepie_hw_devicelistitem_open_oscilloscope.argtypes = [c_uint32]
    api.tiepie_hw_devicelistitem_open_generator.restype = c_uint32
    api.tiepie_hw_devicelistitem_open_generator.argtypes = [c_uint32]
    api.tiepie_hw_devicelist_get_demo_device_info.restype = c_void_p
    api.tiepie_hw_devicelist_get_demo_device_info.argtypes = []
    api.tiepie_hw_devicelist_create_demo_device.restype = c_uint32
    api.tiepie_hw_devicelist_create_demo_device.argtypes = [c_int32]
    api.tiepie_hw_devicelist_create_combined_device.restype = c_uint32
    api.tiepie_hw_devicelist_create_combined_device.argtypes = [c_void_p, c_uint32]
    api.tiepie_hw_devicelist_create_and_open_combined_device.restype = c_uint32
    api.tiepie_hw_devicelist_create_and_open_combined_device.argtypes = [c_void_p, c_uint32]
    api.tiepie_hw_devicelist_remove_device.restype = None
    api.tiepie_hw_devicelist_remove_device.argtypes = [c_uint32, c_uint8]
    api.tiepie_hw_devicelist_remove_unused_devices.restype = None
    api.tiepie_hw_devicelist_remove_unused_devices.argtypes = []
    api.tiepie_hw_devicelistitem_is_demo.restype = c_uint8
    api.tiepie_hw_devicelistitem_is_demo.argtypes = [c_uint32]
    api.tiepie_hw_devicelistitem_can_open.restype = c_uint8
    api.tiepie_hw_devicelistitem_can_open.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_devicelistitem_opened_by.restype = c_uint32
    api.tiepie_hw_devicelistitem_opened_by.argtypes = [c_uint32, c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_devicelistitem_get_product_id.restype = c_int32
    api.tiepie_hw_devicelistitem_get_product_id.argtypes = [c_uint32]
    api.tiepie_hw_devicelistitem_get_name.restype = c_uint32
    api.tiepie_hw_devicelistitem_get_name.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_devicelistitem_get_name_short.restype = c_uint32
    api.tiepie_hw_devicelistitem_get_name_short.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_devicelistitem_get_name_shortest.restype = c_uint32
    api.tiepie_hw_devicelistitem_get_name_shortest.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_devicelistitem_get_calibration_date.restype = tiepie_hw_date
    api.tiepie_hw_devicelistitem_get_calibration_date.argtypes = [c_uint32]
    api.tiepie_hw_devicelistitem_get_serial_number.restype = c_uint32
    api.tiepie_hw_devicelistitem_get_serial_number.argtypes = [c_uint32]
    api.tiepie_hw_devicelistitem_get_ip_address.restype = c_uint32
    api.tiepie_hw_devicelistitem_get_ip_address.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_devicelistitem_get_ip_port.restype = c_uint16
    api.tiepie_hw_devicelistitem_get_ip_port.argtypes = [c_uint32]
    api.tiepie_hw_devicelistitem_has_server.restype = c_uint8
    api.tiepie_hw_devicelistitem_has_server.argtypes = [c_uint32]
    api.tiepie_hw_devicelistitem_get_server.restype = c_uint32
    api.tiepie_hw_devicelistitem_get_server.argtypes = [c_uint32]
    api.tiepie_hw_devicelistitem_get_types.restype = c_uint32
    api.tiepie_hw_devicelistitem_get_types.argtypes = [c_uint32]
    api.tiepie_hw_devicelistitem_get_contained_serial_numbers.restype = c_uint32
    api.tiepie_hw_devicelistitem_get_contained_serial_numbers.argtypes = [c_uint32, c_void_p, c_uint32]
    api.tiepie_hw_devicelistitemcombined_get_product_id.restype = c_int32
    api.tiepie_hw_devicelistitemcombined_get_product_id.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_devicelistitemcombined_get_name.restype = c_uint32
    api.tiepie_hw_devicelistitemcombined_get_name.argtypes = [c_uint32, c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_devicelistitemcombined_get_name_short.restype = c_uint32
    api.tiepie_hw_devicelistitemcombined_get_name_short.argtypes = [c_uint32, c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_devicelistitemcombined_get_name_shortest.restype = c_uint32
    api.tiepie_hw_devicelistitemcombined_get_name_shortest.argtypes = [c_uint32, c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_devicelistitemcombined_get_calibration_date.restype = tiepie_hw_date
    api.tiepie_hw_devicelistitemcombined_get_calibration_date.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_devicelistitemcombined_get_oscilloscope_channel_count.restype = c_uint16
    api.tiepie_hw_devicelistitemcombined_get_oscilloscope_channel_count.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_network_get_auto_detect_enabled.restype = c_uint8
    api.tiepie_hw_network_get_auto_detect_enabled.argtypes = []
    api.tiepie_hw_network_set_auto_detect_enabled.restype = c_uint8
    api.tiepie_hw_network_set_auto_detect_enabled.argtypes = [c_uint8]
    api.tiepie_hw_network_servers_add.restype = c_uint8
    api.tiepie_hw_network_servers_add.argtypes = [c_char_p, c_uint32, c_void_p]
    api.tiepie_hw_network_servers_remove.restype = c_uint8
    api.tiepie_hw_network_servers_remove.argtypes = [c_char_p, c_uint32, c_uint8]
    api.tiepie_hw_network_servers_get_count.restype = c_uint32
    api.tiepie_hw_network_servers_get_count.argtypes = []
    api.tiepie_hw_network_servers_get_by_index.restype = c_uint32
    api.tiepie_hw_network_servers_get_by_index.argtypes = [c_uint32]
    api.tiepie_hw_network_servers_get_by_url.restype = c_uint32
    api.tiepie_hw_network_servers_get_by_url.argtypes = [c_char_p, c_uint32]
    api.tiepie_hw_object_close.restype = None
    api.tiepie_hw_object_close.argtypes = [c_uint32]
    api.tiepie_hw_object_is_removed.restype = c_uint8
    api.tiepie_hw_object_is_removed.argtypes = [c_uint32]
    api.tiepie_hw_object_get_interfaces.restype = c_uint64
    api.tiepie_hw_object_get_interfaces.argtypes = [c_uint32]
    api.tiepie_hw_device_get_calibration_date.restype = tiepie_hw_date
    api.tiepie_hw_device_get_calibration_date.argtypes = [c_uint32]
    api.tiepie_hw_device_get_serial_number.restype = c_uint32
    api.tiepie_hw_device_get_serial_number.argtypes = [c_uint32]
    api.tiepie_hw_device_get_ip_address.restype = c_uint32
    api.tiepie_hw_device_get_ip_address.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_device_get_ip_port.restype = c_uint16
    api.tiepie_hw_device_get_ip_port.argtypes = [c_uint32]
    api.tiepie_hw_device_get_product_id.restype = c_int32
    api.tiepie_hw_device_get_product_id.argtypes = [c_uint32]
    api.tiepie_hw_device_get_type.restype = c_uint32
    api.tiepie_hw_device_get_type.argtypes = [c_uint32]
    api.tiepie_hw_device_get_name.restype = c_uint32
    api.tiepie_hw_device_get_name.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_device_get_name_short.restype = c_uint32
    api.tiepie_hw_device_get_name_short.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_device_get_name_shortest.restype = c_uint32
    api.tiepie_hw_device_get_name_shortest.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_device_has_wireless_trigger_module.restype = c_uint8
    api.tiepie_hw_device_has_wireless_trigger_module.argtypes = [c_uint32]
    api.tiepie_hw_device_has_battery.restype = c_uint8
    api.tiepie_hw_device_has_battery.argtypes = [c_uint32]
    api.tiepie_hw_device_has_battery_ex.restype = c_uint8
    api.tiepie_hw_device_has_battery_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_device_get_battery_charge.restype = c_int8
    api.tiepie_hw_device_get_battery_charge.argtypes = [c_uint32]
    api.tiepie_hw_device_get_battery_charge_ex.restype = c_int8
    api.tiepie_hw_device_get_battery_charge_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_device_get_battery_time_to_empty.restype = c_int32
    api.tiepie_hw_device_get_battery_time_to_empty.argtypes = [c_uint32]
    api.tiepie_hw_device_get_battery_time_to_empty_ex.restype = c_int32
    api.tiepie_hw_device_get_battery_time_to_empty_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_device_get_battery_time_to_full.restype = c_int32
    api.tiepie_hw_device_get_battery_time_to_full.argtypes = [c_uint32]
    api.tiepie_hw_device_get_battery_time_to_full_ex.restype = c_int32
    api.tiepie_hw_device_get_battery_time_to_full_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_device_is_battery_charger_connected.restype = c_uint8
    api.tiepie_hw_device_is_battery_charger_connected.argtypes = [c_uint32]
    api.tiepie_hw_device_is_battery_charger_connected_ex.restype = c_uint8
    api.tiepie_hw_device_is_battery_charger_connected_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_device_is_battery_charging.restype = c_uint8
    api.tiepie_hw_device_is_battery_charging.argtypes = [c_uint32]
    api.tiepie_hw_device_is_battery_charging_ex.restype = c_uint8
    api.tiepie_hw_device_is_battery_charging_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_device_is_battery_broken.restype = c_uint8
    api.tiepie_hw_device_is_battery_broken.argtypes = [c_uint32]
    api.tiepie_hw_device_is_battery_broken_ex.restype = c_uint8
    api.tiepie_hw_device_is_battery_broken_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_device_trigger_get_input_count.restype = c_uint16
    api.tiepie_hw_device_trigger_get_input_count.argtypes = [c_uint32]
    api.tiepie_hw_device_trigger_get_input_index_by_id.restype = c_uint16
    api.tiepie_hw_device_trigger_get_input_index_by_id.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_oscilloscope_trigger_input_is_triggered.restype = c_uint8
    api.tiepie_hw_oscilloscope_trigger_input_is_triggered.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_device_trigger_input_get_enabled.restype = c_uint8
    api.tiepie_hw_device_trigger_input_get_enabled.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_device_trigger_input_set_enabled.restype = c_uint8
    api.tiepie_hw_device_trigger_input_set_enabled.argtypes = [c_uint32, c_uint16, c_uint8]
    api.tiepie_hw_device_trigger_input_get_kinds.restype = c_uint64
    api.tiepie_hw_device_trigger_input_get_kinds.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_trigger_input_get_kinds_ex.restype = c_uint64
    api.tiepie_hw_oscilloscope_trigger_input_get_kinds_ex.argtypes = [c_uint32, c_uint16, c_uint32]
    api.tiepie_hw_device_trigger_input_get_kind.restype = c_uint64
    api.tiepie_hw_device_trigger_input_get_kind.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_device_trigger_input_set_kind.restype = c_uint64
    api.tiepie_hw_device_trigger_input_set_kind.argtypes = [c_uint32, c_uint16, c_uint64]
    api.tiepie_hw_device_trigger_input_is_available.restype = c_uint8
    api.tiepie_hw_device_trigger_input_is_available.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_trigger_input_is_available_ex.restype = c_uint8
    api.tiepie_hw_oscilloscope_trigger_input_is_available_ex.argtypes = [c_uint32, c_uint16, c_uint32]
    api.tiepie_hw_device_trigger_input_get_id.restype = c_uint32
    api.tiepie_hw_device_trigger_input_get_id.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_device_trigger_input_get_name.restype = c_uint32
    api.tiepie_hw_device_trigger_input_get_name.argtypes = [c_uint32, c_uint16, c_char_p, c_uint32]
    api.tiepie_hw_device_trigger_get_output_count.restype = c_uint16
    api.tiepie_hw_device_trigger_get_output_count.argtypes = [c_uint32]
    api.tiepie_hw_device_trigger_get_output_index_by_id.restype = c_uint16
    api.tiepie_hw_device_trigger_get_output_index_by_id.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_device_trigger_output_get_enabled.restype = c_uint8
    api.tiepie_hw_device_trigger_output_get_enabled.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_device_trigger_output_set_enabled.restype = c_uint8
    api.tiepie_hw_device_trigger_output_set_enabled.argtypes = [c_uint32, c_uint16, c_uint8]
    api.tiepie_hw_device_trigger_output_get_events.restype = c_uint64
    api.tiepie_hw_device_trigger_output_get_events.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_device_trigger_output_get_event.restype = c_uint64
    api.tiepie_hw_device_trigger_output_get_event.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_device_trigger_output_set_event.restype = c_uint64
    api.tiepie_hw_device_trigger_output_set_event.argtypes = [c_uint32, c_uint16, c_uint64]
    api.tiepie_hw_device_trigger_output_get_id.restype = c_uint32
    api.tiepie_hw_device_trigger_output_get_id.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_device_trigger_output_get_name.restype = c_uint32
    api.tiepie_hw_device_trigger_output_get_name.argtypes = [c_uint32, c_uint16, c_char_p, c_uint32]
    api.tiepie_hw_device_trigger_output_trigger.restype = c_uint8
    api.tiepie_hw_device_trigger_output_trigger.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_get_channel_count.restype = c_uint16
    api.tiepie_hw_oscilloscope_get_channel_count.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_channel_is_available.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_is_available.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_is_available_ex.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_is_available_ex.argtypes = [c_uint32, c_uint16, c_uint32, c_double, c_uint8, c_void_p, c_uint16]
    api.tiepie_hw_oscilloscope_channel_get_connector_type.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_get_connector_type.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_is_differential.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_is_differential.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_is_isolated.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_is_isolated.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_get_impedance.restype = c_double
    api.tiepie_hw_oscilloscope_channel_get_impedance.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_get_bandwidths.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_get_bandwidths.argtypes = [c_uint32, c_uint16, c_void_p, c_uint32]
    api.tiepie_hw_oscilloscope_channel_get_bandwidth.restype = c_double
    api.tiepie_hw_oscilloscope_channel_get_bandwidth.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_set_bandwidth.restype = c_double
    api.tiepie_hw_oscilloscope_channel_set_bandwidth.argtypes = [c_uint32, c_uint16, c_double]
    api.tiepie_hw_oscilloscope_channel_get_couplings.restype = c_uint64
    api.tiepie_hw_oscilloscope_channel_get_couplings.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_get_coupling.restype = c_uint64
    api.tiepie_hw_oscilloscope_channel_get_coupling.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_set_coupling.restype = c_uint64
    api.tiepie_hw_oscilloscope_channel_set_coupling.argtypes = [c_uint32, c_uint16, c_uint64]
    api.tiepie_hw_oscilloscope_channel_get_enabled.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_get_enabled.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_set_enabled.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_set_enabled.argtypes = [c_uint32, c_uint16, c_uint8]
    api.tiepie_hw_oscilloscope_channel_get_auto_ranging.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_get_auto_ranging.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_set_auto_ranging.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_set_auto_ranging.argtypes = [c_uint32, c_uint16, c_uint8]
    api.tiepie_hw_oscilloscope_channel_get_ranges.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_get_ranges.argtypes = [c_uint32, c_uint16, c_void_p, c_uint32]
    api.tiepie_hw_oscilloscope_channel_get_ranges_ex.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_get_ranges_ex.argtypes = [c_uint32, c_uint16, c_uint64, c_void_p, c_uint32]
    api.tiepie_hw_oscilloscope_channel_get_range.restype = c_double
    api.tiepie_hw_oscilloscope_channel_get_range.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_set_range.restype = c_double
    api.tiepie_hw_oscilloscope_channel_set_range.argtypes = [c_uint32, c_uint16, c_double]
    api.tiepie_hw_oscilloscope_channel_has_safeground.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_has_safeground.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_get_safeground_enabled.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_get_safeground_enabled.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_set_safeground_enabled.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_set_safeground_enabled.argtypes = [c_uint32, c_uint16, c_uint8]
    api.tiepie_hw_oscilloscope_channel_get_safeground_threshold_min.restype = c_double
    api.tiepie_hw_oscilloscope_channel_get_safeground_threshold_min.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_get_safeground_threshold_max.restype = c_double
    api.tiepie_hw_oscilloscope_channel_get_safeground_threshold_max.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_get_safeground_threshold.restype = c_double
    api.tiepie_hw_oscilloscope_channel_get_safeground_threshold.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_set_safeground_threshold.restype = c_double
    api.tiepie_hw_oscilloscope_channel_set_safeground_threshold.argtypes = [c_uint32, c_uint16, c_double]
    api.tiepie_hw_oscilloscope_channel_verify_safeground_threshold.restype = c_double
    api.tiepie_hw_oscilloscope_channel_verify_safeground_threshold.argtypes = [c_uint32, c_uint16, c_double]
    api.tiepie_hw_oscilloscope_channel_has_trigger.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_has_trigger.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_has_trigger_ex.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_has_trigger_ex.argtypes = [c_uint32, c_uint16, c_uint32]
    api.tiepie_hw_oscilloscope_channel_trigger_is_available.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_trigger_is_available.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_is_available_ex.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_trigger_is_available_ex.argtypes = [c_uint32, c_uint16, c_uint32, c_double, c_uint8, c_void_p, c_void_p, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_is_triggered.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_trigger_is_triggered.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_get_enabled.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_trigger_get_enabled.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_set_enabled.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_trigger_set_enabled.argtypes = [c_uint32, c_uint16, c_uint8]
    api.tiepie_hw_oscilloscope_channel_trigger_get_kinds.restype = c_uint64
    api.tiepie_hw_oscilloscope_channel_trigger_get_kinds.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_get_kinds_ex.restype = c_uint64
    api.tiepie_hw_oscilloscope_channel_trigger_get_kinds_ex.argtypes = [c_uint32, c_uint16, c_uint32]
    api.tiepie_hw_oscilloscope_channel_trigger_get_kind.restype = c_uint64
    api.tiepie_hw_oscilloscope_channel_trigger_get_kind.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_set_kind.restype = c_uint64
    api.tiepie_hw_oscilloscope_channel_trigger_set_kind.argtypes = [c_uint32, c_uint16, c_uint64]
    api.tiepie_hw_oscilloscope_channel_trigger_get_level_modes.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_trigger_get_level_modes.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_get_level_mode.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_trigger_get_level_mode.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_set_level_mode.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_trigger_set_level_mode.argtypes = [c_uint32, c_uint16, c_uint32]
    api.tiepie_hw_oscilloscope_channel_trigger_get_level_count.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_trigger_get_level_count.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_get_level.restype = c_double
    api.tiepie_hw_oscilloscope_channel_trigger_get_level.argtypes = [c_uint32, c_uint16, c_uint32]
    api.tiepie_hw_oscilloscope_channel_trigger_set_level.restype = c_double
    api.tiepie_hw_oscilloscope_channel_trigger_set_level.argtypes = [c_uint32, c_uint16, c_uint32, c_double]
    api.tiepie_hw_oscilloscope_channel_trigger_get_hysteresis_count.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_trigger_get_hysteresis_count.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_get_hysteresis.restype = c_double
    api.tiepie_hw_oscilloscope_channel_trigger_get_hysteresis.argtypes = [c_uint32, c_uint16, c_uint32]
    api.tiepie_hw_oscilloscope_channel_trigger_set_hysteresis.restype = c_double
    api.tiepie_hw_oscilloscope_channel_trigger_set_hysteresis.argtypes = [c_uint32, c_uint16, c_uint32, c_double]
    api.tiepie_hw_oscilloscope_channel_trigger_get_conditions.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_trigger_get_conditions.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_get_conditions_ex.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_trigger_get_conditions_ex.argtypes = [c_uint32, c_uint16, c_uint32, c_uint64]
    api.tiepie_hw_oscilloscope_channel_trigger_get_condition.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_trigger_get_condition.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_set_condition.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_trigger_set_condition.argtypes = [c_uint32, c_uint16, c_uint32]
    api.tiepie_hw_oscilloscope_channel_trigger_get_time_count.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_trigger_get_time_count.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_trigger_get_time.restype = c_double
    api.tiepie_hw_oscilloscope_channel_trigger_get_time.argtypes = [c_uint32, c_uint16, c_uint32]
    api.tiepie_hw_oscilloscope_channel_trigger_set_time.restype = c_double
    api.tiepie_hw_oscilloscope_channel_trigger_set_time.argtypes = [c_uint32, c_uint16, c_uint32, c_double]
    api.tiepie_hw_oscilloscope_channel_trigger_verify_time.restype = c_double
    api.tiepie_hw_oscilloscope_channel_trigger_verify_time.argtypes = [c_uint32, c_uint16, c_uint32, c_double]
    api.tiepie_hw_oscilloscope_channel_trigger_verify_time_ex.restype = c_double
    api.tiepie_hw_oscilloscope_channel_trigger_verify_time_ex.argtypes = [c_uint32, c_uint16, c_uint32, c_double, c_uint32, c_double, c_uint64, c_uint32]
    api.tiepie_hw_oscilloscope_is_demo.restype = c_uint8
    api.tiepie_hw_oscilloscope_is_demo.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_channel_demo_get_signal.restype = c_int32
    api.tiepie_hw_oscilloscope_channel_demo_get_signal.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_set_signal.restype = c_int32
    api.tiepie_hw_oscilloscope_channel_demo_set_signal.argtypes = [c_uint32, c_uint16, c_int32]
    api.tiepie_hw_oscilloscope_channel_demo_has_amplitude.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_demo_has_amplitude.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_get_amplitude.restype = c_double
    api.tiepie_hw_oscilloscope_channel_demo_get_amplitude.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_set_amplitude.restype = c_double
    api.tiepie_hw_oscilloscope_channel_demo_set_amplitude.argtypes = [c_uint32, c_uint16, c_double]
    api.tiepie_hw_oscilloscope_channel_demo_has_frequency.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_demo_has_frequency.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_get_frequency.restype = c_double
    api.tiepie_hw_oscilloscope_channel_demo_get_frequency.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_set_frequency.restype = c_double
    api.tiepie_hw_oscilloscope_channel_demo_set_frequency.argtypes = [c_uint32, c_uint16, c_double]
    api.tiepie_hw_oscilloscope_channel_demo_has_offset.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_demo_has_offset.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_get_offset.restype = c_double
    api.tiepie_hw_oscilloscope_channel_demo_get_offset.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_set_offset.restype = c_double
    api.tiepie_hw_oscilloscope_channel_demo_set_offset.argtypes = [c_uint32, c_uint16, c_double]
    api.tiepie_hw_oscilloscope_channel_demo_has_symmetry.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_demo_has_symmetry.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_get_symmetry.restype = c_double
    api.tiepie_hw_oscilloscope_channel_demo_get_symmetry.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_set_symmetry.restype = c_double
    api.tiepie_hw_oscilloscope_channel_demo_set_symmetry.argtypes = [c_uint32, c_uint16, c_double]
    api.tiepie_hw_oscilloscope_channel_demo_has_phase.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_demo_has_phase.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_get_phase.restype = c_double
    api.tiepie_hw_oscilloscope_channel_demo_get_phase.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_set_phase.restype = c_double
    api.tiepie_hw_oscilloscope_channel_demo_set_phase.argtypes = [c_uint32, c_uint16, c_double]
    api.tiepie_hw_oscilloscope_channel_demo_has_noise_enabled.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_demo_has_noise_enabled.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_get_noise_enabled.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_demo_get_noise_enabled.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_demo_set_noise_enabled.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_demo_set_noise_enabled.argtypes = [c_uint32, c_uint16, c_uint8]
    api.tiepie_hw_oscilloscope_get_data.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data.argtypes = [c_uint32, c_void_p, c_uint16, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_1ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_1ch.argtypes = [c_uint32, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_2ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_2ch.argtypes = [c_uint32, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_3ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_3ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_4ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_4ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_5ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_5ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_6ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_6ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_7ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_7ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_8ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_8ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_valid_pre_sample_count.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_valid_pre_sample_count.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_channel_get_data_value_range.restype = None
    api.tiepie_hw_oscilloscope_channel_get_data_value_range.argtypes = [c_uint32, c_uint16, c_void_p, c_void_p]
    api.tiepie_hw_oscilloscope_channel_get_data_value_min.restype = c_double
    api.tiepie_hw_oscilloscope_channel_get_data_value_min.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_get_data_value_max.restype = c_double
    api.tiepie_hw_oscilloscope_channel_get_data_value_max.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_get_data_raw.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_raw.argtypes = [c_uint32, c_void_p, c_uint16, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_raw_1ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_raw_1ch.argtypes = [c_uint32, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_raw_2ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_raw_2ch.argtypes = [c_uint32, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_raw_3ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_raw_3ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_raw_4ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_raw_4ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_raw_5ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_raw_5ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_raw_6ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_raw_6ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_raw_7ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_raw_7ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_get_data_raw_8ch.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_data_raw_8ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.tiepie_hw_oscilloscope_channel_get_data_raw_type.restype = c_uint32
    api.tiepie_hw_oscilloscope_channel_get_data_raw_type.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_get_data_raw_value_range.restype = None
    api.tiepie_hw_oscilloscope_channel_get_data_raw_value_range.argtypes = [c_uint32, c_uint16, c_void_p, c_void_p, c_void_p]
    api.tiepie_hw_oscilloscope_channel_get_data_raw_value_min.restype = c_int64
    api.tiepie_hw_oscilloscope_channel_get_data_raw_value_min.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_get_data_raw_value_zero.restype = c_int64
    api.tiepie_hw_oscilloscope_channel_get_data_raw_value_zero.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_get_data_raw_value_max.restype = c_int64
    api.tiepie_hw_oscilloscope_channel_get_data_raw_value_max.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_channel_is_range_max_reachable.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_is_range_max_reachable.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_start.restype = c_uint8
    api.tiepie_hw_oscilloscope_start.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_stop.restype = c_uint8
    api.tiepie_hw_oscilloscope_stop.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_force_trigger.restype = c_uint8
    api.tiepie_hw_oscilloscope_force_trigger.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_get_measure_modes.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_measure_modes.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_get_measure_mode.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_measure_mode.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_measure_mode.restype = c_uint32
    api.tiepie_hw_oscilloscope_set_measure_mode.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_oscilloscope_is_running.restype = c_uint8
    api.tiepie_hw_oscilloscope_is_running.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_is_triggered.restype = c_uint8
    api.tiepie_hw_oscilloscope_is_triggered.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_is_timeout_triggered.restype = c_uint8
    api.tiepie_hw_oscilloscope_is_timeout_triggered.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_is_force_triggered.restype = c_uint8
    api.tiepie_hw_oscilloscope_is_force_triggered.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_is_data_ready.restype = c_uint8
    api.tiepie_hw_oscilloscope_is_data_ready.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_is_data_overflow.restype = c_uint8
    api.tiepie_hw_oscilloscope_is_data_overflow.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_get_auto_resolution_modes.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_auto_resolution_modes.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_get_auto_resolution_mode.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_auto_resolution_mode.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_auto_resolution_mode.restype = c_uint32
    api.tiepie_hw_oscilloscope_set_auto_resolution_mode.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_oscilloscope_get_resolutions.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_resolutions.argtypes = [c_uint32, c_void_p, c_uint32]
    api.tiepie_hw_oscilloscope_get_resolution.restype = c_uint8
    api.tiepie_hw_oscilloscope_get_resolution.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_resolution.restype = c_uint8
    api.tiepie_hw_oscilloscope_set_resolution.argtypes = [c_uint32, c_uint8]
    api.tiepie_hw_oscilloscope_is_resolution_enhanced.restype = c_uint8
    api.tiepie_hw_oscilloscope_is_resolution_enhanced.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_is_resolution_enhanced_ex.restype = c_uint8
    api.tiepie_hw_oscilloscope_is_resolution_enhanced_ex.argtypes = [c_uint32, c_uint8]
    api.tiepie_hw_oscilloscope_get_clock_sources.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_clock_sources.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_get_clock_source.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_clock_source.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_clock_source.restype = c_uint32
    api.tiepie_hw_oscilloscope_set_clock_source.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_oscilloscope_get_clock_source_frequencies.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_clock_source_frequencies.argtypes = [c_uint32, c_void_p, c_uint32]
    api.tiepie_hw_oscilloscope_get_clock_source_frequencies_ex.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_clock_source_frequencies_ex.argtypes = [c_uint32, c_uint32, c_void_p, c_uint32]
    api.tiepie_hw_oscilloscope_get_clock_source_frequency.restype = c_double
    api.tiepie_hw_oscilloscope_get_clock_source_frequency.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_clock_source_frequency.restype = c_double
    api.tiepie_hw_oscilloscope_set_clock_source_frequency.argtypes = [c_uint32, c_double]
    api.tiepie_hw_oscilloscope_get_clock_outputs.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_clock_outputs.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_get_clock_output.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_clock_output.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_clock_output.restype = c_uint32
    api.tiepie_hw_oscilloscope_set_clock_output.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_oscilloscope_get_clock_output_frequencies.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_clock_output_frequencies.argtypes = [c_uint32, c_void_p, c_uint32]
    api.tiepie_hw_oscilloscope_get_clock_output_frequencies_ex.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_clock_output_frequencies_ex.argtypes = [c_uint32, c_uint32, c_void_p, c_uint32]
    api.tiepie_hw_oscilloscope_get_clock_output_frequency.restype = c_double
    api.tiepie_hw_oscilloscope_get_clock_output_frequency.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_clock_output_frequency.restype = c_double
    api.tiepie_hw_oscilloscope_set_clock_output_frequency.argtypes = [c_uint32, c_double]
    api.tiepie_hw_oscilloscope_get_sample_rate_max.restype = c_double
    api.tiepie_hw_oscilloscope_get_sample_rate_max.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_get_sample_rate.restype = c_double
    api.tiepie_hw_oscilloscope_get_sample_rate.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_sample_rate.restype = c_double
    api.tiepie_hw_oscilloscope_set_sample_rate.argtypes = [c_uint32, c_double]
    api.tiepie_hw_oscilloscope_verify_sample_rate.restype = c_double
    api.tiepie_hw_oscilloscope_verify_sample_rate.argtypes = [c_uint32, c_double]
    api.tiepie_hw_oscilloscope_verify_sample_rate_ex.restype = c_double
    api.tiepie_hw_oscilloscope_verify_sample_rate_ex.argtypes = [c_uint32, c_double, c_uint32, c_uint8, c_void_p, c_uint16]
    api.tiepie_hw_oscilloscope_verify_sample_rates_ex.restype = None
    api.tiepie_hw_oscilloscope_verify_sample_rates_ex.argtypes = [c_uint32, c_void_p, c_uint32, c_uint32, c_uint32, c_uint8, c_void_p, c_uint16]
    api.tiepie_hw_oscilloscope_get_record_length_max.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_record_length_max.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_get_record_length_max_ex.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_record_length_max_ex.argtypes = [c_uint32, c_uint32, c_uint8]
    api.tiepie_hw_oscilloscope_get_record_length.restype = c_uint64
    api.tiepie_hw_oscilloscope_get_record_length.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_record_length.restype = c_uint64
    api.tiepie_hw_oscilloscope_set_record_length.argtypes = [c_uint32, c_uint64]
    api.tiepie_hw_oscilloscope_verify_record_length.restype = c_uint64
    api.tiepie_hw_oscilloscope_verify_record_length.argtypes = [c_uint32, c_uint64]
    api.tiepie_hw_oscilloscope_verify_record_length_ex.restype = c_uint64
    api.tiepie_hw_oscilloscope_verify_record_length_ex.argtypes = [c_uint32, c_uint64, c_uint32, c_uint8, c_void_p, c_uint16]
    api.tiepie_hw_oscilloscope_get_pre_sample_ratio.restype = c_double
    api.tiepie_hw_oscilloscope_get_pre_sample_ratio.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_pre_sample_ratio.restype = c_double
    api.tiepie_hw_oscilloscope_set_pre_sample_ratio.argtypes = [c_uint32, c_double]
    api.tiepie_hw_oscilloscope_get_segment_count_max.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_segment_count_max.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_get_segment_count_max_ex.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_segment_count_max_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_oscilloscope_get_segment_count.restype = c_uint32
    api.tiepie_hw_oscilloscope_get_segment_count.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_segment_count.restype = c_uint32
    api.tiepie_hw_oscilloscope_set_segment_count.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_oscilloscope_verify_segment_count.restype = c_uint32
    api.tiepie_hw_oscilloscope_verify_segment_count.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_oscilloscope_verify_segment_count_ex.restype = c_uint32
    api.tiepie_hw_oscilloscope_verify_segment_count_ex.argtypes = [c_uint32, c_uint32, c_uint32, c_uint64, c_void_p, c_uint16]
    api.tiepie_hw_oscilloscope_has_trigger.restype = c_uint8
    api.tiepie_hw_oscilloscope_has_trigger.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_has_trigger_ex.restype = c_uint8
    api.tiepie_hw_oscilloscope_has_trigger_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_oscilloscope_trigger_get_timeout.restype = c_double
    api.tiepie_hw_oscilloscope_trigger_get_timeout.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_trigger_set_timeout.restype = c_double
    api.tiepie_hw_oscilloscope_trigger_set_timeout.argtypes = [c_uint32, c_double]
    api.tiepie_hw_oscilloscope_trigger_verify_timeout.restype = c_double
    api.tiepie_hw_oscilloscope_trigger_verify_timeout.argtypes = [c_uint32, c_double]
    api.tiepie_hw_oscilloscope_trigger_verify_timeout_ex.restype = c_double
    api.tiepie_hw_oscilloscope_trigger_verify_timeout_ex.argtypes = [c_uint32, c_double, c_uint32, c_double]
    api.tiepie_hw_oscilloscope_trigger_has_delay.restype = c_uint8
    api.tiepie_hw_oscilloscope_trigger_has_delay.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_trigger_has_delay_ex.restype = c_uint8
    api.tiepie_hw_oscilloscope_trigger_has_delay_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_oscilloscope_trigger_get_delay_max.restype = c_double
    api.tiepie_hw_oscilloscope_trigger_get_delay_max.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_trigger_get_delay_max_ex.restype = c_double
    api.tiepie_hw_oscilloscope_trigger_get_delay_max_ex.argtypes = [c_uint32, c_uint32, c_double]
    api.tiepie_hw_oscilloscope_trigger_get_delay.restype = c_double
    api.tiepie_hw_oscilloscope_trigger_get_delay.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_trigger_set_delay.restype = c_double
    api.tiepie_hw_oscilloscope_trigger_set_delay.argtypes = [c_uint32, c_double]
    api.tiepie_hw_oscilloscope_trigger_verify_delay.restype = c_double
    api.tiepie_hw_oscilloscope_trigger_verify_delay.argtypes = [c_uint32, c_double]
    api.tiepie_hw_oscilloscope_trigger_verify_delay_ex.restype = c_double
    api.tiepie_hw_oscilloscope_trigger_verify_delay_ex.argtypes = [c_uint32, c_double, c_uint32, c_double]
    api.tiepie_hw_oscilloscope_has_presamples_valid.restype = c_uint8
    api.tiepie_hw_oscilloscope_has_presamples_valid.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_has_presamples_valid_ex.restype = c_uint8
    api.tiepie_hw_oscilloscope_has_presamples_valid_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_oscilloscope_get_presamples_valid.restype = c_uint8
    api.tiepie_hw_oscilloscope_get_presamples_valid.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_set_presamples_valid.restype = c_uint8
    api.tiepie_hw_oscilloscope_set_presamples_valid.argtypes = [c_uint32, c_uint8]
    api.tiepie_hw_oscilloscope_has_sureconnect.restype = c_uint8
    api.tiepie_hw_oscilloscope_has_sureconnect.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_channel_has_sureconnect.restype = c_uint8
    api.tiepie_hw_oscilloscope_channel_has_sureconnect.argtypes = [c_uint32, c_uint16]
    api.tiepie_hw_oscilloscope_start_sureconnect.restype = c_uint8
    api.tiepie_hw_oscilloscope_start_sureconnect.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_start_sureconnect_ex.restype = c_uint8
    api.tiepie_hw_oscilloscope_start_sureconnect_ex.argtypes = [c_uint32, c_void_p, c_uint16]
    api.tiepie_hw_oscilloscope_is_sureconnect_completed.restype = c_uint8
    api.tiepie_hw_oscilloscope_is_sureconnect_completed.argtypes = [c_uint32]
    api.tiepie_hw_oscilloscope_get_sureconnect_data.restype = c_uint16
    api.tiepie_hw_oscilloscope_get_sureconnect_data.argtypes = [c_uint32, c_void_p, c_uint16]
    api.tiepie_hw_generator_get_connector_type.restype = c_uint32
    api.tiepie_hw_generator_get_connector_type.argtypes = [c_uint32]
    api.tiepie_hw_generator_is_differential.restype = c_uint8
    api.tiepie_hw_generator_is_differential.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_impedance.restype = c_double
    api.tiepie_hw_generator_get_impedance.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_resolution.restype = c_uint8
    api.tiepie_hw_generator_get_resolution.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_output_value_min.restype = c_double
    api.tiepie_hw_generator_get_output_value_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_output_value_max.restype = c_double
    api.tiepie_hw_generator_get_output_value_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_output_value_min_max.restype = None
    api.tiepie_hw_generator_get_output_value_min_max.argtypes = [c_uint32, c_void_p, c_void_p]
    api.tiepie_hw_generator_is_controllable.restype = c_uint8
    api.tiepie_hw_generator_is_controllable.argtypes = [c_uint32]
    api.tiepie_hw_generator_is_running.restype = c_uint8
    api.tiepie_hw_generator_is_running.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_status.restype = c_uint32
    api.tiepie_hw_generator_get_status.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_output_enable.restype = c_uint8
    api.tiepie_hw_generator_get_output_enable.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_output_enable.restype = c_uint8
    api.tiepie_hw_generator_set_output_enable.argtypes = [c_uint32, c_uint8]
    api.tiepie_hw_generator_has_output_invert.restype = c_uint8
    api.tiepie_hw_generator_has_output_invert.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_output_invert.restype = c_uint8
    api.tiepie_hw_generator_get_output_invert.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_output_invert.restype = c_uint8
    api.tiepie_hw_generator_set_output_invert.argtypes = [c_uint32, c_uint8]
    api.tiepie_hw_generator_start.restype = c_uint8
    api.tiepie_hw_generator_start.argtypes = [c_uint32]
    api.tiepie_hw_generator_stop.restype = c_uint8
    api.tiepie_hw_generator_stop.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_signal_types.restype = c_uint32
    api.tiepie_hw_generator_get_signal_types.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_signal_type.restype = c_uint32
    api.tiepie_hw_generator_get_signal_type.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_signal_type.restype = c_uint32
    api.tiepie_hw_generator_set_signal_type.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_generator_has_amplitude.restype = c_uint8
    api.tiepie_hw_generator_has_amplitude.argtypes = [c_uint32]
    api.tiepie_hw_generator_has_amplitude_ex.restype = c_uint8
    api.tiepie_hw_generator_has_amplitude_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_generator_get_amplitude_min.restype = c_double
    api.tiepie_hw_generator_get_amplitude_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_amplitude_max.restype = c_double
    api.tiepie_hw_generator_get_amplitude_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_amplitude_min_max_ex.restype = None
    api.tiepie_hw_generator_get_amplitude_min_max_ex.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_amplitude.restype = c_double
    api.tiepie_hw_generator_get_amplitude.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_amplitude.restype = c_double
    api.tiepie_hw_generator_set_amplitude.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_amplitude.restype = c_double
    api.tiepie_hw_generator_verify_amplitude.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_amplitude_ex.restype = c_double
    api.tiepie_hw_generator_verify_amplitude_ex.argtypes = [c_uint32, c_double, c_uint32, c_uint32, c_double, c_uint8]
    api.tiepie_hw_generator_get_amplitude_ranges.restype = c_uint32
    api.tiepie_hw_generator_get_amplitude_ranges.argtypes = [c_uint32, c_void_p, c_uint32]
    api.tiepie_hw_generator_get_amplitude_range.restype = c_double
    api.tiepie_hw_generator_get_amplitude_range.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_amplitude_range.restype = c_double
    api.tiepie_hw_generator_set_amplitude_range.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_get_amplitude_auto_ranging.restype = c_uint8
    api.tiepie_hw_generator_get_amplitude_auto_ranging.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_amplitude_auto_ranging.restype = c_uint8
    api.tiepie_hw_generator_set_amplitude_auto_ranging.argtypes = [c_uint32, c_uint8]
    api.tiepie_hw_generator_has_offset.restype = c_uint8
    api.tiepie_hw_generator_has_offset.argtypes = [c_uint32]
    api.tiepie_hw_generator_has_offset_ex.restype = c_uint8
    api.tiepie_hw_generator_has_offset_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_generator_get_offset_min.restype = c_double
    api.tiepie_hw_generator_get_offset_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_offset_max.restype = c_double
    api.tiepie_hw_generator_get_offset_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_offset_min_max_ex.restype = None
    api.tiepie_hw_generator_get_offset_min_max_ex.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_offset.restype = c_double
    api.tiepie_hw_generator_get_offset.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_offset.restype = c_double
    api.tiepie_hw_generator_set_offset.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_offset.restype = c_double
    api.tiepie_hw_generator_verify_offset.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_offset_ex.restype = c_double
    api.tiepie_hw_generator_verify_offset_ex.argtypes = [c_uint32, c_double, c_uint32, c_double, c_uint8]
    api.tiepie_hw_generator_get_frequency_modes.restype = c_uint32
    api.tiepie_hw_generator_get_frequency_modes.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_frequency_modes_ex.restype = c_uint32
    api.tiepie_hw_generator_get_frequency_modes_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_generator_get_frequency_mode.restype = c_uint32
    api.tiepie_hw_generator_get_frequency_mode.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_frequency_mode.restype = c_uint32
    api.tiepie_hw_generator_set_frequency_mode.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_generator_has_frequency.restype = c_uint8
    api.tiepie_hw_generator_has_frequency.argtypes = [c_uint32]
    api.tiepie_hw_generator_has_frequency_ex.restype = c_uint8
    api.tiepie_hw_generator_has_frequency_ex.argtypes = [c_uint32, c_uint32, c_uint32]
    api.tiepie_hw_generator_get_frequency_min.restype = c_double
    api.tiepie_hw_generator_get_frequency_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_frequency_max.restype = c_double
    api.tiepie_hw_generator_get_frequency_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_frequency_min_max.restype = None
    api.tiepie_hw_generator_get_frequency_min_max.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_frequency_min_max_ex.restype = None
    api.tiepie_hw_generator_get_frequency_min_max_ex.argtypes = [c_uint32, c_uint32, c_uint32, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_frequency.restype = c_double
    api.tiepie_hw_generator_get_frequency.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_frequency.restype = c_double
    api.tiepie_hw_generator_set_frequency.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_frequency.restype = c_double
    api.tiepie_hw_generator_verify_frequency.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_frequency_ex.restype = c_double
    api.tiepie_hw_generator_verify_frequency_ex.argtypes = [c_uint32, c_double, c_uint32, c_uint32, c_uint64, c_double]
    api.tiepie_hw_generator_has_phase.restype = c_uint8
    api.tiepie_hw_generator_has_phase.argtypes = [c_uint32]
    api.tiepie_hw_generator_has_phase_ex.restype = c_uint8
    api.tiepie_hw_generator_has_phase_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_generator_get_phase_min.restype = c_double
    api.tiepie_hw_generator_get_phase_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_phase_max.restype = c_double
    api.tiepie_hw_generator_get_phase_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_phase_min_max_ex.restype = None
    api.tiepie_hw_generator_get_phase_min_max_ex.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_phase.restype = c_double
    api.tiepie_hw_generator_get_phase.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_phase.restype = c_double
    api.tiepie_hw_generator_set_phase.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_phase.restype = c_double
    api.tiepie_hw_generator_verify_phase.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_phase_ex.restype = c_double
    api.tiepie_hw_generator_verify_phase_ex.argtypes = [c_uint32, c_double, c_uint32]
    api.tiepie_hw_generator_has_symmetry.restype = c_uint8
    api.tiepie_hw_generator_has_symmetry.argtypes = [c_uint32]
    api.tiepie_hw_generator_has_symmetry_ex.restype = c_uint8
    api.tiepie_hw_generator_has_symmetry_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_generator_get_symmetry_min.restype = c_double
    api.tiepie_hw_generator_get_symmetry_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_symmetry_max.restype = c_double
    api.tiepie_hw_generator_get_symmetry_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_symmetry_min_max_ex.restype = None
    api.tiepie_hw_generator_get_symmetry_min_max_ex.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_symmetry.restype = c_double
    api.tiepie_hw_generator_get_symmetry.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_symmetry.restype = c_double
    api.tiepie_hw_generator_set_symmetry.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_symmetry.restype = c_double
    api.tiepie_hw_generator_verify_symmetry.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_symmetry_ex.restype = c_double
    api.tiepie_hw_generator_verify_symmetry_ex.argtypes = [c_uint32, c_double, c_uint32]
    api.tiepie_hw_generator_has_width.restype = c_uint8
    api.tiepie_hw_generator_has_width.argtypes = [c_uint32]
    api.tiepie_hw_generator_has_width_ex.restype = c_uint8
    api.tiepie_hw_generator_has_width_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_generator_get_width_min.restype = c_double
    api.tiepie_hw_generator_get_width_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_width_max.restype = c_double
    api.tiepie_hw_generator_get_width_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_width_min_max_ex.restype = None
    api.tiepie_hw_generator_get_width_min_max_ex.argtypes = [c_uint32, c_uint32, c_double, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_width.restype = c_double
    api.tiepie_hw_generator_get_width.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_width.restype = c_double
    api.tiepie_hw_generator_set_width.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_width.restype = c_double
    api.tiepie_hw_generator_verify_width.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_width_ex.restype = c_double
    api.tiepie_hw_generator_verify_width_ex.argtypes = [c_uint32, c_double, c_uint32, c_double]
    api.tiepie_hw_generator_has_edge_time.restype = c_uint8
    api.tiepie_hw_generator_has_edge_time.argtypes = [c_uint32]
    api.tiepie_hw_generator_has_edge_time_ex.restype = c_uint8
    api.tiepie_hw_generator_has_edge_time_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_generator_get_leading_edge_time_min.restype = c_double
    api.tiepie_hw_generator_get_leading_edge_time_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_leading_edge_time_max.restype = c_double
    api.tiepie_hw_generator_get_leading_edge_time_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_leading_edge_time_min_max_ex.restype = None
    api.tiepie_hw_generator_get_leading_edge_time_min_max_ex.argtypes = [c_uint32, c_uint32, c_double, c_double, c_double, c_double, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_leading_edge_time.restype = c_double
    api.tiepie_hw_generator_get_leading_edge_time.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_leading_edge_time.restype = c_double
    api.tiepie_hw_generator_set_leading_edge_time.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_leading_edge_time.restype = c_double
    api.tiepie_hw_generator_verify_leading_edge_time.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_leading_edge_time_ex.restype = c_double
    api.tiepie_hw_generator_verify_leading_edge_time_ex.argtypes = [c_uint32, c_double, c_uint32, c_double, c_double, c_double, c_double]
    api.tiepie_hw_generator_get_trailing_edge_time_min.restype = c_double
    api.tiepie_hw_generator_get_trailing_edge_time_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_trailing_edge_time_max.restype = c_double
    api.tiepie_hw_generator_get_trailing_edge_time_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_trailing_edge_time_min_max_ex.restype = None
    api.tiepie_hw_generator_get_trailing_edge_time_min_max_ex.argtypes = [c_uint32, c_uint32, c_double, c_double, c_double, c_double, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_trailing_edge_time.restype = c_double
    api.tiepie_hw_generator_get_trailing_edge_time.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_trailing_edge_time.restype = c_double
    api.tiepie_hw_generator_set_trailing_edge_time.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_trailing_edge_time.restype = c_double
    api.tiepie_hw_generator_verify_trailing_edge_time.argtypes = [c_uint32, c_double]
    api.tiepie_hw_generator_verify_trailing_edge_time_ex.restype = c_double
    api.tiepie_hw_generator_verify_trailing_edge_time_ex.argtypes = [c_uint32, c_double, c_uint32, c_double, c_double, c_double, c_double]
    api.tiepie_hw_generator_has_data.restype = c_uint8
    api.tiepie_hw_generator_has_data.argtypes = [c_uint32]
    api.tiepie_hw_generator_has_data_ex.restype = c_uint8
    api.tiepie_hw_generator_has_data_ex.argtypes = [c_uint32, c_uint32]
    api.tiepie_hw_generator_get_data_length_min.restype = c_uint64
    api.tiepie_hw_generator_get_data_length_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_data_length_max.restype = c_uint64
    api.tiepie_hw_generator_get_data_length_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_data_length_min_max_ex.restype = None
    api.tiepie_hw_generator_get_data_length_min_max_ex.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_data_length.restype = c_uint64
    api.tiepie_hw_generator_get_data_length.argtypes = [c_uint32]
    api.tiepie_hw_generator_verify_data_length.restype = c_uint64
    api.tiepie_hw_generator_verify_data_length.argtypes = [c_uint32, c_uint64]
    api.tiepie_hw_generator_verify_data_length_ex.restype = c_uint64
    api.tiepie_hw_generator_verify_data_length_ex.argtypes = [c_uint32, c_uint64, c_uint32]
    api.tiepie_hw_generator_set_data.restype = None
    api.tiepie_hw_generator_set_data.argtypes = [c_uint32, c_void_p, c_uint64]
    api.tiepie_hw_generator_set_data_ex.restype = None
    api.tiepie_hw_generator_set_data_ex.argtypes = [c_uint32, c_void_p, c_uint64, c_uint32]
    api.tiepie_hw_generator_get_data_raw_type.restype = c_uint32
    api.tiepie_hw_generator_get_data_raw_type.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_data_raw_value_range.restype = None
    api.tiepie_hw_generator_get_data_raw_value_range.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_data_raw_value_min.restype = c_int64
    api.tiepie_hw_generator_get_data_raw_value_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_data_raw_value_zero.restype = c_int64
    api.tiepie_hw_generator_get_data_raw_value_zero.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_data_raw_value_max.restype = c_int64
    api.tiepie_hw_generator_get_data_raw_value_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_data_raw.restype = None
    api.tiepie_hw_generator_set_data_raw.argtypes = [c_uint32, c_void_p, c_uint64]
    api.tiepie_hw_generator_set_data_raw_ex.restype = None
    api.tiepie_hw_generator_set_data_raw_ex.argtypes = [c_uint32, c_void_p, c_uint64, c_uint32]
    api.tiepie_hw_generator_get_modes.restype = c_uint64
    api.tiepie_hw_generator_get_modes.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_modes_ex.restype = c_uint64
    api.tiepie_hw_generator_get_modes_ex.argtypes = [c_uint32, c_uint32, c_uint32]
    api.tiepie_hw_generator_get_modes_native.restype = c_uint64
    api.tiepie_hw_generator_get_modes_native.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_mode.restype = c_uint64
    api.tiepie_hw_generator_get_mode.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_mode.restype = c_uint64
    api.tiepie_hw_generator_set_mode.argtypes = [c_uint32, c_uint64]
    api.tiepie_hw_generator_is_burst_active.restype = c_uint8
    api.tiepie_hw_generator_is_burst_active.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_burst_count_min.restype = c_uint64
    api.tiepie_hw_generator_get_burst_count_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_burst_count_max.restype = c_uint64
    api.tiepie_hw_generator_get_burst_count_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_burst_count_min_max_ex.restype = None
    api.tiepie_hw_generator_get_burst_count_min_max_ex.argtypes = [c_uint32, c_uint64, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_burst_count.restype = c_uint64
    api.tiepie_hw_generator_get_burst_count.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_burst_count.restype = c_uint64
    api.tiepie_hw_generator_set_burst_count.argtypes = [c_uint32, c_uint64]
    api.tiepie_hw_generator_get_burst_sample_count_min.restype = c_uint64
    api.tiepie_hw_generator_get_burst_sample_count_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_burst_sample_count_max.restype = c_uint64
    api.tiepie_hw_generator_get_burst_sample_count_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_burst_sample_count_min_max_ex.restype = None
    api.tiepie_hw_generator_get_burst_sample_count_min_max_ex.argtypes = [c_uint32, c_uint64, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_burst_sample_count.restype = c_uint64
    api.tiepie_hw_generator_get_burst_sample_count.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_burst_sample_count.restype = c_uint64
    api.tiepie_hw_generator_set_burst_sample_count.argtypes = [c_uint32, c_uint64]
    api.tiepie_hw_generator_get_burst_segment_count_min.restype = c_uint64
    api.tiepie_hw_generator_get_burst_segment_count_min.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_burst_segment_count_max.restype = c_uint64
    api.tiepie_hw_generator_get_burst_segment_count_max.argtypes = [c_uint32]
    api.tiepie_hw_generator_get_burst_segment_count_min_max_ex.restype = None
    api.tiepie_hw_generator_get_burst_segment_count_min_max_ex.argtypes = [c_uint32, c_uint64, c_uint32, c_uint32, c_double, c_uint64, c_void_p, c_void_p]
    api.tiepie_hw_generator_get_burst_segment_count.restype = c_uint64
    api.tiepie_hw_generator_get_burst_segment_count.argtypes = [c_uint32]
    api.tiepie_hw_generator_set_burst_segment_count.restype = c_uint64
    api.tiepie_hw_generator_set_burst_segment_count.argtypes = [c_uint32, c_uint64]
    api.tiepie_hw_generator_verify_burst_segment_count.restype = c_uint64
    api.tiepie_hw_generator_verify_burst_segment_count.argtypes = [c_uint32, c_uint64]
    api.tiepie_hw_generator_verify_burst_segment_count_ex.restype = c_uint64
    api.tiepie_hw_generator_verify_burst_segment_count_ex.argtypes = [c_uint32, c_uint64, c_uint64, c_uint32, c_uint32, c_double, c_uint64]
    api.tiepie_hw_server_connect.restype = c_uint8
    api.tiepie_hw_server_connect.argtypes = [c_uint32, c_uint8]
    api.tiepie_hw_server_disconnect.restype = c_uint8
    api.tiepie_hw_server_disconnect.argtypes = [c_uint32, c_uint8]
    api.tiepie_hw_server_remove.restype = c_uint8
    api.tiepie_hw_server_remove.argtypes = [c_uint32, c_uint8]
    api.tiepie_hw_server_get_status.restype = c_uint32
    api.tiepie_hw_server_get_status.argtypes = [c_uint32]
    api.tiepie_hw_server_get_last_error.restype = c_uint32
    api.tiepie_hw_server_get_last_error.argtypes = [c_uint32]
    api.tiepie_hw_server_get_url.restype = c_uint32
    api.tiepie_hw_server_get_url.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_server_get_id.restype = c_uint32
    api.tiepie_hw_server_get_id.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_server_get_ip_address.restype = c_uint32
    api.tiepie_hw_server_get_ip_address.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_server_get_ip_port.restype = c_uint16
    api.tiepie_hw_server_get_ip_port.argtypes = [c_uint32]
    api.tiepie_hw_server_get_name.restype = c_uint32
    api.tiepie_hw_server_get_name.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_server_get_description.restype = c_uint32
    api.tiepie_hw_server_get_description.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_server_get_version.restype = c_uint32
    api.tiepie_hw_server_get_version.argtypes = [c_uint32, c_char_p, c_uint32]
    api.tiepie_hw_pointerarray_new.restype = c_void_p
    api.tiepie_hw_pointerarray_new.argtypes = [c_uint32]
    api.tiepie_hw_pointerarray_set.restype = None
    api.tiepie_hw_pointerarray_set.argtypes = [c_void_p, c_uint32, c_void_p]
    api.tiepie_hw_pointerarray_delete.restype = None
    api.tiepie_hw_pointerarray_delete.argtypes = [c_void_p]

    return api


api = load_libtiepie()
