# python-licverify

Python client for [go-license](https://github.com/luhtfiimanal/go-license) license verification.

`python-licverify` allows you to verify `.lic` files generated by the `licforge` CLI or Go library **entirely from Python**, including:

* RSA-SHA256 signature validation
* Hardware binding checks (MAC address, disk ID, hostname)
* Expiry validation
* Simple CLI utility

## Installation

```bash
pip install python-licverify  # or uv pip install python-licverify
```

> Depend on `cryptography` and `psutil`. Wheels are provided for Python 3.12+, no extra build tools required.

## Usage

### Library API

```python
from licverify import Verifier

PUBLIC_KEY_PEM = open("public.pem").read()
verifier = Verifier(PUBLIC_KEY_PEM)

license = verifier.load_license("license.lic")

try:
    license.verify(verifier)  # raises on failure
except Exception as exc:
    print(f"License invalid: {exc}")
else:
    print("License is valid!")
```

### Command-line

After installation a `licverify` command is available:

```bash
licverify --public-key public.pem --license license.lic
```

Exit status 0 ⇒ valid, status 1 ⇒ invalid.

## Examples

See [`examples/basic_usage.py`](examples/basic_usage.py).

## Development

```bash
git clone https://github.com/luhtfiimanal/python-licverify
cd python-licverify
uv sync  # install dev deps (optional)
uv run -m pip install -e .
```

Run tests (to be added soon):

```bash
pytest -q
```

## License

This project is licensed under the MIT License – see the [LICENSE](LICENSE) file for details.
