"""Manufacturers and their devices for the LinkPlay component."""

from typing import Final

from linkplay.consts import LOGGER

MANUFACTURER_ARTSOUND: Final[str] = "ArtSound"
MANUFACTURER_ARYLIC: Final[str] = "Arylic"
MANUFACTURER_IEAST: Final[str] = "iEAST"
MANUFACTURER_WIIM: Final[str] = "WiiM"
MANUFACTURER_GGMM: Final[str] = "GGMM"
MANUFACTURER_MEDION: Final[str] = "Medion"
MANUFACTURER_GENERIC: Final[str] = "Generic"
MODELS_ARTSOUND_SMART_ZONE4: Final[str] = "Smart Zone 4 AMP"
MODELS_ARTSOUND_SMART_HYDE: Final[str] = "Smart Hyde"
MODELS_ARYLIC_S50: Final[str] = "S50+"
MODELS_ARYLIC_S50_PRO: Final[str] = "S50 Pro"
MODELS_ARYLIC_A30: Final[str] = "A30"
MODELS_ARYLIC_A50: Final[str] = "A50"
MODELS_ARYLIC_A50S: Final[str] = "A50+"
MODELS_ARYLIC_UP2STREAM_AMP: Final[str] = "Up2Stream Amp 2.0"
MODELS_ARYLIC_UP2STREAM_AMP_2P1: Final[str] = "Up2Stream Amp 2.1"
MODELS_ARYLIC_UP2STREAM_AMP_V3: Final[str] = "Up2Stream Amp v3"
MODELS_ARYLIC_UP2STREAM_AMP_V4: Final[str] = "Up2Stream Amp v4"
MODELS_ARYLIC_UP2STREAM_MINI: Final[str] = "Up2Stream Mini"
MODELS_ARYLIC_UP2STREAM_PRO: Final[str] = "Up2Stream Pro v1"
MODELS_ARYLIC_UP2STREAM_PRO_V3: Final[str] = "Up2Stream Pro v3"
MODELS_ARYLIC_UP2STREAM_PRO_V4: Final[str] = "Up2Stream Pro v4"
MODELS_ARYLIC_S10P: Final[str] = "Arylic S10+"
MODELS_ARYLIC_UP2STREAM_PLATE_AMP: Final[str] = "Up2Stream Plate Amp"
MODELS_IEAST_AUDIOCAST_M5: Final[str] = "AudioCast M5"
MODELS_WIIM_AMP: Final[str] = "WiiM Amp"
MODELS_WIIM_MINI: Final[str] = "WiiM Mini"
MODELS_WIIM_PRO: Final[str] = "WiiM Pro"
MODELS_WIIM_PRO_PLUS: Final[str] = "WiiM Pro Plus"
MODELS_GGMM_GGMM_E2: Final[str] = "GGMM E2"
MODELS_MEDION_MD_43970: Final[str] = "Life P66970 (MD 43970)"
MODELS_GENERIC: Final[str] = "Generic"

PROJECTID_LOOKUP: Final[dict[str, tuple[str, str]]] = {
    "SMART_ZONE4_AMP": (MANUFACTURER_ARTSOUND, MODELS_ARTSOUND_SMART_ZONE4),
    "SMART_HYDE": (MANUFACTURER_ARTSOUND, MODELS_ARTSOUND_SMART_HYDE),
    "ARYLIC_S50": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_S50),
    "RP0016_S50PRO_S": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_S50_PRO),
    "RP0011_WB60_S": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_A30),
    "X-50": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_A50),
    "ARYLIC_A50S": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_A50S),
    "RP0011_WB60": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_UP2STREAM_AMP),
    "UP2STREAM_AMP_V3": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_UP2STREAM_AMP_V3),
    "UP2STREAM_AMP_V4": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_UP2STREAM_AMP_V4),
    "UP2STREAM_PRO_V3": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_UP2STREAM_PRO_V3),
    "UP2STREAM_PRO_V4": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_UP2STREAM_PRO_V4),
    "S10P_WIFI": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_S10P),
    "ARYLIC_V20": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_UP2STREAM_PLATE_AMP),
    "UP2STREAM_MINI_V3": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_UP2STREAM_MINI),
    "UP2STREAM_AMP_2P1": (MANUFACTURER_ARYLIC, MODELS_ARYLIC_UP2STREAM_AMP_2P1),
    "RP0014_A50C_S": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "ARYLIC_A30": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "ARYLIC_SUBWOOFER": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "ARYLIC_S50A": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "RP0010_D5_S": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "RP0001": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "RP0013_WA31S": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "RP0010_D5": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "RP0013_WA31S_S": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "RP0014_A50D_S": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "ARYLIC_A50TE": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "ARYLIC_A50N": (MANUFACTURER_ARYLIC, MODELS_GENERIC),
    "iEAST-02": (MANUFACTURER_IEAST, MODELS_IEAST_AUDIOCAST_M5),
    "WiiM_Amp_4layer": (MANUFACTURER_WIIM, MODELS_WIIM_AMP),
    "WiiM_Pro_with_gc4a": (MANUFACTURER_WIIM, MODELS_WIIM_PRO),
    "WiiM_Pro_Plus": (MANUFACTURER_WIIM, MODELS_WIIM_PRO_PLUS),
    "WiiM_AMP": (MANUFACTURER_WIIM, MODELS_WIIM_AMP),
    "Muzo_Mini": (MANUFACTURER_WIIM, MODELS_WIIM_MINI),
    "GGMM_E2A": (MANUFACTURER_GGMM, MODELS_GGMM_GGMM_E2),
    "A16": (MANUFACTURER_MEDION, MODELS_MEDION_MD_43970),
}


def get_info_from_project(project: str) -> tuple[str, str]:
    """Get manufacturer and model info based on given project."""
    #    if project not in PROJECTID_LOOKUP:
    #        LOGGER.warning(
    #            "The project name '%s' is not found in the manufacturer list. Kindly open an issue at https://github.com/velleman/python-linkplay/issues with the project name %s and mention the manufacturer of this product and the product name.",
    #            project,
    #            project,
    #        )
    return PROJECTID_LOOKUP.get(project, (MANUFACTURER_GENERIC, MODELS_GENERIC))
