# rule_categories copypaste from: https://docs.astral.sh/ruff/rules/
rule_categories = """
Pyflakes (F)
pycodestyle (E, W)
Warning (W)
Error (E)
mccabe (C90)
isort (I)
pep8-naming (N)
pydocstyle (D)
pyupgrade (UP)
flake8-2020 (YTT)
flake8-annotations (ANN)
flake8-async (ASYNC)
flake8-bandit (S)
flake8-blind-except (BLE)
flake8-boolean-trap (FBT)
flake8-bugbear (B)
flake8-builtins (A)
flake8-commas (COM)
flake8-copyright (CPY)
flake8-comprehensions (C4)
flake8-datetimez (DTZ)
flake8-debugger (T10)
flake8-django (DJ)
flake8-errmsg (EM)
flake8-executable (EXE)
flake8-future-annotations (FA)
flake8-implicit-str-concat (ISC)
flake8-import-conventions (ICN)
flake8-logging (LOG)
flake8-logging-format (G)
flake8-no-pep420 (INP)
flake8-pie (PIE)
flake8-print (T20)
flake8-pyi (PYI)
flake8-pytest-style (PT)
flake8-quotes (Q)
flake8-raise (RSE)
flake8-return (RET)
flake8-self (SLF)
flake8-slots (SLOT)
flake8-simplify (SIM)
flake8-tidy-imports (TID)
flake8-type-checking (TC)
flake8-gettext (INT)
flake8-unused-arguments (ARG)
flake8-use-pathlib (PTH)
flake8-todos (TD)
flake8-fixme (FIX)
eradicate (ERA)
pandas-vet (PD)
pygrep-hooks (PGH)
Pylint (PL)
Convention (C)
Error (E)
Refactor (R)
Warning (W)
tryceratops (TRY)
flynt (FLY)
NumPy-specific rules (NPY)
FastAPI (FAST)
Airflow (AIR)
Perflint (PERF)
refurb (FURB)
pydoclint (DOC)
Ruff-specific rules (RUF)
"""


def copypaste_this_into_ruff_tomls_select_list() -> None:
    names_code = [l.replace(")", "").split("(") for l in rule_categories.split("\n")]
    code_names = [(cn[1], cn[0]) for cn in names_code if len(cn) == 2]
    print(code_names)
    for code, name in code_names:
        print(f'"{code}",\t# {name}')


if __name__ == "__main__":
    copypaste_this_into_ruff_tomls_select_list()
