# python-listmonk
The API collection for listmonk

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:

```python
import listmonk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:

```python
import listmonk
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import listmonk
from listmonk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:9000/api
# See configuration.py for a list of all supported configuration parameters.
configuration = listmonk.Configuration(
    host="http://localhost:9000/api"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = listmonk.Configuration(
    username=os.environ["USERNAME"],
    password=os.environ["PASSWORD"]
)

# Enter a context with an instance of the API client
with listmonk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = listmonk.AdminApi(api_client)
    
    try:
        api_response = api_instance.reload_app()
        print("The response of AdminApi->reload_app:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AdminApi->reload_app: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:9000/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**reload_app**](docs/AdminApi.md#reload_app) | **POST** /admin/reload | 
*BouncesApi* | [**delete_bounce_by_id**](docs/BouncesApi.md#delete_bounce_by_id) | **DELETE** /bounces/{id} | 
*BouncesApi* | [**delete_bounces**](docs/BouncesApi.md#delete_bounces) | **DELETE** /bounces | 
*BouncesApi* | [**get_bounce_by_id**](docs/BouncesApi.md#get_bounce_by_id) | **GET** /bounces/{id} | 
*BouncesApi* | [**get_bounces**](docs/BouncesApi.md#get_bounces) | **GET** /bounces | 
*CampaignsApi* | [**create_campaign**](docs/CampaignsApi.md#create_campaign) | **POST** /campaigns | 
*CampaignsApi* | [**create_campaign_content_by_id**](docs/CampaignsApi.md#create_campaign_content_by_id) | **POST** /campaigns/{id}/content | 
*CampaignsApi* | [**delete_campaign_by_id**](docs/CampaignsApi.md#delete_campaign_by_id) | **DELETE** /campaigns/{id} | 
*CampaignsApi* | [**get_campaign_analytics**](docs/CampaignsApi.md#get_campaign_analytics) | **GET** /campaigns/analytics/{type} | 
*CampaignsApi* | [**get_campaign_by_id**](docs/CampaignsApi.md#get_campaign_by_id) | **GET** /campaigns/{id} | 
*CampaignsApi* | [**get_campaigns**](docs/CampaignsApi.md#get_campaigns) | **GET** /campaigns | 
*CampaignsApi* | [**get_running_campaign_stats**](docs/CampaignsApi.md#get_running_campaign_stats) | **GET** /campaigns/running/stats | 
*CampaignsApi* | [**preview_campaign_by_id**](docs/CampaignsApi.md#preview_campaign_by_id) | **GET** /campaigns/{id}/preview | 
*CampaignsApi* | [**preview_campaign_text_by_id**](docs/CampaignsApi.md#preview_campaign_text_by_id) | **POST** /campaigns/{id}/text | 
*CampaignsApi* | [**test_campaign_by_id**](docs/CampaignsApi.md#test_campaign_by_id) | **POST** /campaigns/{id}/test | 
*CampaignsApi* | [**update_campaign_archive_by_id**](docs/CampaignsApi.md#update_campaign_archive_by_id) | **PUT** /campaigns/{id}/archive | 
*CampaignsApi* | [**update_campaign_by_id**](docs/CampaignsApi.md#update_campaign_by_id) | **PUT** /campaigns/{id} | 
*CampaignsApi* | [**update_campaign_status_by_id**](docs/CampaignsApi.md#update_campaign_status_by_id) | **PUT** /campaigns/{id}/status | 
*CampaignsApi* | [**update_preview_campaign_by_id**](docs/CampaignsApi.md#update_preview_campaign_by_id) | **POST** /campaigns/{id}/preview | 
*ImportApi* | [**get_import_subscriber_stats**](docs/ImportApi.md#get_import_subscriber_stats) | **GET** /import/subscribers/logs | 
*ImportApi* | [**get_import_subscribers**](docs/ImportApi.md#get_import_subscribers) | **GET** /import/subscribers | 
*ImportApi* | [**import_subscribers**](docs/ImportApi.md#import_subscribers) | **POST** /import/subscribers | 
*ImportApi* | [**stop_import_subscribers**](docs/ImportApi.md#stop_import_subscribers) | **DELETE** /import/subscribers | 
*ListsApi* | [**create_list**](docs/ListsApi.md#create_list) | **POST** /lists | 
*ListsApi* | [**delete_list_by_id**](docs/ListsApi.md#delete_list_by_id) | **DELETE** /lists/{list_id} | 
*ListsApi* | [**get_list_by_id**](docs/ListsApi.md#get_list_by_id) | **GET** /lists/{list_id} | 
*ListsApi* | [**get_lists**](docs/ListsApi.md#get_lists) | **GET** /lists | 
*ListsApi* | [**update_list_by_id**](docs/ListsApi.md#update_list_by_id) | **PUT** /lists/{list_id} | 
*LogsApi* | [**get_logs**](docs/LogsApi.md#get_logs) | **GET** /logs | 
*MaintenanceApi* | [**delete_campaign_analytics_by_type**](docs/MaintenanceApi.md#delete_campaign_analytics_by_type) | **DELETE** /maintenance/analytics/{type} | 
*MaintenanceApi* | [**delete_gc_subscribers**](docs/MaintenanceApi.md#delete_gc_subscribers) | **DELETE** /maintenance/subscribers/{type} | 
*MaintenanceApi* | [**delete_unconfirmed_subscriptions**](docs/MaintenanceApi.md#delete_unconfirmed_subscriptions) | **DELETE** /maintenance/subscriptions/unconfirmed | 
*MediaApi* | [**delete_media_by_id**](docs/MediaApi.md#delete_media_by_id) | **DELETE** /media/{id} | 
*MediaApi* | [**get_media**](docs/MediaApi.md#get_media) | **GET** /media | 
*MediaApi* | [**get_media_by_id**](docs/MediaApi.md#get_media_by_id) | **GET** /media/{id} | 
*MediaApi* | [**upload_media**](docs/MediaApi.md#upload_media) | **POST** /media | 
*MiscellaneousApi* | [**get_dashboard_charts**](docs/MiscellaneousApi.md#get_dashboard_charts) | **GET** /dashboard/charts | 
*MiscellaneousApi* | [**get_dashboard_counts**](docs/MiscellaneousApi.md#get_dashboard_counts) | **GET** /dashboard/counts | 
*MiscellaneousApi* | [**get_health_check**](docs/MiscellaneousApi.md#get_health_check) | **GET** /health | 
*MiscellaneousApi* | [**get_i18n_lang**](docs/MiscellaneousApi.md#get_i18n_lang) | **GET** /lang/{lang} | 
*MiscellaneousApi* | [**get_server_config**](docs/MiscellaneousApi.md#get_server_config) | **GET** /config | 
*PublicApi* | [**get_public_lists**](docs/PublicApi.md#get_public_lists) | **GET** /public/lists | 
*PublicApi* | [**handle_public_subscription**](docs/PublicApi.md#handle_public_subscription) | **POST** /public/subscription | 
*SettingsApi* | [**get_settings**](docs/SettingsApi.md#get_settings) | **GET** /settings | 
*SettingsApi* | [**test_smtp_settings**](docs/SettingsApi.md#test_smtp_settings) | **POST** /settings/smtp/test | 
*SettingsApi* | [**update_settings**](docs/SettingsApi.md#update_settings) | **PUT** /settings | 
*SubscribersApi* | [**blocklist_subscribers_query**](docs/SubscribersApi.md#blocklist_subscribers_query) | **PUT** /subscribers/query/blocklist | 
*SubscribersApi* | [**create_subscriber**](docs/SubscribersApi.md#create_subscriber) | **POST** /subscribers | 
*SubscribersApi* | [**delete_subscriber_bounces_by_id**](docs/SubscribersApi.md#delete_subscriber_bounces_by_id) | **DELETE** /subscribers/{id}/bounces | 
*SubscribersApi* | [**delete_subscriber_by_id**](docs/SubscribersApi.md#delete_subscriber_by_id) | **DELETE** /subscribers/{id} | 
*SubscribersApi* | [**delete_subscriber_by_list**](docs/SubscribersApi.md#delete_subscriber_by_list) | **DELETE** /subscribers | 
*SubscribersApi* | [**delete_subscriber_by_query**](docs/SubscribersApi.md#delete_subscriber_by_query) | **POST** /subscribers/query/delete | 
*SubscribersApi* | [**export_subscriber_data_by_id**](docs/SubscribersApi.md#export_subscriber_data_by_id) | **GET** /subscribers/{id}/export | 
*SubscribersApi* | [**get_subscriber_bounces_by_id**](docs/SubscribersApi.md#get_subscriber_bounces_by_id) | **GET** /subscribers/{id}/bounces | 
*SubscribersApi* | [**get_subscriber_by_id**](docs/SubscribersApi.md#get_subscriber_by_id) | **GET** /subscribers/{id} | 
*SubscribersApi* | [**get_subscribers**](docs/SubscribersApi.md#get_subscribers) | **GET** /subscribers | 
*SubscribersApi* | [**manage_blocklist_by_subscriber_list**](docs/SubscribersApi.md#manage_blocklist_by_subscriber_list) | **PUT** /subscribers/blocklist | 
*SubscribersApi* | [**manage_blocklist_subscribers_by_id**](docs/SubscribersApi.md#manage_blocklist_subscribers_by_id) | **PUT** /subscribers/{id}/blocklist | 
*SubscribersApi* | [**manage_subscriber_list_by_id**](docs/SubscribersApi.md#manage_subscriber_list_by_id) | **PUT** /subscribers/lists/{id} | 
*SubscribersApi* | [**manage_subscriber_lists**](docs/SubscribersApi.md#manage_subscriber_lists) | **PUT** /subscribers/lists | 
*SubscribersApi* | [**manage_subscriber_lists_by_query**](docs/SubscribersApi.md#manage_subscriber_lists_by_query) | **PUT** /subscribers/query/lists | 
*SubscribersApi* | [**subscriber_send_optin_by_id**](docs/SubscribersApi.md#subscriber_send_optin_by_id) | **POST** /subscribers/{id}/optin | 
*SubscribersApi* | [**update_subscriber_by_id**](docs/SubscribersApi.md#update_subscriber_by_id) | **PUT** /subscribers/{id} | 
*TemplatesApi* | [**delete_template_by_id**](docs/TemplatesApi.md#delete_template_by_id) | **DELETE** /templates/{id} | 
*TemplatesApi* | [**get_template_by_id**](docs/TemplatesApi.md#get_template_by_id) | **GET** /templates/{id} | 
*TemplatesApi* | [**get_templates**](docs/TemplatesApi.md#get_templates) | **GET** /templates | 
*TemplatesApi* | [**preview_template**](docs/TemplatesApi.md#preview_template) | **POST** /templates/preview | 
*TemplatesApi* | [**preview_template_by_id**](docs/TemplatesApi.md#preview_template_by_id) | **GET** /templates/{id}/preview | 
*TemplatesApi* | [**update_template_by_id**](docs/TemplatesApi.md#update_template_by_id) | **PUT** /templates/{id}/default | 
*TransactionalApi* | [**transact_with_subscriber**](docs/TransactionalApi.md#transact_with_subscriber) | **POST** /tx | 


## Documentation For Models

 - [Bounce](docs/Bounce.md)
 - [BounceResultsInner](docs/BounceResultsInner.md)
 - [BounceResultsInnerCampaign](docs/BounceResultsInnerCampaign.md)
 - [Campaign](docs/Campaign.md)
 - [CampaignAnalyticsCount](docs/CampaignAnalyticsCount.md)
 - [CampaignContentRequest](docs/CampaignContentRequest.md)
 - [CampaignRequest](docs/CampaignRequest.md)
 - [CampaignRequestSendAt](docs/CampaignRequestSendAt.md)
 - [CampaignStats](docs/CampaignStats.md)
 - [CampaignUpdate](docs/CampaignUpdate.md)
 - [CreateCampaign200Response](docs/CreateCampaign200Response.md)
 - [CreateList200Response](docs/CreateList200Response.md)
 - [CreateSubscriber200Response](docs/CreateSubscriber200Response.md)
 - [DashboardChart](docs/DashboardChart.md)
 - [DashboardChartLinkClicksInner](docs/DashboardChartLinkClicksInner.md)
 - [DashboardCount](docs/DashboardCount.md)
 - [DashboardCountData](docs/DashboardCountData.md)
 - [DashboardCountDataCampaigns](docs/DashboardCountDataCampaigns.md)
 - [DashboardCountDataCampaignsByStatus](docs/DashboardCountDataCampaignsByStatus.md)
 - [DashboardCountDataLists](docs/DashboardCountDataLists.md)
 - [DashboardCountDataSubscribers](docs/DashboardCountDataSubscribers.md)
 - [DeleteGCSubscribers200Response](docs/DeleteGCSubscribers200Response.md)
 - [DeleteGCSubscribers200ResponseData](docs/DeleteGCSubscribers200ResponseData.md)
 - [GetBounceById200Response](docs/GetBounceById200Response.md)
 - [GetBounces200Response](docs/GetBounces200Response.md)
 - [GetBounces200ResponseData](docs/GetBounces200ResponseData.md)
 - [GetCampaignAnalytics200Response](docs/GetCampaignAnalytics200Response.md)
 - [GetCampaignById200Response](docs/GetCampaignById200Response.md)
 - [GetCampaigns200Response](docs/GetCampaigns200Response.md)
 - [GetCampaigns200ResponseData](docs/GetCampaigns200ResponseData.md)
 - [GetDashboardCharts200Response](docs/GetDashboardCharts200Response.md)
 - [GetDashboardCounts200Response](docs/GetDashboardCounts200Response.md)
 - [GetHealthCheck200Response](docs/GetHealthCheck200Response.md)
 - [GetI18nLang200Response](docs/GetI18nLang200Response.md)
 - [GetImportSubscriberStats200Response](docs/GetImportSubscriberStats200Response.md)
 - [GetImportSubscribers200Response](docs/GetImportSubscribers200Response.md)
 - [GetLists200Response](docs/GetLists200Response.md)
 - [GetLists200ResponseData](docs/GetLists200ResponseData.md)
 - [GetLogs200Response](docs/GetLogs200Response.md)
 - [GetMedia200Response](docs/GetMedia200Response.md)
 - [GetPublicLists200ResponseInner](docs/GetPublicLists200ResponseInner.md)
 - [GetRunningCampaignStats200Response](docs/GetRunningCampaignStats200Response.md)
 - [GetServerConfig200Response](docs/GetServerConfig200Response.md)
 - [GetSettings200Response](docs/GetSettings200Response.md)
 - [GetSubscriberBouncesById200Response](docs/GetSubscriberBouncesById200Response.md)
 - [GetSubscribers200Response](docs/GetSubscribers200Response.md)
 - [GetSubscribers200ResponseData](docs/GetSubscribers200ResponseData.md)
 - [GetTemplateById200Response](docs/GetTemplateById200Response.md)
 - [GetTemplates200Response](docs/GetTemplates200Response.md)
 - [HandlePublicSubscription200Response](docs/HandlePublicSubscription200Response.md)
 - [HandlePublicSubscriptionRequest](docs/HandlePublicSubscriptionRequest.md)
 - [ImportStatus](docs/ImportStatus.md)
 - [ImportStatusData](docs/ImportStatusData.md)
 - [ImportSubscribersRequest](docs/ImportSubscribersRequest.md)
 - [LanguagePack](docs/LanguagePack.md)
 - [LanguagePackData](docs/LanguagePackData.md)
 - [List](docs/List.md)
 - [MailBoxBounces](docs/MailBoxBounces.md)
 - [MediaFileObject](docs/MediaFileObject.md)
 - [NewList](docs/NewList.md)
 - [NewSubscriber](docs/NewSubscriber.md)
 - [NewSubscriberAttribs](docs/NewSubscriberAttribs.md)
 - [NewSubscriberAttribsStack](docs/NewSubscriberAttribsStack.md)
 - [SMTPSettings](docs/SMTPSettings.md)
 - [SMTPTest](docs/SMTPTest.md)
 - [ServerConfig](docs/ServerConfig.md)
 - [ServerConfigData](docs/ServerConfigData.md)
 - [ServerConfigDataLangsInner](docs/ServerConfigDataLangsInner.md)
 - [Settings](docs/Settings.md)
 - [Subscriber](docs/Subscriber.md)
 - [SubscriberData](docs/SubscriberData.md)
 - [SubscriberListsInner](docs/SubscriberListsInner.md)
 - [SubscriberProfile](docs/SubscriberProfile.md)
 - [SubscriberProfileAttribs](docs/SubscriberProfileAttribs.md)
 - [SubscriberQueryRequest](docs/SubscriberQueryRequest.md)
 - [Subscriptions](docs/Subscriptions.md)
 - [Template](docs/Template.md)
 - [TransactionalMessage](docs/TransactionalMessage.md)
 - [UpdateCampaignArchiveByIdRequest](docs/UpdateCampaignArchiveByIdRequest.md)
 - [UpdateCampaignStatusByIdRequest](docs/UpdateCampaignStatusByIdRequest.md)
 - [UpdateSubscriber](docs/UpdateSubscriber.md)
 - [UploadMedia200Response](docs/UploadMedia200Response.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="basicAuth"></a>
### basicAuth

- **Type**: HTTP basic authentication


## Author




