# coding: utf-8

"""
    Listmonk

    The API collection for listmonk

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictInt, StrictStr
from listmonk.models.bounce_results_inner_campaign import BounceResultsInnerCampaign
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class BounceResultsInner(BaseModel):
    """
    BounceResultsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    type: Optional[StrictStr] = None
    source: Optional[StrictStr] = None
    meta: Optional[Union[str, Any]] = None
    created_at: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    subscriber_uuid: Optional[StrictStr] = None
    subscriber_id: Optional[StrictInt] = None
    campaign: Optional[BounceResultsInnerCampaign] = None
    campaign_uuid: Optional[StrictStr] = None
    total: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["id", "type", "source", "meta", "created_at", "email", "subscriber_uuid", "subscriber_id", "campaign", "campaign_uuid", "total"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of BounceResultsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of campaign
        if self.campaign:
            _dict['campaign'] = self.campaign.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of BounceResultsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "source": obj.get("source"),
            "meta": obj.get("meta"),
            "created_at": obj.get("created_at"),
            "email": obj.get("email"),
            "subscriber_uuid": obj.get("subscriber_uuid"),
            "subscriber_id": obj.get("subscriber_id"),
            "campaign": BounceResultsInnerCampaign.from_dict(obj.get("campaign")) if obj.get("campaign") is not None else None,
            "campaign_uuid": obj.get("campaign_uuid"),
            "total": obj.get("total")
        })
        return _obj


