# coding: utf-8

"""
    Listmonk

    The API collection for listmonk

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr, field_validator
from pydantic import Field
from listmonk.models.bounce_results_inner_campaign import BounceResultsInnerCampaign
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CampaignContentRequest(BaseModel):
    """
    CampaignContentRequest
    """ # noqa: E501
    id: Optional[StrictInt] = None
    created_at: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    campaign_id: Optional[StrictInt] = Field(default=None, alias="CampaignID")
    views: Optional[StrictInt] = None
    clicks: Optional[StrictInt] = None
    lists: Optional[List[BounceResultsInnerCampaign]] = None
    started_at: Optional[StrictStr] = None
    to_send: Optional[StrictInt] = None
    sent: Optional[StrictInt] = None
    uuid: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    subject: Optional[StrictStr] = None
    from_email: Optional[StrictStr] = None
    body: Optional[StrictStr] = None
    send_at: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    content_type: Optional[StrictStr] = None
    tags: Optional[List[StrictStr]] = None
    template_id: Optional[StrictInt] = None
    messenger: Optional[StrictStr] = None
    var_from: Optional[StrictStr] = Field(default=None, alias="from")
    to: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "created_at", "updated_at", "CampaignID", "views", "clicks", "lists", "started_at", "to_send", "sent", "uuid", "type", "name", "subject", "from_email", "body", "send_at", "status", "content_type", "tags", "template_id", "messenger", "from", "to"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('regular', 'optin'):
            raise ValueError("must be one of enum values ('regular', 'optin')")
        return value

    @field_validator('content_type')
    def content_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('richtext', 'html', 'markdown', 'plain'):
            raise ValueError("must be one of enum values ('richtext', 'html', 'markdown', 'plain')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CampaignContentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in lists (list)
        _items = []
        if self.lists:
            for _item in self.lists:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lists'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CampaignContentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "CampaignID": obj.get("CampaignID"),
            "views": obj.get("views"),
            "clicks": obj.get("clicks"),
            "lists": [BounceResultsInnerCampaign.from_dict(_item) for _item in obj.get("lists")] if obj.get("lists") is not None else None,
            "started_at": obj.get("started_at"),
            "to_send": obj.get("to_send"),
            "sent": obj.get("sent"),
            "uuid": obj.get("uuid"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "subject": obj.get("subject"),
            "from_email": obj.get("from_email"),
            "body": obj.get("body"),
            "send_at": obj.get("send_at"),
            "status": obj.get("status"),
            "content_type": obj.get("content_type"),
            "tags": obj.get("tags"),
            "template_id": obj.get("template_id"),
            "messenger": obj.get("messenger"),
            "from": obj.get("from"),
            "to": obj.get("to")
        })
        return _obj


